<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$months = __('months', true);
	$short_months = __('short_months', true);
	ksort($months);
	ksort($short_months);
	$days = __('days', true);
	$short_days = __('short_days', true);
	?>
			
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionCreate" method="post" id="frmCreateListing" class="form pj-form">
		<input type="hidden" name="listing_create" value="1" />
		<?php pjUtil::printNotice(__('lblListingAddTitle', true), __('lblListingAddDesc', true)); ?>
		<p>
			<label class="title"><?php __('lblListingRefid'); ?></label>
			<span class="inline_block">
				<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w185 required" value="<?php echo pjUtil::uuid(); ?>" data-msg-required="<?php __('pj_field_required');?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblListingType'); ?></label>
			<span class="inline_block">
				<select name="type_id" id="type_id" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['type_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<?php
		if (!$controller->isOwner())
		{
			?>
			<p>
				<label class="title"><?php __('lblListingStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach (__('publish_status', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
						}
						?>
					</select>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingStatusTip'); ?>"></a>
				</span>
			</p>
			<p id="expiration_container" style="display:none;">
				<label class="title"><?php __('lblListingExpire'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="expire" id="expire" class="pj-form-field pointer w80 required datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo date($tpl['option_arr']['o_date_format']); ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>" data-msg-required="<?php __('pj_field_required');?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingExpireTip'); ?>"></a>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblListingFeatured'); ?></label>
				<span class="left">
				<?php
				foreach (__('_yesno', true) as $k => $v)
				{
					?>
					<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo 'F' == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
					<?php
				}
				?>
				</span>
			</p>
			<p style="overflow: visible">
				<label class="title"><?php __('lblListingOwner'); ?></label>
				<span class="inline_block">
					<select name="owner_id" id="owner_id" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['user_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<?php
		}
		?>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
		</p>
	</form>
	<script type="text/javascript">	
	var myLabel = myLabel || {};
	myLabel.vr_duplicate_ref_id = "<?php __('vr_duplicate_ref_id'); ?>";
	</script>
	<?php
}
?>