<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	
	<?php pjUtil::printNotice(__('infoListingsTitle', true), __('infoListingsDesc', true)); ?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminListings" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddProperty'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter = __('filter', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $filter['active']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php __('vr_hidden'); ?></a>
			<a href="#" class="pj-button btn-filter btn-featured" data-column="is_featured" data-value="T"><?php echo $filter['featured']; ?></a>
			<a href="#" class="pj-button btn-filter btn-expired" data-column="status" data-value="ED"><?php echo $filter['expired']; ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="float_left w350">
				<p>
					<label class="title"><?php __('lblListingRefid'); ?></label>
					<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w150" />
				</p>
				<?php
				if ($controller->isAdmin() && $tpl['option_arr']['o_allow_add_property'] == 'No')
				{
					?>
					<p style="overflow: visible;">
						<label class="title"><?php __('lblListingOwner'); ?></label>
						<select name="user_id" id="user_id" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['user_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['user_id']) && (int) $_GET['user_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
							}
							?>
						</select>
					</p>
					<?php
				}
				?>
				<p>
					<label class="title"><?php __('lblListingAdults'); ?></label>
					<input type="text" name="adults_from" class="pj-form-field w50 digits spin" readonly="readonly" />
					<input type="text" name="adults_to" class="pj-form-field w50 digits spin" readonly="readonly" />
				</p>
				<p>
					<label class="title"><?php __('lblListingChildren'); ?></label>
					<input type="text" name="children_from" class="pj-form-field w50 digits spin" readonly="readonly" />
					<input type="text" name="children_to" class="pj-form-field w50 digits spin" readonly="readonly" />
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
					<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
				</p>
			</div>
			<div class="float_right w350">
				<p>
					<label class="title"><?php __('lblListingType'); ?></label>
					<select name="type_id" id="type_id" class="pj-form-field w150">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['type_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['type_id']) && (int) $_GET['type_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</p>
				<p>
					<label class="title"><?php __('lblListingBedrooms'); ?></label>
					<input type="text" name="bedrooms_from" class="pj-form-field w50 digits spin" readonly="readonly" />
					<input type="text" name="bedrooms_to" class="pj-form-field w50 digits spin" readonly="readonly" />
				</p>
				<p>
					<label class="title"><?php __('lblListingBathrooms'); ?></label>
					<input type="text" name="bathrooms_from" class="pj-form-field w50 digits spin" readonly="readonly" />
					<input type="text" name="bathrooms_to" class="pj-form-field w50 digits spin" readonly="readonly" />
				</p>
				<p>
					<label class="title"><?php __('lblListingFloorArea'); ?></label>
					<input type="text" name="floor_area_from" class="pj-form-field w50 number spin" readonly="readonly" />
					<input type="text" name="floor_area_to" class="pj-form-field w50 number spin" readonly="readonly" />
				</p>
			</div>
			<br class="clear_both" />
		</form>
	</div>
	
	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.queryString = "";
	pjGrid.isOwner = <?php echo $controller->isOwner() ? 'true' : 'false'; ?>;
	<?php
	if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
	{
		?>pjGrid.queryString += "&user_id=<?php echo (int) $_GET['user_id']; ?>";<?php
	}
	if (isset($_GET['is_featured']) && $_GET['is_featured'] != '')
	{
		?>pjGrid.queryString += "&is_featured=<?php echo $_GET['is_featured']; ?>";<?php
	}
	if (isset($_GET['status']) && $_GET['status'] != '')
	{
		?>pjGrid.queryString += "&status=<?php echo $_GET['status']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.exp_date_plus_30 = "<?php echo pjSanitize::clean(__('vr_exp_date_plus_30', true)); ?>";
	myLabel.view_reservations = "<?php echo pjSanitize::clean(__('vr_view_reservations', true)); ?>";
	myLabel.image = "<?php echo pjSanitize::clean(__('vr_image', true)); ?>";
	myLabel.ref_id = "<?php echo pjSanitize::clean(__('vr_ref_id', true)); ?>";
	myLabel.owner = "<?php echo pjSanitize::clean(__('vr_owner', true)); ?>";
	myLabel.expire = "<?php echo pjSanitize::clean(__('vr_expire', true)); ?>";
	myLabel.publish = "<?php echo pjSanitize::clean(__('vr_publish', true)); ?>";
	myLabel.active = "<?php echo pjSanitize::clean(__('vr_active', true)); ?>";
	myLabel.inactive = "<?php echo pjSanitize::clean(__('vr_inactive', true)); ?>";
	myLabel.hidden = "<?php echo pjSanitize::clean(__('vr_hidden', true)); ?>";
	myLabel.exp_date = "<?php echo pjSanitize::clean(__('vr_exp_date', true)); ?>";
	myLabel.delete_selected = "<?php echo pjSanitize::clean(__('vr_delete_selected', true)); ?>";
	myLabel.published = "<?php echo pjSanitize::clean(__('vr_published', true)); ?>";
	myLabel.latest_reservation = "<?php echo pjSanitize::clean(__('lblLatestReservation', true)); ?>";
	myLabel.reservations = "<?php echo pjSanitize::clean(__('lblReservations', true)); ?>";
	myLabel.on = "<?php echo pjSanitize::clean(__('lblOn', true)); ?>";
	myLabel.not_published = "<?php echo pjSanitize::clean(__('vr_not_published', true)); ?>";
	myLabel.extend_exp_date = "<?php echo pjSanitize::clean(__('vr_extend_exp_date', true)); ?>";
	myLabel.delete_confirm = "<?php echo pjSanitize::clean(__('vr_delete_confirm', true)); ?>";
	</script>
	<?php
}
?>