<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$months = __('months', true);
	$short_months = __('short_months', true);
	ksort($months);
	ksort($short_months);
	$days = __('days', true);
	$short_days = __('short_days', true);
	?>
	<style type="text/css">
	/*.ui-widget-content{
		border: medium none;
	}
	.ui-tabs .ui-tabs-nav li a {
		padding: 0.5em 0.8em;
	}*/
	.mceEditor > table{
		width: 570px !important;
	}
	.ui-menu{
		height: 230px;
		overflow-y: scroll;
	}
	.ui-tabs .ui-tabs-panel{
		overflow: visible;
	}
	</style>
	<div class="vrPropertyTitle">
		<?php
		$locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : NULL;
		if (is_null($locale))
		{
			foreach ($tpl['lp_arr'] as $v)
			{
				if ($v['is_default'] == 1)
				{
					$locale = $v['id'];
					break;
				}
			}
		}
		if (is_null($locale))
		{
			$locale = @$tpl['lp_arr'][0]['id'];
		}
		
		$title_arr = array();
		if(!empty($tpl['arr']['i18n'][$locale]['title']))
		{
			$title_arr[] = $tpl['arr']['i18n'][$locale]['title'];
		}
		if(!empty($tpl['arr']['listing_refid']))
		{
			$title_arr[] = $tpl['arr']['listing_refid'];
		}
		echo __('lblProperty', true) . ': ' . join(" / ", $title_arr); 
		?>
	</div>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate" method="post" id="frmUpdateListing" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="listing_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />

		<div id="tabs">
		
			<ul>
				<li><a href="#tabs-1"><?php __('lblListingSummary'); ?></a></li>
				<li><a href="#tabs-2"><?php __('lblListingDetails'); ?></a></li>
				<li><a href="#tabs-3"><?php __('lblListingExtras'); ?></a></li>
				<li><a href="#tabs-4"><?php __('lblListingPhotos'); ?></a></li>
				<li><a href="#tabs-5"><?php __('lblListingContact'); ?></a></li>
				<li><a href="#tabs-6"><?php __('lblListingAddress'); ?></a></li>
				<li><a href="#tabs-7"><?php __('lblListingPrices'); ?></a></li>
				<li><a href="#tabs-8"><?php __('lblListingBooking'); ?></a></li>
				<li><a href="#tabs-9"><?php __('lblListingTerms'); ?></a></li>
				<li><a href="#tabs-10"><?php __('lblListingEmails'); ?></a></li>
				<li><a href="#tabs-11"><?php __('lblListingSeo'); ?></a></li>
			</ul>
		
			<div id="tabs-1">
					
				<p><label class="title"><?php __('lblListingCreated'); ?></label><span class="left"><?php echo date("D, jS F Y, H:i:s A", strtotime($tpl['arr']['created'])); ?></span></p>
				<p><label class="title"><?php __('lblListingModified'); ?></label><span class="left"><?php echo !empty($tpl['arr']['modified']) ? date("D, jS F Y, H:i:s A", strtotime($tpl['arr']['modified'])) : __('lblNotYet'); ?></span></p>
				<p><label class="title"><?php __('lblListingViews'); ?></label><span class="left"><?php echo $tpl['arr']['views']; ?></span></p>
				<p><label class="title"><?php __('menuReservations'); ?></label><span class="left"><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&amp;action=pjActionIndex&amp;listing_id=<?php echo $tpl['arr']['id']; ?>"><?php echo (int) $tpl['arr']['reservations']; ?></a></span></p>
				<p>
					<label class="title"><?php __('lblListingRefid'); ?></label>
					<span class="inline_block">
						<input type="text" name="listing_refid" id="listing_refid" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_refid'])); ?>" class="pj-form-field w185 required" data-msg-required="<?php __('pj_field_required');?>"/>
					</span>
				</p>
				<?php
				if (!$controller->isOwner())
				{
					?>
					<p><label class="title"><?php __('lblListingStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach (__('publish_status', true) as $k => $v)
								{
									if ($tpl['arr']['status'] == $k)
									{
										?><option value="<?php echo $k; ?>" selected="selected"><?php echo stripslashes($v); ?></option><?php
									} else {
										?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
									}
								}
								?>
							</select>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingStatusTip'); ?>"></a>
						</span>
					</p>
					<p id="expiration_container" style="display:<?php echo $tpl['arr']['status'] == 'E' ? 'block' : 'none';?>;">
						<label class="title"><?php __('lblListingExpire'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="expire" id="expire" class="pj-form-field pointer w80 required datepick" data-msg-required="<?php __('pj_field_required');?>" value="<?php echo pjUtil::formatDate($tpl['arr']['expire'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingExpireTip'); ?>"></a>
					</p>
					<?php
				} else {
					?>
					<p>
						<label class="title"><?php __('lblListingExpire'); ?></label>
						<span class="left float_left"><?php echo date("D, jS F Y", strtotime($tpl['arr']['expire'])); ?></span>
						<a class="pj-button float_left l10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionPayment&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblListingExtend'); ?></a>
					</p>
					<?php
				}
				if (!$controller->isOwner())
				{
					?>
					<p>
						<label class="title"><?php __('lblListingFeatured'); ?></label>
						<span class="left">
						<?php
						foreach (__('_yesno', true) as $k => $v)
						{
							?>
							<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo $tpl['arr']['is_featured'] == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
							<?php
						}
						?>
						</span>
					</p>
					<?php
				}
				if ($controller->isAdmin())
				{
					?>
					<p style="overflow: visible">
						<label class="title"><?php __('lblListingOwner'); ?></label>
						<select name="owner_id" id="owner_id" class="pj-form-field required w200" data-msg-required="<?php __('pj_field_required');?>">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['user_arr'] as $val) {
								?>
								<option value="<?php echo $val['id'];?>" <?php echo $tpl['arr']['owner_id'] == $val['id'] ? 'selected="selected"' : '';?> ><?php echo $val['name'];?></option>
								<?php
							}
							?>
						</select>
					<?php
				}
				?>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div>
		
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoListingDetailsTitle', true), __('infoListingDetailsDesc', true)); ?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10 first_multilang"></div>
				<?php endif; ?>
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblListingType'); ?></label>
						<span class="inline_block" id="boxType">
							<select name="type_id" id="type_id" class="pj-form-field required" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach ($tpl['type_arr'] as $v)
								{
									if ($tpl['arr']['type_id'] == $v['id'])
									{
										?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo stripslashes($v['name']); ?></option><?php
									} else {
										?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
									}
								}
								?>
							</select>
						</span>
					</p>
				<?php
				foreach ($tpl['lp_arr'] as $v)
				{
					?>
					<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<label class="title"><?php __('lblListingTitle'); ?></label>
						<span class="inline_block">
							<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w500<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" data-msg-required="<?php __('pj_field_required');?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" />
							<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
							<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							<?php endif; ?>
						</span>
					</p>
					<?php
				}
				?>
				<p>
					<label class="title"><?php __('lblListingBedrooms'); ?></label>
					<input type="text" name="listing_bedrooms" id="listing_bedrooms" value="<?php echo intval($tpl['arr']['listing_bedrooms']); ?>" class="pj-form-field w80 digits" />
				</p>
				<p><label class="title"><?php __('lblListingBathrooms'); ?></label><input type="text" name="listing_bathrooms" id="listing_bathrooms" value="<?php echo round($tpl['arr']['listing_bathrooms'], 1); ?>" class="pj-form-field w80 digits" /></p>
				<p><label class="title"><?php __('lblListingAdults'); ?></label><input type="text" name="listing_adults" id="listing_adults" value="<?php echo intval($tpl['arr']['listing_adults']); ?>" class="pj-form-field w80 digits" /></p>
				<p><label class="title"><?php __('lblListingChildren'); ?></label><input type="text" name="listing_children" id="listing_children" value="<?php echo intval($tpl['arr']['listing_children']); ?>" class="pj-form-field w80 digits" /></p>
				<?php
				$floor = strtolower($tpl['option_arr']['o_floor']) == 'sq.f.' ? 'sqf' : 'sqm';
				$floor_measure = __('front_view_floor_measure', true);
				?>
				<p><label class="title"><?php __('lblListingFloorArea'); ?></label><input type="text" name="listing_floor_area" id="listing_floor_area" value="<?php echo $tpl['arr']['listing_floor_area']; ?>" class="pj-form-field w80 align_right number" /> <?php echo $floor_measure[$floor]; ?></p>
				<?php
				foreach ($tpl['lp_arr'] as $v)
				{
					?>
					<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<label class="title"><?php __('lblListingDescription'); ?></label>
						<span class="inline_block">
							<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="mceEditor" style="width: 570px; height: 400px"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['description']); ?></textarea>
							<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
							<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							<?php endif; ?>
						</span>
					</p>
					<?php
				}
				?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
					</p>
				</div>
			</div>
			
			<div id="tabs-3">
				<?php pjUtil::printNotice(__('infoListingExtrasTitle', true), __('infoListingExtrasDesc', true)); ?>
				<?php
				$eta = __('extra_type_arr', true);
				?>
				<div class="extra_header b10"><?php echo $eta['property']; ?></div>
				<?php
				$i = 1;
				foreach ($tpl['extra_arr'] as $v)
				{
					if ($v['type'] == 'property')
					{
						$is_open = true;
						?>
						<div class="float_left w200 b5 r25 pj-checkbox gradient<?php echo in_array($v['id'], $tpl['listing_extra_arr']) ? ' pj-checkbox-checked' : NULL; ?>">
							<input type="checkbox"  style="vertical-align: middle" name="extra[]" id="extra_<?php echo $v['id']; ?>" value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['listing_extra_arr']) ? ' checked="checked"' : NULL; ?> />
							<label for="extra_<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></label>
						</div>
						<?php
						if ($i % 3 === 0)
						{
							$is_open = false;
							?><div class="clear_left"></div><?php
						}
						$i++;
					}
				}
				if ($is_open) {
					?><div class="clear_left"></div><?php
				}
				?>
				<div class="extra_header t20 b10"><?php echo $eta['community']; ?></div>
				<?php
				$i = 1;
				foreach ($tpl['extra_arr'] as $v)
				{
					if ($v['type'] == 'community')
					{
						$is_open = true;
						?>
						<div class="float_left w200 b5 r25 pj-checkbox gradient<?php echo in_array($v['id'], $tpl['listing_extra_arr']) ? ' pj-checkbox-checked' : NULL; ?>">
							<input type="checkbox" name="extra[]" id="extra_<?php echo $v['id']; ?>" value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['listing_extra_arr']) ? ' checked="checked"' : NULL; ?> />
							<label for="extra_<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></label>
						</div>
						<?php
						if ($i % 3 === 0)
						{
							$is_open = false;
							?><div class="clear_left"></div><?php
						}
						$i++;
					}
				}
				if ($is_open) {
					?><div class="clear_left"></div><?php
				}
				?>
				<p>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>

			</div>
			
			<div id="tabs-4">
				<?php
				pjUtil::printNotice(@$titles['AL41'], @$bodies['AL41']);
				?>
				<div id="gallery"></div>
			</div>
				
			<?php
			include PJ_VIEWS_PATH . 'pjAdminListings/elements/contact.php';
			
			include PJ_VIEWS_PATH . 'pjAdminListings/elements/address.php';
			
			include PJ_VIEWS_PATH . 'pjAdminListings/elements/prices.php';
			
			include PJ_VIEWS_PATH . 'pjAdminListings/elements/bookings.php';
			?>
			
			<div id="tabs-9" style="padding: 10px 0">
				<?php pjUtil::printNotice(__('infoTermsTitle', true), __('infoTermsDesc', true)); ?>
				<?php
				if(!empty($tpl['others']))
				{
					?>
					<p>
						<span class="inline_block">
							<input type="button" value="<?php __('btnCopyTerms'); ?>" data-id="<?php echo $tpl['arr']['id'];?>" class="pj-button float_left r5 pjVrBtnCopyTerms"/>
							<select name="from_term_id" class="pj-form-field w300 float_left">
								<?php
								foreach($tpl['others'] as $v)
								{
									$title_arr = array();
									if(!empty($v['title']))
									{
										$title_arr[] = pjSanitize::html($v['title']);
									}
									$title_arr[] = pjSanitize::html($v['listing_refid']);
									?>
									<option value="<?php echo $v['id'];?>"><?php echo join(" / ", $title_arr);?></option>
									<?php
								} 
								?>
							</select>
						</span>
					</p>
					<?php
				} 
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif; ?>
				<div class="clear_both">
					<div class="p">
						<?php
						foreach ($tpl['lp_arr'] as $v)
						{
							?>
							<div class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
								<span class="block t5">
									<textarea name="i18n[<?php echo $v['id']; ?>][terms]" class="pj-form-field w700 h200 mceTermsEditor"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['terms']); ?></textarea>
									<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
									<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
									<?php endif; ?>
								</span>
							</div>
							<?php
						}
						
						?>
					</div>
					<p>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					</p>
				</div>
			</div>
			<div id="tabs-10" style="padding: 10px 0">
				<?php pjUtil::printNotice(__('infoEmailsTitle', true), __('infoConfirmationEmailsDesc', true), false); ?>
				<?php
				if(!empty($tpl['others']))
				{
					?>
					<p>
						<span class="inline_block">
							<input type="button" value="<?php __('btnCopyEmails'); ?>" data-id="<?php echo $tpl['arr']['id'];?>" class="pj-button float_left r5 pjVrBtnCopyEmails"/>
							<select name="from_email_id" class="pj-form-field w300 float_left">
								<?php
								foreach($tpl['others'] as $v)
								{
									$title_arr = array();
									if(!empty($v['title']))
									{
										$title_arr[] = pjSanitize::html($v['title']);
									}
									$title_arr[] = pjSanitize::html($v['listing_refid']);
									?>
									<option value="<?php echo $v['id'];?>"><?php echo join(" / ", $title_arr);?></option>
									<?php
								} 
								?>
							</select>
						</span>
					</p>
					<?php
				} 
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif; ?>
				<div class="clear_both">
					<fieldset class="fieldset white">
						<legend><?php __('lblListingConfirmEmail'); ?></legend>
						<br/>
						<div class="p">
							<label class="title"><?php __('lblSubject'); ?></label>
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
								?>
								<div class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<span class="inline-block">
										<input name="i18n[<?php echo $v['id']; ?>][confirm_subject]" class="pj-form-field w400 b10" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['confirm_subject'])); ?>"/>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</div>
								<?php
							}
							?>
						</div>
						<div class="p">
							<label class="title"><?php __('lblMessage'); ?></label>
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
								?>
								<div class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<span class="inline-block">
										<textarea name="i18n[<?php echo $v['id']; ?>][confirm_tokens]" class="pj-form-field mceEditor"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['confirm_tokens']); ?></textarea>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</div>
								<?php
							}
							?>
						</div>
						<p>
							<label class="title">&nbsp;</label>
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
							<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
						</p>
					</fieldset>
					<fieldset class="fieldset white">
						<legend><?php __('lblListingPaymentEmail'); ?></legend>
						<br/>
						<div class="p">
							<label class="title"><?php __('lblSubject'); ?></label>
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
								?>
								<div class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<span class="inline-block">
										<input name="i18n[<?php echo $v['id']; ?>][payment_subject]" class="pj-form-field w400" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['payment_subject'])); ?>"/>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</div>
								<?php
							}
							?>
						</div>
						<div class="p">
							<label class="title"><?php __('lblMessage'); ?></label>
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
								?>
								<div class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<span class="inline-block">
										<textarea name="i18n[<?php echo $v['id']; ?>][payment_tokens]" class="pj-form-field mceEditor"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['payment_tokens']); ?></textarea>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</div>
								<?php
							}
							?>
						</div>
						<p>
							<label class="title">&nbsp;</label>
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
							<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
						</p>
					</fieldset>
				</div>
			</div>
			<div id="tabs-11">
				<?php pjUtil::printNotice(__('infoListingSEOTitle', true), __('infoListingSEODesc', true)); ?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif; ?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingMetaTitle'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_title]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_title'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingMetaKeywords'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_keywords]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_keywords'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingMetaDesc'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_description]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_description'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
					</p>
				</div>
			</div>
	
		</div> <!-- #tabs -->
	</form>
	
	<div id="dialogCopyBookings" title="<?php __('lblCopyConfirmation'); ?>" style="display: none">
		<?php __('lblCopyBookingsText');?>
	</div>
	<div id="dialogCopyTerms" title="<?php __('lblCopyConfirmation'); ?>" style="display: none">
		<?php __('lblCopyTermsText');?>
	</div>
	<div id="dialogCopyEmails" title="<?php __('lblCopyConfirmation'); ?>" style="display: none">
		<?php __('lblCopyEmailsText');?>
	</div>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	var myLabel = myLabel || {};
	myLabel.address_not_found = "<?php __('vr_address_not_found'); ?>";
	myLabel.vr_duplicate_ref_id = "<?php __('vr_duplicate_ref_id'); ?>";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					$("input[name='locale']").val(ui.index);
					$.get("index.php?controller=pjAdminListings&action=pjActionGetLocale", {
						"locale" : ui.index
					}).done(function (data) {
						tid = $("#type_id").find("option:selected").val();
						$("#boxType").html(data.type);
						$("#type_id").find("option[value='"+tid+"']").prop("selected", true);
					});
				}
			});
			$(".first_multilang").find("a[data-index='<?php echo $locale; ?>']").trigger("click");
			$(".multilang").find("a[data-index='<?php echo $locale; ?>']").addClass("pj-form-langbar-item-active");
		});
	})(jQuery_1_8_2);
	</script>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>