<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionIndex"><?php __('tabReservations'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionExport"><?php __('tabExport'); ?></a></li>
		</ul>
	</div>
	<?php pjUtil::printNotice(__('infoReservationsTitle', true), __('infoReservationsDesc', true)); ?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminReservations" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button vrBtnAddReservation" value="<?php __('btnAddReservation'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter r5">
			<span class="inline_block">
				<input type="text" name="q" class="pj-form-field pj-form-field-search w100" placeholder="<?php __('btnSearch'); ?>" />
			</span>
		</form>
		<select name="listing_id" id="listing_id" class="pj-form-field w120">
			<option value="">-- <?php __('lblChoose'); ?> --</option>
			<?php
			foreach ($tpl['listing_arr'] as $item)
			{
				?><option value="<?php echo $item['id']; ?>"><?php echo stripslashes($item['listing_refid']); ?></option><?php
			}
			?>
		</select>
		<?php
		$rs = __('reservation_statuses', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-confirmed"><?php echo $rs['Confirmed']; ?></a>
			<a href="#" class="pj-button btn-pending"><?php echo $rs['Pending']; ?></a>
			<a href="#" class="pj-button btn-cancelled"><?php echo $rs['Cancelled']; ?></a>
		</div>
		<br class="clear_both" />
	</div>

	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['listing_id']) && (int) $_GET['listing_id'] > 0)
	{
		?>pjGrid.queryString += "&listing_id=<?php echo (int) $_GET['listing_id']; ?>";<?php
	}
	if (isset($_GET['status']) && $_GET['status'] != '')
	{
		?>pjGrid.queryString += "&status=<?php echo $_GET['status']; ?>";<?php
	}
	if (isset($_GET['made']) && $_GET['made'] != '')
	{
		?>pjGrid.queryString += "&made=<?php echo $_GET['made']; ?>";<?php
	}
	if (isset($_GET['upcoming']) && $_GET['upcoming'] != '')
	{
		?>pjGrid.queryString += "&upcoming=<?php echo $_GET['upcoming']; ?>";<?php
	}
	$statuses = __('reservation_statuses', true);
	?>
	var myLabel = myLabel || {};
	myLabel.uuid = "<?php echo pjSanitize::clean(__('res_uuid', true)); ?>";
	myLabel.date_from = "<?php echo pjSanitize::clean(__('res_date_from', true)); ?>";
	myLabel.date_to = "<?php echo pjSanitize::clean(__('res_date_to', true)); ?>";
	myLabel.listing = "<?php echo pjSanitize::clean(__('lblReservationListing', true)); ?>";
	myLabel.btn_continue = "<?php echo pjSanitize::clean(__('btnContinue', true)); ?>";
	myLabel.btn_cancel = "<?php echo pjSanitize::clean(__('btnCancel', true)); ?>";
	myLabel.export_selected = "<?php echo pjSanitize::clean(__('vr_export_selected', true)); ?>";
	myLabel.delete_selected = "<?php echo pjSanitize::clean(__('vr_delete_selected', true)); ?>";
	myLabel.delete_confirmation = "<?php echo pjSanitize::clean(__('vr_delete_confirmation', true)); ?>";
	myLabel.status = "<?php echo pjSanitize::clean(__('lblStatus', true)); ?>";
	myLabel.pending = "<?php echo pjSanitize::clean($statuses['Pending']); ?>";
	myLabel.confirmed = "<?php echo pjSanitize::clean($statuses['Confirmed']); ?>";
	myLabel.cancelled = "<?php echo pjSanitize::clean($statuses['Cancelled']); ?>";
	</script>
	<?php
}
?>