<div class="list-group pjVrProducts">
	<?php
	if(!empty($tpl['arr']))
	{
		$price_per = __('price_per', true);
		foreach ($tpl['arr'] as $v)
		{
			$property_title = pjSanitize::html(stripslashes($v['listing_title'] . " / " . $v['listing_refid']));
			if ($tpl['option_arr']['o_seo_url'] == 'No')
			{
				$url = $_SERVER['SCRIPT_NAME'] . '?controller=pjListings&amp;action=pjActionView'.$QS_LANG.'&amp;id=' . $v['id'] .(isset($_GET['iframe']) ? '&amp;iframe' : NULL);
			} else {
				
				$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
				$path = $path == '/' ? '' : $path;
				$url = $path .'/'. $SEO_LANG . $controller->friendlyURL($v['listing_title']) . "-". $v['id'] . ".html";
			}
			$_SESSION[$controller->defaultBackUrl] = pjUtil::getPageURL();
			
			$image = 'https://placehold.it/215x161';
			if(!empty($v['pic']))
			{
				$image = PJ_INSTALL_URL . $v['pic'];
			}
			$add_arr = array();
			if(!empty($v['address_content']))
			{
				$add_arr[] = $v['address_content'];
			}
			if(!empty($v['address_city']))
			{
				$add_arr[] = $v['address_city'];
			}
			if(!empty($v['address_state']))
			{
				$add_arr[] = $v['address_state'];
			}
			if(!empty($v['address_postcode']))
			{
				$add_arr[] = $v['address_postcode'];
			}
			if(!empty($v['country_title']))
			{
				$add_arr[] = $v['country_title'];
			}
			?>
			<a href="<?php echo $url;?>" class="list-group-item pjVrProduct">
				<h3 class="pjVrProductTitle"><?php echo $property_title; ?></h3><!-- /.pjVrProductTitle -->
				<?php
				if($v['address_map'] == 1)
				{ 
					?><div class="pjVrProductAddress"><?php echo join(", ", $add_arr);?></div><?php
				} 
				?>
				<div class="row">
					<div class="col-lg-4 col-md-4 col-sm-5 col-xs-12 pjVrProductImage">
						<div class="pjVrProductImageInner">
							<img src="<?php echo $image;?>" alt="" class="img-responsive" />
						</div><!-- /.pjVrProductImageInner -->
					</div><!-- /.col-lg-4 col-md-4 col-sm-5 col-xs-12 pjVrProductImage -->
					<div class="col-lg-8 col-md-8 col-sm-7 col-xs-12">
						<div class="row">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
								<p class="pjVrProductPrice">
									<small><?php !empty($v['price']) ? __('front_price_from') : null; ?></small>
									<strong><?php echo !empty($v['price']) ? pjUtil::formatCurrencySign(number_format($v['price'], 0), $tpl['option_arr']['o_currency']) : __('front_index_na', true); ?></strong>
									<?php
									if(!empty($v['price']))
									{
										?><small><?php echo $price_per[$v['o_price_based_on']];?></small><?php
									} 
									?>
								</p><!-- /.pjVrProductPrice -->
							</div><!-- /.col-lg-12 col-md-12 col-sm-12 col-xs-12 -->
						</div><!-- /.row -->
						<ul class="list-inline pjVrProductMeta">
							<?php
							if (!empty($v['type_title']))
							{ 
								?>
								<li>
									<dl class="dl-horizontal">
										<dt><?php __('front_index_type'); ?>: </dt>
										<dd><?php echo stripslashes($v['type_title']); ?></dd>
									</dl><!-- /.dl-horizontal -->
								</li>
								<?php
							}
							if (!empty($v['listing_floor_area']))
							{ 
								$floor = $tpl['option_arr']['o_floor'];
								?>
								<li>
									<dl class="dl-horizontal">
										<dt><?php __('front_index_floor'); ?></dt>
										<dd><?php echo pjUtil::showFloor($floor, $v['listing_floor_area'], __('front_view_floor_measure', true)); ?></dd>
									</dl><!-- /.dl-horizontal -->
								</li>
								<?php
							}
							if (!empty($v['listing_bedrooms']))
							{ 
								?>
								<li>
									<dl class="dl-horizontal">
										<dt><?php __('front_index_bedrooms'); ?></dt>
										<dd><?php echo $v['listing_bedrooms']; ?></dd>
									</dl><!-- /.dl-horizontal -->
								</li>
								<?php
							}
							if (!empty($v['listing_bathrooms']))
							{ 
								?>
								<li>
									<dl class="dl-horizontal">
										<dt><?php __('front_index_bathrooms'); ?></dt>
										<dd><?php echo $v['listing_bathrooms'] - (int) $v['listing_bathrooms'] == 0 ? round($v['listing_bathrooms'], 0) : round($v['listing_bathrooms'], 1); ?></dd>
									</dl><!-- /.dl-horizontal -->
								</li>
								<?php
							} 
							?>
						</ul><!-- /.list-inline pjVrProductMeta -->
						
						<p><?php echo pjMultibyte::substr(stripslashes(strip_tags($v['listing_description'])), 0, 350); ?>...</p>
						
						<div class="pjVrProductActions">
							<button class="btn btn-default pjVrBtn pjVrBtnPrimary"><?php __('front_button_full_details');?></button>
						</div><!-- /.pjVrProductActions -->
						
						
					</div><!-- /.col-lg-8 col-md-8 col-sm-7 col-xs-12 -->
				</div><!-- /.row -->
			</a>
			<?php
		}
	}else{
		?><p class="text-warning"><?php __('front_index_empty');?></p><?php
	}
	?>
</div><!-- /.list-group pjVrProducts -->