DROP TABLE IF EXISTS `vacationpackages_fields`;
CREATE TABLE IF NOT EXISTS `vacationpackages_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_multi_lang`;
CREATE TABLE IF NOT EXISTS `vacationpackages_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(80) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_options`;
CREATE TABLE IF NOT EXISTS `vacationpackages_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_roles`;
CREATE TABLE IF NOT EXISTS `vacationpackages_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_users`;
CREATE TABLE IF NOT EXISTS `vacationpackages_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `contact_title` enum('mr','mrs','miss','ms','dr','prof','rev','other') DEFAULT NULL,
  `contact_phone` varchar(255) DEFAULT NULL,
  `contact_mobile` varchar(255) DEFAULT NULL,
  `contact_fax` varchar(255) DEFAULT NULL,
  `contact_url` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_countries`;
CREATE TABLE IF NOT EXISTS `vacationpackages_countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_features`;
CREATE TABLE IF NOT EXISTS `vacationpackages_features` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_listings`;
CREATE TABLE IF NOT EXISTS `vacationpackages_listings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `owner_show` enum('F','T') NOT NULL DEFAULT 'T',
  `flight_included` enum('T','F') DEFAULT 'F',
  `outbound_from` varchar(255) DEFAULT NULL,
  `outbound_to` varchar(255) DEFAULT NULL,
  `outbound_departs` datetime DEFAULT NULL,
  `outbound_arrives` datetime DEFAULT NULL,
  `inbound_from` varchar(255) DEFAULT NULL,
  `inbound_to` varchar(255) DEFAULT NULL,
  `inbound_departs` datetime DEFAULT NULL,
  `inbound_arrives` datetime DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  `address_map` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `address_postcode` varchar(255) DEFAULT NULL,
  `address_content` tinytext,
  `address_city` varchar(255) DEFAULT NULL,
  `address_state` varchar(255) DEFAULT NULL,
  `listing_refid` varchar(255) DEFAULT NULL,
  `listing_rating` tinyint(1) unsigned DEFAULT NULL,
  `listing_season` varchar(255) DEFAULT NULL,
  `listing_nights` tinyint(2) DEFAULT NULL,
  `contact_show` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `expire` date DEFAULT NULL,
  `last_extend` enum('free','paid') DEFAULT 'free',
  `status` enum('T','F','E') NOT NULL DEFAULT 'F',
  `is_featured` enum('F','T') NOT NULL DEFAULT 'F',
  `added_by` enum('other','owner') NOT NULL DEFAULT 'other',
  PRIMARY KEY (`id`),
  UNIQUE KEY `listing_refid` (`listing_refid`),
  KEY `type_id` (`type_id`),
  KEY `country_id` (`country_id`),
  KEY `owner_id` (`owner_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_listings_availabilities`;
CREATE TABLE IF NOT EXISTS `vacationpackages_listings_availabilities` (
  `listing_id` int(10) unsigned NOT NULL,
  `month` tinyint(2) unsigned NOT NULL,
  PRIMARY KEY (`listing_id`,`month`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_listings_features`;
CREATE TABLE IF NOT EXISTS `vacationpackages_listings_features` (
  `listing_id` int(10) unsigned NOT NULL,
  `feature_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`listing_id`,`feature_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_prices`;
CREATE TABLE IF NOT EXISTS `vacationpackages_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL,
  `price_title` varchar(255) DEFAULT NULL,
  `price_type` enum('person','night','total') DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(15,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_enquiries`;
CREATE TABLE IF NOT EXISTS `vacationpackages_enquiries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('Confirmed','New') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_types`;
CREATE TABLE IF NOT EXISTS `vacationpackages_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_payments`;
CREATE TABLE IF NOT EXISTS `vacationpackages_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `vacationpackages_periods`;
CREATE TABLE IF NOT EXISTS `vacationpackages_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_comments`;
CREATE TABLE IF NOT EXISTS `vacationpackages_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `rating` int DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('Confirmed','New') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vacationpackages_notifications`;
CREATE TABLE IF NOT EXISTS `vacationpackages_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `vacationpackages_notifications` (`id`, `user_id`) VALUES
(1, 1);

INSERT INTO `vacationpackages_periods` (`id`, `days`, `price`) VALUES
(1, 10, 49.00),
(2, 20, 79.00),
(3, 30, 99.00),
(4, 40, 109.00),
(5, 50, 119.00);

INSERT INTO `vacationpackages_features` (`id`, `status`) VALUES
(1, 'T'),
(5, 'T'),
(7, 'T'),
(8, 'T'),
(14, 'T'),
(15, 'T'),
(21, 'T'),
(22, 'T'),
(24, 'T'),
(27, 'T'),
(28, 'T'),
(34, 'T'),
(35, 'T'),
(37, 'T'),
(38, 'T'),
(41, 'T'),
(43, 'T'),
(44, 'T'),
(46, 'T'),
(47, 'T'),
(50, 'T'),
(51, 'T'),
(53, 'T'),
(54, 'T');

INSERT INTO `vacationpackages_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnAddPeriod', 'backend', 'Button / Add Period & Price', 'script', NULL),
(7, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(8, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(9, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(10, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(11, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(12, 'btnGoogleMapsApi', 'backend', 'Button / Google Maps API', 'script', NULL),
(13, 'btnLogin', 'backend', 'Login', 'script', NULL),
(14, 'btnReset', 'backend', 'Reset', 'script', NULL),
(15, 'btnSave', 'backend', 'Save', 'script', NULL),
(16, 'btnSearch', 'backend', 'Search', 'script', NULL),
(17, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(18, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(19, 'created', 'backend', 'Created', 'script', NULL),
(20, 'email', 'backend', 'E-Mail', 'script', NULL),
(21, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(22, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(23, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(24, 'galleryAlt', 'backend', 'Gallery / ALT', 'script', NULL),
(25, 'galleryBottomCenter', 'backend', 'Gallery / Bottom Center', 'script', NULL),
(26, 'galleryBottomLeft', 'backend', 'Gallery / Bottom Left', 'script', NULL),
(27, 'galleryBottomRight', 'backend', 'Gallery / Bottom Right', 'script', NULL),
(28, 'galleryBtnCancel', 'backend', 'Gallery / Button Cancel', 'script', NULL),
(29, 'galleryBtnClearCurrent', 'backend', 'Gallery / Clear current one', 'script', NULL),
(30, 'galleryBtnCompress', 'backend', 'Gallery / Button Compress', 'script', NULL),
(31, 'galleryBtnDelete', 'backend', 'Gallery / Button Delete', 'script', NULL),
(32, 'galleryBtnRecreate', 'backend', 'Gallery / Button Recreate', 'script', NULL),
(33, 'galleryBtnSave', 'backend', 'Gallery / Button Save', 'script', NULL),
(34, 'galleryBtnSetWatermark', 'backend', 'Gallery / Set watermark', 'script', NULL),
(35, 'galleryCenterCenter', 'backend', 'Gallery / Center Center', 'script', NULL),
(36, 'galleryCenterLeft', 'backend', 'Gallery / Center Left', 'script', NULL),
(37, 'galleryCenterRight', 'backend', 'Gallery / Center Right', 'script', NULL),
(38, 'galleryCompression', 'backend', 'Gallery / Compression', 'script', NULL),
(39, 'galleryCompressionNote', 'backend', 'Gallery / Compression note', 'script', NULL),
(40, 'galleryConfirmationMulti', 'backend', 'Gallery / Delete all confirmation', 'script', NULL),
(41, 'galleryConfirmationSingle', 'backend', 'Gallery / Delete image confirmation', 'script', NULL),
(42, 'galleryDelete', 'backend', 'Gallery / Delete', 'script', NULL),
(43, 'galleryDeleteAll', 'backend', 'Gallery / Delete All', 'script', NULL),
(44, 'galleryDeleteConfirmation', 'backend', 'Gallery / Delete confirmation', 'script', NULL),
(45, 'galleryEdit', 'backend', 'Gallery / Edit', 'script', NULL),
(46, 'galleryEmptyResult', 'backend', 'Gallery / Empty result set', 'script', NULL),
(47, 'galleryImageSettings', 'backend', 'Gallery / Image settings', 'script', NULL),
(48, 'galleryMove', 'backend', 'Gallery / Move', 'script', NULL),
(49, 'galleryOriginals', 'backend', 'Gallery / Originals', 'script', NULL),
(50, 'galleryPhotos', 'backend', 'Gallery / photos', 'script', NULL),
(51, 'galleryPosition', 'backend', 'Gallery / Position', 'script', NULL),
(52, 'galleryRecreate', 'backend', 'Gallery / Recreate from original', 'script', NULL),
(53, 'galleryResize', 'backend', 'Gallery / Resize', 'script', NULL),
(54, 'galleryRotate', 'backend', 'Listing / ', 'script', NULL),
(55, 'galleryThumbs', 'backend', 'Gallery / Thumbs', 'script', NULL),
(56, 'galleryTopCenter', 'backend', 'Gallery / Top Center', 'script', NULL),
(57, 'galleryTopLeft', 'backend', 'Gallery / Top Left', 'script', NULL),
(58, 'galleryTopRight', 'backend', 'Gallery / Top Right', 'script', NULL),
(59, 'galleryUpload', 'backend', 'Gallery / Upload', 'script', NULL),
(60, 'galleryWatermark', 'backend', 'Gallery / Watermark', 'script', NULL),
(61, 'galleryWatermarkPosition', 'backend', 'Gallery / Watermark position', 'script', NULL),
(62, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(63, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(64, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(65, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(66, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(67, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(68, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(69, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(70, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(71, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(72, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(73, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(74, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(75, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(76, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(77, 'infoEmailBody', 'backend', 'Infobox / Email body', 'script', NULL),
(78, 'infoEmailTitle', 'backend', 'Infobox / Email title', 'script', NULL),
(79, 'infoFeaturesBody', 'backend', 'Infobox / Features Body', 'script', NULL),
(80, 'infoFeaturesCreateBody', 'backend', 'Infobox / Add Feature Body', 'script', NULL),
(81, 'infoFeaturesCreateTitle', 'backend', 'Infobox / Add Feature Title', 'script', NULL),
(82, 'infoFeaturesTitle', 'backend', 'Infobox / Features Title', 'script', NULL),
(83, 'infoFeaturesUpdateBody', 'backend', 'Infobox / Update Feature Body', 'script', NULL),
(84, 'infoFeaturesUpdateTitle', 'backend', 'Infobox / Update Feature Title', 'script', NULL),
(85, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(86, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(87, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(88, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(89, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(90, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(91, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(92, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(93, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(94, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(95, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(96, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(97, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(98, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(99, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(100, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(101, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(102, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(103, 'infoSubmissionsBody', 'backend', 'Infobox / Submission Body', 'script', NULL),
(104, 'infoSubmissionsTitle', 'backend', 'Infobox / Submission Title', 'script', NULL),
(105, 'infoTypesBody', 'backend', 'Infobox / Types Body', 'script', NULL),
(106, 'infoTypesCreateBody', 'backend', 'Infobox / Add Type Body', 'script', NULL),
(107, 'infoTypesCreateTitle', 'backend', 'Infobox / Add Type Title', 'script', NULL),
(108, 'infoTypesTitle', 'backend', 'Infobox / Property Types', 'script', NULL),
(109, 'infoTypesUpdateBody', 'backend', 'Infobox / Update Type Body', 'script', NULL),
(110, 'infoTypesUpdateTitle', 'backend', 'Infobox / Update Type Title', 'script', NULL),
(111, 'lblAddedOn', 'backend', 'Label / Added on', 'script', NULL),
(112, 'lblAddEnquiry', 'backend', 'Label / Add enquiry', 'script', NULL),
(113, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(114, 'lblAutumn', 'backend', 'Label / Autumn', 'script', NULL),
(115, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(116, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(117, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(118, 'lblChooseOwner', 'backend', 'Label / Choose Owner', 'script', NULL),
(119, 'lblChoosePackage', 'backend', 'Label / Choose package', 'script', NULL),
(120, 'lblCommentComment', 'backend', 'Label / Comment', 'script', NULL),
(121, 'lblCommentEmail', 'backend', 'Label / Email', 'script', NULL),
(122, 'lblCommentName', 'backend', 'Label / Name', 'script', NULL),
(123, 'lblCommentPackage', 'backend', 'Label / Package', 'script', NULL),
(124, 'lblCommentStatus', 'backend', 'Label / Status', 'script', NULL),
(125, 'lblCommentTitle', 'backend', 'Label / Title', 'script', NULL),
(126, 'lblContactEmail', 'backend', 'Label / Contact email', 'script', NULL),
(127, 'lblContactFax', 'backend', 'Label / Contact fax', 'script', NULL),
(128, 'lblContactFirstName', 'backend', 'Label / Contact first name', 'script', NULL),
(129, 'lblContactLastName', 'backend', 'Label / Contact last name', 'script', NULL),
(130, 'lblContactMobile', 'backend', 'Label / Contact mobile phone', 'script', NULL),
(131, 'lblContactPhone', 'backend', 'Label / Contact phone', 'script', NULL),
(132, 'lblContactTitle', 'backend', 'Label / Contact title', 'script', NULL),
(133, 'lblContactWebsite', 'backend', 'Label / Contact website', 'script', NULL),
(134, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(135, 'lblDays', 'backend', 'Days', 'script', NULL),
(136, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(137, 'lblEmailBody', 'backend', 'Label / Email body', 'script', NULL),
(138, 'lblEmailSubject', 'backend', 'Label / Subject', 'script', NULL),
(139, 'lblEnquiries', 'backend', 'Label / Enquiries', 'script', NULL),
(140, 'lblEnquiryEmail', 'backend', 'Label / Email', 'script', NULL),
(141, 'lblEnquiryFrom', 'backend', 'Label / From', 'script', NULL),
(142, 'lblEnquiryName', 'backend', 'Label / Name', 'script', NULL),
(143, 'lblEnquiryNotes', 'backend', 'Label / Notes', 'script', NULL),
(144, 'lblEnquiryPackage', 'backend', 'Label / Package', 'script', NULL),
(145, 'lblEnquiryPhone', 'backend', 'Label / Phone', 'script', NULL),
(146, 'lblEnquiryStatus', 'backend', 'Label / Status', 'script', NULL),
(147, 'lblEnquiryTo', 'backend', 'Label / To', 'script', NULL),
(148, 'lblError', 'backend', 'Error', 'script', NULL),
(149, 'lblExport', 'backend', 'Export', 'script', NULL),
(150, 'lblFeature', 'backend', 'Label / Feature', 'script', NULL),
(151, 'lblFlightIncluded', 'backend', 'Label / Flight included', 'script', NULL),
(152, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(153, 'lblInstallFeatured', 'backend', 'Label / Featured packages', 'script', NULL),
(154, 'lblInstallFeat_1', 'backend', 'Install / Feature step 1', 'script', NULL),
(155, 'lblInstallFeat_2', 'backend', 'Install / Feature step 2', 'script', NULL),
(156, 'lblInstallFeat_3', 'backend', 'Install / Feature step 3', 'script', NULL),
(157, 'lblInstallListing', 'backend', 'Install / Listing', 'script', NULL),
(158, 'lblInstallPhp1Title', 'backend', 'Listing install infobox', 'script', NULL),
(159, 'lblInstallPhp1_1', 'backend', 'Install / Step 1', 'script', NULL),
(160, 'lblInstallPhp1_2', 'backend', 'Install / Step 2', 'script', NULL),
(161, 'lblInstallPhp1_2a', 'backend', 'Install / Step 2a', 'script', NULL),
(162, 'lblInstallPhp1_3', 'backend', 'Install / Step 3', 'script', NULL),
(163, 'lblInstallPhp3Title', 'backend', 'Label / Install feature info', 'script', NULL),
(164, 'lblIp', 'backend', 'IP address', 'script', NULL),
(165, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(166, 'lblKeyword', 'backend', 'Label / Keyword', 'script', NULL),
(167, 'lblLastUpdateOn', 'backend', 'Label / Last update on', 'script', NULL),
(168, 'lblListingAddDesc', 'backend', 'Label / Add packace description', 'script', NULL),
(169, 'lblListingAddress', 'backend', 'Label / Address', 'script', NULL),
(170, 'lblListingAddTitle', 'backend', 'Label / Add new package', 'script', NULL),
(171, 'lblListingCheckin', 'backend', 'Label / Check-in', 'script', NULL),
(172, 'lblListingCheckout', 'backend', 'Label / Check-out', 'script', NULL),
(173, 'lblListingCity', 'backend', 'Label / City', 'script', NULL),
(174, 'lblListingCommentNotifyEmail', 'backend', 'Label / New comment notification', 'script', NULL),
(175, 'lblListingCommentNotifyTokens', 'backend', 'Tokens / new comment tokens', 'script', NULL),
(176, 'lblListingConfirmEmail', 'backend', 'Listing / Confirm email', 'script', NULL),
(177, 'lblListingConfirmTokens', 'backend', 'Listing / Confirm Tokens', 'script', NULL),
(178, 'lblListingCountry', 'backend', 'Label / Country', 'script', NULL),
(179, 'lblListingDetails', 'backend', 'Label / Details', 'script', NULL),
(180, 'lblListingEmail', 'backend', 'Listing / Email', 'script', NULL),
(181, 'lblListingExpire', 'backend', 'Label / Expire date', 'script', NULL),
(182, 'lblListingExpireTip', 'backend', 'Label / Expire tip', 'script', NULL),
(183, 'lblListingExtend', 'backend', 'Label / Extend expire date', 'script', NULL),
(184, 'lblListingFax', 'backend', 'Listing / Fax', 'script', NULL),
(185, 'lblListingFeatured', 'backend', 'Label / Is featured', 'script', NULL),
(186, 'lblListingFeatures', 'backend', 'Label / Features', 'script', NULL),
(187, 'lblListingFees', 'backend', 'Label / Fees', 'script', NULL),
(188, 'lblListingFirstName', 'backend', 'Listing / First name', 'script', NULL),
(189, 'lblListingFlight', 'backend', 'Label / Flight', 'script', NULL),
(190, 'lblListingFlightNotes', 'backend', 'Label / Flight notes', 'script', NULL),
(191, 'lblListingGMapNote', 'backend', 'Label / Gmap notes', 'script', NULL),
(192, 'lblListingInBoundArrives', 'backend', 'Label / Inbound Arrives', 'script', NULL),
(193, 'lblListingInBoundDeparts', 'backend', 'Label / Inbound Departs', 'script', NULL),
(194, 'lblListingInboundFlight', 'backend', 'Label / Inbound flight', 'script', NULL),
(195, 'lblListingInboundFrom', 'backend', 'Label / Inbound From', 'script', NULL),
(196, 'lblListingInBoundTo', 'backend', 'Label / Inbound To', 'script', NULL),
(197, 'lblListingLastName', 'backend', 'Listing / Last name', 'script', NULL),
(198, 'lblListingLat', 'backend', 'Label / Latitude', 'script', NULL),
(199, 'lblListingLng', 'backend', 'Label / Longitude', 'script', NULL),
(200, 'lblListingMetaDesc', 'backend', 'Listing / Meta description', 'script', NULL),
(201, 'lblListingMetaKeywords', 'backend', 'Listing / Meta keywords', 'script', NULL),
(202, 'lblListingMetaTitle', 'backend', 'Listing / Meta title', 'script', NULL),
(203, 'lblListingMobile', 'backend', 'Listing / Mobile phone', 'script', NULL),
(204, 'lblListingOutboundArrives', 'backend', 'Label / Outbound Arrives', 'script', NULL),
(205, 'lblListingOutboundDeparts', 'backend', 'Label / Outbound Departs', 'script', NULL),
(206, 'lblListingOutboundFlight', 'backend', 'Label / Outbound flight', 'script', NULL),
(207, 'lblListingOutboundFrom', 'backend', 'Label / From', 'script', NULL),
(208, 'lblListingOutboundTo', 'backend', 'Label / Outbound To', 'script', NULL),
(209, 'lblListingOwner', 'backend', 'Label / Owner', 'script', NULL),
(210, 'lblListingPackage', 'backend', 'Label / Package', 'script', NULL),
(211, 'lblListingPets', 'backend', 'Label / Pets', 'script', NULL),
(212, 'lblListingPhone', 'backend', 'Listing / Phone', 'script', NULL),
(213, 'lblListingPhotos', 'backend', 'Label / Photos', 'script', NULL),
(214, 'lblListingPolicies', 'backend', 'Label / Policies', 'script', NULL),
(215, 'lblListingPrice', 'backend', 'Label / Price', 'script', NULL),
(216, 'lblListingPriceFrom', 'backend', 'Listing / Price from', 'script', NULL),
(217, 'lblListingPriceNotFound', 'backend', 'Label / Price not found', 'script', NULL),
(218, 'lblListingPrices', 'backend', 'Label / Prices', 'script', NULL),
(219, 'lblListingPriceTitle', 'backend', 'Listing / Price title', 'script', NULL),
(220, 'lblListingPriceTo', 'backend', 'Listing / Price to', 'script', NULL),
(221, 'lblListingPriceType', 'backend', 'Label / Price type', 'script', NULL),
(222, 'lblListingPublishPeriod', 'backend', 'Listing / Publish period', 'script', NULL),
(223, 'lblListingRefid', 'backend', 'Label / Reference ID', 'script', NULL),
(224, 'lblListingRegisterNotifyTokens', 'backend', 'label / Register tokens', 'script', NULL),
(225, 'lblListingRegistrationNotifyEmail', 'backend', 'Label / New owner account notification', 'script', NULL),
(226, 'lblListingSeo', 'backend', 'Listing / SEO', 'script', NULL),
(227, 'lblListingState', 'backend', 'Label / State', 'script', NULL),
(228, 'lblListingStatus', 'backend', 'Label / Status', 'script', NULL),
(229, 'lblListingStatusTip', 'backend', 'Label / Status tip', 'script', NULL),
(230, 'lblListingSummary', 'backend', 'Label / Summary', 'script', NULL),
(231, 'lblListingTerms', 'backend', 'Label / Terms', 'script', NULL),
(232, 'lblListingTitle', 'backend', 'Listing / Title', 'script', NULL),
(233, 'lblListingUrl', 'backend', 'Listing / Website', 'script', NULL),
(234, 'lblListingZip', 'backend', 'Label / Zip', 'script', NULL),
(235, 'lblName', 'backend', 'Name', 'script', NULL),
(236, 'lblNights', 'backend', 'Label / Nights', 'script', NULL),
(237, 'lblNo', 'backend', 'No', 'script', NULL),
(238, 'lblOption', 'backend', 'Option', 'script', NULL),
(239, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(240, 'lblOwner', 'backend', 'Label / Owner', 'script', NULL),
(241, 'lblOwnerShow', 'backend', 'Label / Show owner contact', 'script', NULL),
(242, 'lblPackageDescription', 'backend', 'Label / Package description', 'script', NULL),
(243, 'lblPackageTitle', 'backend', 'Label / Package title', 'script', NULL),
(244, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(245, 'lblRating', 'backend', 'Label / Rating', 'script', NULL),
(246, 'lblRole', 'backend', 'Role', 'script', NULL),
(247, 'lblSeasonAvailability', 'backend', 'Label / Season availability', 'script', NULL),
(248, 'lblShowOnMap', 'backend', 'Label / Show on map', 'script', NULL),
(249, 'lblSpring', 'backend', 'Label / Spring', 'script', NULL),
(250, 'lblStatus', 'backend', 'Status', 'script', NULL),
(251, 'lblSummer', 'backend', 'Label / Summer', 'script', NULL),
(252, 'lblTerms', 'backend', 'Label / Booking terms', 'script', NULL),
(253, 'lblType', 'backend', 'Type', 'script', NULL),
(254, 'lblUpdateComment', 'backend', 'Label / Update comment', 'script', NULL),
(255, 'lblUpdateEnquiry', 'backend', 'Label / Update enquiry', 'script', NULL),
(256, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(257, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(258, 'lblValue', 'backend', 'Value', 'script', NULL),
(259, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(260, 'lblWinter', 'backend', 'Label / Winter', 'script', NULL),
(261, 'lblYes', 'backend', 'Yes', 'script', NULL),
(262, 'listing_payment_free', 'backend', 'Listing / FREE', 'script', NULL),
(263, 'listing_payment_period', 'backend', 'Listing / Period', 'script', NULL),
(264, 'listing_payment_price', 'backend', 'Listing / Price', 'script', NULL),
(265, 'listing_payment_renew_free', 'backend', 'Listing / Extend your period for FREE', 'script', NULL),
(266, 'listing_payment_renew_paypal', 'backend', 'Listing / Buy now', 'script', NULL),
(267, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(268, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(269, 'locales', 'backend', 'Languages', 'script', NULL),
(270, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(271, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(272, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(273, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(274, 'menuAddPackage', 'backend', 'Menu / Add package', 'script', NULL),
(275, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(276, 'menuComments', 'backend', 'Menu / Comments', 'script', NULL),
(277, 'menuCountries', 'backend', 'Menu / Countries', 'script', NULL),
(278, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(279, 'menuEmails', 'backend', 'Menu / Emails', 'script', NULL),
(280, 'menuEnquiries', 'backend', 'Menu / Enquiries', 'script', NULL),
(281, 'menuFeatures', 'backend', 'Menu / Features', 'script', NULL),
(282, 'menuInstall', 'backend', 'Menus / Install', 'script', NULL),
(283, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(284, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(285, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(286, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(287, 'menuPackages', 'backend', 'Menu / Packages', 'script', NULL),
(288, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(289, 'menuPreview', 'backend', 'Menus / Preview', 'script', NULL),
(290, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(291, 'menuSubmissions', 'backend', 'Menus / Submissions', 'script', NULL),
(292, 'menuTypes', 'backend', 'Menu / Types', 'script', NULL),
(293, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(294, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(295, 'opt_o_allow_add_package', 'backend', 'Label / Allow user to add package', 'script', NULL),
(296, 'opt_o_allow_add_property', 'backend', 'Options / Allow add property', 'script', NULL),
(297, 'opt_o_comment_and_rating', 'backend', 'Options / Number of comments and average rating', 'script', NULL),
(298, 'opt_o_comment_default_status', 'backend', 'Options / Show visitors'' comments', 'script', NULL),
(299, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(300, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(301, 'opt_o_email_address', 'backend', 'Options / Email address', 'script', NULL),
(302, 'opt_o_featured_properties', 'backend', 'Options / Featured properties', 'script', NULL),
(303, 'opt_o_is_active_owner', 'backend', 'Options / User account confirmed by default', 'script', NULL),
(304, 'opt_o_items_per_page', 'backend', 'Options / Items per page', 'script', NULL),
(305, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(306, 'opt_o_listing_page', 'backend', 'Options / Listing page', 'script', NULL),
(307, 'opt_o_owner_is_active', 'backend', 'Label / Owner account status', 'script', NULL),
(308, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(309, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(310, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(311, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(312, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(313, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(314, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(315, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(316, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(317, 'opt_period_note', 'backend', 'Submissions / Period note', 'script', NULL),
(318, 'pass', 'backend', 'Password', 'script', NULL),
(341, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(342, 'url', 'backend', 'URL', 'script', NULL),
(343, 'user', 'backend', 'Username', 'script', NULL),
(344, 'vk_active', 'backend', 'vk_active', 'script', NULL),
(345, 'vk_address_not_found', 'backend', 'vk_address_not_found', 'script', NULL),
(346, 'vk_confirm_selected', 'backend', 'Label / Confirm selected', 'script', NULL),
(347, 'vk_date_from', 'backend', 'vk_date_from', 'script', NULL),
(348, 'vk_date_submitted', 'backend', 'Label / Date submitted', 'script', NULL),
(349, 'vk_date_to', 'backend', 'vk_date_to', 'script', NULL),
(350, 'vk_delete_confirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(351, 'vk_delete_selected', 'backend', 'vk_delete_selected', 'script', NULL),
(352, 'vk_dismiss_selected', 'backend', 'Label / Dismiss selected', 'script', NULL),
(353, 'vk_email_invalid', 'backend', 'vk_email_invalid', 'script', NULL),
(354, 'vk_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(355, 'vk_expire', 'backend', 'Listings / Expire', 'script', NULL),
(356, 'vk_export_selected', 'backend', 'vk_export_selected', 'script', NULL),
(357, 'vk_exp_date', 'backend', 'Listings / Exp.date', 'script', NULL),
(358, 'vk_exp_date_plus_30', 'backend', 'Listings / Expiration date +30 days', 'script', NULL),
(359, 'vk_extend_exp_date', 'backend', 'Listings / Extend expiration date', 'script', NULL),
(360, 'vk_field_required', 'backend', 'vk_field_required', 'script', NULL),
(361, 'vk_image', 'backend', 'vk_image', 'script', NULL),
(362, 'vk_inactive', 'backend', 'vk_inactive', 'script', NULL),
(363, 'vk_listing', 'backend', 'vk_listing', 'script', NULL),
(364, 'vk_make_all_active', 'backend', 'Label / Make all active', 'script', NULL),
(365, 'vk_make_all_inactive', 'backend', 'Label / Make all inactive', 'script', NULL),
(366, 'vk_make_selected_active', 'backend', 'Label / Make selected active', 'script', NULL),
(367, 'vk_make_selected_inactive', 'backend', 'Label / Make selected inactive', 'script', NULL),
(368, 'vk_name', 'backend', 'Label / Name', 'script', NULL),
(369, 'vk_not_published', 'backend', 'vk_not_published', 'script', NULL),
(370, 'vk_owner', 'backend', 'Listing / Owner', 'script', NULL),
(371, 'vk_publish', 'backend', 'Label / Publish', 'script', NULL),
(372, 'vk_published', 'backend', 'vk_published', 'script', NULL),
(373, 'vk_ref_id', 'backend', 'vk_ref_id', 'script', NULL),
(374, 'vk_revert_status', 'backend', 'vk_revert_status', 'script', NULL),
(375, 'vk_title', 'backend', 'Label / Title', 'script', NULL),
(376, 'vk_view_enquiries', 'backend', 'Listing / View enquiries', 'script', NULL),
(377, 'font_label_of', 'frontend', 'Label / of', 'script', NULL),
(378, 'front_button_login', 'frontend', 'Button / Login', 'script', NULL),
(379, 'front_button_register', 'frontend', 'Button / Register', 'script', NULL),
(380, 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
(381, 'front_label_arrival', 'frontend', 'Label / Arrival', 'script', NULL),
(382, 'front_label_availability', 'frontend', 'Label / Availability', 'script', NULL),
(383, 'front_label_available', 'frontend', 'Label / Available', 'script', NULL),
(384, 'front_label_avg_users_rating', 'frontend', 'Label / Average Users Rating', 'script', NULL),
(385, 'front_label_booking_terms', 'frontend', 'Label / Booking terms', 'script', NULL),
(386, 'front_label_by', 'frontend', 'Label / by', 'script', NULL),
(387, 'front_label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(388, 'front_label_checkin', 'frontend', 'Label / Check-in', 'script', NULL),
(389, 'front_label_checkout', 'frontend', 'Label / Check-out', 'script', NULL),
(390, 'front_label_comment', 'frontend', 'Label / Comment', 'script', NULL),
(391, 'front_label_comments', 'frontend', 'Label / Comments', 'script', NULL),
(392, 'front_label_departure', 'frontend', 'Label / Departure', 'script', NULL),
(393, 'front_label_description', 'frontend', 'Label / Description', 'script', NULL),
(394, 'front_label_details', 'frontend', 'Label / View details', 'script', NULL),
(395, 'front_label_disabled_package', 'frontend', 'Label / Disabled package', 'script', NULL),
(396, 'front_label_duration', 'frontend', 'Lable / Duration', 'script', NULL),
(397, 'front_label_email', 'frontend', 'Label / Email', 'script', NULL),
(398, 'front_label_enquiry', 'frontend', 'Label / Enquiry', 'script', NULL),
(399, 'front_label_fax', 'frontend', 'Label / Fax', 'script', NULL),
(400, 'front_label_features', 'frontend', 'Label / Amenities', 'script', NULL),
(401, 'front_label_fees', 'frontend', 'Label / Fees', 'script', NULL),
(402, 'front_label_filter_by_location', 'frontend', 'Label / Filter by location', 'script', NULL),
(403, 'front_label_filter_by_price', 'frontend', 'Label / Filter by price', 'script', NULL),
(404, 'front_label_filter_by_rating', 'frontend', 'Label / Filter by rating', 'script', NULL),
(405, 'front_label_filter_by_season', 'frontend', 'Label / Filter by season', 'script', NULL),
(406, 'front_label_filter_by_type', 'frontend', 'Label / Filter by type', 'script', NULL),
(407, 'front_label_flight_details', 'frontend', 'Label / Flight details', 'script', NULL),
(408, 'front_label_flight_included', 'frontend', 'Label / Flight included', 'script', NULL),
(409, 'front_label_flight_info', 'frontend', 'Label / Flight information', 'script', NULL),
(410, 'front_label_from', 'frontend', 'Label / From', 'script', NULL),
(411, 'front_label_hour', 'frontend', 'Label / h', 'script', NULL),
(412, 'front_label_inbound_arrive', 'frontend', 'Label / Inbound arrive', 'script', NULL),
(413, 'front_label_inbound_depart', 'frontend', 'Label / Inbound depart', 'script', NULL),
(414, 'front_label_inbound_flight', 'frontend', 'Label / Inbound Flight', 'script', NULL),
(415, 'front_label_inbound_from', 'frontend', 'Label / Inbound from', 'script', NULL),
(416, 'front_label_inbound_to', 'frontend', 'Label / Inbound to', 'script', NULL),
(417, 'front_label_location', 'frontend', 'Label / Location', 'script', NULL),
(418, 'front_label_minute', 'frontend', 'Label / m', 'script', NULL),
(419, 'front_label_mobile', 'frontend', 'Label / Mobile', 'script', NULL),
(420, 'front_label_name', 'frontend', 'Label / Name', 'script', NULL),
(421, 'front_label_nights', 'frontend', 'Label / Nights', 'script', NULL),
(422, 'front_label_notes', 'frontend', 'Label / Notes', 'script', NULL),
(423, 'front_label_not_found', 'frontend', 'Label / No package found.', 'script', NULL),
(424, 'front_label_no_comment', 'frontend', 'Label / No comment', 'script', NULL),
(425, 'front_label_of', 'frontend', 'Label / of', 'script', NULL),
(426, 'front_label_outbound_arrive', 'frontend', 'Outbound arrive', 'script', NULL),
(427, 'front_label_outbound_depart', 'frontend', 'Label / Outbound depart', 'script', NULL),
(428, 'front_label_outbound_flight', 'frontend', 'Label / Outbound Flight', 'script', NULL),
(429, 'front_label_outbound_from', 'frontend', 'Label / Outbound from', 'script', NULL),
(430, 'front_label_outbound_to', 'frontend', 'Label / Outbound to', 'script', NULL),
(431, 'front_label_owner', 'frontend', 'Label / Owner contact', 'script', NULL),
(432, 'front_label_package', 'frontend', 'Label / Package', 'script', NULL),
(433, 'front_label_password', 'frontend', 'Label / Password', 'script', NULL),
(434, 'front_label_per_person', 'frontend', 'Label / per person', 'script', NULL),
(435, 'front_label_pets', 'frontend', 'Label / Pets', 'script', NULL),
(436, 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(437, 'front_label_policies', 'frontend', 'Label / Policies', 'script', NULL),
(438, 'front_label_policies_fees', 'frontend', 'Label / Policies & Fees', 'script', NULL),
(439, 'front_label_post_review', 'frontend', 'Label / Post Review', 'script', NULL),
(440, 'front_label_price', 'frontend', 'Label / Price', 'script', NULL),
(441, 'front_label_prices', 'frontend', 'Label / Availability & Prices', 'script', NULL),
(442, 'front_label_rating', 'frontend', 'Labe / Rating', 'script', NULL),
(443, 'front_label_retype_password', 'frontend', 'Label / Re-type password', 'script', NULL),
(444, 'front_label_send_enquiry', 'frontend', 'Label / Send Enquiry', 'script', NULL),
(445, 'front_label_send_request', 'frontend', 'Label / Send request', 'script', NULL),
(446, 'front_label_star', 'frontend', 'Label / star', 'script', NULL),
(447, 'front_label_stars', 'frontend', 'Label / stars', 'script', NULL),
(448, 'front_label_title', 'frontend', 'Label / Title', 'script', NULL),
(449, 'front_label_to', 'frontend', 'Label / To', 'script', NULL),
(450, 'front_label_total_duration', 'frontend', 'Label / Total Duration', 'script', NULL),
(451, 'front_label_users_rating', 'frontend', 'Label / Users rating', 'script', NULL),
(452, 'front_label_website', 'frontend', 'Label / Website', 'script', NULL),
(453, 'front_lable_stars', 'frontend', 'Label / Stars', 'script', NULL),
(454, 'front_link_back', 'frontend', 'Link / Back', 'script', NULL),
(455, 'front_link_clear_filter', 'frontend', 'Link / Clear filter', 'script', NULL),
(456, 'front_menu_login', 'frontend', 'Menu / Login', 'script', NULL),
(457, 'front_menu_register', 'frontend', 'Menu / Register', 'script', NULL),
(458, 'front_paging_next', 'frontend', 'Label / Next', 'script', NULL),
(459, 'front_paging_previous', 'frontend', 'Label / Prev', 'script', NULL),
(460, 'comment_statuses_ARRAY_Confirmed', 'arrays', 'comment_statuses_ARRAY_Confirmed', 'script', NULL),
(461, 'comment_statuses_ARRAY_New', 'arrays', 'comment_statuses_ARRAY_New', 'script', NULL),
(462, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(463, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(464, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(465, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(466, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(467, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(468, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(469, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(470, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(471, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(472, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(473, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(474, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(475, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(476, 'enquiry_statuses_ARRAY_Confirmed', 'arrays', 'enquiry_statuses_ARRAY_Confirmed', 'script', NULL),
(477, 'enquiry_statuses_ARRAY_New', 'arrays', 'enquiry_statuses_ARRAY_New', 'script', NULL),
(478, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(479, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(480, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(481, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(482, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(483, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(484, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(485, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(486, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(487, 'error_bodies_ARRAY_AC02', 'arrays', 'error_bodies_ARRAY_AC02', 'script', NULL),
(488, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(489, 'error_bodies_ARRAY_AC09', 'arrays', 'error_bodies_ARRAY_AC09', 'script', NULL),
(490, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(491, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(492, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(493, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(494, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(495, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(496, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(497, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(498, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(499, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(500, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(501, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(502, 'error_bodies_ARRAY_AL09', 'arrays', 'error_bodies_ARRAY_AL09', 'script', NULL),
(503, 'error_bodies_ARRAY_AL10', 'arrays', 'error_bodies_ARRAY_AL10', 'script', NULL),
(504, 'error_bodies_ARRAY_AL41', 'arrays', 'error_bodies_ARRAY_AL41', 'script', NULL),
(505, 'error_bodies_ARRAY_AL91', 'arrays', 'error_bodies_ARRAY_AL91', 'script', NULL),
(506, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(507, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(508, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(509, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(510, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(511, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(512, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(513, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(514, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(515, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(516, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(517, 'error_bodies_ARRAY_AU02', 'arrays', 'error_bodies_ARRAY_AU02', 'script', NULL),
(518, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(519, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(520, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(523, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(524, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(525, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(526, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(527, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(528, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(529, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(530, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(531, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(532, 'error_titles_ARRAY_AC02', 'arrays', 'error_titles_ARRAY_AC02', 'script', NULL),
(533, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(534, 'error_titles_ARRAY_AC09', 'arrays', 'error_titles_ARRAY_AC00', 'script', NULL),
(535, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(536, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(537, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(538, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE09', 'script', NULL),
(539, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(540, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(541, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(542, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(543, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(544, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(545, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(546, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(547, 'error_titles_ARRAY_AL09', 'arrays', 'error_titles_ARRAY_AL09', 'script', NULL),
(548, 'error_titles_ARRAY_AL10', 'arrays', 'error_titles_ARRAY_AL10', 'script', NULL),
(549, 'error_titles_ARRAY_AL41', 'arrays', 'error_titles_ARRAY_AL41', 'script', NULL),
(550, 'error_titles_ARRAY_AL91', 'arrays', 'error_titles_ARRAY_AL91', 'script', NULL),
(551, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(552, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(553, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(554, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(555, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(556, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(557, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(558, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(559, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(560, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(561, 'error_titles_ARRAY_AU02', 'arrays', 'error_titles_ARRAY_AU02', 'script', NULL),
(562, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(563, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(564, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(567, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(568, 'filter_ARRAY_featured', 'arrays', 'filter_ARRAY_featured', 'script', NULL),
(569, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(570, 'filter_ARRAY_non_featured', 'arrays', 'filter_ARRAY_non_featured', 'script', NULL),
(571, 'filter_prices_ARRAY_1', 'arrays', 'filter_prices_ARRAY_1', 'script', NULL),
(572, 'filter_prices_ARRAY_2', 'arrays', 'filter_prices_ARRAY_2', 'script', NULL),
(573, 'filter_prices_ARRAY_3', 'arrays', 'filter_prices_ARRAY_3', 'script', NULL),
(574, 'filter_prices_ARRAY_4', 'arrays', 'filter_prices_ARRAY_4', 'script', NULL),
(575, 'filter_seasons_ARRAY_1', 'arrays', 'filter_seasons_ARRAY_1', 'script', NULL),
(576, 'filter_seasons_ARRAY_2', 'arrays', 'filter_seasons_ARRAY_2', 'script', NULL),
(577, 'filter_seasons_ARRAY_3', 'arrays', 'filter_seasons_ARRAY_3', 'script', NULL),
(578, 'filter_seasons_ARRAY_4', 'arrays', 'filter_seasons_ARRAY_4', 'script', NULL),
(579, 'front_error_ARRAY_FR01', 'arrays', 'front_error_ARRAY_FR01', 'script', NULL),
(580, 'front_error_ARRAY_FR02', 'arrays', 'front_error_ARRAY_FR02', 'script', NULL),
(581, 'front_error_ARRAY_FR03', 'arrays', 'front_error_ARRAY_FR03', 'script', NULL),
(582, 'front_error_ARRAY_FRC01', 'arrays', 'front_error_ARRAY_FRC01', 'script', NULL),
(583, 'front_error_ARRAY_FRC02', 'arrays', 'front_error_ARRAY_FRC02', 'script', NULL),
(584, 'front_error_ARRAY_FRC03', 'arrays', 'front_error_ARRAY_FRC03', 'script', NULL),
(585, 'front_error_ARRAY_FRC04', 'arrays', 'front_error_ARRAY_FRC04', 'script', NULL),
(586, 'front_sys_ARRAY_bf_captcha', 'arrays', 'front_sys_ARRAY_bf_captcha', 'script', NULL),
(587, 'front_sys_ARRAY_bf_captcha_inc', 'arrays', 'front_sys_ARRAY_bf_captcha_inc', 'script', NULL),
(588, 'front_sys_ARRAY_bf_comment', 'arrays', 'front_sys_ARRAY_bf_comment', 'script', NULL),
(589, 'front_sys_ARRAY_bf_email', 'arrays', 'front_sys_ARRAY_bf_email', 'script', NULL),
(590, 'front_sys_ARRAY_bf_email_inv', 'arrays', 'front_sys_ARRAY_bf_email_inv', 'script', NULL),
(591, 'front_sys_ARRAY_bf_name', 'arrays', 'front_sys_ARRAY_bf_name', 'script', NULL),
(592, 'front_sys_ARRAY_bf_not_match_password', 'arrays', 'front_sys_ARRAY_bf_not_match_password', 'script', NULL),
(593, 'front_sys_ARRAY_bf_password', 'arrays', 'front_sys_ARRAY_bf_password', 'script', NULL),
(594, 'front_sys_ARRAY_bf_retype_password', 'arrays', 'front_sys_ARRAY_bf_retype_password', 'script', NULL),
(595, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(596, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(597, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(598, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(599, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(600, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(601, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(602, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(603, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(604, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(605, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(606, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(607, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(608, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(609, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(610, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(611, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(612, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(613, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(614, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(615, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(616, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(617, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(618, 'price_types_ARRAY_night', 'arrays', 'price_types_ARRAY_night', 'script', NULL),
(619, 'price_types_ARRAY_person', 'arrays', 'price_types_ARRAY_person', 'script', NULL),
(620, 'price_types_ARRAY_total', 'arrays', 'price_types_ARRAY_total', 'script', NULL),
(621, 'publish_status_ARRAY_E', 'arrays', 'publish_status_ARRAY_E', 'script', NULL),
(622, 'publish_status_ARRAY_F', 'arrays', 'publish_status_ARRAY_F', 'script', NULL),
(623, 'publish_status_ARRAY_T', 'arrays', 'publish_status_ARRAY_T', 'script', NULL),
(624, 'register_status_ARRAY_9901', 'arrays', 'register_status_ARRAY_9901', 'script', NULL),
(625, 'register_status_ARRAY_9902', 'arrays', 'register_status_ARRAY_9902', 'script', NULL),
(626, 'register_status_ARRAY_9903', 'arrays', 'register_status_ARRAY_9903', 'script', NULL),
(627, 'register_status_ARRAY_9904', 'arrays', 'register_status_ARRAY_9904', 'script', NULL),
(628, 'register_status_ARRAY_9905', 'arrays', 'register_status_ARRAY_9905', 'script', NULL),
(629, 'register_status_ARRAY_9906', 'arrays', 'register_status_ARRAY_9906', 'script', NULL),
(630, 'register_status_ARRAY_9907', 'arrays', 'register_status_ARRAY_9907', 'script', NULL),
(631, 'register_status_ARRAY_9908', 'arrays', 'register_status_ARRAY_9908', 'script', NULL),
(632, 'register_status_ARRAY_9909', 'arrays', 'register_status_ARRAY_9909', 'script', NULL),
(633, 'register_status_ARRAY_9910', 'arrays', 'register_status_ARRAY_9910', 'script', NULL),
(634, 'register_status_ARRAY_9911', 'arrays', 'register_status_ARRAY_9911', 'script', NULL),
(635, 'register_status_ARRAY_9912', 'arrays', 'register_status_ARRAY_9912', 'script', NULL),
(636, 'register_status_ARRAY_9913', 'arrays', 'register_status_ARRAY_9913', 'script', NULL),
(637, 'register_status_ARRAY_9997', 'arrays', 'register_status_ARRAY_9997', 'script', NULL),
(638, 'register_status_ARRAY_9998', 'arrays', 'register_status_ARRAY_9998', 'script', NULL),
(639, 'register_status_ARRAY_9999', 'arrays', 'register_status_ARRAY_9999', 'script', NULL),
(640, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(641, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL);
INSERT INTO `vacationpackages_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(642, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(643, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(644, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(645, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(646, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(647, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(648, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(649, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(650, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(651, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(652, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(653, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(654, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(655, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(656, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(657, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(658, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(659, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(660, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(661, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(662, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(663, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(664, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(665, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(666, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(667, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(668, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(669, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(670, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(671, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(672, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(673, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(674, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(675, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(676, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(677, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(678, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(679, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(680, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(681, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(682, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(683, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(684, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(685, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(686, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(687, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(688, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(689, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(690, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(691, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(692, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(693, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(758, 'front_label_filter_by', 'frontend', 'Label / Filter by', 'script', NULL),
(759, 'front_label_season', 'frontend', 'Label / Season', 'script', NULL),
(760, 'front_label_type', 'frontend', 'Label / Type', 'script', NULL),
(764, 'front_label_clear', 'frontend', 'Label / Clear', 'script', NULL),
(765, 'front_label_filter', 'frontend', 'Label / Filter', 'script', NULL),
(766, 'front_label_photo', 'frontend', 'Label / Photo', 'script', NULL),
(767, 'front_label_photos', 'frontend', 'Label / Photos', 'script', NULL),
(832, 'lblNotActive', 'backend', 'Label / Not active', 'script', NULL),
(833, 'front_label_sort_by', 'frontend', 'Label / Sort by', 'script', NULL),
(835, 'front_label_show', 'frontend', 'Label / Show', 'script', NULL),
(836, 'front_label_packages', 'frontend', 'Label / packages', 'script', NULL),
(837, 'front_label_per_page', 'frontend', 'Label / per page', 'script', NULL),
(838, 'item_per_page_ARRAY_10', 'arrays', 'item_per_page_ARRAY_10', 'script', NULL),
(839, 'item_per_page_ARRAY_20', 'arrays', 'item_per_page_ARRAY_20', 'script', NULL),
(840, 'item_per_page_ARRAY_30', 'arrays', 'item_per_page_ARRAY_30', 'script', NULL),
(841, 'item_per_page_ARRAY_50', 'arrays', 'item_per_page_ARRAY_50', 'script', NULL),
(842, 'item_per_page_ARRAY_100', 'arrays', 'item_per_page_ARRAY_100', 'script', NULL),
(843, 'front_label_type_city_country', 'frontend', 'Label / type city or country', 'script', NULL),
(844, 'front_label_top', 'frontend', 'Label / top', 'script', NULL),
(845, 'error_titles_ARRAY_AL20', 'arrays', 'error_titles_ARRAY_AL20', 'script', NULL),
(846, 'error_bodies_ARRAY_AL20', 'arrays', 'error_bodies_ARRAY_AL20', 'script', NULL),
(847, 'lblPostedDateTime', 'backend', 'Label / Date/time', 'script', NULL),
(912, 'lblDashPackages', 'backend', 'Dashboard / Packages', 'script', NULL),
(914, 'lblDashEnquiries', 'backend', 'Dashboard / Enquiries', 'script', NULL),
(915, 'lblDashEnquiry', 'backend', 'Dashboard / Enquiry', 'script', NULL),
(916, 'lblDashComments', 'backend', 'Dashboard / Comments', 'script', NULL),
(917, 'lblDashComment', 'backend', 'Dashboard / Comment', 'script', NULL),
(918, 'lblDashMostPopular', 'backend', 'Dashboard / Most popular', 'script', NULL),
(919, 'lblDashLatestEnquiries', 'backend', 'Dashboard / Latest enquiries', 'script', NULL),
(920, 'lblDashLatestComments', 'backend', 'Dashboard / Latest Comments', 'script', NULL),
(921, 'lblDashViews', 'backend', 'Dashboard / Views', 'script', NULL),
(922, 'lblDashView', 'backend', 'Dashboard / View', 'script', NULL),
(923, 'lblEnquiryNotFound', 'backend', 'Label / No enquiry found', 'script', NULL),
(924, 'lblDashNights', 'backend', 'Dashboard / nights', 'script', NULL),
(925, 'lblDashNight', 'backend', 'Dashboard / night', 'script', NULL),
(926, 'lblListingNotFound', 'backend', 'Label / No package found.', 'script', NULL),
(927, 'lblCommentNotFound', 'backend', 'Label / No comment found', 'script', NULL),
(928, 'lblAddTypeMessage', 'backend', 'Label / Add type message', 'script', NULL),
(929, 'infoFlightTitle', 'backend', 'Infobox / Flight title', 'script', NULL),
(930, 'infoFlightBody', 'backend', 'Infobox / Flight body', 'script', NULL),
(931, 'infoFeatureTitle', 'backend', 'Infobox / Feature Title', 'script', NULL),
(932, 'infoFeatureBody', 'backend', 'Infobox / Feature Body', 'script', NULL),
(933, 'infoOwnerContactTitle', 'backend', 'Infobox / Owner contact title', 'script', NULL),
(934, 'infoOwnerContactBody', 'backend', 'Infobox / Owner contact body', 'script', NULL),
(935, 'infoSEOTitle', 'backend', 'Infobox / SEO Title', 'script', NULL),
(936, 'infoSEOBody', 'backend', 'Infobox / SEO body', 'script', NULL),
(937, 'front_label_cancel', 'frontend', 'Label / Cancel', 'script', NULL),
(938, 'lblInstallOptional', 'backend', 'Label / Optional', 'script', NULL),
(939, 'opt_o_seo_url', 'backend', 'Options / Use SEO Friendly URLs', 'script', NULL),
(940, 'lblInstallPhp4Title', 'backend', 'Label / PHP install step 4', 'script', NULL),
(941, 'lblInstallPhp1_4', 'backend', 'Label / Install step 1-4', 'script', NULL),
(942, 'lblInstallPhp1_5', 'backend', 'Label / Install step 1-5', 'script', NULL),
(943, 'front_label_show_all', 'frontend', 'Label / Show all', 'script', NULL),
(944, 'front_label_show_less', 'frontend', 'Label / Show less', 'script', NULL),
(945, 'front_label_review', 'frontend', 'Label / review', 'script', NULL),
(946, 'front_login_info', 'frontend', 'Label / Login info', 'script', NULL),
(947, 'front_register_info', 'frontend', 'Label / Register info', 'script', NULL),
(948, 'front_label_forgot_password', 'frontend', 'Label / Forgot password', 'script', NULL),
(949, 'front_forgot_info', 'frontend', 'Label / Forgot password info', 'script', NULL),
(950, 'front_button_send', 'frontend', 'Button / Send', 'script', NULL),
(951, 'lblForgotPasswordEmail', 'backend', 'Label / Forgot password email', 'script', NULL),
(952, 'lblForgotPasswordTokens', 'backend', 'Label / Forgot password tokens', 'script', NULL),
(953, 'forgot_status_ARRAY_9901', 'arrays', 'forgot_status_ARRAY_9901', 'script', NULL),
(954, 'forgot_status_ARRAY_9906', 'arrays', 'forgot_status_ARRAY_9906', 'script', NULL),
(955, 'forgot_status_ARRAY_9912', 'arrays', 'forgot_status_ARRAY_9912', 'script', NULL),
(956, 'forgot_status_ARRAY_9997', 'arrays', 'forgot_status_ARRAY_9997', 'script', NULL),
(957, 'forgot_status_ARRAY_9999', 'arrays', 'forgot_status_ARRAY_9999', 'script', NULL),
(958, 'front_label_id', 'frontend', 'Label / ID', 'script', NULL),
(959, 'gridEmptyDate', 'backend', 'Grid / (empty date)', 'script', NULL),
(960, 'gridInvalidDate', 'backend', 'Grid / (invalid date)', 'script', NULL),
(961, 'gridEmptyDateTime', 'backend', 'Grid / (empty date time)', 'script', NULL),
(962, 'gridInvalidDateTime', 'backend', 'Grid / (invalid date time)', 'script', NULL),
(963, 'lblListingRefIDTip', 'backend', 'Tooltip / Ref ID', 'script', NULL),
(964, 'lblListingFeaturedTip', 'backend', 'Tooltip / Featured', 'script', NULL),
(965, 'lblListingOwnerTip', 'backend', 'Tooltip / Owner contact', 'script', NULL),
(966, 'lblListingCityTip', 'backend', 'Tooltip / City', 'script', NULL),
(967, 'lblListingMetaTitleTip', 'backend', 'Tooltip / Meta title', 'script', NULL),
(968, 'lblListingMetaKeywordTip', 'backend', 'Tooltip / Meta keyword', 'script', NULL),
(969, 'lblListingMetaDescTip', 'backend', 'Tooltip / Meta description', 'script', NULL),
(970, 'lblOptionFirstDayTip', 'backend', 'Tooltip / First day of week', 'script', NULL),
(971, 'lblOptionCommentsTip', 'backend', 'Tooltip / Comment and rating', 'script', NULL),
(972, 'lblOptionCurrencyTip', 'backend', 'Tooltip / Currency', 'script', NULL),
(973, 'lblOptionsConfirmEmailTip', 'backend', 'Tooltip / Confirm email', 'script', NULL),
(974, 'lblOptionsCommentEmailTip', 'backend', 'Tooltip / Comment notify email', 'script', NULL),
(975, 'lblOptionsRegistrationEmailTip', 'backend', 'Tooltip / Regstration email', 'script', NULL),
(976, 'lblOptionsForgotEmailTip', 'backend', 'Tooltip / Forgot email', 'script', NULL),
(977, 'lblUnlimited', 'backend', 'Label / Unlimited', 'script', NULL),
(978, 'lblOptionEmailTip', 'backend', 'Tooltip / Email account', 'script', NULL),
(979, 'lblOptionAutoActiveTip', 'backend', 'Tooltip / Auto active account', 'script', NULL),
(980, 'infoUserTitle', 'backend', 'Infobox / Manage user title', 'script', NULL),
(981, 'infoUserBody', 'backend', 'Infobox / Manage user body', 'script', NULL),
(982, 'infoAddPackageTitle', 'backend', 'Infobox / Add package title', 'script', NULL),
(1000, 'infoAddPackageBody', 'backend', 'Infobox / Add package body', 'script', NULL),
(1001, 'infoListingSummaryTitle', 'backend', 'Infobox / Summary title', 'script', NULL),
(1002, 'infoListingSummaryBody', 'backend', 'Infobox / Summary body', 'script', NULL),
(1003, 'infoOwnerFlightTitle', 'backend', 'Infobox / Owner flight title', 'script', NULL),
(1004, 'infoOwnerFlightBody', 'backend', 'Infobox / Owner flight body', 'script', NULL),
(1005, 'infoOwnerFeatureTitle', 'backend', 'Infobox / Feature title', 'script', NULL),
(1006, 'infoOwnerFeatureBody', 'backend', 'Infobox / Feature body', 'script', NULL),
(1007, 'infoOwnerContact2Title', 'backend', 'Infobox / Owner contact title', 'script', NULL),
(1008, 'infoOwnerContact2Body', 'backend', 'Infobox / Owner contact body', 'script', NULL),
(1009, 'infoEditorEmailTitle', 'backend', 'Infobox / Editor email title', 'script', NULL),
(1010, 'infoEditorEmailBody', 'backend', 'Infobox / Editor email body', 'script', NULL),
(1081, 'front_label_reviews', 'frontend', 'Label / reviews', 'script', '2013-09-13 11:36:33'),
(1082, 'front_label_view_all_reviews', 'frontend', 'Label / View All Reviews', 'script', '2013-09-13 11:40:03'),
(1083, 'front_label_type_country', 'frontend', 'Label / type Country and/or city', 'script', '2013-09-13 14:58:08'),
(1084, 'lblIntegrationMethod', 'backend', 'Label / Integration method', 'script', '2013-09-17 10:54:00'),
(1085, 'integration_methods_ARRAY_all', 'arrays', 'integration_methods_ARRAY_all', 'script', '2013-09-17 10:55:00'),
(1086, 'integration_methods_ARRAY_each', 'arrays', 'integration_methods_ARRAY_each', 'script', '2013-09-17 10:55:44'),
(1087, 'lblListingNumberOfFeaturedTip', 'backend', 'Tips / Number of featured packages', 'script', NULL),
(1089, 'register_status_ARRAY_9914', 'arrays', 'register_status_ARRAY_9914', 'script', NULL),
(1090, 'register_status_ARRAY_9915', 'arrays', 'register_status_ARRAY_9915', 'script', NULL);

INSERT INTO `vacationpackages_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjFeature', 1, 'name', 'Air conditioning', 'script'),
(NULL, 5, 'pjFeature', 1, 'name', 'Dining room', 'script'),
(NULL, 7, 'pjFeature', 1, 'name', 'Fireplace', 'script'),
(NULL, 8, 'pjFeature', 1, 'name', 'Breakfast nook', 'script'),
(NULL, 12, 'pjFeature', 1, 'name', 'Laundry area - garage', 'script'),
(NULL, 14, 'pjFeature', 1, 'name', 'Refrigerator', 'script'),
(NULL, 15, 'pjFeature', 1, 'name', 'Balcony', 'script'),
(NULL, 21, 'pjFeature', 1, 'name', 'Swimming pool', 'script'),
(NULL, 22, 'pjFeature', 1, 'name', 'Family room', 'script'),
(NULL, 24, 'pjFeature', 1, 'name', 'Jacuzzi', 'script'),
(NULL, 27, 'pjFeature', 1, 'name', 'Sauna', 'script'),
(NULL, 28, 'pjFeature', 1, 'name', 'Bonus / Rec room', 'script'),
(NULL, 34, 'pjFeature', 1, 'name', 'Garage parking', 'script'),
(NULL, 35, 'pjFeature', 1, 'name', 'Fitness center', 'script'),
(NULL, 37, 'pjFeature', 1, 'name', 'Covered parking', 'script'),
(NULL, 38, 'pjFeature', 1, 'name', 'Swimming pool(s)', 'script'),
(NULL, 41, 'pjFeature', 1, 'name', 'Sauna / Spa', 'script'),
(NULL, 43, 'pjFeature', 1, 'name', 'Business center', 'script'),
(NULL, 44, 'pjFeature', 1, 'name', 'Tennis court(s)', 'script'),
(NULL, 46, 'pjFeature', 1, 'name', 'Clubhouse', 'script'),
(NULL, 47, 'pjFeature', 1, 'name', 'Golf course', 'script'),
(NULL, 50, 'pjFeature', 1, 'name', 'Lake', 'script'),
(NULL, 51, 'pjFeature', 1, 'name', 'Vintage building', 'script'),
(NULL, 53, 'pjFeature', 1, 'name', 'Playground', 'script'),
(NULL, 54, 'pjFeature', 1, 'name', 'Wheelchair access', 'script'),
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add period / price', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Â« Back', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Get coordinates from Google Maps API', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'ALT', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Bottom Center', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Bottom Left', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Bottom Right', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Clear current one', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Compress', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Re-create thumbs', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Set watermark', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Center Center', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Center Left', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Center Right', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Compression', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur id consectetur magna. Nulla facilisi. Sed id dolor ante.', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Are you sure you want to delete all images?', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Are you sure you want to delete selected image?', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Delete All', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'No images uploaded yet.', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Image settings', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Move', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Originals', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'photos', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Position', 'script'),
(NULL, 52, 'pjField', 1, 'title', 're-create from original', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Resize/Crop', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Rotate', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Thumbs', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Top Center', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Top Left', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Top Right', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Upload', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Watermark', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Watermark position', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Next Â»', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Â« Prev', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emailsâ€™ subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized. You can manage the email account that will be used as â€˜email fromâ€™ when sending these notifications on Options menu -> Options tab.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'You can set up and manage a list with pre-defined amenities / features which can be used to describe in brief package features or accommodation amenities. The pre-defined amenities / features list which is set here, will show up on Features tab while editing a package.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Enter feature name and then click Save button.', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Add feature', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Amenities / Features list', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Edit the feature name and then click Save button.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Update feature', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'You can show a map with the location of the package accommodation on the package details page. Submit the full address first and then click on â€˜Get coordinates from Google Maps APIâ€™ button. Save your data.', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Location and Address', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'To publish your package or to extend its expiration date (if the package has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on â€˜Buy nowâ€™ button and make the payment required. After payment is received the package will be automatically published / extended.', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Extend expiration date', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Here you can define all the options that your vacation package offers, if you have such. Name each offer accordingly and set its price and the period when valid. Set at least one price offer if you wish to show a package price. You can use Terms tab to describe in more details the package policies, fees and booking terms. ', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Availability & Prices', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'You can allow/disallow website users to submit their own vacation packages after registering into the system. These users are named â€œOwnersâ€. You can manage ownersâ€™ accounts through Users menu. You can also charge owners for publishing their packages. If you wish to enable user submissions set carefully all options bellow and also set the Emails tab options.', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Package Submissions by Users', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Here you can add, delete and manage package types. It is mandatory to have at least one package type added into the system, because it is mandatory to assign a type to each package.', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Enter type name and then click Save button.', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Add package type', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Package Types', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Edit the name of package type and then click Save button.', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Update package type', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Added on', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Add enquiry', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Autumn', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Choose Owner', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Filter by package', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Package', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Contact email', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Contact fax', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Contact first name', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Contact last name', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Contact mobile phone', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Contact phone', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Contact title', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Contact website', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Email body', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Package', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Feature', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Flight Included', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Featured packages', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where featured listings will be displayed.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Listing', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Follow these steps to insert the Vacation Packages listing on your .php web page using PHP include code:', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the packages listing will be displayed.', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Follow these steps to insert the Featured Packages listing on your .php web page using PHP include code:', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Keyword', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Last update on', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Start submitting your package with choosing its type, status and reference ID. All of them are mandatory fields. If you are using the system for the first time and you do not have a type to choose (or you do not see the type you need) then go to Options menu -> Types tab and add the package types you wish to use.', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Add new package', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Check-in', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Check-out', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'New comment notification', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Available tokens: \r\n\r\n{OwnerName} - Package owner''s name\r\n{Name} - Name \r\n{Email} - Email \r\n{Rating} - Rating \r\n{Title} - Title \r\n{Comment} - Comment \r\n{RefID} - Package RefID\r\n{ListingTitle} - Package title', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'New enquiry notification email', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Available tokens: \r\n\r\n{OwnerName} - Package owner''s name\r\n{FullName} - Enquiry sender name \r\n{Email} - E-mail \r\n{Phone} - Phone number \r\n{Notes} - Additional notes \r\n{StartDate} - Start date \r\n{EndDate} - End date \r\n{ListingID} - Package ID \r\n{ListingTitle} - Package title\r\n{EnquiryID} - Enquiry ID', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Expire date', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Set a date until the package will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Extend expire date', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Make featured', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Fees', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Flight', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Flight notes', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Click on the button to get the location coordinates from Google Maps API. The full address should be submitted above first. You can also enter long/lat coordinates for your package on your own.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Inbound Arrives', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Inbound Departs', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Inbound flight', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Inbound From', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Inbound To', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Latitude', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Longitude', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Meta description', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Meta keywords', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Meta title', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Mobile phone', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Outbound Arrives', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Outbound Departs', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Outbound flight', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Outboud From', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Outbound To', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Owner contact', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Package', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Pets', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Policies', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Price from', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Price not found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Price title', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Price to', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Price type', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Publish period', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Available tokens: \r\n\r\n{Email} - email \r\n{Name} - full name', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'New owner account notification', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Publish', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'You can add a package but choose not to show it on the website listing by choosing â€˜Noâ€™. You can publish the package by choosing â€˜Yesâ€™ or you can make it live only till a certain date by choosing â€˜Based on expiration dateâ€™.', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Nights', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Show owner contact', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Package description', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Package title', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Rating', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Season availability', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Show on map', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Spring', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Summer', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Booking terms', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Update comment', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Update enquiry', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Winter', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'FREE', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Extend your period for FREE', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Buy now', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Add package', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Countries', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Submissions', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Types', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of your vacation packages listing you wish to edit.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Allow users to submit packages', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Allow users to add properties', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Show/Hide ''Average Users Rating''', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Show visitors'' comments', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Email account for email notifications', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Number of packages to shown on Featured Packages listing', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'User account confirmed by default', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Number of packages to shown on a listing page (by default)', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Choose front-end layout', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'URL to the web page where listing is placed', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Automatically activate new owner accounts', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Set your Paypal address', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Select the email sending method that your server supports', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Set prices for submitting packages by owners. You can charge different price according to the length of time that the vacation package is active (visible) on your listing. To do this add and manage â€˜period / priceâ€™ rows below. If you wish to set a â€˜free trialâ€™ period then set the number of the days and set â€˜0â€™ into the price field. If you do not wish to charge owners for submitting their packages, then leave just one â€˜period / priceâ€™ row, define a relevant large number of days into the period filed, and set â€˜0â€™ into the price field.', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Add Language', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Address not found', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Confirm selected', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Date from', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Date submitted', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Date to', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Do you really want to delete the selected record(s)?', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Dismiss selected', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Expire', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Export selected', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Exp.date', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Expiration date +30 days', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Extend expiration date', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Package', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Make all active', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Make all inactive', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Make selected active', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Make selected inactive', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Make selected Inactive', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Publish', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Make selected Active', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Ref ID', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'View enquiries', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Arrival', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Average Users Rating', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Booking terms', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Check-in', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Check-out', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Departure', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'View details', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'We sorry that the current package may be disabled or deleted by the administrator.', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Enquiry', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Amenities', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Fees', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Filter by location', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Filter by price', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Filter by rating', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Filter by season', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Filter by type', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Flight details', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Flight included', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Flight', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'h', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Inbound arrive', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Inbound depart', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Inbound Flight', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Inbound from', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Inbound to', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'm', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Mobile', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Nights', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'No package found.', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'There is no comment.', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Outbound arrive', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Outbound depart', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Outbound Flight', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Outbound from', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Outbound to', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Owner contact', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Package', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Pets', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Policies', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Policies & Fees', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Post Review', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Availability & Prices', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Rating', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Re-type password', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Send Enquiry', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Send request', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'star', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'stars', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Total Duration', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Average Users Rating', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Stars', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Clear filter', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Log in', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'New', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Not confirmed', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'To protect your system from loses perform a backup anytime you wish. Click on the generated file link to download the backup file.  ', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'All changes to the comment have been saved.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'The comment data you entered is not valid.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'We are sorry that the current comment does not exist anymore.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'The comment is for non-existing package. Please check the package status again.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'All changes made to the enquiry have been saved.', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'A new enquiry has been added to the list.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'An error occurred! it failed to add new enquiry.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'We are sorry that the enquiry you are looking for is missing.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'All changes made to the feature have been saved.', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'A new feature has been added to the list.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Error occurred! it failed to add new feature.', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'We are sorry, but the feature you are looking for is missing.', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'All changes made to the package have been saved.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'A new package has been added to the list.', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'An error occurred! it failed to add new package.', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'We are sorry, but the package you are looking for is missing.', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'You have no permission to edit the package.', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Your plan has been extended.', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Upload as many images as you want for this package. You can resize, crop, rotate, watermark and complress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'You can define here all policies and fees that your package has. â€˜Booking termsâ€™ field text will show up in a special box next to the enquiry form on your package details page. You can use it to highlight your booking conditions.', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Your configuration settings have been saved.', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'You have just defined email notification successfully.', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'All changes made to emails have been saved.', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'All changes made to the type have been saved.', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'A new type has been added to the list.', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Error occurred! it failed to add a new type.', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'We are sorry! the types your are looking for are missing.', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'An error occurred when trying to update user.', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Comment updated', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Data invalid', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Comment not found', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Package missing', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Enquiry updated', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Enquiry added', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Error! failed to add enquiry', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Enquiry not found', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Feature updated', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Feature added', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Error! failed to add feature', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Feature not found', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Package updated', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Package added', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Error! failed to add package', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Package not found', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Error occured', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'System notice', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Policies & Fees / Booking terms', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Submissions updated', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Installation Settings Updated', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Emails added', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Email updated', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Type updated', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Type added', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Adding type error', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Type not found', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'User failed to update', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Featured', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Not featured', 'script'),
(NULL, 571, 'pjField', 1, 'title', '$ 100 - $ 500', 'script'),
(NULL, 572, 'pjField', 1, 'title', '$ 500 - $ 1,000', 'script'),
(NULL, 573, 'pjField', 1, 'title', '$ 1,000 - $ 1,500', 'script'),
(NULL, 574, 'pjField', 1, 'title', '> $ 1,500', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Winter', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Spring', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Summer', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Autumn', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Input data is not valid.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Your request has been sent successfully to the package owner.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Sorry! An error occurred and the request could not be sent.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'The comment data is invalid.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'You comment has been posted successfully. Please wait for administrator''s confirmation to have the comment shown.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Your comment has posted successfully.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Some error occurred! The comment could not be saved correctly.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Comment is required.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Re-type password does not match.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Re-type password is required.', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'per night', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'total price', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Based on expiration date', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Re-type password is missing.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Re-type password cannot be empty.', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Re-type password does not match.', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Email was already used.', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Your account has been created successfully, but needs to be approved and activated by the website administrator first.', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Your account has been created successfully. You can log in and start submitting your travel packages.', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Filter by', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Season', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Clear', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Filter', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Photo', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'Not active', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Sort by', 'script');
INSERT INTO `vacationpackages_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 835, 'pjField', 1, 'title', 'Show', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'packages', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'per page', 'script'),
(NULL, 838, 'pjField', 1, 'title', '10 packages', 'script'),
(NULL, 839, 'pjField', 1, 'title', '20 packages', 'script'),
(NULL, 840, 'pjField', 1, 'title', '30 packages', 'script'),
(NULL, 841, 'pjField', 1, 'title', '50 packages', 'script'),
(NULL, 842, 'pjField', 1, 'title', '100 packages', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'type Country and/or city', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'top', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Price warning', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Overlapping prices can lead to unexpected results.', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Date/time', 'script'),
(NULL, 912, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 914, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 915, 'pjField', 1, 'title', 'Enquiry', 'script'),
(NULL, 916, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 917, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 918, 'pjField', 1, 'title', 'Most popular', 'script'),
(NULL, 919, 'pjField', 1, 'title', 'Latest enquiries', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'Latest comments', 'script'),
(NULL, 921, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'No enquiry found', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'nights', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'night', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'No package found.', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'No comment found', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'You need to add at least one type. Click {ADD_TYPE_TAG}here{ADD_TYPE_ENDTAG} to add.', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'Flight Details', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'If there is a flight that is available along with the package, then choose â€˜Yesâ€™ for Flight Included option and fill in the flight details and conditions. By default at the front-end will show airplane icon and â€˜Flight includedâ€™ text on the package listing. If you need to change the â€˜Flight includedâ€™ text then go to Options menu -> Languages Tab, search for this front-end title and edit it.', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'Amenities / Features', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'You can use the pre-defined list of features below to describe in brief the accommodation amenities or package features. To manage the list with pre-defined features go to Options menu -> Features tab.', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Package Owner', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'If you have â€˜Ownerâ€™ type of users into the system, then you can assign an owner to a package. If owners submit packages through their accounts then an owner and a package will be linked together automatically.', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'SEO settings', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your package details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your package details pages.', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with package listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 942, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'Show all', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Show less', 'script'),
(NULL, 945, 'pjField', 1, 'title', 'review', 'script'),
(NULL, 946, 'pjField', 1, 'title', 'Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. ', 'script'),
(NULL, 947, 'pjField', 1, 'title', 'Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. ', 'script'),
(NULL, 948, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 949, 'pjField', 1, 'title', 'Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non mauris vitae erat consequat auctor eu in elit. ', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'Forgot password email', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'Available tokens:\r\n\r\n{Password} - Password', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 956, 'pjField', 1, 'title', 'Email does not exist.', 'script'),
(NULL, 957, 'pjField', 1, 'title', 'The password has been sent to you email.', 'script'),
(NULL, 958, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 959, 'pjField', 1, 'title', '(empty date)', 'script'),
(NULL, 960, 'pjField', 1, 'title', '(invalid date)', 'script'),
(NULL, 961, 'pjField', 1, 'title', '(empty date time)', 'script'),
(NULL, 962, 'pjField', 1, 'title', '(invalid date time)', 'script'),
(NULL, 963, 'pjField', 1, 'title', 'The system auto fills a random ID. You can replace it with an ID of your choice any time.', 'script'),
(NULL, 964, 'pjField', 1, 'title', 'Featured packages go at the top of all listed packages and are marked as such. There is also a separate Featured Packages listing formed by the packages marked as â€˜featuredâ€™ that can be integrated on website page, other than the main packages listing. See Install menu for Featured Packages integration code.', 'script'),
(NULL, 965, 'pjField', 1, 'title', 'Choose Yes/No to show/hide the owner contact information on the package details page.', 'script'),
(NULL, 966, 'pjField', 1, 'title', 'Note that the city you enter will be used on Filter by Location autofill filter field at the front-end. Keep the same cites written consistently. â€˜NYâ€™ and â€˜New Yorkâ€™ are recognized as two different cities by the system.', 'script'),
(NULL, 967, 'pjField', 1, 'title', 'Give a title to your package details web page. For search engines it is highly recommended to have nice, descriptive title with your main keyword phrase. It will also appear in browser headers.\r\n', 'script'),
(NULL, 968, 'pjField', 1, 'title', 'This meta tag has lost its importance. You can leave it empty or use it to lit your keywords. Use comma to separate you keyword phrases.', 'script'),
(NULL, 969, 'pjField', 1, 'title', 'Write a short description of what is your web page (vacation package) for. It is best if you limit your description to 160 characters (with the spaces).', 'script'),
(NULL, 970, 'pjField', 1, 'title', 'that will show on all website and admin panel calendars and date pickers.', 'script'),
(NULL, 971, 'pjField', 1, 'title', 'that will show on all website and admin panel calendars and date pickers.', 'script'),
(NULL, 972, 'pjField', 1, 'title', 'Set the default currency for the whole system (front-end and admin panel).', 'script'),
(NULL, 973, 'pjField', 1, 'title', 'This email will be sent to owners, right after someone sends an enquiry about their package. If there is no owner assigned to a package this email notification will be send to the admin.', 'script'),
(NULL, 974, 'pjField', 1, 'title', 'This email will be sent to owners, right after someone posts a comment about their package. If there is no owner assigned to a package this email notification will be send to the admin.', 'script'),
(NULL, 975, 'pjField', 1, 'title', 'This email notification will be sent to the system admin, right after an owner registers a new account.', 'script'),
(NULL, 976, 'pjField', 1, 'title', 'This email will be sent to anyone who has requested a password recovery.', 'script'),
(NULL, 977, 'pjField', 1, 'title', 'Unlimited', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'Set the email which users will see when they receive emails from the system. Go to Emails menu to manage automated email notifications.', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'If you choose ''Yes'' new owner accounts will be active immediately after they are created. If you choose ''No'' you will have to activate new accounts manually (through Users menu), and after that owners will be able to log in and use them.', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'Manage system users', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'There are 3 user roles with different access rights. ''Admins'' have full access to the system admin panel. ''Editors'' have limited access. Editors cannot set the general and submission website options; they do not have an access to the Translate and Backup menus; and they cannot manage admin and other editors'''' user accounts. ''Owners'' can add and manage only their packages and the comments and enquiries received about them. Through Options menu -> Submissions tab you can allow/disallow owners to register and create accounts through the front-end.', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Add new package', 'script'),
(NULL, 1000, 'pjField', 1, 'title', 'Start submitting your package with choosing its type and reference ID. Both of them are mandatory fields. The system assigns a Reference ID automatically, but you can edit it anytime.', 'script'),
(NULL, 1001, 'pjField', 1, 'title', 'Package Summary', 'script'),
(NULL, 1002, 'pjField', 1, 'title', 'Pay attention to Expire date status. If it says â€˜Not activeâ€™ then your package is not published on the website listing yet. Click on â€˜Publishâ€™ button and choose the appropriate submission period for you. If there is a specific date as a status, then your package will be live on the website listing till that date. You can extend that period by clicking on â€˜Extend expire dateâ€™ button. If the status says â€˜Unlimitedâ€™, then the package will be live until not deleted.', 'script'),
(NULL, 1003, 'pjField', 1, 'title', 'Flight Details', 'script'),
(NULL, 1004, 'pjField', 1, 'title', 'If there is a flight that is available along with the package, then choose â€˜Yesâ€™ for Flight Included option and fill in the flight details and conditions.', 'script'),
(NULL, 1005, 'pjField', 1, 'title', 'Amenities / Features', 'script'),
(NULL, 1006, 'pjField', 1, 'title', 'You can use the pre-defined list of features below to describe in brief the accommodation amenities or package features.', 'script'),
(NULL, 1007, 'pjField', 1, 'title', 'Package Owner', 'script'),
(NULL, 1008, 'pjField', 1, 'title', 'Choose whether you wish to show your contact detail on package details page or not. You can edit your contact details on Profile menu.', 'script'),
(NULL, 1009, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 1010, 'pjField', 1, 'title', 'The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emailsâ€™ subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized.', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'reviews', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'View All Reviews', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'type Country and/or city', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'Integration method', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'All languages on 1 page', 'script'),
(NULL, 1086, 'pjField', 1, 'title', 'Each language on separate page', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'If the number of the packages marked as featured is bigger than the one set here, then they will show on random basis in the Featured Packages listing.', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'Comment is missing.', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'Comment cannot be empty.', 'script'),
(NULL, 1, 'pjNotification', 1, 'confirm_subject', 'New enquiry has been received', 'script'),
(NULL, 1, 'pjNotification', 1, 'confirm_message', 'Dear {OwnerName},\r\n\r\nYou have just received the following enquiry for {ListingID} package:\r\n\r\nEnquiry ID : {EnquiryID}\r\nFrom: {FullName}\r\nE-mail: {Email}\r\nPhone number: {Phone}\r\nAbout: {ListingTitle}, {ListingID} package\r\nCheck-in date: {StartDate}\r\nCheck-out date: {EndDate}\r\nNotes: {Notes}\r\n\r\nThanks.\r\n', 'script'),
(NULL, 1, 'pjNotification', 1, 'notify_subject', 'New vacation package comment has been received', 'script'),
(NULL, 1, 'pjNotification', 1, 'notify_message', 'Dear {OwnerName},\r\n\r\nA new comment about your {RefID} vacation package has been just posted.\r\n\r\nFrom: {Name}\r\nE-mail: {Email} \r\nAbout: {ListingTitle}, {RefID} package\r\nRating: {Rating}\r\nComment Title: {Title}\r\nComment: {Comment}\r\n\r\nThanks.\r\n\r\n', 'script'),
(NULL, 1, 'pjNotification', 1, 'new_account_subject', 'New owner account was created', 'script'),
(NULL, 1, 'pjNotification', 1, 'new_account_message', 'Dear admin,\r\n\r\nA new owner account was just registered by:\r\nName: {Name}\r\nEmail: {Email}\r\n\r\nGo to the admin panel for more details and if activation/de-activation is needed.\r\n\r\nThanks.', 'script'),
(NULL, 1, 'pjNotification', 1, 'forgot_subject', 'Password recovery', 'script'),
(NULL, 1, 'pjNotification', 1, 'forgot_message', 'Dear,\r\n\r\nWe have received a password recovery request by this email. Please, find below your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks.', 'script');

INSERT INTO `vacationpackages_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_layout', 1, 'layout_1|layout_2::layout_1', 'Layout 1|Layout 2', 'enum', 1, 1, NULL),
(1, 'o_currency', 1, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 2, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 3, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 4, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 5, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 6, 1, NULL),
(1, 'o_items_per_page', 1, '10', NULL, 'int', 7, 1, NULL),
(1, 'o_featured_properties', 1, '5', NULL, 'int', 8, 1, NULL),
(1, 'o_comment_default_status', 1, 'Confirmed|New::New', 'When posted|After approval', 'enum', 9, 1, NULL),
(1, 'o_comment_and_rating', 1, 'Show|Hide::Show', NULL, 'enum', 10, 1, NULL),
(1, 'o_email_address', 1, NULL, NULL, 'string', 11, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 12, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 13, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 15, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_add_package', 2, 'Yes|No::Yes', NULL, 'enum', 1, 1, NULL),
(1, 'o_owner_is_active', 2, 'Yes|No::No', NULL, 'enum', 2, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 3, 1, NULL),
(1, 'o_listing_page', 99, 'http://localhost/SCRIPTS/VacationPackages/testpage.php', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `vacationpackages_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');