<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function toAscii($email)
	{
		$output = '';
		$iCnt = strlen($email);
		for ($i = 0; $i < $iCnt; $i += 1)
		{
			$output .= sprintf('&#%s;', ord($email[$i]));
		}
	
		return $output;
	}
	static public function getPageURL()
	{
		$pageURL = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
		if ($_SERVER["SERVER_PORT"] != "80")
		{
			$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		}
		else
		{
			$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		return $pageURL;
	}
	
	static public function getPricesFilter()
	{
		return array(
			1 => array(100, 500),
			2 => array(500, 1000),
			3 => array(1000, 1500),
			4 => array(1500, 9999999)
		);
	}
	
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}

	static public function html2txt($document){
		$search = array('@<script[^>]*?>.*?</script>@si', 
		               '@<[\/\!]*?[^<>]*?>@si',           
		               '@<style[^>]*?>.*?</style>@siU',   
		               '@<![\s\S]*?--[ \t\n\r]*>@'    
		);
		$text = preg_replace($search, '', $document);
		return $text;
	}
	
	static public function truncateDescription($string, $limit, $break=".", $pad="..."){
		if(strlen($string) <= $limit) 
			return $string;  
		if(false !== ($breakpoint = strpos($string, $break, $limit))) 
		{ 
			if($breakpoint < strlen($string) - 1) 
			{ 
				$string = substr($string, 0, $breakpoint) . $pad; 
			} 
		} 
		return $string;
	}
	
	static public function printRating($rating)
	{
		?>
		<div class="vpl-comment-rating">
			<?php
			for($i = 1; $i <= 5; $i++)
			{
				if($i <= $rating)
				{
					?><span class="yellow-star"></span><?php
				}else{
					?><span></span><?php
				}	
			} 
			?>
		</div>
		<?php
	}
	
	static public function getTotalDuration($start, $end)
	{
		$diff = array();
		
		$one_hour = 60*60; 
		$start = strtotime($start);
		$end = strtotime($end);
		if($end - $start >= 0)
		{
			$diff['hours'] = floor(($end - $start)/$one_hour);
			$diff['mins'] = floor((($end - $start)%$one_hour) / 60);
		}
		return $diff;
	}
	
	static public function buildFrontUrl($base_url, $get)
	{
		$url = $base_url;
		if(isset($get['view']))
		{
			$url .= '&view=' . $get['view'];
		}
		if(isset($get['item_per_page']))
		{
			$url .= '&item_per_page=' . $get['item_per_page'];
		}
		if(isset($get['sortby']))
		{
			$url .= '&sortby=' . $get['sortby'];
		}
		if(isset($get['direction']))
		{
			$url .= '&direction=' . $get['direction'];
		}
		if(isset($get['pjPage']))
		{
			$url .= '&pjPage=' . $get['pjPage'];
		}
		if(isset($get['listing_search']))
		{
			$url .= '&listing_search=' . $get['listing_search'];
		}
		if(isset($get['location']) && pjUtil::isValidParam($get['location']))
		{
			$url .= '&location=' . $get['location'];
		}
		if(isset($get['season']))
		{
			$url .= '&season=' . $get['season'];
		}
		if(isset($get['type']))
		{
			$url .= '&type=' . $get['type'];
		}
		if(isset($get['price_from']))
		{
			$url .= '&price_from=' . $get['price_from'];
		}
		if(isset($get['price_to']))
		{
			$url .= '&price_to=' . $get['price_to'];
		}
		if(isset($get['rating_from']))
		{
			$url .= '&rating_from=' . $get['rating_from'];
		}
		if(isset($get['rating_to']))
		{
			$url .= '&rating_to=' . $get['rating_to'];
		}
		
		return $url;
	}
	
	static public function getSortingUrl($url)
	{
		$sorting_url = $url;
		$sorting_url = str_replace('&sortby=price', '', $sorting_url);
		$sorting_url = str_replace('&sortby=stars', '', $sorting_url);
		$sorting_url = str_replace('&direction=asc', '', $sorting_url);
		$sorting_url = str_replace('&direction=desc', '', $sorting_url);
		return $sorting_url;
	}
	
	static public function isValidParam($str) 
	{
	    return !preg_match('/[^A-Za-z0-9.#\\-$]/', $str);
	}
		
}
?>