<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminComments extends pjAdmin
{
	public function pjActionDeleteComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjCommentModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteCommentBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjCommentModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportComment()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjCommentModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Comments-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjCommentModel = pjCommentModel::factory()->join('pjListing', 't2.id=t1.listing_id');
			
			if (isset($_GET['listing_id']) && (int) $_GET['listing_id'] > 0)
			{
				$pjCommentModel->where('t1.listing_id', $_GET['listing_id']);
			}
				
			if (isset($_GET['status']) && !empty($_GET['status']))
			{
				$pjCommentModel->where('t1.status', $_GET['status']);
			}
			
			if ($this->isOwner())
			{
				$pjCommentModel->where('t2.owner_id', $this->getUserId());
			}
			
			$column = 't1.created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjCommentModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjCommentModel->select('t1.id, t1.listing_id, t1.status, t1.title, t1.name, t1.email, t2.listing_refid, t1.created')
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();

			foreach($data as $k => $v)
			{
				$v['created'] = pjUtil::formatDate(date('Y-m-d', strtotime($v['created'])), 'Y-m-d', $this->option_arr['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($v['created'])), 'H:i:s', $this->option_arr['o_time_format']);
				$data[$k] = $v;
			}
			$data = pjSanitize::clean($data);
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
			
		if ($this->isAdmin() || $this->isOwner() || ($this->isOwner() && $this->option_arr['o_allow_add_package'] == 'Yes'))
		{
			$pjListingModel = pjListingModel::factory()
				->select('t1.id, t1.listing_refid, t2.content AS title')
				->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left')
				->orderBy('title ASC, t1.listing_refid ASC');
			if ($this->isOwner())
			{
				$pjListingModel->where('t1.owner_id', $this->getUserId());
			}
			$listing_arr = $pjListingModel->findAll()->getData();
			$listing_arr = pjSanitize::clean($listing_arr);
			$this->set('listing_arr', $listing_arr);

			$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminComments.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjCommentModel = pjCommentModel::factory();
			
			$enquiry = $pjCommentModel
				->select('t1.*, t2.owner_id')
				->join('pjListing', 't2.id=t1.listing_id')
				->find($_GET['id'])->getData();
			
			$pjCommentModel->reset()->set('id', $_GET['id'])->modify(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isOwner() || ($this->isOwner() && $this->option_arr['o_allow_add_package'] == 'Yes'))
		{
			$pjCommentModel = pjCommentModel::factory();

			$comment = $pjCommentModel
				->select("t1.*")
				->join('pjListing', 't2.id=t1.listing_id')
				->find($_REQUEST['id'])->getData();

			if (empty($comment) || count($comment) == 0)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminComments&action=pjActionIndex&err=AC08");
			}
						
			$property = pjListingModel::factory()->find($comment['listing_id'])->getData();
			
			if (empty($property) || count($property) == 0)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminComments&action=pjActionIndex&err=AC09");
			}
			
			if ($this->isOwner())
			{
				if ($property['owner_id'] != $this->getUserId())
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminComments&action=pjActionIndex&err=AC10");
				}
			}
			
			if (isset($_POST['comment_update']))
			{
				$data = array();
				
				$post = array_merge($_POST, $data);
				
				if (!$pjCommentModel->validates($post))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminComments&action=pjActionIndex&err=AC02");
				}
				$pjCommentModel->reset()->set('id', $_POST['id'])->modify($post);
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminComments&action=pjActionIndex&err=AC01");
			} else {
				$this->set('arr', $comment);
			}
			
			$pjListingModel = pjListingModel::factory();
			if ($this->isOwner())
			{
				$pjListingModel->where('t1.owner_id', $this->getUserId());
			}
			$this->set('listing_arr', $pjListingModel
				->select('t1.id, t1.listing_refid, t2.content AS title')
				->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left')
				->orderBy('title ASC')
				->findAll()->getData()
			);
						
			$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminComments.js');
			
		} else {
			$this->set('status', 2);
		}
	}
}
?>