<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjCommentModel extends pjAppModel
{
	protected $primaryKey = 'id';

	protected $table = 'comments';

	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'listing_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'title', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'email', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'rating', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'comment', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'New')
	);

	protected $validate = array(
		'rules' => array(
			'listing_id' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'name' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'email' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'title' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'comment' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'status' => 'pjActionRequired'
		)
	);

	public static function factory($attr=array())
	{
		return new pjCommentModel($attr);
	}
}
?>