<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjListingModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'listings';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'owner_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'type_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'country_id', 'type' => 'int', 'default' => ':NULL'),

		array('name' => 'flight_included', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'outbound_from', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'outbound_to', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'outbound_departs', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'outbound_arrives', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'inbound_from', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'inbound_to', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'inbound_departs', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'inbound_arrives', 'type' => 'datetime', 'default' => ':NULL'),
				
		array('name' => 'address_map', 'type' => 'tinyint', 'default' => '0'),
		array('name' => 'address_postcode', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_content', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'address_city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_state', 'type' => 'varchar', 'default' => ':NULL'),
				
		array('name' => 'listing_refid', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_rating', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_season', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_nights', 'type' => 'int', 'default' => ':NULL'),
		
		array('name' => 'contact_show', 'type' => 'tinyint', 'default' => '0'),
		array('name' => 'owner_show', 'type' => 'enum', 'default' => 'T'),
		
		array('name' => 'lat', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'lng', 'type' => 'varchar', 'default' => ':NULL'),
		
		array('name' => 'views', 'type' => 'int', 'default' => '0'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'modified', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'expire', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'last_extend', 'type' => 'enum', 'default' => 'free'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'T'),
		array('name' => 'is_featured', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'added_by', 'type' => 'enum', 'default' => 'other')
	);
	
	public $i18n = array('title', 'description', 'terms', 'checkin', 'checkout', 'pets', 'policies', 'fees', 'meta_title', 'meta_keywords', 'meta_description');
	
	protected $validate = array(
		'rules' => array(
			'type_id' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'listing_refid' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'status' => 'pjActionRequired'
		)
	);
	
	public static function factory($attr=array())
	{
		return new pjListingModel($attr);
	}
}
?>