<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat packages">
				<div class="info">
					<abbr><?php echo $tpl['number_of_packages'];?></abbr>
					<?php echo (int) $tpl['number_of_packages'] !== 1 ? strtolower(__('lblDashPackages', true)) : strtolower(__('lblDashPackages', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat enquiries">
				<div class="info">
					<abbr><?php echo $tpl['number_of_enquiries'];?></abbr>
					<?php echo (int) $tpl['number_of_enquiries'] !== 1 ? strtolower(__('lblDashEnquiries', true)) : strtolower(__('lblDashEnquiry', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat comments">
				<div class="info">
					<abbr><?php echo $tpl['number_of_comments'];?></abbr>
					<?php echo (int) $tpl['number_of_comments'] !== 1 ? strtolower(__('lblDashComments', true)) : strtolower(__('lblDashComment', true)); ?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashMostPopular'); ?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestEnquiries'); ?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestComments'); ?></div>
		</div>
		
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<?php
				
				$cnt = count($tpl['listing_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblListingNotFound'); ?></p><?php
				}else{
					foreach ($tpl['listing_arr'] as $k => $v)
					{
						?>
						<div class="dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<div class="dashboard_listing_left">
								<div><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']; ?>"><img src="<?php echo PJ_INSTALL_URL . (!empty($v['pic']) ? $v['pic'] :  PJ_IMG_PATH . 'backend/no_img.png'); ?>" alt="" /></a></div>
								<div class="t5"><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']; ?>" class="no-decor"><?php echo pjSanitize::html(stripslashes($v['title'])); ?></a></div>
								<div class="t5"><?php
								$package_info = array($v['type'], $v['address_city']);
								foreach ($package_info as $key => $val)
								{
									if (empty($val))
									{
										unset($package_info[$key]);
									} else {
										$package_info[$key] = pjSanitize::html($val);
									}
								}
								echo join(", ", array_map('stripslashes', $package_info)); ?></div>
							</div>
							<div class="dashboard_listing_right">
								<div class="dashboard_listing_stat"><abbr><?php echo (int) $v['views']; ?></abbr><?php echo (int) $v['views'] !== 1 ? strtolower(__('lblDashViews', true)) : strtolower(__('lblDashView', true)); ?></div>
								<div class="dashboard_listing_stat"><abbr><?php echo (int) $v['enquiries']; ?></abbr><?php echo (int) $v['enquiries'] !== 1 ? strtolower(__('lblDashEnquiries', true)) : strtolower(__('lblDashEnquiry', true)); ?></div>
							</div>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['enquiry_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblEnquiryNotFound'); ?></p><?php
				}
				foreach ($tpl['enquiry_arr'] as $k => $item)
				{
					$nights = (strtotime($item['date_to']) - strtotime($item['date_from'])) / 86400;
					?>
					<div class="dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
						<div class="dashboard_enquiry_left">
							<div class="bold fs13 lh19"><?php echo pjSanitize::html(stripslashes($item['name'])); ?></div>
							<div class="t5 b5 gray"><a class="no-decor" href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&amp;action=pjActionUpdate&amp;id=<?php echo $item['id']; ?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($item['created'])); ?></a></div>
							<?php echo pjSanitize::html(stripslashes($item['title'])); ?>
						</div>
						<div class="dashboard_enquiry_right"><abbr><?php echo $nights; ?> </abbr><?php (int) $nights !== 1 ? __('lblDashNights') : __('lblDashNight'); ?></div>
					</div>
					<?php
				}
				?>
			</div>
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['comment_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblCommentNotFound'); ?></p><?php
				}
				foreach ($tpl['comment_arr'] as $k => $item)
				{
					?>
					<div class="dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
						
						<div class="bold fs13 lh19"><a class="no-decor" href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminComments&amp;action=pjActionUpdate&amp;id=<?php echo $item['id']; ?>"><?php echo pjSanitize::html(stripslashes($item['title'])); ?></a></div>
						<div class="t5 b5 bold"><?php echo pjSanitize::html(stripslashes($item['name'])); ?></div>
						<div class="t5 b5 gray"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($item['created'])); ?></div>
						<?php echo pjSanitize::html(stripslashes($item['package_title'])); ?>
						
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	<?php
}
?>