<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	pjUtil::printNotice(__('infoUpdateEnquiryTitle', true), __('infoUpdateEnquiryDesc', true));
	?>

	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEnquiries&amp;action=pjActionUpdate" method="post" id="frmUpdateEnquiry" class="form pj-form">
		<input type="hidden" name="enquiry_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		
		<div class="clear_both">
			<p style="overflow: visible">
				<label class="title"><?php __('lblEnquiryPackage'); ?></label>
				<span class="inline_block">
					<select name="listing_id" id="listing_id" class="pj-form-field w300 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						if (isset($tpl['listing_arr']) && count($tpl['listing_arr']) > 0)
						{
							foreach ($tpl['listing_arr'] as $v)
							{
								if($v['id'] == $tpl['arr']['listing_id'])
								{
									?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo pjMultibyte::substr(stripslashes($v['title'] . sprintf(" (%s)", $v['listing_refid'])), 0, 50); ?></option><?php
								}else{
									?><option value="<?php echo $v['id']; ?>"><?php echo pjMultibyte::substr(stripslashes($v['title'] . sprintf(" (%s)", $v['listing_refid'])), 0, 50); ?></option><?php
								}
							}
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEnquiryStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field w220 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach (__('enquiry_statuses', true) as $k => $v)
						{
							if($k == $tpl['arr']['status'])
							{
								?><option value="<?php echo $k; ?>" selected="selected"><?php echo stripslashes($v); ?></option><?php
							}else{
								?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
							}
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEnquiryFrom'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="date_from" id="date_from" class="pj-form-field pointer w80 required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($tpl['arr']['date_from'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEnquiryTo'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="date_to" id="date_to" class="pj-form-field pointer w80 required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($tpl['arr']['date_to'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</p>
			
			<p>
				<label class="title"><?php __('lblEnquiryName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" id="name" value="<?php echo stripslashes($tpl['arr']['name']);?>" class="pj-form-field w200 required" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEnquiryEmail'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" value="<?php echo stripslashes($tpl['arr']['email']);?>"  class="pj-form-field email w200" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEnquiryPhone'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
					<input type="text" name="phone" id="phone" value="<?php echo stripslashes($tpl['arr']['phone']);?>"  class="pj-form-field w200" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEnquiryNotes'); ?>:</label>
				<span class="inline_block">
					<textarea name="notes" class="pj-form-field w500 h80"><?php echo stripslashes($tpl['arr']['notes']);?></textarea>
				</span>
			</p>
				
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('vk_field_required'); ?>";
	myLabel.email_invalid = "<?php __('vk_email_invalid'); ?>";
	
	</script>
	<?php
}
?>