var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var
			$frmUpdateComment = $("#frmUpdateComment"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			dialog = ($.fn.dialog !== undefined),
			chosen = ($.fn.chosen !== undefined);

		if ($frmUpdateComment.length > 0 && validate) {
			$frmUpdateComment.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore"
			});
			
		}

		if (chosen) {
			$("#listing_id").chosen();
		}
		
		var $frmFilter = $(".frm-filter");
		if ($frmFilter.length > 0) {
			$frmFilter.on("change", "select[name='listing_id']", function (e) {
				$frmFilter.submit();	
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function formatComment (val, obj) {
				return ['<a href="index.php?controller=pjAdminComments&action=pjActionUpdate&id=', obj.id,'">', val, '</a>'].join("");
			}
			function formatListing (val, obj) {
				return ['<a href="index.php?controller=pjAdminListings&action=pjActionUpdate&id=', obj.listing_id,'">', val, '</a>'].join("");
			}
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminComments&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminComments&action=pjActionDeleteComment&id={:id}"}
				          ],
				columns: [{text: myLabel.title, type: "text", sortable: true, editable: false, renderer: formatComment},
				          {text: myLabel.datetime, type: "text", sortable: true, editable: false},
				          {text: myLabel.listing, type: "text", sortable: true, editable: false, width: 160, renderer: formatListing},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 110, options: [
				                                                                                     {label: myLabel.new_stat, value: "New"}, 
				                                                                                     {label: myLabel.confirmed_stat, value: "Confirmed"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminComments&action=pjActionGetComment" + pjGrid.queryString,
				dataType: "json",
				fields: ['title', 'created', 'listing_refid', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.export_selected, url: "index.php?controller=pjAdminComments&action=pjActionExportComment", ajax: false},
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminComments&action=pjActionDeleteCommentBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminComments&action=pjActionSaveComment&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
			
			$(document).on("click", ".btn-all", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-hover").siblings(".pj-button").removeClass("pj-button-hover");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					status: ""
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-confirmed", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-hover").siblings(".pj-button").removeClass("pj-button-hover");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					status: "Confirmed"
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-new", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-hover").siblings(".pj-button").removeClass("pj-button-hover");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					status: "New"
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("submit", ".frm-filter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					listing_id: $this.find("option:selected", "select[name='listing_id']").val()
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "ASC", content.page, content.rowCount);
				return false;
			});
			
		}
		
		$(document).on("click", ".pj-form-field-icon-date", function (e) {
			$(this).parent().siblings("input[type='text']").datepicker("show");
		}).on("click change", "#dialog_confirm", function (e) {
			if ($(this).is(":checked")) {
				$dialogMessage.find("textarea").prop("readonly", false).removeClass("pj-form-field-readonly")
					.end().find("input[type='text']").prop("readonly", false).removeClass("pj-form-field-readonly");
			} else {
				$dialogMessage.find("textarea").prop("readonly", true).addClass("pj-form-field-readonly")
					.end().find("input[type='text']").prop("readonly", true).addClass("pj-form-field-readonly");
			}
		});
	});
})(jQuery_1_8_2);