var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmEmails = $("#frmEmails"),
			validate = ($.fn.validate !== undefined),
			dialog = ($.fn.dialog !== undefined),
			$dialogDeletePeriod = $("#dialogDeletePeriod"),
			tipsy = ($.fn.tipsy !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		$(".field-int").spinner({
			min: 0
		});
		
		function setListingInstall(locale_id)
		{
			var clone_text = $("#listing_clone_text").val();
			
			if(locale_id > 0)
			{
				clone_text = clone_text.replace('{LANG}', '$pjLang = ' + locale_id + ';');
			}else{
				$("#install_language").css('display', 'none');
				clone_text = clone_text.replace('{LANG}', '');
			}
			$("#listing_install_text").val(clone_text);
		}
		
		function setFeaturedInstall(locale_id)
		{
			var clone_text = $("#featured_clone_text").val();
			
			if(locale_id > 0)
			{
				clone_text = clone_text.replace('{LANG}', '$pjLang = ' + locale_id + ';');
			}else{
				$("#install_language_featured").css('display', 'none');
				clone_text = clone_text.replace('{LANG}', '');
			}
			$("#featured_install_text").val(clone_text);
		}
		
		if($('#listing_install_text').length > 0)
		{
			setListingInstall(0);
			setFeaturedInstall(0);
		}
				
		if (tipsy) {
			$(".center-langbar-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				className: "tipsy-listing-center"
			});
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		
		if ($frmEmails.length > 0 && validate) {
			$frmEmails.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				errorClass: "err",
				wrapper: "em",
				onkeyup: false,
				ignore: ".ignore",
				invalidHandler: function (event, validator) {
				    $(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
			
			
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("click", ".btnAddPeriod", function () {
			var $c = $("#tblPeriodClone tbody").clone(),
			r = $c.html().replace(/\{INDEX\}/g, 'new_' + Math.ceil(Math.random() * 99999));
			$(this).closest("form").find("table").find("tbody").append(r);
		}).on("click", ".btnDeletePeriod", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogDeletePeriod.length > 0 && dialog) {
				$dialogDeletePeriod.data("link", $(this)).dialog("open");
			}
			return false;
		}).on("click", ".btnRemovePeriod", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $tr = $(this).closest("tr");
			$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
				$tr.remove();
			});			
			return false;
		}).on("change", "select[name='integration_method']", function (e) {
			if($(this).val() == 'all')
			{
				$("#install_language").css('display', 'none');
				setListingInstall(0);
			}else{
				$("#install_language").css('display', 'inline-block');
				var locale_id =  parseInt($("#install_language").val(), 10);
				setListingInstall(locale_id);
			}
		}).on("change", "select[name='install_language']", function (e) {
			var locale_id =  parseInt($(this).val(), 10);
			setListingInstall(locale_id);
		}).on("change", "select[name='integration_method_featured']", function (e) {
			if($(this).val() == 'all')
			{
				$("#install_language_featured").css('display', 'none');
				setFeaturedInstall(0);
			}else{
				$("#install_language_featured").css('display', 'inline-block');
				var locale_id =  parseInt($("#install_language_featured").val(), 10);
				setFeaturedInstall(locale_id);
			}
		}).on("change", "select[name='install_language_featured']", function (e) {
			var locale_id =  parseInt($(this).val(), 10);
			setFeaturedInstall(locale_id);
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		});
		
		if ($dialogDeletePeriod.length > 0 && dialog) {
			var buttons = {};
			buttons[myLabel.btn_delete] = function () {
				var $this = $(this),
					$link = $this.data("link"),
					$tr = $link.closest("tr"),
					id = $link.data("id");
				
				$.post("index.php?controller=pjAdminOptions&action=pjActionDeletePeriod", {
					"id": id
				}).done(function (data) {
					if (data.code === undefined) {
						return;
					}
					switch (data.code) {
						case 200:
							$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
								$tr.remove();
								$this.dialog("close");
							});
							break;
					}
				});
			};
			buttons[myLabel.btn_cancel] = function () {
				$(this).dialog("close");
			};
			$dialogDeletePeriod.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				buttons: buttons,
				width: 350
			});
		}
	});
})(jQuery_1_8_2);