<div id="pjVpMapCanvas" class="col-md-12 col-sm-12 col-xs-12 pjVpMapCanvas"></div>
<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=<?php echo $tpl['option_arr']['o_google_map_api'];?>"></script>
<script type="text/javascript">
	var vpMap, vpBounds;
	function vpGoogleMapsInit() {
		var vpOptions = {
			zoom: 9,
			mapTvpeId: google.maps.MapTypeId.ROADMAP
		};
		vpMap = new google.maps.Map(document.getElementById("pjVpMapCanvas"), vpOptions);
		vpBounds = new google.maps.LatLngBounds();
	}
	function vpCodeAddress(lat, lng, contentString) 
	{
		var myLatlng = new google.maps.LatLng(lat, lng);
		vpMap.setCenter(myLatlng);
		
		var marker = new google.maps.Marker({
			map: vpMap,
			icon: '<?php echo PJ_INSTALL_URL . PJ_TEMPLATE_PATH;?>default/img/marker.png',
			position: myLatlng
		});
		if (contentString.length > 0 && contentString != "") {
			var infoWindow = new google.maps.InfoWindow({
				content: contentString
			});
			google.maps.event.addListener(marker, "click", function() {
				infoWindow.open(vpMap, marker);
			});
		}
		vpBounds.extend(myLatlng);
	}
	vpGoogleMapsInit();
	var vpPoints = [];

	<?php
	$vpAddressArr = array();
	foreach($tpl['arr'] as $v)
	{
		if($v['address_map'] != 1)
		{
			continue;
		}
		if(empty($v['lat']) || empty($v['lng']))
		{
			continue;
		}
		
		$address_str = '';
		
		$title = stripslashes($v['listing_title']);
		if ($tpl['option_arr']['o_seo_url'] == 'No')
		{
			$detail_url = $_SERVER['SCRIPT_NAME'] . '?controller=pjListings&amp;action=pjActionView&amp;id=' . $v['id'] .(isset($_GET['iframe']) ? '&amp;iframe' : NULL);
		} else {
			$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
			$path = $path == '/' ? '' : $path;
			$detail_url = $path .'/'. $controller->friendlyURL($v['listing_title']) . "-". $v['id'] . ".html";
		}
		
		$_SESSION[$controller->defaultBackUrl] = pjUtil::getPageURL();
		$price = 'n/a';
		if(!empty($v['max']) && !empty($v['min']))
		{
			if($v['max'] != $v['min'])
			{
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($v['max']), $tpl['option_arr']['o_currency']);
			}else{
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']);
			}
		}
		if(!empty($v['listing_nights']))
		{
			$nights = $v['listing_nights'];
			if($v['listing_nights'] > 1)
			{
				$nights .= ' ' . __('front_label_nights', true);
			}else{
				$nights .= ' ' . __('front_label_night', true);
			}
		}
		$address_arr = array();
		if(!empty($v['address_content']))
		{
			$address_arr[] = $v['address_content'];
		}
		if(!empty($v['address_city']))
		{
			$address_arr[] = $v['address_city'];
		}
		if(!empty($v['address_state']))
		{
			$address_arr[] = $v['address_state'];
		}
		if(!empty($v['country_title']))
		{
			$address_arr[] = $v['country_title'];
		}
				
		$vpAddress = array();
		$vpHtml = array();
		
		$vpAddress[] = stripslashes($v['address_postcode']);
		
		$vpHtml[] = '<div class="pjVpInfoWindow">';
		
		$vpHtml[] = '<label class="pjVpInfoTitle">' . $title . '</label>';
		
		if(!empty($address_arr))
		{
			$vpHtml[] = '<label class="pjVpInfoAddress">' . join(", ", $address_arr) . '</label>';
		}
		$vpHtml[] = '<label>' . __('front_label_price', true) . ": <span>" . $price . '</span></label>';
		
		if(isset($nights) && $v['flight_included'] == 'T')
		{
			$vpHtml[] = '<label>' . $nights . ', ' . __('front_label_flight_included', true) . '</label>';
		}else if(isset($nights)){
			$vpHtml[] = '<label>' . $nights . '</label>';
		}else if($v['flight_included'] == 'T'){
			$vpHtml[] = '<label>' . __('front_label_flight_included', true) . '</label>';
		}
		$vpHtml[] = '<a href="'.$detail_url.'">' . __('front_label_details', true) . '</a>';
		
		$vpHtml[] = '<\/div>';
		
		$vpAddress = preg_replace('/\r\n|\n|\t/', '', $vpAddress);
		$vpHtml = preg_replace('/\r\n|\n|\t/', '', $vpHtml);
		
		$vpAddress = str_replace('"', "\\\"", $vpAddress);
		$vpHtml = str_replace("'", "\'", $vpHtml);
	
		$vpAddressArr[] = '{"lat": "' . floatval($v['lat']) . '", "lng": "' . floatval($v['lng']) . '", "html": \'' . join("", $vpHtml) . '\'}';
	} 
	?>
	vpPoints.push(<?php echo join(', ', $vpAddressArr); ?>);
	for(i = 0, len = vpPoints.length; i < len; i++) 
	{
		vpCodeAddress(vpPoints[i].lat, vpPoints[i].lng, vpPoints[i].html);
	}
	vpMap.fitBounds(vpBounds);
</script>