<?php
if ($tpl['arr']['address_map'] == 1)
{ 
?>
	<div class="panel panel-default pjVpProductSection">
		<div class="panel-heading pjVpProductSectionHead">
			<h3 class="panel-title pjVpProductSectionTitle"><?php echo __('front_label_location'); ?></h3><!-- /.panel-title -->
		</div><!-- /.panel-heading pjVpProductSectionHead -->
		<div class="panel-body pjVpProductSectionBody">
			
			<div id="pjVpViewMapCanvas" class="col-md-9 col-sm-8 col-xs-12 pjVpProductSectionMap">
				<?php
				if (!empty($tpl['arr']['lat']) && !empty($tpl['arr']['lng']))
				{
					$address_arr = array();
					if(!empty($tpl['arr']['address_content']))
					{
						$address_arr[] = $tpl['arr']['address_content'];
					}
					if(!empty($tpl['arr']['address_postcode']))
					{
						$address_arr[] = $tpl['arr']['address_postcode'];
					}
					if(!empty($tpl['arr']['address_city']))
					{
						$address_arr[] = $tpl['arr']['address_city'];
					}
					if(!empty($tpl['arr']['country_title']))
					{
						$address_arr[] = $tpl['arr']['country_title'];
					}
					?>
					<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=<?php echo $tpl['option_arr']['o_google_map_api'];?>"></script>
					<script type="text/javascript">
					var vpMap;
					function vpGoogleMapsInit() {
						var vpOptions = {
							zoom: 12,
							mapTypeId: google.maps.MapTypeId.ROADMAP	
						};
						vpMap = new google.maps.Map(document.getElementById("pjVpViewMapCanvas"), vpOptions);
					}
					function vpCodeAddress(lat, lng, contentString) {
						var myLatlng = new google.maps.LatLng(lat, lng);
						vpMap.setCenter(myLatlng);
						var marker = new google.maps.Marker({
							map: vpMap,
							icon: '<?php echo PJ_INSTALL_URL . PJ_TEMPLATE_PATH;?>default/img/marker.png',
							position: myLatlng
						});
						if (contentString.length > 0 && contentString != "") {
							var infoWindow = new google.maps.InfoWindow({
								content: contentString
							});
							google.maps.event.addListener(marker, "click", function() {
								infoWindow.open(vpMap, marker);
							});
						}
					}
					<?php
					$vpHtml = $vpAddress = array();
					if (!empty($tpl['arr']['country_title']))
					{
						$vpAddress[] = stripslashes($tpl['arr']['country_title']);
					}
					if (!empty($tpl['arr']['address_state']))
					{
						$vpAddress[] = stripslashes($tpl['arr']['address_state']);
					}
					if (!empty($tpl['arr']['address_city']))
					{
						$vpAddress[] = stripslashes($tpl['arr']['address_city']);
					}
					if (!empty($tpl['arr']['address_postcode']))
					{
						$vpAddress[] = stripslashes($tpl['arr']['address_postcode']);
					}
					$vpHtml[] = '<div class="yp-info-window">';
					if (!empty($tpl['arr']['listing_title']))
					{
						$vpHtml[] = '<label class="yp-info-window-head">'.stripslashes($tpl['arr']['listing_title']).'<\/label>';
					}
					$vpHtml[] = '<div class="yp-info-window-block"><span>'. __('front_label_address', true) . '<\/span>: ' . join(", ", $vpAddress) . '<\/div>';
					
					$vpHtml[] = '<\/div>';
					?>
					vpGoogleMapsInit();
					vpCodeAddress(<?php echo $tpl['arr']['lat']; ?>, <?php echo $tpl['arr']['lng']; ?>, '<?php echo join("", $vpHtml); ?>');
					</script>
					<?php
				}
				
				?>
			</div><!-- /.col-md-9 col-sm-8 col-xs-12 pjVpProductSectionMap -->
			<?php
			if(!empty($address_arr))
			{
				?>
				<div class="col-md-3 col-sm-4 col-xs-12">
					<address class="pjVpProductSectionAddress">
						<i class="fa fa-map-marker"></i>
		
						<strong>
							<?php echo implode(", ", $address_arr) ;?>
						</strong>
					</address>
				</div><!-- /.col-md-3 col-sm-4 col-xs-12 -->
				<?php
			} 
			?>	
		</div><!-- /.panel-body pjVpProductSectionBody -->
	</div><!-- /.panel panel-default pjVpProductSection -->
	<?php
} 
?>