/*!
 * Vacation Packages Script v2.1
 * 
 * https://www.phpjabbers.com/vacation-packages/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	

	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined);
    
	function loadDelayedCSS(opts) {
		pjQ.$(window).load(function() {
			pjQ.$('body').append(pjQ.$('<link rel="stylesheet" type="text/css" />').attr('href', opts.server+'templates/default/css/transitions.css'));
		});
	}
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnYacht(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function VacationPackages(opts) {
		if (!(this instanceof VacationPackages)) {
			return new VacationPackages(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	VacationPackages.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	VacationPackages.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	VacationPackages.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;			
			this.opts = {};
			
			return this;
		},
		formatCurrency: function(price, currency)
		{
			var format = '---';
			switch (currency)
			{
				case 'USD':
					format = "$" + price;
					break;
				case 'GBP':
					format = "&pound;" + price;
					break;
				case 'EUR':
					format = "&euro;" + price;
					break;
				case 'JPY':
					format = "&yen;" + price;
					break;
				case 'AUD':
				case 'CAD':
				case 'NZD':
				case 'CHF':
				case 'HKD':
				case 'SGD':
				case 'SEK':
				case 'DKK':
				case 'PLN':
					format = price + currency;
					break;
				case 'NOK':
				case 'HUF':
				case 'CZK':
				case 'ILS':
				case 'MXN':
					format = currency + price;
					break;
				default:
					format = price + currency;
					break;
			}
			return format;
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjWrapper");
			this.$container = pjQ.$(this.container);
			
			loadDelayedCSS(opts);
			
			self.bindFilter();
			self.bindEnquiryForm();
			self.bindRating();
			self.bindCommentForm();
			self.bindLoginForm();
			self.bindForgotForm();
			self.bindRegisterForm();
			
			if(pjQ.$('.pjVpFancybox').length > 0)
			{
				pjQ.$(".pjVpFancybox").fancybox({
					openEffect	: 'none',
					closeEffect	: 'none'
				});
			}
			
			var $frmFilter = pjQ.$('#pjVpFilterForm_' + self.opts.index);
			
			this.$container.on('click.vp', '.pjVpShowFlightNotes', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var show = pjQ.$(this).attr('data-show');
				pjQ.$('.pjVpFlightNotes').hide();
				if(show == 'all')
				{
					pjQ.$('#pjVpFullNotes_' + self.opts.index).show();
				}else{
					pjQ.$('#pjVpShortNotes_' + self.opts.index).show();
				}
			}).on('click.vp', '.pjVpShowCheckinNotes', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var show = pjQ.$(this).attr('data-show');
				pjQ.$('.pjVpCheckinNotes').hide();
				if(show == 'all')
				{
					pjQ.$('#pjVpFullCheckinNotes_' + self.opts.index).show();
				}else{
					pjQ.$('#pjVpShortCheckinNotes_' + self.opts.index).show();
				}
			}).on('click.vp', '.pjVpShowCheckoutNotes', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var show = pjQ.$(this).attr('data-show');
				pjQ.$('.pjVpCheckoutNotes').hide();
				if(show == 'all')
				{
					pjQ.$('#pjVpFullCheckoutNotes_' + self.opts.index).show();
				}else{
					pjQ.$('#pjVpShortCheckoutNotes_' + self.opts.index).show();
				}
			}).on('click.vp', '.pjVpShowPetNotes', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var show = pjQ.$(this).attr('data-show');
				pjQ.$('.pjVpPetNotes').hide();
				if(show == 'all')
				{
					pjQ.$('#pjVpFullPetNotes_' + self.opts.index).show();
				}else{
					pjQ.$('#pjVpShortPetNotes_' + self.opts.index).show();
				}
			}).on('click.vp', '.pjVpShowPolicyNotes', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var show = pjQ.$(this).attr('data-show');
				pjQ.$('.pjVpPolicyNotes').hide();
				if(show == 'all')
				{
					pjQ.$('#pjVpFullPolicyNotes_' + self.opts.index).show();
				}else{
					pjQ.$('#pjVpShortPolicyNotes_' + self.opts.index).show();
				}
			}).on('click.vp', '.pjVpShowFeeNotes', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var show = pjQ.$(this).attr('data-show');
				pjQ.$('.pjVpFeeNotes').hide();
				if(show == 'all')
				{
					pjQ.$('#pjVpFullFeeNotes_' + self.opts.index).show();
				}else{
					pjQ.$('#pjVpShortFeeNotes_' + self.opts.index).show();
				}
			}).on("focusin.vp", ".pjVpCalendarInput", function (e) {
				var minDate, maxDate,
					$this = pjQ.$(this),
					custom = {},
					o = {
						firstDay: $this.attr("data-fday"),
						dateFormat: $this.attr("data-dformat"),
						minDate: '0',
						dayNames: ($this.data("day")).split(","),
					    monthNames: ($this.data("months")).split(","),
					    monthNamesShort: ($this.data("shortmonths")).split(","),
					    dayNamesMin: ($this.data("daymin")).split(","),
						beforeShow: function(input, inst) {
							pjQ.$('#ui-datepicker-div').addClass("pjVpjQueryUI");
						},
						onClose: function (dateText){
							var $frm = pjQ.$('#pjVpEnquiryForm_' + self.opts.index);
							if($frm.length > 0)
							{
								if(pjQ.$(".pjVpCalendarInput[name='date_from']").val() != '' && pjQ.$(".pjVpCalendarInput[name='date_to']").val() != '')
								{
									pjQ.$("input[name='period']").valid();
								}
							}
						}
				};
				switch ($this.attr("name")) {
				case "date_from":
					if(pjQ.$(".pjVpCalendarInput[name='date_to']").val() != '')
					{
						maxDate = pjQ.$(".pjVpCalendarInput[name='date_to']").datepicker({
							firstDay: $this.attr("data-fday"),
							dateFormat: $this.attr("data-dformat")
						}).datepicker("getDate");
						pjQ.$(".pjVpCalendarInput[name='date_to']").datepicker("destroy").removeAttr("id");
						if (maxDate !== null) {
							custom.maxDate = maxDate;
						}
					}
					break;
				case "date_to":
					if(pjQ.$(".pjVpCalendarInput[name='date_from']").val() != '')
					{
						minDate = pjQ.$(".pjVpCalendarInput[name='date_from']").datepicker({
							firstDay: $this.attr("data-fday"),
							dateFormat: $this.attr("data-dformat")
						}).datepicker("getDate");
						pjQ.$(".pjVpCalendarInput[name='date_from']").datepicker("destroy").removeAttr("id");
						if (minDate !== null) {
							custom.minDate = minDate;
						}
					}
					break;
				}
				pjQ.$(this).datepicker(pjQ.$.extend(o, custom));
			}).on("click.vp", ".pjVpCalendarTrigger", function (e) {
				var $dp = pjQ.$(this).next("input[type='text']");
				if ($dp.hasClass("hasDatepicker")) {
					$dp.datepicker("show");
				} else {
					$dp.trigger("focusin").datepicker("show");
				}
			}).on("click.vp", ".pjVpBtnFormTrigger", function (e) {
				var $formTrigger = pjQ.$(this);
				$formTrigger.parent().siblings('.pjVpFormComment').slideDown();
				$formTrigger.hide();
			}).on("click.vp", ".pjVpBtnFormRemove", function (e) {
				var $formClose = pjQ.$(this);
				$formClose.parents('.pjVpFormComment').slideUp();
				$formClose.parents('.pjVpFormComment').siblings('div').children('.pjVpBtnFormTrigger').show();
			}).on("click.vp", ".pjVpBtnSendEnquiry", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				window.location.href=pjQ.$(this).attr('data-url');
				return false;
			}).on("click.vp", "#pjVpCaptchaImage", function (e) {
				var $captcha = pjQ.$(this);
				$captcha.attr("src", $captcha.attr("src").replace(/(&rand=)\d+/g, '\$1' + Math.ceil(Math.random() * 99999)));
				pjQ.$('#pjVpCaptchaField').val("").removeData("previousValue");
			}).on("click.vp", "#pjVpCaptchaCommentImage", function (e) {
				var $captcha = pjQ.$(this);
				$captcha.attr("src", $captcha.attr("src").replace(/(&rand=)\d+/g, '\$1' + Math.ceil(Math.random() * 99999)));
				pjQ.$('#pjVpCaptchaCommentField').val("").removeData("previousValue");
			}).on("click.vp", ".pjVpSortLink", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if($frmFilter.length > 0)
				{
					if($frmFilter.find("input[name='column']").length > 0)
					{
						$frmFilter.find("input[name='column']").val(pjQ.$(this).attr('data-column'));
					}else{
						$frmFilter.append('<input type="hidden" name="column" value="'+pjQ.$(this).attr('data-column')+'"/>');
					}
					if($frmFilter.find("input[name='direction']").length > 0)
					{
						$frmFilter.find("input[name='direction']").val(pjQ.$(this).attr('data-direction'));
					}else{
						$frmFilter.append('<input type="hidden" name="direction" value="'+pjQ.$(this).attr('data-direction')+'"/>');
					}
					$frmFilter.submit();
				}
				
			}).on("click.vp", ".pjVpBtnView", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if($frmFilter.length > 0)
				{
					$frmFilter.find("input[name='view']").val(pjQ.$(this).attr('data-view'));
					$frmFilter.submit();
				}
			}).on("click.vp", ".pjVpFilterSeason", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if($frmFilter.length > 0)
				{
					self.removeSorting();
					if($frmFilter.find("input[name='season']").length > 0)
					{
						var season = $frmFilter.find("input[name='season']").val();
						season += "," + pjQ.$(this).attr('data-id');
						$frmFilter.find("input[name='season']").val(season);
					}else{
						$frmFilter.append('<input type="hidden" name="season" value="'+pjQ.$(this).attr('data-id')+'"/>');
					}
					$frmFilter.submit();
				}
			}).on("click.vp", ".pjVpFilterType", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if($frmFilter.length > 0)
				{
					self.removeSorting();
					if($frmFilter.find("input[name='type']").length > 0)
					{
						var type_id = $frmFilter.find("input[name='type']").val();
						type_id += "," + pjQ.$(this).attr('data-id');
						$frmFilter.find("input[name='type']").val(type_id);
					}else{
						$frmFilter.append('<input type="hidden" name="type" value="'+pjQ.$(this).attr('data-id')+'"/>');
					}
					$frmFilter.submit();
				}
			}).on("click.vp", ".pjVpPaging", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if($frmFilter.length > 0)
				{
					if($frmFilter.find("input[name='pjPage']").length > 0)
					{
						$frmFilter.find("input[name='pjPage']").val(pjQ.$(this).attr('data-page'));
					}else{
						$frmFilter.append('<input type="hidden" name="pjPage" value="'+pjQ.$(this).attr('data-page')+'"/>');
					}
					$frmFilter.submit();
				}
			}).on("click.vp", ".pjVpRemoveFilter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if($frmFilter.length > 0)
				{
					var field = pjQ.$(this).attr('data-field');
					if(field == 'price')
					{
						$frmFilter.find("input[name='price_from']").remove();
						$frmFilter.find("input[name='price_to']").remove();
					}else if(field == 'rating'){
						$frmFilter.find("input[name='rating_from']").remove();
						$frmFilter.find("input[name='rating_to']").remove();
					}else if(field == 'type'){
						var id_str = pjQ.$(this).attr('data-id');
						if(id_str == "")
						{
							$frmFilter.find("input[name='type']").remove();
						}else{
							$frmFilter.find("input[name='type']").val(id_str);
						}
					}else if(field == 'season'){
						var id_str = pjQ.$(this).attr('data-id');
						if(id_str == "")
						{
							$frmFilter.find("input[name='season']").remove();
						}else{
							$frmFilter.find("input[name='season']").val(id_str);
						}
					}else if(field == 'location'){
						$frmFilter.find("input[name='location']").remove();
					}
					
					$frmFilter.submit();
				}
			});
		},
		removeSorting: function()
		{
			var self = this;
			var $frmFilter = pjQ.$('#pjVpFilterForm_' + self.opts.index);
			if($frmFilter.find("input[name='column']").length > 0)
			{
				$frmFilter.find("input[name='column']").remove();
			}
			if($frmFilter.find("input[name='direction']").length > 0)
			{
				$frmFilter.find("input[name='direction']").remove();
			}
		},
		bindFilter: function()
		{
			var self = this;
			var $frmFilter = pjQ.$('#pjVpFilterForm_' + self.opts.index);
			var $filterPrice = pjQ.$('#pjVpFilterPrice_' + self.opts.index),
				$filterPriceLabel = pjQ.$('#pjVpFilterPriceLabel_' + self.opts.index),
				$filterRating = pjQ.$('#pjVpFilterRating_' + self.opts.index),
				$filterRatingLabel = pjQ.$('#pjVpFilterRatingLabel_' + self.opts.index),
				$filterLocation = pjQ.$('#pjVpFilterLocation_' + self.opts.index),
				$itemsPerPage = pjQ.$('#pjVpItemsPerPage_' + self.opts.index),
				$scrollToTop = pjQ.$('#pjVpScrollToTop_' + self.opts.index);
			
			if($filterPrice.length > 0)
			{
				var currency = $filterPrice.attr('data-currency'),
					price_from = parseInt(self.opts.price_from, 10),
					price_to = parseInt(self.opts.price_to, 10);
				
				$filterPrice.slider({
					range: true,
					min: 0,
					max: 1500,
					step: 10,
					values: [ price_from, price_to ],
					slide: function( event, ui ) {
						var filter_price_from = self.formatCurrency(parseInt(ui.values[0], 10), currency),
							filter_price_to = self.formatCurrency(parseInt(ui.values[1], 10), currency);
						$filterPriceLabel.html(self.opts.price_to_filter + ': ' + filter_price_from + ' - ' + filter_price_to);
					},
					stop: function( event, ui ) {
						var slider_value_from = parseInt(ui.values[0], 10),
							slider_value_to = parseInt(ui.values[1], 10);
						$filterPrice.slider({ disabled: true });
						
						if($frmFilter.length > 0)
						{
							self.removeSorting();
							if($frmFilter.find("input[name='price_from']").length > 0)
							{
								$frmFilter.find("input[name='price_from']").val(slider_value_from);
							}else{
								$frmFilter.append('<input type="hidden" name="price_from" value="'+slider_value_from+'"/>');
							}
							if($frmFilter.find("input[name='price_to']").length > 0)
							{
								$frmFilter.find("input[name='price_to']").val(slider_value_to);
							}else{
								$frmFilter.append('<input type="hidden" name="price_to" value="'+slider_value_to+'"/>');
							}
							$frmFilter.submit();
						}
					}
				});
				
				$filterPriceLabel.html(self.opts.price_to_filter + ': ' + self.formatCurrency(price_from, currency) + ' - ' + self.formatCurrency(price_to, currency));
			}
			
			if($filterRating.length > 0)
			{
				var	rating_from = parseInt(self.opts.rating_from, 10),
					rating_to = parseInt(self.opts.rating_to, 10);
				
				$filterRating.slider({
					range: true,
					min: 1,
					max: 5,
					values: [ rating_from, rating_to ],
					slide: function( event, ui ) {
						var filter_rating_from = parseInt(ui.values[0], 10),
							filter_rating_to = parseInt(ui.values[1], 10);
						$filterRatingLabel.html(self.opts.rating_to_filter + ': ' + filter_rating_from + ' - ' + filter_rating_to);
					},
					stop: function( event, ui ) {
						var slider_value_from = parseInt(ui.values[0], 10),
							slider_value_to = parseInt(ui.values[1], 10);
						$filterRating.slider({ disabled: true });
						if($frmFilter.length > 0)
						{
							self.removeSorting();
							if($frmFilter.find("input[name='rating_from']").length > 0)
							{
								$frmFilter.find("input[name='rating_from']").val(slider_value_from);
							}else{
								$frmFilter.append('<input type="hidden" name="rating_from" value="'+slider_value_from+'"/>');
							}
							if($frmFilter.find("input[name='rating_to']").length > 0)
							{
								$frmFilter.find("input[name='rating_to']").val(slider_value_to);
							}else{
								$frmFilter.append('<input type="hidden" name="rating_to" value="'+slider_value_to+'"/>');
							}
							$frmFilter.submit();
						}
					}
				});
				
				$filterRatingLabel.html(self.opts.rating_to_filter + ': ' + rating_from + ' - ' + rating_to);
			}
			if($filterLocation.length > 0)
			{
				$filterLocation.autocomplete({
					minLength: 0,
					source: self.opts.location,
					focus: function( event, ui ) {
						$filterLocation.val( ui.item.label );
					 	return false;
				 	},
				 	select: function( event, ui ) {
				 		$filterLocation.val( ui.item.label );
			 			if(ui.item.label != '')
			 			{
			 				if($frmFilter.length > 0)
							{
								self.removeSorting();
								if($frmFilter.find("input[name='location']").length > 0)
								{
									$frmFilter.find("input[name='location']").val(ui.item.label);
								}else{
									$frmFilter.append('<input type="hidden" name="location" value="'+ui.item.label+'"/>');
								}
								$frmFilter.submit();
							}
			 			}
			 			return false;
				 	},
				 	open: function () {
				        pjQ.$(this).data("ui-autocomplete").menu.element.addClass("vpl-autocomplete-ui");
				    }
				 }).data( "ui-autocomplete" )._renderItem = function( ul, item ) {
					 return pjQ.$( "<li>" )
					 .append( "<a>" + item.label + "</a>" )
					 .appendTo( ul );
				 };
				 $filterLocation.keyup(function (e) {
					 if (e.which == 13) 
					 {
						 if($frmFilter.length > 0)
						 {
							 self.removeSorting();
							 if($frmFilter.find("input[name='location']").length > 0)
							 {
								$frmFilter.find("input[name='location']").val($filterLocation.val());
								}else{
									$frmFilter.append('<input type="hidden" name="location" value="'+$filterLocation.val()+'"/>');
								}
								$frmFilter.submit();
							}
					 }
				 });
			}
			if($itemsPerPage.length > 0)
			{
				$itemsPerPage.on('change', function(e){
					if($frmFilter.length > 0)
					{
						self.removeSorting();
						if($frmFilter.find("input[name='item_per_page']").length > 0)
						{
							$frmFilter.find("input[name='item_per_page']").val(pjQ.$(this).val());
						}else{
							$frmFilter.append('<input type="hidden" name="item_per_page" value="'+pjQ.$(this).val()+'"/>');
						}
						$frmFilter.submit();
					}
				});
			}
			if($scrollToTop.length > 0)
			{
				$scrollToTop.hide();
				pjQ.$(window).scroll(function () {
					if (pjQ.$(this).scrollTop() > 200) 
					{
						$scrollToTop.fadeIn();
					} else {
						$scrollToTop.fadeOut();
					}
				});
				$scrollToTop.click(function () {
					pjQ.$('body,html').animate({
						scrollTop: 0
					}, 800);
					return false;
				});
			}
		},
		bindEnquiryForm: function()
		{
			var self = this;
			var $frm = pjQ.$('#pjVpEnquiryForm_' + self.opts.index);
			
			if($frm.length > 0)
			{
				pjQ.$.validator.addMethod("pjVpEmail", function(value, element) {
				    return this.optional( element ) || ( /^[a-z0-9]+([-._][a-z0-9]+)*@([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,4}$/.test( value ) && /^(?=.{1,64}@.{4,64}$)(?=.{6,100}$).*/.test( value ) );
				});
				
				$frm.validate({
					rules:{
						"period" : {
							required: function(){
								var from = $frm.find('input[name="date_from"]').val(),
									to = $frm.find('input[name="date_to"]').val();
								if(from == '' || to == '')
								{
									return true;
								}else{
									return false;
								}
							}
						},
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'captcha')
						{
							error.appendTo(element.parent().parent().next().find('ul'));
						}else{
							error.appendTo(element.next().find('ul'));
						}
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
							element.parent().parent().parent().parent().addClass('has-error');
						}else{
							element.parent().parent().addClass('has-error');
						}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
							element.parent().parent().parent().parent().removeClass('has-error').addClass('has-success');
						}else{
							element.parent().parent().removeClass('has-error').addClass('has-success');
						}
		            }
				});
			}
		},
		bindRating: function()
		{
			var self = this,
				$rating = pjQ.$('#pjVpRatingValue_' + self.opts.index);
			if($rating.length > 0)
			{
				var rating_value = parseInt($rating.val(), 10);
				self.bindStarHover.call(null, [rating_value]);
				
				pjQ.$('.pjVpBtnStar').each(function(){
					var $this = this;
					$this.onmouseover = function (e) {
						var star = parseInt(pjQ.$(this).attr('data-star'), 10);
						self.bindStarHover.call(null, [star]);
					};
					$this.onmouseout = function (e) {
						var star = parseInt(pjQ.$('#pjVpRatingValue_' + self.opts.index).val(), 10);
						self.bindStarHover.call(null, [star]);
					};
					$this.onclick = function(e){
						if (e && e.preventDefault) {
							e.preventDefault();
						}
						var star = parseInt(pjQ.$(this).attr('data-star'), 10);
						pjQ.$('#pjVpRatingValue_' + self.opts.index).val(star);
					}
				});
			}
		},
		bindStarHover: function(star)
		{
			for(var i = 1; i <= 5; i++)
			{
				var $btnStar = pjQ.$('#pjVpStar_' + i);
				if(i <= star)
				{	
					$btnStar.removeClass('fa-star-o').addClass('fa-star');
				}else{
					$btnStar.removeClass('fa-star').addClass('fa-star-o');
				}
			}
		},
		bindCommentForm: function()
		{
			var self = this;
			var $frm = pjQ.$('#frmVPLComment_' + self.opts.index);
			
			if($frm.length > 0)
			{
				pjQ.$.validator.addMethod("pjVpEmail", function(value, element) {
				    return this.optional( element ) || ( /^[a-z0-9]+([-._][a-z0-9]+)*@([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,4}$/.test( value ) && /^(?=.{1,64}@.{4,64}$)(?=.{6,100}$).*/.test( value ) );
				});
				$frm.validate({
					rules:{
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&comment=1"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'captcha')
						{
							error.appendTo(element.parent().parent().next().find('ul'));
						}else{
							error.appendTo(element.next().find('ul'));
						}
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
							element.parent().parent().parent().parent().addClass('has-error');
						}else{
							element.parent().parent().addClass('has-error');
						}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
							element.parent().parent().parent().parent().removeClass('has-error').addClass('has-success');
						}else{
							element.parent().parent().removeClass('has-error').addClass('has-success');
						}
		            }
				});
			}
		},
		bindLoginForm: function()
		{
			var self = this;
			var $frm = pjQ.$('#frmVpLoginForm_' + self.opts.index);
			if($frm.length > 0)
			{
				$frm.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindForgotForm: function()
		{
			var self = this;
			var $frm = pjQ.$('#frmVpForgotForm_' + self.opts.index);
			if($frm.length > 0)
			{
				pjQ.$.validator.addMethod("pjVpEmail", function(value, element) {
				    return this.optional( element ) || ( /^[a-z0-9]+([-._][a-z0-9]+)*@([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,4}$/.test( value ) && /^(?=.{1,64}@.{4,64}$)(?=.{6,100}$).*/.test( value ) );
				});
				$frm.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindRegisterForm: function()
		{
			var self = this;
			var $frm = pjQ.$('#pjVpRegisterForm_' + self.opts.index);
			
			if($frm.length > 0)
			{
				pjQ.$.validator.addMethod("pjVpEmail", function(value, element) {
				    return this.optional( element ) || ( /^[a-z0-9]+([-._][a-z0-9]+)*@([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,4}$/.test( value ) && /^(?=.{1,64}@.{4,64}$)(?=.{6,100}$).*/.test( value ) );
				});
				$frm.validate({
					rules:{
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha"
						},
						"retype_password":{
							equalTo: "#pjVpRegisterPassword"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'captcha')
						{
							error.appendTo(element.parent().parent().next().find('ul'));
						}else{
							error.appendTo(element.next().find('ul'));
						}
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
							element.parent().parent().parent().parent().addClass('has-error');
						}else{
							element.parent().parent().addClass('has-error');
						}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
							element.parent().parent().parent().parent().removeClass('has-error').addClass('has-success');
						}else{
							element.parent().parent().removeClass('has-error').addClass('has-success');
						}
		            }
				});
			}
		}
	};
	
	window.VacationPackages = VacationPackages;	
})(window);