DROP TABLE IF EXISTS `yachtlisting_bookings`;
CREATE TABLE IF NOT EXISTS `yachtlisting_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `listing_id` int(10) unsigned DEFAULT NULL,
  `week_start` date default NULL,
  `sub_total` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `is_sent` enum('T','F') default 'F',
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_bookings_payments`;
CREATE TABLE IF NOT EXISTS `yachtlisting_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_listings`;
CREATE TABLE `yachtlisting_listings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturer_id` int(11) NULL DEFAULT NULL,
  `owner_id` int(11) NULL DEFAULT NULL,
  `feature_fuel_id` int(10) unsigned DEFAULT NULL,
  `feature_engine_id` int(10) unsigned DEFAULT NULL,
  `feature_hull_id` int(10) unsigned DEFAULT NULL,
  `feature_yacht_id` int(10) unsigned DEFAULT NULL,
  `created` datetime NULL DEFAULT NULL,
  `modified` datetime NULL DEFAULT NULL,
  `views` int(11) NOT NULL DEFAULT '0',
  `for` enum('rent','sale') DEFAULT NULL,
  `status` enum('T','F','E') NOT NULL DEFAULT 'F',
  `expire` date DEFAULT NULL,
  `last_extend` enum('free','paid') DEFAULT 'free',
  `added_by` enum('other','owner') NOT NULL DEFAULT 'other',
  `listing_refid` varchar(255) DEFAULT NULL,
  `listing_model` varchar(255) DEFAULT NULL,
  `listing_price` decimal(15,2) unsigned DEFAULT NULL,
  `listing_year` year(4) DEFAULT NULL,
  `listing_length` decimal(9,2) unsigned DEFAULT NULL,
  `listing_loa` decimal(9,2) unsigned DEFAULT NULL,
  `listing_beam` decimal(9,2) unsigned DEFAULT NULL,
  `listing_engine_hours` smallint(5) unsigned DEFAULT NULL,
  `listing_engine_model` varchar(255) DEFAULT NULL,
  `listing_cruising_speed` smallint(5) unsigned DEFAULT NULL,
  `listing_max_speed` smallint(5) unsigned DEFAULT NULL,
  `listing_fuel_tank` smallint(5) unsigned DEFAULT NULL,
  `listing_power` smallint(5) unsigned DEFAULT NULL,
  `address_country` int(11) DEFAULT NULL,
  `address_state` varchar(250) DEFAULT NULL,
  `address_city` varchar(250) DEFAULT NULL,
  `address_content` varchar(250) DEFAULT NULL,
  `address_zip` varchar(250) DEFAULT NULL,
  `owner_show` enum('T','F') DEFAULT NULL,
  `owner_name` varchar(250) DEFAULT NULL,
  `owner_phone` varchar(250) DEFAULT NULL,
  `owner_email` varchar(250) DEFAULT NULL,
  `owner_fax` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `manufacturer_id` (`manufacturer_id`),
  KEY `owner_id` (`owner_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_prices`;
CREATE TABLE IF NOT EXISTS `yachtlisting_prices` (
  `listing_id` int(10) unsigned NOT NULL,
  `start_date` date NOT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`listing_id`, `start_date`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_payments`;
CREATE TABLE IF NOT EXISTS `yachtlisting_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_periods`;
CREATE TABLE IF NOT EXISTS `yachtlisting_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_extras`;
CREATE TABLE IF NOT EXISTS `yachtlisting_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_listings_extras`;
CREATE TABLE `yachtlisting_listings_extras` (
  `listing_id` int(11) NOT NULL,
  `extra_id` int(11) NOT NULL,
  PRIMARY KEY (`listing_id`, `extra_id`),
  KEY `listing_id` (`listing_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_manufacturers`;
CREATE TABLE IF NOT EXISTS `yachtlisting_manufacturers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_features`;
CREATE TABLE IF NOT EXISTS `yachtlisting_features` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('fuel','engine','hull','yacht') NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_fields`;
CREATE TABLE IF NOT EXISTS `yachtlisting_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_multi_lang`;
CREATE TABLE IF NOT EXISTS `yachtlisting_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_options`;
CREATE TABLE IF NOT EXISTS `yachtlisting_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_roles`;
CREATE TABLE IF NOT EXISTS `yachtlisting_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yachtlisting_users`;
CREATE TABLE IF NOT EXISTS `yachtlisting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `yachtlisting_periods` (`id`, `days`, `price`) VALUES
(1, 10, 49.00),
(2, 20, 79.00),
(3, 30, 99.00),
(4, 40, 109.00),
(5, 50, 119.00);

INSERT INTO `yachtlisting_extras` (`id`, `type`, `status`) VALUES
(1, 1, 'T'),
(2, 1, 'T'),
(3, 1, 'T'),
(4, 1, 'T'),
(5, 1, 'T'),
(6, 1, 'T'),
(7, 1, 'T'),
(8, 1, 'T'),
(9, 1, 'T'),
(10, 1, 'T'),
(11, 1, 'T'),
(12, 1, 'T'),
(13, 1, 'T'),
(14, 1, 'T'),
(15, 1, 'T'),
(16, 1, 'T'),
(17, 1, 'T'),
(18, 1, 'T'),
(19, 1, 'T'),
(20, 1, 'T'),
(21, 1, 'T'),
(22, 1, 'T'),
(23, 1, 'T'),
(24, 1, 'T'),
(25, 1, 'T'),
(26, 1, 'T'),
(27, 1, 'T'),
(28, 1, 'T'),
(29, 1, 'T'),
(30, 1, 'T'),
(31, 1, 'T'),
(32, 1, 'T'),
(33, 1, 'T'),
(34, 2, 'T'),
(35, 2, 'T'),
(36, 2, 'T'),
(37, 2, 'T'),
(38, 2, 'T'),
(39, 2, 'T');

INSERT INTO `yachtlisting_features` (`id`, `type`, `status`) VALUES
(1, 'yacht', 'T'),
(2, 'yacht', 'T'),
(3, 'yacht', 'T'),
(4, 'yacht', 'T'),
(5, 'fuel', 'T'),
(6, 'fuel', 'T'),
(7, 'fuel', 'T'),
(8, 'fuel', 'T'),
(9, 'engine', 'T'),
(10, 'engine', 'T'),
(11, 'engine', 'T'),
(12, 'engine', 'T'),
(13, 'engine', 'T'),
(14, 'engine', 'T'),
(15, 'engine', 'T'),
(16, 'engine', 'T'),
(17, 'engine', 'T'),
(18, 'engine', 'T'),
(19, 'engine', 'T'),
(20, 'engine', 'T'),
(21, 'hull', 'T'),
(22, 'hull', 'T'),
(23, 'hull', 'T'),
(24, 'hull', 'T'),
(25, 'hull', 'T'),
(26, 'hull', 'T'),
(27, 'hull', 'T'),
(28, 'hull', 'T'),
(29, 'hull', 'T'),
(30, 'hull', 'T');

INSERT INTO `yachtlisting_manufacturers` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T'),
(6, 'T'),
(7, 'T'),
(8, 'T'),
(9, 'T'),
(10, 'T'),
(11, 'T'),
(12, 'T'),
(13, 'T'),
(14, 'T'),
(15, 'T'),
(16, 'T'),
(17, 'T'),
(18, 'T'),
(19, 'T'),
(20, 'T'),
(21, 'T'),
(22, 'T'),
(23, 'T'),
(24, 'T'),
(25, 'T'),
(26, 'T'),
(27, 'T'),
(28, 'T'),
(29, 'T'),
(30, 'T'),
(31, 'T'),
(32, 'T'),
(33, 'T'),
(34, 'T'),
(35, 'T'),
(36, 'T'),
(37, 'T'),
(38, 'T'),
(39, 'T'),
(40, 'T'),
(41, 'T'),
(42, 'T'),
(43, 'T'),
(44, 'T'),
(45, 'T'),
(46, 'T'),
(47, 'T'),
(48, 'T'),
(49, 'T'),
(50, 'T'),
(51, 'T'),
(52, 'T'),
(53, 'T'),
(54, 'T'),
(55, 'T'),
(56, 'T'),
(57, 'T'),
(58, 'T'),
(59, 'T'),
(60, 'T'),
(61, 'T'),
(62, 'T'),
(63, 'T'),
(64, 'T'),
(65, 'T'),
(66, 'T'),
(67, 'T'),
(68, 'T'),
(69, 'T'),
(70, 'T'),
(71, 'T'),
(72, 'T'),
(73, 'T'),
(74, 'T'),
(75, 'T'),
(76, 'T'),
(77, 'T'),
(78, 'T'),
(79, 'T'),
(80, 'T'),
(81, 'T'),
(82, 'T'),
(83, 'T'),
(84, 'T'),
(85, 'T'),
(86, 'T'),
(87, 'T'),
(88, 'T'),
(89, 'T'),
(90, 'T'),
(91, 'T'),
(92, 'T'),
(93, 'T'),
(94, 'T'),
(95, 'T'),
(96, 'T'),
(97, 'T'),
(98, 'T'),
(99, 'T'),
(100, 'T');

INSERT INTO `yachtlisting_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(540, 'menuYachts', 'backend', 'Menu / Yachts', 'script', NULL),
(541, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(542, 'tabSubmissions', 'backend', 'Tab / Submissions', 'script', NULL),
(543, 'tabManufacturers', 'backend', 'Tab / Manufacturers', 'script', NULL),
(544, 'tabExtras', 'backend', 'Tab / Extras', 'script', NULL),
(545, 'tabFeatures', 'backend', 'Tab / Features', 'script', NULL),
(546, 'tabBookings', 'backend', 'Tab / Bookings', 'script', NULL),
(547, 'tabPayments', 'backend', 'Tab / Payments', 'script', NULL),
(548, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(549, 'tabBookingForm', 'backend', 'Tab / Booking form', 'script', NULL),
(550, 'tabCustomers', 'backend', 'Tab / Customers', 'script', NULL),
(551, 'tabOwners', 'backend', 'Tab / Owners', 'script', NULL),
(552, 'tabAdministrators', 'backend', 'Tab / Administrators', 'script', NULL),
(553, 'opt_o_length', 'backend', 'Options / Show length in', 'script', NULL),
(554, 'opt_o_fuel', 'backend', 'Options / Show fuel in', 'script', NULL),
(555, 'opt_o_power', 'backend', 'Options / Show power in', 'script', NULL),
(556, 'opt_o_items_per_page', 'backend', 'Options / Items per page', 'script', NULL),
(557, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(558, 'infoSubmissionsTitle', 'backend', 'Infobox / Yacht Submissions by Users', 'script', NULL),
(559, 'infoSubmissionsDesc', 'backend', 'Infobox / Yacht Submissions by Users', 'script', NULL),
(560, 'opt_o_allow_add_listing', 'backend', 'Options / Allow users to submit yachts ', 'script', NULL),
(561, 'opt_o_owner_is_active', 'backend', 'Options / Automatically activate new owner accounts', 'script', NULL),
(562, 'opt_o_paypal_address', 'backend', 'Options / Set your PayPal address ', 'script', NULL),
(563, 'lblOwnerActiveTip', 'backend', 'Label / Owner active tip', 'script', NULL),
(564, 'opt_period_note', 'backend', 'Options / Perios notes', 'script', NULL),
(565, 'payment_period', 'backend', 'Options / Period', 'script', NULL),
(566, 'payment_price', 'backend', 'Options / Price', 'script', NULL),
(567, 'btnAddPeriod', 'backend', 'Buttons / + Add period / price', 'script', NULL),
(568, 'lblDialogDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(569, 'lblDeletePeriodText', 'backend', 'Label / Delete confirmation', 'script', NULL),
(570, 'infoPaymentsTitle', 'backend', 'Infobox / Payment options', 'script', NULL),
(571, 'infoPaymentsDesc', 'backend', 'Infobox / Payment options', 'script', NULL),
(572, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(573, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(574, 'opt_o_booking_status', 'backend', 'Options / Default booking status', 'script', NULL),
(575, 'opt_o_payment_status', 'backend', 'Options / Default payment status', 'script', NULL),
(576, 'opt_o_thank_you_page', 'backend', 'Options / Thank you page', 'script', NULL),
(577, 'opt_o_payment_disable', 'backend', 'Options / Payment disable', 'script', NULL),
(578, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(579, 'opt_o_owner_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(580, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(581, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(582, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(583, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(584, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(585, 'opt_o_allow_cash', 'backend', 'Options / Allow payment with cash', 'script', NULL),
(586, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(587, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(588, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(589, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form', 'script', NULL),
(590, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form', 'script', NULL),
(591, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(592, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(593, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(594, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(595, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(596, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(597, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(598, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(599, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(600, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(601, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(602, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(603, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(604, 'tabToOwners', 'backend', 'Tab / To owners', 'script', NULL),
(605, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(606, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(607, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(608, 'lblBookingTokens', 'backend', 'Label / Booking available tokens', 'script', NULL),
(609, 'lblBookingSMSTokens', 'backend', 'Label / Booking available tokens', 'script', NULL),
(610, 'infoCustomersNotificaionsTitle', 'backend', 'Infobox / Notifications to customers', 'script', NULL),
(611, 'infoCustomersNotificaionsDesc', 'backend', 'Infobox / Notifications to customers', 'script', NULL),
(612, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(613, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(614, 'opt_o_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(615, 'opt_o_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(616, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(617, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(618, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(619, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(620, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(621, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(622, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(623, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(624, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(625, 'infoOwnersNotificaionsTitle', 'backend', 'Infobox / Notifications to owners', 'script', NULL),
(626, 'infoOwnersNotificaionsDesc', 'backend', 'Infobox / Notifications to owners', 'script', NULL),
(627, 'lblLegendBookingsEmails', 'backend', 'Lable / Booking - Emails', 'script', NULL),
(628, 'lblLegendBookingsSMS', 'backend', 'Lable / Bookings - SMS', 'script', NULL),
(629, 'lblLegendAccountSMS', 'backend', 'Lable / Account - SMS', 'script', NULL),
(630, 'lblLegendAccountEmails', 'backend', 'Lable / Account - Emails', 'script', NULL),
(631, 'opt_o_email_registration', 'backend', 'Options / Registration email', 'script', NULL),
(632, 'opt_o_email_registration_text', 'backend', 'Options / Registration email', 'script', NULL),
(633, 'opt_o_email_registration_subject', 'backend', 'Options / Registration email subject', 'script', NULL),
(634, 'opt_o_email_registration_message', 'backend', 'Options / Registration email message', 'script', NULL),
(635, 'opt_o_email_submission', 'backend', 'Options / New yacht submitted email', 'script', NULL),
(636, 'opt_o_email_submission_text', 'backend', 'Options / New yacht submitted email', 'script', NULL),
(637, 'opt_o_email_submission_subject', 'backend', 'Options / New yacht submitted email subject', 'script', NULL),
(638, 'opt_o_email_submission_message', 'backend', 'Options / New yacht submitted email message', 'script', NULL),
(639, 'opt_o_email_forgot_subject', 'backend', 'Options / Password recovery email subject', 'script', NULL),
(640, 'opt_o_email_forgot_message', 'backend', 'Options / Password recovery email message', 'script', NULL),
(641, 'opt_o_sms_registration', 'backend', 'Options / Registration SMS', 'script', NULL),
(642, 'opt_o_sms_registration_message', 'backend', 'Options / Registration SMS content', 'script', NULL),
(643, 'opt_o_sms_submission', 'backend', 'Options / New yacht submitted SMS', 'script', NULL),
(644, 'opt_o_sms_submission_message', 'backend', 'Options / New property submitted SMS content', 'script', NULL),
(645, 'opt_o_sms_submission_message_text', 'backend', 'Options / New property submitted SMS content', 'script', NULL),
(646, 'opt_o_sms_registration_message_text', 'backend', 'Options / Registration SMS content', 'script', NULL),
(647, 'opt_o_email_forgot_message_text', 'backend', 'Options / Password recovery email message', 'script', NULL),
(648, 'opt_o_email_submission_message_text', 'backend', 'Options / New property submitted email message', 'script', NULL),
(649, 'opt_o_email_registration_message_text', 'backend', 'Options / Registration email message', 'script', NULL),
(650, 'opt_o_owner_sms_confirmation_message', 'backend', 'Options / New booking SMS', 'script', NULL),
(651, 'opt_o_owner_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(652, 'opt_o_owner_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(653, 'opt_o_owner_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(654, 'opt_o_owner_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(655, 'opt_o_owner_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(656, 'opt_o_owner_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(657, 'opt_o_owner_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(658, 'opt_o_owner_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(659, 'opt_o_owner_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(660, 'opt_o_owner_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(661, 'opt_o_owner_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(662, 'opt_o_owner_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(663, 'opt_o_owner_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(664, 'infoAdminNotificaionsTitle', 'backend', 'Infobox / Notifications to administrators', 'script', NULL),
(665, 'infoAdminNotificaionsDesc', 'backend', 'Infobox / Notifications to administrators', 'script', NULL),
(666, 'opt_o_admin_email_registration', 'backend', 'Options / Registration email', 'script', NULL),
(667, 'opt_o_admin_email_registration_text', 'backend', 'Options / Registration email', 'script', NULL),
(668, 'opt_o_admin_email_registration_subject', 'backend', 'Options / Registration email subject', 'script', NULL),
(669, 'opt_o_admin_email_registration_message', 'backend', 'Options / Registration email message', 'script', NULL),
(670, 'opt_o_admin_email_registration_message_text', 'backend', 'Options / Registration email message', 'script', NULL),
(671, 'opt_o_admin_email_submission', 'backend', 'Options / New yacht submitted email', 'script', NULL),
(672, 'opt_o_admin_email_submission_text', 'backend', 'Options / New yacht submitted email', 'script', NULL),
(673, 'opt_o_admin_email_submission_subject', 'backend', 'Options / New yacht submitted email subject ', 'script', NULL),
(674, 'opt_o_admin_email_submission_message', 'backend', 'Options / New yacht submitted email message', 'script', NULL),
(675, 'opt_o_admin_email_submission_message_text', 'backend', 'Options / New yacht submitted email message', 'script', NULL),
(676, 'opt_o_admin_sms_registration', 'backend', 'Options / Registration SMS', 'script', NULL),
(677, 'opt_o_admin_sms_registration_text', 'backend', 'Options / Registration SMS', 'script', NULL),
(678, 'opt_o_admin_sms_registration_message', 'backend', 'Options / Registration SMS content', 'script', NULL),
(679, 'opt_o_admin_sms_registration_message_text', 'backend', 'Options / Registration SMS content', 'script', NULL),
(680, 'opt_o_admin_sms_submission', 'backend', 'Options / New yacht submitted SMS', 'script', NULL),
(681, 'opt_o_admin_sms_submission_text', 'backend', 'Options / New yacht submitted SMS', 'script', NULL),
(682, 'opt_o_admin_sms_submission_message', 'backend', 'Options / New yacht submitted SMS', 'script', NULL),
(683, 'opt_o_admin_sms_submission_message_text', 'backend', 'Options / New yacht submitted SMS', 'script', NULL),
(684, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(685, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(686, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(687, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(688, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(689, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(690, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(691, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(692, 'lblExtra', 'backend', 'Label / Extra', 'script', NULL),
(693, 'infoExtrasTitle', 'backend', 'Infobox / List of extras', 'script', NULL),
(694, 'infoExtrasDesc', 'backend', 'Infobox / List of extras', 'script', NULL),
(695, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(696, 'lblSameExtra', 'backend', 'Label / Extra name was already used.', 'script', NULL),
(697, 'infoExtraCreateTitle', 'backend', 'Infobox / Add new extra', 'script', NULL),
(698, 'infoExtraCreateDesc', 'backend', 'Infobox / Add new extra', 'script', NULL),
(699, 'lblExtraType', 'backend', 'Label / Extra type', 'script', NULL),
(700, 'extra_types_ARRAY_1', 'arrays', 'extra_types_ARRAY_1', 'script', NULL),
(701, 'extra_types_ARRAY_2', 'arrays', 'extra_types_ARRAY_2', 'script', NULL),
(702, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(703, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(704, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(705, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(706, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(707, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(708, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(709, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(710, 'infoExtraUpdateTitle', 'backend', 'Infobox / Update extra', 'script', NULL),
(711, 'infoExtraUpdateDesc', 'backend', 'Infobox / Update extra', 'script', NULL),
(712, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(713, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(714, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(715, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(716, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(717, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(718, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(719, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(720, 'feature_types_ARRAY_yacht', 'arrays', 'feature_types_ARRAY_yacht', 'script', NULL),
(721, 'feature_types_ARRAY_fuel', 'arrays', 'feature_types_ARRAY_fuel', 'script', NULL),
(722, 'feature_types_ARRAY_engine', 'arrays', 'feature_types_ARRAY_engine', 'script', NULL),
(723, 'feature_types_ARRAY_hull', 'arrays', 'feature_types_ARRAY_hull', 'script', NULL),
(724, 'infoFeaturesTitle', 'backend', 'Infobox / List of features', 'script', NULL),
(725, 'infoFeaturesDesc', 'backend', 'Infobox / List of features', 'script', NULL),
(726, 'lblFeature', 'backend', 'Label / Feature', 'script', NULL),
(727, 'lblFeatureType', 'backend', 'Label / Feature type', 'script', NULL),
(728, 'lblSameFeature', 'backend', 'Label / Feature name was already used.', 'script', NULL),
(729, 'infoFeatureCreateTitle', 'backend', 'Infobox / Add new feature', 'script', NULL),
(730, 'infoFeatureCreateDesc', 'backend', 'Infobox / Add new feature', 'script', NULL),
(731, 'infoFeatureUpdateTitle', 'backend', 'Infobox / Update feature', 'script', NULL),
(732, 'infoFeatureUpdateDesc', 'backend', 'Infobox / Update feature', 'script', NULL),
(733, 'infoManufacturersTitle', 'backend', 'Infobox / List of manufacturers', 'script', NULL),
(734, 'infoManufacturersDesc', 'backend', 'Infobox / List of manufacturers', 'script', NULL),
(735, 'infoManufacturerCreateTitle', 'backend', 'Infobox / Add new manufacturer', 'script', NULL),
(736, 'infoManufacturerCreateDesc', 'backend', 'Infobox / Add new manufacturer', 'script', NULL),
(737, 'infoManufacturerUpdateTitle', 'backend', 'Infobox / Update manufacturer', 'script', NULL),
(738, 'infoManufacturerUpdateDesc', 'backend', 'Infobox / Update manufacturer', 'script', NULL),
(739, 'lblManufacturer', 'backend', 'Label / Manufacturer', 'script', NULL),
(740, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(741, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(742, 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
(743, 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
(744, 'error_titles_ARRAY_AM04', 'arrays', 'error_titles_ARRAY_AM04', 'script', NULL),
(745, 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(746, 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
(747, 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
(748, 'lblOptional', 'backend', 'Label / Optional', 'script', NULL),
(749, 'lblInstallPhp1Title', 'backend', 'Label / Install description', 'script', NULL),
(750, 'opt_o_listing_page', 'backend', 'Options / Listing page', 'script', NULL),
(751, 'lblInstallPhp1_1', 'backend', 'Options / Listing page', 'script', NULL),
(752, 'lblInstallPhp1_2', 'backend', 'Options / Step 2', 'script', NULL),
(753, 'lblInstallPhp1_2a', 'backend', 'Options / Step 2a', 'script', NULL),
(754, 'lblInstallPhp1_3', 'backend', 'Options / Step 3', 'script', NULL),
(755, 'lblInstallPhp2Title', 'backend', 'Label / Install SEO', 'script', NULL),
(756, 'opt_o_seo_url', 'backend', 'Options / ', 'script', NULL),
(757, 'lblInstallPhp2_1', 'backend', 'Label / Step 2.1 (Optional)', 'script', NULL),
(758, 'lblInstallPhp2_2', 'backend', 'Label / Step 2.2 (Optional)', 'script', NULL),
(759, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(760, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(761, 'listing_for_ARRAY_rent', 'arrays', 'listing_for_ARRAY_rent', 'script', NULL),
(762, 'listing_for_ARRAY_sale', 'arrays', 'listing_for_ARRAY_sale', 'script', NULL),
(763, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(764, 'lblRefId', 'backend', 'Label / Ref ID', 'script', NULL),
(765, 'lblPublish', 'backend', 'Label / Publish', 'script', NULL),
(766, 'lblPublished', 'backend', 'Label / Published', 'script', NULL),
(767, 'lblNotPublished', 'backend', 'Label / Not published', 'script', NULL),
(768, 'lblExtendExpDate', 'backend', 'Label / Extend exp. date', 'script', NULL),
(769, 'lblExpire', 'backend', 'Label / Expire', 'script', NULL),
(770, 'lblExpDate', 'backend', 'Label / Exp. date', 'script', NULL),
(771, 'lblExpDatePlus30', 'backend', 'Label / Expiration date + 30 days', 'script', NULL),
(772, 'lblUnlimited', 'backend', 'Label / Unlimited', 'script', NULL),
(773, 'lblOwner', 'backend', 'Label / Owner', 'script', NULL),
(774, 'tabAddYacht', 'backend', 'Tab / Add yacht', 'script', NULL),
(775, 'lblKeyword', 'backend', 'Label / Keyword', 'script', NULL),
(776, 'lblState', 'backend', 'Label / State', 'script', NULL),
(777, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(778, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(779, 'publish_statuses_ARRAY_T', 'arrays', 'publish_statuses_ARRAY_T', 'script', NULL),
(780, 'publish_statuses_ARRAY_F', 'arrays', 'publish_statuses_ARRAY_F', 'script', NULL),
(781, 'publish_statuses_ARRAY_E', 'arrays', 'publish_statuses_ARRAY_E', 'script', NULL),
(782, 'infoListingAddTitle', 'backend', 'Label / Add new yacht', 'script', NULL),
(783, 'infoListingAddDesc', 'backend', 'Label / Add new yacht', 'script', NULL),
(784, 'lblRefIdTip', 'backend', 'Tips / Reference ID', 'script', NULL),
(785, 'lblAddManufacturer', 'backend', 'Label / Add new manufacturer', 'script', NULL),
(786, 'lblStatusTip', 'backend', 'Tips / Stats', 'script', NULL),
(787, 'lblExpireTip', 'backend', 'Tips / Expire', 'script', NULL),
(788, 'lblYacht', 'backend', 'Label / Yacht', 'script', NULL),
(789, 'tabSummary', 'backend', 'Tab / Summary', 'script', NULL),
(790, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(791, 'tabDescription', 'backend', 'Tab / Description', 'script', NULL),
(793, 'tabPhotos', 'backend', 'Tab / Photos', 'script', NULL),
(794, 'tabOwner', 'backend', 'Tab / Owner', 'script', NULL),
(795, 'tabAddress', 'backend', 'Tab / Address', 'script', NULL),
(796, 'tabSeo', 'backend', 'Tab / SEO', 'script', NULL),
(797, 'infoSummaryTitle', 'backend', 'Infobox / Yacht summary', 'script', NULL),
(798, 'infoSummaryDesc', 'backend', 'Infobox / Yacht summary', 'script', NULL),
(799, 'infoDetailsTitle', 'backend', 'Infobox / Details information', 'script', NULL),
(800, 'infoDetailsDesc', 'backend', 'Infobox / Details information', 'script', NULL),
(801, 'infoDescriptionTitle', 'backend', 'Infobox / Yacht description', 'script', NULL),
(802, 'infoDescriptionDesc', 'backend', 'Infobox / Yacht description', 'script', NULL),
(803, 'infoExtraTitle', 'backend', 'Infobox / Extras', 'script', NULL),
(804, 'infoExtraDesc', 'backend', 'Infobox / Yacht description', 'script', NULL),
(805, 'infoGalleryTitle', 'backend', 'Infobox / Photos', 'script', NULL),
(807, 'infoGalleryDesc', 'backend', 'Infobox / Photos', 'script', NULL),
(808, 'infoContactTitle', 'backend', 'Infobox / Owner contact', 'script', NULL),
(809, 'infoContactDesc', 'backend', 'Infobox / Owner contact', 'script', NULL),
(810, 'infoAddressTitle', 'backend', 'Infobox / Address', 'script', NULL),
(811, 'infoAddressDesc', 'backend', 'Infobox / Address', 'script', NULL),
(812, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(813, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(814, 'lblAddedOn', 'backend', 'Label / Added on', 'script', NULL),
(815, 'lblLastUpdateOn', 'backend', 'Label / Last updated on', 'script', NULL),
(816, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(817, 'lblNotActive', 'backend', 'Lable / Not active', 'script', NULL),
(818, 'lblExtend', 'backend', 'Label / Extend', 'script', NULL),
(819, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(820, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(821, 'lblYear', 'backend', 'Label / Year', 'script', NULL),
(822, 'lblHorsePower', 'backend', 'Label / Horse power', 'script', NULL),
(823, 'lblLOA', 'backend', 'Label / LOA', 'script', NULL),
(824, 'lblLength', 'backend', 'Label / Length', 'script', NULL),
(825, 'lblBeam', 'backend', 'Label / Beam', 'script', NULL),
(826, 'lblEngineHours', 'backend', 'Label / Engine hours', 'script', NULL),
(827, 'lblEngineModel', 'backend', 'Label / Engine model', 'script', NULL),
(828, 'lblCruisingSpeed', 'backend', 'Label / Cruising speed', 'script', NULL),
(829, 'lblMaxSpeed', 'backend', 'Label / Max speed', 'script', NULL),
(830, 'lblFuelTank', 'backend', 'Label / Fuel tank', 'script', NULL),
(831, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(832, 'lblChooseOwner', 'backend', 'Label / Choose owner', 'script', NULL),
(833, 'lblOwnerShow', 'backend', 'Label / Show owner contact', 'script', NULL),
(834, 'lblOwnerTip', 'backend', 'Label / Show owner contact', 'script', NULL),
(835, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(836, 'lblFax', 'backend', 'Label / Fax', 'script', NULL),
(837, 'lblResetContactDetails', 'backend', 'Label /  Load owner contact details', 'script', NULL),
(838, 'lblAddress', 'backend', 'Label /  Address', 'script', NULL),
(839, 'lblZip', 'backend', 'Label /  Zip / post code', 'script', NULL),
(840, 'infoSEOTitle', 'backend', 'Infobox / SEO settings', 'script', NULL),
(841, 'infoSEODesc', 'backend', 'Infobox / SEO settings', 'script', NULL),
(842, 'lblMetaTitle', 'backend', 'Label / Meta title', 'script', NULL),
(843, 'lblMetaKeywords', 'backend', 'Label / Meta keywords', 'script', NULL),
(844, 'lblMetaDesc', 'backend', 'Label / Meta description', 'script', NULL),
(845, 'lblMetaTitleTip', 'backend', 'Label / Meta description', 'script', NULL),
(846, 'lblMetaKeywordTip', 'backend', 'Tip / meta keywords', 'script', NULL),
(847, 'lblMetaDescTip', 'backend', 'Tip / meta description', 'script', NULL),
(848, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(849, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(850, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(851, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(852, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(853, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(854, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(855, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(856, 'infoListingsTitle', 'backend', 'Infobox / List of yachts', 'script', NULL),
(857, 'infoListingsDesc', 'backend', 'Infobox / List of yachts', 'script', NULL),
(858, 'tabPrices', 'backend', 'Tab / Prices', 'script', NULL),
(859, 'infoPricesTitle', 'backend', 'Infobox / Rental prices', 'script', NULL),
(860, 'infoPricesDesc', 'backend', 'Infobox / Rental prices', 'script', NULL),
(861, 'lblWeek', 'backend', 'Label / Week', 'script', NULL),
(863, 'infoExtendTitle', 'backend', 'Infobox / Extend expiration date', 'script', NULL),
(864, 'infoExtendDesc', 'backend', 'Infobox / Extend expiration date', 'script', NULL),
(866, 'payment_renew_paypal', 'backend', 'Button / Buy now', 'script', NULL),
(867, 'listing_payment_free', 'backend', 'Listing / FREE', 'script', NULL),
(868, 'listing_payment_renew_free', 'backend', 'Listing / Extend your period for FREE', 'script', NULL),
(1047, 'front_search', 'frontend', 'Label / Search', 'script', NULL),
(1048, 'front_yachts_not_found', 'frontend', 'Label / Yachts not found', 'script', NULL),
(1049, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(1050, 'front_build', 'frontend', 'Label / Build', 'script', NULL),
(1051, 'front_length', 'frontend', 'Label / Length', 'script', NULL),
(1052, 'front_more_details', 'frontend', 'Label / More Details', 'script', NULL),
(1053, 'front_per_week', 'frontend', 'Label / per week', 'script', NULL),
(1054, 'lblModel', 'backend', 'Label / Model', 'script', NULL),
(1055, 'front_next', 'backend', 'Label / Next', 'script', NULL),
(1056, 'front_prev', 'backend', 'Label / Prev', 'script', NULL),
(1057, 'front_search_for_yachts', 'frontend', 'Label / Search for Yachts', 'script', NULL),
(1058, 'front_all', 'frontend', 'Label / All', 'script', NULL),
(1059, 'front_manufacturer', 'frontend', 'Label / Manufacturer', 'script', NULL),
(1060, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(1061, 'front_home', 'frontend', 'Label / Home', 'script', NULL),
(1062, 'front_my_account', 'frontend', 'Label / My Account', 'script', NULL),
(1063, 'front_model', 'frontend', 'Label / Model', 'script', NULL),
(1064, 'front_reference_id', 'frontend', 'Label / Reference ID', 'script', NULL),
(1065, 'front_year', 'frontend', 'Label / Year', 'script', NULL),
(1066, 'front_horsepower', 'frontend', 'Label / Horse power', 'script', NULL),
(1068, 'front_beam', 'frontend', 'Label / Beam', 'script', NULL),
(1069, 'front_loa', 'frontend', 'Label / LOA', 'script', NULL),
(1070, 'front_search_yatchs', 'frontend', 'Label / Search Yatchs', 'script', NULL),
(1071, 'front_back_to_yachts', 'frontend', 'Label / Back to yachts', 'script', NULL),
(1072, 'front_yacht_reservation', 'frontend', 'Label / Yacht Reservation', 'script', NULL),
(1073, 'front_feature_set', 'frontend', 'Label / Feature set', 'script', NULL),
(1074, 'front_yacth_description', 'frontend', 'Label / Yacht description', 'script', NULL),
(1075, 'front_general_specifications', 'frontend', 'Label / General specifications', 'script', NULL),
(1078, 'front_registration_year', 'frontend', 'Label / Registration year', 'script', NULL),
(1079, 'front_technical_specifications', 'frontend', 'Label / Technical specifications', 'script', NULL),
(1080, 'front_engine_hours', 'frontend', 'Label / Engine hours', 'script', NULL),
(1081, 'front_engine_model', 'frontend', 'Label / Engine model', 'script', NULL),
(1082, 'front_cruising_speed', 'frontend', 'Label / Cruising speed', 'script', NULL),
(1083, 'front_max_speed', 'frontend', 'Label / Max speed', 'script', NULL),
(1084, 'front_fuel_tank', 'frontend', 'Label / Fuel tank', 'script', NULL),
(1085, 'front_week', 'frontend', 'Label / Week', 'script', NULL),
(1086, 'front_make_a_reservation', 'frontend', 'Label / Make a reservation', 'script', NULL),
(1087, 'front_free', 'frontend', 'Label / FREE', 'script', NULL),
(1088, 'front_reserved', 'frontend', 'Label / Reserved', 'script', NULL),
(1089, 'front_login_your_account', 'frontend', 'Label / Login your account', 'script', NULL),
(1090, 'front_manage_your_listing', 'frontend', 'Label / and manage your listing', 'script', NULL),
(1091, 'front_login', 'frontend', 'Label / Login', 'script', NULL),
(1092, 'front_forgot_password', 'frontend', 'Label / Forgot your password?', 'script', NULL),
(1093, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(1094, 'front_email_required', 'frontend', 'Label / Email is required.', 'script', NULL),
(1095, 'front_email_invalid', 'frontend', 'Label / Email is invalid.', 'script', NULL),
(1096, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(1097, 'front_password_required', 'frontend', 'Label / Password is required.', 'script', NULL),
(1098, 'front_create_an_account', 'frontend', 'Label / Create an account', 'script', NULL),
(1099, 'register_err_ARRAY_101', 'arrays', 'register_err_ARRAY_101', 'script', NULL),
(1100, 'register_err_ARRAY_102', 'arrays', 'register_err_ARRAY_102', 'script', NULL),
(1101, 'register_err_ARRAY_103', 'arrays', 'register_err_ARRAY_103', 'script', NULL),
(1102, 'register_err_ARRAY_104', 'arrays', 'register_err_ARRAY_104', 'script', NULL),
(1103, 'register_err_ARRAY_105', 'arrays', 'register_err_ARRAY_105', 'script', NULL),
(1104, 'register_err_ARRAY_106', 'arrays', 'register_err_ARRAY_106', 'script', NULL),
(1105, 'register_err_ARRAY_107', 'arrays', 'register_err_ARRAY_107', 'script', NULL),
(1106, 'register_err_ARRAY_108', 'arrays', 'register_err_ARRAY_108', 'script', NULL),
(1107, 'register_err_ARRAY_109', 'arrays', 'register_err_ARRAY_109', 'script', NULL),
(1108, 'register_err_ARRAY_110', 'arrays', 'register_err_ARRAY_110', 'script', NULL),
(1109, 'register_err_ARRAY_111', 'arrays', 'register_err_ARRAY_111', 'script', NULL),
(1110, 'register_err_ARRAY_112', 'arrays', 'register_err_ARRAY_112', 'script', NULL),
(1111, 'register_err_ARRAY_113', 'arrays', 'register_err_ARRAY_113', 'script', NULL),
(1112, 'register_statuses_ARRAY_200', 'arrays', 'register_statuses_ARRAY_200', 'script', NULL),
(1113, 'register_statuses_ARRAY_201', 'arrays', 'register_statuses_ARRAY_201', 'script', NULL),
(1114, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(1115, 'front_name_required', 'frontend', 'Label / Name is required.', 'script', NULL);
INSERT INTO `yachtlisting_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1116, 'front_reenter_password', 'frontend', 'Label / Re-enter password', 'script', NULL),
(1117, 'front_reenter_password_required', 'frontend', 'Label / Re-enter password is required.', 'script', NULL),
(1118, 'front_password_match', 'frontend', 'Label / Password does not match.', 'script', NULL),
(1119, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(1120, 'front_fax', 'frontend', 'Label / Fax', 'script', NULL),
(1121, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(1122, 'front_captcha_required', 'frontend', 'Label / Captcha is required.', 'script', NULL),
(1123, 'front_captcha_incorrect', 'frontend', 'Label / Captcha is incorrect.', 'script', NULL),
(1124, 'front_button_create', 'frontend', 'Button / Create', 'script', NULL),
(1125, 'front_button_send', 'frontend', 'Button / Send', 'script', NULL),
(1126, 'forgot_err_ARRAY_101', 'arrays', 'forgot_err_ARRAY_101', 'script', NULL),
(1127, 'forgot_err_ARRAY_102', 'arrays', 'forgot_err_ARRAY_102', 'script', NULL),
(1128, 'forgot_err_ARRAY_103', 'arrays', 'forgot_err_ARRAY_103', 'script', NULL),
(1129, 'forgot_err_ARRAY_104', 'arrays', 'forgot_err_ARRAY_104', 'script', NULL),
(1130, 'forgot_statuses_ARRAY_200', 'arrays', 'forgot_statuses_ARRAY_200', 'script', NULL),
(1131, 'front_not_avaialble', 'frontend', 'Label / Not available', 'script', NULL),
(1132, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(1133, 'front_booking', 'frontend', 'Label / Booking', 'script', NULL),
(1134, 'front_selected_yacht', 'frontend', 'Label / Selected Yacht', 'script', NULL),
(1135, 'front_selected_period', 'frontend', 'Label / Selected Period', 'script', NULL),
(1136, 'front_summary', 'frontend', 'Label / Summary', 'script', NULL),
(1137, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(1138, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(1139, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(1140, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(1141, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(1142, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(1143, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(1144, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(1145, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(1146, 'front_zip', 'frontend', 'Label / Zip code', 'script', NULL),
(1147, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(1148, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(1149, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(1150, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(1151, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(1152, 'front_cc_sec', 'frontend', 'Label / CC code', 'script', NULL),
(1153, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(1154, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(1155, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(1156, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(1157, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(1158, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(1159, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(1160, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(1161, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(1162, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(1163, 'front_button_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(1164, 'front_button_continue', 'frontend', 'Button / Continue', 'script', NULL),
(1165, 'front_title_required', 'frontend', 'Label / Title is required.', 'script', NULL),
(1166, 'front_phone_required', 'frontend', 'Label / Phone is required.', 'script', NULL),
(1167, 'front_company_required', 'frontend', 'Label / Company is required.', 'script', NULL),
(1168, 'front_address_required', 'frontend', 'Label / Address is required.', 'script', NULL),
(1169, 'front_country_required', 'frontend', 'Label / Country is required.', 'script', NULL),
(1170, 'front_state_required', 'frontend', 'Label / State is required.', 'script', NULL),
(1171, 'front_city_required', 'frontend', 'Label / City is required.', 'script', NULL),
(1172, 'front_zip_required', 'frontend', 'Label / Zip code is required.', 'script', NULL),
(1173, 'front_notes_required', 'frontend', 'Label / Notes is required.', 'script', NULL),
(1174, 'front_payment_method_required', 'frontend', 'Label / Payment method is required.', 'script', NULL),
(1175, 'front_cc_type_required', 'frontend', 'Label / CC type is required.', 'script', NULL),
(1176, 'front_cc_num_required', 'frontend', 'Label / CC number is required.', 'script', NULL),
(1177, 'front_cc_code_required', 'frontend', 'Label / CC code is required.', 'script', NULL),
(1178, 'front_booking_processing', 'frontend', 'Label / Your booking is processing. Please wait...', 'script', NULL),
(1179, 'front_booking_not_saved', 'frontend', 'Label / The booking could not be saved.', 'script', NULL),
(1180, 'front_booking_statuses_ARRAY_11', 'arrays', 'front_booking_statuses_ARRAY_11', 'script', NULL),
(1181, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(1182, 'front_cancel_heading', 'frontend', 'Label / Cancel booking', 'script', NULL),
(1183, 'front_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(1184, 'front_sub_total', 'frontend', 'Label / Sub-total', 'script', NULL),
(1185, 'front_booking_created', 'frontend', 'Label / Booking created', 'script', NULL),
(1186, 'front_button_confirm', 'frontend', 'Button / Cancel', 'script', NULL),
(1187, 'front_personal_details', 'frontend', 'Label / Personal details', 'script', NULL),
(1188, 'front_booking_details', 'frontend', 'Label / Booking details', 'script', NULL),
(1189, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(1190, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(1191, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(1192, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(1193, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(1194, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(1195, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(1196, 'front_contact_details', 'frontend', 'Label / Contact Details', 'script', NULL),
(1197, 'yacht_types_ARRAY_rent', 'arrays', 'yacht_types_ARRAY_rent', 'script', NULL),
(1198, 'yacht_types_ARRAY_sale', 'arrays', 'yacht_types_ARRAY_sale', 'script', NULL),
(1199, 'front_book_now', 'frontend', 'Label / Book Now', 'script', NULL),
(1200, 'front_enter_booking_details', 'frontend', 'Label / Enter your details to complete booking', 'script', NULL),
(1201, 'lblPerWeek', 'backend', 'Label / per week', 'script', NULL),
(1202, 'opt_o_speed', 'backend', 'Options / Speed in', 'script', NULL),
(1203, 'lblHours', 'backend', 'Label / hours', 'script', NULL),
(1204, 'front_hours', 'frontend', 'Label / hours', 'script', NULL),
(1205, 'menuReservations', 'backend', 'Menu / Reservations', 'script', NULL),
(1206, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(1207, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(1208, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(1209, 'tabAddReservation', 'backend', 'Tab / Add reservation', 'script', NULL),
(1210, 'infoBookingsListTitle', 'backend', 'Infobox / List of bookings', 'script', NULL),
(1211, 'infoBookingsListDesc', 'backend', 'Infobox / List of bookings', 'script', NULL),
(1212, 'lblTotalPrice', 'backend', 'Label / Price', 'script', NULL),
(1213, 'lblFrom', 'backend', 'Label / from', 'script', NULL),
(1214, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(1215, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(1216, 'infoAddBookingTitle', 'backend', 'Infobox / Add new reservation', 'script', NULL),
(1217, 'infoAddBookingDesc', 'backend', 'Infobox / Add new reservation', 'script', NULL),
(1218, 'lblBookingDetails', 'backend', 'Label / Reservation details', 'script', NULL),
(1219, 'lblClientDetails', 'backend', 'Label / Client details', 'script', NULL),
(1220, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(1221, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(1222, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(1223, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(1224, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(1225, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(1226, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(1227, 'lblCCExp', 'backend', 'Label / CC expiration', 'script', NULL),
(1228, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(1229, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(1230, 'lblBookingName', 'backend', 'Label / Name', 'script', NULL),
(1231, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(1232, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(1233, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(1234, 'lblBookingCompany', 'backend', 'Label / Company', 'script', NULL),
(1235, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(1236, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(1237, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(1238, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(1239, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(1240, 'tabUpdateReservation', 'backend', 'Label / Update reservation', 'script', NULL),
(1241, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update reservation', 'script', NULL),
(1242, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update reservation', 'script', NULL),
(1243, 'lblCreated', 'backend', 'Label / Created', 'script', NULL),
(1244, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(1245, 'lblResendConfirmation', 'backend', 'Label / Resend confirmation', 'script', NULL),
(1246, 'infoResendTitle', 'backend', 'Infobox / Resend confirmation', 'script', NULL),
(1247, 'infoResendDesc', 'backend', 'Infobox / Resend confirmation', 'script', NULL),
(1248, 'lblConfirmationEmail', 'backend', 'Label / Confirmation email', 'script', NULL),
(1249, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(1250, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(1251, 'lblPaymentEmail', 'backend', 'Label / Payment email', 'script', NULL),
(1252, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(1253, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(1254, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(1255, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(1256, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(1257, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(1258, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(1259, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(1260, 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
(1261, 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
(1262, 'lblYachtForSale', 'backend', 'Label / yachts for sale', 'script', NULL),
(1263, 'lblYachtsForSale', 'backend', 'Label / yachts for sale', 'script', NULL),
(1264, 'lblYachtForRent', 'backend', 'Label / yacht for rent', 'script', NULL),
(1265, 'lblYachtsForRent', 'backend', 'Label / yachts for rent', 'script', NULL),
(1266, 'lblRentalReservation', 'backend', 'Label / rental reservation', 'script', NULL),
(1267, 'lblRentalReservations', 'backend', 'Label / rental reservations', 'script', NULL),
(1268, 'lblMostPopular', 'backend', 'Label / Most Popular', 'script', NULL),
(1269, 'lblViewAll', 'backend', 'Label / View all', 'script', NULL),
(1272, 'lblReservationID', 'backend', 'Label / Reservation ID', 'script', NULL),
(1274, 'lblYachtsNotFound', 'backend', 'Label / Yachts not found', 'script', NULL),
(1275, 'lblReservationsNotFound', 'backend', 'Label / Reservations not found', 'script', NULL),
(1276, 'lblLatestReservations', 'backend', 'Label / Latest Reservations', 'script', NULL),
(1277, 'lblReservations', 'backend', 'Label / Reservations', 'script', NULL),
(1278, 'system_124', 'frontend', 'Label / The selected week is not available.', 'script', NULL),
(1457, 'lblEnterDigitsOnly', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(1458, 'lblMinLength', 'backend', 'Label / Please, enter 4 digits.', 'script', NULL),
(1459, 'lblMaxLength', 'backend', 'Label / Please, enter 4 digits.', 'script', NULL),
(1460, 'lblMaxFiveLength', 'backend', 'Label / Please enter no more than 5 digits.', 'script', NULL),
(1461, 'lblNoWeeklyPrices', 'backend', 'Label / There are no weekly prices added for the yacht.', 'script', NULL);

INSERT INTO `yachtlisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjExtra', 1, 'name', 'A Must See! Cabin', 'data'),
(NULL, 1, 'pjExtra', 2, 'name', 'A Must See! Cabin', 'data'),
(NULL, 1, 'pjExtra', 3, 'name', 'A Must See! Cabin', 'data'),
(NULL, 2, 'pjExtra', 1, 'name', 'Cockpit Carpet Liner', 'data'),
(NULL, 2, 'pjExtra', 2, 'name', 'Cockpit Carpet Liner', 'data'),
(NULL, 2, 'pjExtra', 3, 'name', 'Cockpit Carpet Liner', 'data'),
(NULL, 3, 'pjExtra', 1, 'name', 'Cockpit Refrigerator', 'data'),
(NULL, 3, 'pjExtra', 2, 'name', 'Cockpit Refrigerator', 'data'),
(NULL, 3, 'pjExtra', 3, 'name', 'Cockpit Refrigerator', 'data'),
(NULL, 4, 'pjExtra', 1, 'name', 'Microwave', 'data'),
(NULL, 4, 'pjExtra', 2, 'name', 'Microwave', 'data'),
(NULL, 4, 'pjExtra', 3, 'name', 'Microwave', 'data'),
(NULL, 5, 'pjExtra', 1, 'name', 'Cockpit Cover', 'data'),
(NULL, 5, 'pjExtra', 2, 'name', 'Cockpit Cover', 'data'),
(NULL, 5, 'pjExtra', 3, 'name', 'Cockpit Cover', 'data'),
(NULL, 6, 'pjExtra', 1, 'name', 'Shore Power Charger', 'data'),
(NULL, 6, 'pjExtra', 2, 'name', 'Shore Power w/ Charger 120v/12v', 'data'),
(NULL, 6, 'pjExtra', 3, 'name', 'Shore Power w/ Charger 120v/12v', 'data'),
(NULL, 7, 'pjExtra', 1, 'name', 'V-Berth', 'data'),
(NULL, 7, 'pjExtra', 2, 'name', 'V-Berth', 'data'),
(NULL, 7, 'pjExtra', 3, 'name', 'V-Berth', 'data'),
(NULL, 8, 'pjExtra', 1, 'name', 'Galley and Head - Never Used', 'data'),
(NULL, 8, 'pjExtra', 2, 'name', 'Galley and Head - Never Used', 'data'),
(NULL, 8, 'pjExtra', 3, 'name', 'Galley and Head - Never Used', 'data'),
(NULL, 9, 'pjExtra', 1, 'name', 'Very Low Engine Hours', 'data'),
(NULL, 9, 'pjExtra', 2, 'name', 'Very Low Engine Hours', 'data'),
(NULL, 9, 'pjExtra', 3, 'name', 'Very Low Engine Hours', 'data'),
(NULL, 10, 'pjExtra', 1, 'name', 'Very Well Maintained', 'data'),
(NULL, 10, 'pjExtra', 2, 'name', 'Very Well Maintained', 'data'),
(NULL, 10, 'pjExtra', 3, 'name', 'Very Well Maintained', 'data'),
(NULL, 11, 'pjExtra', 1, 'name', 'A Must See! Cabin', 'data'),
(NULL, 11, 'pjExtra', 2, 'name', 'A Must See! Cabin', 'data'),
(NULL, 11, 'pjExtra', 3, 'name', 'A Must See! Cabin', 'data'),
(NULL, 12, 'pjExtra', 1, 'name', 'U-Shaped Forward Dinette Lounge', 'data'),
(NULL, 12, 'pjExtra', 2, 'name', 'U-Shaped Forward Dinette Lounge/Double Berth w/ High Gloss Solid Wood Table and Filler Cushions', 'data'),
(NULL, 12, 'pjExtra', 3, 'name', 'U-Shaped Forward Dinette Lounge/Double Berth w/ High Gloss Solid Wood Table and Filler Cushions', 'data'),
(NULL, 13, 'pjExtra', 1, 'name', 'Lighted Hanging Locker', 'data'),
(NULL, 13, 'pjExtra', 2, 'name', 'Lighted Hanging Locker', 'data'),
(NULL, 13, 'pjExtra', 3, 'name', 'Lighted Hanging Locker', 'data'),
(NULL, 14, 'pjExtra', 1, 'name', 'Enclosed Head', 'data'),
(NULL, 14, 'pjExtra', 2, 'name', 'Enclosed Head', 'data'),
(NULL, 14, 'pjExtra', 3, 'name', 'Enclosed Head', 'data'),
(NULL, 15, 'pjExtra', 1, 'name', 'Carbon Monoxide Detector', 'data'),
(NULL, 15, 'pjExtra', 2, 'name', 'Carbon Monoxide Detector', 'data'),
(NULL, 15, 'pjExtra', 3, 'name', 'Carbon Monoxide Detector', 'data'),
(NULL, 16, 'pjExtra', 1, 'name', 'Deck Hatch', 'data'),
(NULL, 16, 'pjExtra', 2, 'name', 'Deck Hatch', 'data'),
(NULL, 16, 'pjExtra', 3, 'name', 'Deck Hatch', 'data'),
(NULL, 17, 'pjExtra', 1, 'name', 'Ultra-Leather Interior', 'data'),
(NULL, 17, 'pjExtra', 2, 'name', 'Ultra-Leather Interior', 'data'),
(NULL, 17, 'pjExtra', 3, 'name', 'Ultra-Leather Interior', 'data'),
(NULL, 18, 'pjExtra', 1, 'name', 'Wetbar w/ Refrigerator', 'data'),
(NULL, 18, 'pjExtra', 2, 'name', 'Wetbar w/ Refrigerator and Corian (c) Countertop', 'data'),
(NULL, 18, 'pjExtra', 3, 'name', 'Wetbar w/ Refrigerator and Corian (c) Countertop', 'data'),
(NULL, 19, 'pjExtra', 1, 'name', 'Walk Thru Windshield', 'data'),
(NULL, 19, 'pjExtra', 2, 'name', 'Walk Thru Windshield', 'data'),
(NULL, 19, 'pjExtra', 3, 'name', 'Walk Thru Windshield', 'data'),
(NULL, 20, 'pjExtra', 1, 'name', 'Ritchie Compass', 'data'),
(NULL, 20, 'pjExtra', 2, 'name', 'Ritchie Compass', 'data'),
(NULL, 20, 'pjExtra', 3, 'name', 'Ritchie Compass', 'data'),
(NULL, 21, 'pjExtra', 1, 'name', 'Livorsi Shifters/Throttles', 'data'),
(NULL, 21, 'pjExtra', 2, 'name', 'Livorsi Shifters/Throttles', 'data'),
(NULL, 21, 'pjExtra', 3, 'name', 'Livorsi Shifters/Throttles', 'data'),
(NULL, 22, 'pjExtra', 1, 'name', 'Tilt Steering', 'data'),
(NULL, 22, 'pjExtra', 2, 'name', 'Tilt Steering', 'data'),
(NULL, 22, 'pjExtra', 3, 'name', 'Tilt Steering', 'data'),
(NULL, 23, 'pjExtra', 1, 'name', 'Hydraulic Steering', 'data'),
(NULL, 23, 'pjExtra', 2, 'name', 'Hydraulic Steering', 'data'),
(NULL, 23, 'pjExtra', 3, 'name', 'Hydraulic Steering', 'data'),
(NULL, 24, 'pjExtra', 1, 'name', 'Twin Command Seating', 'data'),
(NULL, 24, 'pjExtra', 2, 'name', 'Twin Command Seating w/ Dual Position Helm and Companion Seats', 'data'),
(NULL, 24, 'pjExtra', 3, 'name', 'Twin Command Seating w/ Dual Position Helm and Companion Seats', 'data'),
(NULL, 25, 'pjExtra', 1, 'name', 'Port Lounge', 'data'),
(NULL, 25, 'pjExtra', 2, 'name', 'Port Lounge w/ Integrated Dive Tank Storage', 'data'),
(NULL, 25, 'pjExtra', 3, 'name', 'Port Lounge w/ Integrated Dive Tank Storage', 'data'),
(NULL, 26, 'pjExtra', 1, 'name', 'U-Shaped Aft Lounge Seating', 'data'),
(NULL, 26, 'pjExtra', 2, 'name', 'U-Shaped Aft Lounge Seating w/ Storage', 'data'),
(NULL, 26, 'pjExtra', 3, 'name', 'U-Shaped Aft Lounge Seating w/ Storage', 'data'),
(NULL, 27, 'pjExtra', 1, 'name', 'Dual-Height Cockpit Tables', 'data'),
(NULL, 27, 'pjExtra', 2, 'name', 'Dual-Height Cockpit Tables', 'data'),
(NULL, 27, 'pjExtra', 3, 'name', 'Dual-Height Cockpit Tables', 'data'),
(NULL, 28, 'pjExtra', 1, 'name', 'In-Floor Ski Storage', 'data'),
(NULL, 28, 'pjExtra', 2, 'name', 'In-Floor Ski Storage', 'data'),
(NULL, 28, 'pjExtra', 3, 'name', 'In-Floor Ski Storage', 'data'),
(NULL, 29, 'pjExtra', 1, 'name', 'Concealed Fender Storage', 'data'),
(NULL, 29, 'pjExtra', 2, 'name', 'Concealed Fender Storage', 'data'),
(NULL, 29, 'pjExtra', 3, 'name', 'Concealed Fender Storage', 'data'),
(NULL, 30, 'pjExtra', 1, 'name', 'Motorized Engine Hatch Lift', 'data'),
(NULL, 30, 'pjExtra', 2, 'name', 'Motorized Engine Hatch Lift', 'data'),
(NULL, 30, 'pjExtra', 3, 'name', 'Motorized Engine Hatch Lift', 'data'),
(NULL, 31, 'pjExtra', 1, 'name', 'Windlass', 'data'),
(NULL, 31, 'pjExtra', 2, 'name', 'Windlass', 'data'),
(NULL, 31, 'pjExtra', 3, 'name', 'Windlass', 'data'),
(NULL, 32, 'pjExtra', 1, 'name', 'Full camper enclosure', 'data'),
(NULL, 32, 'pjExtra', 2, 'name', 'Full camper enclosure', 'data'),
(NULL, 32, 'pjExtra', 3, 'name', 'Full camper enclosure', 'data'),
(NULL, 33, 'pjExtra', 1, 'name', 'Vacu flush head', 'data'),
(NULL, 33, 'pjExtra', 2, 'name', 'Vacu flush head', 'data'),
(NULL, 33, 'pjExtra', 3, 'name', 'Vacu flush head', 'data'),
(NULL, 34, 'pjExtra', 1, 'name', 'Electronics', 'data'),
(NULL, 34, 'pjExtra', 2, 'name', 'Electronics', 'data'),
(NULL, 34, 'pjExtra', 3, 'name', 'Electronics', 'data'),
(NULL, 35, 'pjExtra', 1, 'name', 'Garmin GPS Map 172C', 'data'),
(NULL, 35, 'pjExtra', 2, 'name', 'Garmin GPS Map 172C', 'data'),
(NULL, 35, 'pjExtra', 3, 'name', 'Garmin GPS Map 172C', 'data'),
(NULL, 36, 'pjExtra', 1, 'name', 'Standard Horizon VHF', 'data'),
(NULL, 36, 'pjExtra', 2, 'name', 'Standard Horizon VHF', 'data'),
(NULL, 36, 'pjExtra', 3, 'name', 'Standard Horizon VHF', 'data'),
(NULL, 37, 'pjExtra', 1, 'name', 'Depthfinder', 'data'),
(NULL, 37, 'pjExtra', 2, 'name', 'Depthfinder', 'data'),
(NULL, 37, 'pjExtra', 3, 'name', 'Depthfinder', 'data'),
(NULL, 38, 'pjExtra', 1, 'name', 'Stereo', 'data'),
(NULL, 38, 'pjExtra', 2, 'name', 'Stereo', 'data'),
(NULL, 38, 'pjExtra', 3, 'name', 'Stereo', 'data'),
(NULL, 39, 'pjExtra', 1, 'name', 'Stereo Remote at Helm', 'data'),
(NULL, 39, 'pjExtra', 2, 'name', 'Stereo Remote at Helm', 'data'),
(NULL, 39, 'pjExtra', 3, 'name', 'Stereo Remote at Helm', 'data'),
(NULL, 1, 'pjFeature', 1, 'name', 'Power Boats', 'data'),
(NULL, 1, 'pjFeature', 2, 'name', 'Power Boats', 'data'),
(NULL, 1, 'pjFeature', 3, 'name', 'Power Boats', 'data'),
(NULL, 2, 'pjFeature', 1, 'name', 'Sailboats', 'data'),
(NULL, 2, 'pjFeature', 2, 'name', 'Sailboats', 'data'),
(NULL, 2, 'pjFeature', 3, 'name', 'Sailboats', 'data'),
(NULL, 3, 'pjFeature', 1, 'name', 'Small Boats', 'data'),
(NULL, 3, 'pjFeature', 2, 'name', 'Small Boats', 'data'),
(NULL, 3, 'pjFeature', 3, 'name', 'Small Boats', 'data'),
(NULL, 4, 'pjFeature', 1, 'name', 'PWC', 'data'),
(NULL, 4, 'pjFeature', 2, 'name', 'PWC', 'data'),
(NULL, 4, 'pjFeature', 3, 'name', 'PWC', 'data'),
(NULL, 5, 'pjFeature', 1, 'name', 'diesel', 'data'),
(NULL, 5, 'pjFeature', 2, 'name', 'diesel', 'data'),
(NULL, 5, 'pjFeature', 3, 'name', 'diesel', 'data'),
(NULL, 6, 'pjFeature', 1, 'name', 'gas', 'data'),
(NULL, 6, 'pjFeature', 2, 'name', 'gas', 'data'),
(NULL, 6, 'pjFeature', 3, 'name', 'gas', 'data'),
(NULL, 7, 'pjFeature', 1, 'name', 'electric', 'data'),
(NULL, 7, 'pjFeature', 2, 'name', 'electric', 'data'),
(NULL, 7, 'pjFeature', 3, 'name', 'electric', 'data'),
(NULL, 8, 'pjFeature', 1, 'name', 'other', 'data'),
(NULL, 8, 'pjFeature', 2, 'name', 'other', 'data'),
(NULL, 8, 'pjFeature', 3, 'name', 'other', 'data'),
(NULL, 9, 'pjFeature', 1, 'name', 'Direct Drive', 'data'),
(NULL, 9, 'pjFeature', 2, 'name', 'Direct Drive', 'data'),
(NULL, 9, 'pjFeature', 3, 'name', 'Direct Drive', 'data'),
(NULL, 10, 'pjFeature', 1, 'name', 'Jet Drive', 'data'),
(NULL, 10, 'pjFeature', 2, 'name', 'Jet Drive', 'data'),
(NULL, 10, 'pjFeature', 3, 'name', 'Jet Drive', 'data'),
(NULL, 11, 'pjFeature', 1, 'name', 'None', 'data'),
(NULL, 11, 'pjFeature', 2, 'name', 'None', 'data'),
(NULL, 11, 'pjFeature', 3, 'name', 'None', 'data'),
(NULL, 12, 'pjFeature', 1, 'name', 'Other', 'data'),
(NULL, 12, 'pjFeature', 2, 'name', 'Other', 'data'),
(NULL, 12, 'pjFeature', 3, 'name', 'Other', 'data'),
(NULL, 13, 'pjFeature', 1, 'name', 'Single', 'data'),
(NULL, 13, 'pjFeature', 2, 'name', 'Single', 'data'),
(NULL, 13, 'pjFeature', 3, 'name', 'Single', 'data'),
(NULL, 14, 'pjFeature', 1, 'name', 'Single I/O', 'data'),
(NULL, 14, 'pjFeature', 2, 'name', 'Single I/O', 'data'),
(NULL, 14, 'pjFeature', 3, 'name', 'Single I/O', 'data'),
(NULL, 15, 'pjFeature', 1, 'name', 'Twin', 'data'),
(NULL, 15, 'pjFeature', 2, 'name', 'Twin', 'data'),
(NULL, 15, 'pjFeature', 3, 'name', 'Twin', 'data'),
(NULL, 16, 'pjFeature', 1, 'name', 'Twin I/O', 'data'),
(NULL, 16, 'pjFeature', 2, 'name', 'Twin I/O', 'data'),
(NULL, 16, 'pjFeature', 3, 'name', 'Twin I/O', 'data'),
(NULL, 17, 'pjFeature', 1, 'name', 'Twin Outboard', 'data'),
(NULL, 17, 'pjFeature', 2, 'name', 'Twin Outboard', 'data'),
(NULL, 17, 'pjFeature', 3, 'name', 'Twin Outboard', 'data'),
(NULL, 18, 'pjFeature', 1, 'name', 'Triple I/O', 'data'),
(NULL, 18, 'pjFeature', 2, 'name', 'Triple I/O', 'data'),
(NULL, 18, 'pjFeature', 3, 'name', 'Triple I/O', 'data'),
(NULL, 19, 'pjFeature', 1, 'name', 'Triple Outboard', 'data'),
(NULL, 19, 'pjFeature', 2, 'name', 'Triple Outboard', 'data'),
(NULL, 19, 'pjFeature', 3, 'name', 'Triple Outboard', 'data'),
(NULL, 20, 'pjFeature', 1, 'name', 'V-Drive', 'data'),
(NULL, 20, 'pjFeature', 2, 'name', 'V-Drive', 'data'),
(NULL, 20, 'pjFeature', 3, 'name', 'V-Drive', 'data'),
(NULL, 21, 'pjFeature', 1, 'name', 'Aluminum', 'data'),
(NULL, 21, 'pjFeature', 2, 'name', 'Aluminum', 'data'),
(NULL, 21, 'pjFeature', 3, 'name', 'Aluminum', 'data'),
(NULL, 22, 'pjFeature', 1, 'name', 'Ferro-Cement', 'data'),
(NULL, 22, 'pjFeature', 2, 'name', 'Ferro-Cement', 'data'),
(NULL, 22, 'pjFeature', 3, 'name', 'Ferro-Cement', 'data'),
(NULL, 23, 'pjFeature', 1, 'name', 'Fiberglass/Composite', 'data'),
(NULL, 23, 'pjFeature', 2, 'name', 'Fiberglass/Composite', 'data'),
(NULL, 23, 'pjFeature', 3, 'name', 'Fiberglass/Composite', 'data'),
(NULL, 24, 'pjFeature', 1, 'name', 'Fiberglass Reinforced', 'data'),
(NULL, 24, 'pjFeature', 2, 'name', 'Fiberglass Reinforced', 'data'),
(NULL, 24, 'pjFeature', 3, 'name', 'Fiberglass Reinforced', 'data'),
(NULL, 25, 'pjFeature', 1, 'name', 'Inflatable', 'data'),
(NULL, 25, 'pjFeature', 2, 'name', 'Inflatable', 'data'),
(NULL, 25, 'pjFeature', 3, 'name', 'Inflatable', 'data'),
(NULL, 26, 'pjFeature', 1, 'name', 'Other', 'data'),
(NULL, 26, 'pjFeature', 2, 'name', 'Other', 'data'),
(NULL, 26, 'pjFeature', 3, 'name', 'Other', 'data'),
(NULL, 27, 'pjFeature', 1, 'name', 'Plastic', 'data'),
(NULL, 27, 'pjFeature', 2, 'name', 'Plastic', 'data'),
(NULL, 27, 'pjFeature', 3, 'name', 'Plastic', 'data'),
(NULL, 28, 'pjFeature', 1, 'name', 'Rigid Inflatable', 'data'),
(NULL, 28, 'pjFeature', 2, 'name', 'Rigid Inflatable', 'data'),
(NULL, 28, 'pjFeature', 3, 'name', 'Rigid Inflatable', 'data'),
(NULL, 29, 'pjFeature', 1, 'name', 'Steel', 'data'),
(NULL, 29, 'pjFeature', 2, 'name', 'Steel', 'data'),
(NULL, 29, 'pjFeature', 3, 'name', 'Steel', 'data'),
(NULL, 30, 'pjFeature', 1, 'name', 'Wood', 'data'),
(NULL, 30, 'pjFeature', 2, 'name', 'Wood', 'data'),
(NULL, 30, 'pjFeature', 3, 'name', 'Wood', 'data'),
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'User with such email address exists.', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script');
INSERT INTO `yachtlisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Client with such email address exists.', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Yachts', 'script'),
(NULL, 540, 'pjField', 2, 'title', 'Yachts', 'script'),
(NULL, 540, 'pjField', 3, 'title', 'Yachts', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 541, 'pjField', 2, 'title', 'General', 'script'),
(NULL, 541, 'pjField', 3, 'title', 'General', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Submissions', 'script'),
(NULL, 542, 'pjField', 2, 'title', 'Submissions', 'script'),
(NULL, 542, 'pjField', 3, 'title', 'Submissions', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Manufacturers', 'script'),
(NULL, 543, 'pjField', 2, 'title', 'Manufacturers', 'script'),
(NULL, 543, 'pjField', 3, 'title', 'Manufacturers', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 544, 'pjField', 2, 'title', 'Extras', 'script'),
(NULL, 544, 'pjField', 3, 'title', 'Extras', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 545, 'pjField', 2, 'title', 'Features', 'script'),
(NULL, 545, 'pjField', 3, 'title', 'Features', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 546, 'pjField', 2, 'title', 'Reservations', 'script'),
(NULL, 546, 'pjField', 3, 'title', 'Reservations', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'Payments', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'Payments', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 548, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 548, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Reservation form', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'Reservation form', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'Reservation form', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Customers', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'Customers', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'Customers', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Owners', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'Owners', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'Owners', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Administrators', 'script'),
(NULL, 552, 'pjField', 2, 'title', 'Administrators', 'script'),
(NULL, 552, 'pjField', 3, 'title', 'Administrators', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Show length in', 'script'),
(NULL, 553, 'pjField', 2, 'title', 'Show length in', 'script'),
(NULL, 553, 'pjField', 3, 'title', 'Show length in', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Show fuel in', 'script'),
(NULL, 554, 'pjField', 2, 'title', 'Show fuel in', 'script'),
(NULL, 554, 'pjField', 3, 'title', 'Show fuel in', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Show power in', 'script'),
(NULL, 555, 'pjField', 2, 'title', 'Show power in', 'script'),
(NULL, 555, 'pjField', 3, 'title', 'Show power in', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 556, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 556, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Yacht Submissions by Users', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'Yacht Submissions by Users', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'Yacht Submissions by Users', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'You can allow/disallow website users to submit their own yachts after registering into the system. These users are named ''Owner''. You can manage owner''s accounts through Users menu. You can also charge owners for publishing their yachts. If you wish to enable user submissions set carefully all options bellow and also set the Notifications tab options.', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'You can allow/disallow website users to submit their own yachts after registering into the system. These users are named ''Owner''. You can manage owner''s accounts through Users menu. You can also charge owners for publishing their yachts. If you wish to enable user submissions set carefully all options bellow and also set the Notifications tab options.', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'You can allow/disallow website users to submit their own yachts after registering into the system. These users are named ''Owner''. You can manage owner''s accounts through Users menu. You can also charge owners for publishing their yachts. If you wish to enable user submissions set carefully all options bellow and also set the Notifications tab options.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Allow users to submit yachts', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'Allow users to submit yachts', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'Allow users to submit yachts', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Automatically activate new owner accounts', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Automatically activate new owner accounts', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Automatically activate new owner accounts', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Set your PayPal address', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'Set your PayPal address', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'Set your PayPal address', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'If you choose ''Yes'' new owner accounts will be active immediately after they are created. If you choose ''No'' you will have to activate new accounts manually (through Users menu), and after that owners will be able to log in and use them.', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'If you choose ''Yes'' new owner accounts will be active immediately after they are created. If you choose ''No'' you will have to activate new accounts manually (through Users menu), and after that owners will be able to log in and use them.', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'If you choose ''Yes'' new owner accounts will be active immediately after they are created. If you choose ''No'' you will have to activate new accounts manually (through Users menu), and after that owners will be able to log in and use them.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Set prices for submitting yachts by owners. You can charge different price according to the length of time that the yacht is active (visible) on your listing. To do this add and manage "period / price" rows below. If you wish to set a "free trial" period then set the number of the days and set "0" into the price field. If you do not wish to charge owners for submitting their yachts, then leave just one "period / price" row, define a relevant large number of days into the period filed, and set "0" into the price field.', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Set prices for submitting yachts by owners. You can charge different price according to the length of time that the yacht is active (visible) on your listing. To do this add and manage "period / price" rows below. If you wish to set a "free trial" period then set the number of the days and set "0" into the price field. If you do not wish to charge owners for submitting their yachts, then leave just one "period / price" row, define a relevant large number of days into the period filed, and set "0" into the price field.', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Set prices for submitting yachts by owners. You can charge different price according to the length of time that the yacht is active (visible) on your listing. To do this add and manage "period / price" rows below. If you wish to set a "free trial" period then set the number of the days and set "0" into the price field. If you do not wish to charge owners for submitting their yachts, then leave just one "period / price" row, define a relevant large number of days into the period filed, and set "0" into the price field.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Period', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Period', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 567, 'pjField', 1, 'title', '+ Add period / price', 'script'),
(NULL, 567, 'pjField', 2, 'title', '+ Add period / price', 'script'),
(NULL, 567, 'pjField', 3, 'title', '+ Add period / price', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Are you sure you want to delete selected period/price?', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'Are you sure you want to delete selected period/price?', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'Are you sure you want to delete selected period/price?', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Payment options', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'Payment options', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'Payment options', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences. Note that for cash payments the system will not be able to collect deposit amount online.', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences. Note that for cash payments the system will not be able to collect deposit amount online.', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences. Note that for cash payments the system will not be able to collect deposit amount online.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Deposit payment', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Deposit payment', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'Tax payment', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'Tax payment', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'PayPal business email address', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'PayPal business email address', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 580, 'pjField', 2, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 580, 'pjField', 3, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 581, 'pjField', 2, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 581, 'pjField', 3, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 582, 'pjField', 2, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 582, 'pjField', 3, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 583, 'pjField', 2, 'title', 'Authorize.net time zone', 'script'),
(NULL, 583, 'pjField', 3, 'title', 'Authorize.net time zone', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 584, 'pjField', 2, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 584, 'pjField', 3, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Allow payment with cash', 'script'),
(NULL, 585, 'pjField', 2, 'title', 'Allow payment with cash', 'script'),
(NULL, 585, 'pjField', 3, 'title', 'Allow payment with cash', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 586, 'pjField', 2, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 586, 'pjField', 3, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 587, 'pjField', 2, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 587, 'pjField', 3, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 588, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 588, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Reservation form', 'script'),
(NULL, 589, 'pjField', 2, 'title', 'Reservation form', 'script'),
(NULL, 589, 'pjField', 3, 'title', 'Reservation form', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 590, 'pjField', 2, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 590, 'pjField', 3, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 591, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 591, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 592, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 592, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 593, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 593, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 594, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 594, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 595, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 595, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 596, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 596, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 597, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 597, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 598, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 598, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 599, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 599, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 600, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 600, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 601, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 601, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 602, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 602, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 603, 'pjField', 2, 'title', 'To customers', 'script'),
(NULL, 603, 'pjField', 3, 'title', 'To customers', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'To owners', 'script'),
(NULL, 604, 'pjField', 2, 'title', 'To owners', 'script'),
(NULL, 604, 'pjField', 3, 'title', 'To owners', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 605, 'pjField', 2, 'title', 'To administrators', 'script'),
(NULL, 605, 'pjField', 3, 'title', 'To administrators', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 606, 'pjField', 2, 'title', 'Emails', 'script'),
(NULL, 606, 'pjField', 3, 'title', 'Emails', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 607, 'pjField', 2, 'title', 'SMS', 'script'),
(NULL, 607, 'pjField', 3, 'title', 'SMS', 'script'),
(NULL, 608, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{Address}\r\n{Notes}\r\n{Yacht}\r\n{BookingID}\r\n{BookingTime}\r\n{SubTotal}\r\n{Tax}\r\n{Total}\r\n{Deposit}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 608, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{Address}\r\n{Notes}\r\n{Yacht}\r\n{BookingID}\r\n{BookingTime}\r\n{SubTotal}\r\n{Tax}\r\n{Total}\r\n{Deposit}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 608, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{Address}\r\n{Notes}\r\n{Yacht}\r\n{BookingID}\r\n{BookingTime}\r\n{SubTotal}\r\n{Tax}\r\n{Total}\r\n{Deposit}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 609, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Yacht}\r\n{BookingID}\r\n{BookingTime}\r\n{SubTotal}\r\n{Tax}\r\n{Total}\r\n{Deposit}', 'script'),
(NULL, 609, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Yacht}\r\n{BookingID}\r\n{BookingTime}\r\n{SubTotal}\r\n{Tax}\r\n{Total}\r\n{Deposit}', 'script'),
(NULL, 609, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Yacht}\r\n{BookingID}\r\n{BookingTime}\r\n{SubTotal}\r\n{Tax}\r\n{Total}\r\n{Deposit}', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Notifications to customers', 'script'),
(NULL, 610, 'pjField', 2, 'title', 'Notifications to customers', 'script'),
(NULL, 610, 'pjField', 3, 'title', 'Notifications to customers', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'These notifications will be sent to customers who rent an yacht. You can set and customize email and SMS notifications to customers to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 611, 'pjField', 2, 'title', 'These notifications will be sent to customers who rent an yacht. You can set and customize email and SMS notifications to customers to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 611, 'pjField', 3, 'title', 'These notifications will be sent to customers who rent an yacht. You can set and customize email and SMS notifications to customers to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 612, 'pjField', 2, 'title', 'New booking received email', 'script'),
(NULL, 612, 'pjField', 3, 'title', 'New booking received email', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 613, 'pjField', 2, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 613, 'pjField', 3, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 614, 'pjField', 2, 'title', 'New booking confirmation subject', 'script'),
(NULL, 614, 'pjField', 3, 'title', 'New booking confirmation subject', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 615, 'pjField', 2, 'title', 'New booking confirmation message', 'script'),
(NULL, 615, 'pjField', 3, 'title', 'New booking confirmation message', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 616, 'pjField', 2, 'title', 'Send payment confirmation email', 'script'),
(NULL, 616, 'pjField', 3, 'title', 'Send payment confirmation email', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 617, 'pjField', 2, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 617, 'pjField', 3, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 618, 'pjField', 2, 'title', 'Payment confirmation subject', 'script'),
(NULL, 618, 'pjField', 3, 'title', 'Payment confirmation subject', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 619, 'pjField', 2, 'title', 'Payment confirmation message', 'script'),
(NULL, 619, 'pjField', 3, 'title', 'Payment confirmation message', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 620, 'pjField', 2, 'title', 'Send cancellation email', 'script'),
(NULL, 620, 'pjField', 3, 'title', 'Send cancellation email', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving cancellation email.', 'script'),
(NULL, 621, 'pjField', 2, 'title', 'Select ''Yes'' if you want to notify your customers for receiving cancellation email.', 'script'),
(NULL, 621, 'pjField', 3, 'title', 'Select ''Yes'' if you want to notify your customers for receiving cancellation email.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 622, 'pjField', 2, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 622, 'pjField', 3, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 623, 'pjField', 2, 'title', 'Cancel confirmation message', 'script'),
(NULL, 623, 'pjField', 3, 'title', 'Cancel confirmation message', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 624, 'pjField', 2, 'title', 'Booking reminder SMS', 'script'),
(NULL, 624, 'pjField', 3, 'title', 'Booking reminder SMS', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Notifications to owners', 'script'),
(NULL, 625, 'pjField', 2, 'title', 'Notifications to owners', 'script'),
(NULL, 625, 'pjField', 3, 'title', 'Notifications to owners', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Set and customize email and SMS notifications to yacht owners to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails using the available tokens.', 'script'),
(NULL, 626, 'pjField', 2, 'title', 'Set and customize email and SMS notifications to yacht owners to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails using the available tokens.', 'script'),
(NULL, 626, 'pjField', 3, 'title', 'Set and customize email and SMS notifications to yacht owners to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails using the available tokens.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Booking - Emails', 'script'),
(NULL, 627, 'pjField', 2, 'title', 'Booking - Emails', 'script'),
(NULL, 627, 'pjField', 3, 'title', 'Booking - Emails', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Bookings - SMS', 'script'),
(NULL, 628, 'pjField', 2, 'title', 'Bookings - SMS', 'script'),
(NULL, 628, 'pjField', 3, 'title', 'Bookings - SMS', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Account - SMS', 'script'),
(NULL, 629, 'pjField', 2, 'title', 'Account - SMS', 'script'),
(NULL, 629, 'pjField', 3, 'title', 'Account - SMS', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Account - Emails', 'script'),
(NULL, 630, 'pjField', 2, 'title', 'Account - Emails', 'script'),
(NULL, 630, 'pjField', 3, 'title', 'Account - Emails', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Registration email', 'script'),
(NULL, 631, 'pjField', 2, 'title', 'Registration email', 'script'),
(NULL, 631, 'pjField', 3, 'title', 'Registration email', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to owners after they created new account. Otherwise select ''No''.', 'script'),
(NULL, 632, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send an email to owners after they created new account. Otherwise select ''No''.', 'script'),
(NULL, 632, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send an email to owners after they created new account. Otherwise select ''No''.', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Registration email subject', 'script'),
(NULL, 633, 'pjField', 2, 'title', 'Registration email subject', 'script'),
(NULL, 633, 'pjField', 3, 'title', 'Registration email subject', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Registration email message', 'script'),
(NULL, 634, 'pjField', 2, 'title', 'Registration email message', 'script'),
(NULL, 634, 'pjField', 3, 'title', 'Registration email message', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'New yacht submitted email', 'script'),
(NULL, 635, 'pjField', 2, 'title', 'New yacht submitted email', 'script'),
(NULL, 635, 'pjField', 3, 'title', 'New yacht submitted email', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to owner after they submitted new yachts to the system. Otherwise select ''No''.', 'script'),
(NULL, 636, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send an email to owner after they submitted new yachts to the system. Otherwise select ''No''.', 'script'),
(NULL, 636, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send an email to owner after they submitted new yachts to the system. Otherwise select ''No''.', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'New yacht submitted email subject', 'script'),
(NULL, 637, 'pjField', 2, 'title', 'New yacht submitted email subject', 'script'),
(NULL, 637, 'pjField', 3, 'title', 'New yacht submitted email subject', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'New yacht submitted email message', 'script'),
(NULL, 638, 'pjField', 2, 'title', 'New yacht submitted email message', 'script'),
(NULL, 638, 'pjField', 3, 'title', 'New yacht submitted email message', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Password recovery email subject', 'script'),
(NULL, 639, 'pjField', 2, 'title', 'Password recovery email subject', 'script'),
(NULL, 639, 'pjField', 3, 'title', 'Password recovery email subject', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Password recovery email message', 'script'),
(NULL, 640, 'pjField', 2, 'title', 'Password recovery email message', 'script'),
(NULL, 640, 'pjField', 3, 'title', 'Password recovery email message', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Registration SMS', 'script'),
(NULL, 641, 'pjField', 2, 'title', 'Registration SMS', 'script'),
(NULL, 641, 'pjField', 3, 'title', 'Registration SMS', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Registration SMS content', 'script'),
(NULL, 642, 'pjField', 2, 'title', 'Registration SMS content', 'script'),
(NULL, 642, 'pjField', 3, 'title', 'Registration SMS content', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'New yacht submitted SMS', 'script'),
(NULL, 643, 'pjField', 2, 'title', 'New yacht submitted SMS', 'script'),
(NULL, 643, 'pjField', 3, 'title', 'New yacht submitted SMS', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'New property submitted SMS content', 'script'),
(NULL, 644, 'pjField', 2, 'title', 'New property submitted SMS content', 'script'),
(NULL, 644, 'pjField', 3, 'title', 'New property submitted SMS content', 'script'),
(NULL, 645, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 645, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 645, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 646, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 646, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 646, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 647, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Password}', 'script'),
(NULL, 647, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Password}', 'script'),
(NULL, 647, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Password}', 'script'),
(NULL, 648, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 648, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 648, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 649, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 649, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 649, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'New booking SMS', 'script'),
(NULL, 650, 'pjField', 2, 'title', 'New booking SMS', 'script'),
(NULL, 650, 'pjField', 3, 'title', 'New booking SMS', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 651, 'pjField', 2, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 651, 'pjField', 3, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 652, 'pjField', 2, 'title', 'New booking received email', 'script'),
(NULL, 652, 'pjField', 3, 'title', 'New booking received email', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Select ''Yes'' if you - owners want to receive email when new booking made. ', 'script'),
(NULL, 653, 'pjField', 2, 'title', 'Select ''Yes'' if you - owners want to receive email when new booking made. ', 'script'),
(NULL, 653, 'pjField', 3, 'title', 'Select ''Yes'' if you - owners want to receive email when new booking made. ', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 654, 'pjField', 2, 'title', 'New booking confirmation subject', 'script'),
(NULL, 654, 'pjField', 3, 'title', 'New booking confirmation subject', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 655, 'pjField', 2, 'title', 'New booking confirmation message', 'script'),
(NULL, 655, 'pjField', 3, 'title', 'New booking confirmation message', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 656, 'pjField', 2, 'title', 'Send payment confirmation email', 'script'),
(NULL, 656, 'pjField', 3, 'title', 'Send payment confirmation email', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Select ''Yes'' if you - owners want to receive email when customers make a payment for their bookings. Otherwise select ''No''.', 'script'),
(NULL, 657, 'pjField', 2, 'title', 'Select ''Yes'' if you - owners want to receive email when customers make a payment for their bookings. Otherwise select ''No''.', 'script'),
(NULL, 657, 'pjField', 3, 'title', 'Select ''Yes'' if you - owners want to receive email when customers make a payment for their bookings. Otherwise select ''No''.', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 658, 'pjField', 2, 'title', 'Payment confirmation subject', 'script'),
(NULL, 658, 'pjField', 3, 'title', 'Payment confirmation subject', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 659, 'pjField', 2, 'title', 'Payment confirmation message', 'script'),
(NULL, 659, 'pjField', 3, 'title', 'Payment confirmation message', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 660, 'pjField', 2, 'title', 'Send cancellation email', 'script'),
(NULL, 660, 'pjField', 3, 'title', 'Send cancellation email', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Select ''Yes'' if you - owners want to received email when customers cancel their bookings. Otherwise select ''No''.', 'script'),
(NULL, 661, 'pjField', 2, 'title', 'Select ''Yes'' if you - owners want to received email when customers cancel their bookings. Otherwise select ''No''.', 'script'),
(NULL, 661, 'pjField', 3, 'title', 'Select ''Yes'' if you - owners want to received email when customers cancel their bookings. Otherwise select ''No''.', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 662, 'pjField', 2, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 662, 'pjField', 3, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 663, 'pjField', 2, 'title', 'Cancel confirmation message', 'script'),
(NULL, 663, 'pjField', 3, 'title', 'Cancel confirmation message', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Notifications to administrators', 'script'),
(NULL, 664, 'pjField', 2, 'title', 'Notifications to administrators', 'script'),
(NULL, 664, 'pjField', 3, 'title', 'Notifications to administrators', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Create customized email and SMS messages that will be sent to administrators (you). You can enable or disable sending of the notifications below. You can also personalize emails using the available tokens.', 'script'),
(NULL, 665, 'pjField', 2, 'title', 'Create customized email and SMS messages that will be sent to administrators (you). You can enable or disable sending of the notifications below. You can also personalize emails using the available tokens.', 'script'),
(NULL, 665, 'pjField', 3, 'title', 'Create customized email and SMS messages that will be sent to administrators (you). You can enable or disable sending of the notifications below. You can also personalize emails using the available tokens.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Registration email', 'script'),
(NULL, 666, 'pjField', 2, 'title', 'Registration email', 'script'),
(NULL, 666, 'pjField', 3, 'title', 'Registration email', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send notification to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 667, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send notification to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 667, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send notification to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Registration email subject', 'script'),
(NULL, 668, 'pjField', 2, 'title', 'Registration email subject', 'script'),
(NULL, 668, 'pjField', 3, 'title', 'Registration email subject', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Registration email message', 'script'),
(NULL, 669, 'pjField', 2, 'title', 'Registration email message', 'script'),
(NULL, 669, 'pjField', 3, 'title', 'Registration email message', 'script'),
(NULL, 670, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 670, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 670, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'New yacht submitted email', 'script'),
(NULL, 671, 'pjField', 2, 'title', 'New yacht submitted email', 'script'),
(NULL, 671, 'pjField', 3, 'title', 'New yacht submitted email', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send notification to administrator after new yacht submitted. Otherwise, select ''No''.', 'script'),
(NULL, 672, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send notification to administrator after new yacht submitted. Otherwise, select ''No''.', 'script'),
(NULL, 672, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send notification to administrator after new yacht submitted. Otherwise, select ''No''.', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'New yacht submitted email subject', 'script'),
(NULL, 673, 'pjField', 2, 'title', 'New yacht submitted email subject', 'script'),
(NULL, 673, 'pjField', 3, 'title', 'New yacht submitted email subject', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'New yacht submitted email message', 'script'),
(NULL, 674, 'pjField', 2, 'title', 'New yacht submitted email message', 'script'),
(NULL, 674, 'pjField', 3, 'title', 'New yacht submitted email message', 'script'),
(NULL, 675, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 675, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 675, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Registration SMS', 'script'),
(NULL, 676, 'pjField', 2, 'title', 'Registration SMS', 'script'),
(NULL, 676, 'pjField', 3, 'title', 'Registration SMS', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 677, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 677, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Registration SMS content', 'script'),
(NULL, 678, 'pjField', 2, 'title', 'Registration SMS content', 'script'),
(NULL, 678, 'pjField', 3, 'title', 'Registration SMS content', 'script'),
(NULL, 679, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 679, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 679, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'New yacht submitted SMS', 'script'),
(NULL, 680, 'pjField', 2, 'title', 'New yacht submitted SMS', 'script'),
(NULL, 680, 'pjField', 3, 'title', 'New yacht submitted SMS', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new yacht submitted. Otherwise, select ''No''.', 'script'),
(NULL, 681, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new yacht submitted. Otherwise, select ''No''.', 'script'),
(NULL, 681, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new yacht submitted. Otherwise, select ''No''.', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'New yacht submitted SMS content ', 'script'),
(NULL, 682, 'pjField', 2, 'title', 'New yacht submitted SMS content ', 'script'),
(NULL, 682, 'pjField', 3, 'title', 'New yacht submitted SMS content ', 'script'),
(NULL, 683, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 683, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 683, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 684, 'pjField', 2, 'title', 'Notifications updated', 'script'),
(NULL, 684, 'pjField', 3, 'title', 'Notifications updated', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 685, 'pjField', 2, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 685, 'pjField', 3, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Submissions updated', 'script'),
(NULL, 686, 'pjField', 2, 'title', 'Submissions updated', 'script'),
(NULL, 686, 'pjField', 3, 'title', 'Submissions updated', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 687, 'pjField', 2, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 687, 'pjField', 3, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Booking options updated', 'script'),
(NULL, 688, 'pjField', 2, 'title', 'Booking options updated', 'script'),
(NULL, 688, 'pjField', 3, 'title', 'Booking options updated', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 689, 'pjField', 2, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 689, 'pjField', 3, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Booking form updated', 'script');
INSERT INTO `yachtlisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 690, 'pjField', 2, 'title', 'Booking form updated', 'script'),
(NULL, 690, 'pjField', 3, 'title', 'Booking form updated', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 691, 'pjField', 2, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 691, 'pjField', 3, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Extra', 'script'),
(NULL, 692, 'pjField', 2, 'title', 'Extra', 'script'),
(NULL, 692, 'pjField', 3, 'title', 'Extra', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'List of extras', 'script'),
(NULL, 693, 'pjField', 2, 'title', 'List of extras', 'script'),
(NULL, 693, 'pjField', 3, 'title', 'List of extras', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Here you can add, delete and manage extras of yachts.', 'script'),
(NULL, 694, 'pjField', 2, 'title', 'Here you can add, delete and manage extras of yachts.', 'script'),
(NULL, 694, 'pjField', 3, 'title', 'Here you can add, delete and manage extras of yachts.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 695, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 695, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Extra name was already used.', 'script'),
(NULL, 696, 'pjField', 2, 'title', 'Extra name was already used.', 'script'),
(NULL, 696, 'pjField', 3, 'title', 'Extra name was already used.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Add new extra', 'script'),
(NULL, 697, 'pjField', 2, 'title', 'Add new extra', 'script'),
(NULL, 697, 'pjField', 3, 'title', 'Add new extra', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Please fill in the form below and click SAVE button to add new extra.', 'script'),
(NULL, 698, 'pjField', 2, 'title', 'Please fill in the form below and click SAVE button to add new extra.', 'script'),
(NULL, 698, 'pjField', 3, 'title', 'Please fill in the form below and click SAVE button to add new extra.', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Extra type', 'script'),
(NULL, 699, 'pjField', 2, 'title', 'Extra type', 'script'),
(NULL, 699, 'pjField', 3, 'title', 'Extra type', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Accommodations', 'script'),
(NULL, 700, 'pjField', 2, 'title', 'Accommodations', 'script'),
(NULL, 700, 'pjField', 3, 'title', 'Accommodations', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Electronics and Navigational Gear', 'script'),
(NULL, 701, 'pjField', 2, 'title', 'Electronics and Navigational Gear', 'script'),
(NULL, 701, 'pjField', 3, 'title', 'Electronics and Navigational Gear', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Extra updated', 'script'),
(NULL, 702, 'pjField', 2, 'title', 'Extra updated', 'script'),
(NULL, 702, 'pjField', 3, 'title', 'Extra updated', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'All changes made to extra have been saved.', 'script'),
(NULL, 703, 'pjField', 2, 'title', 'All changes made to extra have been saved.', 'script'),
(NULL, 703, 'pjField', 3, 'title', 'All changes made to extra have been saved.', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Extra added', 'script'),
(NULL, 704, 'pjField', 2, 'title', 'Extra added', 'script'),
(NULL, 704, 'pjField', 3, 'title', 'Extra added', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'A new extra has been added into the list.', 'script'),
(NULL, 705, 'pjField', 2, 'title', 'A new extra has been added into the list.', 'script'),
(NULL, 705, 'pjField', 3, 'title', 'A new extra has been added into the list.', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Extra failed to add', 'script'),
(NULL, 706, 'pjField', 2, 'title', 'Extra failed to add', 'script'),
(NULL, 706, 'pjField', 3, 'title', 'Extra failed to add', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'We are sorry that new extra could not be added successfully.', 'script'),
(NULL, 707, 'pjField', 2, 'title', 'We are sorry that new extra could not be added successfully.', 'script'),
(NULL, 707, 'pjField', 3, 'title', 'We are sorry that new extra could not be added successfully.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Extra not found', 'script'),
(NULL, 708, 'pjField', 2, 'title', 'Extra not found', 'script'),
(NULL, 708, 'pjField', 3, 'title', 'Extra not found', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'We are sorry that extra you are looking for is missing.', 'script'),
(NULL, 709, 'pjField', 2, 'title', 'We are sorry that extra you are looking for is missing.', 'script'),
(NULL, 709, 'pjField', 3, 'title', 'We are sorry that extra you are looking for is missing.', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Update extra', 'script'),
(NULL, 710, 'pjField', 2, 'title', 'Update extra', 'script'),
(NULL, 710, 'pjField', 3, 'title', 'Update extra', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Make any change on the form below and click Save button to edit extra information.', 'script'),
(NULL, 711, 'pjField', 2, 'title', 'Make any change on the form below and click Save button to edit extra information.', 'script'),
(NULL, 711, 'pjField', 3, 'title', 'Make any change on the form below and click Save button to edit extra information.', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Feature updated', 'script'),
(NULL, 712, 'pjField', 2, 'title', 'Feature updated', 'script'),
(NULL, 712, 'pjField', 3, 'title', 'Feature updated', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'All changes made to the feature have been saved.', 'script'),
(NULL, 713, 'pjField', 2, 'title', 'All changes made to the feature have been saved.', 'script'),
(NULL, 713, 'pjField', 3, 'title', 'All changes made to the feature have been saved.', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Feature added', 'script'),
(NULL, 714, 'pjField', 2, 'title', 'Feature added', 'script'),
(NULL, 714, 'pjField', 3, 'title', 'Feature added', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Fill in the form below and click Save button to add new feature.', 'script'),
(NULL, 715, 'pjField', 2, 'title', 'Fill in the form below and click Save button to add new feature.', 'script'),
(NULL, 715, 'pjField', 3, 'title', 'Fill in the form below and click Save button to add new feature.', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Feature failed to add', 'script'),
(NULL, 716, 'pjField', 2, 'title', 'Feature failed to add', 'script'),
(NULL, 716, 'pjField', 3, 'title', 'Feature failed to add', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'We are sorry that new feature could not be added successfully.', 'script'),
(NULL, 717, 'pjField', 2, 'title', 'We are sorry that new feature could not be added successfully.', 'script'),
(NULL, 717, 'pjField', 3, 'title', 'We are sorry that new feature could not be added successfully.', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Feature not found', 'script'),
(NULL, 718, 'pjField', 2, 'title', 'Feature not found', 'script'),
(NULL, 718, 'pjField', 3, 'title', 'Feature not found', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'We are sorry that the feature you are looking for is missing.', 'script'),
(NULL, 719, 'pjField', 2, 'title', 'We are sorry that the feature you are looking for is missing.', 'script'),
(NULL, 719, 'pjField', 3, 'title', 'We are sorry that the feature you are looking for is missing.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Yacht type', 'script'),
(NULL, 720, 'pjField', 2, 'title', 'Yacht type', 'script'),
(NULL, 720, 'pjField', 3, 'title', 'Yacht type', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Fuel type', 'script'),
(NULL, 721, 'pjField', 2, 'title', 'Fuel type', 'script'),
(NULL, 721, 'pjField', 3, 'title', 'Fuel type', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Engine type', 'script'),
(NULL, 722, 'pjField', 2, 'title', 'Engine type', 'script'),
(NULL, 722, 'pjField', 3, 'title', 'Engine type', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Hull type', 'script'),
(NULL, 723, 'pjField', 2, 'title', 'Hull type', 'script'),
(NULL, 723, 'pjField', 3, 'title', 'Hull type', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'List of features', 'script'),
(NULL, 724, 'pjField', 2, 'title', 'List of features', 'script'),
(NULL, 724, 'pjField', 3, 'title', 'List of features', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Here you can add, delete and manage yacht features. Click on the "Add+" button to add new feature.', 'script'),
(NULL, 725, 'pjField', 2, 'title', 'Here you can add, delete and manage yacht features. Click on the "Add+" button to add new feature.', 'script'),
(NULL, 725, 'pjField', 3, 'title', 'Here you can add, delete and manage yacht features. Click on the "Add+" button to add new feature.', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'Feature', 'script'),
(NULL, 726, 'pjField', 2, 'title', 'Feature', 'script'),
(NULL, 726, 'pjField', 3, 'title', 'Feature', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Feature type', 'script'),
(NULL, 727, 'pjField', 2, 'title', 'Feature type', 'script'),
(NULL, 727, 'pjField', 3, 'title', 'Feature type', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Feature name was already used.', 'script'),
(NULL, 728, 'pjField', 2, 'title', 'Feature name was already used.', 'script'),
(NULL, 728, 'pjField', 3, 'title', 'Feature name was already used.', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Add new feature', 'script'),
(NULL, 729, 'pjField', 2, 'title', 'Add new feature', 'script'),
(NULL, 729, 'pjField', 3, 'title', 'Add new feature', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Please fill in the form below and click Save button to add new feature.', 'script'),
(NULL, 730, 'pjField', 2, 'title', 'Please fill in the form below and click Save button to add new feature.', 'script'),
(NULL, 730, 'pjField', 3, 'title', 'Please fill in the form below and click Save button to add new feature.', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Update feature', 'script'),
(NULL, 731, 'pjField', 2, 'title', 'Update feature', 'script'),
(NULL, 731, 'pjField', 3, 'title', 'Update feature', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Make any change on the form below and click Save button to update feature information.', 'script'),
(NULL, 732, 'pjField', 2, 'title', 'Make any change on the form below and click Save button to update feature information.', 'script'),
(NULL, 732, 'pjField', 3, 'title', 'Make any change on the form below and click Save button to update feature information.', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'List of manufacturers', 'script'),
(NULL, 733, 'pjField', 2, 'title', 'List of manufacturers', 'script'),
(NULL, 733, 'pjField', 3, 'title', 'List of manufacturers', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Here you can add, delete and manage manufacturers. Click on the button "Add+" to add new manufacturer.', 'script'),
(NULL, 734, 'pjField', 2, 'title', 'Here you can add, delete and manage manufacturers. Click on the button "Add+" to add new manufacturer.', 'script'),
(NULL, 734, 'pjField', 3, 'title', 'Here you can add, delete and manage manufacturers. Click on the button "Add+" to add new manufacturer.', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Add new manufacturer', 'script'),
(NULL, 735, 'pjField', 2, 'title', 'Add new manufacturer', 'script'),
(NULL, 735, 'pjField', 3, 'title', 'Add new manufacturer', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Please enter manufacturer name and click Save button.', 'script'),
(NULL, 736, 'pjField', 2, 'title', 'Please enter manufacturer name and click Save button.', 'script'),
(NULL, 736, 'pjField', 3, 'title', 'Please enter manufacturer name and click Save button.', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Update manufacturer', 'script'),
(NULL, 737, 'pjField', 2, 'title', 'Update manufacturer', 'script'),
(NULL, 737, 'pjField', 3, 'title', 'Update manufacturer', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Make any change on the manufacture name and click Save button to update the information.', 'script'),
(NULL, 738, 'pjField', 2, 'title', 'Make any change on the manufacture name and click Save button to update the information.', 'script'),
(NULL, 738, 'pjField', 3, 'title', 'Make any change on the manufacture name and click Save button to update the information.', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Manufacturer', 'script'),
(NULL, 739, 'pjField', 2, 'title', 'Manufacturer', 'script'),
(NULL, 739, 'pjField', 3, 'title', 'Manufacturer', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Manufacturer updated', 'script'),
(NULL, 740, 'pjField', 2, 'title', 'Manufacturer updated', 'script'),
(NULL, 740, 'pjField', 3, 'title', 'Manufacturer updated', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'All changes made to the manufacturer has been saved.', 'script'),
(NULL, 741, 'pjField', 2, 'title', 'All changes made to the manufacturer has been saved.', 'script'),
(NULL, 741, 'pjField', 3, 'title', 'All changes made to the manufacturer has been saved.', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Manufacturer added', 'script'),
(NULL, 742, 'pjField', 2, 'title', 'Manufacturer added', 'script'),
(NULL, 742, 'pjField', 3, 'title', 'Manufacturer added', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'A new manufacturer has been added into the list.', 'script'),
(NULL, 743, 'pjField', 2, 'title', 'A new manufacturer has been added into the list.', 'script'),
(NULL, 743, 'pjField', 3, 'title', 'A new manufacturer has been added into the list.', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Manufacturer failed to add', 'script'),
(NULL, 744, 'pjField', 2, 'title', 'Manufacturer failed to add', 'script'),
(NULL, 744, 'pjField', 3, 'title', 'Manufacturer failed to add', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'We are sorry that new manufacturer could not be added successfully.', 'script'),
(NULL, 745, 'pjField', 2, 'title', 'We are sorry that new manufacturer could not be added successfully.', 'script'),
(NULL, 745, 'pjField', 3, 'title', 'We are sorry that new manufacturer could not be added successfully.', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Manufacturer not found', 'script'),
(NULL, 746, 'pjField', 2, 'title', 'Manufacturer not found', 'script'),
(NULL, 746, 'pjField', 3, 'title', 'Manufacturer not found', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'We are sorry that the manufacturer you are looking for is missing.', 'script'),
(NULL, 747, 'pjField', 2, 'title', 'We are sorry that the manufacturer you are looking for is missing.', 'script'),
(NULL, 747, 'pjField', 3, 'title', 'We are sorry that the manufacturer you are looking for is missing.', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 748, 'pjField', 2, 'title', 'Optional', 'script'),
(NULL, 748, 'pjField', 3, 'title', 'Optional', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 749, 'pjField', 2, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 749, 'pjField', 3, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 750, 'pjField', 2, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 750, 'pjField', 3, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 751, 'pjField', 2, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 751, 'pjField', 3, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 752, 'pjField', 2, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 752, 'pjField', 3, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 753, 'pjField', 2, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 753, 'pjField', 3, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 754, 'pjField', 2, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 754, 'pjField', 3, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 755, 'pjField', 2, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 755, 'pjField', 3, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 756, 'pjField', 2, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 756, 'pjField', 3, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 757, 'pjField', 2, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 757, 'pjField', 3, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 758, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 758, 'pjField', 2, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 758, 'pjField', 3, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Install settings updated', 'script'),
(NULL, 759, 'pjField', 2, 'title', 'Install settings updated', 'script'),
(NULL, 759, 'pjField', 3, 'title', 'Install settings updated', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'All changes made to installation settings have been saved.', 'script'),
(NULL, 760, 'pjField', 2, 'title', 'All changes made to installation settings have been saved.', 'script'),
(NULL, 760, 'pjField', 3, 'title', 'All changes made to installation settings have been saved.', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'For rent', 'script'),
(NULL, 761, 'pjField', 2, 'title', 'For rent', 'script'),
(NULL, 761, 'pjField', 3, 'title', 'For rent', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'For sale', 'script'),
(NULL, 762, 'pjField', 2, 'title', 'For sale', 'script'),
(NULL, 762, 'pjField', 3, 'title', 'For sale', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 763, 'pjField', 2, 'title', 'Image', 'script'),
(NULL, 763, 'pjField', 3, 'title', 'Image', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Ref ID', 'script'),
(NULL, 764, 'pjField', 2, 'title', 'Ref ID', 'script'),
(NULL, 764, 'pjField', 3, 'title', 'Ref ID', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Publish', 'script'),
(NULL, 765, 'pjField', 2, 'title', 'Publish', 'script'),
(NULL, 765, 'pjField', 3, 'title', 'Publish', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Published', 'script'),
(NULL, 766, 'pjField', 2, 'title', 'Published', 'script'),
(NULL, 766, 'pjField', 3, 'title', 'Published', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Not published', 'script'),
(NULL, 767, 'pjField', 2, 'title', 'Not published', 'script'),
(NULL, 767, 'pjField', 3, 'title', 'Not published', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Extend exp. date', 'script'),
(NULL, 768, 'pjField', 2, 'title', 'Extend exp. date', 'script'),
(NULL, 768, 'pjField', 3, 'title', 'Extend exp. date', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Expire', 'script'),
(NULL, 769, 'pjField', 2, 'title', 'Expire', 'script'),
(NULL, 769, 'pjField', 3, 'title', 'Expire', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Exp. date', 'script'),
(NULL, 770, 'pjField', 2, 'title', 'Exp. date', 'script'),
(NULL, 770, 'pjField', 3, 'title', 'Exp. date', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Expiration date + 30 days', 'script'),
(NULL, 771, 'pjField', 2, 'title', 'Expiration date + 30 days', 'script'),
(NULL, 771, 'pjField', 3, 'title', 'Expiration date + 30 days', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Unlimited', 'script'),
(NULL, 772, 'pjField', 2, 'title', 'Unlimited', 'script'),
(NULL, 772, 'pjField', 3, 'title', 'Unlimited', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 773, 'pjField', 2, 'title', 'Owner', 'script'),
(NULL, 773, 'pjField', 3, 'title', 'Owner', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Add yacht', 'script'),
(NULL, 774, 'pjField', 2, 'title', 'Add yacht', 'script'),
(NULL, 774, 'pjField', 3, 'title', 'Add yacht', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Keyword', 'script'),
(NULL, 775, 'pjField', 2, 'title', 'Keyword', 'script'),
(NULL, 775, 'pjField', 3, 'title', 'Keyword', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 776, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 776, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 777, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 777, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 778, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 778, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 779, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 779, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 780, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 780, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Based on expiration date', 'script'),
(NULL, 781, 'pjField', 2, 'title', 'Based on expiration date', 'script'),
(NULL, 781, 'pjField', 3, 'title', 'Based on expiration date', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Add new yacht', 'script'),
(NULL, 782, 'pjField', 2, 'title', 'Add new yacht', 'script'),
(NULL, 782, 'pjField', 3, 'title', 'Add new yacht', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Fill in the most important details for the yacht. On the next step you will be able to add all other details and also upload images. Go to Options menu -> Manufacturers tab to modify the list of available Manufacturers.', 'script'),
(NULL, 783, 'pjField', 2, 'title', 'Fill in the most important details for the yacht. On the next step you will be able to add all other details and also upload images. Go to Options menu -> Manufacturers tab to modify the list of available Manufacturers.', 'script'),
(NULL, 783, 'pjField', 3, 'title', 'Fill in the most important details for the yacht. On the next step you will be able to add all other details and also upload images. Go to Options menu -> Manufacturers tab to modify the list of available Manufacturers.', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'The system auto fills a auto increment number. You can replace it with an ID of your choice any time.', 'script'),
(NULL, 784, 'pjField', 2, 'title', 'The system auto fills a auto increment number. You can replace it with an ID of your choice any time.', 'script'),
(NULL, 784, 'pjField', 3, 'title', 'The system auto fills a auto increment number. You can replace it with an ID of your choice any time.', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'You need to add at least one manufacturer. Click {ADD_MANU_TAG}here{ADD_MANU_ENDTAG} to add.', 'script'),
(NULL, 785, 'pjField', 2, 'title', 'You need to add at least one manufacturer. Click {ADD_MANU_TAG}here{ADD_MANU_ENDTAG} to add.', 'script'),
(NULL, 785, 'pjField', 3, 'title', 'You need to add at least one manufacturer. Click {ADD_MANU_TAG}here{ADD_MANU_ENDTAG} to add.', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'You can add a yacht but choose not to show it on the website listing by choosing "No". You can publish the yacht by choosing "Yes" or you can make it live only till a certain date by choosing "Based on expiration date', 'script'),
(NULL, 786, 'pjField', 2, 'title', 'You can add a yacht but choose not to show it on the website listing by choosing "No". You can publish the yacht by choosing "Yes" or you can make it live only till a certain date by choosing "Based on expiration date', 'script'),
(NULL, 786, 'pjField', 3, 'title', 'You can add a yacht but choose not to show it on the website listing by choosing "No". You can publish the yacht by choosing "Yes" or you can make it live only till a certain date by choosing "Based on expiration date', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Set a date until the yacht will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 787, 'pjField', 2, 'title', 'Set a date until the yacht will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 787, 'pjField', 3, 'title', 'Set a date until the yacht will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Yacht', 'script'),
(NULL, 788, 'pjField', 2, 'title', 'Yacht', 'script'),
(NULL, 788, 'pjField', 3, 'title', 'Yacht', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 789, 'pjField', 2, 'title', 'Summary', 'script'),
(NULL, 789, 'pjField', 3, 'title', 'Summary', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 790, 'pjField', 2, 'title', 'Details', 'script'),
(NULL, 790, 'pjField', 3, 'title', 'Details', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 791, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 791, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 793, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 793, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 794, 'pjField', 2, 'title', 'Owner', 'script'),
(NULL, 794, 'pjField', 3, 'title', 'Owner', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 795, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 795, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 796, 'pjField', 2, 'title', 'SEO', 'script'),
(NULL, 796, 'pjField', 3, 'title', 'SEO', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Yacht summary', 'script'),
(NULL, 797, 'pjField', 2, 'title', 'Yacht summary', 'script'),
(NULL, 797, 'pjField', 3, 'title', 'Yacht summary', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Below you can edit the most important details about the yacht. Please, pay attention to Status field. If it says "No" then the yacht is not published on the front end. ', 'script'),
(NULL, 798, 'pjField', 2, 'title', 'Below you can edit the most important details about the yacht. Please, pay attention to Status field. If it says "No" then the yacht is not published on the front end. ', 'script'),
(NULL, 798, 'pjField', 3, 'title', 'Below you can edit the most important details about the yacht. Please, pay attention to Status field. If it says "No" then the yacht is not published on the front end. ', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Yacht details', 'script'),
(NULL, 799, 'pjField', 2, 'title', 'Yacht details', 'script'),
(NULL, 799, 'pjField', 3, 'title', 'Yacht details', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Below you can set more details about the yacht.', 'script'),
(NULL, 800, 'pjField', 2, 'title', 'Below you can set more details about the yacht.', 'script'),
(NULL, 800, 'pjField', 3, 'title', 'Below you can set more details about the yacht.', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Yacht description', 'script'),
(NULL, 801, 'pjField', 2, 'title', 'Yacht description', 'script'),
(NULL, 801, 'pjField', 3, 'title', 'Yacht description', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Write full description about the yacht using the text box below.', 'script'),
(NULL, 802, 'pjField', 2, 'title', 'Write full description about the yacht using the text box below.', 'script'),
(NULL, 802, 'pjField', 3, 'title', 'Write full description about the yacht using the text box below.', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 803, 'pjField', 2, 'title', 'Extras', 'script'),
(NULL, 803, 'pjField', 3, 'title', 'Extras', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'Check available yacht extras. Under Options menu -> Extras tab you can define all available extras.', 'script'),
(NULL, 804, 'pjField', 2, 'title', 'Check available yacht extras. Under Options menu -> Extras tab you can define all available extras.', 'script'),
(NULL, 804, 'pjField', 3, 'title', 'Check available yacht extras. Under Options menu -> Extras tab you can define all available extras.', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 805, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 805, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'Upload as many images as you want for this yacht. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 807, 'pjField', 2, 'title', 'Upload as many images as you want for this yacht. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 807, 'pjField', 3, 'title', 'Upload as many images as you want for this yacht. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'Yacht owner', 'script'),
(NULL, 808, 'pjField', 2, 'title', 'Yacht owner', 'script'),
(NULL, 808, 'pjField', 3, 'title', 'Yacht owner', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'Select one of the available users as yacht owner or add new onwer details. You can also specify is owner contact details will be shown on the yacht details page or not.', 'script'),
(NULL, 809, 'pjField', 2, 'title', 'Select one of the available users as yacht owner or add new onwer details. You can also specify is owner contact details will be shown on the yacht details page or not.', 'script'),
(NULL, 809, 'pjField', 3, 'title', 'Select one of the available users as yacht owner or add new onwer details. You can also specify is owner contact details will be shown on the yacht details page or not.', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 810, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 810, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'Enter address where yacht is currently located.', 'script'),
(NULL, 811, 'pjField', 2, 'title', 'Enter address where yacht is currently located.', 'script'),
(NULL, 811, 'pjField', 3, 'title', 'Enter address where yacht is currently located.', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 812, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 812, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 813, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 813, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'Added on', 'script'),
(NULL, 814, 'pjField', 2, 'title', 'Added on', 'script'),
(NULL, 814, 'pjField', 3, 'title', 'Added on', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'Last updated on', 'script'),
(NULL, 815, 'pjField', 2, 'title', 'Last updated on', 'script'),
(NULL, 815, 'pjField', 3, 'title', 'Last updated on', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 816, 'pjField', 2, 'title', 'Views', 'script'),
(NULL, 816, 'pjField', 3, 'title', 'Views', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Not active', 'script'),
(NULL, 817, 'pjField', 2, 'title', 'Not active', 'script'),
(NULL, 817, 'pjField', 3, 'title', 'Not active', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'Extend', 'script'),
(NULL, 818, 'pjField', 2, 'title', 'Extend', 'script'),
(NULL, 818, 'pjField', 3, 'title', 'Extend', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 819, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 819, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 820, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 820, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Year', 'script'),
(NULL, 821, 'pjField', 2, 'title', 'Year', 'script'),
(NULL, 821, 'pjField', 3, 'title', 'Year', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Horse power', 'script'),
(NULL, 822, 'pjField', 2, 'title', 'Horse power', 'script'),
(NULL, 822, 'pjField', 3, 'title', 'Horse power', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'LOA', 'script'),
(NULL, 823, 'pjField', 2, 'title', 'LOA', 'script'),
(NULL, 823, 'pjField', 3, 'title', 'LOA', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Length', 'script'),
(NULL, 824, 'pjField', 2, 'title', 'Length', 'script'),
(NULL, 824, 'pjField', 3, 'title', 'Length', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Beam', 'script'),
(NULL, 825, 'pjField', 2, 'title', 'Beam', 'script'),
(NULL, 825, 'pjField', 3, 'title', 'Beam', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Engine hours', 'script'),
(NULL, 826, 'pjField', 2, 'title', 'Engine hours', 'script'),
(NULL, 826, 'pjField', 3, 'title', 'Engine hours', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Engine model', 'script'),
(NULL, 827, 'pjField', 2, 'title', 'Engine model', 'script'),
(NULL, 827, 'pjField', 3, 'title', 'Engine model', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Cruising speed', 'script'),
(NULL, 828, 'pjField', 2, 'title', 'Cruising speed', 'script'),
(NULL, 828, 'pjField', 3, 'title', 'Cruising speed', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Max speed', 'script'),
(NULL, 829, 'pjField', 2, 'title', 'Max speed', 'script'),
(NULL, 829, 'pjField', 3, 'title', 'Max speed', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Fuel tank', 'script'),
(NULL, 830, 'pjField', 2, 'title', 'Fuel tank', 'script'),
(NULL, 830, 'pjField', 3, 'title', 'Fuel tank', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 831, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 831, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'Choose owner', 'script'),
(NULL, 832, 'pjField', 2, 'title', 'Choose owner', 'script'),
(NULL, 832, 'pjField', 3, 'title', 'Choose owner', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Show owner contact', 'script'),
(NULL, 833, 'pjField', 2, 'title', 'Show owner contact', 'script'),
(NULL, 833, 'pjField', 3, 'title', 'Show owner contact', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Choose Yes/No to show/hide the owner contact information on the yacht details page.', 'script'),
(NULL, 834, 'pjField', 2, 'title', 'Choose Yes/No to show/hide the owner contact information on the yacht details page.', 'script'),
(NULL, 834, 'pjField', 3, 'title', 'Choose Yes/No to show/hide the owner contact information on the yacht details page.', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 835, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 835, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 836, 'pjField', 2, 'title', 'Fax', 'script'),
(NULL, 836, 'pjField', 3, 'title', 'Fax', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'Load owner contact details', 'script'),
(NULL, 837, 'pjField', 2, 'title', 'Load owner contact details', 'script'),
(NULL, 837, 'pjField', 3, 'title', 'Load owner contact details', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 838, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 838, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Zip / post code', 'script'),
(NULL, 839, 'pjField', 2, 'title', 'Zip / post code', 'script'),
(NULL, 839, 'pjField', 3, 'title', 'Zip / post code', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'SEO settings', 'script'),
(NULL, 840, 'pjField', 2, 'title', 'SEO settings', 'script'),
(NULL, 840, 'pjField', 3, 'title', 'SEO settings', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your yacht details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 841, 'pjField', 2, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your yacht details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 841, 'pjField', 3, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your yacht details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'Meta title', 'script'),
(NULL, 842, 'pjField', 2, 'title', 'Meta title', 'script'),
(NULL, 842, 'pjField', 3, 'title', 'Meta title', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Meta keywords', 'script'),
(NULL, 843, 'pjField', 2, 'title', 'Meta keywords', 'script'),
(NULL, 843, 'pjField', 3, 'title', 'Meta keywords', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'Meta description', 'script'),
(NULL, 844, 'pjField', 2, 'title', 'Meta description', 'script'),
(NULL, 844, 'pjField', 3, 'title', 'Meta description', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Give a title to your yacht details web page. For search engines it is highly recommended to have nice, descriptive title with your main keyword phrase. It will also appear in browser headers.', 'script'),
(NULL, 845, 'pjField', 2, 'title', 'Give a title to your yacht details web page. For search engines it is highly recommended to have nice, descriptive title with your main keyword phrase. It will also appear in browser headers.', 'script'),
(NULL, 845, 'pjField', 3, 'title', 'Give a title to your yacht details web page. For search engines it is highly recommended to have nice, descriptive title with your main keyword phrase. It will also appear in browser headers.', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'This meta tag has lost its importance. You can leave it empty or use it to lit your keywords. Use comma to separate you keyword phrases.', 'script'),
(NULL, 846, 'pjField', 2, 'title', 'This meta tag has lost its importance. You can leave it empty or use it to lit your keywords. Use comma to separate you keyword phrases.', 'script'),
(NULL, 846, 'pjField', 3, 'title', 'This meta tag has lost its importance. You can leave it empty or use it to lit your keywords. Use comma to separate you keyword phrases.', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Write a short description of what is your web page (yacht detail page) for. It is best if you limit your description to 160 characters (with the spaces)', 'script'),
(NULL, 847, 'pjField', 2, 'title', 'Write a short description of what is your web page (yacht detail page) for. It is best if you limit your description to 160 characters (with the spaces)', 'script'),
(NULL, 847, 'pjField', 3, 'title', 'Write a short description of what is your web page (yacht detail page) for. It is best if you limit your description to 160 characters (with the spaces)', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Yacht updated', 'script'),
(NULL, 848, 'pjField', 2, 'title', 'Yacht updated', 'script'),
(NULL, 848, 'pjField', 3, 'title', 'Yacht updated', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'All changes made to yacht have been saved successfully.', 'script'),
(NULL, 849, 'pjField', 2, 'title', 'All changes made to yacht have been saved successfully.', 'script'),
(NULL, 849, 'pjField', 3, 'title', 'All changes made to yacht have been saved successfully.', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Yacht added', 'script'),
(NULL, 850, 'pjField', 2, 'title', 'Yacht added', 'script'),
(NULL, 850, 'pjField', 3, 'title', 'Yacht added', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'A new yacht has been added into the list.', 'script'),
(NULL, 851, 'pjField', 2, 'title', 'A new yacht has been added into the list.', 'script'),
(NULL, 851, 'pjField', 3, 'title', 'A new yacht has been added into the list.', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Yacht failed to add', 'script'),
(NULL, 852, 'pjField', 2, 'title', 'Yacht failed to add', 'script'),
(NULL, 852, 'pjField', 3, 'title', 'Yacht failed to add', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'We are sorry that new yacht could not be added successfully.', 'script'),
(NULL, 853, 'pjField', 2, 'title', 'We are sorry that new yacht could not be added successfully.', 'script'),
(NULL, 853, 'pjField', 3, 'title', 'We are sorry that new yacht could not be added successfully.', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'Yacht not found', 'script'),
(NULL, 854, 'pjField', 2, 'title', 'Yacht not found', 'script'),
(NULL, 854, 'pjField', 3, 'title', 'Yacht not found', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'We are sorry that the yacht you are looking for is missing.', 'script'),
(NULL, 855, 'pjField', 2, 'title', 'We are sorry that the yacht you are looking for is missing.', 'script'),
(NULL, 855, 'pjField', 3, 'title', 'We are sorry that the yacht you are looking for is missing.', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'All yachts', 'script'),
(NULL, 856, 'pjField', 2, 'title', 'All yachts', 'script'),
(NULL, 856, 'pjField', 3, 'title', 'All yachts', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Below you can see all added yachts. You can edit and delete any of the yachts and also as many yachts as you want.', 'script'),
(NULL, 857, 'pjField', 2, 'title', 'Below you can see all added yachts. You can edit and delete any of the yachts and also as many yachts as you want.', 'script'),
(NULL, 857, 'pjField', 3, 'title', 'Below you can see all added yachts. You can edit and delete any of the yachts and also as many yachts as you want.', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 858, 'pjField', 2, 'title', 'Prices', 'script'),
(NULL, 858, 'pjField', 3, 'title', 'Prices', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'Rental prices', 'script'),
(NULL, 859, 'pjField', 2, 'title', 'Rental prices', 'script'),
(NULL, 859, 'pjField', 3, 'title', 'Rental prices', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'Enter week rental price for each week during the year. If you leave price empty then yacht will not be available for renting. Under options page you can select the week starting date. By default your clients can rent the yacht per one week.', 'script'),
(NULL, 860, 'pjField', 2, 'title', 'Enter week rental price for each week during the year. If you leave price empty then yacht will not be available for renting. Under options page you can select the week starting date. By default your clients can rent the yacht per one week.', 'script'),
(NULL, 860, 'pjField', 3, 'title', 'Enter week rental price for each week during the year. If you leave price empty then yacht will not be available for renting. Under options page you can select the week starting date. By default your clients can rent the yacht per one week.', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Week', 'script'),
(NULL, 861, 'pjField', 2, 'title', 'Week', 'script'),
(NULL, 861, 'pjField', 3, 'title', 'Week', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'Extend expiration date', 'script'),
(NULL, 863, 'pjField', 2, 'title', 'Extend expiration date', 'script'),
(NULL, 863, 'pjField', 3, 'title', 'Extend expiration date', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'To publish your yacht or to extend its expiration date (if the yacht has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on "Buy now" button and make the payment required. After payment is received the yacht will be automatically published / extended.', 'script'),
(NULL, 864, 'pjField', 2, 'title', 'To publish your yacht or to extend its expiration date (if the yacht has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on "Buy now" button and make the payment required. After payment is received the yacht will be automatically published / extended.', 'script'),
(NULL, 864, 'pjField', 3, 'title', 'To publish your yacht or to extend its expiration date (if the yacht has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on "Buy now" button and make the payment required. After payment is received the yacht will be automatically published / extended.', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'Buy now', 'script'),
(NULL, 866, 'pjField', 2, 'title', 'Buy now', 'script'),
(NULL, 866, 'pjField', 3, 'title', 'Buy now', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'FREE', 'script'),
(NULL, 867, 'pjField', 2, 'title', 'FREE', 'script'),
(NULL, 867, 'pjField', 3, 'title', 'FREE', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'Extend your period for FREE', 'script'),
(NULL, 868, 'pjField', 2, 'title', 'Extend your period for FREE', 'script'),
(NULL, 868, 'pjField', 3, 'title', 'Extend your period for FREE', 'script'),
(NULL, 1047, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 1047, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 1047, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 1048, 'pjField', 1, 'title', 'Yachts not found.', 'script'),
(NULL, 1048, 'pjField', 2, 'title', 'Yachts not found.', 'script'),
(NULL, 1048, 'pjField', 3, 'title', 'Yachts not found.', 'script'),
(NULL, 1049, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1049, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 1049, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 1050, 'pjField', 1, 'title', 'Build', 'script'),
(NULL, 1050, 'pjField', 2, 'title', 'Build', 'script'),
(NULL, 1050, 'pjField', 3, 'title', 'Build', 'script'),
(NULL, 1051, 'pjField', 1, 'title', 'Length', 'script'),
(NULL, 1051, 'pjField', 2, 'title', 'Length', 'script'),
(NULL, 1051, 'pjField', 3, 'title', 'Length', 'script'),
(NULL, 1052, 'pjField', 1, 'title', 'More Details', 'script'),
(NULL, 1052, 'pjField', 2, 'title', 'More Details', 'script'),
(NULL, 1052, 'pjField', 3, 'title', 'More Details', 'script'),
(NULL, 1053, 'pjField', 1, 'title', 'per week', 'script'),
(NULL, 1053, 'pjField', 2, 'title', 'per week', 'script'),
(NULL, 1053, 'pjField', 3, 'title', 'per week', 'script'),
(NULL, 1054, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 1054, 'pjField', 2, 'title', 'Model', 'script'),
(NULL, 1054, 'pjField', 3, 'title', 'Model', 'script'),
(NULL, 1055, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 1055, 'pjField', 2, 'title', 'Next', 'script'),
(NULL, 1055, 'pjField', 3, 'title', 'Next', 'script'),
(NULL, 1056, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 1056, 'pjField', 2, 'title', 'Prev', 'script'),
(NULL, 1056, 'pjField', 3, 'title', 'Prev', 'script'),
(NULL, 1057, 'pjField', 1, 'title', 'Search for Yachts', 'script'),
(NULL, 1057, 'pjField', 2, 'title', 'Search for Yachts', 'script'),
(NULL, 1057, 'pjField', 3, 'title', 'Search for Yachts', 'script'),
(NULL, 1058, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 1058, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 1058, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 1059, 'pjField', 1, 'title', 'Manufacturer', 'script'),
(NULL, 1059, 'pjField', 2, 'title', 'Manufacturer', 'script'),
(NULL, 1059, 'pjField', 3, 'title', 'Manufacturer', 'script'),
(NULL, 1060, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 1060, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 1060, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 1061, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 1061, 'pjField', 2, 'title', 'Home', 'script'),
(NULL, 1061, 'pjField', 3, 'title', 'Home', 'script'),
(NULL, 1062, 'pjField', 1, 'title', 'My Account', 'script'),
(NULL, 1062, 'pjField', 2, 'title', 'My Account', 'script'),
(NULL, 1062, 'pjField', 3, 'title', 'My Account', 'script'),
(NULL, 1063, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 1063, 'pjField', 2, 'title', 'Model', 'script'),
(NULL, 1063, 'pjField', 3, 'title', 'Model', 'script'),
(NULL, 1064, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 1064, 'pjField', 2, 'title', 'Reference ID', 'script'),
(NULL, 1064, 'pjField', 3, 'title', 'Reference ID', 'script'),
(NULL, 1065, 'pjField', 1, 'title', 'Year', 'script'),
(NULL, 1065, 'pjField', 2, 'title', 'Year', 'script');
INSERT INTO `yachtlisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1065, 'pjField', 3, 'title', 'Year', 'script'),
(NULL, 1066, 'pjField', 1, 'title', 'Horse power', 'script'),
(NULL, 1066, 'pjField', 2, 'title', 'Horse power', 'script'),
(NULL, 1066, 'pjField', 3, 'title', 'Horse power', 'script'),
(NULL, 1068, 'pjField', 1, 'title', 'Beam', 'script'),
(NULL, 1068, 'pjField', 2, 'title', 'Beam', 'script'),
(NULL, 1068, 'pjField', 3, 'title', 'Beam', 'script'),
(NULL, 1069, 'pjField', 1, 'title', 'LOA', 'script'),
(NULL, 1069, 'pjField', 2, 'title', 'LOA', 'script'),
(NULL, 1069, 'pjField', 3, 'title', 'LOA', 'script'),
(NULL, 1070, 'pjField', 1, 'title', 'Search Yatchs', 'script'),
(NULL, 1070, 'pjField', 2, 'title', 'Search Yatchs', 'script'),
(NULL, 1070, 'pjField', 3, 'title', 'Search Yatchs', 'script'),
(NULL, 1071, 'pjField', 1, 'title', 'Back to yachts', 'script'),
(NULL, 1071, 'pjField', 2, 'title', 'Back to yachts', 'script'),
(NULL, 1071, 'pjField', 3, 'title', 'Back to yachts', 'script'),
(NULL, 1072, 'pjField', 1, 'title', 'Yacht Reservation', 'script'),
(NULL, 1072, 'pjField', 2, 'title', 'Yacht Reservation', 'script'),
(NULL, 1072, 'pjField', 3, 'title', 'Yacht Reservation', 'script'),
(NULL, 1073, 'pjField', 1, 'title', 'Feature set', 'script'),
(NULL, 1073, 'pjField', 2, 'title', 'Feature set', 'script'),
(NULL, 1073, 'pjField', 3, 'title', 'Feature set', 'script'),
(NULL, 1074, 'pjField', 1, 'title', 'Yacht description', 'script'),
(NULL, 1074, 'pjField', 2, 'title', 'Yacht description', 'script'),
(NULL, 1074, 'pjField', 3, 'title', 'Yacht description', 'script'),
(NULL, 1075, 'pjField', 1, 'title', 'General specifications', 'script'),
(NULL, 1075, 'pjField', 2, 'title', 'General specifications', 'script'),
(NULL, 1075, 'pjField', 3, 'title', 'General specifications', 'script'),
(NULL, 1078, 'pjField', 1, 'title', 'Registration year', 'script'),
(NULL, 1078, 'pjField', 2, 'title', 'Registration year', 'script'),
(NULL, 1078, 'pjField', 3, 'title', 'Registration year', 'script'),
(NULL, 1079, 'pjField', 1, 'title', 'Technical specifications', 'script'),
(NULL, 1079, 'pjField', 2, 'title', 'Technical specifications', 'script'),
(NULL, 1079, 'pjField', 3, 'title', 'Technical specifications', 'script'),
(NULL, 1080, 'pjField', 1, 'title', 'Engine hours', 'script'),
(NULL, 1080, 'pjField', 2, 'title', 'Engine hours', 'script'),
(NULL, 1080, 'pjField', 3, 'title', 'Engine hours', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'Engine model', 'script'),
(NULL, 1081, 'pjField', 2, 'title', 'Engine model', 'script'),
(NULL, 1081, 'pjField', 3, 'title', 'Engine model', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'Cruising speed', 'script'),
(NULL, 1082, 'pjField', 2, 'title', 'Cruising speed', 'script'),
(NULL, 1082, 'pjField', 3, 'title', 'Cruising speed', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'Max speed', 'script'),
(NULL, 1083, 'pjField', 2, 'title', 'Max speed', 'script'),
(NULL, 1083, 'pjField', 3, 'title', 'Max speed', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'Fuel tank', 'script'),
(NULL, 1084, 'pjField', 2, 'title', 'Fuel tank', 'script'),
(NULL, 1084, 'pjField', 3, 'title', 'Fuel tank', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'Week', 'script'),
(NULL, 1085, 'pjField', 2, 'title', 'Week', 'script'),
(NULL, 1085, 'pjField', 3, 'title', 'Week', 'script'),
(NULL, 1086, 'pjField', 1, 'title', 'Make a reservation', 'script'),
(NULL, 1086, 'pjField', 2, 'title', 'Make a reservation', 'script'),
(NULL, 1086, 'pjField', 3, 'title', 'Make a reservation', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'FREE', 'script'),
(NULL, 1087, 'pjField', 2, 'title', 'FREE', 'script'),
(NULL, 1087, 'pjField', 3, 'title', 'FREE', 'script'),
(NULL, 1088, 'pjField', 1, 'title', 'Reserved', 'script'),
(NULL, 1088, 'pjField', 2, 'title', 'Reserved', 'script'),
(NULL, 1088, 'pjField', 3, 'title', 'Reserved', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'Login your account', 'script'),
(NULL, 1089, 'pjField', 2, 'title', 'Login your account', 'script'),
(NULL, 1089, 'pjField', 3, 'title', 'Login your account', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'and manage your listing', 'script'),
(NULL, 1090, 'pjField', 2, 'title', 'and manage your listing', 'script'),
(NULL, 1090, 'pjField', 3, 'title', 'and manage your listing', 'script'),
(NULL, 1091, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 1091, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 1091, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 1092, 'pjField', 1, 'title', 'Forgot your password?', 'script'),
(NULL, 1092, 'pjField', 2, 'title', 'Forgot your password?', 'script'),
(NULL, 1092, 'pjField', 3, 'title', 'Forgot your password?', 'script'),
(NULL, 1093, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1093, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 1093, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 1094, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 1094, 'pjField', 2, 'title', 'Email is required.', 'script'),
(NULL, 1094, 'pjField', 3, 'title', 'Email is required.', 'script'),
(NULL, 1095, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1095, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 1095, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 1096, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1096, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 1096, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 1097, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 1097, 'pjField', 2, 'title', 'Password is required.', 'script'),
(NULL, 1097, 'pjField', 3, 'title', 'Password is required.', 'script'),
(NULL, 1098, 'pjField', 1, 'title', 'Create an account', 'script'),
(NULL, 1098, 'pjField', 2, 'title', 'Create an account', 'script'),
(NULL, 1098, 'pjField', 3, 'title', 'Create an account', 'script'),
(NULL, 1099, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 1099, 'pjField', 2, 'title', 'Name is missing.', 'script'),
(NULL, 1099, 'pjField', 3, 'title', 'Name is missing.', 'script'),
(NULL, 1100, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 1100, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 1100, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 1101, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 1101, 'pjField', 2, 'title', 'Password is missing.', 'script'),
(NULL, 1101, 'pjField', 3, 'title', 'Password is missing.', 'script'),
(NULL, 1102, 'pjField', 1, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 1102, 'pjField', 2, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 1102, 'pjField', 3, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 1103, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 1103, 'pjField', 2, 'title', 'Name cannot be empty.', 'script'),
(NULL, 1103, 'pjField', 3, 'title', 'Name cannot be empty.', 'script'),
(NULL, 1104, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1104, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1104, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1105, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 1105, 'pjField', 2, 'title', 'Password cannot be empty.', 'script'),
(NULL, 1105, 'pjField', 3, 'title', 'Password cannot be empty.', 'script'),
(NULL, 1106, 'pjField', 1, 'title', 'Re-enter password cannot be empty.', 'script'),
(NULL, 1106, 'pjField', 2, 'title', 'Re-enter password cannot be empty.', 'script'),
(NULL, 1106, 'pjField', 3, 'title', 'Re-enter password cannot be empty.', 'script'),
(NULL, 1107, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1107, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 1107, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 1108, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 1108, 'pjField', 2, 'title', 'Password does not match.', 'script'),
(NULL, 1108, 'pjField', 3, 'title', 'Password does not match.', 'script'),
(NULL, 1109, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 1109, 'pjField', 2, 'title', 'Captcha is missing.', 'script'),
(NULL, 1109, 'pjField', 3, 'title', 'Captcha is missing.', 'script'),
(NULL, 1110, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 1110, 'pjField', 2, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 1110, 'pjField', 3, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 1111, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1111, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1111, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1112, 'pjField', 1, 'title', 'Your account has been created and activated successfully.', 'script'),
(NULL, 1112, 'pjField', 2, 'title', 'Your account has been created and activated successfully.', 'script'),
(NULL, 1112, 'pjField', 3, 'title', 'Your account has been created and activated successfully.', 'script'),
(NULL, 1113, 'pjField', 1, 'title', 'Your account has been created successfully, but it needs to have confirmation from the administrator.', 'script'),
(NULL, 1113, 'pjField', 2, 'title', 'Your account has been created successfully, but it needs to have confirmation from the administrator.', 'script'),
(NULL, 1113, 'pjField', 3, 'title', 'Your account has been created successfully, but it needs to have confirmation from the administrator.', 'script'),
(NULL, 1114, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1114, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 1114, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 1115, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 1115, 'pjField', 2, 'title', 'Name is required.', 'script'),
(NULL, 1115, 'pjField', 3, 'title', 'Name is required.', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'Re-enter password', 'script'),
(NULL, 1116, 'pjField', 2, 'title', 'Re-enter password', 'script'),
(NULL, 1116, 'pjField', 3, 'title', 'Re-enter password', 'script'),
(NULL, 1117, 'pjField', 1, 'title', 'Re-enter password is required.', 'script'),
(NULL, 1117, 'pjField', 2, 'title', 'Re-enter password is required.', 'script'),
(NULL, 1117, 'pjField', 3, 'title', 'Re-enter password is required.', 'script'),
(NULL, 1118, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 1118, 'pjField', 2, 'title', 'Password does not match.', 'script'),
(NULL, 1118, 'pjField', 3, 'title', 'Password does not match.', 'script'),
(NULL, 1119, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1119, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 1119, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 1120, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 1120, 'pjField', 2, 'title', 'Fax', 'script'),
(NULL, 1120, 'pjField', 3, 'title', 'Fax', 'script'),
(NULL, 1121, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1121, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 1121, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 1122, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 1122, 'pjField', 2, 'title', 'Captcha is required.', 'script'),
(NULL, 1122, 'pjField', 3, 'title', 'Captcha is required.', 'script'),
(NULL, 1123, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1123, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1123, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1124, 'pjField', 1, 'title', 'Create', 'script'),
(NULL, 1124, 'pjField', 2, 'title', 'Create', 'script'),
(NULL, 1124, 'pjField', 3, 'title', 'Create', 'script'),
(NULL, 1125, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 1125, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 1125, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 1126, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 1126, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 1126, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 1127, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1127, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1127, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1128, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1128, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 1128, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 1129, 'pjField', 1, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 1129, 'pjField', 2, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 1129, 'pjField', 3, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 1130, 'pjField', 1, 'title', 'Your password has been sent to your mail box.', 'script'),
(NULL, 1130, 'pjField', 2, 'title', 'Your password has been sent to your mail box.', 'script'),
(NULL, 1130, 'pjField', 3, 'title', 'Your password has been sent to your mail box.', 'script'),
(NULL, 1131, 'pjField', 1, 'title', 'Not available', 'script'),
(NULL, 1131, 'pjField', 2, 'title', 'Not available', 'script'),
(NULL, 1131, 'pjField', 3, 'title', 'Not available', 'script'),
(NULL, 1132, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1132, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 1132, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 1133, 'pjField', 1, 'title', 'Booking', 'script'),
(NULL, 1133, 'pjField', 2, 'title', 'Booking', 'script'),
(NULL, 1133, 'pjField', 3, 'title', 'Booking', 'script'),
(NULL, 1134, 'pjField', 1, 'title', 'Selected Yacht', 'script'),
(NULL, 1134, 'pjField', 2, 'title', 'Selected Yacht', 'script'),
(NULL, 1134, 'pjField', 3, 'title', 'Selected Yacht', 'script'),
(NULL, 1135, 'pjField', 1, 'title', 'Selected Period', 'script'),
(NULL, 1135, 'pjField', 2, 'title', 'Selected Period', 'script'),
(NULL, 1135, 'pjField', 3, 'title', 'Selected Period', 'script'),
(NULL, 1136, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 1136, 'pjField', 2, 'title', 'Summary', 'script'),
(NULL, 1136, 'pjField', 3, 'title', 'Summary', 'script'),
(NULL, 1137, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1137, 'pjField', 2, 'title', 'Tax', 'script'),
(NULL, 1137, 'pjField', 3, 'title', 'Tax', 'script'),
(NULL, 1138, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1138, 'pjField', 2, 'title', 'Total', 'script'),
(NULL, 1138, 'pjField', 3, 'title', 'Total', 'script'),
(NULL, 1139, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 1139, 'pjField', 2, 'title', 'Deposit', 'script'),
(NULL, 1139, 'pjField', 3, 'title', 'Deposit', 'script'),
(NULL, 1140, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1140, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 1140, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 1141, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1141, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 1141, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 1142, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1142, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 1142, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 1143, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1143, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 1143, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 1144, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1144, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 1144, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 1145, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1145, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 1145, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 1146, 'pjField', 1, 'title', 'Zip code', 'script'),
(NULL, 1146, 'pjField', 2, 'title', 'Zip code', 'script'),
(NULL, 1146, 'pjField', 3, 'title', 'Zip code', 'script'),
(NULL, 1147, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1147, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 1147, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 1148, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 1148, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 1148, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 1149, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 1149, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 1149, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 1150, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 1150, 'pjField', 2, 'title', 'CC type', 'script'),
(NULL, 1150, 'pjField', 3, 'title', 'CC type', 'script'),
(NULL, 1151, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 1151, 'pjField', 2, 'title', 'CC number', 'script'),
(NULL, 1151, 'pjField', 3, 'title', 'CC number', 'script'),
(NULL, 1152, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 1152, 'pjField', 2, 'title', 'CC code', 'script'),
(NULL, 1152, 'pjField', 3, 'title', 'CC code', 'script'),
(NULL, 1153, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 1153, 'pjField', 2, 'title', 'CC expiration', 'script'),
(NULL, 1153, 'pjField', 3, 'title', 'CC expiration', 'script'),
(NULL, 1154, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 1154, 'pjField', 2, 'title', 'PayPal', 'script'),
(NULL, 1154, 'pjField', 3, 'title', 'PayPal', 'script'),
(NULL, 1155, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 1155, 'pjField', 2, 'title', 'Authorize.net', 'script'),
(NULL, 1155, 'pjField', 3, 'title', 'Authorize.net', 'script'),
(NULL, 1156, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 1156, 'pjField', 2, 'title', 'Credit card', 'script'),
(NULL, 1156, 'pjField', 3, 'title', 'Credit card', 'script'),
(NULL, 1157, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 1157, 'pjField', 2, 'title', 'Cash', 'script'),
(NULL, 1157, 'pjField', 3, 'title', 'Cash', 'script'),
(NULL, 1158, 'pjField', 1, 'title', 'Bank', 'script'),
(NULL, 1158, 'pjField', 2, 'title', 'Bank', 'script'),
(NULL, 1158, 'pjField', 3, 'title', 'Bank', 'script'),
(NULL, 1159, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 1159, 'pjField', 2, 'title', 'Maestro', 'script'),
(NULL, 1159, 'pjField', 3, 'title', 'Maestro', 'script'),
(NULL, 1160, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 1160, 'pjField', 2, 'title', 'AmericanExpress', 'script'),
(NULL, 1160, 'pjField', 3, 'title', 'AmericanExpress', 'script'),
(NULL, 1161, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 1161, 'pjField', 2, 'title', 'MasterCard', 'script'),
(NULL, 1161, 'pjField', 3, 'title', 'MasterCard', 'script'),
(NULL, 1162, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 1162, 'pjField', 2, 'title', 'Visa', 'script'),
(NULL, 1162, 'pjField', 3, 'title', 'Visa', 'script'),
(NULL, 1163, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1163, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 1163, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 1164, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 1164, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 1164, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 1165, 'pjField', 1, 'title', 'Title is required.', 'script'),
(NULL, 1165, 'pjField', 2, 'title', 'Title is required.', 'script'),
(NULL, 1165, 'pjField', 3, 'title', 'Title is required.', 'script'),
(NULL, 1166, 'pjField', 1, 'title', 'Phone is required.', 'script'),
(NULL, 1166, 'pjField', 2, 'title', 'Phone is required.', 'script'),
(NULL, 1166, 'pjField', 3, 'title', 'Phone is required.', 'script'),
(NULL, 1167, 'pjField', 1, 'title', 'Company is required.', 'script'),
(NULL, 1167, 'pjField', 2, 'title', 'Company is required.', 'script'),
(NULL, 1167, 'pjField', 3, 'title', 'Company is required.', 'script'),
(NULL, 1168, 'pjField', 1, 'title', 'Address is required.', 'script'),
(NULL, 1168, 'pjField', 2, 'title', 'Address is required.', 'script'),
(NULL, 1168, 'pjField', 3, 'title', 'Address is required.', 'script'),
(NULL, 1169, 'pjField', 1, 'title', 'Country is required.', 'script'),
(NULL, 1169, 'pjField', 2, 'title', 'Country is required.', 'script'),
(NULL, 1169, 'pjField', 3, 'title', 'Country is required.', 'script'),
(NULL, 1170, 'pjField', 1, 'title', 'State is required.', 'script'),
(NULL, 1170, 'pjField', 2, 'title', 'State is required.', 'script'),
(NULL, 1170, 'pjField', 3, 'title', 'State is required.', 'script'),
(NULL, 1171, 'pjField', 1, 'title', 'City is required.', 'script'),
(NULL, 1171, 'pjField', 2, 'title', 'City is required.', 'script'),
(NULL, 1171, 'pjField', 3, 'title', 'City is required.', 'script'),
(NULL, 1172, 'pjField', 1, 'title', 'Zip code is required.', 'script'),
(NULL, 1172, 'pjField', 2, 'title', 'Zip code is required.', 'script'),
(NULL, 1172, 'pjField', 3, 'title', 'Zip code is required.', 'script'),
(NULL, 1173, 'pjField', 1, 'title', 'Notes is required.', 'script'),
(NULL, 1173, 'pjField', 2, 'title', 'Notes is required.', 'script'),
(NULL, 1173, 'pjField', 3, 'title', 'Notes is required.', 'script'),
(NULL, 1174, 'pjField', 1, 'title', 'Payment method is required.', 'script'),
(NULL, 1174, 'pjField', 2, 'title', 'Payment method is required.', 'script'),
(NULL, 1174, 'pjField', 3, 'title', 'Payment method is required.', 'script'),
(NULL, 1175, 'pjField', 1, 'title', 'CC type is required.', 'script'),
(NULL, 1175, 'pjField', 2, 'title', 'CC type is required.', 'script'),
(NULL, 1175, 'pjField', 3, 'title', 'CC type is required.', 'script'),
(NULL, 1176, 'pjField', 1, 'title', 'CC number is required.', 'script'),
(NULL, 1176, 'pjField', 2, 'title', 'CC number is required.', 'script'),
(NULL, 1176, 'pjField', 3, 'title', 'CC number is required.', 'script'),
(NULL, 1177, 'pjField', 1, 'title', 'CC code is required.', 'script'),
(NULL, 1177, 'pjField', 2, 'title', 'CC code is required.', 'script'),
(NULL, 1177, 'pjField', 3, 'title', 'CC code is required.', 'script'),
(NULL, 1178, 'pjField', 1, 'title', 'Your booking is processing. Please wait...', 'script'),
(NULL, 1178, 'pjField', 2, 'title', 'Your booking is processing. Please wait...', 'script'),
(NULL, 1178, 'pjField', 3, 'title', 'Your booking is processing. Please wait...', 'script'),
(NULL, 1179, 'pjField', 1, 'title', 'The booking could not be saved.', 'script'),
(NULL, 1179, 'pjField', 2, 'title', 'The booking could not be saved.', 'script'),
(NULL, 1179, 'pjField', 3, 'title', 'The booking could not be saved.', 'script'),
(NULL, 1180, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 1180, 'pjField', 2, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 1180, 'pjField', 3, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 1181, 'pjField', 1, 'title', 'Thank you! Your booking has been made. We will contact you ASAP.', 'script'),
(NULL, 1181, 'pjField', 2, 'title', 'Thank you! Your booking has been made. We will contact you ASAP.', 'script'),
(NULL, 1181, 'pjField', 3, 'title', 'Thank you! Your booking has been made. We will contact you ASAP.', 'script'),
(NULL, 1182, 'pjField', 1, 'title', 'Cancel booking', 'script'),
(NULL, 1182, 'pjField', 2, 'title', 'Cancel booking', 'script'),
(NULL, 1182, 'pjField', 3, 'title', 'Cancel booking', 'script'),
(NULL, 1183, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 1183, 'pjField', 2, 'title', 'Booking ID', 'script'),
(NULL, 1183, 'pjField', 3, 'title', 'Booking ID', 'script'),
(NULL, 1184, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 1184, 'pjField', 2, 'title', 'Sub-total', 'script'),
(NULL, 1184, 'pjField', 3, 'title', 'Sub-total', 'script'),
(NULL, 1185, 'pjField', 1, 'title', 'Booking created', 'script'),
(NULL, 1185, 'pjField', 2, 'title', 'Booking created', 'script'),
(NULL, 1185, 'pjField', 3, 'title', 'Booking created', 'script'),
(NULL, 1186, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1186, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 1186, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 1187, 'pjField', 1, 'title', 'Personal details', 'script'),
(NULL, 1187, 'pjField', 2, 'title', 'Personal details', 'script'),
(NULL, 1187, 'pjField', 3, 'title', 'Personal details', 'script'),
(NULL, 1188, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 1188, 'pjField', 2, 'title', 'Booking details', 'script'),
(NULL, 1188, 'pjField', 3, 'title', 'Booking details', 'script'),
(NULL, 1189, 'pjField', 1, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 1189, 'pjField', 2, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 1189, 'pjField', 3, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 1190, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 1190, 'pjField', 2, 'title', 'Missing parameters', 'script'),
(NULL, 1190, 'pjField', 3, 'title', 'Missing parameters', 'script'),
(NULL, 1191, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 1191, 'pjField', 2, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 1191, 'pjField', 3, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 1192, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 1192, 'pjField', 2, 'title', 'Security hash did not match.', 'script'),
(NULL, 1192, 'pjField', 3, 'title', 'Security hash did not match.', 'script'),
(NULL, 1193, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 1193, 'pjField', 2, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 1193, 'pjField', 3, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 1194, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 1194, 'pjField', 2, 'title', 'No records selected', 'script'),
(NULL, 1194, 'pjField', 3, 'title', 'No records selected', 'script'),
(NULL, 1195, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 1195, 'pjField', 2, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 1195, 'pjField', 3, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 1196, 'pjField', 1, 'title', 'Contact Details', 'script'),
(NULL, 1196, 'pjField', 2, 'title', 'Contact Details', 'script'),
(NULL, 1196, 'pjField', 3, 'title', 'Contact Details', 'script'),
(NULL, 1197, 'pjField', 1, 'title', 'Yachts for rent', 'script'),
(NULL, 1197, 'pjField', 2, 'title', 'Yachts for rent', 'script'),
(NULL, 1197, 'pjField', 3, 'title', 'Yachts for rent', 'script'),
(NULL, 1198, 'pjField', 1, 'title', 'Yachts for sale', 'script'),
(NULL, 1198, 'pjField', 2, 'title', 'Yachts for sale', 'script'),
(NULL, 1198, 'pjField', 3, 'title', 'Yachts for sale', 'script'),
(NULL, 1199, 'pjField', 1, 'title', 'Book Now', 'script'),
(NULL, 1199, 'pjField', 2, 'title', 'Book Now', 'script'),
(NULL, 1199, 'pjField', 3, 'title', 'Book Now', 'script'),
(NULL, 1200, 'pjField', 1, 'title', 'Enter your details to complete booking', 'script'),
(NULL, 1200, 'pjField', 2, 'title', 'Enter your details to complete booking', 'script'),
(NULL, 1200, 'pjField', 3, 'title', 'Enter your details to complete booking', 'script'),
(NULL, 1201, 'pjField', 1, 'title', 'per week', 'script'),
(NULL, 1201, 'pjField', 2, 'title', 'per week', 'script'),
(NULL, 1201, 'pjField', 3, 'title', 'per week', 'script'),
(NULL, 1202, 'pjField', 1, 'title', 'Speed in', 'script'),
(NULL, 1202, 'pjField', 2, 'title', 'Speed in', 'script'),
(NULL, 1202, 'pjField', 3, 'title', 'Speed in', 'script'),
(NULL, 1203, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 1203, 'pjField', 2, 'title', 'hours', 'script'),
(NULL, 1203, 'pjField', 3, 'title', 'hours', 'script'),
(NULL, 1204, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 1204, 'pjField', 2, 'title', 'hours', 'script'),
(NULL, 1204, 'pjField', 3, 'title', 'hours', 'script'),
(NULL, 1205, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 1205, 'pjField', 2, 'title', 'Reservations', 'script'),
(NULL, 1205, 'pjField', 3, 'title', 'Reservations', 'script'),
(NULL, 1206, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 1206, 'pjField', 2, 'title', 'Confirmed', 'script'),
(NULL, 1206, 'pjField', 3, 'title', 'Confirmed', 'script'),
(NULL, 1207, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 1207, 'pjField', 2, 'title', 'Pending', 'script'),
(NULL, 1207, 'pjField', 3, 'title', 'Pending', 'script'),
(NULL, 1208, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 1208, 'pjField', 2, 'title', 'Cancelled', 'script'),
(NULL, 1208, 'pjField', 3, 'title', 'Cancelled', 'script'),
(NULL, 1209, 'pjField', 1, 'title', 'Add reservation', 'script'),
(NULL, 1209, 'pjField', 2, 'title', 'Add reservation', 'script'),
(NULL, 1209, 'pjField', 3, 'title', 'Add reservation', 'script'),
(NULL, 1210, 'pjField', 1, 'title', 'Rental reservations', 'script'),
(NULL, 1210, 'pjField', 2, 'title', 'Rental reservations', 'script'),
(NULL, 1210, 'pjField', 3, 'title', 'Rental reservations', 'script'),
(NULL, 1211, 'pjField', 1, 'title', 'Below you can see a list with all rental reservations. Under Add reservation tab you can manually add a reservation.', 'script'),
(NULL, 1211, 'pjField', 2, 'title', 'Below you can see a list with all rental reservations. Under Add reservation tab you can manually add a reservation.', 'script'),
(NULL, 1211, 'pjField', 3, 'title', 'Below you can see a list with all rental reservations. Under Add reservation tab you can manually add a reservation.', 'script'),
(NULL, 1212, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1212, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 1212, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 1213, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 1213, 'pjField', 2, 'title', 'from', 'script'),
(NULL, 1213, 'pjField', 3, 'title', 'from', 'script'),
(NULL, 1214, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 1214, 'pjField', 2, 'title', 'to', 'script'),
(NULL, 1214, 'pjField', 3, 'title', 'to', 'script'),
(NULL, 1215, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1215, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 1215, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 1216, 'pjField', 1, 'title', 'Add new reservation', 'script'),
(NULL, 1216, 'pjField', 2, 'title', 'Add new reservation', 'script'),
(NULL, 1216, 'pjField', 3, 'title', 'Add new reservation', 'script'),
(NULL, 1217, 'pjField', 1, 'title', 'Fill in the form below and click on Save button to add new reservation.', 'script'),
(NULL, 1217, 'pjField', 2, 'title', 'Fill in the form below and click on Save button to add new reservation.', 'script'),
(NULL, 1217, 'pjField', 3, 'title', 'Fill in the form below and click on Save button to add new reservation.', 'script'),
(NULL, 1218, 'pjField', 1, 'title', 'Reservation details', 'script'),
(NULL, 1218, 'pjField', 2, 'title', 'Reservation details', 'script'),
(NULL, 1218, 'pjField', 3, 'title', 'Reservation details', 'script'),
(NULL, 1219, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 1219, 'pjField', 2, 'title', 'Client details', 'script'),
(NULL, 1219, 'pjField', 3, 'title', 'Client details', 'script'),
(NULL, 1220, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 1220, 'pjField', 2, 'title', 'Sub-total', 'script'),
(NULL, 1220, 'pjField', 3, 'title', 'Sub-total', 'script'),
(NULL, 1221, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1221, 'pjField', 2, 'title', 'Tax', 'script'),
(NULL, 1221, 'pjField', 3, 'title', 'Tax', 'script'),
(NULL, 1222, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1222, 'pjField', 2, 'title', 'Total', 'script'),
(NULL, 1222, 'pjField', 3, 'title', 'Total', 'script'),
(NULL, 1223, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 1223, 'pjField', 2, 'title', 'Deposit', 'script'),
(NULL, 1223, 'pjField', 3, 'title', 'Deposit', 'script'),
(NULL, 1224, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 1224, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 1224, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 1225, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 1225, 'pjField', 2, 'title', 'CC type', 'script'),
(NULL, 1225, 'pjField', 3, 'title', 'CC type', 'script'),
(NULL, 1226, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 1226, 'pjField', 2, 'title', 'CC number', 'script'),
(NULL, 1226, 'pjField', 3, 'title', 'CC number', 'script'),
(NULL, 1227, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 1227, 'pjField', 2, 'title', 'CC expiration', 'script'),
(NULL, 1227, 'pjField', 3, 'title', 'CC expiration', 'script'),
(NULL, 1228, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 1228, 'pjField', 2, 'title', 'CC code', 'script'),
(NULL, 1228, 'pjField', 3, 'title', 'CC code', 'script'),
(NULL, 1229, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1229, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 1229, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 1230, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1230, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 1230, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 1231, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1231, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 1231, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 1232, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1232, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 1232, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 1233, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1233, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 1233, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 1234, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1234, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 1234, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 1235, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1235, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 1235, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 1236, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1236, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 1236, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 1237, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1237, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 1237, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 1238, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1238, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 1238, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 1239, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1239, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 1239, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 1240, 'pjField', 1, 'title', 'Update reservation', 'script'),
(NULL, 1240, 'pjField', 2, 'title', 'Update reservation', 'script'),
(NULL, 1240, 'pjField', 3, 'title', 'Update reservation', 'script'),
(NULL, 1241, 'pjField', 1, 'title', 'Update reservation', 'script'),
(NULL, 1241, 'pjField', 2, 'title', 'Update reservation', 'script'),
(NULL, 1241, 'pjField', 3, 'title', 'Update reservation', 'script'),
(NULL, 1242, 'pjField', 1, 'title', 'You can make any change on the form below and click on Save button to update reservation information.', 'script'),
(NULL, 1242, 'pjField', 2, 'title', 'You can make any change on the form below and click on Save button to update reservation information.', 'script'),
(NULL, 1242, 'pjField', 3, 'title', 'You can make any change on the form below and click on Save button to update reservation information.', 'script'),
(NULL, 1243, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 1243, 'pjField', 2, 'title', 'Created', 'script'),
(NULL, 1243, 'pjField', 3, 'title', 'Created', 'script'),
(NULL, 1244, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 1244, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 1244, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 1245, 'pjField', 1, 'title', 'Resend confirmation', 'script'),
(NULL, 1245, 'pjField', 2, 'title', 'Resend confirmation', 'script'),
(NULL, 1245, 'pjField', 3, 'title', 'Resend confirmation', 'script'),
(NULL, 1246, 'pjField', 1, 'title', 'Resend confirmation', 'script'),
(NULL, 1246, 'pjField', 2, 'title', 'Resend confirmation', 'script'),
(NULL, 1246, 'pjField', 3, 'title', 'Resend confirmation', 'script'),
(NULL, 1247, 'pjField', 1, 'title', 'You are about to re-send the confirmation email to client who made the booking. Please click on the button Send of which email you refer to.', 'script'),
(NULL, 1247, 'pjField', 2, 'title', 'You are about to re-send the confirmation email to client who made the booking. Please click on the button Send of which email you refer to.', 'script'),
(NULL, 1247, 'pjField', 3, 'title', 'You are about to re-send the confirmation email to client who made the booking. Please click on the button Send of which email you refer to.', 'script'),
(NULL, 1248, 'pjField', 1, 'title', 'Confirmation email', 'script'),
(NULL, 1248, 'pjField', 2, 'title', 'Confirmation email', 'script'),
(NULL, 1248, 'pjField', 3, 'title', 'Confirmation email', 'script'),
(NULL, 1249, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 1249, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 1249, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 1250, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 1250, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 1250, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 1251, 'pjField', 1, 'title', 'Payment email', 'script'),
(NULL, 1251, 'pjField', 2, 'title', 'Payment email', 'script'),
(NULL, 1251, 'pjField', 3, 'title', 'Payment email', 'script'),
(NULL, 1252, 'pjField', 1, 'title', 'Reservation updated', 'script'),
(NULL, 1252, 'pjField', 2, 'title', 'Reservation updated', 'script'),
(NULL, 1252, 'pjField', 3, 'title', 'Reservation updated', 'script'),
(NULL, 1253, 'pjField', 1, 'title', 'All changes made to the reservation have been saved successfully.', 'script'),
(NULL, 1253, 'pjField', 2, 'title', 'All changes made to the reservation have been saved successfully.', 'script'),
(NULL, 1253, 'pjField', 3, 'title', 'All changes made to the reservation have been saved successfully.', 'script'),
(NULL, 1254, 'pjField', 1, 'title', 'Reservation added', 'script'),
(NULL, 1254, 'pjField', 2, 'title', 'Reservation added', 'script'),
(NULL, 1254, 'pjField', 3, 'title', 'Reservation added', 'script'),
(NULL, 1255, 'pjField', 1, 'title', 'A new reservation has been added into the system.', 'script'),
(NULL, 1255, 'pjField', 2, 'title', 'A new reservation has been added into the system.', 'script'),
(NULL, 1255, 'pjField', 3, 'title', 'A new reservation has been added into the system.', 'script'),
(NULL, 1256, 'pjField', 1, 'title', 'Reservation failed to add', 'script'),
(NULL, 1256, 'pjField', 2, 'title', 'Reservation failed to add', 'script'),
(NULL, 1256, 'pjField', 3, 'title', 'Reservation failed to add', 'script'),
(NULL, 1257, 'pjField', 1, 'title', 'We are sorry that new reservation could not be added successfully.', 'script'),
(NULL, 1257, 'pjField', 2, 'title', 'We are sorry that new reservation could not be added successfully.', 'script'),
(NULL, 1257, 'pjField', 3, 'title', 'We are sorry that new reservation could not be added successfully.', 'script'),
(NULL, 1258, 'pjField', 1, 'title', 'Reservation not found', 'script'),
(NULL, 1258, 'pjField', 2, 'title', 'Reservation not found', 'script'),
(NULL, 1258, 'pjField', 3, 'title', 'Reservation not found', 'script'),
(NULL, 1259, 'pjField', 1, 'title', 'We are sorry that the reservation you are looking for is missing.', 'script'),
(NULL, 1259, 'pjField', 2, 'title', 'We are sorry that the reservation you are looking for is missing.', 'script'),
(NULL, 1259, 'pjField', 3, 'title', 'We are sorry that the reservation you are looking for is missing.', 'script'),
(NULL, 1260, 'pjField', 1, 'title', 'Confirmation email sent', 'script'),
(NULL, 1260, 'pjField', 2, 'title', 'Confirmation email sent', 'script'),
(NULL, 1260, 'pjField', 3, 'title', 'Confirmation email sent', 'script'),
(NULL, 1261, 'pjField', 1, 'title', 'The confirmation email has been sent to the client.', 'script'),
(NULL, 1261, 'pjField', 2, 'title', 'The confirmation email has been sent to the client.', 'script'),
(NULL, 1261, 'pjField', 3, 'title', 'The confirmation email has been sent to the client.', 'script'),
(NULL, 1262, 'pjField', 1, 'title', 'yacht for sale', 'script'),
(NULL, 1262, 'pjField', 2, 'title', 'yacht for sale', 'script'),
(NULL, 1262, 'pjField', 3, 'title', 'yacht for sale', 'script'),
(NULL, 1263, 'pjField', 1, 'title', 'yachts for sale', 'script'),
(NULL, 1263, 'pjField', 2, 'title', 'yachts for sale', 'script'),
(NULL, 1263, 'pjField', 3, 'title', 'yachts for sale', 'script'),
(NULL, 1264, 'pjField', 1, 'title', 'yacht for rent', 'script'),
(NULL, 1264, 'pjField', 2, 'title', 'yacht for rent', 'script'),
(NULL, 1264, 'pjField', 3, 'title', 'yacht for rent', 'script'),
(NULL, 1265, 'pjField', 1, 'title', 'yachts for rent', 'script'),
(NULL, 1265, 'pjField', 2, 'title', 'yachts for rent', 'script'),
(NULL, 1265, 'pjField', 3, 'title', 'yachts for rent', 'script'),
(NULL, 1266, 'pjField', 1, 'title', 'rental reservation', 'script'),
(NULL, 1266, 'pjField', 2, 'title', 'rental reservation', 'script'),
(NULL, 1266, 'pjField', 3, 'title', 'rental reservation', 'script'),
(NULL, 1267, 'pjField', 1, 'title', 'rental reservations', 'script'),
(NULL, 1267, 'pjField', 2, 'title', 'rental reservations', 'script'),
(NULL, 1267, 'pjField', 3, 'title', 'rental reservations', 'script'),
(NULL, 1268, 'pjField', 1, 'title', 'Most Popular', 'script'),
(NULL, 1268, 'pjField', 2, 'title', 'Most Popular', 'script'),
(NULL, 1268, 'pjField', 3, 'title', 'Most Popular', 'script'),
(NULL, 1269, 'pjField', 1, 'title', 'View all', 'script'),
(NULL, 1269, 'pjField', 2, 'title', 'View all', 'script'),
(NULL, 1269, 'pjField', 3, 'title', 'View all', 'script'),
(NULL, 1272, 'pjField', 1, 'title', 'Reservation ID', 'script'),
(NULL, 1272, 'pjField', 2, 'title', 'Reservation ID', 'script'),
(NULL, 1272, 'pjField', 3, 'title', 'Reservation ID', 'script'),
(NULL, 1274, 'pjField', 1, 'title', 'Yachts not found.', 'script'),
(NULL, 1274, 'pjField', 2, 'title', 'Yachts not found.', 'script'),
(NULL, 1274, 'pjField', 3, 'title', 'Yachts not found.', 'script'),
(NULL, 1275, 'pjField', 1, 'title', 'Reservations not found', 'script'),
(NULL, 1275, 'pjField', 2, 'title', 'Reservations not found', 'script'),
(NULL, 1275, 'pjField', 3, 'title', 'Reservations not found', 'script'),
(NULL, 1276, 'pjField', 1, 'title', 'Latest Reservations', 'script'),
(NULL, 1276, 'pjField', 2, 'title', 'Latest Reservations', 'script'),
(NULL, 1276, 'pjField', 3, 'title', 'Latest Reservations', 'script'),
(NULL, 1277, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 1277, 'pjField', 2, 'title', 'Reservations', 'script'),
(NULL, 1277, 'pjField', 3, 'title', 'Reservations', 'script'),
(NULL, 1278, 'pjField', 1, 'title', 'The selected week is not available.', 'script'),
(NULL, 1278, 'pjField', 2, 'title', 'The selected week is not available.', 'script'),
(NULL, 1278, 'pjField', 3, 'title', 'The selected week is not available.', 'script'),
(NULL, 1457, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 1457, 'pjField', 2, 'title', 'Please enter only digits.', 'script'),
(NULL, 1457, 'pjField', 3, 'title', 'Please enter only digits.', 'script'),
(NULL, 1458, 'pjField', 1, 'title', 'Please, enter 4 digits.', 'script'),
(NULL, 1458, 'pjField', 2, 'title', 'Please, enter 4 digits.', 'script'),
(NULL, 1458, 'pjField', 3, 'title', 'Please, enter 4 digits.', 'script'),
(NULL, 1459, 'pjField', 1, 'title', 'Please, enter 4 digits.', 'script'),
(NULL, 1459, 'pjField', 2, 'title', 'Please, enter 4 digits.', 'script'),
(NULL, 1459, 'pjField', 3, 'title', 'Please, enter 4 digits.', 'script'),
(NULL, 1460, 'pjField', 1, 'title', 'Please enter no more than 5 digits.', 'script'),
(NULL, 1460, 'pjField', 2, 'title', 'Please enter no more than 5 digits.', 'script'),
(NULL, 1460, 'pjField', 3, 'title', 'Please enter no more than 5 digits.', 'script'),
(NULL, 1461, 'pjField', 1, 'title', 'There are no weekly prices added for the yacht.', 'script'),
(NULL, 1461, 'pjField', 2, 'title', 'There are no weekly prices added for the yacht.', 'script'),
(NULL, 1461, 'pjField', 3, 'title', 'There are no weekly prices added for the yacht.', 'script'),
(NULL, 1, 'pjManufacturer', 1, 'name', 'Albemarle', 'data'),
(NULL, 1, 'pjManufacturer', 2, 'name', 'Albemarle', 'data'),
(NULL, 1, 'pjManufacturer', 3, 'name', 'Albemarle', 'data'),
(NULL, 2, 'pjManufacturer', 1, 'name', 'Albin', 'data'),
(NULL, 2, 'pjManufacturer', 2, 'name', 'Albin', 'data'),
(NULL, 2, 'pjManufacturer', 3, 'name', 'Albin', 'data'),
(NULL, 3, 'pjManufacturer', 1, 'name', 'Astondoa', 'data'),
(NULL, 3, 'pjManufacturer', 2, 'name', 'Astondoa', 'data'),
(NULL, 3, 'pjManufacturer', 3, 'name', 'Astondoa', 'data'),
(NULL, 4, 'pjManufacturer', 1, 'name', 'Azimut', 'data'),
(NULL, 4, 'pjManufacturer', 2, 'name', 'Azimut', 'data'),
(NULL, 4, 'pjManufacturer', 3, 'name', 'Azimut', 'data'),
(NULL, 5, 'pjManufacturer', 1, 'name', 'Baja', 'data'),
(NULL, 5, 'pjManufacturer', 2, 'name', 'Baja', 'data'),
(NULL, 5, 'pjManufacturer', 3, 'name', 'Baja', 'data'),
(NULL, 6, 'pjManufacturer', 1, 'name', 'Bavaria', 'data'),
(NULL, 6, 'pjManufacturer', 2, 'name', 'Bavaria', 'data'),
(NULL, 6, 'pjManufacturer', 3, 'name', 'Bavaria', 'data'),
(NULL, 7, 'pjManufacturer', 1, 'name', 'Bayliner', 'data'),
(NULL, 7, 'pjManufacturer', 2, 'name', 'Bayliner', 'data'),
(NULL, 7, 'pjManufacturer', 3, 'name', 'Bayliner', 'data'),
(NULL, 8, 'pjManufacturer', 1, 'name', 'Beneteau', 'data'),
(NULL, 8, 'pjManufacturer', 2, 'name', 'Beneteau', 'data'),
(NULL, 8, 'pjManufacturer', 3, 'name', 'Beneteau', 'data'),
(NULL, 9, 'pjManufacturer', 1, 'name', 'Bertram', 'data'),
(NULL, 9, 'pjManufacturer', 2, 'name', 'Bertram', 'data'),
(NULL, 9, 'pjManufacturer', 3, 'name', 'Bertram', 'data'),
(NULL, 10, 'pjManufacturer', 1, 'name', 'Blackfin', 'data'),
(NULL, 10, 'pjManufacturer', 2, 'name', 'Blackfin', 'data'),
(NULL, 10, 'pjManufacturer', 3, 'name', 'Blackfin', 'data'),
(NULL, 11, 'pjManufacturer', 1, 'name', 'Boston Whaler', 'data'),
(NULL, 11, 'pjManufacturer', 2, 'name', 'Boston Whaler', 'data'),
(NULL, 11, 'pjManufacturer', 3, 'name', 'Boston Whaler', 'data'),
(NULL, 12, 'pjManufacturer', 1, 'name', 'C&c', 'data'),
(NULL, 12, 'pjManufacturer', 2, 'name', 'C&c', 'data'),
(NULL, 12, 'pjManufacturer', 3, 'name', 'C&c', 'data'),
(NULL, 13, 'pjManufacturer', 1, 'name', 'Cabo', 'data'),
(NULL, 13, 'pjManufacturer', 2, 'name', 'Cabo', 'data'),
(NULL, 13, 'pjManufacturer', 3, 'name', 'Cabo', 'data'),
(NULL, 14, 'pjManufacturer', 1, 'name', 'Californian', 'data'),
(NULL, 14, 'pjManufacturer', 2, 'name', 'Californian', 'data'),
(NULL, 14, 'pjManufacturer', 3, 'name', 'Californian', 'data'),
(NULL, 15, 'pjManufacturer', 1, 'name', 'Canados', 'data'),
(NULL, 15, 'pjManufacturer', 2, 'name', 'Canados', 'data'),
(NULL, 15, 'pjManufacturer', 3, 'name', 'Canados', 'data'),
(NULL, 16, 'pjManufacturer', 1, 'name', 'Carver', 'data'),
(NULL, 16, 'pjManufacturer', 2, 'name', 'Carver', 'data'),
(NULL, 16, 'pjManufacturer', 3, 'name', 'Carver', 'data'),
(NULL, 17, 'pjManufacturer', 1, 'name', 'Catalina', 'data'),
(NULL, 17, 'pjManufacturer', 2, 'name', 'Catalina', 'data'),
(NULL, 17, 'pjManufacturer', 3, 'name', 'Catalina', 'data'),
(NULL, 18, 'pjManufacturer', 1, 'name', 'Century', 'data'),
(NULL, 18, 'pjManufacturer', 2, 'name', 'Century', 'data'),
(NULL, 18, 'pjManufacturer', 3, 'name', 'Century', 'data'),
(NULL, 19, 'pjManufacturer', 1, 'name', 'Chaparral', 'data'),
(NULL, 19, 'pjManufacturer', 2, 'name', 'Chaparral', 'data'),
(NULL, 19, 'pjManufacturer', 3, 'name', 'Chaparral', 'data'),
(NULL, 20, 'pjManufacturer', 1, 'name', 'Cheoy Lee', 'data'),
(NULL, 20, 'pjManufacturer', 2, 'name', 'Cheoy Lee', 'data'),
(NULL, 20, 'pjManufacturer', 3, 'name', 'Cheoy Lee', 'data'),
(NULL, 21, 'pjManufacturer', 1, 'name', 'Chris Craft', 'data'),
(NULL, 21, 'pjManufacturer', 2, 'name', 'Chris Craft', 'data'),
(NULL, 21, 'pjManufacturer', 3, 'name', 'Chris Craft', 'data'),
(NULL, 22, 'pjManufacturer', 1, 'name', 'Chris-craft', 'data'),
(NULL, 22, 'pjManufacturer', 2, 'name', 'Chris-craft', 'data'),
(NULL, 22, 'pjManufacturer', 3, 'name', 'Chris-craft', 'data'),
(NULL, 23, 'pjManufacturer', 1, 'name', 'Cobalt', 'data'),
(NULL, 23, 'pjManufacturer', 2, 'name', 'Cobalt', 'data'),
(NULL, 23, 'pjManufacturer', 3, 'name', 'Cobalt', 'data'),
(NULL, 24, 'pjManufacturer', 1, 'name', 'Contender', 'data'),
(NULL, 24, 'pjManufacturer', 2, 'name', 'Contender', 'data'),
(NULL, 24, 'pjManufacturer', 3, 'name', 'Contender', 'data'),
(NULL, 25, 'pjManufacturer', 1, 'name', 'Cranchi', 'data'),
(NULL, 25, 'pjManufacturer', 2, 'name', 'Cranchi', 'data'),
(NULL, 25, 'pjManufacturer', 3, 'name', 'Cranchi', 'data'),
(NULL, 26, 'pjManufacturer', 1, 'name', 'Crownline', 'data'),
(NULL, 26, 'pjManufacturer', 2, 'name', 'Crownline', 'data'),
(NULL, 26, 'pjManufacturer', 3, 'name', 'Crownline', 'data'),
(NULL, 27, 'pjManufacturer', 1, 'name', 'Cruisers', 'data'),
(NULL, 27, 'pjManufacturer', 2, 'name', 'Cruisers', 'data'),
(NULL, 27, 'pjManufacturer', 3, 'name', 'Cruisers', 'data'),
(NULL, 28, 'pjManufacturer', 1, 'name', 'Cruisers Yachts', 'data'),
(NULL, 28, 'pjManufacturer', 2, 'name', 'Cruisers Yachts', 'data'),
(NULL, 28, 'pjManufacturer', 3, 'name', 'Cruisers Yachts', 'data'),
(NULL, 29, 'pjManufacturer', 1, 'name', 'Custom', 'data'),
(NULL, 29, 'pjManufacturer', 2, 'name', 'Custom', 'data'),
(NULL, 29, 'pjManufacturer', 3, 'name', 'Custom', 'data'),
(NULL, 30, 'pjManufacturer', 1, 'name', 'Custom Build', 'data'),
(NULL, 30, 'pjManufacturer', 2, 'name', 'Custom Build', 'data'),
(NULL, 30, 'pjManufacturer', 3, 'name', 'Custom Build', 'data'),
(NULL, 31, 'pjManufacturer', 1, 'name', 'Dehler', 'data'),
(NULL, 31, 'pjManufacturer', 2, 'name', 'Dehler', 'data'),
(NULL, 31, 'pjManufacturer', 3, 'name', 'Dehler', 'data'),
(NULL, 32, 'pjManufacturer', 1, 'name', 'Donzi', 'data'),
(NULL, 32, 'pjManufacturer', 2, 'name', 'Donzi', 'data'),
(NULL, 32, 'pjManufacturer', 3, 'name', 'Donzi', 'data'),
(NULL, 33, 'pjManufacturer', 1, 'name', 'Doral', 'data'),
(NULL, 33, 'pjManufacturer', 2, 'name', 'Doral', 'data'),
(NULL, 33, 'pjManufacturer', 3, 'name', 'Doral', 'data'),
(NULL, 34, 'pjManufacturer', 1, 'name', 'Dufour', 'data'),
(NULL, 34, 'pjManufacturer', 2, 'name', 'Dufour', 'data'),
(NULL, 34, 'pjManufacturer', 3, 'name', 'Dufour', 'data'),
(NULL, 35, 'pjManufacturer', 1, 'name', 'Egg Harbor', 'data'),
(NULL, 35, 'pjManufacturer', 2, 'name', 'Egg Harbor', 'data'),
(NULL, 35, 'pjManufacturer', 3, 'name', 'Egg Harbor', 'data'),
(NULL, 36, 'pjManufacturer', 1, 'name', 'Elan', 'data'),
(NULL, 36, 'pjManufacturer', 2, 'name', 'Elan', 'data'),
(NULL, 36, 'pjManufacturer', 3, 'name', 'Elan', 'data'),
(NULL, 37, 'pjManufacturer', 1, 'name', 'Fairline', 'data'),
(NULL, 37, 'pjManufacturer', 2, 'name', 'Fairline', 'data'),
(NULL, 37, 'pjManufacturer', 3, 'name', 'Fairline', 'data'),
(NULL, 38, 'pjManufacturer', 1, 'name', 'Ferretti', 'data'),
(NULL, 38, 'pjManufacturer', 2, 'name', 'Ferretti', 'data'),
(NULL, 38, 'pjManufacturer', 3, 'name', 'Ferretti', 'data'),
(NULL, 39, 'pjManufacturer', 1, 'name', 'Formula', 'data'),
(NULL, 39, 'pjManufacturer', 2, 'name', 'Formula', 'data'),
(NULL, 39, 'pjManufacturer', 3, 'name', 'Formula', 'data'),
(NULL, 40, 'pjManufacturer', 1, 'name', 'Fountain', 'data'),
(NULL, 40, 'pjManufacturer', 2, 'name', 'Fountain', 'data'),
(NULL, 40, 'pjManufacturer', 3, 'name', 'Fountain', 'data'),
(NULL, 41, 'pjManufacturer', 1, 'name', 'Fountaine Pajot', 'data'),
(NULL, 41, 'pjManufacturer', 2, 'name', 'Fountaine Pajot', 'data'),
(NULL, 41, 'pjManufacturer', 3, 'name', 'Fountaine Pajot', 'data');
INSERT INTO `yachtlisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 42, 'pjManufacturer', 1, 'name', 'Four Winns', 'data'),
(NULL, 42, 'pjManufacturer', 2, 'name', 'Four Winns', 'data'),
(NULL, 42, 'pjManufacturer', 3, 'name', 'Four Winns', 'data'),
(NULL, 43, 'pjManufacturer', 1, 'name', 'Gib''sea', 'data'),
(NULL, 43, 'pjManufacturer', 2, 'name', 'Gib''sea', 'data'),
(NULL, 43, 'pjManufacturer', 3, 'name', 'Gib''sea', 'data'),
(NULL, 44, 'pjManufacturer', 1, 'name', 'Grady White', 'data'),
(NULL, 44, 'pjManufacturer', 2, 'name', 'Grady White', 'data'),
(NULL, 44, 'pjManufacturer', 3, 'name', 'Grady White', 'data'),
(NULL, 45, 'pjManufacturer', 1, 'name', 'Grand Banks', 'data'),
(NULL, 45, 'pjManufacturer', 2, 'name', 'Grand Banks', 'data'),
(NULL, 45, 'pjManufacturer', 3, 'name', 'Grand Banks', 'data'),
(NULL, 46, 'pjManufacturer', 1, 'name', 'Grand Soleil', 'data'),
(NULL, 46, 'pjManufacturer', 2, 'name', 'Grand Soleil', 'data'),
(NULL, 46, 'pjManufacturer', 3, 'name', 'Grand Soleil', 'data'),
(NULL, 47, 'pjManufacturer', 1, 'name', 'Guy Couach', 'data'),
(NULL, 47, 'pjManufacturer', 2, 'name', 'Guy Couach', 'data'),
(NULL, 47, 'pjManufacturer', 3, 'name', 'Guy Couach', 'data'),
(NULL, 48, 'pjManufacturer', 1, 'name', 'Hallberg-rassy', 'data'),
(NULL, 48, 'pjManufacturer', 2, 'name', 'Hallberg-rassy', 'data'),
(NULL, 48, 'pjManufacturer', 3, 'name', 'Hallberg-rassy', 'data'),
(NULL, 49, 'pjManufacturer', 1, 'name', 'Hanse', 'data'),
(NULL, 49, 'pjManufacturer', 2, 'name', 'Hanse', 'data'),
(NULL, 49, 'pjManufacturer', 3, 'name', 'Hanse', 'data'),
(NULL, 50, 'pjManufacturer', 1, 'name', 'Hatteras', 'data'),
(NULL, 50, 'pjManufacturer', 2, 'name', 'Hatteras', 'data'),
(NULL, 50, 'pjManufacturer', 3, 'name', 'Hatteras', 'data'),
(NULL, 51, 'pjManufacturer', 1, 'name', 'Hinckley', 'data'),
(NULL, 51, 'pjManufacturer', 2, 'name', 'Hinckley', 'data'),
(NULL, 51, 'pjManufacturer', 3, 'name', 'Hinckley', 'data'),
(NULL, 52, 'pjManufacturer', 1, 'name', 'Hunter', 'data'),
(NULL, 52, 'pjManufacturer', 2, 'name', 'Hunter', 'data'),
(NULL, 52, 'pjManufacturer', 3, 'name', 'Hunter', 'data'),
(NULL, 53, 'pjManufacturer', 1, 'name', 'Hydra-sports', 'data'),
(NULL, 53, 'pjManufacturer', 2, 'name', 'Hydra-sports', 'data'),
(NULL, 53, 'pjManufacturer', 3, 'name', 'Hydra-sports', 'data'),
(NULL, 54, 'pjManufacturer', 1, 'name', 'Island Packet', 'data'),
(NULL, 54, 'pjManufacturer', 2, 'name', 'Island Packet', 'data'),
(NULL, 54, 'pjManufacturer', 3, 'name', 'Island Packet', 'data'),
(NULL, 55, 'pjManufacturer', 1, 'name', 'J Boats', 'data'),
(NULL, 55, 'pjManufacturer', 2, 'name', 'J Boats', 'data'),
(NULL, 55, 'pjManufacturer', 3, 'name', 'J Boats', 'data'),
(NULL, 56, 'pjManufacturer', 1, 'name', 'Jeanneau', 'data'),
(NULL, 56, 'pjManufacturer', 2, 'name', 'Jeanneau', 'data'),
(NULL, 56, 'pjManufacturer', 3, 'name', 'Jeanneau', 'data'),
(NULL, 57, 'pjManufacturer', 1, 'name', 'Jefferson', 'data'),
(NULL, 57, 'pjManufacturer', 2, 'name', 'Jefferson', 'data'),
(NULL, 57, 'pjManufacturer', 3, 'name', 'Jefferson', 'data'),
(NULL, 58, 'pjManufacturer', 1, 'name', 'Lagoon', 'data'),
(NULL, 58, 'pjManufacturer', 2, 'name', 'Lagoon', 'data'),
(NULL, 58, 'pjManufacturer', 3, 'name', 'Lagoon', 'data'),
(NULL, 59, 'pjManufacturer', 1, 'name', 'Larson', 'data'),
(NULL, 59, 'pjManufacturer', 2, 'name', 'Larson', 'data'),
(NULL, 59, 'pjManufacturer', 3, 'name', 'Larson', 'data'),
(NULL, 60, 'pjManufacturer', 1, 'name', 'Luhrs', 'data'),
(NULL, 60, 'pjManufacturer', 2, 'name', 'Luhrs', 'data'),
(NULL, 60, 'pjManufacturer', 3, 'name', 'Luhrs', 'data'),
(NULL, 61, 'pjManufacturer', 1, 'name', 'Mainship', 'data'),
(NULL, 61, 'pjManufacturer', 2, 'name', 'Mainship', 'data'),
(NULL, 61, 'pjManufacturer', 3, 'name', 'Mainship', 'data'),
(NULL, 62, 'pjManufacturer', 1, 'name', 'Mako', 'data'),
(NULL, 62, 'pjManufacturer', 2, 'name', 'Mako', 'data'),
(NULL, 62, 'pjManufacturer', 3, 'name', 'Mako', 'data'),
(NULL, 63, 'pjManufacturer', 1, 'name', 'Maxum', 'data'),
(NULL, 63, 'pjManufacturer', 2, 'name', 'Maxum', 'data'),
(NULL, 63, 'pjManufacturer', 3, 'name', 'Maxum', 'data'),
(NULL, 64, 'pjManufacturer', 1, 'name', 'Meridian', 'data'),
(NULL, 64, 'pjManufacturer', 2, 'name', 'Meridian', 'data'),
(NULL, 64, 'pjManufacturer', 3, 'name', 'Meridian', 'data'),
(NULL, 65, 'pjManufacturer', 1, 'name', 'Monterey', 'data'),
(NULL, 65, 'pjManufacturer', 2, 'name', 'Monterey', 'data'),
(NULL, 65, 'pjManufacturer', 3, 'name', 'Monterey', 'data'),
(NULL, 66, 'pjManufacturer', 1, 'name', 'Moody', 'data'),
(NULL, 66, 'pjManufacturer', 2, 'name', 'Moody', 'data'),
(NULL, 66, 'pjManufacturer', 3, 'name', 'Moody', 'data'),
(NULL, 67, 'pjManufacturer', 1, 'name', 'Morgan', 'data'),
(NULL, 67, 'pjManufacturer', 2, 'name', 'Morgan', 'data'),
(NULL, 67, 'pjManufacturer', 3, 'name', 'Morgan', 'data'),
(NULL, 68, 'pjManufacturer', 1, 'name', 'Nautor', 'data'),
(NULL, 68, 'pjManufacturer', 2, 'name', 'Nautor', 'data'),
(NULL, 68, 'pjManufacturer', 3, 'name', 'Nautor', 'data'),
(NULL, 69, 'pjManufacturer', 1, 'name', 'Ocean', 'data'),
(NULL, 69, 'pjManufacturer', 2, 'name', 'Ocean', 'data'),
(NULL, 69, 'pjManufacturer', 3, 'name', 'Ocean', 'data'),
(NULL, 70, 'pjManufacturer', 1, 'name', 'Ocean Alexander', 'data'),
(NULL, 70, 'pjManufacturer', 2, 'name', 'Ocean Alexander', 'data'),
(NULL, 70, 'pjManufacturer', 3, 'name', 'Ocean Alexander', 'data'),
(NULL, 71, 'pjManufacturer', 1, 'name', 'Pearson', 'data'),
(NULL, 71, 'pjManufacturer', 2, 'name', 'Pearson', 'data'),
(NULL, 71, 'pjManufacturer', 3, 'name', 'Pearson', 'data'),
(NULL, 72, 'pjManufacturer', 1, 'name', 'Pershing', 'data'),
(NULL, 72, 'pjManufacturer', 2, 'name', 'Pershing', 'data'),
(NULL, 72, 'pjManufacturer', 3, 'name', 'Pershing', 'data'),
(NULL, 73, 'pjManufacturer', 1, 'name', 'Princess', 'data'),
(NULL, 73, 'pjManufacturer', 2, 'name', 'Princess', 'data'),
(NULL, 73, 'pjManufacturer', 3, 'name', 'Princess', 'data'),
(NULL, 74, 'pjManufacturer', 1, 'name', 'Pro Line', 'data'),
(NULL, 74, 'pjManufacturer', 2, 'name', 'Pro Line', 'data'),
(NULL, 74, 'pjManufacturer', 3, 'name', 'Pro Line', 'data'),
(NULL, 75, 'pjManufacturer', 1, 'name', 'Pro-line', 'data'),
(NULL, 75, 'pjManufacturer', 2, 'name', 'Pro-line', 'data'),
(NULL, 75, 'pjManufacturer', 3, 'name', 'Pro-line', 'data'),
(NULL, 76, 'pjManufacturer', 1, 'name', 'Pursuit', 'data'),
(NULL, 76, 'pjManufacturer', 2, 'name', 'Pursuit', 'data'),
(NULL, 76, 'pjManufacturer', 3, 'name', 'Pursuit', 'data'),
(NULL, 77, 'pjManufacturer', 1, 'name', 'Rampage', 'data'),
(NULL, 77, 'pjManufacturer', 2, 'name', 'Rampage', 'data'),
(NULL, 77, 'pjManufacturer', 3, 'name', 'Rampage', 'data'),
(NULL, 78, 'pjManufacturer', 1, 'name', 'Regal', 'data'),
(NULL, 78, 'pjManufacturer', 2, 'name', 'Regal', 'data'),
(NULL, 78, 'pjManufacturer', 3, 'name', 'Regal', 'data'),
(NULL, 79, 'pjManufacturer', 1, 'name', 'Regulator', 'data'),
(NULL, 79, 'pjManufacturer', 2, 'name', 'Regulator', 'data'),
(NULL, 79, 'pjManufacturer', 3, 'name', 'Regulator', 'data'),
(NULL, 80, 'pjManufacturer', 1, 'name', 'Rinker', 'data'),
(NULL, 80, 'pjManufacturer', 2, 'name', 'Rinker', 'data'),
(NULL, 80, 'pjManufacturer', 3, 'name', 'Rinker', 'data'),
(NULL, 81, 'pjManufacturer', 1, 'name', 'Riva', 'data'),
(NULL, 81, 'pjManufacturer', 2, 'name', 'Riva', 'data'),
(NULL, 81, 'pjManufacturer', 3, 'name', 'Riva', 'data'),
(NULL, 82, 'pjManufacturer', 1, 'name', 'Riviera', 'data'),
(NULL, 82, 'pjManufacturer', 2, 'name', 'Riviera', 'data'),
(NULL, 82, 'pjManufacturer', 3, 'name', 'Riviera', 'data'),
(NULL, 83, 'pjManufacturer', 1, 'name', 'Rodman', 'data'),
(NULL, 83, 'pjManufacturer', 2, 'name', 'Rodman', 'data'),
(NULL, 83, 'pjManufacturer', 3, 'name', 'Rodman', 'data'),
(NULL, 84, 'pjManufacturer', 1, 'name', 'Sabre', 'data'),
(NULL, 84, 'pjManufacturer', 2, 'name', 'Sabre', 'data'),
(NULL, 84, 'pjManufacturer', 3, 'name', 'Sabre', 'data'),
(NULL, 85, 'pjManufacturer', 1, 'name', 'San Lorenzo', 'data'),
(NULL, 85, 'pjManufacturer', 2, 'name', 'San Lorenzo', 'data'),
(NULL, 85, 'pjManufacturer', 3, 'name', 'San Lorenzo', 'data'),
(NULL, 86, 'pjManufacturer', 1, 'name', 'Sea Ray', 'data'),
(NULL, 86, 'pjManufacturer', 2, 'name', 'Sea Ray', 'data'),
(NULL, 86, 'pjManufacturer', 3, 'name', 'Sea Ray', 'data'),
(NULL, 87, 'pjManufacturer', 1, 'name', 'Sealine', 'data'),
(NULL, 87, 'pjManufacturer', 2, 'name', 'Sealine', 'data'),
(NULL, 87, 'pjManufacturer', 3, 'name', 'Sealine', 'data'),
(NULL, 88, 'pjManufacturer', 1, 'name', 'Seaswirl', 'data'),
(NULL, 88, 'pjManufacturer', 2, 'name', 'Seaswirl', 'data'),
(NULL, 88, 'pjManufacturer', 3, 'name', 'Seaswirl', 'data'),
(NULL, 89, 'pjManufacturer', 1, 'name', 'Silverton', 'data'),
(NULL, 89, 'pjManufacturer', 2, 'name', 'Silverton', 'data'),
(NULL, 89, 'pjManufacturer', 3, 'name', 'Silverton', 'data'),
(NULL, 90, 'pjManufacturer', 1, 'name', 'Sunseeker', 'data'),
(NULL, 90, 'pjManufacturer', 2, 'name', 'Sunseeker', 'data'),
(NULL, 90, 'pjManufacturer', 3, 'name', 'Sunseeker', 'data'),
(NULL, 91, 'pjManufacturer', 1, 'name', 'Tiara', 'data'),
(NULL, 91, 'pjManufacturer', 2, 'name', 'Tiara', 'data'),
(NULL, 91, 'pjManufacturer', 3, 'name', 'Tiara', 'data'),
(NULL, 92, 'pjManufacturer', 1, 'name', 'Tollycraft', 'data'),
(NULL, 92, 'pjManufacturer', 2, 'name', 'Tollycraft', 'data'),
(NULL, 92, 'pjManufacturer', 3, 'name', 'Tollycraft', 'data'),
(NULL, 93, 'pjManufacturer', 1, 'name', 'Trojan', 'data'),
(NULL, 93, 'pjManufacturer', 2, 'name', 'Trojan', 'data'),
(NULL, 93, 'pjManufacturer', 3, 'name', 'Trojan', 'data'),
(NULL, 94, 'pjManufacturer', 1, 'name', 'Trophy', 'data'),
(NULL, 94, 'pjManufacturer', 2, 'name', 'Trophy', 'data'),
(NULL, 94, 'pjManufacturer', 3, 'name', 'Trophy', 'data'),
(NULL, 95, 'pjManufacturer', 1, 'name', 'Uniflite', 'data'),
(NULL, 95, 'pjManufacturer', 2, 'name', 'Uniflite', 'data'),
(NULL, 95, 'pjManufacturer', 3, 'name', 'Uniflite', 'data'),
(NULL, 96, 'pjManufacturer', 1, 'name', 'Viking', 'data'),
(NULL, 96, 'pjManufacturer', 2, 'name', 'Viking', 'data'),
(NULL, 96, 'pjManufacturer', 3, 'name', 'Viking', 'data'),
(NULL, 97, 'pjManufacturer', 1, 'name', 'Wellcraft', 'data'),
(NULL, 97, 'pjManufacturer', 2, 'name', 'Wellcraft', 'data'),
(NULL, 97, 'pjManufacturer', 3, 'name', 'Wellcraft', 'data'),
(NULL, 98, 'pjManufacturer', 1, 'name', 'Westerly', 'data'),
(NULL, 98, 'pjManufacturer', 2, 'name', 'Westerly', 'data'),
(NULL, 98, 'pjManufacturer', 3, 'name', 'Westerly', 'data'),
(NULL, 99, 'pjManufacturer', 1, 'name', 'Windy', 'data'),
(NULL, 99, 'pjManufacturer', 2, 'name', 'Windy', 'data'),
(NULL, 99, 'pjManufacturer', 3, 'name', 'Windy', 'data'),
(NULL, 100, 'pjManufacturer', 1, 'name', 'X-yachts', 'data'),
(NULL, 100, 'pjManufacturer', 2, 'name', 'X-yachts', 'data'),
(NULL, 100, 'pjManufacturer', 3, 'name', 'X-yachts', 'data');

INSERT INTO `yachtlisting_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_length', 1, 'ft|m::m', 'Feet|Meter', 'enum', 2, 1, NULL),
(1, 'o_fuel', 1, 'gal|l::l', 'Gallon|Liter', 'enum', 3, 1, NULL),
(1, 'o_speed', 1, 'km/h|mph::km/h', 'km/h|mph', 'enum', 3, 1, NULL),
(1, 'o_power', 1, 'hp|kw::hp', 'hp|kw', 'enum', 4, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 4, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 5, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 6, 1, NULL),
(1, 'o_items_per_page', 1, '10', NULL, 'int', 7, 1, NULL),
(1, 'o_layout', 1, 'layout1|layout2|layout3::layout1', 'Layout 1|Layout 2|Layout 3', 'enum', 8, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 12, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 13, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 15, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 16, 1, NULL),

(1, 'o_allow_add_listing', 2, 'Yes|No::Yes', NULL, 'enum', 1, 1, NULL),
(1, 'o_owner_is_active', 2, 'Yes|No::No', NULL, 'enum', 2, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 3, 1, NULL),

(1, 'o_currency', 3, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 3, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 3, '0.00', NULL, 'int', 3, 1, NULL),
(1, 'o_booking_status', 3, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 3, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thank_you_page', 3, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 3, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_owner_paypal_address', 3, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 3, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 3, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 3, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 3, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 3, 'Yes|No::Yes', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 3, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 4, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 4, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 4, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 4, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_sms_confirmation_message', 4, '', NULL, 'text', 10, 1, NULL),

(1, 'o_owner_email_confirmation', 5, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_owner_email_confirmation_subject', 5, '', NULL, 'string', 8, 1, NULL),
(1, 'o_owner_email_confirmation_message', 5, '', NULL, 'text', 9, 1, NULL),
(1, 'o_owner_email_payment', 5, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_owner_email_payment_subject', 5, '', NULL, 'string', 11, 1, NULL),
(1, 'o_owner_email_payment_message', 5, '', NULL, 'text', 12, 1, NULL),
(1, 'o_owner_email_cancel', 5, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_owner_email_cancel_subject', 5, '', NULL, 'string', 14, 1, NULL),
(1, 'o_owner_email_cancel_message', 5, '', NULL, 'text', 15, 1, NULL),

(1, 'o_owner_sms_confirmation_message', 5, '', NULL, 'text', 16, 1, NULL),
(1, 'o_owner_sms_payment_message', 5, '', NULL, 'text', 17, 1, NULL),

(1, 'o_email_registration', 6, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_registration_subject', 6, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_registration_message', 6, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_submission', 6, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_email_submission_subject', 6, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_submission_message', 6, '', NULL, 'text', 9, 1, NULL),
(1, 'o_email_forgot_subject', 6, '', NULL, 'string', 11, 1, NULL),
(1, 'o_email_forgot_message', 6, '', NULL, 'text', 12, 1, NULL),
(1, 'o_sms_registration', 6, '0|1::1', 'No|Yes', 'enum', 15, 1, NULL),
(1, 'o_sms_registration_message', 6, '', NULL, 'text', 16, 1, NULL),
(1, 'o_sms_submission', 6, '0|1::1', 'No|Yes', 'enum', 17, 1, NULL),
(1, 'o_sms_submission_message', 6, '', NULL, 'text', 18, 1, NULL),

(1, 'o_admin_email_registration', 7, '0|1::1', 'No|Yes', 'enum', 5, 1, NULL),
(1, 'o_admin_email_registration_subject', 7, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_registration_message', 7, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_submission', 7, '0|1::1', 'No|Yes', 'enum', 8, 1, NULL),
(1, 'o_admin_email_submission_subject', 7, '', NULL, 'string', 9, 1, NULL),
(1, 'o_admin_email_submission_message', 7, '', NULL, 'text', 10, 1, NULL),
(1, 'o_admin_sms_registration', 7, '0|1::1', 'No|Yes', 'enum', 13, 1, NULL),
(1, 'o_admin_sms_registration_message', 7, '', NULL, 'text', 14, 1, NULL),
(1, 'o_admin_sms_submission', 7, '0|1::1', 'No|Yes', 'enum', 15, 1, NULL),
(1, 'o_admin_sms_submission_message', 7, '', NULL, 'text', 16, 1, NULL),

(1, 'o_bf_include_title', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 8, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 8, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 8, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 8, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 8, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),

(1, 'o_listing_page', 99, '', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `yachtlisting_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');