<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminOptions extends pjAdmin
{
	public function pjActionGetOptions()
	{
		$pjOptionModel = pjOptionModel::factory();
		$pjOptionModel->where('t1.foreign_id', $this->getForeignId());
		if($this->getForeignId() > 1 && $this->isAdmin())
		{
			$_arr = array();
			foreach($pjOptionModel->defaultOpts as $v)
			{
				$_arr[] = "'" . $v . "'";
			}
			$pjOptionModel->orWhere("(t1.foreign_id = '1' AND t1.`key` IN (".join(",", $_arr)."))");
		}
		$arr = $pjOptionModel
			->orderBy('t1.order ASC')
			->findAll()
			->getData();
		return $arr;
	} 
	
	public function pjActionIndex()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$this->set('arr', $this->pjActionGetOptions());
			
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSubmissions()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$OptionModel = new pjOptionModel();
			$this->set('arr', $this->pjActionGetOptions());
			$this->set('o_arr', $OptionModel->getPairs($this->getForeignId()));
			$this->set('period_arr', pjPeriodModel::factory()->orderBy('t1.days ASC')->findAll()->getData());
				
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionBooking()
	{
		$this->checkLogin();
	
		if ($this->isAdmin() || $this->isOwner())
		{
			$arr = $this->pjActionGetOptions();
			if(empty($arr))
			{
				$pjOptionModel = pjOptionModel::factory();
				
				$pjOptionModel->removeOptions($this->getUserId());
				$pjOptionModel->init($this->getUserId());
				pjMultiLangModel::factory()->where('model', 'pjOption')->where('foreign_id', $this->getUserId())->eraseAll();
				$pjOptionModel->initMultiLang($this->getUserId(), 3);
			}
			$arr = $this->pjActionGetOptions();
			$this->set('arr', $arr);
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionNotification()
	{
		$this->checkLogin();
	
		if ($this->isAdmin() || $this->isOwner())
		{
			$arr = $this->pjActionGetOptions();
			
			$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getUserId(), 'pjOption');
			
			$this->set('arr', $arr);
			
			pjObject::import('Model', array('pjLocale:pjLocale', 'pjLocale:pjLocaleLanguage'));
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$lp_arr = array();
			foreach ($locale_arr as $item)
			{
				$lp_arr[$item['id']."_"] = $item['file'];
			}
			$this->set('lp_arr', $locale_arr);
			$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
			
			$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionBookingForm()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$this->set('arr', $this->pjActionGetOptions());
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isOwner())
		{
			if (isset($_POST['options_update']))
			{
				$OptionModel = new pjOptionModel();
				
				$user_id = $this->getUserId();
				if(isset($_POST['user_id']) && (int) $_POST['user_id'] > 0)
				{
					$user_id = (int) $_POST['user_id'];
				}
				if($this->getRoleId() == 1)
				{
					$user_id = 1;
				}
				foreach ($_POST as $key => $value)
				{
					if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
					{
						list(, , $k) = explode("-", $key);
						if (!empty($k))
						{
							if(in_array($k, $OptionModel->defaultOpts))
							{
								$OptionModel
									->reset()
									->where('foreign_id', 1)
									->where('`key`', $k)
									->limit(1)
									->modifyAll(array('value' => $value));
							}else{
								$OptionModel
									->reset()
									->where('foreign_id', $user_id)
									->where('`key`', $k)
									->limit(1)
									->modifyAll(array('value' => $value));
							}
						}
					}
				}
				
				if (isset($_POST['price']) && count($_POST['price']) > 0 && isset($_POST['days']) && count($_POST['days']) > 0)
				{
					$pjPeriodModel = pjPeriodModel::factory();
					foreach ($_POST['price'] as $key => $value)
					{
						if (strpos($key, 'new_') === 0)
						{
							$pjPeriodModel->reset()->setAttributes(array('days' => $_POST['days'][$key], 'price' => $_POST['price'][$key]))->insert();
						} else {
							$pjPeriodModel->reset()->setAttributes(array('id' => $key))->modify(array('days' => $_POST['days'][$key], 'price' => $_POST['price'][$key]));
						}
					}
				}
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $user_id, 'pjOption', 'data');
				}
				
				if (isset($_POST['next_action']))
				{
					switch ($_POST['next_action'])
					{
						case 'pjActionIndex':
							$err = 'AO01';
							break;
						case 'pjActionNotification':
							$err = 'AO02&tab_id=' . $_POST['tab_id'];
							break;
						case 'pjActionSubmissions':
							$err = 'AO03';
							break;
						case 'pjActionBooking':
							$err = 'AO04';
							break;
						case 'pjActionBookingForm':
							$err = 'AO05';
							break;
						case 'pjActionInstall':
							$err = 'AO06';
							break;
					}
				}
				if(isset($_POST['next_controller']))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=".@$_POST['next_controller']."&action=" . @$_POST['next_action'] . "&id=" . @$_POST['user_id'] . "&err=$err");
				}else{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOptions&action=" . @$_POST['next_action'] . "&err=$err");
				}
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionInstall()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$this->set('o_arr', $this->pjActionGetOptions());
				
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
	
			$lp_arr = array();
			foreach ($locale_arr as $item)
			{
				$lp_arr[$item['id']."_"] = $item['file'];
			}
			$this->set('lp_arr', $locale_arr);
			$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
	
			$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeletePeriod()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array('code' => 100);
			if (isset($_POST['id']) && (int) $_POST['id'] > 0)
			{
				$response['code'] = 101;
				if (pjPeriodModel::factory()->setAttributes(array('id' => $_POST['id']))->erase()->getAffectedRows() == 1)
				{
					$response['code'] = 200;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionPreview()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdateTheme()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjOptionModel::factory()
				->where('foreign_id', $this->getForeignId())
				->where('`key`', 'o_theme')
				->limit(1)
				->modifyAll(array('value' => 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme' . $_GET['theme']));
	
		}
	}
}
?>