<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjWebsite extends pjListings
{
	protected $locales = array();
	
	public function __construct()
	{
		$this->setLayout('pjActionWebsite');
	}
	
	public function afterFilter()
	{
		$theme = $this->getTheme();
		if($theme == false)
		{
			$theme = $this->option_arr['o_theme'];
		}
		
		$this->appendCss('bootstrap.min.css', PJ_THIRD_PARTY_PATH . 'bootstrap/css/');
		$this->appendCss('https://fonts.googleapis.com/css?family=Fira+Sans:400,500,700,300', '', true);
		$this->appendCss('flexslider.css',PJ_TEMPLATE_PATH . PJ_TEMPLATE_WEBSITE_PATH . 'css/');
		$this->appendCss('jquery-ui-1.9.2.custom.min.css', PJ_THIRD_PARTY_PATH . 'jquery_ui/css/');
		$this->appendCss('style.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_WEBSITE_PATH . 'css/');
		$this->appendCss($theme . '.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_WEBSITE_PATH . 'css/themes/');
	}
	
	public function pjActionIndex()
	{
		$pjListingModel = pjListingModel::factory();
		
		$manufacturer_arr = pjManufacturerModel::factory()
			->select('t1.*, t2.content AS name')
			->join('pjMultiLang', "t2.model='pjManufacturer' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left')
			->where('status', 'T')
			->where("t1.id IN (SELECT TL.manufacturer_id FROM `".pjListingModel::factory()->getTable()."` AS TL)")
			->orderBy('name ASC')
			->findAll()
			->getData();
	
		$this->set('manufacturer_arr', pjSanitize::clean($manufacturer_arr));
		
		$model_arr = $pjListingModel
			->select("DISTINCT t1.listing_model")
			->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left')
			->where("(t1.status = 'T' OR (t1.status = 'E' AND t1.expire >= CURDATE()))")
			->where("(t2.content IS NOT NULL)")
			->orderBy("t1.listing_model ASC")
			->findAll()
			->getData();
		$this->set('model_arr', pjSanitize::clean($model_arr));
		
		$this->set('meta_arr', array(
			'title' => __('ws_home_meta_title', true),
			'keywords' => __('ws_home_meta_keywords', true),
			'description' => __('ws_home_meta_description', true),
		));
		
		$this->set('sale_feature_arr', $this->getFeaturedYachts($this->option_arr, $this->getLocaleId(), 'sale'));
		$this->set('rent_feature_arr', $this->getFeaturedYachts($this->option_arr, $this->getLocaleId(), 'rent'));
		
		$this->appendCss('index.php?controller=pjNewsletter&action=pjActionLoadCss', PJ_INSTALL_URL, true);
	}

	public function pjActionServices(){
		$this->set('meta_arr', array(
				'title' => __('ws_service_meta_title', true),
				'keywords' => __('ws_service_meta_keywords', true),
				'description' => __('ws_service_meta_description', true),
		));
	}
	
    public function pjActionAboutUs(){
    	$this->set('meta_arr', array(
    		'title' => __('ws_about_meta_title', true),
    		'keywords' => __('ws_about_meta_keywords', true),
    		'description' => __('ws_about_meta_description', true),
    	));
    }

    public function pjActionContactUs(){
    	$this->set('meta_arr', array(
    		'title' => __('ws_contact_meta_title', true),
    		'keywords' => __('ws_contact_meta_keywords', true),
    		'description' => __('ws_contact_meta_description', true),
    	));
    	
    	$this->appendCss('index.php?controller=pjForm&action=pjActionLoadCss&fid=1', PJ_INSTALL_URL, true);
    	$this->appendJs('index.php?controller=pjForm&action=pjActionLoadJs&fid=1', PJ_INSTALL_URL, true);
    }
    
    public function pjActionTerms(){
    	$this->set('meta_arr', array(
    		'title' => __('ws_terms_meta_title', true),
    		'keywords' => __('ws_terms_meta_keywords', true),
    		'description' => __('ws_terms_meta_description', true),
    	));
    }
}
?>