<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjPriceModel extends pjAppModel
{
	protected $primaryKey = null;
	
	protected $table = 'prices';
	
	protected $schema = array(
		array('name' => 'listing_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'start_date', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'price', 'type' => 'decimal', 'default' => ':NULL')
	);
	
	public static function factory($attr=array())
	{
		return new pjPriceModel($attr);
	}
	
	public function getPrices($listing_id, $year)
	{
		$arr = $this
			->reset()
			->where('listing_id', $listing_id)
			->where("DATE_FORMAT(t1.start_date,'%Y')", $year)
			->orderBy("start_date ASC")
			->findAll()
			->getDataPair("start_date", "price");
		return $arr;
	}
	
	public function getPricesByMonth($listing_id, $month)
	{
		$arr = $this
			->reset()
			->where('listing_id', $listing_id)
			->where("DATE_FORMAT(t1.start_date,'%Y-%m')", $month)
			->orderBy("start_date ASC")
			->findAll()
			->getDataPair("start_date", "price");
		return $arr;
	}
}
?>