<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	$types = __('types', true, false);
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat yachts">
				<div class="info">
					<abbr><?php echo $tpl['cnt_yachts_for_sale'];?></abbr>
					<?php $tpl['cnt_yachts_for_sale'] != 1 ? __('lblYachtsForSale') : __('lblYachtForSale');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat yachts">
				<div class="info">
					<abbr><?php echo $tpl['cnt_yachts_for_rent'];?></abbr>
					<?php $tpl['cnt_yachts_for_rent'] != 1 ? __('lblYachtsForRent') : __('lblYachtForRent');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat bookings">
				<div class="info">
					<abbr><?php echo $tpl['cnt_reservations'];?></abbr>
					<?php $tpl['cnt_reservations'] != 1 ? __('lblRentalReservations') : __('lblRentalReservation');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblMostPopular');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionIndex&amp;for=sale"><?php __('lblViewAll'); ?></a>)</div>
			<div class="dashboard_column_top"><?php __('lblMostPopular');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionIndex&amp;for=rent"><?php __('lblViewAll'); ?></a>)</div>
			<div class="dashboard_column_top"><?php __('lblLatestReservations');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex"><?php __('lblViewAll'); ?></a>)</div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['sale_arr']))
					{
						foreach($tpl['sale_arr'] as $k => $v)
						{ 
							$_arr = array();
							if(!empty($v['manufacturer']))
							{
								$_arr[] = pjSanitize::html($v['manufacturer']);
							}
							if(!empty($v['listing_model']))
							{
								$_arr[] = pjSanitize::html($v['listing_model']);
							}
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></a></label>
								<label><?php __('lblRefId');?>: <span><?php echo pjSanitize::html($v['listing_refid']);?></span></label>
								<label><span><?php echo join(' / ', $_arr);?></span></label>
								<label><?php __('lblPrice');?>: <span><?php echo !empty($v['listing_price']) ? pjUtil::formatCurrencySign(number_format($v['listing_price'], 0), $tpl['option_arr']['o_currency']) : null;?></span></label>
								<label><?php __('lblViews');?>: <span><?php echo pjSanitize::html($v['views']);?></span></label>
								<label><?php __('lblAddedOn');?>: <span><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created']))?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['created']))?></span></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><?php __('lblYachtsNotFound');?></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['rent_arr']))
					{
						foreach($tpl['rent_arr'] as $k => $v)
						{ 
							$_arr = array();
							if(!empty($v['manufacturer']))
							{
								$_arr[] = pjSanitize::html($v['manufacturer']);
							}
							if(!empty($v['listing_model']))
							{
								$_arr[] = pjSanitize::html($v['listing_model']);
							}
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></a></label>
								<label><?php __('lblRefId');?>: <span><?php echo pjSanitize::html($v['listing_refid']);?></span></label>
								<label><span><?php echo join(' / ', $_arr);?></span></label>
								<label><?php __('lblViews');?>: <span><?php echo pjSanitize::html($v['views']);?></span></label>
								<label><?php __('lblReservations');?>: <span><?php echo $v['cnt_reservations'];?></span></label>
								<label><?php __('lblAddedOn');?>: <span><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created']))?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['created']))?></span></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><?php __('lblYachtsNotFound');?></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['reservation_arr']))
					{
						foreach($tpl['reservation_arr'] as $k => $v)
						{ 
							?>
							<div class="dashboard_row">
								<label><?php __('lblReservationID');?>: <span><?php echo pjSanitize::html($v['uuid']);?></span></label>
								<label><span><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['c_name']);?></a></span></label>
								<label><span><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate&amp;id=<?php echo $v['listing_id'];?>"><?php echo pjSanitize::html($v['title']);?> / <?php echo pjSanitize::html($v['listing_refid']);?></a></span></label>
								<label><span><?php echo __('lblWeek') . ' ' . date('W', strtotime($v['week_start'])) . ' ' . date($tpl['option_arr']['o_date_format'], strtotime($v['week_start'])) . ' - ' . date($tpl['option_arr']['o_date_format'], strtotime($v['week_start']) + 6 * 60 * 60 * 24);?></span></label>
								<label><?php __('lblTotalPrice');?>: <span><?php echo pjUtil::formatCurrencySign(number_format($v['total'], 0), $tpl['option_arr']['o_currency'])?></span></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><?php __('lblReservationsNotFound');?></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format']); ?></div>
		</div>
	</div>
	<?php
}
?>