<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	pjUtil::printNotice(__('infoListingAddTitle', true), __('infoListingAddDesc', true)); 
	?>		
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionCreate" method="post" id="frmCreateListing" class="form pj-form">
		<input type="hidden" name="listing_create" value="1" />
		<p>
			<label class="title"><?php __('lblType'); ?></label>
			<span class="inline_block">
				<select name="for" id="for" class="pj-form-field required">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach (__('listing_for', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblRefId'); ?></label>
			<span class="inline_block">
				<input type="text" name="listing_refid" id="listing_refid" value="<?php echo $tpl['listing_refid']; ?>" class="pj-form-field required" />
				<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblRefIdTip'); ?>"></a>
			</span>
		</p>
		<?php
		if(!empty($tpl['manufacturer_arr']))
		{ 
			?>
			<p>
				<label class="title"><?php __('lblManufacturer'); ?></label>
				<span class="inline_block">
					<select name="manufacturer_id" id="manufacturer_id" class="pj-form-field w200 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['manufacturer_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<?php
		}else{
			$add_type_message = __('lblAddManufacturer', true);
			$add_type_message = str_replace('{ADD_MANU_TAG}', '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminManufacturers&amp;action=pjActionCreate">', $add_type_message);
			$add_type_message = str_replace('{ADD_MANU_ENDTAG}', '</a>', $add_type_message);
			?>
			<p>
				<label class="title"><?php __('lblManufacturer'); ?></label>
				<span class="inline_block">
					<label class="content"><?php echo $add_type_message;?></label>
				</span>
			</p>
			<?php
		}
		?>
		<p>
			<label class="title"><?php __('lblModel'); ?></label>
			<span class="inline_block">
				<input type="text" name="listing_model" id="listing_model" class="pj-form-field" />
			</span>
		</p>
		<?php
		if (!$controller->isOwner())
		{
			?>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field w200 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						$publish_statuses = __('publish_statuses', true);
						?>
						<option value="T"><?php echo stripslashes($publish_statuses['T']); ?></option>
						<option value="F"><?php echo stripslashes($publish_statuses['F']); ?></option>
						<option value="E"><?php echo stripslashes($publish_statuses['E']); ?></option>
					</select>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::html(__('lblStatusTip', true)); ?>"></a>
				</span>
			</p>
			<p id="expiration_container" style="display:none;">
				<label class="title"><?php __('lblExpire'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="expire" id="expire" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo date($tpl['option_arr']['o_date_format']); ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblExpireTip'); ?>"></a>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblMakeFeatured'); ?></label>
				<span class="left">
					<?php
					foreach (__('_yesno', true) as $k => $v)
					{
						?>
						<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo 'F' == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
						<?php
					}
					if(PJ_IS_WEBSITE == true)
					{
						?>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::clean(__('lblWebsiteFeaturedTip', true)); ?>"></a>
						<?php
					}else{
						?>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::clean(__('lblFeaturedTip', true)); ?>"></a>
						<?php
					} 
					?>
				</span>
			</p>
			<?php
		}
		?>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
		</p>
	</form>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	</script>
	<?php
}
?>