<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	?>
	<style type="text/css">
	/*.ui-widget-content{
		border: medium none;
	}
	.ui-tabs .ui-tabs-nav li a {
		padding: 0.5em 0.8em;
	}*/
	.mceEditor > table{
		width: 570px !important;
	}
	.ui-menu{
		height: 230px;
		overflow-y: scroll;
	}
	.ui-tabs .ui-tabs-panel{
		overflow: visible;
	}
	</style>

	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate" method="post" id="frmUpdateListing" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="listing_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />

		<div class="listing-title bold b10">
			<?php
			$title_arr = array();
			$title_arr[] =  $tpl['arr']['listing_refid'];
			if(!empty($tpl['arr']['i18n'][$locale]['title']))
			{
				$title_arr[] = $tpl['arr']['i18n'][$locale]['title'];
			}
			echo __('lblYacht', true) . ': ' . join(', ', $title_arr);
			?>
		</div>

		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabSummary'); ?></a></li>
				<li><a href="#tabs-2"><?php __('tabDetails'); ?></a></li>
				<li><a href="#tabs-3"><?php __('tabDescription'); ?></a></li>
				<li><a href="#tabs-4"><?php __('tabExtras'); ?></a></li>
				<li><a href="#tabs-5"><?php __('tabPhotos'); ?></a></li>
				<?php
				if($tpl['arr']['for'] == 'rent')
				{ 
					?><li><a href="#tabs-6"><?php __('tabPrices'); ?></a></li><?php
				} 
				?>
				<li><a href="#tabs-<?php echo $tpl['arr']['for'] == 'rent' ? 7 : 6;?>"><?php __('tabOwner'); ?></a></li>
				<li><a href="#tabs-<?php echo $tpl['arr']['for'] == 'rent' ? 8 : 7;?>"><?php __('tabAddress'); ?></a></li>
				<li><a href="#tabs-<?php echo $tpl['arr']['for'] == 'rent' ? 9 : 8?>"><?php __('tabSeo'); ?></a></li>
			</ul>
		
			<div id="tabs-1">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoSummaryTitle', true), __('infoSummaryDesc', true));
				}else{
					pjUtil::printNotice(__('infoSummaryTitle', true), __('infoSummaryDesc', true));
				} 
				?>	
				<p><label class="title"><?php __('lblAddedOn'); ?></label><span class="left"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></span></p>
				<p><label class="title"><?php __('lblLastUpdateOn'); ?></label><span class="left"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['modified'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['modified'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></span></p>
				<p><label class="title"><?php __('lblViews'); ?></label><span class="left"><?php echo $tpl['arr']['views']; ?></span></p>
				<p>
					<label class="title"><?php __('lblType'); ?></label>
					<span class="inline_block">
						<select name="for" id="for" class="pj-form-field required">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach (__('listing_for', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k==$tpl['arr']['for'] ? ' selected="selected"' : null;?>><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblRefId'); ?></label>
					<span class="inline_block">
						<input type="text" name="listing_refid" id="listing_refid" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_refid'])); ?>" class="pj-form-field required" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblManufacturer'); ?></label>
					<span class="inline_block">
						<select name="manufacturer_id" id="manufacturer_id" class="pj-form-field w200 required">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['manufacturer_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo $v['id']==$tpl['arr']['manufacturer_id'] ? ' selected="selected"' : null;?>><?php echo stripslashes($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblModel'); ?></label>
					<span class="inline_block">
						<input type="text" name="listing_model" id="listing_model" class="pj-form-field" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_model'])); ?>" />
					</span>
				</p>
				<?php
				if (!$controller->isOwner())
				{
					?>
					<p><label class="title"><?php __('lblStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field required">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								$publish_statuses = __('publish_statuses', true);
								?>
								<option value="T"<?php echo $tpl['arr']['status'] == 'T' ? 'selected="selected"' : null;?>><?php echo stripslashes($publish_statuses['T']); ?></option>
								<option value="F"<?php echo $tpl['arr']['status'] == 'F' ? 'selected="selected"' : null;?>><?php echo stripslashes($publish_statuses['F']); ?></option>
								<option value="E"<?php echo $tpl['arr']['status'] == 'E' ? 'selected="selected"' : null;?>><?php echo stripslashes($publish_statuses['E']); ?></option>
							</select>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::html(__('lblStatusTip', true)); ?>"></a>
						</span>
					</p>
					<p id="expiration_container" style="display:<?php echo $tpl['arr']['status'] == 'E' ? 'block' : 'none'; ?>;">
						<label class="title"><?php __('lblExpire'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="expire" id="expire" class="pj-form-field pointer w80 required datepick" value="<?php echo pjUtil::formatDate($tpl['arr']['expire'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblExpireTip'); ?>"></a>
					</p>
					<p>
						<label class="title"><?php __('lblMakeFeatured'); ?></label>
						<span class="left">
						<?php
						foreach (__('_yesno', true) as $k => $v)
						{
							?>
							<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo $tpl['arr']['is_featured'] == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
							<?php
						}
						if(PJ_IS_WEBSITE == true)
						{
							?>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::clean(__('lblWebsiteFeaturedTip', true)); ?>"></a>
							<?php
						}else{
							?>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::clean(__('lblFeaturedTip', true)); ?>"></a>
							<?php
						}
						?>
						</span>
					</p>
					<?php
				} else {
					?>
					<p>
						<?php
						if($tpl['arr']['status'] == 'F')
						{
							?>
							<label class="title color-red"><?php __('lblExpire'); ?></label>
							<span class="left float_left"><?php __('lblNotActive'); ?></span>
							<a class="pj-button float_left l10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionPayment&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblPublish'); ?></a>
							<?php
						}else if($tpl['arr']['status'] == 'T'){
							?>
							<label class="title"><?php __('lblExpire'); ?></label>
							<span class="left"><?php __('lblUnlimited'); ?></span>
							<?php
						}else{ 
							?>
							<label class="title"><?php __('lblExpire'); ?></label>
							<span class="left float_left"><?php echo pjUtil::formatDate($tpl['arr']['expire'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></span>
							<a class="pj-button float_left l10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionPayment&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblExtend'); ?></a>
							<?php
						}
						?>
					</p>
					<?php
				}
				?>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div>
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoDetailsTitle', true), __('infoDetailsDesc', true));?>
				<div class="multilang b10 first_multilang"></div>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblTitle'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w500<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" />
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							</span>
						</p>
						<?php
					}
					$feature_types = __('feature_types', true);
					foreach($tpl['feature_arr'] as $k => $feature_arr)
					{
						?>
						<p>
							<label class="title"><?php echo $feature_types[$k]; ?></label>
							<span class="inline_block">
								<select name="feature_<?php echo $k?>_id" id="feature_<?php echo $k?>_id" class="pj-form-field w200">
									<option value="">-- <?php __('lblChoose'); ?> --</option>
									<?php
									foreach ($feature_arr as $v)
									{
										if ($tpl['arr']['feature_'.$k.'_id'] == $v['id'])
										{
											?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo stripslashes($v['name']); ?></option><?php
										} else {
											?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
										}
									}
									?>
								</select>
							</span>
						</p>
						<?php
					}
					if($tpl['arr']['for'] == 'sale')
					{
						?>
						<p>
							<label class="title"><?php __('lblPrice'); ?></label>
							<span class="inline_block">
								<span class="pj-form-field-custom pj-form-field-custom-before float_left r10">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" name="listing_price" class="pj-form-field w90 align_right number" value="<?php echo pjSanitize::html($tpl['arr']['listing_price']);?>"/>
								</span>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<label class="title"><?php __('lblYear'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_year" id="listing_year" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_year'])); ?>" class="pj-form-field w100 digits" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblHorsePower'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_power" id="listing_power" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_power'])); ?>" class="pj-form-field w100 digits" />&nbsp;<?php echo $tpl['option_arr']['o_power'];?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblLength'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_length" id="listing_length" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_length'])); ?>" class="pj-form-field w100 number" />&nbsp;<?php echo $tpl['option_arr']['o_length'];?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblLOA'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_loa" id="listing_loa" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_loa'])); ?>" class="pj-form-field w100 digits" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblBeam'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_beam" id="listing_beam" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_beam'])); ?>" class="pj-form-field w100 number" />&nbsp;<?php echo $tpl['option_arr']['o_length'];?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblEngineHours'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_engine_hours" id="listing_engine_hours" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_engine_hours'])); ?>" class="pj-form-field w100 digits" />&nbsp;<?php __('lblHours');?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblEngineModel'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_engine_model" id="listing_engine_model" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_engine_model'])); ?>" class="pj-form-field w100" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblCruisingSpeed'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_cruising_speed" id="listing_cruising_speed" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_cruising_speed'])); ?>" class="pj-form-field w100 digits" />&nbsp;<?php echo $tpl['option_arr']['o_speed'];?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblMaxSpeed'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_max_speed" id="listing_max_speed" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_max_speed'])); ?>" class="pj-form-field w100 digits" />&nbsp;<?php echo $tpl['option_arr']['o_speed'];?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblFuelTank'); ?></label>
						<span class="inline_block">
							<input type="text" name="listing_fuel_tank" id="listing_fuel_tank" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_fuel_tank'])); ?>" class="pj-form-field w100 digits" />&nbsp;<?php echo $tpl['option_arr']['o_fuel'];?>
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
					</p>
				</div>
			</div><!-- tabs-2 -->
			<div id="tabs-3">
				<?php
				pjUtil::printNotice(__('infoDescriptionTitle', true), __('infoDescriptionDesc', true));
				?>
				<div class="multilang b10 first_multilang"></div>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblDescription'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="mceEditor<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" style="width: 570px; height: 250px"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['description']); ?></textarea>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
					</p>
				</div>
			</div><!-- tab-3 -->
			<div id="tabs-4">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoExtraTitle', true), __('infoExtraDesc', true));
				}else{
					pjUtil::printNotice(__('infoExtraTitle', true), __('infoExtraDesc', true));
				}
				$extra_types = __('extra_types', true);
				foreach($tpl['extra_arr'] as $k => $extra_arr)
				{
					?>
					<fieldset class="fieldset white">
						<legend><?php echo $extra_types[$k];?></legend>
						<?php
						$i = 1;
						$is_open = true;
						foreach ($extra_arr as $v)
						{
							$is_open = true;
							?>
							<div class="float_left w200 b5 r20 pj-checkbox gradient<?php echo in_array($v['id'], $tpl['listing_extra_id_arr']) ? ' pj-checkbox-checked' : NULL; ?>">
								<input type="checkbox"  style="vertical-align: middle" name="extra[]" id="extra_<?php echo $v['id']; ?>" value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['listing_extra_id_arr']) ? ' checked="checked"' : NULL; ?> />
								<label for="extra_<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></label>
							</div>
							<?php
							if ($i % 3 === 0)
							{
								$is_open = false;
								?><div class="clear_left"></div><?php
							}
							$i++;
							
						}
						if ($is_open) {
							?><div class="clear_left"></div><?php
						}
						?>
					</fieldset>
					<?php
				}
				?>
				<p>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div><!-- tabs-4 -->
			<div id="tabs-5">
				<?php
				pjUtil::printNotice(__('infoGalleryTitle', true), __('infoGalleryDesc', true));
				?>
				<div id="gallery"></div>
			</div><!-- tabs-5 -->
			<?php
			if($tpl['arr']['for'] == 'rent')
			{ 
				?>
				<div id="tabs-6" class="pj-loader-outer">
					<div class="pj-loader"></div>
					<?php
					pjUtil::printNotice(__('infoPricesTitle', true), __('infoPricesDesc', true));
					$from_year = date('Y');
					$year = $from_year;
					?>
					<p>
						<label class="title"><?php __('lblYear'); ?></label>
						<span class="inline_block">
							<select name="price_year" id="year_price" class="pj-form-field w100">
								<?php
								for ($i = $from_year; $i <= ($from_year + 5); $i++ )
								{
									?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<div id="ylPriceContainer">
						<?php include_once PJ_VIEWS_PATH . 'pjAdminListings/pjActionGetPrices.php';?>
					</div>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
					</p>
				</div><!-- tabs-5 -->
				<?php
			} 
			?>
			<div id="tabs-<?php echo $tpl['arr']['for'] == 'rent' ? 7 : 6;?>">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoContactTitle', true), __('infoContactDesc', true)); 
				}else{
					pjUtil::printNotice(__('infoContactTitle', true), __('infoContactDesc', true)); 
				}
				
				if ($controller->isAdmin() || $controller->isEditor())
				{
					?>
					<p>
						<label class="title"><?php __('lblChooseOwner'); ?></label>
						<span class="inline_block">
							<select name="owner_id" id="owner_id" class="pj-form-field w200">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach ($tpl['user_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>" <?php echo $v['id'] == $tpl['arr']['owner_id'] ? 'selected="selected"' : null;?>><?php echo stripslashes($v['name']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>	
					<?php
				} 
				?>
				<p>
					<label class="title"><?php __('lblOwnerShow'); ?></label>
					<span class="inline_block">
						<select name="owner_show" id="owner_show" class="pj-form-field w150">
							<?php
							if(empty($tpl['arr']['owner_show']))
							{
								$tpl['arr']['owner_show'] = 'T';
							}
							foreach (__('_yesno', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $tpl['arr']['owner_show'] == $k ? 'selected="selected"' : null;?>><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblOwnerTip'); ?>"></a>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block"><label class="content"><a class="resetContact" href="#"><?php __('lblResetContactDetails')?></a></label></span>
				</p>
				
				<p>
					<label class="title"><?php __('lblName'); ?></label>
					<span class="inline_block">
						<input type="text" name="owner_name" id="owner_name" value="<?php echo pjSanitize::html($tpl['arr']['owner_name']); ?>" class="pj-form-field w250" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('email'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="owner_email" id="owner_email" class="pj-form-field email w200" value="<?php echo pjSanitize::html($tpl['arr']['owner_email']); ?>" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPhone'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="owner_phone" id="owner_phone" value="<?php echo pjSanitize::html($tpl['arr']['owner_phone']); ?>" class="pj-form-field w200" placeholder="(123) 456-7890"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblFax'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="owner_fax" id="owner_fax" value="<?php echo pjSanitize::html($tpl['arr']['owner_fax']); ?>" class="pj-form-field w200" placeholder="(123) 456-7890"/>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div><!-- tabs-6 -->
			<div id="tabs-<?php echo $tpl['arr']['for'] == 'rent' ? 8 : 7;?>">
				<?php
				pjUtil::printNotice(__('infoAddressTitle', true), __('infoAddressDesc', true));
				?>
				<p>
					<label class="title"><?php __('lblAddress'); ?></label>
					<input type="text" name="address_content" id="address_content" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_content'])); ?>" class="pj-form-field w500" />
				</p>
				<p>
					<label class="title"><?php __('lblZip'); ?></label>
					<input type="text" name="address_zip" id="address_zip" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_zip'])); ?>" class="pj-form-field" />
				</p>
				<p style="overflow: visible">
					<label class="title"><?php __('lblCountry'); ?></label>
					<select name="address_country" id="address_country" class="pj-form-field w300">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['country_arr'] as $v)
						{
							if ($tpl['arr']['address_country'] == $v['id'])
							{
								?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo stripslashes($v['name']); ?></option><?php
							} else {
								?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
							}
						}
						?>
					</select>
				</p>
				<p><label class="title"><?php __('lblState'); ?></label><input type="text" name="address_state" id="address_state" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_state'])); ?>" class="pj-form-field w200" /></p>
				<p>
					<label class="title"><?php __('lblCity'); ?></label>
					<span class="inline_block">
						<input type="text" name="address_city" id="address_city" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_city'])); ?>" class="pj-form-field w200" />
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				</p>
			</div><!-- tabs-7 -->
			<div id="tabs-<?php echo $tpl['arr']['for'] == 'rent' ? 9 : 8;?>">
				<?php
				pjUtil::printNotice(__('infoSEOTitle', true), __('infoSEODesc', true));  
				?>
				<div class="multilang b10"></div>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title">
								<span class="title-tooltip"><?php __('lblMetaTitle'); ?></span>
								&nbsp;
								<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblMetaTitleTip'); ?>"></a>
							</label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_title]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_title'])); ?>" />
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><span class="title-tooltip"><?php __('lblMetaKeywords'); ?></span>&nbsp;<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblMetaKeywordTip'); ?>"></a></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][meta_keywords]" class="pj-form-field w500 h100"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_keywords'])); ?></textarea>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><span class="title-tooltip"><?php __('lblMetaDesc'); ?></span>&nbsp;<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblMetaDescTip'); ?>"></a></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][meta_description]" class="pj-form-field w500 h100"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_description'])); ?></textarea>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
					</p>
				</div>
			</div><!-- tabs-8 -->
			
		</div> <!-- #tabs -->
	</form>
	
	<div id="dialogDeleteFile" title="<?php __('gridDeleteConfirmation'); ?>" style="display:none;">
		<?php __('lblDeleteFileConfirmation'); ?>
	</div>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	var myLabel = myLabel || {};
	myLabel.isOwner = <?php echo $controller->isOwner() ? 'true' : 'false'; ?>;
	myLabel.address_not_found = "<?php __('lblAddressNotFound'); ?>";
	myLabel.digits = "<?php __('lblEnterDigitsOnly'); ?>";
	myLabel.min_length = "<?php __('lblMinLength'); ?>";
	myLabel.max_length = "<?php __('lblMaxLength'); ?>";
	myLabel.max_five_length = "<?php __('lblMaxFiveLength'); ?>";
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					$("input[name='locale']").val(ui.index);
				}
			});
			$(".first_multilang").find("a[data-index='<?php echo $locale; ?>']").trigger("click");
			$(".multilang").find("a[data-index='<?php echo $locale; ?>']").addClass("pj-form-langbar-item-active");
		});
	})(jQuery_1_8_2);
	</script>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>