<?php
$week_arr = pjUtil::getWeeksOfMonth(date('Y', $_GET['month']), date('n', $_GET['month']), $tpl['option_arr']['o_week_start']);
$months = __('months', true); 
?>
<table class="ylReservationTable">
	<thead>
		<tr>
			<th class="ylTableLeft">
				<a class="ylNavMonth" href="#" data-id="<?php echo $_GET['id']?>" data-month="<?php echo $week_arr['prev'] ?>">&lt; <?php __('front_prev');?></a>
			</th>
			<th colspan="3">
				<?php echo $months[date('n', $_GET['month'])] . ' ' . date('Y', $_GET['month']);?>
			</th>
			<th class="ylTableRight">
				<a class="ylNavMonth" href="#" data-id="<?php echo $_GET['id']?>" data-month="<?php echo $week_arr['next'] ?>"><?php __('front_next');?> &gt;</a>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach($week_arr as $k => $v)
		{
			if($k == 'next' || $k == 'prev')
			{
				continue;
			}
			$iso_date = date('Y-m-d', $v['monday']);
			$is_reserved = false;
			$is_avaialble = false;
			if(in_array($iso_date, $tpl['booking_arr']))
			{
				$is_reserved = true;
			}else{
				if(isset($tpl['price_arr'][$iso_date]))
				{
					if($iso_date >= date('Y-m-d'))
					{
						$is_avaialble = true;
					}
				}
			}
			?>
			<tr class="<?php echo $is_reserved == true ? 'ylReserved' : ($is_avaialble == true ? 'ylAvailable' : 'ylUnavailable');?>" data-week = "<?php echo $v['monday'];?>">
				<td>
					<span><?php __('front_week');?> <?php echo $k;?></span>
				</td>
				<td>
					<span><?php echo date($tpl['option_arr']['o_date_format'], $v['monday'])?> - <?php echo date($tpl['option_arr']['o_date_format'], $v['sunday'])?></span>
				</td>
				<td>
					<strong><?php echo $is_avaialble == true ? pjUtil::formatCurrencySign($tpl['price_arr'][$iso_date], $tpl['option_arr']['o_currency'])  : '&nbsp;'?></strong>
				</td>
				<td>
					<?php
					if($is_reserved == false)
					{ 
						if($is_avaialble == true)
						{
							?>
							<em><?php __('front_free');?></em>
							<?php
						}else{
							?><em><?php __('front_not_avaialble');?></em><?php
						}
					}else{
						?><em><?php __('front_reserved');?></em><?php
					} 
					?>
				</td>
				<td>
					<?php
					if($is_reserved == false)
					{ 
						if($is_avaialble == true)
						{
							?>
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjListings&amp;action=pjActionReserve&amp;id=<?php echo $_GET['id']?>" data-week="<?php echo $v['monday'];?>" class="ylBtn ylBtnTertiary ylBtnReserve"><?php __('front_make_a_reservation');?></a>
							<?php
						}else{
							?>&nbsp;<?php
						}
					}else{
						?>&nbsp;<?php
					} 
					?>
				</td>
			</tr>
			<?php
		} 
		?>
	</tbody>
</table>