DROP TABLE IF EXISTS `yellowpages_listings`;
CREATE TABLE IF NOT EXISTS `yellowpages_listings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `listing_refid` varchar(255) DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  `address_map` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `address_postcode` varchar(255) DEFAULT NULL,
  `address_content` text,
  `address_city` varchar(255) DEFAULT NULL,
  `address_state` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `expire` date DEFAULT NULL,
  `last_extend` enum('free','paid') DEFAULT NULL,
  `owner_show` enum('F','T') NOT NULL DEFAULT 'T',
  `status` enum('T','F','E') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `owner_id` (`owner_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_listings_categories`;
CREATE TABLE IF NOT EXISTS `yellowpages_listings_categories` (
  `listing_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`listing_id`,`category_id`),
  KEY `listing_id` (`listing_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_categories`;
CREATE TABLE IF NOT EXISTS `yellowpages_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_payments`;
CREATE TABLE IF NOT EXISTS `yellowpages_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_periods`;
CREATE TABLE IF NOT EXISTS `yellowpages_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_fields`;
CREATE TABLE IF NOT EXISTS `yellowpages_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_multi_lang`;
CREATE TABLE IF NOT EXISTS `yellowpages_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_options`;
CREATE TABLE IF NOT EXISTS `yellowpages_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_roles`;
CREATE TABLE IF NOT EXISTS `yellowpages_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `yellowpages_users`;
CREATE TABLE IF NOT EXISTS `yellowpages_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `title` varchar(50) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `mobile` varchar(100) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `yellowpages_categories` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T'),
(6, 'T'),
(7, 'T'),
(8, 'T'),
(9, 'T'),
(10, 'T'),
(11, 'T'),
(12, 'T'),
(13, 'T'),
(14, 'T'),
(15, 'T'),
(16, 'T'),
(17, 'T'),
(18, 'T'),
(19, 'T'),
(20, 'T'),
(21, 'T'),
(22, 'T'),
(23, 'T'),
(24, 'T'),
(25, 'T'),
(26, 'T'),
(27, 'T'),
(28, 'T'),
(29, 'T'),
(30, 'T'),
(31, 'T'),
(32, 'T'),
(33, 'T'),
(34, 'T'),
(35, 'T'),
(36, 'T'),
(37, 'T'),
(38, 'T'),
(39, 'T'),
(40, 'T'),
(41, 'T'),
(42, 'T'),
(43, 'T'),
(44, 'T'),
(45, 'T'),
(46, 'T'),
(47, 'T'),
(48, 'T'),
(49, 'T'),
(50, 'T'),
(51, 'T'),
(52, 'T'),
(53, 'T'),
(54, 'T'),
(55, 'T'),
(56, 'T'),
(57, 'T'),
(58, 'T'),
(59, 'T'),
(60, 'T'),
(61, 'T'),
(62, 'T'),
(63, 'T'),
(64, 'T'),
(65, 'T'),
(66, 'T'),
(67, 'T'),
(68, 'T'),
(69, 'T'),
(70, 'T'),
(71, 'T'),
(72, 'T'),
(73, 'T'),
(74, 'T');

INSERT INTO `yellowpages_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(322, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(323, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(324, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(325, 'opt_o_time_format', 'backend', 'Option / Time format', 'script', NULL),
(326, 'opt_o_items_per_page', 'backend', 'Options / Items per page', 'script', NULL),
(327, 'opt_o_email_address', 'backend', 'Options / Email address', 'script', NULL),
(328, 'menuSubmissions', 'backend', 'Menu / Submissions', 'script', NULL),
(329, 'infoSubmissionsTitle', 'backend', 'Infobox / Submission title', 'script', NULL),
(330, 'infoSubmissionsBody', 'backend', 'Infobox / Submission body', 'script', NULL),
(331, 'opt_o_allow_add_listing', 'backend', 'Options / Allow users to add listing', 'script', NULL),
(332, 'opt_o_owner_is_active', 'backend', 'Options / User account confirmed', 'script', NULL),
(333, 'opt_period_note', 'backend', 'Options / Period note', 'script', NULL),
(334, 'opt_o_paypal_address', 'backend', 'Options / Paypal email address', 'script', NULL),
(335, 'pj_payment_period', 'backend', 'Label / Period', 'script', NULL),
(336, 'pj_payment_price', 'backend', 'Label / Price', 'script', NULL),
(337, 'btnAddPeriod', 'backend', 'Buttons / Add period', 'script', NULL),
(338, 'yp_delete_period_title', 'backend', 'Label / Delete period title', 'script', NULL),
(339, 'yp_delete_period_body', 'backend', 'Label / Delete period body', 'script', NULL),
(340, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(341, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(342, 'yp_email_invalid', 'backend', 'Label / Email invalid', 'script', NULL),
(343, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(344, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(345, 'lblMobile', 'backend', 'Label / Mobile', 'script', NULL),
(346, 'lblFax', 'backend', 'Label / Fax', 'script', NULL),
(347, 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
(348, 'yp_delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(349, 'yp_delete_confirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(350, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(351, 'menuCountries', 'backend', 'Menu / Countries', 'script', NULL),
(352, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(353, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(354, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(355, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(356, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(357, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(358, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(359, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(360, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(361, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(362, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(363, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(364, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(365, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(366, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(367, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(368, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(369, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(370, 'yp_field_required', 'backend', 'Label / Field required', 'script', NULL),
(371, 'yp_same_category', 'backend', 'Label / Same category', 'script', NULL),
(372, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(373, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(374, 'menuListings', 'backend', 'Menu / Listings', 'script', NULL),
(375, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(376, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(377, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(378, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(379, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(380, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(381, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(382, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(383, 'lblAddListing', 'backend', 'Lable / Add listing', 'script', NULL),
(384, 'lblImage', 'backend', 'Lable / Image', 'script', NULL),
(385, 'lblListingRefid', 'backend', 'Lable / Ref ID', 'script', NULL),
(386, 'lblOwner', 'backend', 'Lable / Owner', 'script', NULL),
(387, 'lblExpire', 'backend', 'Lable / Expire', 'script', NULL),
(388, 'lblPublish', 'backend', 'Lable / Publish', 'script', NULL),
(391, 'lblExpireDate', 'backend', 'Lable / Exp. date', 'script', NULL),
(392, 'lblPublished', 'backend', 'Lable / Published', 'script', NULL),
(393, 'lblNotPublished', 'backend', 'Lable / Not published', 'script', NULL),
(394, 'lblExtendExpireDate', 'backend', 'Lable / Extend expiration date', 'script', NULL),
(395, 'lblDeleteSelected', 'backend', 'Lable / Delete selected', 'script', NULL),
(396, 'lblDeleteConfirmation', 'backend', 'Lable / Delete confirmation', 'script', NULL),
(397, 'lblNever', 'backend', 'Label / never', 'script', NULL),
(398, 'error_titles_ARRAY_AL11', 'arrays', 'error_titles_ARRAY_AL11', 'script', NULL),
(399, 'error_bodies_ARRAY_AL11', 'arrays', 'error_bodies_ARRAY_AL11', 'script', NULL),
(400, 'error_titles_ARRAY_AL09', 'arrays', 'error_titles_ARRAY_AL09', 'script', NULL),
(401, 'error_bodies_ARRAY_AL09', 'arrays', 'error_bodies_ARRAY_AL09', 'script', NULL),
(402, 'error_titles_ARRAY_AL10', 'arrays', 'error_titles_ARRAY_AL10', 'script', NULL),
(403, 'error_bodies_ARRAY_AL10', 'arrays', 'error_bodies_ARRAY_AL10', 'script', NULL),
(404, 'infoListingAddTitle', 'backend', 'Infobox / Add new listing', 'script', NULL),
(405, 'infoListingAddDesc', 'backend', 'Infobox / Add new listing desc', 'script', NULL),
(407, 'lblListingStatus', 'backend', 'Label / Status', 'script', NULL),
(408, 'lblListingExpire', 'backend', 'Label / Expire date', 'script', NULL),
(409, 'lblListingOwner', 'backend', 'Label / Owner', 'script', NULL),
(410, 'lblOwnerShow', 'backend', 'Label / Show owner contact', 'script', NULL),
(411, 'lblListingShowContactTip', 'backend', 'Label / Show contact tip', 'script', NULL),
(412, 'lblListingExpireTip', 'backend', 'Label / Expire date tip', 'script', NULL),
(413, 'lblListingStatusTip', 'backend', 'Label / Status tip', 'script', NULL),
(414, 'publish_status_ARRAY_T', 'arrays', 'publish_status_ARRAY_T', 'script', NULL),
(415, 'publish_status_ARRAY_F', 'arrays', 'publish_status_ARRAY_F', 'script', NULL),
(416, 'publish_status_ARRAY_E', 'arrays', 'publish_status_ARRAY_E', 'script', NULL),
(417, 'lblListingSummary', 'backend', 'Label / Summary', 'script', NULL),
(418, 'lblListingDetails', 'backend', 'Label / Details', 'script', NULL),
(419, 'lblListingDescription', 'backend', 'Label / Description', 'script', NULL),
(420, 'lblListingCategories', 'backend', 'Label / Categories', 'script', NULL),
(421, 'lblListingPhotos', 'backend', 'Label / Photos', 'script', NULL),
(422, 'lblListingSeo', 'backend', 'Label / SEO', 'script', NULL),
(423, 'lblListingCreated', 'backend', 'Label / Created', 'script', NULL),
(424, 'lblListingModified', 'backend', 'Label / Modified', 'script', NULL),
(425, 'lblListingViews', 'backend', 'Label / Views', 'script', NULL),
(426, 'infoListingDetailTitle', 'backend', 'Infobox / Listing detail title', 'script', NULL),
(427, 'infoListingDetailBody', 'backend', 'Infobox / Listing detail body', 'script', NULL),
(428, 'lblListingTitle', 'backend', 'Label / Title', 'script', NULL),
(430, 'infoCategoryTitle', 'backend', 'Infobox / Listing category title', 'script', NULL),
(431, 'infoCategoryBody', 'backend', 'Infobox / Listing category body', 'script', NULL),
(432, 'error_titles_ARRAY_AL41', 'arrays', 'error_titles_ARRAY_AL41', 'script', NULL),
(433, 'error_bodies_ARRAY_AL41', 'arrays', 'error_bodies_ARRAY_AL41', 'script', NULL),
(435, 'lblShowOnMap', 'backend', 'Label / Show on map', 'script', NULL),
(436, 'lblListingZip', 'backend', 'Label / Zip', 'script', NULL),
(437, 'lblListingAddress', 'backend', 'Label / Address', 'script', NULL),
(438, 'lblListingCountry', 'backend', 'Label / Country', 'script', NULL),
(439, 'lblListingState', 'backend', 'Label / State', 'script', NULL),
(440, 'lblListingCity', 'backend', 'Label / City', 'script', NULL),
(441, 'lblListingGMapNote', 'backend', 'Label / GMap note', 'script', NULL),
(442, 'btnGoogleMapsApi', 'backend', 'label / google map api', 'script', NULL),
(443, 'lblListingLat', 'backend', 'Label / Latitude', 'script', NULL),
(444, 'lblListingLng', 'backend', 'Label / Longitude', 'script', NULL),
(445, 'infoListingSEOTitle', 'backend', 'Infobox / SEO settings', 'script', NULL),
(446, 'infoListingSEOBody', 'backend', 'Infobox / SEO settings body', 'script', NULL),
(447, 'lblListingMetaTitle', 'backend', 'Label / Meta title', 'script', NULL),
(448, 'lblListingMetaKeywords', 'backend', 'Label / Meta keywords', 'script', NULL),
(449, 'lblListingMetaDesc', 'backend', 'Label / Meta description', 'script', NULL),
(450, 'lblNA', 'backend', 'Label / na', 'script', NULL),
(451, 'lblAddressNotFound', 'backend', 'Label / Address not found', 'script', NULL),
(452, 'lblKeyword', 'backend', 'Label / Keyword', 'script', NULL),
(453, 'lblListingCategory', 'backend', 'Label / Category', 'script', NULL),
(454, 'lblExpireDatePlus30', 'backend', 'Lable / Expiration date +30 days', 'script', NULL),
(455, 'lblExtendConfirmation', 'backend', 'Label / Extend confirm', 'script', NULL),
(456, 'lblListingExtend', 'backend', 'Label / Extend expire date', 'script', NULL),
(457, 'lblPeriod', 'backend', 'Label / Period', 'script', NULL),
(458, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(460, 'lblBuyNow', 'backend', 'Label / Buy now', 'script', NULL),
(461, 'lblFree', 'backend', 'Label / FREE', 'script', NULL),
(462, 'lblExtendForFree', 'backend', 'Label / Extend your period for FREE', 'script', NULL),
(463, 'lblInstallListing', 'backend', 'Label / Listing', 'script', NULL),
(464, 'lblInstallOptional', 'backend', 'Label / Optional', 'script', NULL),
(465, 'lblInstallPhp1Title', 'backend', 'Label / Step 1', 'script', NULL),
(466, 'opt_o_listing_page', 'backend', 'Options / listing page', 'script', NULL),
(467, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(468, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(469, 'lblInstallPhp1_1', 'backend', 'Label / Install step 1', 'script', NULL),
(470, 'lblInstallPhp1_2', 'backend', 'Label / Install step 2', 'script', NULL),
(471, 'lblInstallPhp1_2a', 'backend', 'Label / Install step 2a', 'script', NULL),
(472, 'lblInstallPhp1_3', 'backend', 'Label / Install step 3', 'script', NULL),
(473, 'lblInstallPhp2Title', 'backend', 'Label / Install option title', 'script', NULL),
(474, 'opt_o_seo_url', 'backend', 'Options /  Use SEO Friendly URLs', 'script', NULL),
(475, 'lblInstallPhp1_4', 'backend', 'Label / Install step 4', 'script', NULL),
(476, 'lblInstallPhp1_5', 'backend', 'Label / Install step 5', 'script', NULL),
(546, 'infoEmailTitle', 'backend', 'Infobox / Email notifications', 'script', NULL),
(547, 'infoEmailBody', 'backend', 'Infobox / Email notifications body', 'script', NULL),
(548, 'lblRegistrationNotifyEmail', 'backend', 'Label / New user account notification', 'script', NULL),
(549, 'lblRegistrationEmailTip', 'backend', 'Label / New user account tips', 'script', NULL),
(550, 'lblEmailSubject', 'backend', 'Label / Subject', 'script', NULL),
(551, 'lblEmailMessage', 'backend', 'Label / Message', 'script', NULL),
(552, 'lblRegisterNotifyTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(553, 'menuEmails', 'backend', 'Menu / Emails', 'script', NULL),
(554, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(555, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(556, 'label_search', 'frontend', 'Label / Search', 'script', NULL),
(557, 'menu_home', 'frontend', 'Menu / Home', 'script', NULL),
(558, 'menu_categories', 'frontend', 'Menu / Categories', 'script', NULL),
(559, 'menu_map', 'frontend', 'Menu / Map', 'script', NULL),
(560, 'menu_account', 'frontend', 'Menu / Account', 'script', NULL),
(561, 'label_filter_by_category', 'frontend', 'Label / Filter by Category', 'script', NULL),
(562, 'label_order_by', 'frontend', 'Label / Order by', 'script', NULL),
(563, 'label_alphabetically', 'frontend', 'Label / Alphabetically', 'script', NULL),
(564, 'label_date_added', 'frontend', 'Label / Date added', 'script', NULL),
(565, 'label_not_found', 'frontend', 'Label / No listing found', 'script', NULL),
(566, 'label_view_more', 'frontend', 'Label / View more', 'script', NULL),
(567, 'label_back', 'frontend', 'Label / back', 'script', NULL),
(568, 'label_address', 'frontend', 'Label / Address', 'script', NULL),
(569, 'label_description', 'frontend', 'Label / Description', 'script', NULL),
(570, 'label_enter_address', 'frontend', 'Label / Enter your address', 'script', NULL),
(571, 'label_directions', 'frontend', 'Label / Directions', 'script', NULL),
(572, 'label_share_lising', 'frontend', 'Label / Sharing via email', 'script', NULL),
(573, 'label_to', 'frontend', 'Label / To', 'script', NULL),
(574, 'label_from', 'frontend', 'Label / From', 'script', NULL),
(575, 'label_subject', 'frontend', 'Label / Subject', 'script', NULL),
(576, 'label_message', 'frontend', 'Label / Message', 'script', NULL),
(577, 'button_send', 'frontend', 'Button / Send', 'script', NULL),
(578, 'button_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(579, 'label_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(580, 'label_email_invalid', 'frontend', 'Label / Email is invalid', 'script', NULL),
(581, 'label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(582, 'label_email', 'frontend', 'Label / Email', 'script', NULL),
(583, 'label_url', 'frontend', 'Label / Url', 'script', NULL),
(584, 'label_login', 'frontend', 'Label / Login', 'script', NULL),
(585, 'label_register', 'frontend', 'Label / Register', 'script', NULL),
(586, 'label_login_text', 'frontend', 'Label / Login text', 'script', NULL),
(587, 'label_register_text', 'frontend', 'Label / Register text', 'script', NULL),
(588, 'label_username', 'frontend', 'Label / Username', 'script', NULL),
(589, 'label_password', 'frontend', 'Label / Password', 'script', NULL),
(590, 'label_full_name', 'frontend', 'Label / Full name', 'script', NULL),
(591, 'label_website', 'frontend', 'Label / Website', 'script', NULL),
(592, 'label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(593, 'label_email_required', 'frontend', 'Label / Email is required.', 'script', NULL),
(595, 'label_password_required', 'frontend', 'Label / Password is required.', 'script', NULL),
(596, 'label_name_required', 'frontend', 'Label / Full name is required.', 'script', NULL),
(597, 'label_captcha_required', 'frontend', 'Label / Captcha is required.', 'script', NULL),
(598, 'label_captcha_incorrect', 'frontend', 'Label / Captcha is incorrect.', 'script', NULL),
(599, 'label_email_used', 'frontend', 'Label / Email was already in use.', 'script', NULL),
(600, 'register_error_ARRAY_9901', 'arrays', 'register_error_ARRAY_9901', 'script', NULL),
(601, 'register_error_ARRAY_9902', 'arrays', 'register_error_ARRAY_9902', 'script', NULL),
(602, 'register_error_ARRAY_9903', 'arrays', 'register_error_ARRAY_9902', 'script', NULL),
(603, 'register_error_ARRAY_9904', 'arrays', 'register_error_ARRAY_9904', 'script', NULL),
(604, 'register_error_ARRAY_9905', 'arrays', 'register_error_ARRAY_9905', 'script', NULL),
(605, 'register_error_ARRAY_9906', 'arrays', 'register_error_ARRAY_9906', 'script', NULL),
(606, 'register_error_ARRAY_9907', 'arrays', 'register_error_ARRAY_9907', 'script', NULL),
(607, 'register_error_ARRAY_9908', 'arrays', 'register_error_ARRAY_9908', 'script', NULL),
(608, 'register_error_ARRAY_9909', 'arrays', 'register_error_ARRAY_9909', 'script', NULL),
(609, 'register_error_ARRAY_9910', 'arrays', 'register_error_ARRAY_9910', 'script', NULL),
(610, 'register_error_ARRAY_9999', 'arrays', 'register_error_ARRAY_9999', 'script', NULL),
(611, 'register_error_ARRAY_9998', 'arrays', 'register_error_ARRAY_9998', 'script', NULL),
(612, 'label_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(614, 'label_forgot_text', 'frontend', 'Label / Forgot password text', 'script', NULL),
(615, 'lblForgotNotifyEmail', 'backend', 'Label / Password recovery', 'script', NULL),
(616, 'lblForgotEmailTip', 'backend', 'Tip / Forgot password', 'script', NULL),
(617, 'lblForgotEmailTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(618, 'forgot_error_ARRAY_9901', 'arrays', 'forgot_error_ARRAY_9901', 'script', NULL),
(619, 'forgot_error_ARRAY_9902', 'arrays', 'forgot_error_ARRAY_9902', 'script', NULL),
(620, 'forgot_error_ARRAY_9903', 'arrays', 'forgot_error_ARRAY_9903', 'script', NULL),
(621, 'forgot_error_ARRAY_9999', 'arrays', 'forgot_error_ARRAY_9999', 'script', NULL),
(623, 'lblListingContact', 'backend', 'Label / Contact', 'script', NULL),
(624, 'lblDashListings', 'backend', 'Label / Listings', 'script', NULL),
(625, 'lblDashListing', 'backend', 'Label / Listing', 'script', NULL),
(626, 'lblDashExpiredListings', 'backend', 'Label / Listings expire today', 'script', NULL),
(627, 'lblDashExpiredListing', 'backend', 'Label / Listing expire today', 'script', NULL),
(628, 'lblDashUsers', 'backend', 'Label / Users', 'script', NULL),
(629, 'lblDashUser', 'backend', 'Label / User', 'script', NULL),
(630, 'lblDashMostPopular', 'backend', 'Label / Most popular listings', 'script', NULL),
(631, 'lblDashLatestAdded', 'backend', 'Label / Latest Added Listings', 'script', NULL),
(632, 'lblDashLastUsers', 'backend', 'Label / Latest Registered Users', 'script', NULL),
(633, 'lblListingNotFound', 'backend', 'Label / Listing not found', 'script', NULL),
(634, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(635, 'lblView', 'backend', 'Label / View', 'script', NULL),
(636, 'lblUserNotFound', 'backend', 'Label / User not found', 'script', NULL),
(637, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(638, 'lblImport', 'backend', 'Label / Import', 'script', NULL),
(639, 'infoImportListingTitle', 'backend', 'Infobox / Import Listings title', 'script', NULL),
(640, 'infoImportListingBody', 'backend', 'Infobox / Import Listing body', 'script', NULL),
(641, 'error_titles_ARRAY_AL12', 'arrays', 'error_titles_ARRAY_AL12', 'script', NULL),
(642, 'error_bodies_ARRAY_AL12', 'arrays', 'error_bodies_ARRAY_AL12', 'script', NULL),
(643, 'error_titles_ARRAY_AL13', 'arrays', 'error_titles_ARRAY_AL13', 'script', NULL),
(644, 'error_bodies_ARRAY_AL13', 'arrays', 'error_bodies_ARRAY_AL13', 'script', NULL),
(645, 'error_titles_ARRAY_AL14', 'arrays', 'error_titles_ARRAY_AL14', 'script', NULL),
(646, 'error_bodies_ARRAY_AL14', 'arrays', 'error_bodies_ARRAY_AL14', 'script', NULL),
(647, 'lblCSVFile', 'backend', 'Label / CSV file', 'script', NULL),
(743, 'title', 'backend', 'Label / Title', 'script', NULL),
(744, 'phone', 'backend', 'Label / Phone', 'script', NULL),
(745, 'mobile', 'backend', 'Label / Mobile', 'script', NULL),
(746, 'fax', 'backend', 'Label / Fax', 'script', NULL),
(747, 'website', 'backend', 'Label / Website', 'script', NULL),
(748, 'lblListingNotifyEmail', 'backend', 'Label / Listing notify', 'script', NULL),
(749, 'lblListingEmailTip', 'backend', 'Label / Listing notify tip', 'script', NULL),
(750, 'lblListingNotifyTokens', 'backend', 'Label / Available tokens', 'script', NULL);

INSERT INTO `yellowpages_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjCategory', 1, 'name', 'Air Conditioning Contractors & Systems', 'data'),
(NULL, 1, 'pjCategory', 2, 'name', 'Air Conditioning Contractors & Systems', 'data'),
(NULL, 1, 'pjCategory', 3, 'name', 'Air Conditioning Contractors & Systems', 'data'),
(NULL, 2, 'pjCategory', 1, 'name', 'Amusement Places & Arcades', 'data'),
(NULL, 2, 'pjCategory', 2, 'name', 'Amusement Places & Arcades', 'data'),
(NULL, 2, 'pjCategory', 3, 'name', 'Amusement Places & Arcades', 'data'),
(NULL, 3, 'pjCategory', 1, 'name', 'Animal Shelters', 'data'),
(NULL, 3, 'pjCategory', 2, 'name', 'Animal Shelters', 'data'),
(NULL, 3, 'pjCategory', 3, 'name', 'Animal Shelters', 'data'),
(NULL, 4, 'pjCategory', 1, 'name', 'Apartments', 'data'),
(NULL, 4, 'pjCategory', 2, 'name', 'Apartments', 'data'),
(NULL, 4, 'pjCategory', 3, 'name', 'Apartments', 'data'),
(NULL, 5, 'pjCategory', 1, 'name', 'Attorneys', 'data'),
(NULL, 5, 'pjCategory', 2, 'name', 'Attorneys', 'data'),
(NULL, 5, 'pjCategory', 3, 'name', 'Attorneys', 'data'),
(NULL, 6, 'pjCategory', 1, 'name', 'Auto Repair & Service', 'data'),
(NULL, 6, 'pjCategory', 2, 'name', 'Auto Repair & Service', 'data'),
(NULL, 6, 'pjCategory', 3, 'name', 'Auto Repair & Service', 'data'),
(NULL, 7, 'pjCategory', 1, 'name', 'Automobile Body Repairing & Painting', 'data'),
(NULL, 7, 'pjCategory', 2, 'name', 'Automobile Body Repairing & Painting', 'data'),
(NULL, 7, 'pjCategory', 3, 'name', 'Automobile Body Repairing & Painting', 'data'),
(NULL, 8, 'pjCategory', 1, 'name', 'Automobile Parts & Supplies', 'data'),
(NULL, 8, 'pjCategory', 2, 'name', 'Automobile Parts & Supplies', 'data'),
(NULL, 8, 'pjCategory', 3, 'name', 'Automobile Parts & Supplies', 'data'),
(NULL, 9, 'pjCategory', 1, 'name', 'Automobile Salvage', 'data'),
(NULL, 9, 'pjCategory', 2, 'name', 'Automobile Salvage', 'data'),
(NULL, 9, 'pjCategory', 3, 'name', 'Automobile Salvage', 'data'),
(NULL, 10, 'pjCategory', 1, 'name', 'Banks', 'data'),
(NULL, 10, 'pjCategory', 2, 'name', 'Banks', 'data'),
(NULL, 10, 'pjCategory', 3, 'name', 'Banks', 'data'),
(NULL, 11, 'pjCategory', 1, 'name', 'Bars', 'data'),
(NULL, 11, 'pjCategory', 2, 'name', 'Bars', 'data'),
(NULL, 11, 'pjCategory', 3, 'name', 'Bars', 'data'),
(NULL, 12, 'pjCategory', 1, 'name', 'Beauty Salons & Services', 'data'),
(NULL, 12, 'pjCategory', 2, 'name', 'Beauty Salons & Services', 'data'),
(NULL, 12, 'pjCategory', 3, 'name', 'Beauty Salons & Services', 'data'),
(NULL, 13, 'pjCategory', 1, 'name', 'Boat-Rental & Charter', 'data'),
(NULL, 13, 'pjCategory', 2, 'name', 'Boat-Rental & Charter', 'data'),
(NULL, 13, 'pjCategory', 3, 'name', 'Boat-Rental & Charter', 'data'),
(NULL, 14, 'pjCategory', 1, 'name', 'Bowling', 'data'),
(NULL, 14, 'pjCategory', 2, 'name', 'Bowling', 'data'),
(NULL, 14, 'pjCategory', 3, 'name', 'Bowling', 'data'),
(NULL, 15, 'pjCategory', 1, 'name', 'Bus Lines', 'data'),
(NULL, 15, 'pjCategory', 2, 'name', 'Bus Lines', 'data'),
(NULL, 15, 'pjCategory', 3, 'name', 'Bus Lines', 'data'),
(NULL, 16, 'pjCategory', 1, 'name', 'Campgrounds & Recreational Vehicle Parks', 'data'),
(NULL, 16, 'pjCategory', 2, 'name', 'Campgrounds & Recreational Vehicle Parks', 'data'),
(NULL, 16, 'pjCategory', 3, 'name', 'Campgrounds & Recreational Vehicle Parks', 'data'),
(NULL, 17, 'pjCategory', 1, 'name', 'Camps-Recreational', 'data'),
(NULL, 17, 'pjCategory', 2, 'name', 'Camps-Recreational', 'data'),
(NULL, 17, 'pjCategory', 3, 'name', 'Camps-Recreational', 'data'),
(NULL, 18, 'pjCategory', 1, 'name', 'Carpet & Rug Cleaners', 'data'),
(NULL, 18, 'pjCategory', 2, 'name', 'Carpet & Rug Cleaners', 'data'),
(NULL, 18, 'pjCategory', 3, 'name', 'Carpet & Rug Cleaners', 'data'),
(NULL, 19, 'pjCategory', 1, 'name', 'Chinese Restaurants', 'data'),
(NULL, 19, 'pjCategory', 2, 'name', 'Chinese Restaurants', 'data'),
(NULL, 19, 'pjCategory', 3, 'name', 'Chinese Restaurants', 'data'),
(NULL, 20, 'pjCategory', 1, 'name', 'Chiropractors & Chiropractic Services', 'data'),
(NULL, 20, 'pjCategory', 2, 'name', 'Chiropractors & Chiropractic Services', 'data'),
(NULL, 20, 'pjCategory', 3, 'name', 'Chiropractors & Chiropractic Services', 'data'),
(NULL, 21, 'pjCategory', 1, 'name', 'Churches & Places of Worship', 'data'),
(NULL, 21, 'pjCategory', 2, 'name', 'Churches & Places of Worship', 'data'),
(NULL, 21, 'pjCategory', 3, 'name', 'Churches & Places of Worship', 'data'),
(NULL, 22, 'pjCategory', 1, 'name', 'Criminal Law Attorneys', 'data'),
(NULL, 22, 'pjCategory', 2, 'name', 'Criminal Law Attorneys', 'data'),
(NULL, 22, 'pjCategory', 3, 'name', 'Criminal Law Attorneys', 'data'),
(NULL, 23, 'pjCategory', 1, 'name', 'Dentists', 'data'),
(NULL, 23, 'pjCategory', 2, 'name', 'Dentists', 'data'),
(NULL, 23, 'pjCategory', 3, 'name', 'Dentists', 'data'),
(NULL, 24, 'pjCategory', 1, 'name', 'Department Stores', 'data'),
(NULL, 24, 'pjCategory', 2, 'name', 'Department Stores', 'data'),
(NULL, 24, 'pjCategory', 3, 'name', 'Department Stores', 'data'),
(NULL, 25, 'pjCategory', 1, 'name', 'Electricians', 'data'),
(NULL, 25, 'pjCategory', 2, 'name', 'Electricians', 'data'),
(NULL, 25, 'pjCategory', 3, 'name', 'Electricians', 'data'),
(NULL, 26, 'pjCategory', 1, 'name', 'Employment Agencies', 'data'),
(NULL, 26, 'pjCategory', 2, 'name', 'Employment Agencies', 'data'),
(NULL, 26, 'pjCategory', 3, 'name', 'Employment Agencies', 'data'),
(NULL, 27, 'pjCategory', 1, 'name', 'Fence-Sales, Service & Contractors', 'data'),
(NULL, 27, 'pjCategory', 2, 'name', 'Fence-Sales, Service & Contractors', 'data'),
(NULL, 27, 'pjCategory', 3, 'name', 'Fence-Sales, Service & Contractors', 'data'),
(NULL, 28, 'pjCategory', 1, 'name', 'Florists', 'data'),
(NULL, 28, 'pjCategory', 2, 'name', 'Florists', 'data'),
(NULL, 28, 'pjCategory', 3, 'name', 'Florists', 'data'),
(NULL, 29, 'pjCategory', 1, 'name', 'Furniture Stores', 'data'),
(NULL, 29, 'pjCategory', 2, 'name', 'Furniture Stores', 'data'),
(NULL, 29, 'pjCategory', 3, 'name', 'Furniture Stores', 'data'),
(NULL, 30, 'pjCategory', 1, 'name', 'Glass-Auto, Plate, Window, Etc', 'data'),
(NULL, 30, 'pjCategory', 2, 'name', 'Glass-Auto, Plate, Window, Etc', 'data'),
(NULL, 30, 'pjCategory', 3, 'name', 'Glass-Auto, Plate, Window, Etc', 'data'),
(NULL, 31, 'pjCategory', 1, 'name', 'Golf Courses', 'data'),
(NULL, 31, 'pjCategory', 2, 'name', 'Golf Courses', 'data'),
(NULL, 31, 'pjCategory', 3, 'name', 'Golf Courses', 'data'),
(NULL, 32, 'pjCategory', 3, 'name', 'Grocery Stores2', 'data'),
(NULL, 32, 'pjCategory', 1, 'name', 'Grocery Stores2', 'data'),
(NULL, 32, 'pjCategory', 2, 'name', 'Grocery Stores2', 'data'),
(NULL, 33, 'pjCategory', 1, 'name', 'Hobby & Model Shops', 'data'),
(NULL, 33, 'pjCategory', 2, 'name', 'Hobby & Model Shops', 'data'),
(NULL, 33, 'pjCategory', 3, 'name', 'Hobby & Model Shops', 'data'),
(NULL, 34, 'pjCategory', 1, 'name', 'Hospitals', 'data'),
(NULL, 34, 'pjCategory', 2, 'name', 'Hospitals', 'data'),
(NULL, 34, 'pjCategory', 3, 'name', 'Hospitals', 'data'),
(NULL, 35, 'pjCategory', 1, 'name', 'Hotels', 'data'),
(NULL, 35, 'pjCategory', 2, 'name', 'Hotels', 'data'),
(NULL, 35, 'pjCategory', 3, 'name', 'Hotels', 'data'),
(NULL, 36, 'pjCategory', 1, 'name', 'Insurance', 'data'),
(NULL, 36, 'pjCategory', 2, 'name', 'Insurance', 'data'),
(NULL, 36, 'pjCategory', 3, 'name', 'Insurance', 'data'),
(NULL, 37, 'pjCategory', 1, 'name', 'Italian Restaurants', 'data'),
(NULL, 37, 'pjCategory', 2, 'name', 'Italian Restaurants', 'data'),
(NULL, 37, 'pjCategory', 3, 'name', 'Italian Restaurants', 'data'),
(NULL, 38, 'pjCategory', 1, 'name', 'Landscape Contractors', 'data'),
(NULL, 38, 'pjCategory', 2, 'name', 'Landscape Contractors', 'data'),
(NULL, 38, 'pjCategory', 3, 'name', 'Landscape Contractors', 'data'),
(NULL, 39, 'pjCategory', 1, 'name', 'Libraries', 'data'),
(NULL, 39, 'pjCategory', 2, 'name', 'Libraries', 'data'),
(NULL, 39, 'pjCategory', 3, 'name', 'Libraries', 'data'),
(NULL, 40, 'pjCategory', 1, 'name', 'Mail & Shipping Services', 'data'),
(NULL, 40, 'pjCategory', 2, 'name', 'Mail & Shipping Services', 'data'),
(NULL, 40, 'pjCategory', 3, 'name', 'Mail & Shipping Services', 'data'),
(NULL, 41, 'pjCategory', 1, 'name', 'Mexican Restaurants', 'data'),
(NULL, 41, 'pjCategory', 2, 'name', 'Mexican Restaurants', 'data'),
(NULL, 41, 'pjCategory', 3, 'name', 'Mexican Restaurants', 'data'),
(NULL, 42, 'pjCategory', 1, 'name', 'Motels', 'data'),
(NULL, 42, 'pjCategory', 2, 'name', 'Motels', 'data'),
(NULL, 42, 'pjCategory', 3, 'name', 'Motels', 'data'),
(NULL, 43, 'pjCategory', 1, 'name', 'Motorcycle Dealers', 'data'),
(NULL, 43, 'pjCategory', 2, 'name', 'Motorcycle Dealers', 'data'),
(NULL, 43, 'pjCategory', 3, 'name', 'Motorcycle Dealers', 'data'),
(NULL, 44, 'pjCategory', 1, 'name', 'Movie Theaters', 'data'),
(NULL, 44, 'pjCategory', 2, 'name', 'Movie Theaters', 'data'),
(NULL, 44, 'pjCategory', 3, 'name', 'Movie Theaters', 'data'),
(NULL, 45, 'pjCategory', 1, 'name', 'Nail Salons', 'data'),
(NULL, 45, 'pjCategory', 2, 'name', 'Nail Salons', 'data'),
(NULL, 45, 'pjCategory', 3, 'name', 'Nail Salons', 'data'),
(NULL, 46, 'pjCategory', 1, 'name', 'New Car Dealers', 'data'),
(NULL, 46, 'pjCategory', 2, 'name', 'New Car Dealers', 'data'),
(NULL, 46, 'pjCategory', 3, 'name', 'New Car Dealers', 'data'),
(NULL, 47, 'pjCategory', 1, 'name', 'Newspapers', 'data'),
(NULL, 47, 'pjCategory', 2, 'name', 'Newspapers', 'data'),
(NULL, 47, 'pjCategory', 3, 'name', 'Newspapers', 'data'),
(NULL, 48, 'pjCategory', 1, 'name', 'Night Clubs', 'data'),
(NULL, 48, 'pjCategory', 2, 'name', 'Night Clubs', 'data'),
(NULL, 48, 'pjCategory', 3, 'name', 'Night Clubs', 'data'),
(NULL, 49, 'pjCategory', 1, 'name', 'Painting Contractors', 'data'),
(NULL, 49, 'pjCategory', 2, 'name', 'Painting Contractors', 'data'),
(NULL, 49, 'pjCategory', 3, 'name', 'Painting Contractors', 'data'),
(NULL, 50, 'pjCategory', 1, 'name', 'Parks', 'data'),
(NULL, 50, 'pjCategory', 2, 'name', 'Parks', 'data'),
(NULL, 50, 'pjCategory', 3, 'name', 'Parks', 'data'),
(NULL, 51, 'pjCategory', 1, 'name', 'Party Supply Rental', 'data'),
(NULL, 51, 'pjCategory', 2, 'name', 'Party Supply Rental', 'data'),
(NULL, 51, 'pjCategory', 3, 'name', 'Party Supply Rental', 'data'),
(NULL, 52, 'pjCategory', 1, 'name', 'Pest Control Services', 'data'),
(NULL, 52, 'pjCategory', 2, 'name', 'Pest Control Services', 'data'),
(NULL, 52, 'pjCategory', 3, 'name', 'Pest Control Services', 'data'),
(NULL, 53, 'pjCategory', 1, 'name', 'Pet Stores', 'data'),
(NULL, 53, 'pjCategory', 2, 'name', 'Pet Stores', 'data'),
(NULL, 53, 'pjCategory', 3, 'name', 'Pet Stores', 'data'),
(NULL, 54, 'pjCategory', 1, 'name', 'Physicians & Surgeons', 'data'),
(NULL, 54, 'pjCategory', 2, 'name', 'Physicians & Surgeons', 'data'),
(NULL, 54, 'pjCategory', 3, 'name', 'Physicians & Surgeons', 'data'),
(NULL, 55, 'pjCategory', 1, 'name', 'Physicians & Surgeons, Family Medicine & General Practice', 'data'),
(NULL, 55, 'pjCategory', 2, 'name', 'Physicians & Surgeons, Family Medicine & General Practice', 'data'),
(NULL, 55, 'pjCategory', 3, 'name', 'Physicians & Surgeons, Family Medicine & General Practice', 'data'),
(NULL, 56, 'pjCategory', 1, 'name', 'Pizza', 'data'),
(NULL, 56, 'pjCategory', 2, 'name', 'Pizza', 'data'),
(NULL, 56, 'pjCategory', 3, 'name', 'Pizza', 'data'),
(NULL, 57, 'pjCategory', 1, 'name', 'Plumbers', 'data'),
(NULL, 57, 'pjCategory', 2, 'name', 'Plumbers', 'data'),
(NULL, 57, 'pjCategory', 3, 'name', 'Plumbers', 'data'),
(NULL, 58, 'pjCategory', 1, 'name', 'Police Departments', 'data'),
(NULL, 58, 'pjCategory', 2, 'name', 'Police Departments', 'data'),
(NULL, 58, 'pjCategory', 3, 'name', 'Police Departments', 'data'),
(NULL, 59, 'pjCategory', 1, 'name', 'Post Offices', 'data'),
(NULL, 59, 'pjCategory', 2, 'name', 'Post Offices', 'data'),
(NULL, 59, 'pjCategory', 3, 'name', 'Post Offices', 'data'),
(NULL, 60, 'pjCategory', 1, 'name', 'Public Schools', 'data'),
(NULL, 60, 'pjCategory', 2, 'name', 'Public Schools', 'data'),
(NULL, 60, 'pjCategory', 3, 'name', 'Public Schools', 'data'),
(NULL, 61, 'pjCategory', 1, 'name', 'Radio Stations & Broadcast Companies', 'data'),
(NULL, 61, 'pjCategory', 2, 'name', 'Radio Stations & Broadcast Companies', 'data'),
(NULL, 61, 'pjCategory', 3, 'name', 'Radio Stations & Broadcast Companies', 'data'),
(NULL, 62, 'pjCategory', 1, 'name', 'Railroads-Ticket Agencies', 'data'),
(NULL, 62, 'pjCategory', 2, 'name', 'Railroads-Ticket Agencies', 'data'),
(NULL, 62, 'pjCategory', 3, 'name', 'Railroads-Ticket Agencies', 'data'),
(NULL, 63, 'pjCategory', 1, 'name', 'Real Estate Agents', 'data'),
(NULL, 63, 'pjCategory', 2, 'name', 'Real Estate Agents', 'data'),
(NULL, 63, 'pjCategory', 3, 'name', 'Real Estate Agents', 'data'),
(NULL, 64, 'pjCategory', 1, 'name', 'Restaurants', 'data'),
(NULL, 64, 'pjCategory', 2, 'name', 'Restaurants', 'data'),
(NULL, 64, 'pjCategory', 3, 'name', 'Restaurants', 'data'),
(NULL, 65, 'pjCategory', 1, 'name', 'Roofing Contractors', 'data'),
(NULL, 65, 'pjCategory', 2, 'name', 'Roofing Contractors', 'data'),
(NULL, 65, 'pjCategory', 3, 'name', 'Roofing Contractors', 'data'),
(NULL, 66, 'pjCategory', 1, 'name', 'Seafood Restaurants', 'data'),
(NULL, 66, 'pjCategory', 2, 'name', 'Seafood Restaurants', 'data'),
(NULL, 66, 'pjCategory', 3, 'name', 'Seafood Restaurants', 'data'),
(NULL, 67, 'pjCategory', 1, 'name', 'Shopping Centers & Malls', 'data'),
(NULL, 67, 'pjCategory', 2, 'name', 'Shopping Centers & Malls', 'data'),
(NULL, 67, 'pjCategory', 3, 'name', 'Shopping Centers & Malls', 'data'),
(NULL, 68, 'pjCategory', 1, 'name', 'Tattoos', 'data'),
(NULL, 68, 'pjCategory', 2, 'name', 'Tattoos', 'data'),
(NULL, 68, 'pjCategory', 3, 'name', 'Tattoos', 'data'),
(NULL, 69, 'pjCategory', 1, 'name', 'Taxis', 'data'),
(NULL, 69, 'pjCategory', 2, 'name', 'Taxis', 'data'),
(NULL, 69, 'pjCategory', 3, 'name', 'Taxis', 'data'),
(NULL, 70, 'pjCategory', 1, 'name', 'Tire Dealers', 'data'),
(NULL, 70, 'pjCategory', 2, 'name', 'Tire Dealers', 'data'),
(NULL, 70, 'pjCategory', 3, 'name', 'Tire Dealers', 'data'),
(NULL, 71, 'pjCategory', 1, 'name', 'Tree Service', 'data'),
(NULL, 71, 'pjCategory', 2, 'name', 'Tree Service', 'data'),
(NULL, 71, 'pjCategory', 3, 'name', 'Tree Service', 'data'),
(NULL, 72, 'pjCategory', 1, 'name', 'Used Car Dealers', 'data'),
(NULL, 72, 'pjCategory', 2, 'name', 'Used Car Dealers', 'data'),
(NULL, 72, 'pjCategory', 3, 'name', 'Used Car Dealers', 'data'),
(NULL, 73, 'pjCategory', 1, 'name', 'Vehicle License & Registration Guinea', 'data'),
(NULL, 73, 'pjCategory', 2, 'name', 'Vehicle License & Registration Guinea', 'data'),
(NULL, 73, 'pjCategory', 3, 'name', 'Vehicle License & Registration Guinea', 'data'),
(NULL, 74, 'pjCategory', 1, 'name', 'Veterinarians', 'data'),
(NULL, 74, 'pjCategory', 2, 'name', 'Veterinarians', 'data'),
(NULL, 74, 'pjCategory', 3, 'name', 'Veterinarians', 'data'),
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of your listing you wish to edit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Click on the flag icon to choose which language version of your listing you wish to edit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Click on the flag icon to choose which language version of your listing you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script');
INSERT INTO `yellowpages_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 323, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 323, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 324, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 324, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Number of listings per page', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Number of listings per page', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Number of listings per page', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Email address used for email notifications', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Email address used for email notifications', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Email address used for email notifications', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Submissions', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Submissions', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Submissions', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Listing Submissions by Users', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'Listing Submissions by Users', 'script'),
(NULL, 329, 'pjField', 3, 'title', 'Listing Submissions by Users', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'You can allow/disallow website users to submit their own listings after registering into the system. These users are named ''owners''. You can manage owners'''' accounts through Users menu. You can also charge owners for publishing their listings. If you wish to enable user submissions set carefully all options bellow and also set the Emails tab options.', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'You can allow/disallow website users to submit their own listings after registering into the system. These users are named ''owners''. You can manage owners'''' accounts through Users menu. You can also charge owners for publishing their listings. If you wish to enable user submissions set carefully all options bellow and also set the Emails tab options.', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'You can allow/disallow website users to submit their own listings after registering into the system. These users are named ''owners''. You can manage owners'''' accounts through Users menu. You can also charge owners for publishing their listings. If you wish to enable user submissions set carefully all options bellow and also set the Emails tab options.', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Allow users to add listing', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'Allow users to add listing', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'Allow users to add listing', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'User account confirmed by default', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'User account confirmed by default', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'User account confirmed by default', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Set prices for submitting listings by owners. You can charge different price according to the length of time that the listing is active (visible) on your listing page. To do this add and manage ''''period / price'''' rows below. If you wish to set a ''''free trial'''' period then set the number of the days and set ''''0'''' into the price field. If you do not wish to charge owners for submitting their listings, then leave just one ''''period / price'''' row, define a relevant large number of days into the period filed, and set ''''0'''' into the price field.', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'Set prices for submitting listings by owners. You can charge different price according to the length of time that the listing is active (visible) on your listing page. To do this add and manage ''''period / price'''' rows below. If you wish to set a ''''free trial'''' period then set the number of the days and set ''''0'''' into the price field. If you do not wish to charge owners for submitting their listings, then leave just one ''''period / price'''' row, define a relevant large number of days into the period filed, and set ''''0'''' into the price field.', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'Set prices for submitting listings by owners. You can charge different price according to the length of time that the listing is active (visible) on your listing page. To do this add and manage ''''period / price'''' rows below. If you wish to set a ''''free trial'''' period then set the number of the days and set ''''0'''' into the price field. If you do not wish to charge owners for submitting their listings, then leave just one ''''period / price'''' row, define a relevant large number of days into the period filed, and set ''''0'''' into the price field.', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Paypal email address', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Paypal email address', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Paypal email address', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'Period', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'Period', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Add period / Price', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'Add period / Price', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'Add period / Price', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Delete period', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Delete period', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Delete period', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Are you sure that you want to delete this period / price?', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'Are you sure that you want to delete this period / price?', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'Are you sure that you want to delete this period / price?', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Submissions updated', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Submissions updated', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Submissions updated', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'All changes made to the submissions have been saved.', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'All changes made to the submissions have been saved.', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'All changes made to the submissions have been saved.', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Mobile', 'script'),
(NULL, 345, 'pjField', 2, 'title', 'Mobile', 'script'),
(NULL, 345, 'pjField', 3, 'title', 'Mobile', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'Fax', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'Fax', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Countries', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'Countries', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'Countries', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Category updated', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'Category updated', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'Category updated', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 354, 'pjField', 2, 'title', 'Category added', 'script'),
(NULL, 354, 'pjField', 3, 'title', 'Category added', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 355, 'pjField', 2, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 355, 'pjField', 3, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Category failed to add', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Category failed to add', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Category failed to add', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'We are sorry that the category could not be added.', 'script'),
(NULL, 357, 'pjField', 2, 'title', 'We are sorry that the category could not be added.', 'script'),
(NULL, 357, 'pjField', 3, 'title', 'We are sorry that the category could not be added.', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 358, 'pjField', 2, 'title', 'Category not found', 'script'),
(NULL, 358, 'pjField', 3, 'title', 'Category not found', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'The category you are looking for is missing.', 'script'),
(NULL, 359, 'pjField', 2, 'title', 'The category you are looking for is missing.', 'script'),
(NULL, 359, 'pjField', 3, 'title', 'The category you are looking for is missing.', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Country updated', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Country updated', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Country updated', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'All changes made to the country have been saved.', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'All changes made to the country have been saved.', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'All changes made to the country have been saved.', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Country added', 'script'),
(NULL, 362, 'pjField', 2, 'title', 'Country added', 'script'),
(NULL, 362, 'pjField', 3, 'title', 'Country added', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'A new country has been added to the list.', 'script'),
(NULL, 363, 'pjField', 2, 'title', 'A new country has been added to the list.', 'script'),
(NULL, 363, 'pjField', 3, 'title', 'A new country has been added to the list.', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Country failed to add', 'script'),
(NULL, 364, 'pjField', 2, 'title', 'Country failed to add', 'script'),
(NULL, 364, 'pjField', 3, 'title', 'Country failed to add', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'We are sorry that the country could not be saved.', 'script'),
(NULL, 365, 'pjField', 2, 'title', 'We are sorry that the country could not be saved.', 'script'),
(NULL, 365, 'pjField', 3, 'title', 'We are sorry that the country could not be saved.', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Country not found', 'script'),
(NULL, 366, 'pjField', 2, 'title', 'Country not found', 'script'),
(NULL, 366, 'pjField', 3, 'title', 'Country not found', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'The country you are looking for is missing.', 'script'),
(NULL, 367, 'pjField', 2, 'title', 'The country you are looking for is missing.', 'script'),
(NULL, 367, 'pjField', 3, 'title', 'The country you are looking for is missing.', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 368, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 368, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 369, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 369, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 370, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 370, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Category was already in use.', 'script'),
(NULL, 371, 'pjField', 2, 'title', 'Category was already in use.', 'script'),
(NULL, 371, 'pjField', 3, 'title', 'Category was already in use.', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 372, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 372, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 373, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 373, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Listings', 'script'),
(NULL, 374, 'pjField', 2, 'title', 'Listings', 'script'),
(NULL, 374, 'pjField', 3, 'title', 'Listings', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Listing updated', 'script'),
(NULL, 375, 'pjField', 2, 'title', 'Listing updated', 'script'),
(NULL, 375, 'pjField', 3, 'title', 'Listing updated', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Listing added', 'script'),
(NULL, 376, 'pjField', 2, 'title', 'Listing added', 'script'),
(NULL, 376, 'pjField', 3, 'title', 'Listing added', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Listing failed to add', 'script'),
(NULL, 377, 'pjField', 2, 'title', 'Listing failed to add', 'script'),
(NULL, 377, 'pjField', 3, 'title', 'Listing failed to add', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Listing not found', 'script'),
(NULL, 378, 'pjField', 2, 'title', 'Listing not found', 'script'),
(NULL, 378, 'pjField', 3, 'title', 'Listing not found', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'All changes made to the listing have been saved.', 'script'),
(NULL, 379, 'pjField', 2, 'title', 'All changes made to the listing have been saved.', 'script'),
(NULL, 379, 'pjField', 3, 'title', 'All changes made to the listing have been saved.', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'A new listing has been added.', 'script'),
(NULL, 380, 'pjField', 2, 'title', 'A new listing has been added.', 'script'),
(NULL, 380, 'pjField', 3, 'title', 'A new listing has been added.', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'We sorry that the listing has not been saved.', 'script'),
(NULL, 381, 'pjField', 2, 'title', 'We sorry that the listing has not been saved.', 'script'),
(NULL, 381, 'pjField', 3, 'title', 'We sorry that the listing has not been saved.', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'The listing you are looking for is missing.', 'script'),
(NULL, 382, 'pjField', 2, 'title', 'The listing you are looking for is missing.', 'script'),
(NULL, 382, 'pjField', 3, 'title', 'The listing you are looking for is missing.', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Add listing', 'script'),
(NULL, 383, 'pjField', 2, 'title', 'Add listing', 'script'),
(NULL, 383, 'pjField', 3, 'title', 'Add listing', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 384, 'pjField', 2, 'title', 'Image', 'script'),
(NULL, 384, 'pjField', 3, 'title', 'Image', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Ref ID', 'script'),
(NULL, 385, 'pjField', 2, 'title', 'Ref ID', 'script'),
(NULL, 385, 'pjField', 3, 'title', 'Ref ID', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 386, 'pjField', 2, 'title', 'Owner', 'script'),
(NULL, 386, 'pjField', 3, 'title', 'Owner', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Expire', 'script'),
(NULL, 387, 'pjField', 2, 'title', 'Expire', 'script'),
(NULL, 387, 'pjField', 3, 'title', 'Expire', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Publish', 'script'),
(NULL, 388, 'pjField', 2, 'title', 'Publish', 'script'),
(NULL, 388, 'pjField', 3, 'title', 'Publish', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Exp. date', 'script'),
(NULL, 391, 'pjField', 2, 'title', 'Exp. date', 'script'),
(NULL, 391, 'pjField', 3, 'title', 'Exp. date', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Published', 'script'),
(NULL, 392, 'pjField', 2, 'title', 'Published', 'script'),
(NULL, 392, 'pjField', 3, 'title', 'Published', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Not published', 'script'),
(NULL, 393, 'pjField', 2, 'title', 'Not published', 'script'),
(NULL, 393, 'pjField', 3, 'title', 'Not published', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Extend expiration date', 'script'),
(NULL, 394, 'pjField', 2, 'title', 'Extend expiration date', 'script'),
(NULL, 394, 'pjField', 3, 'title', 'Extend expiration date', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 395, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 395, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 396, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 396, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'never', 'script'),
(NULL, 397, 'pjField', 2, 'title', 'never', 'script'),
(NULL, 397, 'pjField', 3, 'title', 'never', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'No permission', 'script'),
(NULL, 398, 'pjField', 2, 'title', 'No permission', 'script'),
(NULL, 398, 'pjField', 3, 'title', 'No permission', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'We are sorry that you have no permission to add or edit car.', 'script'),
(NULL, 399, 'pjField', 2, 'title', 'We are sorry that you have no permission to add or edit car.', 'script'),
(NULL, 399, 'pjField', 3, 'title', 'We are sorry that you have no permission to add or edit car.', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Invalid data', 'script'),
(NULL, 400, 'pjField', 2, 'title', 'Invalid data', 'script'),
(NULL, 400, 'pjField', 3, 'title', 'Invalid data', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'We are sorry that you have entered invalid data.', 'script'),
(NULL, 401, 'pjField', 2, 'title', 'We are sorry that you have entered invalid data.', 'script'),
(NULL, 401, 'pjField', 3, 'title', 'We are sorry that you have entered invalid data.', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Existing reference ID', 'script'),
(NULL, 402, 'pjField', 2, 'title', 'Existing reference ID', 'script'),
(NULL, 402, 'pjField', 3, 'title', 'Existing reference ID', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'You have entered an existing reference ID.', 'script'),
(NULL, 403, 'pjField', 2, 'title', 'You have entered an existing reference ID.', 'script'),
(NULL, 403, 'pjField', 3, 'title', 'You have entered an existing reference ID.', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Add new listing', 'script'),
(NULL, 404, 'pjField', 2, 'title', 'Add new listing', 'script'),
(NULL, 404, 'pjField', 3, 'title', 'Add new listing', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Start adding a new listing with entering the main details about it. On the next step you will be able to enter additional information about the listing. You can manage available categories under Options page, Categories tabs.', 'script'),
(NULL, 405, 'pjField', 2, 'title', 'Start adding a new listing with entering the main details about it. On the next step you will be able to enter additional information about the listing. You can manage available categories under Options page, Categories tabs.', 'script'),
(NULL, 405, 'pjField', 3, 'title', 'Start adding a new listing with entering the main details about it. On the next step you will be able to enter additional information about the listing. You can manage available categories under Options page, Categories tabs.', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Publish', 'script'),
(NULL, 407, 'pjField', 2, 'title', 'Publish', 'script'),
(NULL, 407, 'pjField', 3, 'title', 'Publish', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Expire date', 'script'),
(NULL, 408, 'pjField', 2, 'title', 'Expire date', 'script'),
(NULL, 408, 'pjField', 3, 'title', 'Expire date', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 409, 'pjField', 2, 'title', 'Owner', 'script'),
(NULL, 409, 'pjField', 3, 'title', 'Owner', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Show owner contact', 'script'),
(NULL, 410, 'pjField', 2, 'title', 'Show owner contact', 'script'),
(NULL, 410, 'pjField', 3, 'title', 'Show owner contact', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Select ''Yes'' if you want to show owner contact on the front-end. Otherwise, please select ''No''.', 'script'),
(NULL, 411, 'pjField', 2, 'title', 'Select ''Yes'' if you want to show owner contact on the front-end. Otherwise, please select ''No''.', 'script'),
(NULL, 411, 'pjField', 3, 'title', 'Select ''Yes'' if you want to show owner contact on the front-end. Otherwise, please select ''No''.', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Set a date until the listing will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 412, 'pjField', 2, 'title', 'Set a date until the listing will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 412, 'pjField', 3, 'title', 'Set a date until the listing will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Publish the listing permanently, hide it or publish until the expiration date set.', 'script'),
(NULL, 413, 'pjField', 2, 'title', 'Publish the listing permanently, hide it or publish until the expiration date set.', 'script'),
(NULL, 413, 'pjField', 3, 'title', 'Publish the listing permanently, hide it or publish until the expiration date set.', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 414, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 414, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 415, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 415, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Based on expiration date', 'script'),
(NULL, 416, 'pjField', 2, 'title', 'Based on expiration date', 'script'),
(NULL, 416, 'pjField', 3, 'title', 'Based on expiration date', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 417, 'pjField', 2, 'title', 'Summary', 'script'),
(NULL, 417, 'pjField', 3, 'title', 'Summary', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 418, 'pjField', 2, 'title', 'Details', 'script'),
(NULL, 418, 'pjField', 3, 'title', 'Details', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 419, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 419, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 420, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 420, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 421, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 421, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 422, 'pjField', 2, 'title', 'SEO', 'script'),
(NULL, 422, 'pjField', 3, 'title', 'SEO', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 423, 'pjField', 2, 'title', 'Created', 'script'),
(NULL, 423, 'pjField', 3, 'title', 'Created', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Modified', 'script'),
(NULL, 424, 'pjField', 2, 'title', 'Modified', 'script'),
(NULL, 424, 'pjField', 3, 'title', 'Modified', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 425, 'pjField', 2, 'title', 'Views', 'script'),
(NULL, 425, 'pjField', 3, 'title', 'Views', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Listing detail title', 'script'),
(NULL, 426, 'pjField', 2, 'title', 'Listing detail title', 'script'),
(NULL, 426, 'pjField', 3, 'title', 'Listing detail title', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Listing detail body', 'script'),
(NULL, 427, 'pjField', 2, 'title', 'Listing detail body', 'script'),
(NULL, 427, 'pjField', 3, 'title', 'Listing detail body', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 428, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 428, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 430, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 430, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Assign the listing to any of the available categories below. You can assign each listing to one or multiple categories. If you do not assign a category listing will not appear on the front end.', 'script'),
(NULL, 431, 'pjField', 2, 'title', 'Assign the listing to any of the available categories below. You can assign each listing to one or multiple categories. If you do not assign a category listing will not appear on the front end.', 'script'),
(NULL, 431, 'pjField', 3, 'title', 'Assign the listing to any of the available categories below. You can assign each listing to one or multiple categories. If you do not assign a category listing will not appear on the front end.', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 432, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 432, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Upload as many images as you want for this car. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 433, 'pjField', 2, 'title', 'Upload as many images as you want for this car. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 433, 'pjField', 3, 'title', 'Upload as many images as you want for this car. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Show on map', 'script'),
(NULL, 435, 'pjField', 2, 'title', 'Show on map', 'script'),
(NULL, 435, 'pjField', 3, 'title', 'Show on map', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 436, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 436, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 437, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 437, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 438, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 438, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 439, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 439, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 440, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 440, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Click on the button to get the location coordinates from Google Maps API. The full address should be submitted above first. You can also enter long/lat coordinates for your listing on your own.', 'script'),
(NULL, 441, 'pjField', 2, 'title', 'Click on the button to get the location coordinates from Google Maps API. The full address should be submitted above first. You can also enter long/lat coordinates for your listing on your own.', 'script'),
(NULL, 441, 'pjField', 3, 'title', 'Click on the button to get the location coordinates from Google Maps API. The full address should be submitted above first. You can also enter long/lat coordinates for your listing on your own.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Get coordinates from Google Maps API', 'script'),
(NULL, 442, 'pjField', 2, 'title', 'Get coordinates from Google Maps API', 'script'),
(NULL, 442, 'pjField', 3, 'title', 'Get coordinates from Google Maps API', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Latitude', 'script'),
(NULL, 443, 'pjField', 2, 'title', 'Latitude', 'script'),
(NULL, 443, 'pjField', 3, 'title', 'Latitude', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Longitude', 'script'),
(NULL, 444, 'pjField', 2, 'title', 'Longitude', 'script'),
(NULL, 444, 'pjField', 3, 'title', 'Longitude', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'SEO settings', 'script'),
(NULL, 445, 'pjField', 2, 'title', 'SEO settings', 'script'),
(NULL, 445, 'pjField', 3, 'title', 'SEO settings', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your listing details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 446, 'pjField', 2, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your listing details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 446, 'pjField', 3, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your listing details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Meta title', 'script'),
(NULL, 447, 'pjField', 2, 'title', 'Meta title', 'script'),
(NULL, 447, 'pjField', 3, 'title', 'Meta title', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Meta keywords', 'script'),
(NULL, 448, 'pjField', 2, 'title', 'Meta keywords', 'script'),
(NULL, 448, 'pjField', 3, 'title', 'Meta keywords', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Meta description', 'script'),
(NULL, 449, 'pjField', 2, 'title', 'Meta description', 'script'),
(NULL, 449, 'pjField', 3, 'title', 'Meta description', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'n/a', 'script'),
(NULL, 450, 'pjField', 2, 'title', 'n/a', 'script'),
(NULL, 450, 'pjField', 3, 'title', 'n/a', 'script'),
(NULL, 451, 'pjField', 2, 'title', 'Address not found', 'script'),
(NULL, 451, 'pjField', 3, 'title', 'Address not found', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Address not found', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Keyword', 'script'),
(NULL, 452, 'pjField', 2, 'title', 'Keyword', 'script'),
(NULL, 452, 'pjField', 3, 'title', 'Keyword', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 453, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 453, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Expiration date +30 days', 'script'),
(NULL, 454, 'pjField', 2, 'title', 'Expiration date +30 days', 'script'),
(NULL, 454, 'pjField', 3, 'title', 'Expiration date +30 days', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Are you sure that you want to extend selected listing(s) for 30 days?', 'script'),
(NULL, 455, 'pjField', 2, 'title', 'Are you sure that you want to extend selected listing(s) for 30 days?', 'script'),
(NULL, 455, 'pjField', 3, 'title', 'Are you sure that you want to extend selected listing(s) for 30 days?', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Extend expire date', 'script'),
(NULL, 456, 'pjField', 2, 'title', 'Extend expire date', 'script'),
(NULL, 456, 'pjField', 3, 'title', 'Extend expire date', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 457, 'pjField', 2, 'title', 'Period', 'script'),
(NULL, 457, 'pjField', 3, 'title', 'Period', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 458, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 458, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Buy now', 'script'),
(NULL, 460, 'pjField', 2, 'title', 'Buy now', 'script'),
(NULL, 460, 'pjField', 3, 'title', 'Buy now', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'FREE', 'script'),
(NULL, 461, 'pjField', 2, 'title', 'FREE', 'script'),
(NULL, 461, 'pjField', 3, 'title', 'FREE', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Extend your period for FREE', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'Extend your period for FREE', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'Extend your period for FREE', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Listing', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'Listing', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'Listing', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'Optional', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'Optional', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Installation settings updated', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'Installation settings updated', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'Installation settings updated', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Your configuration settings have been saved.', 'script'),
(NULL, 468, 'pjField', 2, 'title', 'Your configuration settings have been saved.', 'script'),
(NULL, 468, 'pjField', 3, 'title', 'Your configuration settings have been saved.', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 469, 'pjField', 2, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 469, 'pjField', 3, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 470, 'pjField', 2, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 470, 'pjField', 3, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 472, 'pjField', 2, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 472, 'pjField', 3, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 474, 'pjField', 1, 'title', ' Use SEO Friendly URLs', 'script'),
(NULL, 474, 'pjField', 2, 'title', ' Use SEO Friendly URLs', 'script'),
(NULL, 474, 'pjField', 3, 'title', ' Use SEO Friendly URLs', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 476, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 476, 'pjField', 2, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 476, 'pjField', 3, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 546, 'pjField', 2, 'title', 'Email notifications', 'script'),
(NULL, 546, 'pjField', 3, 'title', 'Email notifications', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emails subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized.', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emails subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized.', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emails subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'New user account notification', 'script'),
(NULL, 548, 'pjField', 2, 'title', 'New user account notification', 'script'),
(NULL, 548, 'pjField', 3, 'title', 'New user account notification', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'New user account notification will be sent to all of the administrators of your website. There are 2 available tokens Email and Full Name.', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'New user account notification will be sent to all of the administrators of your website. There are 2 available tokens Email and Full Name.', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'New user account notification will be sent to all of the administrators of your website. There are 2 available tokens Email and Full Name.', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Available tokens:\r\n\r\n{Email} - Email\r\n{Name} - Full name', 'script'),
(NULL, 552, 'pjField', 2, 'title', 'Available tokens:\r\n\r\n{Email} - Email\r\n{Name} - Full name', 'script'),
(NULL, 552, 'pjField', 3, 'title', 'Available tokens:\r\n\r\n{Email} - Email\r\n{Name} - Full name', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 553, 'pjField', 2, 'title', 'Emails', 'script'),
(NULL, 553, 'pjField', 3, 'title', 'Emails', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Email settings updated', 'script'),
(NULL, 554, 'pjField', 2, 'title', 'Email settings updated', 'script'),
(NULL, 554, 'pjField', 3, 'title', 'Email settings updated', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'All changes made to email settings have been saved.', 'script'),
(NULL, 555, 'pjField', 2, 'title', 'All changes made to email settings have been saved.', 'script'),
(NULL, 555, 'pjField', 3, 'title', 'All changes made to email settings have been saved.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 556, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 556, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'Home', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'Home', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'Map', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'Map', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Account', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'Account', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'Account', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Filter by Category', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Filter by Category', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Filter by Category', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Order by:', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'Order by:', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'Order by:', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Alphabetically', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Alphabetically', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Alphabetically', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Date added', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Date added', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Date added', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'There are no listings found.', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'There are no listings found.', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'There are no listings found.', 'script');
INSERT INTO `yellowpages_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 566, 'pjField', 1, 'title', 'View more', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'View more', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'View more', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'back', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'back', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'back', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Enter your address', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'Enter your address', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'Enter your address', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Directions', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'Directions', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'Directions', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Sharing the listing via sending email', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Sharing the listing via sending email', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Sharing the listing via sending email', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'To', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 580, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 580, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 581, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 581, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 582, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 582, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Url', 'script'),
(NULL, 583, 'pjField', 2, 'title', 'Url', 'script'),
(NULL, 583, 'pjField', 3, 'title', 'Url', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 584, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 584, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 585, 'pjField', 2, 'title', 'Register', 'script'),
(NULL, 585, 'pjField', 3, 'title', 'Register', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 586, 'pjField', 2, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 586, 'pjField', 3, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 587, 'pjField', 2, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 587, 'pjField', 3, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 588, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 588, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 589, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 589, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Full name', 'script'),
(NULL, 590, 'pjField', 2, 'title', 'Full name', 'script'),
(NULL, 590, 'pjField', 3, 'title', 'Full name', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 591, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 591, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 592, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 592, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 593, 'pjField', 2, 'title', 'Email is required.', 'script'),
(NULL, 593, 'pjField', 3, 'title', 'Email is required.', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 595, 'pjField', 2, 'title', 'Password is required.', 'script'),
(NULL, 595, 'pjField', 3, 'title', 'Password is required.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Full name is required.', 'script'),
(NULL, 596, 'pjField', 2, 'title', 'Full name is required.', 'script'),
(NULL, 596, 'pjField', 3, 'title', 'Full name is required.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 597, 'pjField', 2, 'title', 'Captcha is required.', 'script'),
(NULL, 597, 'pjField', 3, 'title', 'Captcha is required.', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 598, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 598, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Email was already in use.', 'script'),
(NULL, 599, 'pjField', 2, 'title', 'Email was already in use.', 'script'),
(NULL, 599, 'pjField', 3, 'title', 'Email was already in use.', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 600, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 600, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 601, 'pjField', 2, 'title', 'Password is missing.', 'script'),
(NULL, 601, 'pjField', 3, 'title', 'Password is missing.', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Full name is missing.', 'script'),
(NULL, 602, 'pjField', 2, 'title', 'Full name is missing.', 'script'),
(NULL, 602, 'pjField', 3, 'title', 'Full name is missing.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 603, 'pjField', 2, 'title', 'Captcha is missing.', 'script'),
(NULL, 603, 'pjField', 3, 'title', 'Captcha is missing.', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 604, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 604, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 605, 'pjField', 2, 'title', 'Password cannot be empty.', 'script'),
(NULL, 605, 'pjField', 3, 'title', 'Password cannot be empty.', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Full name cannot be empty.', 'script'),
(NULL, 606, 'pjField', 2, 'title', 'Full name cannot be empty.', 'script'),
(NULL, 606, 'pjField', 3, 'title', 'Full name cannot be empty.', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 607, 'pjField', 2, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 607, 'pjField', 3, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 608, 'pjField', 2, 'title', 'Captcha is not correct.', 'script'),
(NULL, 608, 'pjField', 3, 'title', 'Captcha is not correct.', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Email was already in use.', 'script'),
(NULL, 609, 'pjField', 2, 'title', 'Email was already in use.', 'script'),
(NULL, 609, 'pjField', 3, 'title', 'Email was already in use.', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Your account has been created successfully. It was also activated, so you can start to login now.', 'script'),
(NULL, 610, 'pjField', 2, 'title', 'Your account has been created successfully. It was also activated, so you can start to login now.', 'script'),
(NULL, 610, 'pjField', 3, 'title', 'Your account has been created successfully. It was also activated, so you can start to login now.', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Your account has been created successfully. However, you need to wait for the confirmation of the administrator', 'script'),
(NULL, 611, 'pjField', 2, 'title', 'Your account has been created successfully. However, you need to wait for the confirmation of the administrator', 'script'),
(NULL, 611, 'pjField', 3, 'title', 'Your account has been created successfully. However, you need to wait for the confirmation of the administrator', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 612, 'pjField', 2, 'title', 'Forgot password?', 'script'),
(NULL, 612, 'pjField', 3, 'title', 'Forgot password?', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 614, 'pjField', 2, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 614, 'pjField', 3, 'title', 'Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Password recovery', 'script'),
(NULL, 615, 'pjField', 2, 'title', 'Password recovery', 'script'),
(NULL, 615, 'pjField', 3, 'title', 'Password recovery', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'This is the email will be sent to users in case they sent a request for recovering their password.', 'script'),
(NULL, 616, 'pjField', 2, 'title', 'This is the email will be sent to users in case they sent a request for recovering their password.', 'script'),
(NULL, 616, 'pjField', 3, 'title', 'This is the email will be sent to users in case they sent a request for recovering their password.', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Available tokens:\r\n\r\n{Name} - Full name\r\n{Password} - Password', 'script'),
(NULL, 617, 'pjField', 2, 'title', 'Available tokens:\r\n\r\n{Name} - Full name\r\n{Password} - Password', 'script'),
(NULL, 617, 'pjField', 3, 'title', 'Available tokens:\r\n\r\n{Name} - Full name\r\n{Password} - Password', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 618, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 618, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 619, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 619, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Email does not exist in our system.', 'script'),
(NULL, 620, 'pjField', 2, 'title', 'Email does not exist in our system.', 'script'),
(NULL, 620, 'pjField', 3, 'title', 'Email does not exist in our system.', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Password has been sent to your email address.', 'script'),
(NULL, 621, 'pjField', 2, 'title', 'Password has been sent to your email address.', 'script'),
(NULL, 621, 'pjField', 3, 'title', 'Password has been sent to your email address.', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Contact', 'script'),
(NULL, 623, 'pjField', 2, 'title', 'Contact', 'script'),
(NULL, 623, 'pjField', 3, 'title', 'Contact', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Listings', 'script'),
(NULL, 624, 'pjField', 2, 'title', 'Listings', 'script'),
(NULL, 624, 'pjField', 3, 'title', 'Listings', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Listing', 'script'),
(NULL, 625, 'pjField', 2, 'title', 'Listing', 'script'),
(NULL, 625, 'pjField', 3, 'title', 'Listing', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Listings expire today', 'script'),
(NULL, 626, 'pjField', 2, 'title', 'Listings expire today', 'script'),
(NULL, 626, 'pjField', 3, 'title', 'Listings expire today', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Listing expire today', 'script'),
(NULL, 627, 'pjField', 2, 'title', 'Listing expire today', 'script'),
(NULL, 627, 'pjField', 3, 'title', 'Listing expire today', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 628, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 628, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 629, 'pjField', 2, 'title', 'User', 'script'),
(NULL, 629, 'pjField', 3, 'title', 'User', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Most Popular Listings', 'script'),
(NULL, 630, 'pjField', 2, 'title', 'Most Popular Listings', 'script'),
(NULL, 630, 'pjField', 3, 'title', 'Most Popular Listings', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Latest Added Listings', 'script'),
(NULL, 631, 'pjField', 2, 'title', 'Latest Added Listings', 'script'),
(NULL, 631, 'pjField', 3, 'title', 'Latest Added Listings', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Latest Registered Users', 'script'),
(NULL, 632, 'pjField', 2, 'title', 'Latest Registered Users', 'script'),
(NULL, 632, 'pjField', 3, 'title', 'Latest Registered Users', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Listing not found', 'script'),
(NULL, 633, 'pjField', 2, 'title', 'Listing not found', 'script'),
(NULL, 633, 'pjField', 3, 'title', 'Listing not found', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 634, 'pjField', 2, 'title', 'Views', 'script'),
(NULL, 634, 'pjField', 3, 'title', 'Views', 'script'),
(NULL, 635, 'pjField', 2, 'title', 'View', 'script'),
(NULL, 635, 'pjField', 3, 'title', 'View', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'User not found', 'script'),
(NULL, 636, 'pjField', 2, 'title', 'User not found', 'script'),
(NULL, 636, 'pjField', 3, 'title', 'User not found', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 637, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 637, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 638, 'pjField', 2, 'title', 'Import', 'script'),
(NULL, 638, 'pjField', 3, 'title', 'Import', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Import Listings', 'script'),
(NULL, 639, 'pjField', 2, 'title', 'Import Listings', 'script'),
(NULL, 639, 'pjField', 3, 'title', 'Import Listings', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'You can import a CSV file with listings data. Please, add a listing manually using the Add Lsting form and then export it from the Listing lists, bottom button "Choose action". This is the format of the required CSV file for import.', 'script'),
(NULL, 640, 'pjField', 2, 'title', 'You can import a CSV file with listings data. Please, add a listing manually using the Add Lsting form and then export it from the Listing lists, bottom button "Choose action". This is the format of the required CSV file for import.', 'script'),
(NULL, 640, 'pjField', 3, 'title', 'You can import a CSV file with listings data. Please, add a listing manually using the Add Lsting form and then export it from the Listing lists, bottom button "Choose action". This is the format of the required CSV file for import.', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Listings imported', 'script'),
(NULL, 641, 'pjField', 2, 'title', 'Listings imported', 'script'),
(NULL, 641, 'pjField', 3, 'title', 'Listings imported', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'The listing csv file has been imported successfully.', 'script'),
(NULL, 642, 'pjField', 2, 'title', 'The listing csv file has been imported successfully.', 'script'),
(NULL, 642, 'pjField', 3, 'title', 'The listing csv file has been imported successfully.', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'CSV file missing', 'script'),
(NULL, 643, 'pjField', 2, 'title', 'CSV file missing', 'script'),
(NULL, 643, 'pjField', 3, 'title', 'CSV file missing', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Importing listings could not be processed because of missing of csv file.', 'script'),
(NULL, 644, 'pjField', 2, 'title', 'Importing listings could not be processed because of missing of csv file.', 'script'),
(NULL, 644, 'pjField', 3, 'title', 'Importing listings could not be processed because of missing of csv file.', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'File type error', 'script'),
(NULL, 645, 'pjField', 2, 'title', 'File type error', 'script'),
(NULL, 645, 'pjField', 3, 'title', 'File type error', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 646, 'pjField', 2, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 646, 'pjField', 3, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'CSV file', 'script'),
(NULL, 647, 'pjField', 2, 'title', 'CSV file', 'script'),
(NULL, 647, 'pjField', 3, 'title', 'CSV file', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 743, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 743, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 744, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 744, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Mobile', 'script'),
(NULL, 745, 'pjField', 2, 'title', 'Mobile', 'script'),
(NULL, 745, 'pjField', 3, 'title', 'Mobile', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 746, 'pjField', 2, 'title', 'Fax', 'script'),
(NULL, 746, 'pjField', 3, 'title', 'Fax', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 747, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 747, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'New listing notification', 'script'),
(NULL, 748, 'pjField', 2, 'title', 'New listing notification', 'script'),
(NULL, 748, 'pjField', 3, 'title', 'New listing notification', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'New listing notification will be sent to all of administrators of your website. There are some available tokens below.', 'script'),
(NULL, 749, 'pjField', 2, 'title', 'New listing notification will be sent to all of administrators of your website. There are some available tokens below.', 'script'),
(NULL, 749, 'pjField', 3, 'title', 'New listing notification will be sent to all of administrators of your website. There are some available tokens below.', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Available tokens:\r\n\r\n{Name} - Owner name\r\n{Email} - Owner email\r\n{ListingRefID} - Listing RefID\r\n{ListingURL} - Listing URL', 'script'),
(NULL, 750, 'pjField', 2, 'title', 'Available tokens:\r\n\r\n{Name} - Owner name\r\n{Email} - Owner email\r\n{ListingRefID} - Listing RefID\r\n{ListingURL} - Listing URL', 'script'),
(NULL, 750, 'pjField', 3, 'title', 'Available tokens:\r\n\r\n{Name} - Owner name\r\n{Email} - Owner email\r\n{ListingRefID} - Listing RefID\r\n{ListingURL} - Listing URL', 'script'),
(NULL, 1, 'pjNotification', 1, 'new_account_subject', 'New user account notification', 'data'),
(NULL, 1, 'pjNotification', 1, 'new_account_message', 'Hi,\r\n\r\nThere is new user account created. Below is the detail information of the account.\r\n\r\nFull name: {Name}\r\nEmail: {Email}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 2, 'new_account_subject', 'New user account notification', 'data'),
(NULL, 1, 'pjNotification', 2, 'new_account_message', 'Hi,\r\n\r\nThere is new user account created. Below is the detail information of the account.\r\n\r\nFull name: {Name}\r\nEmail: {Email}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 3, 'new_account_subject', 'New user account notification', 'data'),
(NULL, 1, 'pjNotification', 3, 'new_account_message', 'Hi,\r\n\r\nThere is new user account created. Below is the detail information of the account.\r\n\r\nFull name: {Name}\r\nEmail: {Email}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 1, 'forgot_subject', 'Password recovery', 'data'),
(NULL, 1, 'pjNotification', 1, 'forgot_message', 'Hi {Name},\r\n\r\nWe have received a password recovery request by this email. Please, find below your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 3, 'forgot_subject', 'Password recovery', 'data'),
(NULL, 1, 'pjNotification', 3, 'forgot_message', 'Hi {Name},\r\n\r\nWe have received a password recovery request by this email. Please, find below your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 2, 'forgot_subject', 'Password recovery', 'data'),
(NULL, 1, 'pjNotification', 2, 'forgot_message', 'Hi {Name},\r\n\r\nWe have received a password recovery request by this email. Please, find below your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 1, 'new_listing_subject', 'New listing notification', 'data'),
(NULL, 1, 'pjNotification', 1, 'new_listing_message', 'Hi,\r\n\r\nA new listing has been posted. Here are some detail information related to the listing.\r\n\r\nOwner name: {Name}\r\nOwner email: {Email}\r\nListing Reference ID: {ListingRefID}\r\n\r\nPlease click on this link to view more details about the listing. {ListingURL}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 3, 'new_listing_subject', 'New listing notification', 'data'),
(NULL, 1, 'pjNotification', 3, 'new_listing_message', 'Hi,\r\n\r\nA new listing has been posted. Here are some detail information related to the listing.\r\n\r\nOwner name: {Name}\r\nOwner email: {Email}\r\nListing Reference ID: {ListingRefID}\r\n\r\nPlease click on this link to view more details about the listing. {ListingURL}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjNotification', 2, 'new_listing_subject', 'New listing notification', 'data'),
(NULL, 1, 'pjNotification', 2, 'new_listing_message', 'Hi,\r\n\r\nA new listing has been posted. Here are some detail information related to the listing.\r\n\r\nOwner name: {Name}\r\nOwner email: {Email}\r\nListing Reference ID: {ListingRefID}\r\n\r\nPlease click on this link to view more details about the listing. {ListingURL}\r\n\r\nThanks!', 'data');

INSERT INTO `yellowpages_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_layout', 1, 'layout_1|layout_2::layout_1', 'Layout 1|Layout 2', 'enum', 1, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 3, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 4, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 5, 1, NULL),
(1, 'o_items_per_page', 1, '10', NULL, 'int', 6, 1, NULL),
(1, 'o_email_address', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_allow_add_listing', 2, 'Yes|No::Yes', NULL, 'enum', 2, 1, NULL),
(1, 'o_owner_is_active', 2, 'Yes|No::No', NULL, 'enum', 3, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 4, 1, NULL),
(1, 'o_listing_page', 99, '', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `yellowpages_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');

INSERT INTO `yellowpages_periods` (`id`, `days`, `price`) VALUES
(1, 10, 49.00),
(2, 20, 79.00),
(3, 30, 99.00),
(4, 40, 109.00),
(5, 50, 119.00);