<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	static public function getPageURL()
	{
		$pageURL = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
		if ($_SERVER["SERVER_PORT"] != "80")
		{
			$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		}
		else
		{
			$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		return $pageURL;
	}
	static public function html2txt($document){
		$search = array('@<script[^>]*?>.*?</script>@si', 
		               '@<[\/\!]*?[^<>]*?>@si',           
		               '@<style[^>]*?>.*?</style>@siU',   
		               '@<![\s\S]*?--[ \t\n\r]*>@'    
		);
		$text = preg_replace($search, '', $document);
		return $text;
	}
	
	static public function truncateDescription($string, $limit, $break=".", $pad="..."){
		if(strlen($string) <= $limit) 
			return $string;  
		if(false !== ($breakpoint = strpos($string, $break, $limit))) 
		{ 
			if($breakpoint < strlen($string) - 1) 
			{ 
				$string = substr($string, 0, $breakpoint) . $pad; 
			} 
		} 
		return $string;
	}
	
	static public function getSortingUrl($url)
	{
		$sorting_url = $url;
		$sorting_url = str_replace('&sortby=title', '', $sorting_url);
		$sorting_url = str_replace('&sortby=created', '', $sorting_url);
		$sorting_url = str_replace('&direction=asc', '', $sorting_url);
		$sorting_url = str_replace('&direction=desc', '', $sorting_url);
		return $sorting_url;
	}
	
	static public function getFilterUrl($url, $get)
	{
		$filter_url = $url;
		if(isset($get['category_id']))
		{
			$filter_url = str_replace('&category_id='.$get['category_id'], '', $filter_url);
		}
		return $filter_url;
	}
	
	static public function currPageURL() {
 		$pageURL = 'http';
 		if (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") 
 		{
 			$pageURL .= "s";
 		}
 		$pageURL .= "://";
 		if ($_SERVER["SERVER_PORT"] != "80") 
 		{
  			$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 		} else {
  			$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 		}
 		$parts = parse_url($pageURL);
 		if(isset($parts['query']))
 		{
	 		parse_str($parts['query'], $query);
	 		if(empty($query))
	 		{
	 			$pageURL .= '?controller=pjListings&action=pjActionIndex';
	 		}
 		}
 		
 		return $pageURL;
	}
	static public function textToHtml($content)
	{
		$content = preg_replace('/\r\n|\n/', '<br />', $content);
		return '<html><head><title></title></head><body>'.$content.'</body></html>';
	}
}
?>