<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat listings">
				<div class="info">
					<abbr><?php echo $tpl['cnt_listings'];?></abbr>
					<?php echo (int) $tpl['cnt_listings'] !== 1 ? strtolower(__('lblDashListings', true)) : strtolower(__('lblDashListing', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat listings">
				<div class="info">
					<abbr><?php echo $tpl['cnt_expire_arr'];?></abbr>
					<?php echo (int) $tpl['cnt_expire_arr'] !== 1 ? strtolower(__('lblDashExpiredListings', true)) : strtolower(__('lblDashExpiredListing', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat<?php echo !$controller->isOwner() ? ' users' : null;?>">
				<div class="info">
					<?php
					if(!$controller->isOwner())
					{ 
						?>
						<abbr><?php echo $tpl['cnt_users'];?></abbr>
						<?php echo (int) $tpl['cnt_users'] !== 1 ? strtolower(__('lblDashUsers', true)) : strtolower(__('lblDashUser', true));
					}else{
						echo "&nbsp;";
					} 
					?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashMostPopular');?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestAdded');?></div>
			<div class="dashboard_column_top"><?php echo (!$controller->isOwner()) ? __('lblDashLastUsers', true) : "&nbsp;"; ?></div>
		</div>
		
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['listing_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblListingNotFound'); ?></p><?php
				}else{
					foreach ($tpl['listing_arr'] as $k => $v)
					{
						$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'backend/no-image.png';
						if(!empty($v['pic']))
						{
							if(is_file(PJ_INSTALL_PATH . $v['pic']))
							{
								$image = PJ_INSTALL_URL . $v['pic'];
							}
						}
						?>
						<div class="dashboard_listing_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><img src="<?php echo $image;?>"  /></a>
							<div class="listing-views"><label><?php echo $v['views'];?></label><span><?php echo $v['views'] != 1 ? strtolower(__('lblViews', true)) : strtolower(__('lblView', true)); ?></span></div>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['latest_listing_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblListingNotFound'); ?></p><?php
				}else{
					foreach ($tpl['latest_listing_arr'] as $k => $v)
					{
						$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'backend/no-image.png';
						if(!empty($v['pic']))
						{
							if(is_file(PJ_INSTALL_PATH . $v['pic']))
							{
								$image = PJ_INSTALL_URL . $v['pic'];
							}
						}
						?>
						<div class="dashboard_listing_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><img src="<?php echo $image;?>"  /></a>
							<div class="listing-views"><label><?php echo $v['views'];?></label><span><?php echo $v['views'] != 1 ? strtolower(__('lblViews', true)) : strtolower(__('lblView', true)); ?></span></div>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
			<?php
			if(!$controller->isOwner())
			{
				$cnt = count($tpl['user_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblUserNotFound'); ?></p><?php
				}else{
					foreach ($tpl['user_arr'] as $k => $v)
					{
						?>
						<div class="dashboard_user_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<label class="name"><?php echo stripslashes($v['name']);?></label>
							<a class="email" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo $v['email']; ?></a>
							<label class="last-login"><?php echo strtolower(__('lblDashLastLogin', true));?>: <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($v['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></label>
							<div class="listings"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionIndex&owner_id=<?php echo $v['id'];?>"><?php echo $v['cnt_listings'];?></a> <?php echo $v['cnt_listings'] != 1 ? strtolower(__('lblDashListings')) : strtolower(__('lblDashListing')); ?></div>
						</div>
						<?php
					}
				} 
			}else{
				
			}
			?>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>