<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionIndex"><?php __('menuListings'); ?></a></li>
			<?php
			if(!$controller->isOwner() || ($controller->isOwner() && $tpl['option_arr']['o_allow_add_listing'] == 'Yes'))
			{
				?>
				<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionImport"><?php __('lblImport'); ?></a></li>
				<?php 
			}
			?>
		</ul>
	</div>
	
	<div class="b10">
		<?php
		if(!$controller->isOwner() || ($controller->isOwner() && $tpl['option_arr']['o_allow_add_listing'] == 'Yes'))
		{
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left r5">
				<input type="hidden" name="controller" value="pjAdminListings" />
				<input type="hidden" name="action" value="pjActionCreate" />
				<input type="submit" class="pj-button" value="+ <?php __('lblAddListing'); ?>" />
			</form>
			<?php 
		}
		?>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>

		<div class="float_right t5">
			<a href="#" class="pj-button btn-all">All</a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php __('lblPublished'); ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php __('lblNotPublished'); ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="float_left w350">
				<p>
					<label class="title80"><?php __('lblListingRefid'); ?></label>
					<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w200" />
				</p>
				
				<p>
					<label class="title80"><?php __('lblTitle'); ?></label>
					<input type="text" name="keyword" id="keyword" class="pj-form-field w200" />
				</p>
				<?php
				if ($controller->isAdmin()|| $controller->isEditor())
				{
					?>
					<p style="overflow: visible;">
						<label class="title80"><?php __('lblListingOwner'); ?></label>
						<select name="owner_id" id="owner_id" class="pj-form-field w200">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['owner_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['user_id']) && (int) $_GET['user_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
							}
							?>
						</select>
					</p>
					<?php
				} 
				?>
			</div>
			<div class="float_right w350">
				
				<p>
					<label class="title80"><?php __('lblListingState'); ?></label>
					<input type="text" name="address_state" id="address_state" class="pj-form-field w200" />
				</p>
				<p>
					<label class="title80"><?php __('lblListingCity'); ?></label>
					<input type="text" name="address_city" id="address_city" class="pj-form-field w200" />
				</p>
				<p>
				<label class="title80"><?php __('lblListingCountry'); ?></label>
					<select name="country_id" id="country_id" class="pj-form-field w250">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['country_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['country_id']) && (int) $_GET['country_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</p>
			</div>
			<br class="clear_both" />
			<p>
				<label class="title80"><?php __('lblListingCategory'); ?></label>
				<select name="category_id" id="category_id" class="pj-form-field w400">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['category_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['category_id']) && (int) $_GET['category_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</p>
			<p>
				<label class="title80">&nbsp;</label>
				<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
				<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
			</p>
		</form>
	</div>
	
	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.queryString = "";
	pjGrid.isEditor = <?php echo $controller->isEditor() ? 'true' : 'false'; ?>;
	pjGrid.isOwner = <?php echo $controller->isOwner() ? 'true' : 'false'; ?>;
	<?php
	if (isset($_GET['owner_id']) && (int) $_GET['owner_id'] > 0)
	{
		?>pjGrid.queryString += "&owner_id=<?php echo (int) $_GET['owner_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.image = "<?php echo pjSanitize::html(__('lblImage', true)); ?>";
	myLabel.ref_id = "<?php echo pjSanitize::html(__('lblListingRefid', true)); ?>";
	myLabel.owner = "<?php echo pjSanitize::html(__('lblOwner', true)); ?>";
	myLabel.expire = "<?php echo pjSanitize::html(__('lblExpire', true)); ?>";
	myLabel.publish = "<?php echo pjSanitize::html(__('lblPublish', true)); ?>";
	myLabel.active = "<?php echo pjSanitize::html(__('lblActive', true)); ?>";
	myLabel.inactive = "<?php echo pjSanitize::html(__('lblInactive', true)); ?>";
	myLabel.exp_date = "<?php echo pjSanitize::html(__('lblExpireDate', true)); ?>";
	myLabel.published = "<?php echo pjSanitize::html(__('lblPublished', true)); ?>";
	myLabel.exported = "<?php echo pjSanitize::html(__('lblExport', true)); ?>";
	myLabel.exp_date_plus_30 = "<?php echo pjSanitize::html(__('lblExpireDatePlus30', true)); ?>";
	myLabel.not_published = "<?php echo pjSanitize::html(__('lblNotPublished', true)); ?>";
	myLabel.extend_exp_date = "<?php echo pjSanitize::html(__('lblExtendExpireDate', true)); ?>";
	myLabel.extend_confirm = "<?php echo pjSanitize::html(__('lblExtendConfirmation', true)); ?>";
	myLabel.delete_selected = "<?php echo pjSanitize::html(__('lblDeleteSelected', true)); ?>";
	myLabel.delete_confirm = "<?php echo pjSanitize::html(__('lblDeleteConfirmation', true)); ?>";
	</script>
	<?php
}
?>