<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	<style type="text/css">
		.mceEditor > table{
			width: 570px !important;
		}
		.ui-menu{
			height: 230px;
			overflow-y: scroll;
		}
		.ui-tabs .ui-tabs-panel{
			overflow: visible;
		}
	</style>

	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate" method="post" id="frmUpdateListing" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="listing_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />

		<div id="tabs">
		
			<ul>
				<li><a href="#tabs-1"><?php __('lblListingSummary'); ?></a></li>
				<li><a href="#tabs-2"><?php __('lblListingDetails'); ?></a></li>
				<li><a href="#tabs-3"><?php __('lblListingCategories'); ?></a></li>
				<li><a href="#tabs-4"><?php __('lblListingPhotos'); ?></a></li>
				<li><a href="#tabs-5"><?php __('lblListingAddress'); ?></a></li>
				<li><a href="#tabs-6"><?php __('lblListingContact'); ?></a></li>
				<li><a href="#tabs-7"><?php __('lblListingSeo'); ?></a></li>
			</ul>
		
			<div id="tabs-1">
					
				<p><label class="title"><?php __('lblListingCreated'); ?></label><span class="left"><?php echo pjUtil::formatDate(date("Y-m-d", strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?> <?php echo pjUtil::formatTime(date("H:i:s", strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></span></p>
				<p><label class="title"><?php __('lblListingModified'); ?></label><span class="left"><?php echo !empty($tpl['arr']['modified']) ? pjUtil::formatDate(date("Y-m-d", strtotime($tpl['arr']['modified'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date("H:i:s", strtotime($tpl['arr']['modified'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : __('lblNA'); ?></span></p>
				<p><label class="title"><?php __('lblListingViews'); ?></label><span class="left"><?php echo $tpl['arr']['views']; ?></span></p>
				<p>
					<label class="title"><?php __('lblListingRefid'); ?></label>
					<span class="inline_block">
						<input type="text" name="listing_refid" id="listing_refid" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_refid'])); ?>" class="pj-form-field required" />
					</span>
				</p>
				<?php
				if (!$controller->isOwner())
				{
					?>
					<p><label class="title"><?php __('lblListingStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field required">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach (__('publish_status', true) as $k => $v)
								{
									if ($tpl['arr']['status'] == $k)
									{
										?><option value="<?php echo $k; ?>" selected="selected"><?php echo stripslashes($v); ?></option><?php
									} else {
										?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
									}
								}
								?>
							</select>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingStatusTip'); ?>"></a>
						</span>
					</p>
					<p id="expiration_container" style="display:<?php echo $tpl['arr']['status'] == 'E' ? 'block' : 'none'; ?>;">
						<label class="title"><?php __('lblListingExpire'); ?></label>
						<span class="inline_block">
							<span class="pj-form-field-custom pj-form-field-custom-after">
								<input type="text" name="expire" id="expire" class="pj-form-field pointer w80 datepick" value="<?php echo pjUtil::formatDate($tpl['arr']['expire'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingExpireTip'); ?>"></a>
						</span>
					</p>
					<?php
				} else {
					if(!empty($tpl['arr']['expire']))
					{
						?>
						<p>
							<label class="title"><?php __('lblListingExpire'); ?></label>
							<span class="left float_left<?php echo $tpl['arr']['expire'] < date('Y-m-d') ? ' red' : null; ?>"><?php echo pjUtil::formatDate(date("Y-m-d", strtotime($tpl['arr']['expire'])), 'Y-m-d', $tpl['option_arr']['o_date_format'] ); ?></span>
							<a class="pj-button float_left l10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionPayment&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblListingExtend'); ?></a>
						</p>
						<?php
					}else{
						?>
						<p>
							<label class="title"><?php __('lblListingExpire'); ?></label>
							<label class="content"><?php __('lblNever', false, false);?></label>
						</p>
						<?php
					}
				}
				
				if (!$controller->isOwner())
				{
					?>
					<p style="overflow: visible">
						<label class="title"><?php __('lblListingOwner'); ?></label>
						<select name="owner_id" id="owner_id" class="pj-form-field required w200">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['user_arr'] as $val) {
								?>
								<option value="<?php echo $val['id'];?>" <?php echo $tpl['arr']['owner_id'] == $val['id'] ? 'selected="selected"' : '';?> ><?php echo $val['name'];?></option>
								<?php
							}
							?>
						</select>
					<?php
				}
				?>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div>
		
			<div id="tabs-2">
				<?php
				pjUtil::printNotice(__('infoListingDetailTitle', true), __('infoListingDetailBody', true)); 
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif;?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingTitle'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w500<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingDescription'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="mceEditor" style="width: 570px; height: 300px"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
					</p>
				</div>
			</div>
			<div id="tabs-3">
				<?php
				pjUtil::printNotice(__('infoCategoryTitle', true), __('infoCategoryBody', true)); 
				
				$i = 1;
				foreach ($tpl['category_arr'] as $v)
				{
					$is_open = true;
					?>
					<div class="float_left w200 b5 r25 pj-checkbox gradient<?php echo in_array($v['id'], $tpl['listing_category_arr']) ? ' pj-checkbox-checked' : NULL; ?>">
						<input type="checkbox"  style="vertical-align: middle" name="category[]" id="category_<?php echo $v['id']; ?>" value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['listing_category_arr']) ? ' checked="checked"' : NULL; ?> />
						<label for="category_<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></label>
					</div>
					<?php
					if ($i % 3 === 0)
					{
						$is_open = false;
						?><div class="clear_left"></div><?php
					}
					$i++;
					
				}
				if ($is_open) {
					?><div class="clear_left"></div><?php
				}
				?>
				
				<p>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div>
			
			<div id="tabs-4">
				<?php
				pjUtil::printNotice(@$titles['AL41'], @$bodies['AL41']);
				?>
				<div id="gallery"></div>
			</div>
			<div id="tabs-5">
				<?php
				pjUtil::printNotice(__('infoListingAddressTitle', true), __('infoListingAddressBody', true));
				?>
				<div class="clear_both overflow">
					<p>
						<label class="title"><?php __('lblShowOnMap'); ?></label>
						<input type="radio" name="address_map" id="address_map_1" class="t5" value="1"<?php echo $tpl['arr']['address_map'] == 1 ? ' checked="checked"' : NULL; ?> /> <label for="address_map_1"><?php echo __('lblYes'); ?></label>
						<input type="radio" name="address_map" id="address_map_0" class="t5"  value="0"<?php echo $tpl['arr']['address_map'] == 0 ? ' checked="checked"' : NULL; ?> /> <label for="address_map_0"><?php echo __('lblNo'); ?></label>
					</p>
					<p><label class="title"><?php __('lblListingZip'); ?></label><input type="text" name="address_postcode" id="address_postcode" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_postcode'])); ?>" class="pj-form-field" /></p>
					<p>
						<label class="title"><?php __('lblListingAddress'); ?></label>
						<input type="text" name="address_content" id="address_content" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_content'])); ?>" class="pj-form-field w500" />
					</p>
					<p style="overflow: visible">
						<label class="title"><?php __('lblListingCountry'); ?></label>
						<select name="country_id" id="country_id" class="pj-form-field w300">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['country_arr'] as $v)
							{
								if ($tpl['arr']['country_id'] == $v['id'])
								{
									?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo stripslashes($v['name']); ?></option><?php
								} else {
									?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
								}
							}
							?>
						</select>
					</p>
					<p>
						<label class="title"><?php __('lblListingState'); ?></label>
						<input type="text" name="address_state" id="address_state" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_state'])); ?>" class="pj-form-field w200" />
					</p>
					<p>
						<label class="title"><?php __('lblListingCity'); ?></label>
						<span class="inline_block">
							<input type="text" name="address_city" id="address_city" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_city'])); ?>" class="pj-form-field w200" />
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<span><?php __('lblListingGMapNote'); ?></span>
					</p>
					<div class="vrLeftContent">
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<input type="button" value="<?php __('btnGoogleMapsApi'); ?>" class="pj-button btnGoogleMapsApi" />
								<span style="color: red; display: none"></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblListingLat'); ?></label>
							<input type="text" name="lat" id="lat" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['lat'])); ?>" class="pj-form-field w200 number" />
						</p>
						<p>
							<label class="title"><?php __('lblListingLng'); ?></label>
							<input type="text" name="lng" id="lng" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['lng'])); ?>" class="pj-form-field w200 number" />
						</p>
						<p>
							<label class="title">&nbsp;</label>
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
							<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
						</p>
					</div>
					<div class="vrRightCcontent">
						<span id="map-message"></span>
						<div id="map_canvas" class="vrMapCanvas"></div>
					</div>
				</div>
			</div>
			<div id="tabs-6">
				<p>
					<label class="title"><?php __('lblPhone'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="phone" id="phone" class="pj-form-field w250" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['phone'])); ?>" placeholder="(123) 456-7890" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblFax'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="fax" id="fax" class="pj-form-field w250" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['fax'])); ?>" placeholder="(123) 456-7890" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblWebsite'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
						<input type="text" name="url" id="url" class="pj-form-field w300 validateUrl" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['url'])); ?>" placeholder="http://www.domain.com"  />
					</span>
				</p>
				<p>
					<label class="title"><?php __('email'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="email" id="email" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['email'])); ?>" class="pj-form-field email w200" placeholder="info@test.com" />
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div>
			<div id="tabs-7">
				<?php
				pjUtil::printNotice(__('infoListingSEOTitle', true), __('infoListingSEOBody', true));  
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif; ?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingMetaTitle'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_title]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_title'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingMetaKeywords'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_keywords]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_keywords'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingMetaDesc'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_description]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_description'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
					</p>
				</div>
			</div>
			
		</div> <!-- #tabs -->
	</form>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	var myLabel = myLabel || {};
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	myLabel.address_not_found = "<?php __('lblAddressNotFound'); ?>";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					$("input[name='locale']").val(ui.index);
				}
			});
			$(".multilang").find("a[data-index='<?php echo $locale; ?>']").trigger("click");
		});
	})(jQuery_1_8_2);
	</script>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>