(function (window, undefined) {
	var d = window.document;
	
	function stivaYP(options) {
		if (!(this instanceof stivaYP)) {
			return new stivaYP();
		}
		this.map;
		if(d.getElementById('yp_view_map'))
		{
			this.directionsDisplay = new google.maps.DirectionsRenderer();
			this.directionsService = new google.maps.DirectionsService();
			this.geocoder = new google.maps.Geocoder();
		}
		this.frmLogin = null;
		this.frmForgot = null;
		this.frmRegister = null;
		this.status = 'map';
		this.direction = 0;
		this.menu_status = 0;
		this.init();
		return this;
	}
	
	stivaYP.prototype = {
		
		bindFilter: function()
		{
			var self = this,
				category = d.getElementById('yp_filter_category');
			if(category)
			{
				category.onchange = function () {
					var href = this.getAttribute("lang") + "&category_id=" + this.value;
					window.location.href = href;
				}
			}
		},
		
		loadDirection: function(lat, lng)
		{
			var self = this,
				direction_container = d.getElementById('yp_direction_container');

			direction_container.style.display = 'block';
			
			var start =new google.maps.LatLng(lat, lng);
			var end = new google.maps.LatLng(ypFrontObj.yp_map_lat, ypFrontObj.yp_map_lng);
			
			var ypOptions = {
					center: end,
					zoom: 12,
					mapTypeId: google.maps.MapTypeId.ROADMAP	
				};
			self.direction = 1;
			self.map = new google.maps.Map(document.getElementById("yp_direction_map"), ypOptions);
			
			self.directionsDisplay.setMap(self.map);
			self.directionsDisplay.setPanel(d.getElementById("yp_direction_list"));

			
			var request = {
							origin: start,
							destination: end,
							travelMode: google.maps.TravelMode.DRIVING
					};
			self.directionsService.route(request, function(result, status) {
				if (status == google.maps.DirectionsStatus.OK) {
					self.directionsDisplay.setDirections(result);
				}
			});
		},
		bindDirection: function()
		{
			var self = this,
				address = d.getElementById('yp_start_address'),
				view_map = d.getElementById('yp_view_map'),
				direction_container = d.getElementById('yp_direction_container');
			address.onkeyup = function(e)
			{
				if(e.which == 13)
				{
					if(address.value != '')
					{
						JABB.Ajax.getJSON(address.getAttribute("lang") + '&address=' + address.value, function (json) {
							if(json.code == '200')
							{
								view_map.style.display = 'none';
								self.loadDirection(json.lat, json.lng);
							}
						});
					}
				}
			}
		},
		bindSharing: function()
		{
			var self = this,
				address = d.getElementById('yp_start_address'),
				email = d.getElementById('yp_email_sharing'),
				direction = d.getElementById('yp_directions'),
				address_container = d.getElementById('yp_address_container');
			if(email)
			{
				email.onclick = function(e){
					if (e && e.preventDefault) {
						e.preventDefault();
					}
					self.overlaySharing.open();
				}
			}
			if(direction)
			{
				direction.onclick = function(e){
					if (e && e.preventDefault) {
						e.preventDefault();
					}
					if(self.status == 'map')
					{
						address_container.style.display = "block";
						self.status = 'direction';
						self.bindDirection();
					}else{
						self.status = 'map';
						address.value = '';
						address_container.style.display = "none";
						if(self.direction == 1)
						{
							self.bindMap();
						}
					}
				}
			}
		},
		googleMapInit: function()
		{
			var self = this,
				view_map = d.getElementById('yp_view_map'),
				direction_container = d.getElementById('yp_direction_container');
			var ypOptions = {
				zoom: 12,
				mapTypeId: google.maps.MapTypeId.ROADMAP	
			};
			view_map.style.display = "block";
			self.map = new google.maps.Map(d.getElementById("yp_view_map_canvas"), ypOptions);
			
			direction_container.style.display = "none";
		},
		codeAddress: function(lat, lng, contentString)
		{
			var self = this,
				myLatlng = new google.maps.LatLng(lat, lng);
			
			self.map.setCenter(myLatlng);
			var marker = new google.maps.Marker({
				map: self.map,
				position: myLatlng
			});
			if (contentString.length > 0 && contentString != "") {
				var infoWindow = new google.maps.InfoWindow({
					content: contentString
				});
				google.maps.event.addListener(marker, "click", function() {
					infoWindow.open(self.map, marker);
				});
			}
		},
		bindMap: function()
		{
			var self = this;
			self.direction = 0;
			self.googleMapInit();
			self.codeAddress(ypFrontObj.yp_map_lat, ypFrontObj.yp_map_lng, ypFrontObj.yp_info_window);
		},
		validateSharing: function()
		{
			var self = this,
				re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
				frm = d.getElementById("frmYPSharing"),
				to = frm.to,
				from = frm.from,
				subject = frm.subject,
				message = frm.message,
				send_url = frm.getAttribute("action");
				valid = true;
			
			var validate_to = d.getElementById("yp_validate_" + to.getAttribute("name")),
				validate_from = d.getElementById("yp_validate_" + from.getAttribute("name")),
				validate_subject = d.getElementById("yp_validate_" + subject.getAttribute("name")),
				validate_message = d.getElementById("yp_validate_" + message.getAttribute("name"));

			if(to.value != '')
			{
				if (to.value != '' && to.value.match(re) == null) {
					validate_to.innerHTML = ypFrontObj.yp_email_invalid;
					valid = false;
				}else{
					validate_to.innerHTML = '';
				}
			}else{
				validate_to.innerHTML = ypFrontObj.yp_required_field;
				valid = false;
			}
			if(from.value != '')
			{
				if (from.value != '' && from.value.match(re) == null) {
					validate_from.innerHTML = ypFrontObj.yp_email_invalid;
					valid = false;
				}else{
					validate_from.innerHTML = '';
				}
			}else{
				validate_from.innerHTML = ypFrontObj.yp_required_field;
				valid = false;
			}
			if(subject.value == '')
			{
				validate_subject.innerHTML = ypFrontObj.yp_required_field;
				valid = false;
			}else{
				validate_subject.innerHTML = '';
			}
			
			if(message.value == '')
			{
				validate_message.innerHTML = ypFrontObj.yp_required_field;
				valid = false;
			}else{
				validate_message.innerHTML = '';
			}
			if(valid == true)
			{
				var post = JABB.Utils.serialize(frm);
				JABB.Ajax.sendRequest(send_url, function (req) {
					self.overlaySharing.close();
			    }, post);
			}
		},
		bindMapView: function()
		{
			var self = this,
				category = d.getElementById('yp_map_category'),
				arr = JABB.Utils.getElementsByClass("yp-map-title", d.getElementById("yp_map_container"), "A");
			
			for (var i = 0, len = arr.length; i < len; i++) {
				JABB.Utils.addEvent(arr[i], "click", function (e) {
					if (e && e.preventDefault) {
						e.preventDefault();
					}
					var i = this.getAttributeNode("lang").value;
					google.maps.event.trigger(ypMarkersArray[i], 'click');
				});
			}
			
			if(category)
			{
				category.onchange = function () {
					var href = this.getAttribute("lang") + "&category_id=" + this.value;
					window.location.href = href;
				}
			}
		},
		validateLoginForm: function(container)
		{
			var self = this,
				re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
				msg = '',
				email = self.frmLogin.login_email,
				password = self.frmLogin.login_password;
			
			if (email) {
				if (email.value == '') {
					msg += '<li>' + ypFrontObj.yp_email_required + '</li>';
				}
				if (email.value != '' && email.value.match(re) == null) {
					msg += '<li>' + ypFrontObj.yp_email_invalid + '</li>';
				}
			}
			if (password && password.value == '') {
				msg += '<li>' + ypFrontObj.yp_password_required + '</li>';
			}
			if (msg != '') {
				container.innerHTML = msg;
				container.style.display = "block";
			} else {
				self.frmLogin.submit();
			}
		},
		checkCaptcha: function(container)
		{
			var self = this,
				captcha = self.frmRegister.captcha;
			
			JABB.Ajax.sendRequest(ypFrontObj.yp_install_folder + 'index.php?controller=pjFront&action=pjActionCheckCaptcha&captcha=' + captcha.value, function (resp) {
				var code = resp.responseText;
				if(code == '100'){
					self.frmRegister.submit();
				}else{
					msg = '<li>' + ypFrontObj.yp_captcha_incorrect + '</li>';
					container.innerHTML = msg;
					container.style.display = "block";
				}
			});
		},
		checkEmail: function(container)
		{
			var self = this,
				email = self.frmRegister.email;
			
			JABB.Ajax.sendRequest(ypFrontObj.yp_install_folder + 'index.php?controller=pjListings&action=pjActionCheckEmail&email=' + email.value, function (resp) {
				var code = resp.responseText;
				if(code == '100'){
					self.checkCaptcha(container);
				}else{
					msg = '<li>' + ypFrontObj.yp_email_used + '</li>';
					container.innerHTML = msg;
					container.style.display = "block";
				}
			});
		},
		validateRegisterForm: function(container)
		{
			var self = this,
				re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
				msg = '',
				email = self.frmRegister.email,
				password = self.frmRegister.password,
				name = self.frmRegister.name,
				captcha = self.frmRegister.captcha;
			
			if (email) {
				if (email.value == '') {
					msg += '<li>' + ypFrontObj.yp_email_required + '</li>';
				}
				if (email.value != '' && email.value.match(re) == null) {
					msg += '<li>' + ypFrontObj.yp_email_invalid + '</li>';
				}
			}
			if (password && password.value == '') {
				msg += '<li>' + ypFrontObj.yp_password_required + '</li>';
			}
			if (name && name.value == '') {
				msg += '<li>' + ypFrontObj.yp_name_required + '</li>';
			}
			if (captcha && captcha.value == '') {
				msg += '<li>' + ypFrontObj.yp_captcha_required + '</li>';
			}
			if (msg != '') {
				container.innerHTML = msg;
				container.style.display = "block";
			} else {
				self.checkEmail(container);
			}
		},
		bindAccount: function()
		{
			var self = this,
				login_error_container = d.getElementById('yp_login_error_container'),
				register_error_container = d.getElementById('yp_register_error_container');
			
			self.frmLogin = d.getElementById('frmYPLogin');
			self.frmRegister = d.getElementById('frmYPRegister');
			
			self.frmLogin.onsubmit = function(e)
			{
				self.validateLoginForm(login_error_container);
				return false;
			}
			
			self.frmRegister.onsubmit = function(e)
			{
				self.validateRegisterForm(register_error_container);
				return false;
			}
		},
		validateForgotForm: function(container)
		{
			var self = this,
				re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
				msg = '',
				email = self.frmForgot.email;
			
			if (email) {
				if (email.value == '') {
					msg += '<li>' + ypFrontObj.yp_email_required + '</li>';
				}
				if (email.value != '' && email.value.match(re) == null) {
					msg += '<li>' + ypFrontObj.yp_email_invalid + '</li>';
				}
			}
			
			if (msg != '') {
				container.innerHTML = msg;
				container.style.display = "block";
			} else {
				self.frmForgot.submit();
			}
		},
		bindForgot: function()
		{
			var self = this,
				forgot_error_container = d.getElementById('yp_forgot_error_container');
			
			self.frmForgot = d.getElementById('frmYPForgot');
						
			self.frmForgot.onsubmit = function(e)
			{
				self.validateForgotForm(forgot_error_container);
				return false;
			}
		},
		bindMenu: function(){
			var self = this,
				arr = JABB.Utils.getElementsByClass("yp-hidden-menu", d.getElementById("yp_menu_container"), "A"),
				menu_list = d.getElementById('yp_menu_list');
			if(arr.length > 0)
			{
				JABB.Utils.addEvent(arr[0], "click", function (e) {
					if (e && e.preventDefault) {
						e.preventDefault();
					}
					if(self.menu_status == 1){
						self.menu_status = 0;
						menu_list.style.display = "none";
					}else{
						menu_list.style.display = "block";
						self.menu_status = 1;
					}
				});
			}
		},
		init: function () {
			var self = this;
			if (typeof ypFrontObj.detail_view != 'undefined')
			{			
				var href = d.getElementById('yp_email_sharing').getAttribute('lang');
				self.overlaySharing = new OverlayJS({
					selector: "yp_email_dialog",
					modal: true,
					width: 550,
					height: 444,
					onBeforeOpen: function () {
						var $that = this;
					    JABB.Ajax.sendRequest(href, function (req) {
					    	$that.content.innerHTML = req.responseText;
					    });
					},
					buttons: {
						"Send": function (button) {
							self.validateSharing();
						},
						"Cancel": function (button) {
							this.close();
						}
					}
				});
				self.bindSharing();
				if(ypFrontObj.yp_address_map == 1)
				{
					self.bindMap();
				}
			}
			if (typeof ypFrontObj.list_view != 'undefined')
			{
				self.bindFilter();
			}
			if (typeof ypFrontObj.map_view != 'undefined')
			{
				self.bindMapView();
			}
			if (typeof ypFrontObj.account != 'undefined')
			{
				self.bindAccount();
			}
			if (typeof ypFrontObj.forgot_password != 'undefined')
			{
				self.bindForgot();
			}
			self.bindMenu();
		}
	}
	return (window.stivaYP = stivaYP);
})(window);
var stivaObj = new stivaYP();