DROP TABLE IF EXISTS `joblisting_fields`;
CREATE TABLE IF NOT EXISTS `joblisting_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_multi_lang`;
CREATE TABLE IF NOT EXISTS `joblisting_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_options`;
CREATE TABLE IF NOT EXISTS `joblisting_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_roles`;
CREATE TABLE IF NOT EXISTS `joblisting_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_users`;
CREATE TABLE IF NOT EXISTS `joblisting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_jobs`;
CREATE TABLE IF NOT EXISTS `joblisting_jobs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employer_id` int(10) DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `address_postcode` varchar(255) DEFAULT NULL,
  `address_content` text DEFAULT NULL,
  `address_city` varchar(255) DEFAULT NULL,
  `address_state` varchar(255) DEFAULT NULL,
  `job_refid` varchar(255) DEFAULT NULL,
  `job_salary` varchar(255) DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `expired` date DEFAULT NULL,
  `expired_show` enum('T','F') DEFAULT 'F',
  `employer_show` enum('T','F') DEFAULT 'F',
  `last_extend` enum('free','paid') DEFAULT NULL,
  `status` enum('T','F','E') NOT NULL DEFAULT 'F',
  `is_featured` enum('F','T') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`),
  KEY `country_id` (`country_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_applications`;
CREATE TABLE IF NOT EXISTS `joblisting_applications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` int(10) unsigned DEFAULT NULL,
  `employee_id` int(10) unsigned DEFAULT NULL,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`),
  KEY `employee_id` (`employee_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_employers`;
CREATE TABLE IF NOT EXISTS `joblisting_employers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `company_name` varchar(255) DEFAULT NULL,
  `contact_name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `ip_registered` varchar(50) DEFAULT NULL,
  `ip_last_login` varchar(50) DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_employees`;
CREATE TABLE IF NOT EXISTS `joblisting_employees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `linkedin` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_files`;
CREATE TABLE IF NOT EXISTS `joblisting_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `hash` varchar(64) DEFAULT NULL,
  `file_type` enum('employee','application') DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`),
  KEY `foreign_id` (`foreign_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_periods`;
CREATE TABLE IF NOT EXISTS `joblisting_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `joblisting_payments`;
CREATE TABLE IF NOT EXISTS `joblisting_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `joblisting_periods` (`id`, `days`, `price`) VALUES
(2, 20, 79.00),
(4, 50, 119.00),
(5, 10, 49.00),
(6, 30, 99.00),
(7, 40, 109.00);

DROP TABLE IF EXISTS `joblisting_types`;
CREATE TABLE IF NOT EXISTS `joblisting_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `joblisting_types` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T'),
(6, 'T');

DROP TABLE IF EXISTS `joblisting_notifications`;
CREATE TABLE IF NOT EXISTS `joblisting_notifications` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `joblisting_notifications` (`id`) VALUES
(1),
(2),
(3),
(4);

DROP TABLE IF EXISTS `joblisting_categories`;
CREATE TABLE IF NOT EXISTS `joblisting_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `joblisting_categories` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T'),
(6, 'T'),
(7, 'T'),
(8, 'T'),
(9, 'T'),
(10, 'T'),
(11, 'T'),
(12, 'T'),
(13, 'T'),
(14, 'T'),
(15, 'T'),
(16, 'T'),
(17, 'T'),
(18, 'T'),
(19, 'T'),
(20, 'T'),
(21, 'T'),
(22, 'T'),
(23, 'T'),
(24, 'T'),
(25, 'T');

INSERT INTO `joblisting_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(133, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(134, 'url', 'backend', 'URL', 'script', NULL),
(135, 'user', 'backend', 'Username', 'script', NULL),
(136, 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(137, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(138, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(139, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(140, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(141, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(142, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(143, 'days_ARRAY_7', 'arrays', 'days_ARRAY_7', 'script', NULL),
(144, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(145, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(146, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(147, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(148, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(149, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(150, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(151, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(152, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(153, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(154, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(155, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(156, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(157, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(158, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(159, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(160, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(161, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(162, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(163, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(164, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(169, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(170, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(171, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(172, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(173, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(174, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(175, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(176, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(177, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(178, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(179, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(180, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(181, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(186, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(187, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(188, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(189, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(190, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(191, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(192, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(193, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(194, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(195, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(196, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(197, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(198, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(199, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(200, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(201, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(202, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(203, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(204, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(205, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(206, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(207, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(208, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(209, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(210, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(211, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(212, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(213, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(214, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(215, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(216, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(217, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(218, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(219, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(220, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(221, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(222, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(223, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(224, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(225, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(226, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(227, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(228, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(229, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(230, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(231, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(232, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(233, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(234, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(235, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(236, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(237, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(238, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(239, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(240, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(241, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(242, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(243, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(244, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(245, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(246, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(247, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(248, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(249, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(250, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(251, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(252, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(253, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(254, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(255, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(256, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(257, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(258, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(259, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(260, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(261, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(262, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(263, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(264, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(302, 'menuTypes', 'backend', 'Menu / Types', 'script', NULL),
(303, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(304, 'lblInactive', 'backend', 'Laben / Inactive', 'script', NULL),
(305, 'lblDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(306, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(307, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(308, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(309, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(310, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(311, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(312, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(313, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(314, 'lblDeleteSelected', 'backend', 'Label / Delete selected', 'script', NULL),
(315, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(316, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(317, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(318, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(319, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(320, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(321, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(322, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(323, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(324, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(325, 'menuCountries', 'backend', 'Menu / Countries', 'script', NULL),
(326, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(327, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(328, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(329, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(330, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(331, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(332, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(333, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(334, 'menuEmployees', 'backend', 'Menu / Employees', 'script', NULL),
(335, 'lblAddEmployee', 'backend', 'Label / Add employee', 'script', NULL),
(336, 'lblFirstName', 'backend', 'Label / First name', 'script', NULL),
(337, 'lblLastName', 'backend', 'Label / Last name', 'script', NULL),
(338, 'employee_statarr_ARRAY_T', 'arrays', 'employee_statarr_ARRAY_T', 'script', NULL),
(339, 'employee_statarr_ARRAY_F', 'arrays', 'employee_statarr_ARRAY_F', 'script', NULL),
(340, 'jl_email_taken', 'backend', 'Label / Email taken', 'script', NULL),
(341, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(342, 'error_titles_ARRAY_AEE01', 'arrays', 'error_titles_ARRAY_AEE01', 'script', NULL),
(343, 'error_titles_ARRAY_AEE03', 'arrays', 'error_titles_ARRAY_AEE03', 'script', NULL),
(344, 'error_titles_ARRAY_AEE04', 'arrays', 'error_titles_ARRAY_AEE04', 'script', NULL),
(345, 'error_titles_ARRAY_AEE08', 'arrays', 'error_titles_ARRAY_AEE08', 'script', NULL),
(346, 'error_bodies_ARRAY_AEE01', 'arrays', 'error_bodies_ARRAY_AEE01', 'script', NULL),
(347, 'error_bodies_ARRAY_AEE03', 'arrays', 'error_bodies_ARRAY_AEE03', 'script', NULL),
(348, 'error_bodies_ARRAY_AEE04', 'arrays', 'error_bodies_ARRAY_AEE04', 'script', NULL),
(349, 'error_bodies_ARRAY_AEE08', 'arrays', 'error_bodies_ARRAY_AEE08', 'script', NULL),
(350, 'lblCV', 'backend', 'Label / CV', 'script', NULL),
(351, 'jl_file_allowed', 'backend', 'Label / File allowed', 'script', NULL),
(352, 'lblUpdateEmployee', 'backend', 'Label / Update employee', 'script', NULL),
(353, 'lnkOpen', 'backend', 'Link / Open', 'script', NULL),
(354, 'lnkDownload', 'backend', 'Link / Download', 'script', NULL),
(355, 'lnkDelete', 'backend', 'Link / Delete', 'script', NULL),
(356, 'lblDeleteCVTitle', 'backend', 'Label / Delete CV Title', 'script', NULL),
(357, 'lblDeleteCVBody', 'backend', 'Label / Delete CV body', 'script', NULL),
(358, 'menuEmployers', 'backend', 'Menu / Employers', 'script', NULL),
(359, 'error_titles_ARRAY_AER01', 'arrays', 'error_titles_ARRAY_AER01', 'script', NULL),
(360, 'error_titles_ARRAY_AER03', 'arrays', 'error_titles_ARRAY_AER03', 'script', NULL),
(361, 'error_titles_ARRAY_AER04', 'arrays', 'error_titles_ARRAY_AER04', 'script', NULL),
(362, 'error_titles_ARRAY_AER08', 'arrays', 'error_titles_ARRAY_AER08', 'script', NULL),
(363, 'error_bodies_ARRAY_AER01', 'arrays', 'error_bodies_ARRAY_AER01', 'script', NULL),
(364, 'error_bodies_ARRAY_AER03', 'arrays', 'error_bodies_ARRAY_AER03', 'script', NULL),
(365, 'error_bodies_ARRAY_AER04', 'arrays', 'error_bodies_ARRAY_AER04', 'script', NULL),
(366, 'error_bodies_ARRAY_AER08', 'arrays', 'error_bodies_ARRAY_AER08', 'script', NULL),
(367, 'lblAddEmployer', 'backend', 'Label / Add employer', 'script', NULL),
(368, 'lblCompanyName', 'backend', 'Label / Company name', 'script', NULL),
(369, 'employer_statarr_ARRAY_T', 'arrays', 'employer_statarr_ARRAY_T', 'script', NULL),
(370, 'employer_statarr_ARRAY_F', 'arrays', 'employer_statarr_ARRAY_F', 'script', NULL),
(371, 'lblContactName', 'backend', 'Label / Contact name', 'script', NULL),
(372, 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
(373, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(374, 'lblLogo', 'backend', 'Label / Logo', 'script', NULL),
(375, 'lblDeleteLogoTitle', 'backend', 'Label / Delete logo title', 'script', NULL),
(376, 'lblDeleteLogoBody', 'backend', 'Label / Delete logo body', 'script', NULL),
(377, 'lblUpdateEmployer', 'backend', 'Label / Update employer', 'script', NULL),
(378, 'menuApplications', 'backend', 'Menu / Applications', 'script', NULL),
(379, 'menuJobs', 'backend', 'Menu / Jobs', 'script', NULL),
(380, 'lblAddJob', 'backend', 'Label / Add job', 'script', NULL),
(381, 'filter_published_ARRAY_T', 'arrays', 'filter_published_ARRAY_T', 'script', NULL),
(382, 'filter_published_ARRAY_F', 'arrays', 'filter_published_ARRAY_F', 'script', NULL),
(383, 'lblReferenceID', 'backend', 'Label / Reference ID', 'script', NULL),
(384, 'lblIsPublished', 'backend', 'Label / Is published', 'script', NULL),
(385, 'lblIsFeatured', 'backend', 'Label / Is featured', 'script', NULL),
(386, 'lblJobSummary', 'backend', 'Label / Summary', 'script', NULL),
(387, 'lblJobDetails', 'backend', 'Label / Details', 'script', NULL),
(388, 'lblEmployerDetails', 'backend', 'Label / Employer details', 'script', NULL),
(389, 'error_titles_ARRAY_AJ01', 'arrays', 'error_titles_ARRAY_AJ01', 'script', NULL),
(390, 'error_titles_ARRAY_AJ03', 'arrays', 'error_titles_ARRAY_AJ03', 'script', NULL),
(391, 'error_titles_ARRAY_AJ04', 'arrays', 'error_titles_ARRAY_AJ04', 'script', NULL),
(392, 'error_titles_ARRAY_AJ08', 'arrays', 'error_titles_ARRAY_AJ08', 'script', NULL),
(393, 'error_bodies_ARRAY_AJ01', 'arrays', 'error_bodies_ARRAY_AJ01', 'script', NULL),
(394, 'error_bodies_ARRAY_AJ03', 'arrays', 'error_bodies_ARRAY_AJ03', 'script', NULL),
(395, 'error_bodies_ARRAY_AJ04', 'arrays', 'error_bodies_ARRAY_AJ04', 'script', NULL),
(396, 'error_bodies_ARRAY_AJ08', 'arrays', 'error_bodies_ARRAY_AJ08', 'script', NULL),
(397, 'lblAddedon', 'backend', 'Label / Added on', 'script', NULL),
(398, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(399, 'lblLastUpdatedOn', 'backend', 'Label / Last updated on', 'script', NULL),
(400, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(401, 'lblExpiredOn', 'backend', 'Label / Expired on', 'script', NULL),
(402, 'lblShowOn', 'backend', 'Label / Show on', 'script', NULL),
(403, 'lblJobTitle', 'backend', 'Label / Job title', 'script', NULL),
(404, 'lblJobSalary', 'backend', 'Label / Salary', 'script', NULL),
(405, 'lblJobDescription', 'backend', 'Label / Job description', 'script', NULL),
(406, 'lblZipCode', 'backend', 'Label / Zip code', 'script', NULL),
(407, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(408, 'lblState', 'backend', 'Label / State', 'script', NULL),
(409, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(410, 'lblShowEmployer', 'backend', 'Label / Show employer details', 'script', NULL),
(411, 'lblEmployer', 'backend', 'Label / Employer', 'script', NULL),
(412, 'lblJobOfferAddress', 'backend', 'Label / Job offer address', 'script', NULL),
(413, 'lblJobGMapNote', 'backend', 'Label / GMap note', 'script', NULL),
(414, 'btnGoogleMapsApi', 'backend', 'Button / Google Maps API', 'script', NULL),
(415, 'lblJobLat', 'backend', 'Label / Latitube', 'script', NULL),
(416, 'lblJobLng', 'backend', 'Label / Longitude', 'script', NULL),
(417, 'jl_address_not_found', 'backend', 'Label / Address not found', 'script', NULL),
(418, 'lblKeyword', 'backend', 'Label / Keyword', 'script', NULL),
(419, 'lblAppliedJob', 'backend', 'Label / Applied job', 'script', NULL),
(420, 'lblCreated', 'backend', 'Label / Created', 'script', NULL),
(421, 'opt_o_item_per_page', 'backend', 'Option / Items per page', 'script', NULL),
(422, 'opt_o_job_page', 'backend', 'Options / URL to web page', 'script', NULL),
(423, 'opt_o_email_address', 'backend', 'Options / Email address', 'script', NULL),
(424, 'opt_o_is_employee_confirmed', 'backend', 'Options / Employee account is confirmed', 'script', NULL),
(425, 'opt_o_featured_jobs', 'backend', 'Options / Featured jobs', 'script', NULL),
(426, 'opt_o_is_adding_job_allowed', 'backend', 'Opions / Allow adding job offers', 'script', NULL),
(427, 'opt_o_is_employer_confirmed', 'backend', 'Options / Employer account confirmed', 'script', NULL),
(428, 'opt_o_is_applying_job_allowed', 'backend', 'Options / Allow applying job', 'script', NULL),
(429, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(430, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(431, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(432, 'lblInstallPhp1Title', 'backend', 'INstall / Installation title', 'script', NULL),
(433, 'lblInstallPhp1_1', 'backend', 'Install / Step 1', 'script', NULL),
(434, 'lblInstallPhp1_2', 'backend', 'Install / Step 3', 'script', NULL),
(435, 'lblInstallPhp1_3', 'backend', 'Install / Step 3', 'script', NULL),
(436, 'front_menu_home', 'frontend', 'Front Menu / Home', 'script', NULL),
(437, 'front_menu_search', 'frontend', 'Front Menu / Search', 'script', NULL),
(438, 'front_menu_login', 'frontend', 'Front Menu / Login', 'script', NULL),
(439, 'front_menu_back', 'frontend', 'Front Menu / Back', 'script', NULL),
(440, 'front_menu_logout', 'frontend', 'Front Menu / Logout', 'script', NULL),
(441, 'front_menu_register', 'frontend', 'Front Menu / Register', 'script', NULL),
(442, 'front_menu_profile', 'frontend', 'Front Menu / Profile', 'script', NULL),
(443, 'front_paging_next', 'frontend', 'Front Paging / Next', 'script', NULL),
(444, 'front_paging_previous', 'frontend', 'Front Paging / Prev', 'script', NULL),
(445, 'front_label_search_for_jobs', 'frontend', 'Front Label / Search for jobs', 'script', NULL),
(446, 'front_label_type', 'frontend', 'Front Label / Type', 'script', NULL),
(447, 'front_label_category', 'frontend', 'Front Label / Category', 'script', NULL),
(448, 'front_label_country', 'frontend', 'Front Label / Country', 'script', NULL),
(449, 'front_label_state', 'frontend', 'Front Label / State', 'script', NULL),
(450, 'front_label_city', 'frontend', 'Front Label / City', 'script', NULL),
(451, 'front_label_refid', 'frontend', 'Front Label / Reference ID', 'script', NULL),
(452, 'front_label_keyword', 'frontend', 'Front Label / Keyword', 'script', NULL),
(453, 'front_label_choose', 'frontend', 'Front Label / Choose', 'script', NULL),
(454, 'front_button_search', 'frontend', 'Front Button / Search', 'script', NULL),
(455, 'front_label_employers', 'frontend', 'Front Label / Employers', 'script', NULL),
(456, 'front_label_candidates', 'frontend', 'Front Label / Candidates', 'script', NULL),
(457, 'front_label_employer_register_intro', 'frontend', 'Front Label / Employer register intro', 'script', NULL),
(458, 'front_label_candidate_register_intro', 'frontend', 'Front Label / Candidate register intro', 'script', NULL),
(459, 'front_label_email', 'frontend', 'Front Label / Email', 'script', NULL),
(460, 'front_button_register', 'frontend', 'Front button / Register', 'script', NULL),
(461, 'front_label_password', 'frontend', 'Front Label / Password', 'script', NULL),
(462, 'front_label_cpassword', 'frontend', 'Front Label / Confirm password', 'script', NULL),
(463, 'front_label_company_name', 'frontend', 'Front Label / Company name', 'script', NULL),
(464, 'front_label_contact_name', 'frontend', 'Front Label / Contact name', 'script', NULL),
(465, 'front_label_website', 'frontend', 'Front Label / Website', 'script', NULL),
(466, 'front_label_phone', 'frontend', 'Front Label / Phone', 'script', NULL),
(467, 'front_label_description', 'frontend', 'Front Label / Description', 'script', NULL),
(468, 'front_label_logo', 'frontend', 'Front Label / Logo', 'script', NULL),
(469, 'front_label_captcha', 'frontend', 'Front Label / Captcha', 'script', NULL),
(470, 'front_error_ARRAY_email', 'arrays', 'front_error_ARRAY_email', 'script', NULL),
(471, 'front_error_ARRAY_email_inv', 'arrays', 'front_error_ARRAY_email_inv', 'script', NULL),
(472, 'front_error_ARRAY_password', 'arrays', 'front_error_ARRAY_password', 'script', NULL),
(473, 'front_error_ARRAY_cpassword', 'arrays', 'front_error_ARRAY_cpassword', 'script', NULL),
(474, 'front_error_ARRAY_password_match', 'arrays', 'front_error_ARRAY_password_match', 'script', NULL),
(475, 'front_error_ARRAY_company_name', 'arrays', 'front_error_ARRAY_company_name', 'script', NULL),
(476, 'front_error_ARRAY_fname', 'arrays', 'front_error_ARRAY_fname', 'script', NULL),
(477, 'front_error_ARRAY_lname', 'arrays', 'front_error_ARRAY_lname', 'script', NULL),
(478, 'front_error_ARRAY_captcha', 'arrays', 'front_error_ARRAY_captcha', 'script', NULL),
(479, 'front_error_ARRAY_captcha_inc', 'arrays', 'front_error_ARRAY_captcha_inc', 'script', NULL),
(480, 'front_label_fname', 'frontend', 'Front Label / First name', 'script', NULL),
(481, 'front_label_lname', 'frontend', 'Front Label / Last name', 'script', NULL),
(482, 'front_label_cv', 'frontend', 'Front Label / CV', 'script', NULL),
(483, 'front_error_ARRAY_cv_ext', 'arrays', 'front_error_ARRAY_cv_ext', 'script', NULL),
(484, 'front_error_ARRAY_email_used', 'arrays', 'front_error_ARRAY_email_used', 'script', NULL),
(485, 'front_employer_reg_ARRAY_0', 'arrays', 'front_employer_reg_ARRAY_0', 'script', NULL),
(486, 'front_employer_reg_ARRAY_1', 'arrays', 'front_employer_reg_ARRAY_1', 'script', NULL),
(487, 'front_employer_reg_ARRAY_2', 'arrays', 'front_employer_reg_ARRAY_2', 'script', NULL),
(488, 'front_employer_reg_ARRAY_data_inv', 'arrays', 'front_employer_reg_ARRAY_data_inv', 'script', NULL),
(489, 'front_candidate_reg_ARRAY_0', 'arrays', 'front_candidate_reg_ARRAY_0', 'script', NULL),
(490, 'front_candidate_reg_ARRAY_1', 'arrays', 'front_candidate_reg_ARRAY_1', 'script', NULL),
(491, 'front_candidate_reg_ARRAY_2', 'arrays', 'front_candidate_reg_ARRAY_2', 'script', NULL),
(492, 'front_candidate_reg_ARRAY_data_inv', 'arrays', 'front_candidate_reg_ARRAY_data_inv', 'script', NULL),
(493, 'front_label_employer_login_intro', 'frontend', 'Front Label / Employer login intro', 'script', NULL),
(494, 'front_label_candidate_login_intro', 'frontend', 'Front Label / Candidate login intro', 'script', NULL),
(495, 'front_button_login', 'frontend', 'Front Button / Login', 'script', NULL),
(496, 'front_login_ARRAY_0', 'arrays', 'front_login_ARRAY_0', 'script', NULL),
(497, 'front_login_ARRAY_1', 'arrays', 'frotn_login_ARRAY_1', 'script', NULL),
(498, 'front_login_ARRAY_3', 'arrays', 'front_login_ARRAY_3', 'script', NULL),
(499, 'front_label_profile', 'frontend', 'Front Label / Profile', 'script', NULL),
(500, 'front_button_save', 'frontend', 'Front button / Save', 'script', NULL),
(501, 'front_link_open', 'frontend', 'Front Link / Open', 'script', NULL),
(502, 'front_link_download', 'frontend', 'Front Link / Download', 'script', NULL),
(503, 'front_link_delete', 'frontend', 'Front Link / Delete', 'script', NULL),
(504, 'front_label_cv_confirm', 'frontend', 'Front Label / Delete cv confirmation', 'script', NULL),
(505, 'front_label_delete_cv_error', 'frontend', 'Front Label / Delete CV error', 'script', NULL),
(506, 'front_profile_ARRAY_1', 'arrays', 'front_profile_ARRAY_1', 'script', NULL),
(507, 'front_label_salary', 'frontend', 'Front Label / Salary', 'script', NULL),
(508, 'front_label_expire_on', 'frontend', 'front_label_expire_on', 'script', NULL),
(509, 'front_label_employer_details', 'frontend', 'front_label_employer_details', 'script', NULL),
(510, 'front_label_job_description', 'frontend', 'front_label_job_description', 'script', NULL),
(511, 'front_label_job_apply', 'frontend', 'front_label_job_apply', 'script', NULL),
(512, 'front_label_notes', 'frontend', 'front_label_notes', 'script', NULL),
(513, 'front_button_apply', 'frontend', 'front_button_apply', 'script', NULL),
(514, 'front_apply_ARRAY_0', 'arrays', 'front_apply_ARRAY_0', 'script', NULL),
(515, 'front_apply_ARRAY_1', 'arrays', 'front_apply_ARRAY_1', 'script', NULL),
(516, 'front_apply_ARRAY_data_inv', 'arrays', 'front_apply_ARRAY_data_inv', 'script', NULL),
(517, 'lblViewApplication', 'backend', 'Label / View application', 'script', NULL),
(518, 'lblNotes', 'backend', 'Label / Notes', 'script', NULL),
(519, 'lblEmployeeAccount', 'backend', 'Label / Employee account', 'script', NULL),
(520, 'lblViewEmployee', 'backend', 'Label / View employee', 'script', NULL),
(521, 'lblEmployerLogin', 'backend', 'Label / Employer login', 'script', NULL),
(522, 'employerLogin', 'frontend', 'employerLogin', 'script', NULL),
(523, 'lblAdminLogin', 'backend', 'Label / Admin login', 'script', NULL),
(524, 'notifications_ARRAY_1', 'arrays', 'notifications_ARRAY_1', 'script', NULL),
(525, 'notifications_ARRAY_2', 'arrays', 'notifications_ARRAY_2', 'script', NULL),
(526, 'notifications_ARRAY_4', 'arrays', 'notifications_ARRAY_4', 'script', NULL),
(527, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(528, 'opt_notify_subject', 'backend', 'opt_notify_subject', 'script', NULL),
(529, 'opt_notify_message', 'backend', 'opt_notify_message', 'script', NULL),
(530, 'error_titles_ARRAY_AN01', 'arrays', 'error_titles_ARRAY_AN01', 'script', NULL),
(531, 'error_bodies_ARRAY_AN01', 'arrays', 'error_bodies_ARRAY_AN01', 'script', NULL),
(532, 'notify_tokens_ARRAY_1', 'arrays', 'notify_tokens_ARRAY_1', 'script', NULL),
(533, 'notify_tokens_ARRAY_2', 'arrays', 'notify_tokens_ARRAY_2', 'script', NULL),
(534, 'notify_tokens_ARRAY_4', 'arrays', 'notify_tokens_ARRAY_4', 'script', NULL),
(572, 'front_label_your_cv', 'frontend', 'Front Label / Your CV', 'script', NULL),
(573, 'front_label_send_latest_cv', 'frontend', 'Front Label / Send latest CV', 'script', NULL),
(575, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(576, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(577, 'front_label_job_type', 'frontend', 'front_label_job_type', 'script', NULL),
(578, 'front_label_all', 'frontend', 'front_label_all', 'script', NULL),
(579, 'front_label_no_found', 'frontend', 'front_label_no_found', 'script', NULL),
(580, 'front_link_back', 'frontend', 'front_link_back', 'script', NULL),
(581, 'jl_field_required', 'backend', 'jl_field_required', 'script', NULL),
(582, 'jl_email_invalid', 'backend', 'jl_email_invalid', 'script', NULL),
(583, 'front_link_forgot_password', 'frontend', 'front_link_forgot_password', 'script', NULL),
(584, 'front_label_forgot_password', 'frontend', 'front_label_forgot_password', 'script', NULL),
(585, 'front_label_forgot_password_intro', 'frontend', 'front_label_forgot_password_intro', 'script', NULL),
(586, 'front_button_send', 'frontend', 'front_button_send', 'script', NULL),
(587, 'front_forgot_ARRAY_0', 'arrays', 'front_forgot_ARRAY_0', 'script', NULL),
(588, 'front_forgot_ARRAY_1', 'arrays', 'front_forgot_ARRAY_1', 'script', NULL),
(589, 'lblJobAddTitle', 'backend', 'Infobox / Add job title', 'script', NULL),
(590, 'lblJobAddDesc', 'backend', 'Infobox / Add new job content', 'script', NULL),
(591, 'lblExpireOnTip', 'backend', 'Label / Expired on tip', 'script', NULL),
(592, 'publish_status_ARRAY_F', 'arrays', 'publish_status_ARRAY_F', 'script', NULL),
(593, 'publish_status_ARRAY_T', 'arrays', 'publish_status_ARRAY_T', 'script', NULL),
(594, 'publish_status_ARRAY_E', 'arrays', 'publish_status_ARRAY_E', 'script', NULL),
(595, 'lblStatusTip', 'backend', 'Label / Status tip', 'script', NULL),
(596, 'jl_exp_date', 'backend', 'jl_exp_date', 'script', NULL),
(597, 'lblJobExtend', 'backend', 'Label / Extend expire date', 'script', NULL),
(598, 'menuSubmissions', 'backend', 'Menu / Submissions', 'script', NULL),
(599, 'infoSubmissionsTitle', 'backend', 'Infobox / Submission Title', 'script', NULL),
(600, 'infoSubmissionsBody', 'backend', 'Infobox / Submission content', 'script', NULL),
(601, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(602, 'opt_period_note', 'backend', 'Options / Period note', 'script', NULL),
(603, 'job_payment_period', 'backend', 'job_payment_period', 'script', NULL),
(604, 'job_payment_price', 'backend', 'job_payment_price', 'script', NULL),
(605, 'btnAddPeriod', 'backend', 'Button / Add Period', 'script', NULL),
(606, 'jl_delete_confirmation_title', 'backend', 'Label / Delete confirmation title', 'script', NULL),
(607, 'jl_delete_period_confirmation', 'backend', 'Label / Delete period confirmation content', 'script', NULL),
(608, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(609, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(611, 'job_payment_renew_paypal', 'backend', 'Buy now', 'script', NULL),
(612, 'job_payment_free', 'backend', 'Label / FREE', 'script', NULL),
(613, 'job_payment_renew_free', 'backend', 'Listing / Extend your period for FREE', 'script', NULL),
(614, 'lblInstallOptional', 'backend', 'Install / Optional', 'script', NULL),
(615, 'lblInstallPhp2Title', 'backend', 'Install / SEO title', 'script', NULL),
(616, 'opt_o_seo_url', 'backend', 'Options / SEO url', 'script', NULL),
(618, 'lblInstallPhp2_1', 'backend', 'Install / SEO step 1', 'script', NULL),
(619, 'lblInstallPhp2_2', 'backend', 'Install / SEO step 2', 'script', NULL),
(620, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(621, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(622, 'notify_titles_ARRAY_1', 'arrays', 'notify_titles_ARRAY_1', 'script', NULL),
(623, 'notify_titles_ARRAY_2', 'arrays', 'notify_titles_ARRAY_2', 'script', NULL),
(624, 'notify_titles_ARRAY_4', 'arrays', 'notify_titles_ARRAY_4', 'script', NULL),
(625, 'notify_bodies_ARRAY_1', 'arrays', 'notify_bodies_ARRAY_1', 'script', NULL),
(626, 'notify_bodies_ARRAY_2', 'arrays', 'notify_bodies_ARRAY_2', 'script', NULL),
(627, 'notify_bodies_ARRAY_4', 'arrays', 'notify_bodies_ARRAY_4', 'script', NULL),
(665, 'btnExtendExpDate', 'backend', 'Buttons / Extend exp.date', 'script', NULL),
(666, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(667, 'lblJob', 'backend', 'Label / Job', 'script', NULL),
(668, 'lblJobs', 'backend', 'Label / Jobs', 'script', NULL),
(669, 'lblEmployers', 'backend', 'Label / Employers', 'script', NULL),
(670, 'lblApplication', 'backend', 'Label / Application', 'script', NULL),
(671, 'lblApplications', 'backend', 'Label / Applications', 'script', NULL),
(672, 'lblLatestJobs', 'backend', 'Label / Latest jobs', 'script', NULL),
(673, 'lblLatestEmployers', 'backend', 'Label / Latest employers', 'script', NULL),
(674, 'lblLatestApplications', 'backend', 'Label / Latest applications', 'script', NULL),
(675, 'lblNoEmployerFound', 'backend', 'Label / Employer not found', 'script', NULL),
(676, 'lblNoApplicationFound', 'backend', 'Label / Application not found', 'script', NULL),
(677, 'lblNoJobFound', 'backend', 'Label / Job not found', 'script', NULL),
(678, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(679, 'front_label_linkedin', 'frontend', 'Label / Linkedin', 'script', NULL),
(680, 'lblLinkedin', 'backend', 'Label / Linkedin', 'script', NULL),
(681, 'lblRegisteredOn', 'backend', 'Label / Registered on', 'script', NULL),
(682, 'lblLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(683, 'jl_same_refid', 'backend', 'Label / Ref ID used', 'script', NULL),
(684, 'job_statuses_ARRAY_1', 'arrays', 'job_statuses_ARRAY_1', 'script', NULL),
(685, 'job_statuses_ARRAY_2', 'arrays', 'job_statuses_ARRAY_2', 'script', NULL),
(686, 'job_statuses_ARRAY_3', 'arrays', 'job_statuses_ARRAY_3', 'script', NULL),
(687, 'job_statuses_ARRAY_4', 'arrays', 'job_statuses_ARRAY_4', 'script', NULL),
(688, 'notifications_ARRAY_3', 'arrays', 'notifications_ARRAY_3', 'script', NULL),
(689, 'notify_tokens_ARRAY_3', 'arrays', 'notify_tokens_ARRAY_3', 'script', NULL),
(690, 'notify_titles_ARRAY_3', 'arrays', 'notify_titles_ARRAY_3', 'script', NULL),
(691, 'notify_bodies_ARRAY_3', 'arrays', 'notify_bodies_ARRAY_3', 'script', NULL),
(692, 'lblNotYet', 'backend', 'Label / Not yet', 'script', NULL),
(693, 'job_statuses_ARRAY_5', 'arrays', 'job_statuses_ARRAY_5', 'script', NULL),
(694, 'job_statuses_ARRAY_6', 'arrays', 'job_statuses_ARRAY_6', 'script', NULL),
(695, 'error_titles_ARRAY_AJ09', 'arrays', 'error_titles_ARRAY_AJ09', 'script', NULL),
(696, 'error_bodies_ARRAY_AJ09', 'arrays', 'error_bodies_ARRAY_AJ09', 'script', NULL),
(697, 'jl_same_type', 'backend', 'Label / same type', 'script', NULL),
(698, 'lblMostPopularJobs', 'backend', 'Label / Most Popular Jobs', 'script', NULL);

INSERT INTO `joblisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjCategory', 1, 'name', 'Accounting/Finance/Insurance Jobs', 'script'),
(NULL, 2, 'pjCategory', 1, 'name', 'Administrative/Clerical Jobs', 'script'),
(NULL, 3, 'pjCategory', 1, 'name', 'Banking/Real Estate/Mortgage Professionals Jobs', 'script'),
(NULL, 4, 'pjCategory', 1, 'name', 'Biotech/R&D/Science Jobs', 'script'),
(NULL, 5, 'pjCategory', 1, 'name', 'Building Construction/Skilled Trades Jobs', 'script'),
(NULL, 6, 'pjCategory', 1, 'name', 'Business/Strategic Management Jobs', 'script'),
(NULL, 7, 'pjCategory', 1, 'name', 'Creative/Design Jobs', 'script'),
(NULL, 8, 'pjCategory', 1, 'name', 'Customer Support/Client Care Jobs', 'script'),
(NULL, 9, 'pjCategory', 1, 'name', 'Editorial/Writing Jobs', 'script'),
(NULL, 10, 'pjCategory', 1, 'name', 'Education/Training Jobs', 'script'),
(NULL, 11, 'pjCategory', 1, 'name', 'Engineering Jobs', 'script'),
(NULL, 12, 'pjCategory', 1, 'name', 'Food Services/Hospitality Jobs', 'script'),
(NULL, 13, 'pjCategory', 1, 'name', 'Human Resources Jobs', 'script'),
(NULL, 14, 'pjCategory', 1, 'name', 'Installation/Maintenance/Repair Jobs', 'script'),
(NULL, 15, 'pjCategory', 1, 'name', 'IT/Software Development Jobs', 'script'),
(NULL, 16, 'pjCategory', 1, 'name', 'Legal Jobs', 'script'),
(NULL, 17, 'pjCategory', 1, 'name', 'Logistics/Transportation Jobs', 'script'),
(NULL, 18, 'pjCategory', 1, 'name', 'Manufacturing/Production/Operations Jobs', 'script'),
(NULL, 19, 'pjCategory', 1, 'name', 'Marketing/Product Jobs', 'script'),
(NULL, 20, 'pjCategory', 1, 'name', 'Medical/Health Jobs', 'script'),
(NULL, 21, 'pjCategory', 1, 'name', 'Other Jobs', 'script'),
(NULL, 22, 'pjCategory', 1, 'name', 'Project/Program Management Jobs', 'script'),
(NULL, 23, 'pjCategory', 1, 'name', 'Quality Assurance/Safety Jobs', 'script'),
(NULL, 24, 'pjCategory', 1, 'name', 'Sales/Retail/Business Development Jobs', 'script'),
(NULL, 25, 'pjCategory', 1, 'name', 'Security/Protective Services Jobs', 'script'),
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Types', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Are you sure you want to delete selected record(s)?', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Type updated!', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Type added!', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Error: failed to add type!', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Type not found!', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Your changes to the type have been saved.', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'The new type has been added to the list.', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Oops! The type you are looking for is missing.', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Category updated!', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Category added!', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Error: failed to add category!', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Category not found!', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Your changes to the category have been saved.', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'The new category has been added to the list.', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Oops! The category you are looking for is missing.', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Countries', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Country updated!', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Country added!', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Country failed to add.', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Country not found!', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Your changes to country has been saved.', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'A new country has been added!', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Oops! The country you are looking for is missing.', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Employees', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Add employee', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Employee updated!', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Employee added!', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Error: failed to add employee!', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Employee not found!', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Your changes to the employee have been saved.', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'The new employee has been added to the list.', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Oops! The employee you are looking for is missing.', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'CV', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Only file with extension doc; pdf; docx is allowed.', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Update employee', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Open', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Download', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Delete CV confirmation', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Are you sure that you want to delete this CV?', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Employers', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Employer updated!', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Employer added!', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Error: failed to add employer!', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Employer not found!', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Your changes to the employer have been saved.', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'The new employer has been added to the list.', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Oops! The employer you are looking for is missing.', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Add employer', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Contact name', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Logo', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Delete logo', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Are you sure that you want to delete this logo?', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Update employer', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Applications', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Jobs', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Add job', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Published', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Unpublished', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Ref ID', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Is published', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Is featured', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Employer details', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Job updated!', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Job added!', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Error: failed to add job!', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Job not found!', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Your changes to the job have been saved.', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'A new job has been added to the list.', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Oops! The job you are looking for is missing.', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Added on', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Last updated on', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Expired on', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Show on job details page', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Job title', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Salary', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Job description', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Zip code', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Show employer details', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Employer', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Job offer address', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Click on the button to find address coordinates. You can also enter long/lat coordinates for the company address.', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Get from Google Maps API using the address', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Latitude', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Longitude', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Address not found', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Keyword', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Applied job', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'URL to web page where jobs listing is placed', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Email address', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Employee account is confirmed by default', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Featured jobs', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Allow users to add job offers', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Employer account confirmed by default', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Allow employees to apply for a job', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Follow the steps below to install job listing script on your web page.', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Step 2. Copy and paste following code inside your html code, where the job listing will be displayed.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Search for jobs', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Keyword', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Employers', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Candidates', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam semper lacinia libero vitae iaculis. ', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam semper lacinia libero vitae iaculis. ', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Confirm password', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Contact name', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Logo', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Confirm password is required.', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Company name is required.', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'First name is required.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Last name is required.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'CV', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Only files with extension docx|doc|pdf are allowed.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Email was registered by another.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Sorry! Your account could not be created successfully.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Your account has been created and confirmed too.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Your account has been created, but it is not confirmed yet.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'The information you entered is invalid.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Sorry! Your account could not be saved successfully.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Your account has been created and confirmed too.', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Your account has been created, but it is not confirmed yet.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'The information you entered is invalid.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam semper lacinia libero vitae iaculis.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam semper lacinia libero vitae iaculis.', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Login failed! Email or password is wrong.', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Login failed! Your account is still not activated.', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Login failed! You entered invalid data.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Open', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Download', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Are you sure that you want to delete this file?', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Failed to delete the file!', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'The profile has been updated.', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Salary', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Expire on', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Employer details', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Job description', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Apply for this job position', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Apply', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Error occurred! The application form could not be saved correctly.', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Your application has been sent to the employer successfully.', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'The information you entered is invalid.', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'View application', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Employee account', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'View employee', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Employer login', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Employer login', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Admin login', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Job offer confirmation', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Job offer application', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'All changes made to notifications have been saved.', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'available tokens:\r\n<br/>\r\n{fname}\r\n<br/>\r\n{refid}', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'available tokens:\r\n<br/>\r\n{refid}\r\n<br/>\r\n{fname}\r\n<br/>\r\n{lname}\r\n<br/>\r\n{email}\r\n<br/>\r\n{notes}', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'available tokens:\r\n<br/>\r\n{fname}\r\n<br/>\r\n{password}', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Your CV', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Send latest CV', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'All changes to the profiles have been saved.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Job type', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'No job found!', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Sorry! we could not find out your email address.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'The password has been sent to your mail box.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Add new job', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Enter the required fields and add a new job ad.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Set a date until the job will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Based on expiration date', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Publish the job permanently, hide it or publish until the expiration date set.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Exp.date', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Extend expiration date', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Submissions', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Front-end Submissions', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Allow employers to post jobs and set various options.', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Paypal address', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'You can create different periods for the jobs to be posted on your website. Set different price for each period or 0 if you want to add a free period.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Add period / price', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Are you sure you want to delete selected period/price?', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Submissions updated', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'All changes made to the submissions have been saved.', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Buy now', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'FREE', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Extend your period for FREE', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your jobs.', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with job listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 619, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling put the following code into the HEAD part of your web page.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Install updated', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'All the changes made to install have been saved.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Job offer confirmation', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Job offer application', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'This email will be sent to the candidates who applied for a job.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'This email will be sent to the administrator and the job owner.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'This is password reminder email message.', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Extend Exp', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Job', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Jobs', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Employers', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Application', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Applications', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Latest Jobs', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Latest Employers', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Latest Applications', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Employer not found', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Application not found', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Job not found', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Linkedin', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Linkedin', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Registered on', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'The Ref ID was already in use.', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'The account of employer who posted the job does not exist on the system anymore.', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'The account of employer who posted the job has been disabled.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'The current job has not been published.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'The current just has just been expired.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'New job notification', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'available tokens:\r\n<br/><br/>\r\n{refid}<br/>\r\n{editjoburl}', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'New job notification', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'This email will be sent to the administrator when new job is posted.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'not yet', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'The job type has been de-activated or deleted by the administrator.', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'The job category has been de-activated or deleted by the administrator.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'System notice', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Your plan has been extended.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Type title was already in use.', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Most Popular Jobs', 'script'),
(NULL, 1, 'pjNotification', 1, 'message1', 'Dear {fname},\r\n\r\nYour job application for job: {refid} is received.\r\n \r\nThank you', 'script'),
(NULL, 1, 'pjNotification', 1, 'subject2', 'Job offer application', 'script'),
(NULL, 1, 'pjNotification', 1, 'message2', 'You received a new application for job : {refid}\r\n\r\nFirst Name: {fname}\r\nLast Name: {lname}\r\nE-Mail: {email}\r\n\r\nThis email was automatically generated, please do not reply.', 'script'),
(NULL, 1, 'pjNotification', 1, 'subject3', 'New job notification', 'script'),
(NULL, 1, 'pjNotification', 1, 'message3', 'A new job has been posted. \r\n\r\nReference ID: {refid}\r\n\r\nEdit the job ad here: {editjoburl}\r\n\r\nThank you!', 'script'),
(NULL, 1, 'pjNotification', 1, 'subject4', 'Password reminder', 'script'),
(NULL, 1, 'pjNotification', 1, 'message4', 'Dear {fname},\r\n\r\nyour password is: {password}\r\n \r\nThank you', 'script'),
(NULL, 1, 'pjNotification', 1, 'subject1', 'Job offer confirmation', 'script'),
(NULL, 2, 'pjNotification', 1, 'subject2', 'Job offer application', 'script'),
(NULL, 2, 'pjNotification', 1, 'message2', 'You received a new application for job : {refid}\r\n\r\nFirst Name: {fname}\r\nLast Name: {lname}\r\nE-Mail: {email}\r\n\r\nThis email was automatically generated, please do not reply.', 'script'),
(NULL, 2, 'pjNotification', 1, 'subject1', 'Job offer confirmation', 'script'),
(NULL, 2, 'pjNotification', 1, 'message1', 'Dear {fname},\r\n\r\nYour job application for job: {refid} is received.\r\n \r\nThank you', 'script'),
(NULL, 2, 'pjNotification', 1, 'subject3', 'New job notification', 'script'),
(NULL, 2, 'pjNotification', 1, 'message3', 'A new job has been posted. \r\n\r\nReference ID: {refid}\r\n\r\nEdit the job ad here: {editjoburl}\r\n\r\nThank you!', 'script'),
(NULL, 2, 'pjNotification', 1, 'subject4', 'Password reminder', 'script'),
(NULL, 2, 'pjNotification', 1, 'message4', 'Dear {fname},\r\n\r\nyour password is: {password}\r\n \r\nThank you', 'script'),
(NULL, 3, 'pjNotification', 1, 'subject1', 'Job offer confirmation', 'script'),
(NULL, 3, 'pjNotification', 1, 'message1', 'Dear {fname},\r\n\r\nYour job application for job: {refid} is received.\r\n \r\nThank you', 'script'),
(NULL, 3, 'pjNotification', 1, 'subject2', 'Job offer application', 'script'),
(NULL, 3, 'pjNotification', 1, 'message2', 'You received a new application for job : {refid}\r\n\r\nFirst Name: {fname}\r\nLast Name: {lname}\r\nE-Mail: {email}\r\n\r\nThis email was automatically generated, please do not reply.', 'script'),
(NULL, 3, 'pjNotification', 1, 'subject4', 'Password reminder', 'script'),
(NULL, 3, 'pjNotification', 1, 'message4', 'Dear {fname},\r\n\r\nyour password is: {password}\r\n \r\nThank you', 'script'),
(NULL, 3, 'pjNotification', 1, 'subject3', 'New job notification', 'script'),
(NULL, 3, 'pjNotification', 1, 'message3', 'A new job has been posted. \r\n\r\nReference ID: {refid}\r\n\r\nEdit the job ad here: {editjoburl}\r\n\r\nThank you!', 'script'),
(NULL, 4, 'pjNotification', 1, 'message4', 'Dear {fname},\r\n\r\nyour password is: {password}\r\n \r\nThank you', 'script'),
(NULL, 4, 'pjNotification', 1, 'subject1', 'Job offer confirmation', 'script'),
(NULL, 4, 'pjNotification', 1, 'message1', 'Dear {fname},\r\n\r\nYour job application for job: {refid} is received.\r\n \r\nThank you', 'script'),
(NULL, 4, 'pjNotification', 1, 'subject2', 'Job offer application', 'script'),
(NULL, 4, 'pjNotification', 1, 'message2', 'You received a new application for job : {refid}\r\n\r\nFirst Name: {fname}\r\nLast Name: {lname}\r\nE-Mail: {email}\r\n\r\nThis email was automatically generated, please do not reply.', 'script'),
(NULL, 4, 'pjNotification', 1, 'subject3', 'New job notification', 'script'),
(NULL, 4, 'pjNotification', 1, 'message3', 'A new job has been posted. \r\n\r\nReference ID: {refid}\r\n\r\nEdit the job ad here: {editjoburl}\r\n\r\nThank you!', 'script'),
(NULL, 4, 'pjNotification', 1, 'subject4', 'Password reminder', 'script'),
(NULL, 1, 'pjType', 1, 'name', 'Contract', 'script'),
(NULL, 2, 'pjType', 1, 'name', 'Full Time', 'script'),
(NULL, 3, 'pjType', 1, 'name', 'Internship', 'script'),
(NULL, 4, 'pjType', 1, 'name', 'Other', 'script'),
(NULL, 5, 'pjType', 1, 'name', 'Part Time', 'script'),
(NULL, 6, 'pjType', 1, 'name', 'Temp', 'script');

INSERT INTO `joblisting_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_item_per_page', 1, '5', NULL, 'int', 5, 1, NULL),
(1, 'o_is_employee_confirmed', 1, 'Yes|No::Yes', NULL, 'enum', 8, 1, NULL),
(1, 'o_is_applying_job_allowed', 1, 'Yes|No::Yes', NULL, 'enum', 9, 1, NULL),
(1, 'o_layout', 1, 'layout_1|layout_2|layout_3::layout_1', 'Layout 1|Layout 2|Layout 3', 'enum', 10, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 11, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 13, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 14, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_is_adding_job_allowed', 2, 'Yes|No::Yes', NULL, 'enum', 1, 1, NULL),
(1, 'o_is_employer_confirmed', 2, 'Yes|No::Yes', NULL, 'enum', 2, 1, NULL),
(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 3, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 4, 1, NULL),
(1, 'o_job_page', 99, '', NULL, 'string', 6, 1, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', 13, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `joblisting_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');