<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjJobModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'jobs';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'employer_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'type_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'category_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'country_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'address_postcode', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_content', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'address_city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_state', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'job_refid', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'job_salary', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'views', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'modified', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'expired', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'expired_show', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'employer_show', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'last_extend', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'is_featured', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'F')
	);
	
	public $i18n = array('job_title', 'job_description', 'company_name', 'meta_title', 'meta_keywords', 'meta_description', 'address_content', 'address_city', 'address_state');
	
	protected $validate = array(
		'rules' => array(
			'job_refid' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'type_id' => 'pjActionRequired',
			'category_id' => 'pjActionRequired',
			'status' => 'pjActionRequired'
		)
	);

	public static function factory($attr=array())
	{
		return new pjJobModel($attr);
	}
}
?>