<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoUpdateEmployeeTitle', true), __('infoUpdateEmployeeDesc', true));
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployees&amp;action=pjActionUpdate" method="post" id="frmUpdateEmployee" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="employee_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<p>
			<label class="title"><?php __('email'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
				<input type="text" name="email" id="email" class="pj-form-field required email w200" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['email'])); ?>" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('pass'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
				<input type="text" name="password" id="password" class="pj-form-field required w200" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['password'])); ?>" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblFirstName'); ?></label>
			<span class="inline_block">
				<input type="text" name="fname" id="fname" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['fname'])); ?>" class="pj-form-field w250 required" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblLastName'); ?></label>
			<span class="inline_block">
				<input type="text" name="lname" id="lname" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['lname'])); ?>" class="pj-form-field w250 required" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblPhone'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
				<input type="text" name="phone" id="phone" class="pj-form-field w150" placeholder="(123) 456-7890" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['phone'])); ?>" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblLinkedin'); ?></label>
			<span class="inline_block">
				<input type="text" name="linkedin" id="linkedin" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['linkedin'])); ?>" class="pj-form-field w250" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblCV'); ?></label>
			<span class="inline_block">
				<input type="file" name="cv" id="cv" class="pj-form-field w250" />
			</span>
		</p>
		<?php
		
		if(isset($tpl['file_arr']))
		{
			$file = $tpl['file_arr'];
			if(!empty($file['file_path']))
			{
				$file_path = PJ_INSTALL_PATH . $file['file_path'];
				$file_url = PJ_INSTALL_URL . $file['file_path'];
				if(file_exists($file_path))
				{
					?>
					<p id="cv_container">
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<label class="content r10"><?php echo $file['file_name'];?></label>
							<a target="_blank" class="icon download-file r10" href="<?php echo PJ_INSTALL_URL;?>index.php?controller=pjAdminEmployees&action=pjActionDownloadFile&id=<?php echo $file['id']; ?>&hash=<?php echo $file['hash']; ?>"><?php echo strtolower(__('lnkDownload', true));?></a>
							<a href="javascript:void(0);" class="icon delete-file" rev="<?php echo $file['id']?>"><?php echo strtolower(__('lnkDelete', true));?></a>
						</span>
					</p>
					<?php
				}
			}
		} 
		?>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('employee_statarr', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEmployees&action=pjActionIndex';" />
		</p>
	</form>
	<div id="dialogDeleteCV" title="<?php __('	lblDeleteDVTitle'); ?>" style="display:none">
		<p><?php __('lblDeleteCVBody'); ?></p>
	</div>
	<script type="text/javascript">
		var myLabel = myLabel || {};
		myLabel.field_required = "<?php __('jl_field_required'); ?>";
		myLabel.email_invalid = "<?php __('jl_email_invalid'); ?>";
		myLabel.email_taken = "<?php __('jl_email_taken'); ?>";
		myLabel.file_allowed = "<?php __('jl_file_allowed'); ?>";
	</script>
	<?php
}
?>