var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateEmployer = $("#frmCreateEmployer"),
			$frmUpdateEmployer = $("#frmUpdateEmployer"),
			$frmUpdateProfile = $("#frmUpdateProfile"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateEmployer.length > 0 && validate) {
			$.validator.addMethod(
			    "fileAccept",
			    function(value, element) {
			    	if(value != '')
			    	{
			    		var ext = value.split('.').pop().toLowerCase();
				    	if($.inArray(ext, ['docx','pdf','doc']) == -1) {
				    	    return false;
				    	}else{
				    		return true;
				    	}
			    	}else{
			    		return true;
			    	}
			    }, myLabel.file_allowed
			);
			$frmCreateEmployer.validate({
				rules: {
					"email": {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminEmployers&action=pjActionCheckEmail"
					},
					"cv":{
						fileAccept: function(element){
							return $("#cv").val();
		            	}
					}
				},
				messages: {
					"email": {
						required: myLabel.field_required,
						email: myLabel.email_invalid,
						remote: myLabel.email_taken
					},
					"company_name": {
						required: myLabel.field_required
					},
					"password": {
						required: myLabel.field_required
					},
					"i18n[1][description]": {
						required: myLabel.field_required
					},
					"i18n[2][description]": {
						required: myLabel.field_required
					},
					"i18n[3][description]": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateEmployer.length > 0 && validate || ($frmUpdateProfile.length > 0 && validate)) {
			$.validator.addMethod(
			    "fileAccept",
			    function(value, element) {
			    	var ext = value.split('.').pop().toLowerCase();
			    	if($.inArray(ext, ['docx','pdf','doc']) == -1) {
			    	    return false;
			    	}else{
			    		return true;
			    	}
			    }, myLabel.file_allowed
			);
			$frmUpdateEmployer.validate({
				rules: {
					"email": {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminEmployers&action=pjActionCheckEmail&id=" + $frmUpdateEmployer.find("input[name='id']").val()
					},
					"cv":{
						fileAccept: function(element){
							return $("#cv").val();
		            	}
					}
				},
				messages: {
					"email": {
						required: myLabel.field_required,
						email: myLabel.email_invalid,
						remote: myLabel.email_taken
					},
					"company_name": {
						required: myLabel.field_required
					},
					"password": {
						required: myLabel.field_required
					},
					"i18n[1][description]": {
						required: myLabel.field_required
					},
					"i18n[2][description]": {
						required: myLabel.field_required
					},
					"i18n[3][description]": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			
			$frmUpdateProfile.validate({
				rules: {
					"email": {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminEmployers&action=pjActionCheckEmail&id=" + $frmUpdateProfile.find("input[name='id']").val()
					},
					"cv":{
						fileAccept: function(element){
							return $("#cv").val();
		            	}
					}
				},
				messages: {
					"email": {
						remote: myLabel.email_taken
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			
			$('.delete-logo').on('click', function(e){
				e.preventDefault();
				var employer_id = $(this).attr('rev');
				$("#dialogDeleteLogo").dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					height:150,
					modal: true,
					
					buttons: {
						'Delete': function() {
							$.ajax({
								type: "POST",
								data: {
									id: employer_id
								},
								dataType: 'json',
								url: "index.php?controller=pjAdminEmployers&action=pjActionDeleteLogo",
								success: function (res) {
									if(res.status == 1){
										$("#logo_container").remove();
									}
								}
							});
							$(this).dialog('close');			
						},
						'Cancel': function() {
							$(this).dialog('close');
						}
					}
				});
				$("#dialogDeleteLogo").dialog('open');
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function formatJobs (str, obj) 
			{
				if(str != '0')
				{
					return '<a href="index.php?controller=pjAdminJobs&action=pjActionIndex&employer_id='+obj.id+'">'+str+'</a>';
				}else{
					return str;
				}
			}
			function formatApps (str, obj) 
			{
				if(str != '0')
				{
					return '<a href="index.php?controller=pjAdminApplications&action=pjActionIndex&employer_id='+obj.id+'">'+str+'</a>';
				}else{
					return str;
				}
			}
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminEmployers&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminEmployers&action=pjActionDeleteEmployer&id={:id}"}
				          ],
				columns: [{text: myLabel.company_name, type: "text", sortable: true, editable: false, width: 190},
				          {text: myLabel.email, type: "text", sortable: true, editable: true, width: 160},
				          {text: myLabel.jobs, type: "text", sortable: true, editable: false, width: 50, align: "center", renderer: formatJobs},
				          {text: myLabel.applications, type: "text", sortable: true, editable: false, width: 100, align: "center", renderer: formatApps},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminEmployers&action=pjActionGetEmployer",
				dataType: "json",
				fields: ['company_name', 'email', 'cnt_jobs', 'cnt_apps', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminEmployers&action=pjActionDeleteEmployerBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.revert_status, url: "index.php?controller=pjAdminEmployers&action=pjActionStatusEmployer", render: true},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminEmployers&action=pjActionExportEmployer", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminEmployers&action=pjActionSaveEmployer&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminEmployers&action=pjActionGetEmployer", "company_name", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminEmployers&action=pjActionGetEmployer", "company_name", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-status-1", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		}).on("click", ".pj-status-0", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.post("index.php?controller=pjAdminEmployers&action=pjActionSetActive", {
				id: $(this).closest("tr").data("object")['id']
			}).done(function (data) {
				$grid.datagrid("load", "index.php?controller=pjAdminEmployers&action=pjActionGetEmployer");
			});
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminEmployers&action=pjActionGetEmployer", "id", "ASC", content.page, content.rowCount);
			return false;
		});
	});
})(jQuery_1_8_2);