var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateFilter = $("#frmCreateFilter"),
			$frmUpdateFilter = $("#frmUpdateFilter"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);

		if ($frmCreateFilter.length > 0 && validate) {
			$frmCreateFilter.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
					}
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
		}
		if ($frmUpdateFilter.length > 0 && validate) {
			$frmUpdateFilter.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					$(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var gridOpts = {
				buttons: [{type: "edit", url: "index.php?controller=pjAdminFilters&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminFilters&action=pjActionDeleteFilter&id={:id}"}
				          ],
				columns: [{text: myLabel.filter_type, type: "text", sortable: true, editable: false, width: 150},
				          {text: myLabel.filter_name, type: "text", sortable: true, editable: false, width: 350},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminFilters&action=pjActionGetFilter" + pjGrid.queryString,
				dataType: "json",
				fields: ['type', 'name', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminFilters&action=pjActionDeleteFilterBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminFilters&action=pjActionSaveFilter&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			}
			if(pjGrid.queryString != "")
			{
				gridOpts.columns = [{text: myLabel.filter_type, type: "text", sortable: true, editable: false, width: 150},
							        {text: myLabel.filter_name, type: "text", sortable: true, editable: false, width: 270},
							        {text: myLabel.order, type: "text", sortable: true, editable: false, width: 80, align: "center", css:{cursor: "move"}},
							        {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
							                                                                                     {label: myLabel.active, value: "T"}, 
							                                                                                     {label: myLabel.inactive, value: "F"}
							                                                                                     ], applyClass: "pj-status"}];
				gridOpts.fields = ['type', 'name', 'sort', 'status'];
				gridOpts.sortable = true;
				gridOpts.sortableUrl = "index.php?controller=pjAdminFilters&action=pjActionSortFilter" + pjGrid.queryString;
			}
			var $grid = $("#grid").datagrid(gridOpts);
		}
		$("#content").on("change", "#filter_by_type", function (e) {
			$(this).closest('form').submit();
		});
	});
})(jQuery_1_8_2);