<?php
mt_srand();
$index = mt_rand(1, 9999);
?>
<div id="pjWrapper">
	<div class="container-fluid pjMlContainer">
		<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/header.php';?>
		
		<div class="row pjMlBody pjMlAccess">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 pjMlForm pjMlFormLogIn">
				
				<p class="pjMlFormTitle"><?php __('front_your_profile');?></p><!-- /.pjMlFormTitle -->
				<br/>
				<?php
				if(isset($tpl['err']))
				{
					$front_err = pjSanitize::clean(__('front_err', true));
					$error_message = $front_err[$tpl['err']];
					$error_message = str_replace("{MAXSIZE}", ini_get('post_max_size'), $error_message);
					?>
					<div class="alert alert-danger" role="alert"><?php echo $error_message;?></div>
					<?php
				}
				if(isset($tpl['msg']))
				{
					$front_msg = pjSanitize::clean(__('front_msg', true));
					?>
					<div class="alert alert-success" role="alert"><?php echo $front_msg[$tpl['msg']];?></div>
					<?php
				} 
				?>
				<div>
					<ul class="nav nav-tabs" role="tablist">
					    <li role="presentation" class="active"><a href="#details" aria-controls="details" role="tab" data-toggle="tab"><?php __('front_tab_details');?></a></li>
					    <li role="presentation"><a href="#photos" aria-controls="photos" role="tab" data-toggle="tab"><?php __('front_tab_photos');?></a></li>
				 	</ul>
				 	<div class="tab-content">
					    <div role="tabpanel" class="tab-pane active" id="details">
					   		<div class="row">
					   			<form id="pjMLProfileForm_<?php echo $index;?>" action="<?php echo $_SERVER['PHP_SELF'];?>?controller=pjLoad&amp;action=pjActionProfile" method="post" data-toggle="validator" role="form" autocomplete="off" enctype="multipart/form-data">
									<input type="hidden" name="profile" value="1" />
									<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
									
									<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 pjMlFormBody">
										<div class="form-group">
											<label for=""><?php __('front_email_address');?>: </label>
											
											<input type="email" name="email" value="<?php echo pjSanitize::html($tpl['arr']['email']);?>" class="form-control required email" data-msg-required="<?php __('front_field_required');?>" data-msg-email="<?php __('front_email_invalid');?>" data-msg-remote="<?php __('front_email_in_used');?>"/>
											<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_password');?>: </label>
											
											<input type="password" id="pjMLPassword_<?php echo $index;?>" value="<?php echo pjSanitize::html($tpl['arr']['password']);?>" name="password" class="form-control required" data-msg-required="<?php __('front_field_required');?>"/>
											<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_name');?>: </label>
											
											<input type="text" name="i18n[<?php echo $controller->getLocaleId(); ?>][name]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$controller->getLocaleId()]['name']); ?>" class="form-control required" data-msg-required="<?php __('front_field_required');?>"/>
											<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_phone');?>: </label>
											
											<input type="text" name="phone" value="<?php echo pjSanitize::html($tpl['arr']['phone']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_age');?>: </label>
											
											<input type="text" name="age" value="<?php echo pjSanitize::html($tpl['arr']['age']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_address');?>: </label>
											
											<input type="text" name="i18n[<?php echo $controller->getLocaleId(); ?>][address]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$controller->getLocaleId()]['address']); ?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_city');?>: </label>
											
											<input type="text" name="i18n[<?php echo $controller->getLocaleId(); ?>][city]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$controller->getLocaleId()]['city']); ?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_state');?>: </label>
											
											<input type="text" name="i18n[<?php echo $controller->getLocaleId(); ?>][state]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$controller->getLocaleId()]['state']); ?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_zip');?>: </label>
											
											<input type="text" name="zip" value="<?php echo pjSanitize::html($tpl['arr']['zip']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_country');?>: </label>
											
											<select name="country_id" class="form-control">
												<option value="">-- <?php __('front_select');?> --</option>
												<?php
												foreach($tpl['country_arr'] as $v)
												{
													?><option value="<?php echo $v['id'];?>"<?php echo $tpl['arr']['country_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['country_title']);?></option><?php
												} 
												?>
											</select>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_avatar');?>: </label>
											
											<input type="file" name="avatar"/>
										</div><!-- /.form-group -->
										<?php
										if(!empty($tpl['arr']['avatar_path']) && is_file(PJ_INSTALL_PATH . $tpl['arr']['avatar_path']))
										{
											?>
											<div id="pjMLAvatarContainer" class="form-group" style="overflow: hidden;">
												<img class="img-responsive pull-left" src="<?php echo PJ_INSTALL_URL . $tpl['arr']['avatar_path']?>"/>
												&nbsp;&nbsp;<a href="#" class="pjMLOpenAvatarModal" data-id="<?php echo $tpl['arr']['id'];?>"><i class="fa fa-times"></i>&nbsp;<?php __('front_delete');?></a>
											</div><!-- /.form-group -->
											
											<div class="modal fade" id="pjMLDeleteAvatarModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
											  	<div class="modal-dialog" role="document">
											    	<div class="modal-content">
											      		<div class="modal-body">
											        		<?php __('front_delete_avatar_confirm');?>
											      		</div>
											      		<div class="modal-footer">
											        		<button type="button" class="btn btn-default" data-dismiss="modal"><?php __('front_btn_close');?></button>
											        		<button type="button" class="btn btn-primary pjMLDeleteAvatar" data-id="<?php echo $tpl['arr']['id'];?>"><?php __('front_btn_delete');?></button>
											      		</div>
											    	</div>
											  	</div>
											</div>
											<?php
										} 
										?>
										<div class="form-group">
											<label for=""><?php __('front_biography');?>: </label>
											
											<textarea name="i18n[<?php echo $controller->getLocaleId(); ?>][biography]" class="form-control textarea"><?php echo stripslashes(@$tpl['arr']['i18n'][$controller->getLocaleId()]['biography']); ?></textarea>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_facebook');?>: </label>
											
											<input type="text" name="facebook" value="<?php echo pjSanitize::html($tpl['arr']['facebook']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										<?php /*
										<div class="form-group">
											<label for=""><?php __('front_google_plus');?>: </label>
											
											<input type="text" name="google" value="<?php echo pjSanitize::html($tpl['arr']['google']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										*/ ?>
										<div class="form-group">
											<label for=""><?php __('front_linkedin');?>: </label>
											
											<input type="text" name="linkedin" value="<?php echo pjSanitize::html($tpl['arr']['linkedin']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										<div class="form-group">
											<label for=""><?php __('front_twitter');?>: </label>
											
											<input type="text" name="twitter" value="<?php echo pjSanitize::html($tpl['arr']['twitter']);?>" class="form-control"/>
										</div><!-- /.form-group -->
										
										<div class="form-group">
											<label for=""><?php __('front_skills');?>: </label>
											
											<div class="row">
												<?php
												foreach($tpl['skill_arr'] as $v)
												{
													?>
													<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
														<div class="pjMlCheckbox pjMlCustomCheckbox">
															<input type="checkbox" id="skill_<?php echo $v['id'];?>"<?php echo in_array($v['id'], $tpl['skill_id_arr']) ? ' checked="checked"' : NULL;?> name="skill_id[]" value="<?php echo $v['id'];?>"/>
			
															<label for="skill_<?php echo $v['id'];?>">
																<span class="pjMlCustomCheckboxFake">
																	<i class="fa fa-check"></i>
																</span>
			
																<?php echo pjSanitize::html($v['name']);?>
															</label>
														</div><!-- /.pjMlCheckbox pjMlCustomCheckbox -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-6 -->
													<?php
												} 
												?>
											</div><!-- /.row -->
										</div><!-- /.form-group -->
										
										<div class="pjMlFormActions">
											<button type="submit" class="btn btn-default pjMlBtn pjMlBtnPrimary"><?php __('front_btn_save');?></button>
										
										</div><!-- /.pjMlFormActions -->
									</div><!-- /.pjMlFormBody -->
								</form>
							</div> 	
					    </div><!-- /.details TAB -->
					    <div role="tabpanel" class="tab-pane" id="photos">
					    	<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 pjMlFormBody">
					    		<form id="pjMLUploadForm_<?php echo $index;?>" action="<?php echo $_SERVER['PHP_SELF'];?>?controller=pjLoad&amp;action=pjActionUpload" method="post" data-toggle="validator" role="form" autocomplete="off" enctype="multipart/form-data">
									<input type="hidden" name="upload" value="1" />
									<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
									
									<div class="form-group">
										<label for=""><?php __('front_photo');?>: </label>
										
										<input type="file" id="pjMLPhoto_<?php echo $index;?>" name="image" class="required" data-msg-required="<?php __('front_field_required');?>"/>
										<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
									</div><!-- /.form-group -->
									
									<div id="pjMLUploadMessage_<?php echo $index;?>" class="alert" role="alert" data-info="<?php __('front_upload_processing');?>" style="display:none;"></div>
									
									<div class="pjMlFormActions">
										<button type="submit" class="btn btn-default pjMlBtn pjMlBtnPrimary"><?php __('front_btn_upload');?></button>
									
									</div><!-- /.pjMlFormActions -->
								</form>
					    	</div><!-- /.col-lg-12 col-md-12 col-sm-12 col-xs-12 pjMlFormBody -->
					    	<div id="pjMLGallery_<?php echo $index;?>" class="col-lg-12 col-md-12 col-sm-12 col-xs-12 pjMlFormBody">
					    		<div class="row pjMlProfileThumbs">
									<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/gallery.php';?>
								</div><!-- /.row pjMlProfileThumbs -->
					    	</div><!-- /.col-lg-12 col-md-12 col-sm-12 col-xs-12 pjMlFormBody -->
					    	
					    	<div class="modal fade" id="pjMLDeletePhotoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
							  	<div class="modal-dialog" role="document">
							    	<div class="modal-content">
							      		<div class="modal-body">
							        		<?php __('front_delete_photo_confirm');?>
							      		</div>
							      		<div class="modal-footer">
							        		<button type="button" class="btn btn-default" data-dismiss="modal"><?php __('front_btn_close');?></button>
							        		<button id="pjMLDeleteButton_<?php echo $index;?>" type="button" class="btn btn-primary pjMLDeletePhoto" data-member_id="<?php echo $tpl['arr']['id'];?>" data-id=""><?php __('front_btn_delete');?></button>
							      		</div>
							    	</div>
							  	</div>
							</div>
					    </div><!-- /.photos TAB -->
				  	</div><!-- Tab -->
				</div>
			</div><!-- /.col-lg-offset-3 col-lg-6 col-md-offset-3 col-md-6 col-sm-offset-3 col-sm-6 col-xs-12 pjMlForm pjMlFormLogIn -->
		</div>
	</div><!-- /.container-fluid pjMlContainer -->
</div><!-- /#pjWrapper -->
	
<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/loadjs.php';?>