<?php
mt_srand();
$index = mt_rand(1, 9999);
?>
<div id="pjWrapper">
	<div class="container-fluid pjMlContainer">
		<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/header.php';?>
		
		<?php
		if(!empty($tpl['arr']))
		{
			$img = 'https://placehold.it/60x60';
			if(!empty($tpl['arr']['avatar_path']))
			{
				$img = PJ_INSTALL_URL . $tpl['arr']['avatar_path'];
			}
			?>
			<div class="pjMlBody">
				<div class="panel panel-default pjMlProfile">
					<header class="panel-heading pjMlProfileHead">
						<div class="pjMlProfileImage">
							<img src="<?php echo $img;?>" alt="" />
						</div><!-- /.pjMlProfileImage -->
	
						<div class="pjMlProfileInner">
							<div class="row">
								<div class="col-lg-9 col-md-9 col-sm-8 col-xs-12">
									<p class="pjMlProfileTitle"><?php echo pjSanitize::html($tpl['arr']['name']);?></p><!-- /.pjMlProfileTitle -->
	
									<?php
									if($tpl['arr']['age'] != '')
									{ 
										?><p><?php __('front_age')?>: <?php echo $tpl['arr']['age'];?></p><?php
									} 
									?>
								</div><!-- /.col-lg-9 col-md-9 col-sm-8 col-xs-12 -->
	
								<div class="col-lg-3 col-md-3 col-sm-4 col-xs-12 text-right">
									<ul class="list-inline pjMlProfileSocials">
										<?php
										if(!empty($tpl['arr']['facebook']))
										{ 
											?>
											<li>
												<a href="<?php echo $tpl['arr']['facebook'];?>" target="_blank" class="pjMlLinkFacebook">
													<i class="fa fa-facebook"></i>
												</a>
											</li>
											<?php
										}
										if(!empty($tpl['arr']['linkedin']))
										{
											?>
											<li>
												<a href="<?php echo $tpl['arr']['linkedin'];?>" target="_blank" class="pjMlLinkLinkedin">
													<i class="fa fa-linkedin"></i>
												</a>
											</li>
											<?php
										}
										if(!empty($tpl['arr']['twitter']))
										{
											?>
											<li>
												<a href="<?php echo $tpl['arr']['twitter'];?>" target="_blank" class="pjMlLinkLinkedin">
													<i class="fa fa-twitter"></i>
												</a>
											</li>
											<?php
										}  
										?>
									</ul><!-- /.list-inline pjMlProfileSocials -->
								</div><!-- /.col-lg-3 col-md-3 col-sm-4 col-xs-12 text-right -->
							</div><!-- /.row -->
	
							<div class="pjMlProfileContacts">
								<ul class="list-inline">
									<li>
										<i class="fa fa-envelope"></i> 
										<?php echo !preg_match('/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i', $tpl['arr']['email']) ? $tpl['arr']['email'] : '<a href="mailto:'.$tpl['arr']['email'].'">'.$tpl['arr']['email'].'</a>'; ?>
									</li>
	
									<?php
									if(!empty($tpl['arr']['phone']))
									{
										?>
										<li>
											<i class="fa fa-phone-square"></i> 
											<span class="pjMlPhone"><?php echo pjSanitize::html($tpl['arr']['phone']);?></span>
										</li>
										<?php
									} 
									$add_arr = array();
									if(!empty($tpl['arr']['address']))
									{
										$add_arr[] = pjSanitize::html($tpl['arr']['address']);
									}
									if(!empty($tpl['arr']['city']))
									{
										$add_arr[] = pjSanitize::html($tpl['arr']['city']);
									}
									if(!empty($tpl['arr']['state']))
									{
										$add_arr[] = pjSanitize::html($tpl['arr']['state']);
									}
									if(!empty($tpl['arr']['zip']))
									{
										$add_arr[] = pjSanitize::html($tpl['arr']['zip']);
									}
									if(!empty($tpl['arr']['country']))
									{
										$add_arr[] = pjSanitize::html($tpl['arr']['country']);
									}
									if(!empty($add_arr))
									{
										?>
										<li>
											<i class="fa fa-map-marker"></i> 
											<?php echo join(", ", $add_arr);?>
										</li>
										<?php
									} 
									?>
								</ul><!-- /.list-inline -->
							</div><!-- /.pjMlProfileContacts -->
						</div><!-- /.pjMlProfileInner -->
					</header><!-- /.panel-heading pjMlProfileHead -->
					
					<div class="panel-body pjMlProfileBody">
						<div class="row">
							<div class="<?php echo count($tpl['gallery_arr']) > 0 ? 'col-lg-7 col-md-7 col-sm-7 col-xs-12' : 'col-lg-12 col-md-12 col-sm-12 col-xs-12'; ?>">
								<p class="pjMlProfileTitleSmall"><?php __('front_skills');?>:</p><!-- /.pjMlProfileTitleSmall -->
								<?php
								if(!empty($tpl['arr']['skills']))
								{ 
									?>
									<ul class="list-inline pjMlListLabels">
										<?php
										foreach($tpl['arr']['skills'] as $skill)
										{
											?><li><span class="label label-default"><?php echo pjSanitize::html($skill);?></span></li><?php
										} 
										?>
									</ul><!-- /.list-inline pjMlListLabels -->
									<?php
								} 
								?>
								<p class="pjMlProfileTitleSmall"><?php __('front_bio');?>:</p><!-- /.pjMlProfileTitleSmall -->
								<p><?php echo nl2br(pjSanitize::html($tpl['arr']['biography']));?></p>
							</div><!-- /.col-lg-7 col-md-7 col-sm-7 col-xs-12 -->
							<?php
							if (count($tpl['gallery_arr']) > 0)
							{ 
								?>
								<div class="col-lg-5 col-md-5 col-sm-5 col-xs-12 pjMlProfileAside">
									<p class="pjMlProfileTitleSmall"><?php __('front_photos');?>:</p><!-- /.pjMlProfileTitleSmall -->
	
									<div class="row pjMlProfileThumbs">
										<?php
										foreach ($tpl['gallery_arr'] as $k => $v)
										{
											?>
											<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pjMlProfileThumb">
												<a href="#pjMlThumbsGallery" class="thumbnail" data-slide-to="<?php echo $k;?>">
													<img src="<?php echo PJ_INSTALL_URL . $v['medium_path']; ?>" alt="" data-toggle="modal" data-target="#pjMlThumbsPopup" />
												</a>
											</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-6 pjMlProfileThumb -->
											<?php
										} 
										?>
									</div><!-- /.row pjMlProfileThumbs -->
	
									<div class="modal fade pjMlThumbsPopup" id="pjMlThumbsPopup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
										<div class="modal-dialog">
											<div class="modal-content">
												<div class="modal-body">
													<button type="button" class="close pjMlThumbsPopupCloseBtn" data-dismiss="modal">
														<span aria-hidden="true">&times;</span>
														<span class="sr-only"></span>
													</button>
													
													<div class="carousel slide pjMlThumbsGallery" id="pjMlThumbsGallery" data-interval="false">
														<div class="carousel-inner">
															<?php
															foreach ($tpl['gallery_arr'] as $k => $v)
															{
																?>
																<div class="item<?php echo $k == 0 ? ' active' : NULL;?>">
																	<img width="" src="<?php echo PJ_INSTALL_URL . $v['large_path']; ?>" alt="item<?php echo $k;?>" />
																</div><!-- /.item active -->
																<?php
															} 
															?>
														</div><!-- /.carousel-inner -->
														<?php
														if(count($tpl['gallery_arr']) > 1)
														{ 
															?>
															<a class="left carousel-control" href="#pjMlThumbsGallery" role="button" data-slide="prev">
																<i class="fa fa-chevron-left"></i>
															</a>
															<a class="right carousel-control" href="#pjMlThumbsGallery" role="button" data-slide="next">
																<i class="fa fa-chevron-right"></i>
															</a>
															<?php
														} 
														?>
													</div><!-- /#pjMlThumbsGallery.carousel slide pjMlThumbsGallery -->
												</div><!-- /.modal-body -->
											</div><!-- /.modal-content -->
										</div><!-- /.modal-dialog -->
									</div><!-- /#pjMlThumbsPopup.modal fade pjMlThumbsPopup -->
								</div><!-- /.col-lg-5 col-md-5 col-sm-5 col-xs-12 pjMlProfileAside -->
								<?php
							} 
							?>
						</div><!-- /.row -->
					</div><!-- /.panel-body pjMlProfileBody -->
				</div><!-- /.panel panel-default pjMlProfile -->
			</div><!-- /.pjMlBody -->
			<?php
		} else {
			?>
			<div class="row pjMlBody pjMlMembers">
				<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 pjMlMember">
					<p class="pjMlMemberNotFound"><?php __('front_no_members_found');?></p>
				</div>
			</div><!-- /.row pjMlBody pjMlMembers -->
			<?php
		}
		?>
			
	</div><!-- /.container-fluid pjMlContainer -->
</div><!-- /#pjWrapper -->
	
<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/loadjs.php';?>