DROP TABLE IF EXISTS `news_script_news`;
CREATE TABLE IF NOT EXISTS `news_script_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `published_date` date DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `status` enum('publish','hide','show') DEFAULT 'hide',
  `source_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `target` enum('new','current') DEFAULT 'new',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `news_script_fields`;
CREATE TABLE IF NOT EXISTS `news_script_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `news_script_multi_lang`;
CREATE TABLE IF NOT EXISTS `news_script_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `news_script_options`;
CREATE TABLE IF NOT EXISTS `news_script_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `news_script_roles`;
CREATE TABLE IF NOT EXISTS `news_script_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `news_script_users`;
CREATE TABLE IF NOT EXISTS `news_script_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `news_script_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 0, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_layout', 1, 'layout_1|layout_2|layout_3|layout_4::layout_1', 'Layout 1|Layout 2|Layout 3|Layout 4', 'enum', 5, 0, NULL),
(1, 'o_news_per_page', 1, '10', NULL, 'int', 6, 1, NULL),
(1, 'o_show_upto', 1, '7', NULL, 'int', 7, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 0, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `news_script_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');












INSERT INTO `news_script_fields` VALUES
('1', 'addLocale', 'backend', 'Add language', 'script', NULL),
('2', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('3', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('4', 'backend', 'backend', 'Backend titles', 'script', NULL),
('5', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('6', 'btnBack', 'backend', 'Button Back', 'script', NULL),
('7', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('8', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('9', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('10', 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
('11', 'btnLogin', 'backend', 'Login', 'script', NULL),
('12', 'btnReset', 'backend', 'Reset', 'script', NULL),
('13', 'btnSave', 'backend', 'Save', 'script', NULL),
('14', 'btnSearch', 'backend', 'Search', 'script', NULL),
('15', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('16', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('17', 'created', 'backend', 'Created', 'script', NULL),
('18', 'email', 'backend', 'E-Mail', 'script', NULL),
('19', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('20', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('21', 'frontend', 'backend', 'Front-end titles', 'script', NULL),
('22', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('23', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('24', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('25', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('26', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('27', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('28', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('29', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('30', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('31', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('32', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('33', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('34', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('35', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('36', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('37', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
('38', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
('39', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
('40', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
('41', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
('42', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
('43', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
('44', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
('45', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
('46', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
('47', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
('48', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
('49', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
('50', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
('51', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
('52', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
('53', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
('54', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
('55', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('56', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('57', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('58', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('59', 'lblDays', 'backend', 'Days', 'script', NULL),
('60', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('61', 'lblError', 'backend', 'Error', 'script', NULL),
('62', 'lblExport', 'backend', 'Export', 'script', NULL),
('63', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('64', 'lblIp', 'backend', 'IP address', 'script', NULL),
('65', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblNo', 'backend', 'No', 'script', NULL),
('68', 'lblOption', 'backend', 'Option', 'script', NULL),
('69', 'lblOptionList', 'backend', 'Option list', 'script', NULL),
('70', 'lblRole', 'backend', 'Role', 'script', NULL),
('71', 'lblStatus', 'backend', 'Status', 'script', NULL),
('72', 'lblType', 'backend', 'Type', 'script', NULL),
('73', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('74', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('75', 'lblValue', 'backend', 'Value', 'script', NULL),
('76', 'lblYes', 'backend', 'Yes', 'script', NULL),
('77', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('78', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
('79', 'locales', 'backend', 'Languages', 'script', NULL),
('80', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
('81', 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
('82', 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
('83', 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
('84', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('85', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('86', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
('87', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('88', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('89', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('90', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
('91', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('92', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('93', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
('94', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('95', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('96', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
('97', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
('98', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
('99', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
('100', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
('101', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('102', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
('103', 'pass', 'backend', 'Password', 'script', NULL),
('125', 'revert_status', 'backend', 'Revert status', 'script', NULL),
('126', 'url', 'backend', 'URL', 'script', NULL),
('127', 'user', 'backend', 'Username', 'script', NULL),
('128', 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
('129', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('130', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('131', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('132', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('133', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('134', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('135', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('136', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
('137', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
('138', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
('139', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
('140', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
('141', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
('142', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
('143', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('144', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('145', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('146', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('147', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
('148', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('149', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('150', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('151', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('152', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('153', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('154', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('155', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('156', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('159', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('160', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('161', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('162', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('163', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('164', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('165', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('166', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('167', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('168', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('169', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('170', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('171', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('174', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('175', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('176', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('177', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('178', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('179', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
('180', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
('181', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
('182', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
('183', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
('184', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
('185', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
('186', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
('187', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
('188', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
('189', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
('190', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
('191', 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
('192', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
('193', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
('194', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
('195', 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
('196', 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
('197', 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
('198', 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
('199', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
('200', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
('201', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
('202', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
('203', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
('204', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
('205', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
('206', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
('207', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
('208', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
('209', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
('210', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
('211', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('212', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('213', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('214', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('215', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('216', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('217', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('218', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('219', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('220', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('221', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('222', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('223', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('224', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('225', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('226', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('227', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('228', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('229', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('230', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('231', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('232', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('233', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('234', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('235', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('236', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('237', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('238', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('239', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('240', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('241', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('242', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('243', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('244', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('245', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('246', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('247', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('248', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('249', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('250', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('251', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
('252', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
('253', 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
('254', 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
('255', 'lblAll', 'backend', 'Label / All', 'script', NULL),
('256', 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
('308', 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
('360', 'menuNews', 'backend', 'Menu / News', 'script', NULL),
('361', 'menuInstall', 'backend', 'Menu / Preview & Install', 'script', NULL),
('362', 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
('363', 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
('364', 'opt_o_news_per_page', 'backend', 'Options / News per page', 'script', NULL),
('365', 'opt_o_show_upto', 'backend', 'Options / Show up to', 'script', NULL),
('417', 'lblAddNews', 'backend', 'Label / Add news', 'script', NULL),
('418', 'infoNewsListTitle', 'backend', 'Infobox / News List', 'script', NULL),
('419', 'infoNewsListDesc', 'backend', 'Infobox / News List Desc', 'script', '2014-04-30 09:32:45'),
('420', 'news_statuses_ARRAY_publish', 'arrays', 'news_statuses_ARRAY_publish', 'script', NULL),
('421', 'news_statuses_ARRAY_hide', 'arrays', 'news_statuses_ARRAY_hide', 'script', NULL),
('422', 'news_statuses_ARRAY_show', 'arrays', 'news_statuses_ARRAY_show', 'script', NULL),
('423', 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
('424', 'lblPublishedDate', 'backend', 'Lable / Published date', 'script', NULL),
('425', 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
('426', 'infoAddNewsTitle', 'backend', 'Infobox / Add News Title', 'script', NULL),
('427', 'infoAddNewsDesc', 'backend', 'Infobox / Add News Desc', 'script', NULL),
('428', 'lblDescription', 'backend', 'Lable / Description', 'script', NULL),
('429', 'lblFullNews', 'backend', 'Label / Full news', 'script', NULL),
('430', 'lblUrl', 'backend', 'Lable / URL', 'script', NULL),
('431', 'pj_invalid_url', 'backend', 'Lable / Invalid url', 'script', NULL),
('432', 'targets_ARRAY_new', 'arrays', 'targets_ARRAY_new', 'script', NULL),
('433', 'targets_ARRAY_current', 'arrays', 'targets_ARRAY_current', 'script', NULL),
('434', 'lblTarget', 'backend', 'Lable / Target', 'script', NULL),
('435', 'lblImage', 'backend', 'Lable / Image', 'script', NULL),
('436', 'error_titles_ARRAY_AN01', 'arrays', 'error_titles_ARRAY_AN01', 'script', NULL),
('437', 'error_bodies_ARRAY_AN01', 'arrays', 'error_bodies_ARRAY_AN01', 'script', NULL),
('438', 'error_titles_ARRAY_AN03', 'arrays', 'error_titles_ARRAY_AN03', 'script', NULL),
('439', 'error_bodies_ARRAY_AN03', 'arrays', 'error_bodies_ARRAY_AN03', 'script', NULL),
('440', 'error_titles_ARRAY_AN04', 'arrays', 'error_titles_ARRAY_AN04', 'script', NULL),
('441', 'error_bodies_ARRAY_AN04', 'arrays', 'error_bodies_ARRAY_AN04', 'script', NULL),
('442', 'error_titles_ARRAY_AN08', 'arrays', 'error_titles_ARRAY_AN08', 'script', NULL),
('443', 'error_bodies_ARRAY_AN08', 'arrays', 'error_bodies_ARRAY_AN08', 'script', NULL),
('444', 'lblUpdateNews', 'backend', 'Label / Update news', 'script', NULL),
('445', 'lblDeleteImage', 'backend', 'Delete Image', 'script', NULL),
('446', 'lblDeleteConfirmation', 'backend', 'Delete Image Confirmationi', 'script', NULL),
('447', 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
('448', 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
('449', 'infoUpdateNewsTitle', 'backend', 'Infobox / Update news title', 'script', NULL),
('450', 'infoUpdateNewsDesc', 'backend', 'Infobox / Update news desc', 'script', '2014-04-30 09:41:07'),
('451', 'lblInstallJs1_title', 'backend', 'Label / Installation', 'script', NULL),
('452', 'lblInstallJs1_body', 'backend', 'Label / Installation text', 'script', '2014-04-30 09:34:02'),
('453', 'lblInstallConfig', 'backend', 'Label / Installation configuration', 'script', NULL),
('454', 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
('455', 'lblInstallConfigLocale', 'backend', 'Label / Select language', 'script', NULL),
('456', 'layouts_ARRAY_layout_1', 'arrays', 'layouts_ARRAY_layout_1', 'script', NULL),
('457', 'layouts_ARRAY_layout_2', 'arrays', 'layouts_ARRAY_layout_2', 'script', NULL),
('458', 'layouts_ARRAY_layout_3', 'arrays', 'layouts_ARRAY_layout_3', 'script', NULL),
('459', 'layouts_ARRAY_layout_4', 'arrays', 'layouts_ARRAY_layout_4', 'script', NULL),
('460', 'layouts_ARRAY_layout_5', 'arrays', 'layouts_ARRAY_layout_5', 'script', NULL),
('461', 'lblInstallConfigLayout', 'backend', 'Lable / Select layout', 'script', NULL),
('513', 'front_no_news', 'frontend', 'Label / No news', 'script', NULL),
('514', 'front_prev', 'frontend', 'Label / Prev', 'script', NULL),
('515', 'front_next', 'frontend', 'Label / Next', 'script', NULL),
('516', 'front_read_more', 'frontend', 'Label / Read more', 'script', NULL),
('517', 'front_published_date', 'frontend', 'Label / Published date', 'script', NULL),
('518', 'front_back', 'frontend', 'Label / Back', 'script', NULL),
('519', 'front_read_more_plus', 'frontend', 'Label / Read more +', 'script', NULL);

INSERT INTO `news_script_multi_lang` VALUES
('1', '1', 'pjField', '1', 'title', 'Add language', 'script'),
('2', '1', 'pjField', '2', 'title', 'Add language', 'script'),
('3', '1', 'pjField', '3', 'title', 'Add language', 'script'),
('4', '2', 'pjField', '1', 'title', 'Password reminder', 'script'),
('5', '2', 'pjField', '2', 'title', 'Password reminder', 'script'),
('6', '2', 'pjField', '3', 'title', 'Password reminder', 'script'),
('7', '3', 'pjField', '1', 'title', 'Admin Login', 'script'),
('8', '3', 'pjField', '2', 'title', 'Admin Login', 'script'),
('9', '3', 'pjField', '3', 'title', 'Admin Login', 'script'),
('10', '4', 'pjField', '1', 'title', 'Back-end titles', 'script'),
('11', '4', 'pjField', '2', 'title', 'Back-end titles', 'script'),
('12', '4', 'pjField', '3', 'title', 'Back-end titles', 'script'),
('13', '5', 'pjField', '1', 'title', 'Add +', 'script'),
('14', '5', 'pjField', '2', 'title', 'Add +', 'script'),
('15', '5', 'pjField', '3', 'title', 'Add +', 'script'),
('16', '6', 'pjField', '1', 'title', '« Back', 'script'),
('17', '6', 'pjField', '2', 'title', 'Back', 'script'),
('18', '6', 'pjField', '3', 'title', '« Back', 'script'),
('19', '7', 'pjField', '1', 'title', 'Backup', 'script'),
('20', '7', 'pjField', '2', 'title', 'Backup', 'script'),
('21', '7', 'pjField', '3', 'title', 'Backup', 'script'),
('22', '8', 'pjField', '1', 'title', 'Cancel', 'script'),
('23', '8', 'pjField', '2', 'title', 'Cancel', 'script'),
('24', '8', 'pjField', '3', 'title', 'Cancel', 'script'),
('25', '9', 'pjField', '1', 'title', 'Continue', 'script'),
('26', '9', 'pjField', '2', 'title', 'Continue', 'script'),
('27', '9', 'pjField', '3', 'title', 'Continue', 'script'),
('28', '10', 'pjField', '1', 'title', 'Delete', 'script'),
('29', '10', 'pjField', '2', 'title', 'Delete', 'script'),
('30', '10', 'pjField', '3', 'title', 'Delete', 'script'),
('31', '11', 'pjField', '1', 'title', 'Login', 'script'),
('32', '11', 'pjField', '2', 'title', 'Login', 'script'),
('33', '11', 'pjField', '3', 'title', 'Login', 'script'),
('34', '12', 'pjField', '1', 'title', 'Reset', 'script'),
('35', '12', 'pjField', '2', 'title', 'Reset', 'script'),
('36', '12', 'pjField', '3', 'title', 'Reset', 'script'),
('37', '13', 'pjField', '1', 'title', 'Save', 'script'),
('38', '13', 'pjField', '2', 'title', 'Save', 'script'),
('39', '13', 'pjField', '3', 'title', 'Save', 'script'),
('40', '14', 'pjField', '1', 'title', 'Search', 'script'),
('41', '14', 'pjField', '2', 'title', 'Search', 'script'),
('42', '14', 'pjField', '3', 'title', 'Search', 'script'),
('43', '15', 'pjField', '1', 'title', 'Send', 'script'),
('44', '15', 'pjField', '2', 'title', 'Send', 'script'),
('45', '15', 'pjField', '3', 'title', 'Send', 'script'),
('46', '16', 'pjField', '1', 'title', 'Update', 'script'),
('47', '16', 'pjField', '2', 'title', 'Update', 'script'),
('48', '16', 'pjField', '3', 'title', 'Update', 'script'),
('49', '17', 'pjField', '1', 'title', 'DateTime', 'script'),
('50', '17', 'pjField', '2', 'title', 'DateTime', 'script'),
('51', '17', 'pjField', '3', 'title', 'DateTime', 'script'),
('52', '18', 'pjField', '1', 'title', 'Email', 'script'),
('53', '18', 'pjField', '2', 'title', 'Email', 'script'),
('54', '18', 'pjField', '3', 'title', 'Email', 'script'),
('55', '19', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('56', '19', 'pjField', '2', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('57', '19', 'pjField', '3', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('58', '20', 'pjField', '1', 'title', 'Password reminder', 'script'),
('59', '20', 'pjField', '2', 'title', 'Password reminder', 'script'),
('60', '20', 'pjField', '3', 'title', 'Password reminder', 'script'),
('61', '21', 'pjField', '1', 'title', 'Front-end titles', 'script'),
('62', '21', 'pjField', '2', 'title', 'Front-end titles', 'script'),
('63', '21', 'pjField', '3', 'title', 'Front-end titles', 'script'),
('64', '22', 'pjField', '1', 'title', 'Action confirmation', 'script'),
('65', '22', 'pjField', '2', 'title', 'Action confirmation', 'script'),
('66', '22', 'pjField', '3', 'title', 'Action confirmation', 'script'),
('67', '23', 'pjField', '1', 'title', 'Cancel', 'script'),
('68', '23', 'pjField', '2', 'title', 'Cancel', 'script'),
('69', '23', 'pjField', '3', 'title', 'Cancel', 'script'),
('70', '24', 'pjField', '1', 'title', 'Delete', 'script'),
('71', '24', 'pjField', '2', 'title', 'Delete', 'script'),
('72', '24', 'pjField', '3', 'title', 'Delete', 'script'),
('73', '25', 'pjField', '1', 'title', 'OK', 'script'),
('74', '25', 'pjField', '2', 'title', 'OK', 'script'),
('75', '25', 'pjField', '3', 'title', 'OK', 'script'),
('76', '26', 'pjField', '1', 'title', 'Choose Action', 'script'),
('77', '26', 'pjField', '2', 'title', 'Choose Action', 'script'),
('78', '26', 'pjField', '3', 'title', 'Choose Action', 'script'),
('79', '27', 'pjField', '1', 'title', 'Are you sure you want to delete selected record?', 'script'),
('80', '27', 'pjField', '2', 'title', 'Are you sure you want to delete selected record?', 'script'),
('81', '27', 'pjField', '3', 'title', 'Are you sure you want to delete selected record?', 'script'),
('82', '28', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('83', '28', 'pjField', '2', 'title', 'Delete confirmation', 'script'),
('84', '28', 'pjField', '3', 'title', 'Delete confirmation', 'script'),
('85', '29', 'pjField', '1', 'title', 'No records found', 'script'),
('86', '29', 'pjField', '2', 'title', 'No records found', 'script'),
('87', '29', 'pjField', '3', 'title', 'No records found', 'script'),
('88', '30', 'pjField', '1', 'title', 'Go to page:', 'script'),
('89', '30', 'pjField', '2', 'title', 'Go to page:', 'script'),
('90', '30', 'pjField', '3', 'title', 'Go to page:', 'script'),
('91', '31', 'pjField', '1', 'title', 'Items per page', 'script'),
('92', '31', 'pjField', '2', 'title', 'Items per page', 'script'),
('93', '31', 'pjField', '3', 'title', 'Items per page', 'script'),
('94', '32', 'pjField', '1', 'title', 'Next »', 'script'),
('95', '32', 'pjField', '2', 'title', 'Next »', 'script'),
('96', '32', 'pjField', '3', 'title', 'Next »', 'script'),
('97', '33', 'pjField', '1', 'title', 'Next page', 'script'),
('98', '33', 'pjField', '2', 'title', 'Next page', 'script'),
('99', '33', 'pjField', '3', 'title', 'Next page', 'script'),
('100', '34', 'pjField', '1', 'title', '« Prev', 'script'),
('101', '34', 'pjField', '2', 'title', '« Prev', 'script'),
('102', '34', 'pjField', '3', 'title', '« Prev', 'script'),
('103', '35', 'pjField', '1', 'title', 'Prev page', 'script'),
('104', '35', 'pjField', '2', 'title', 'Prev page', 'script'),
('105', '35', 'pjField', '3', 'title', 'Prev page', 'script'),
('106', '36', 'pjField', '1', 'title', 'Total items:', 'script'),
('107', '36', 'pjField', '2', 'title', 'Total items:', 'script'),
('108', '36', 'pjField', '3', 'title', 'Total items:', 'script'),
('109', '37', 'pjField', '1', 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
('110', '37', 'pjField', '2', 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
('111', '37', 'pjField', '3', 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
('112', '38', 'pjField', '1', 'title', 'Location and address', 'script'),
('113', '38', 'pjField', '2', 'title', 'Location and address', 'script'),
('114', '38', 'pjField', '3', 'title', 'Location and address', 'script'),
('115', '39', 'pjField', '1', 'title', 'Listing Bookings Body', 'script'),
('116', '39', 'pjField', '2', 'title', 'Listing Bookings Body', 'script'),
('117', '39', 'pjField', '3', 'title', 'Listing Bookings Body', 'script'),
('118', '40', 'pjField', '1', 'title', 'Listing Bookings Title', 'script'),
('119', '40', 'pjField', '2', 'title', 'Listing Bookings Title', 'script'),
('120', '40', 'pjField', '3', 'title', 'Listing Bookings Title', 'script'),
('121', '41', 'pjField', '1', 'title', 'Listing Contact Body', 'script'),
('122', '41', 'pjField', '2', 'title', 'Listing Contact Body', 'script'),
('123', '41', 'pjField', '3', 'title', 'Listing Contact Body', 'script'),
('124', '42', 'pjField', '1', 'title', 'Listing Contact Title', 'script'),
('125', '42', 'pjField', '2', 'title', 'Listing Contact Title', 'script'),
('126', '42', 'pjField', '3', 'title', 'Listing Contact Title', 'script'),
('127', '43', 'pjField', '1', 'title', 'Extend exp.date Body', 'script'),
('128', '43', 'pjField', '2', 'title', 'Extend exp.date Body', 'script'),
('129', '43', 'pjField', '3', 'title', 'Extend exp.date Body', 'script'),
('130', '44', 'pjField', '1', 'title', 'Extend exp.date Title', 'script'),
('131', '44', 'pjField', '2', 'title', 'Extend exp.date Title', 'script'),
('132', '44', 'pjField', '3', 'title', 'Extend exp.date Title', 'script'),
('133', '45', 'pjField', '1', 'title', 'Listing Prices Body', 'script'),
('134', '45', 'pjField', '2', 'title', 'Listing Prices Body', 'script'),
('135', '45', 'pjField', '3', 'title', 'Listing Prices Body', 'script'),
('136', '46', 'pjField', '1', 'title', 'Listing Prices Title', 'script'),
('137', '46', 'pjField', '2', 'title', 'Listing Prices Title', 'script'),
('138', '46', 'pjField', '3', 'title', 'Listing Prices Title', 'script'),
('139', '47', 'pjField', '1', 'title', 'Languages Array Body', 'script'),
('140', '47', 'pjField', '2', 'title', 'Languages Array Body', 'script'),
('141', '47', 'pjField', '3', 'title', 'Languages Array Body', 'script'),
('142', '48', 'pjField', '1', 'title', 'Languages Arrays Title', 'script'),
('143', '48', 'pjField', '2', 'title', 'Languages Arrays Title', 'script'),
('144', '48', 'pjField', '3', 'title', 'Languages Arrays Title', 'script'),
('145', '49', 'pjField', '1', 'title', 'Languages Backend Body', 'script'),
('146', '49', 'pjField', '2', 'title', 'Languages Backend Body', 'script'),
('147', '49', 'pjField', '3', 'title', 'Languages Backend Body', 'script'),
('148', '50', 'pjField', '1', 'title', 'Languages Backend Title', 'script'),
('149', '50', 'pjField', '2', 'title', 'Languages Backend Title', 'script'),
('150', '50', 'pjField', '3', 'title', 'Languages Backend Title', 'script'),
('151', '51', 'pjField', '1', 'title', 'Languages Body', 'script'),
('152', '51', 'pjField', '2', 'title', 'Languages Body', 'script'),
('153', '51', 'pjField', '3', 'title', 'Languages Body', 'script'),
('154', '52', 'pjField', '1', 'title', 'Languages Frontend Body', 'script'),
('155', '52', 'pjField', '2', 'title', 'Languages Frontend Body', 'script'),
('156', '52', 'pjField', '3', 'title', 'Languages Frontend Body', 'script'),
('157', '53', 'pjField', '1', 'title', 'Languages Frontend Title', 'script'),
('158', '53', 'pjField', '2', 'title', 'Languages Frontend Title', 'script'),
('159', '53', 'pjField', '3', 'title', 'Languages Frontend Title', 'script'),
('160', '54', 'pjField', '1', 'title', 'Languages Title', 'script'),
('161', '54', 'pjField', '2', 'title', 'Languages Title', 'script'),
('162', '54', 'pjField', '3', 'title', 'Languages Title', 'script'),
('163', '55', 'pjField', '1', 'title', 'Add user', 'script'),
('164', '55', 'pjField', '2', 'title', 'Add user', 'script'),
('165', '55', 'pjField', '3', 'title', 'Add user', 'script'),
('166', '56', 'pjField', '1', 'title', 'Backup database', 'script'),
('167', '56', 'pjField', '2', 'title', 'Backup database', 'script'),
('168', '56', 'pjField', '3', 'title', 'Backup database', 'script'),
('169', '57', 'pjField', '1', 'title', 'Backup files', 'script'),
('170', '57', 'pjField', '2', 'title', 'Backup files', 'script'),
('171', '57', 'pjField', '3', 'title', 'Backup files', 'script'),
('172', '58', 'pjField', '1', 'title', 'Choose', 'script'),
('173', '58', 'pjField', '2', 'title', 'Choose', 'script'),
('174', '58', 'pjField', '3', 'title', 'Choose', 'script'),
('175', '59', 'pjField', '1', 'title', 'days', 'script'),
('176', '59', 'pjField', '2', 'title', 'days', 'script'),
('177', '59', 'pjField', '3', 'title', 'days', 'script'),
('178', '60', 'pjField', '1', 'title', 'Delete', 'script'),
('179', '60', 'pjField', '2', 'title', 'Delete', 'script'),
('180', '60', 'pjField', '3', 'title', 'Delete', 'script'),
('181', '61', 'pjField', '1', 'title', 'Error', 'script'),
('182', '61', 'pjField', '2', 'title', 'Error', 'script'),
('183', '61', 'pjField', '3', 'title', 'Error', 'script'),
('184', '62', 'pjField', '1', 'title', 'Export', 'script'),
('185', '62', 'pjField', '2', 'title', 'Export', 'script'),
('186', '62', 'pjField', '3', 'title', 'Export', 'script'),
('187', '63', 'pjField', '1', 'title', 'Forgot password', 'script'),
('188', '63', 'pjField', '2', 'title', 'Forgot password', 'script'),
('189', '63', 'pjField', '3', 'title', 'Forgot password', 'script'),
('190', '64', 'pjField', '1', 'title', 'IP address', 'script'),
('191', '64', 'pjField', '2', 'title', 'IP address', 'script'),
('192', '64', 'pjField', '3', 'title', 'IP address', 'script'),
('193', '65', 'pjField', '1', 'title', 'Is confirmed', 'script'),
('194', '65', 'pjField', '2', 'title', 'Is Active', 'script'),
('195', '65', 'pjField', '3', 'title', 'Is confirmed', 'script'),
('196', '66', 'pjField', '1', 'title', 'Name', 'script'),
('197', '66', 'pjField', '2', 'title', 'Name', 'script'),
('198', '66', 'pjField', '3', 'title', 'Name', 'script'),
('199', '67', 'pjField', '1', 'title', 'No', 'script'),
('200', '67', 'pjField', '2', 'title', '??', 'script'),
('201', '67', 'pjField', '3', 'title', 'No', 'script'),
('202', '68', 'pjField', '1', 'title', 'Option', 'script'),
('203', '68', 'pjField', '2', 'title', 'Option', 'script'),
('204', '68', 'pjField', '3', 'title', 'Option', 'script'),
('205', '69', 'pjField', '1', 'title', 'Option list', 'script'),
('206', '69', 'pjField', '2', 'title', 'Option list', 'script'),
('207', '69', 'pjField', '3', 'title', 'Option list', 'script'),
('208', '70', 'pjField', '1', 'title', 'Role', 'script'),
('209', '70', 'pjField', '2', 'title', 'Role', 'script'),
('210', '70', 'pjField', '3', 'title', 'Role', 'script'),
('211', '71', 'pjField', '1', 'title', 'Status', 'script'),
('212', '71', 'pjField', '2', 'title', 'Status', 'script'),
('213', '71', 'pjField', '3', 'title', 'Status', 'script'),
('214', '72', 'pjField', '1', 'title', 'Type', 'script'),
('215', '72', 'pjField', '2', 'title', 'Type', 'script'),
('216', '72', 'pjField', '3', 'title', 'Type', 'script'),
('217', '73', 'pjField', '1', 'title', 'Update user', 'script'),
('218', '73', 'pjField', '2', 'title', 'Update user', 'script'),
('219', '73', 'pjField', '3', 'title', 'Update user', 'script'),
('220', '74', 'pjField', '1', 'title', 'Registration date/time', 'script'),
('221', '74', 'pjField', '2', 'title', 'Registration date/time', 'script'),
('222', '74', 'pjField', '3', 'title', 'Registration date/time', 'script'),
('223', '75', 'pjField', '1', 'title', 'Value', 'script'),
('224', '75', 'pjField', '2', 'title', 'Value', 'script'),
('225', '75', 'pjField', '3', 'title', 'Value', 'script'),
('226', '76', 'pjField', '1', 'title', 'Yes', 'script'),
('227', '76', 'pjField', '2', 'title', '??', 'script'),
('228', '76', 'pjField', '3', 'title', 'Yes', 'script'),
('229', '77', 'pjField', '1', 'title', 'Back', 'script'),
('230', '77', 'pjField', '2', 'title', 'Back', 'script'),
('231', '77', 'pjField', '3', 'title', 'Back', 'script'),
('232', '78', 'pjField', '1', 'title', 'Arrays titles', 'script'),
('233', '78', 'pjField', '2', 'title', 'Arrays titles', 'script'),
('234', '78', 'pjField', '3', 'title', 'Arrays titles', 'script'),
('235', '79', 'pjField', '1', 'title', 'Languages', 'script'),
('236', '79', 'pjField', '2', 'title', 'Languages', 'script'),
('237', '79', 'pjField', '3', 'title', 'Languages', 'script'),
('238', '80', 'pjField', '1', 'title', 'Flag', 'script'),
('239', '80', 'pjField', '2', 'title', 'Flag', 'script'),
('240', '80', 'pjField', '3', 'title', 'Flag', 'script'),
('241', '81', 'pjField', '1', 'title', 'Is default', 'script'),
('242', '81', 'pjField', '2', 'title', 'Is default', 'script'),
('243', '81', 'pjField', '3', 'title', 'Is default', 'script'),
('244', '82', 'pjField', '1', 'title', 'Order', 'script'),
('245', '82', 'pjField', '2', 'title', 'Order', 'script'),
('246', '82', 'pjField', '3', 'title', 'Order', 'script'),
('247', '83', 'pjField', '1', 'title', 'Title', 'script'),
('248', '83', 'pjField', '2', 'title', 'Title', 'script'),
('249', '83', 'pjField', '3', 'title', 'Title', 'script'),
('250', '84', 'pjField', '1', 'title', 'Backup', 'script'),
('251', '84', 'pjField', '2', 'title', 'Backup', 'script'),
('252', '84', 'pjField', '3', 'title', 'Backup', 'script'),
('253', '85', 'pjField', '1', 'title', 'Dashboard', 'script'),
('254', '85', 'pjField', '2', 'title', 'Dashboard', 'script'),
('255', '85', 'pjField', '3', 'title', 'Dashboard', 'script'),
('256', '86', 'pjField', '1', 'title', 'Multi Lang', 'script'),
('257', '86', 'pjField', '2', 'title', 'Multi Lang', 'script'),
('258', '86', 'pjField', '3', 'title', 'Multi Lang', 'script'),
('259', '87', 'pjField', '1', 'title', 'Languages', 'script'),
('260', '87', 'pjField', '2', 'title', 'Languages', 'script'),
('261', '87', 'pjField', '3', 'title', 'Languages', 'script'),
('262', '88', 'pjField', '1', 'title', 'Logout', 'script'),
('263', '88', 'pjField', '2', 'title', 'Logout', 'script'),
('264', '88', 'pjField', '3', 'title', 'Logout', 'script'),
('265', '89', 'pjField', '1', 'title', 'Options', 'script'),
('266', '89', 'pjField', '2', 'title', 'Options', 'script'),
('267', '89', 'pjField', '3', 'title', 'Options', 'script'),
('268', '90', 'pjField', '1', 'title', 'Plugins', 'script'),
('269', '90', 'pjField', '2', 'title', 'Plugins', 'script'),
('270', '90', 'pjField', '3', 'title', 'Plugins', 'script'),
('271', '91', 'pjField', '1', 'title', 'Profile', 'script'),
('272', '91', 'pjField', '2', 'title', 'Profile', 'script'),
('273', '91', 'pjField', '3', 'title', 'Profile', 'script'),
('274', '92', 'pjField', '1', 'title', 'Users', 'script'),
('275', '92', 'pjField', '2', 'title', 'Users', 'script'),
('276', '92', 'pjField', '3', 'title', 'Users', 'script'),
('277', '93', 'pjField', '1', 'title', 'Click on the flag icon to choose which language version of your news you wish to edit.', 'script'),
('278', '93', 'pjField', '2', 'title', 'Click on the flag icon to choose which language version of your news you wish to edit.', 'script'),
('279', '93', 'pjField', '3', 'title', 'Click on the flag icon to choose which language version of your news you wish to edit.', 'script'),
('280', '94', 'pjField', '1', 'title', 'Currency', 'script'),
('281', '94', 'pjField', '2', 'title', 'Currency', 'script'),
('282', '94', 'pjField', '3', 'title', 'Currency', 'script'),
('283', '95', 'pjField', '1', 'title', 'Date format', 'script'),
('284', '95', 'pjField', '2', 'title', 'Date format', 'script'),
('285', '95', 'pjField', '3', 'title', 'Date format', 'script'),
('286', '96', 'pjField', '1', 'title', 'Send email', 'script'),
('287', '96', 'pjField', '2', 'title', 'Send email', 'script'),
('288', '96', 'pjField', '3', 'title', 'Send email', 'script'),
('289', '97', 'pjField', '1', 'title', 'SMTP Host', 'script'),
('290', '97', 'pjField', '2', 'title', 'SMTP Host', 'script'),
('291', '97', 'pjField', '3', 'title', 'SMTP Host', 'script'),
('292', '98', 'pjField', '1', 'title', 'SMTP Password', 'script'),
('293', '98', 'pjField', '2', 'title', 'SMTP Password', 'script'),
('294', '98', 'pjField', '3', 'title', 'SMTP Password', 'script'),
('295', '99', 'pjField', '1', 'title', 'SMTP Port', 'script'),
('296', '99', 'pjField', '2', 'title', 'SMTP Port', 'script'),
('297', '99', 'pjField', '3', 'title', 'SMTP Port', 'script'),
('298', '100', 'pjField', '1', 'title', 'SMTP Username', 'script'),
('299', '100', 'pjField', '2', 'title', 'SMTP Username', 'script'),
('300', '100', 'pjField', '3', 'title', 'SMTP Username', 'script'),
('301', '101', 'pjField', '1', 'title', 'Timezone', 'script'),
('302', '101', 'pjField', '2', 'title', 'Timezone', 'script'),
('303', '101', 'pjField', '3', 'title', 'Timezone', 'script'),
('304', '102', 'pjField', '1', 'title', 'First day of the week', 'script'),
('305', '102', 'pjField', '2', 'title', 'First day of the week', 'script'),
('306', '102', 'pjField', '3', 'title', 'First day of the week', 'script'),
('307', '103', 'pjField', '1', 'title', 'Password', 'script'),
('308', '103', 'pjField', '2', 'title', 'Password', 'script'),
('309', '103', 'pjField', '3', 'title', 'Password', 'script'),
('310', '125', 'pjField', '1', 'title', 'Revert status', 'script'),
('311', '125', 'pjField', '2', 'title', 'Revert status', 'script'),
('312', '125', 'pjField', '3', 'title', 'Revert status', 'script'),
('313', '126', 'pjField', '1', 'title', 'URL', 'script'),
('314', '126', 'pjField', '2', 'title', 'URL', 'script'),
('315', '126', 'pjField', '3', 'title', 'URL', 'script'),
('316', '127', 'pjField', '1', 'title', 'Username', 'script'),
('317', '127', 'pjField', '2', 'title', 'Username', 'script'),
('318', '127', 'pjField', '3', 'title', 'Username', 'script'),
('319', '128', 'pjField', '1', 'title', 'Email address was already in use', 'script'),
('320', '128', 'pjField', '2', 'title', 'Email address was already in use', 'script'),
('321', '128', 'pjField', '3', 'title', 'Email address was already in use', 'script'),
('322', '129', 'pjField', '1', 'title', 'Sunday', 'script'),
('323', '129', 'pjField', '2', 'title', 'Sunday', 'script'),
('324', '129', 'pjField', '3', 'title', 'Sunday', 'script'),
('325', '130', 'pjField', '1', 'title', 'Monday', 'script'),
('326', '130', 'pjField', '2', 'title', 'Monday', 'script'),
('327', '130', 'pjField', '3', 'title', 'Monday', 'script'),
('328', '131', 'pjField', '1', 'title', 'Tuesday', 'script'),
('329', '131', 'pjField', '2', 'title', 'Tuesday', 'script'),
('330', '131', 'pjField', '3', 'title', 'Tuesday', 'script'),
('331', '132', 'pjField', '1', 'title', 'Wednesday', 'script'),
('332', '132', 'pjField', '2', 'title', 'Wednesday', 'script'),
('333', '132', 'pjField', '3', 'title', 'Wednesday', 'script'),
('334', '133', 'pjField', '1', 'title', 'Thursday', 'script'),
('335', '133', 'pjField', '2', 'title', 'Thursday', 'script'),
('336', '133', 'pjField', '3', 'title', 'Thursday', 'script'),
('337', '134', 'pjField', '1', 'title', 'Friday', 'script'),
('338', '134', 'pjField', '2', 'title', 'Friday', 'script'),
('339', '134', 'pjField', '3', 'title', 'Friday', 'script'),
('340', '135', 'pjField', '1', 'title', 'Saturday', 'script'),
('341', '135', 'pjField', '2', 'title', 'Saturday', 'script'),
('342', '135', 'pjField', '3', 'title', 'Saturday', 'script'),
('343', '136', 'pjField', '1', 'title', 'S', 'script'),
('344', '136', 'pjField', '2', 'title', 'S', 'script'),
('345', '136', 'pjField', '3', 'title', 'S', 'script'),
('346', '137', 'pjField', '1', 'title', 'M', 'script'),
('347', '137', 'pjField', '2', 'title', 'M', 'script'),
('348', '137', 'pjField', '3', 'title', 'M', 'script'),
('349', '138', 'pjField', '1', 'title', 'T', 'script'),
('350', '138', 'pjField', '2', 'title', 'T', 'script'),
('351', '138', 'pjField', '3', 'title', 'T', 'script'),
('352', '139', 'pjField', '1', 'title', 'W', 'script'),
('353', '139', 'pjField', '2', 'title', 'W', 'script'),
('354', '139', 'pjField', '3', 'title', 'W', 'script'),
('355', '140', 'pjField', '1', 'title', 'T', 'script'),
('356', '140', 'pjField', '2', 'title', 'T', 'script'),
('357', '140', 'pjField', '3', 'title', 'T', 'script'),
('358', '141', 'pjField', '1', 'title', 'F', 'script'),
('359', '141', 'pjField', '2', 'title', 'F', 'script'),
('360', '141', 'pjField', '3', 'title', 'F', 'script'),
('361', '142', 'pjField', '1', 'title', 'S', 'script'),
('362', '142', 'pjField', '2', 'title', 'S', 'script'),
('363', '142', 'pjField', '3', 'title', 'S', 'script'),
('364', '143', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script'),
('365', '143', 'pjField', '2', 'title', 'Given email address is not associated with any account.', 'script'),
('366', '143', 'pjField', '3', 'title', 'Given email address is not associated with any account.', 'script'),
('367', '144', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script'),
('368', '144', 'pjField', '2', 'title', 'For further instructions please check your mailbox.', 'script'),
('369', '144', 'pjField', '3', 'title', 'For further instructions please check your mailbox.', 'script'),
('370', '145', 'pjField', '1', 'title', 'We are sorry, please try again later.', 'script'),
('371', '145', 'pjField', '2', 'title', 'We are sorry, please try again later.', 'script'),
('372', '145', 'pjField', '3', 'title', 'We are sorry, please try again later.', 'script'),
('373', '146', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script'),
('374', '146', 'pjField', '2', 'title', 'All the changes made to your profile have been saved.', 'script'),
('375', '146', 'pjField', '3', 'title', 'All the changes made to your profile have been saved.', 'script'),
('376', '147', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
('377', '147', 'pjField', '2', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
('378', '147', 'pjField', '3', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
('379', '148', 'pjField', '1', 'title', 'All backup files have been saved.', 'script'),
('380', '148', 'pjField', '2', 'title', 'All backup files have been saved.', 'script'),
('381', '148', 'pjField', '3', 'title', 'All backup files have been saved.', 'script'),
('382', '149', 'pjField', '1', 'title', 'No option was selected.', 'script'),
('383', '149', 'pjField', '2', 'title', 'No option was selected.', 'script'),
('384', '149', 'pjField', '3', 'title', 'No option was selected.', 'script'),
('385', '150', 'pjField', '1', 'title', 'Backup not performed.', 'script'),
('386', '150', 'pjField', '2', 'title', 'Backup not performed.', 'script'),
('387', '150', 'pjField', '3', 'title', 'Backup not performed.', 'script'),
('388', '151', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script'),
('389', '151', 'pjField', '2', 'title', 'All the changes made to titles have been saved.', 'script'),
('390', '151', 'pjField', '3', 'title', 'All the changes made to titles have been saved.', 'script'),
('391', '152', 'pjField', '1', 'title', 'All the changes made to options have been saved.', 'script'),
('392', '152', 'pjField', '2', 'title', 'All the changes made to options have been saved.', 'script'),
('393', '152', 'pjField', '3', 'title', 'All the changes made to options have been saved.', 'script'),
('394', '153', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('395', '153', 'pjField', '2', 'title', 'All the changes made to this user have been saved.', 'script'),
('396', '153', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('397', '154', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('398', '154', 'pjField', '2', 'title', 'All the changes made to this user have been saved.', 'script'),
('399', '154', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('400', '155', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script'),
('401', '155', 'pjField', '2', 'title', 'We are sorry, but the user has not been added.', 'script'),
('402', '155', 'pjField', '3', 'title', 'We are sorry, but the user has not been added.', 'script'),
('403', '156', 'pjField', '1', 'title', 'User your looking for is missing.', 'script'),
('404', '156', 'pjField', '2', 'title', 'User your looking for is missing.', 'script'),
('405', '156', 'pjField', '3', 'title', 'User your looking for is missing.', 'script'),
('406', '159', 'pjField', '1', 'title', 'Account not found!', 'script'),
('407', '159', 'pjField', '2', 'title', 'Account not found!', 'script'),
('408', '159', 'pjField', '3', 'title', 'Account not found!', 'script'),
('409', '160', 'pjField', '1', 'title', 'Password send!', 'script'),
('410', '160', 'pjField', '2', 'title', 'Password send!', 'script'),
('411', '160', 'pjField', '3', 'title', 'Password send!', 'script'),
('412', '161', 'pjField', '1', 'title', 'Password not send!', 'script'),
('413', '161', 'pjField', '2', 'title', 'Password not send!', 'script'),
('414', '161', 'pjField', '3', 'title', 'Password not send!', 'script'),
('415', '162', 'pjField', '1', 'title', 'Profile updated!', 'script'),
('416', '162', 'pjField', '2', 'title', 'Profile updated!', 'script'),
('417', '162', 'pjField', '3', 'title', 'Profile updated!', 'script'),
('418', '163', 'pjField', '1', 'title', 'Backup', 'script'),
('419', '163', 'pjField', '2', 'title', 'Backup', 'script'),
('420', '163', 'pjField', '3', 'title', 'Backup', 'script'),
('421', '164', 'pjField', '1', 'title', 'Backup complete!', 'script'),
('422', '164', 'pjField', '2', 'title', 'Backup complete!', 'script'),
('423', '164', 'pjField', '3', 'title', 'Backup complete!', 'script'),
('424', '165', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('425', '165', 'pjField', '2', 'title', 'Backup failed!', 'script'),
('426', '165', 'pjField', '3', 'title', 'Backup failed!', 'script'),
('427', '166', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('428', '166', 'pjField', '2', 'title', 'Backup failed!', 'script'),
('429', '166', 'pjField', '3', 'title', 'Backup failed!', 'script'),
('430', '167', 'pjField', '1', 'title', 'Options updated!', 'script'),
('431', '167', 'pjField', '2', 'title', 'Options updated!', 'script'),
('432', '167', 'pjField', '3', 'title', 'Options updated!', 'script'),
('433', '168', 'pjField', '1', 'title', 'User updated!', 'script'),
('434', '168', 'pjField', '2', 'title', 'User updated!', 'script'),
('435', '168', 'pjField', '3', 'title', 'User updated!', 'script'),
('436', '169', 'pjField', '1', 'title', 'User added!', 'script'),
('437', '169', 'pjField', '2', 'title', 'User added!', 'script'),
('438', '169', 'pjField', '3', 'title', 'User added!', 'script'),
('439', '170', 'pjField', '1', 'title', 'User failed to add.', 'script'),
('440', '170', 'pjField', '2', 'title', 'User failed to add.', 'script'),
('441', '170', 'pjField', '3', 'title', 'User failed to add.', 'script'),
('442', '171', 'pjField', '1', 'title', 'User not found.', 'script'),
('443', '171', 'pjField', '2', 'title', 'User not found.', 'script'),
('444', '171', 'pjField', '3', 'title', 'User not found.', 'script'),
('445', '174', 'pjField', '1', 'title', 'Active', 'script'),
('446', '174', 'pjField', '2', 'title', 'Active', 'script'),
('447', '174', 'pjField', '3', 'title', 'Active', 'script'),
('448', '175', 'pjField', '1', 'title', 'Inactive', 'script'),
('449', '175', 'pjField', '2', 'title', 'Inactive', 'script'),
('450', '175', 'pjField', '3', 'title', 'Inactive', 'script'),
('451', '176', 'pjField', '1', 'title', 'Wrong username or password', 'script'),
('452', '176', 'pjField', '2', 'title', 'Wrong username or password', 'script'),
('453', '176', 'pjField', '3', 'title', 'Wrong username or password', 'script'),
('454', '177', 'pjField', '1', 'title', 'Access denied', 'script'),
('455', '177', 'pjField', '2', 'title', 'Access denied', 'script'),
('456', '177', 'pjField', '3', 'title', 'Access denied', 'script'),
('457', '178', 'pjField', '1', 'title', 'Account is disabled', 'script'),
('458', '178', 'pjField', '2', 'title', 'Account is disabled', 'script'),
('459', '178', 'pjField', '3', 'title', 'Account is disabled', 'script'),
('460', '179', 'pjField', '1', 'title', 'January', 'script'),
('461', '179', 'pjField', '2', 'title', 'January', 'script'),
('462', '179', 'pjField', '3', 'title', 'January', 'script'),
('463', '180', 'pjField', '1', 'title', 'October', 'script'),
('464', '180', 'pjField', '2', 'title', 'October', 'script'),
('465', '180', 'pjField', '3', 'title', 'October', 'script'),
('466', '181', 'pjField', '1', 'title', 'November', 'script'),
('467', '181', 'pjField', '2', 'title', 'November', 'script'),
('468', '181', 'pjField', '3', 'title', 'November', 'script'),
('469', '182', 'pjField', '1', 'title', 'December', 'script'),
('470', '182', 'pjField', '2', 'title', 'December', 'script'),
('471', '182', 'pjField', '3', 'title', 'December', 'script'),
('472', '183', 'pjField', '1', 'title', 'February', 'script'),
('473', '183', 'pjField', '2', 'title', 'February', 'script'),
('474', '183', 'pjField', '3', 'title', 'February', 'script'),
('475', '184', 'pjField', '1', 'title', 'March', 'script'),
('476', '184', 'pjField', '2', 'title', 'March', 'script'),
('477', '184', 'pjField', '3', 'title', 'March', 'script'),
('478', '185', 'pjField', '1', 'title', 'April', 'script'),
('479', '185', 'pjField', '2', 'title', 'April', 'script'),
('480', '185', 'pjField', '3', 'title', 'April', 'script'),
('481', '186', 'pjField', '1', 'title', 'May', 'script'),
('482', '186', 'pjField', '2', 'title', 'May', 'script'),
('483', '186', 'pjField', '3', 'title', 'May', 'script'),
('484', '187', 'pjField', '1', 'title', 'June', 'script'),
('485', '187', 'pjField', '2', 'title', 'June', 'script'),
('486', '187', 'pjField', '3', 'title', 'June', 'script'),
('487', '188', 'pjField', '1', 'title', 'July', 'script'),
('488', '188', 'pjField', '2', 'title', 'July', 'script'),
('489', '188', 'pjField', '3', 'title', 'July', 'script'),
('490', '189', 'pjField', '1', 'title', 'August', 'script'),
('491', '189', 'pjField', '2', 'title', 'August', 'script'),
('492', '189', 'pjField', '3', 'title', 'August', 'script'),
('493', '190', 'pjField', '1', 'title', 'September', 'script'),
('494', '190', 'pjField', '2', 'title', 'September', 'script'),
('495', '190', 'pjField', '3', 'title', 'September', 'script'),
('496', '191', 'pjField', '1', 'title', 'Dr.', 'script'),
('497', '191', 'pjField', '2', 'title', 'Dr.', 'script'),
('498', '191', 'pjField', '3', 'title', 'Dr.', 'script'),
('499', '192', 'pjField', '1', 'title', 'Miss', 'script'),
('500', '192', 'pjField', '2', 'title', 'Miss', 'script'),
('501', '192', 'pjField', '3', 'title', 'Miss', 'script'),
('502', '193', 'pjField', '1', 'title', 'Mr.', 'script'),
('503', '193', 'pjField', '2', 'title', 'Mr.', 'script'),
('504', '193', 'pjField', '3', 'title', 'Mr.', 'script'),
('505', '194', 'pjField', '1', 'title', 'Mrs.', 'script'),
('506', '194', 'pjField', '2', 'title', 'Mrs.', 'script'),
('507', '194', 'pjField', '3', 'title', 'Mrs.', 'script'),
('508', '195', 'pjField', '1', 'title', 'Ms.', 'script'),
('509', '195', 'pjField', '2', 'title', 'Ms.', 'script'),
('510', '195', 'pjField', '3', 'title', 'Ms.', 'script'),
('511', '196', 'pjField', '1', 'title', 'Other', 'script'),
('512', '196', 'pjField', '2', 'title', 'Other', 'script'),
('513', '196', 'pjField', '3', 'title', 'Other', 'script'),
('514', '197', 'pjField', '1', 'title', 'Prof.', 'script'),
('515', '197', 'pjField', '2', 'title', 'Prof.', 'script'),
('516', '197', 'pjField', '3', 'title', 'Prof.', 'script'),
('517', '198', 'pjField', '1', 'title', 'Rev.', 'script'),
('518', '198', 'pjField', '2', 'title', 'Rev.', 'script'),
('519', '198', 'pjField', '3', 'title', 'Rev.', 'script'),
('520', '199', 'pjField', '1', 'title', 'Jan', 'script'),
('521', '199', 'pjField', '2', 'title', 'Jan', 'script'),
('522', '199', 'pjField', '3', 'title', 'Jan', 'script'),
('523', '200', 'pjField', '1', 'title', 'Oct', 'script'),
('524', '200', 'pjField', '2', 'title', 'Oct', 'script'),
('525', '200', 'pjField', '3', 'title', 'Oct', 'script'),
('526', '201', 'pjField', '1', 'title', 'Nov', 'script'),
('527', '201', 'pjField', '2', 'title', 'Nov', 'script'),
('528', '201', 'pjField', '3', 'title', 'Nov', 'script'),
('529', '202', 'pjField', '1', 'title', 'Dec', 'script'),
('530', '202', 'pjField', '2', 'title', 'Dec', 'script'),
('531', '202', 'pjField', '3', 'title', 'Dec', 'script'),
('532', '203', 'pjField', '1', 'title', 'Feb', 'script'),
('533', '203', 'pjField', '2', 'title', 'Feb', 'script'),
('534', '203', 'pjField', '3', 'title', 'Feb', 'script'),
('535', '204', 'pjField', '1', 'title', 'Mar', 'script'),
('536', '204', 'pjField', '2', 'title', 'Mar', 'script'),
('537', '204', 'pjField', '3', 'title', 'Mar', 'script'),
('538', '205', 'pjField', '1', 'title', 'Apr', 'script'),
('539', '205', 'pjField', '2', 'title', 'Apr', 'script'),
('540', '205', 'pjField', '3', 'title', 'Apr', 'script'),
('541', '206', 'pjField', '1', 'title', 'May', 'script'),
('542', '206', 'pjField', '2', 'title', 'May', 'script'),
('543', '206', 'pjField', '3', 'title', 'May', 'script'),
('544', '207', 'pjField', '1', 'title', 'Jun', 'script'),
('545', '207', 'pjField', '2', 'title', 'Jun', 'script'),
('546', '207', 'pjField', '3', 'title', 'Jun', 'script'),
('547', '208', 'pjField', '1', 'title', 'Jul', 'script'),
('548', '208', 'pjField', '2', 'title', 'Jul', 'script'),
('549', '208', 'pjField', '3', 'title', 'Jul', 'script'),
('550', '209', 'pjField', '1', 'title', 'Aug', 'script'),
('551', '209', 'pjField', '2', 'title', 'Aug', 'script'),
('552', '209', 'pjField', '3', 'title', 'Aug', 'script'),
('553', '210', 'pjField', '1', 'title', 'Sep', 'script'),
('554', '210', 'pjField', '2', 'title', 'Sep', 'script'),
('555', '210', 'pjField', '3', 'title', 'Sep', 'script'),
('556', '211', 'pjField', '1', 'title', 'You are not loged in.', 'script'),
('557', '211', 'pjField', '2', 'title', 'You are not loged in.', 'script'),
('558', '211', 'pjField', '3', 'title', 'You are not loged in.', 'script'),
('559', '212', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('560', '212', 'pjField', '2', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('561', '212', 'pjField', '3', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('562', '213', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('563', '213', 'pjField', '2', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('564', '213', 'pjField', '3', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('565', '214', 'pjField', '1', 'title', 'Empty resultset.', 'script'),
('566', '214', 'pjField', '2', 'title', 'Empty resultset.', 'script'),
('567', '214', 'pjField', '3', 'title', 'Empty resultset.', 'script'),
('568', '215', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script'),
('569', '215', 'pjField', '2', 'title', 'The operation is not allowed in demo mode.', 'script'),
('570', '215', 'pjField', '3', 'title', 'The operation is not allowed in demo mode.', 'script'),
('571', '216', 'pjField', '1', 'title', 'No property for the reservation found', 'script'),
('572', '216', 'pjField', '2', 'title', 'No property for the reservation found', 'script'),
('573', '216', 'pjField', '3', 'title', 'No property for the reservation found', 'script'),
('574', '217', 'pjField', '1', 'title', 'No reservation found', 'script'),
('575', '217', 'pjField', '2', 'title', 'No reservation found', 'script'),
('576', '217', 'pjField', '3', 'title', 'No reservation found', 'script'),
('577', '218', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script'),
('578', '218', 'pjField', '2', 'title', 'No permisions to edit the reservation', 'script'),
('579', '218', 'pjField', '3', 'title', 'No permisions to edit the reservation', 'script'),
('580', '219', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('581', '219', 'pjField', '2', 'title', 'No permisions to edit the property', 'script'),
('582', '219', 'pjField', '3', 'title', 'No permisions to edit the property', 'script'),
('583', '220', 'pjField', '1', 'title', 'E-Mail address already exist', 'script'),
('584', '220', 'pjField', '2', 'title', 'E-Mail address already exist', 'script'),
('585', '220', 'pjField', '3', 'title', 'E-Mail address already exist', 'script'),
('586', '221', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('587', '221', 'pjField', '2', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('588', '221', 'pjField', '3', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('589', '222', 'pjField', '1', 'title', 'Your registration was successfull.', 'script'),
('590', '222', 'pjField', '2', 'title', 'Your registration was successfull.', 'script'),
('591', '222', 'pjField', '3', 'title', 'Your registration was successfull.', 'script'),
('592', '223', 'pjField', '1', 'title', 'GMT-03:00', 'script'),
('593', '223', 'pjField', '2', 'title', 'GMT-03:00', 'script'),
('594', '223', 'pjField', '3', 'title', 'GMT-03:00', 'script'),
('595', '224', 'pjField', '1', 'title', 'GMT-04:00', 'script'),
('596', '224', 'pjField', '2', 'title', 'GMT-04:00', 'script'),
('597', '224', 'pjField', '3', 'title', 'GMT-04:00', 'script'),
('598', '225', 'pjField', '1', 'title', 'GMT-05:00', 'script'),
('599', '225', 'pjField', '2', 'title', 'GMT-05:00', 'script'),
('600', '225', 'pjField', '3', 'title', 'GMT-05:00', 'script'),
('601', '226', 'pjField', '1', 'title', 'GMT-06:00', 'script'),
('602', '226', 'pjField', '2', 'title', 'GMT-06:00', 'script'),
('603', '226', 'pjField', '3', 'title', 'GMT-06:00', 'script'),
('604', '227', 'pjField', '1', 'title', 'GMT-07:00', 'script'),
('605', '227', 'pjField', '2', 'title', 'GMT-07:00', 'script'),
('606', '227', 'pjField', '3', 'title', 'GMT-07:00', 'script'),
('607', '228', 'pjField', '1', 'title', 'GMT-08:00', 'script'),
('608', '228', 'pjField', '2', 'title', 'GMT-08:00', 'script'),
('609', '228', 'pjField', '3', 'title', 'GMT-08:00', 'script'),
('610', '229', 'pjField', '1', 'title', 'GMT-09:00', 'script'),
('611', '229', 'pjField', '2', 'title', 'GMT-09:00', 'script'),
('612', '229', 'pjField', '3', 'title', 'GMT-09:00', 'script'),
('613', '230', 'pjField', '1', 'title', 'GMT-01:00', 'script'),
('614', '230', 'pjField', '2', 'title', 'GMT-01:00', 'script'),
('615', '230', 'pjField', '3', 'title', 'GMT-01:00', 'script'),
('616', '231', 'pjField', '1', 'title', 'GMT-10:00', 'script'),
('617', '231', 'pjField', '2', 'title', 'GMT-10:00', 'script'),
('618', '231', 'pjField', '3', 'title', 'GMT-10:00', 'script'),
('619', '232', 'pjField', '1', 'title', 'GMT-11:00', 'script'),
('620', '232', 'pjField', '2', 'title', 'GMT-11:00', 'script'),
('621', '232', 'pjField', '3', 'title', 'GMT-11:00', 'script'),
('622', '233', 'pjField', '1', 'title', 'GMT-12:00', 'script'),
('623', '233', 'pjField', '2', 'title', 'GMT-12:00', 'script'),
('624', '233', 'pjField', '3', 'title', 'GMT-12:00', 'script'),
('625', '234', 'pjField', '1', 'title', 'GMT-02:00', 'script'),
('626', '234', 'pjField', '2', 'title', 'GMT-02:00', 'script'),
('627', '234', 'pjField', '3', 'title', 'GMT-02:00', 'script'),
('628', '235', 'pjField', '1', 'title', 'GMT', 'script'),
('629', '235', 'pjField', '2', 'title', 'GMT', 'script'),
('630', '235', 'pjField', '3', 'title', 'GMT', 'script'),
('631', '236', 'pjField', '1', 'title', 'GMT+03:00', 'script'),
('632', '236', 'pjField', '2', 'title', 'GMT+03:00', 'script'),
('633', '236', 'pjField', '3', 'title', 'GMT+03:00', 'script'),
('634', '237', 'pjField', '1', 'title', 'GMT+04:00', 'script'),
('635', '237', 'pjField', '2', 'title', 'GMT+04:00', 'script'),
('636', '237', 'pjField', '3', 'title', 'GMT+04:00', 'script'),
('637', '238', 'pjField', '1', 'title', 'GMT+05:00', 'script'),
('638', '238', 'pjField', '2', 'title', 'GMT+05:00', 'script'),
('639', '238', 'pjField', '3', 'title', 'GMT+05:00', 'script'),
('640', '239', 'pjField', '1', 'title', 'GMT+06:00', 'script'),
('641', '239', 'pjField', '2', 'title', 'GMT+06:00', 'script'),
('642', '239', 'pjField', '3', 'title', 'GMT+06:00', 'script'),
('643', '240', 'pjField', '1', 'title', 'GMT+07:00', 'script'),
('644', '240', 'pjField', '2', 'title', 'GMT+07:00', 'script'),
('645', '240', 'pjField', '3', 'title', 'GMT+07:00', 'script'),
('646', '241', 'pjField', '1', 'title', 'GMT+08:00', 'script'),
('647', '241', 'pjField', '2', 'title', 'GMT+08:00', 'script'),
('648', '241', 'pjField', '3', 'title', 'GMT+08:00', 'script'),
('649', '242', 'pjField', '1', 'title', 'GMT+09:00', 'script'),
('650', '242', 'pjField', '2', 'title', 'GMT+09:00', 'script'),
('651', '242', 'pjField', '3', 'title', 'GMT+09:00', 'script'),
('652', '243', 'pjField', '1', 'title', 'GMT+01:00', 'script'),
('653', '243', 'pjField', '2', 'title', 'GMT+01:00', 'script'),
('654', '243', 'pjField', '3', 'title', 'GMT+01:00', 'script'),
('655', '244', 'pjField', '1', 'title', 'GMT+10:00', 'script'),
('656', '244', 'pjField', '2', 'title', 'GMT+10:00', 'script'),
('657', '244', 'pjField', '3', 'title', 'GMT+10:00', 'script'),
('658', '245', 'pjField', '1', 'title', 'GMT+11:00', 'script'),
('659', '245', 'pjField', '2', 'title', 'GMT+11:00', 'script'),
('660', '245', 'pjField', '3', 'title', 'GMT+11:00', 'script'),
('661', '246', 'pjField', '1', 'title', 'GMT+12:00', 'script'),
('662', '246', 'pjField', '2', 'title', 'GMT+12:00', 'script'),
('663', '246', 'pjField', '3', 'title', 'GMT+12:00', 'script'),
('664', '247', 'pjField', '1', 'title', 'GMT+13:00', 'script'),
('665', '247', 'pjField', '2', 'title', 'GMT+13:00', 'script'),
('666', '247', 'pjField', '3', 'title', 'GMT+13:00', 'script'),
('667', '248', 'pjField', '1', 'title', 'GMT+02:00', 'script'),
('668', '248', 'pjField', '2', 'title', 'GMT+02:00', 'script'),
('669', '248', 'pjField', '3', 'title', 'GMT+02:00', 'script'),
('670', '249', 'pjField', '1', 'title', 'Inactive', 'script'),
('671', '249', 'pjField', '2', 'title', 'Inactive', 'script'),
('672', '249', 'pjField', '3', 'title', 'Inactive', 'script'),
('673', '250', 'pjField', '1', 'title', 'Active', 'script'),
('674', '250', 'pjField', '2', 'title', 'Active', 'script'),
('675', '250', 'pjField', '3', 'title', 'Active', 'script'),
('676', '251', 'pjField', '1', 'title', 'No', 'script'),
('677', '251', 'pjField', '2', 'title', 'No', 'script'),
('678', '251', 'pjField', '3', 'title', 'No', 'script'),
('679', '252', 'pjField', '1', 'title', 'Yes', 'script'),
('680', '252', 'pjField', '2', 'title', 'Yes', 'script'),
('681', '252', 'pjField', '3', 'title', 'Yes', 'script'),
('682', '253', 'pjField', '1', 'title', 'Delete selected', 'script'),
('683', '253', 'pjField', '2', 'title', 'Delete selected', 'script'),
('684', '253', 'pjField', '3', 'title', 'Delete selected', 'script'),
('685', '254', 'pjField', '1', 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
('686', '254', 'pjField', '2', 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
('687', '254', 'pjField', '3', 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
('688', '255', 'pjField', '1', 'title', 'All', 'script'),
('689', '255', 'pjField', '2', 'title', 'All', 'script'),
('690', '255', 'pjField', '3', 'title', 'All', 'script'),
('691', '256', 'pjField', '1', 'title', 'Email address was already in use.', 'script'),
('692', '256', 'pjField', '2', 'title', 'Email address was already in use.', 'script'),
('693', '256', 'pjField', '3', 'title', 'Email address was already in use.', 'script'),
('694', '308', 'pjField', '1', 'title', 'Last login', 'script'),
('695', '308', 'pjField', '2', 'title', 'Last login', 'script'),
('696', '308', 'pjField', '3', 'title', 'Last login', 'script'),
('697', '360', 'pjField', '1', 'title', 'News', 'script'),
('698', '360', 'pjField', '2', 'title', 'News', 'script'),
('699', '360', 'pjField', '3', 'title', 'News', 'script'),
('700', '361', 'pjField', '1', 'title', 'Preview & Install', 'script'),
('701', '361', 'pjField', '2', 'title', 'Preview & Install', 'script'),
('702', '361', 'pjField', '3', 'title', 'Preview & Install', 'script'),
('703', '362', 'pjField', '1', 'title', 'Time format', 'script'),
('704', '362', 'pjField', '2', 'title', 'Time format', 'script'),
('705', '362', 'pjField', '3', 'title', 'Time format', 'script'),
('706', '363', 'pjField', '1', 'title', 'Layout', 'script'),
('707', '363', 'pjField', '2', 'title', 'Layout', 'script'),
('708', '363', 'pjField', '3', 'title', 'Layout', 'script'),
('709', '364', 'pjField', '1', 'title', 'News per page', 'script'),
('710', '364', 'pjField', '2', 'title', 'News per page', 'script'),
('711', '364', 'pjField', '3', 'title', 'News per page', 'script'),
('712', '365', 'pjField', '1', 'title', 'Show old news up to X days ago', 'script'),
('713', '365', 'pjField', '2', 'title', 'Show old news up to X days ago', 'script'),
('714', '365', 'pjField', '3', 'title', 'Show old news up to X days ago', 'script'),
('715', '417', 'pjField', '1', 'title', 'Add news', 'script'),
('716', '417', 'pjField', '2', 'title', 'Add news', 'script'),
('717', '417', 'pjField', '3', 'title', 'Add news', 'script'),
('718', '418', 'pjField', '1', 'title', 'News List', 'script'),
('719', '418', 'pjField', '2', 'title', 'News List', 'script'),
('720', '418', 'pjField', '3', 'title', 'News List', 'script'),
('721', '419', 'pjField', '1', 'title', 'Below is a list with all news. To add a news click on the "Add news" tab above. You can also edit and delete any of the news.', 'script'),
('722', '419', 'pjField', '2', 'title', 'Below is a list with all news. To add a news click on the "Add news" tab above. You can also edit and delete any of the news.', 'script'),
('723', '419', 'pjField', '3', 'title', 'Below is a list with all news. To add a news click on the "Add news" tab above. You can also edit and delete any of the news.', 'script'),
('724', '420', 'pjField', '1', 'title', 'Publish', 'script'),
('725', '420', 'pjField', '2', 'title', 'Publish', 'script'),
('726', '420', 'pjField', '3', 'title', 'Publish', 'script'),
('727', '421', 'pjField', '1', 'title', 'Hidden', 'script'),
('728', '421', 'pjField', '2', 'title', 'Hidden', 'script'),
('729', '421', 'pjField', '3', 'title', 'Hidden', 'script'),
('730', '422', 'pjField', '1', 'title', 'Show on date', 'script'),
('731', '422', 'pjField', '2', 'title', 'Show on date', 'script'),
('732', '422', 'pjField', '3', 'title', 'Show on date', 'script'),
('733', '423', 'pjField', '1', 'title', 'Title', 'script'),
('734', '423', 'pjField', '2', 'title', 'Title', 'script'),
('735', '423', 'pjField', '3', 'title', 'Title', 'script'),
('736', '424', 'pjField', '1', 'title', 'Published date', 'script'),
('737', '424', 'pjField', '2', 'title', 'Published date', 'script'),
('738', '424', 'pjField', '3', 'title', 'Published date', 'script'),
('739', '425', 'pjField', '1', 'title', 'This field is required.', 'script'),
('740', '425', 'pjField', '2', 'title', 'This field is required.', 'script'),
('741', '425', 'pjField', '3', 'title', 'This field is required.', 'script'),
('742', '426', 'pjField', '1', 'title', 'Add News', 'script'),
('743', '426', 'pjField', '2', 'title', 'Add News', 'script'),
('744', '426', 'pjField', '3', 'title', 'Add News', 'script'),
('745', '427', 'pjField', '1', 'title', 'Please fill out the form below and click Save button to create news.', 'script'),
('746', '427', 'pjField', '2', 'title', 'Please fill out the form below and click Save button to create news.', 'script'),
('747', '427', 'pjField', '3', 'title', 'Please fill out the form below and click Save button to create news.', 'script'),
('748', '428', 'pjField', '1', 'title', 'Description', 'script'),
('749', '428', 'pjField', '2', 'title', 'Description', 'script'),
('750', '428', 'pjField', '3', 'title', 'Description', 'script'),
('751', '429', 'pjField', '1', 'title', 'Full news', 'script'),
('752', '429', 'pjField', '2', 'title', 'Full news', 'script'),
('753', '429', 'pjField', '3', 'title', 'Full news', 'script'),
('754', '430', 'pjField', '1', 'title', 'URL', 'script'),
('755', '430', 'pjField', '2', 'title', 'URL', 'script'),
('756', '430', 'pjField', '3', 'title', 'URL', 'script'),
('757', '431', 'pjField', '1', 'title', 'URL is not valid.', 'script'),
('758', '431', 'pjField', '2', 'title', 'URL is not valid.', 'script'),
('759', '431', 'pjField', '3', 'title', 'URL is not valid.', 'script'),
('760', '432', 'pjField', '1', 'title', 'Open in new window', 'script'),
('761', '432', 'pjField', '2', 'title', 'Open in new window', 'script'),
('762', '432', 'pjField', '3', 'title', 'Open in new window', 'script'),
('763', '433', 'pjField', '1', 'title', 'Open in current window', 'script'),
('764', '433', 'pjField', '2', 'title', 'Open in current window', 'script'),
('765', '433', 'pjField', '3', 'title', 'Open in current window', 'script'),
('766', '434', 'pjField', '1', 'title', 'Target', 'script'),
('767', '434', 'pjField', '2', 'title', 'Target', 'script'),
('768', '434', 'pjField', '3', 'title', 'Target', 'script'),
('769', '435', 'pjField', '1', 'title', 'Image', 'script'),
('770', '435', 'pjField', '2', 'title', 'Image', 'script'),
('771', '435', 'pjField', '3', 'title', 'Image', 'script'),
('772', '436', 'pjField', '1', 'title', 'News updated', 'script'),
('773', '436', 'pjField', '2', 'title', 'News updated', 'script'),
('774', '436', 'pjField', '3', 'title', 'News updated', 'script'),
('775', '437', 'pjField', '1', 'title', 'All changes made on news have been saved successfully.', 'script'),
('776', '437', 'pjField', '2', 'title', 'All changes made on news have been saved successfully.', 'script'),
('777', '437', 'pjField', '3', 'title', 'All changes made on news have been saved successfully.', 'script'),
('778', '438', 'pjField', '1', 'title', 'News added', 'script'),
('779', '438', 'pjField', '2', 'title', 'News added', 'script'),
('780', '438', 'pjField', '3', 'title', 'News added', 'script'),
('781', '439', 'pjField', '1', 'title', 'News has been added to the list.', 'script'),
('782', '439', 'pjField', '2', 'title', 'News has been added to the list.', 'script'),
('783', '439', 'pjField', '3', 'title', 'News has been added to the list.', 'script'),
('784', '440', 'pjField', '1', 'title', 'News failed to add', 'script'),
('785', '440', 'pjField', '2', 'title', 'News failed to add', 'script'),
('786', '440', 'pjField', '3', 'title', 'News failed to add', 'script'),
('787', '441', 'pjField', '1', 'title', 'We are sorry that some error occurred, so the news could not be added.', 'script'),
('788', '441', 'pjField', '2', 'title', 'We are sorry that some error occurred, so the news could not be added.', 'script'),
('789', '441', 'pjField', '3', 'title', 'We are sorry that some error occurred, so the news could not be added.', 'script'),
('790', '442', 'pjField', '1', 'title', 'News not found', 'script'),
('791', '442', 'pjField', '2', 'title', 'News not found', 'script'),
('792', '442', 'pjField', '3', 'title', 'News not found', 'script'),
('793', '443', 'pjField', '1', 'title', 'We are sorry that news you are looking for is missing.', 'script'),
('794', '443', 'pjField', '2', 'title', 'We are sorry that news you are looking for is missing.', 'script'),
('795', '443', 'pjField', '3', 'title', 'We are sorry that news you are looking for is missing.', 'script'),
('796', '444', 'pjField', '1', 'title', 'Update news', 'script'),
('797', '444', 'pjField', '2', 'title', 'Update news', 'script'),
('798', '444', 'pjField', '3', 'title', 'Update news', 'script'),
('799', '445', 'pjField', '1', 'title', 'Delete Image', 'script'),
('800', '445', 'pjField', '2', 'title', 'Delete Image', 'script'),
('801', '445', 'pjField', '3', 'title', 'Delete Image', 'script'),
('802', '446', 'pjField', '1', 'title', 'Are you sure that you want to delete this image?', 'script'),
('803', '446', 'pjField', '2', 'title', 'Are you sure that you want to delete this image?', 'script'),
('804', '446', 'pjField', '3', 'title', 'Are you sure that you want to delete this image?', 'script'),
('805', '447', 'pjField', '1', 'title', 'Yes', 'script'),
('806', '447', 'pjField', '2', 'title', 'Yes', 'script'),
('807', '447', 'pjField', '3', 'title', 'Yes', 'script'),
('808', '448', 'pjField', '1', 'title', 'No', 'script'),
('809', '448', 'pjField', '2', 'title', 'No', 'script'),
('810', '448', 'pjField', '3', 'title', 'No', 'script'),
('811', '449', 'pjField', '1', 'title', 'Update news', 'script'),
('812', '449', 'pjField', '2', 'title', 'Update news', 'script'),
('813', '449', 'pjField', '3', 'title', 'Update news', 'script'),
('814', '450', 'pjField', '1', 'title', 'Change the news and click on Save button at the bottom to save changes. ', 'script'),
('815', '450', 'pjField', '2', 'title', 'Change the news and click on Save button at the bottom to save changes. ', 'script'),
('816', '450', 'pjField', '3', 'title', 'Change the news and click on Save button at the bottom to save changes. ', 'script'),
('817', '451', 'pjField', '1', 'title', 'Installation', 'script'),
('818', '451', 'pjField', '2', 'title', 'Installation', 'script'),
('819', '451', 'pjField', '3', 'title', 'Installation', 'script'),
('820', '452', 'pjField', '1', 'title', 'You can select layout and default language for your news widget. Click on the Preview button to see how it looks. Then copy the code below and paste it on your web page where you want the news section to appear.', 'script'),
('821', '452', 'pjField', '2', 'title', 'You can select layout and default language for your news widget. Click on the Preview button to see how it looks. Then copy the code below and paste it on your web page where you want the news section to appear.', 'script'),
('822', '452', 'pjField', '3', 'title', 'You can select layout and default language for your news widget. Click on the Preview button to see how it looks. Then copy the code below and paste it on your web page where you want the news section to appear.', 'script'),
('823', '453', 'pjField', '1', 'title', 'Installation configuration', 'script'),
('824', '453', 'pjField', '2', 'title', 'Installation configuration', 'script'),
('825', '453', 'pjField', '3', 'title', 'Installation configuration', 'script'),
('826', '454', 'pjField', '1', 'title', 'Preview', 'script'),
('827', '454', 'pjField', '2', 'title', 'Preview', 'script'),
('828', '454', 'pjField', '3', 'title', 'Preview', 'script'),
('829', '455', 'pjField', '1', 'title', 'Select language', 'script'),
('830', '455', 'pjField', '2', 'title', 'Select language', 'script'),
('831', '455', 'pjField', '3', 'title', 'Select language', 'script'),
('832', '456', 'pjField', '1', 'title', 'Layout 1', 'script'),
('833', '456', 'pjField', '2', 'title', 'Layout 1', 'script'),
('834', '456', 'pjField', '3', 'title', 'Layout 1', 'script'),
('835', '457', 'pjField', '1', 'title', 'Layout 2', 'script'),
('836', '457', 'pjField', '2', 'title', 'Layout 2', 'script'),
('837', '457', 'pjField', '3', 'title', 'Layout 2', 'script'),
('838', '458', 'pjField', '1', 'title', 'Layout 3', 'script'),
('839', '458', 'pjField', '2', 'title', 'Layout 3', 'script'),
('840', '458', 'pjField', '3', 'title', 'Layout 3', 'script'),
('841', '459', 'pjField', '1', 'title', 'Layout 4', 'script'),
('842', '459', 'pjField', '2', 'title', 'Layout 4', 'script'),
('843', '459', 'pjField', '3', 'title', 'Layout 4', 'script'),
('844', '460', 'pjField', '1', 'title', 'Layout 5', 'script'),
('845', '460', 'pjField', '2', 'title', 'Layout 5', 'script'),
('846', '460', 'pjField', '3', 'title', 'Layout 5', 'script'),
('847', '461', 'pjField', '1', 'title', 'Select layout', 'script'),
('848', '461', 'pjField', '2', 'title', 'Select layout', 'script'),
('849', '461', 'pjField', '3', 'title', 'Select layout', 'script'),
('850', '513', 'pjField', '1', 'title', 'There is no news found.', 'script'),
('851', '513', 'pjField', '2', 'title', 'There is no news found.', 'script'),
('852', '513', 'pjField', '3', 'title', 'There is no news found.', 'script'),
('853', '514', 'pjField', '1', 'title', 'Prev', 'script'),
('854', '514', 'pjField', '2', 'title', 'Prev', 'script'),
('855', '514', 'pjField', '3', 'title', 'Prev', 'script'),
('856', '515', 'pjField', '1', 'title', 'Next', 'script'),
('857', '515', 'pjField', '2', 'title', 'Next', 'script'),
('858', '515', 'pjField', '3', 'title', 'Next', 'script'),
('859', '516', 'pjField', '1', 'title', 'Read more', 'script'),
('860', '516', 'pjField', '2', 'title', 'Read more', 'script'),
('861', '516', 'pjField', '3', 'title', 'Read more', 'script'),
('862', '517', 'pjField', '1', 'title', 'Published date', 'script'),
('863', '517', 'pjField', '2', 'title', 'Published date', 'script'),
('864', '517', 'pjField', '3', 'title', 'Published date', 'script'),
('865', '518', 'pjField', '1', 'title', 'Back', 'script'),
('866', '518', 'pjField', '2', 'title', 'Back', 'script'),
('867', '518', 'pjField', '3', 'title', 'Back', 'script'),
('868', '519', 'pjField', '1', 'title', 'Read more +', 'script'),
('869', '519', 'pjField', '2', 'title', 'Read more +', 'script'),
('870', '519', 'pjField', '3', 'title', 'Read more +', 'script');