<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminNews extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['news_create']))
			{
				$pjNewsModel = pjNewsModel::factory();
				
				$data = array();
				$data['published_date'] = pjUtil::formatDate($_POST['published_date'], $this->option_arr['o_date_format']);
				
				$id = $pjNewsModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjNews', 'data');
					}
					
					if (isset($_FILES['image']) && !empty($_FILES['image']['tmp_name']))
					{
						$data = array();
						
						$Image = new pjImage();
						if ($Image->getErrorCode() !== 200)
						{
							$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
							if ($Image->load($_FILES['image']))
							{
								$resp = $Image->isConvertPossible();
								if ($resp['status'] === true)
								{
									$hash = md5(uniqid(rand(), true));
									$source_path = PJ_UPLOAD_PATH . 'source/' . $id . '_' . $hash . '.' . $Image->getExtension();
									$thumb_path = PJ_UPLOAD_PATH . 'thumb/' . $id . '_' . $hash . '.' . $Image->getExtension();
									if ($Image->save($source_path))
									{
										$Image->loadImage($source_path);
										$Image->resizeSmart(69, 69);
										$Image->saveImage($thumb_path);
										
										$data['source_path'] = $source_path;
										$data['thumb_path'] = $thumb_path;
										$data['image_name'] = $_FILES['image']['name'];
										$pjNewsModel->reset()->where('id', $id)->limit(1)->modifyAll($data);
									}
								}
							}
						}
					}
					$err = 'AN03';
				} else {
					$err = 'AN04';
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminNews&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('pjAdminNews.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteNews()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$pjNewsModel = pjNewsModel::factory();
			$arr = $pjNewsModel->find($_GET['id'])->getData();
			if(!empty($arr['source_path']))
			{
				$image_path = $arr['source_path'];
				if (file_exists(PJ_INSTALL_PATH . $image_path)) {
					@unlink(PJ_INSTALL_PATH . $image_path);
				}
			}
			if(!empty($arr['thumb_path']))
			{
				$image_path = $arr['thumb_path'];
				if (file_exists(PJ_INSTALL_PATH . $image_path)) {
					@unlink(PJ_INSTALL_PATH . $image_path);
				}
			}
			
			if ($pjNewsModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjNews')->where('foreign_id', $_GET['id'])->eraseAll();
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteNewsBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjNewsModel = pjNewsModel::factory();
				$arr = $pjNewsModel->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach($arr as $v)
				{
					if(!empty($v['source_path']))
					{
						$image_path = $v['source_path'];
						if (file_exists(PJ_INSTALL_PATH . $image_path)) {
							@unlink(PJ_INSTALL_PATH . $image_path);
						}
					}
					if(!empty($v['thumb_path']))
					{
						$image_path = $v['thumb_path'];
						if (file_exists(PJ_INSTALL_PATH . $image_path)) {
							@unlink(PJ_INSTALL_PATH . $image_path);
						}
					}
				}
				$pjNewsModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjNews')->whereIn('foreign_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportNews()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjNewsModel::factory()	
				->select('t1.*, t2.content as title')
				->join('pjMultiLang', "t2.model='pjNews' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->whereIn('t1.id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("News-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetNews()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjNewsModel = pjNewsModel::factory()->join('pjMultiLang', "t2.model='pjNews' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjNewsModel->where('t2.content LIKE', "%$q%");
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('hide', 'show', 'publish')))
			{
				$pjNewsModel->where('t1.status', $_GET['status']);
			}
	
			$column = 'published_date';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjNewsModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjNewsModel->select(" t1.id, t1.status, t1.published_date, t2.content as title")
								 ->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminNews.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveNews()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjNewsModel = pjNewsModel::factory();
			if (!in_array($_POST['column'], $pjNewsModel->i18n))
			{
				$value = $_POST['value'];
				
				$pjNewsModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $value));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjNews', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['news_update']))
			{
				$arr = pjNewsModel::factory()->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminNews&action=pjActionIndex&err=AN08");
				}
				
				$pjNewsModel = pjNewsModel::factory();
				$data = array();
				$data['modified'] = date('Y-m-d H:i:s');
				$data['published_date'] = pjUtil::formatDate($_POST['published_date'], $this->option_arr['o_date_format']);
				
				if (isset($_FILES['image']) && !empty($_FILES['image']['tmp_name']))
				{
					if(!empty($arr['source_path']))
					{
						$source_path = PJ_INSTALL_PATH . $arr['source_path'];
						$thumb_path = PJ_INSTALL_PATH . $arr['thumb_path'];
						@unlink($source_path);
						@unlink($thumb_path);
					}
						
					$Image = new pjImage();
					if ($Image->getErrorCode() !== 200)
					{
						$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
						if ($Image->load($_FILES['image']))
						{
							$resp = $Image->isConvertPossible();
							if ($resp['status'] === true)
							{
								$hash = md5(uniqid(rand(), true));
								$source_path = PJ_UPLOAD_PATH . 'source/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
								$thumb_path = PJ_UPLOAD_PATH . 'thumb/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
								if ($Image->save($source_path))
								{
									$Image->loadImage($source_path);
									$Image->resizeSmart(69, 69);
									$Image->saveImage($thumb_path);
									
									$data['source_path'] = $source_path;
									$data['thumb_path'] = $thumb_path;
									$data['image_name'] = $_FILES['image']['name'];
								}
							}
						}
					}
				}
				$pjNewsModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjNews', 'data');
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminNews&action=pjActionIndex&err=AN01");
				
			} else {
				$arr = pjNewsModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminNews&action=pjActionIndex&err=AN08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjNews');
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				$this->set('arr', $arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('pjAdminNews.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$pjNewsModel = pjNewsModel::factory();
			$arr = $pjNewsModel->find($_GET['id'])->getData(); 
			
			if(!empty($arr))
			{
				if(!empty($arr['source_path']))
				{
					$source_path = PJ_INSTALL_PATH . $arr['source_path'];
					$thumb_path = PJ_INSTALL_PATH . $arr['thumb_path'];
					@unlink($source_path);
					@unlink($thumb_path);
				}
				
				$data = array();
				$data['source_path'] = ':NULL';
				$data['thumb_path'] = ':NULL';
				$data['image_name'] = ':NULL';
				$pjNewsModel->reset()->where(array('id' => $_GET['id']))->limit(1)->modifyAll($data);
				
				$response['code'] = 200;
			}else{
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
	}
}
?>