<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjNewsManager_Captcha';
	
	public $defaultLocale = 'pjNewsManager_LocaleId';

	public $defaultLangMenu = 'pjNewsManager_LangMenu';
	
	public $defaultLayout = 'pjNewsManager_Layout';
	
	public $defaultIndex = 'pjNewsManager_Index';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		self::allowCORS();
	}
	
	private function _get($key)
	{
		if ($this->_is($key))
		{
			return $_SESSION[$this->defaultStore][$key];
		}
		return false;
	}
	
	private function _is($key)
	{
		return isset($_SESSION[$this->defaultStore]) && isset($_SESSION[$this->defaultStore][$key]);
	}
	
	private function _set($key, $value)
	{
		$_SESSION[$this->defaultStore][$key] = $value;
		return $this;
	}

	public function afterFilter()
	{		
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array('pjActionList', 'pjActionDetails')))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		$is_forced = false;
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			if($_GET['action'] != 'pjActionLoadCss')
			{
				if(isset($_GET['locale']) && (int) $_GET['locale'] > 0)
				{
					$this->setLocaleId($_GET['locale']);
					$this->loadSetFields(true);
					$is_forced = true;
				}else{
					$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
					if (count($locale_arr) === 1)
					{
						$this->setLocaleId($locale_arr[0]['id']);
					}
				}
			}
		}else{
			if(isset($_GET['locale']) && (int) $_GET['locale'] > 0 && $_SESSION[$this->defaultLocale] != $_GET['locale'])
			{
				$this->setLocaleId($_GET['locale']);
				$this->loadSetFields(true);
				$is_forced = true;
			}
		}
		if($is_forced == false)
		{
			$this->loadSetFields();
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionLoadCss()
	{
		$layout = $this->option_arr['o_layout'];
		if(isset($_GET['layout']) && in_array($_GET['layout'], array('layout_1', 'layout_2', 'layout_3', 'layout_4')))
		{
			$layout = $_GET['layout'];
		}
		$arr = array(
			array('file' => 'front_lib.css', 'path' => PJ_CSS_PATH),
			array('file' => 'front_'.$layout.'.css', 'path' => PJ_CSS_PATH),
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
			
			if ($string !== FALSE)
			{
				echo str_replace(
					array('../img/'),
					array(PJ_IMG_PATH),
					$string) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
		
		$hide = 0;
		if(isset($_GET['locale']) && $_GET['locale'] > 0)
		{
			$hide = 1;
		}
		$this->set('hide', $hide);
	}
	
	public function pjActionList()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjNewsModel = pjNewsModel::factory()
							->join('pjMultiLang', "t2.model='pjNews' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t3.model='pjNews' AND t3.foreign_id=t1.id AND t3.field='description' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t4.model='pjNews' AND t4.foreign_id=t1.id AND t4.field='full_news' AND t4.locale='".$this->getLocaleId()."'", 'left outer');
							
			$upto_timestamp = time() - ((int) $this->option_arr['o_show_upto'] * 84600);
							
			$pjNewsModel->where("(t1.status = 'publish' AND UNIX_TIMESTAMP(t1.published_date) >= $upto_timestamp)")
						->orWhere("(t1.status = 'show' AND t1.published_date = '".date('Y-m-d')."')");
			$column = 'published_date';
			$direction = 'DESC';
			
			$total = $pjNewsModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $this->option_arr['o_news_per_page'];
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$arr = $pjNewsModel->select(" t1.*, t2.content as title, t3.content as description, t4.content as full_news")
								 ->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
								 
			$this->set('arr', $arr);
			$this->set('paginator', array('pages' => $pages, 'total' => $total));
		}
	}
	
	public function pjActionDetail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$arr = pjNewsModel::factory()
							->join('pjMultiLang', "t2.model='pjNews' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t3.model='pjNews' AND t3.foreign_id=t1.id AND t3.field='description' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t4.model='pjNews' AND t4.foreign_id=t1.id AND t4.field='full_news' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
							->select(" t1.*, t2.content as title, t3.content as description, t4.content as full_news")
							->find($_GET['id'])->getData();

			$this->set('arr', $arr);

		}
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>