var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmOptions = $("#frmOptions"),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		if ($frmOptions.length > 0) 
		{
			$frmOptions.validate({
				rules:{
					"value-int-o_news_per_page":{
						positiveNumber: true
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			$.validator.addMethod('positiveNumber',
			    function (value) { 
			        return Number(value) > 0;
			    }, 
			    myLabel.positive_number
			);
		}
		function setInstall()
		{
			var clone = $('#pj_install_clone').text(),
				locale = $('#install_locale').val(),
				layout = $('#install_layout').val(),
				rel = $('#pj_preview_install').attr('rel');
			
			clone = clone.replace(/\{LAYOUT\}/g, '&layout=' + layout);
			if(locale == '')
			{
				clone = clone.replace(/\{LOCALE\}/g, '');
			}else{
				clone = clone.replace(/\{LOCALE\}/g, '&locale=' + locale);
			}
			
			rel = rel.replace(/\{LAYOUT\}/g, '?layout=' + layout);
			if(locale == '')
			{
				rel = rel.replace(/\{LOCALE\}/g, '');
			}else{
				rel = rel.replace(/\{LOCALE\}/g, '&locale=' + locale);
			}
			$('#install_code').val(clone);
			$('#pj_preview_install').attr('href', rel);
		}
		if($('#install_code').length > 0)
		{
			setInstall();
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_paypal']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxPaypal").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxPaypal").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_authorize']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxAuthorize").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxAuthorize").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_bank']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxBankAccount").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxBankAccount").show();
				break;
			}
		}).on("change", ".pj-install-config", function (e) {
			setInstall();
		}).on("change", ".pj-install-config", function (e) {
			setInstall();
		});
	});
})(jQuery_1_8_2);