/*!
 * PHP News Script v1.0
 * https://www.phpjabbers.com/php-news-script/
 * 
 * Copyright 2014, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document,
		routes = [
		          	{pattern: /^#!\/List$/, eventName: "loadList"},
		          	{pattern: /^#!\/List\/page:(\d+)?$/, eventName: "loadList"},
		          	{pattern: /^#!\/Detail\/id:(\d+)?$/, eventName: "loadDetail"},
		         ];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadList");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function NewsManager(opts) {
		if (!(this instanceof NewsManager)) {
			return new NewsManager(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	NewsManager.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	NewsManager.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	NewsManager.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;
			this.page = 1;
			this.id = null;
			this.opts = {};
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("nmContainer_" + this.opts.index);
			this.$container = pjQ.$(this.container);
			
			this.$container.on("click.nm", ".nmSelectorLocale", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var locale = pjQ.$(this).data("id");
				self.opts.locale = locale;
				pjQ.$(this).addClass("nmLocaleFocus").parent().parent().find("a.nmSelectorLocale").not(this).removeClass("nmLocaleFocus");
				
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionLocale", "&session_id=", self.opts.session_id].join(""), {
					"locale_id": locale
				}).done(function (data) {
					self.loadList.call(self);
				}).fail(function () {
					log("Deferred is rejected");
				});
				return false;
			}).on("click.nm", ".nmPaging", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.page = pjQ.$(this).attr('rev');
				
				hashBang(["#!/List/page:", self.page].join(""));
				return false;
			}).on("click.nm", ".nmNewsBack", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				hashBang(["#!/List/page:", self.page].join(""));
				return false;
			}).on("click.nm", ".nmFullNews", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.id = pjQ.$(this).attr('data-id');
				hashBang(["#!/Detail/id:", self.id].join(""));
				return false;
			}).on("click.nm", ".nmNewsURL", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var target = pjQ.$(this).attr('data-target'),
					url = pjQ.$(this).attr('data-url');
				if(target == 'new')
				{
					window.open(url);
				}else{
					window.location.href = url;
				}
				return false;
			}).on("click.nm", ".nmNewsBox", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(pjQ.$(this).hasClass( "nmNewsBoxToggle" ))
				{
					pjQ.$(this).removeClass('nmNewsBoxToggle');
				}else{
					pjQ.$(this).addClass('nmNewsBoxToggle');
				}
				return false;
			});
			
			pjQ.$(window).on("loadList", this.$container, function (e, page) {
				self.page =	page;
				self.loadList.call(self);
			}).on("loadDetail", this.$container, function (e, id) {
				self.id = id;
				self.loadDetail.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadList.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		loadList: function () {
			var self = this,
				index = this.opts.index,
				params = { "index": this.opts.index, "page" : self.page, 'layout' : this.opts.layout, 'hide' : this.opts.hide, 'locale' : this.opts.locale };
			
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionList", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
			}).fail(function () {
				
			});
		},
		loadDetail: function () {
			var self = this,
				index = this.opts.index,
				params = { "index": this.opts.index, "id" : self.id, 'layout' : this.opts.layout, 'hide' : this.opts.hide, 'locale' : this.opts.locale };
			
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionDetail", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
			}).fail(function () {
				
			});
		}
	};
	
	window.NewsManager = NewsManager;	
})(window);