BEGIN;

DROP TABLE IF EXISTS `postcomment_fields`;
CREATE TABLE IF NOT EXISTS `postcomment_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_multi_lang`;
CREATE TABLE IF NOT EXISTS `postcomment_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_options`;
CREATE TABLE IF NOT EXISTS `postcomment_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_roles`;
CREATE TABLE IF NOT EXISTS `postcomment_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_users`;
CREATE TABLE IF NOT EXISTS `postcomment_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_members`;
CREATE TABLE IF NOT EXISTS `postcomment_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `member_since` date DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `avatar_path` varchar(255) DEFAULT NULL,
  `avatar_name` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `last_login` datetime default NULL,
  `active_expire` date default NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_comments`;
CREATE TABLE IF NOT EXISTS `postcomment_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `member_id` int(10) unsigned NOT NULL,
  `topic_id` int(10) unsigned NOT NULL,
  `rating` int(2) unsigned NOT NULL,
  `comment_text` text DEFAULT NULL,
  `subscribed` enum('0','1') DEFAULT '0',
  `likes` int(11) NOT NULL,
  `dislikes` int(11) NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F','R') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `topic_id` (`topic_id`),
  KEY `member_id` (`member_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_votes`;
CREATE TABLE `postcomment_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comment_id` int(11) DEFAULT NULL,
  `user_ip` varchar(20) DEFAULT NULL,
  `vote_value` enum('up','down') DEFAULT NULL,
  `voted_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_topics`;
CREATE TABLE IF NOT EXISTS `postcomment_topics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic` varchar(255) DEFAULT NULL,
  `page_url` varchar(255) DEFAULT NULL,
  `views` int(11) DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
   KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_files`;
CREATE TABLE IF NOT EXISTS `postcomment_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int(11) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comment_id` (`comment_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `postcomment_users_notifications`;
CREATE TABLE IF NOT EXISTS `postcomment_users_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `notification_id` tinyint(3) unsigned DEFAULT NULL,
  `type` enum('email','sms') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`notification_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `postcomment_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddComment', 'backend', 'Add comment', 'script', NULL),
(56, 'lblAddMember', 'backend', 'Label Add member', 'script', NULL),
(57, 'lblAddTopic', 'backend', 'Add Topic', 'script', NULL),
(58, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(59, 'lblAvatar', 'backend', 'Label Avatar', 'script', NULL),
(60, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(61, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(62, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(63, 'lblComment', 'backend', 'Comment', 'script', NULL),
(64, 'lblCommentFiles', 'backend', 'Comment files', 'script', NULL),
(65, 'lblDashLastLogin', 'backend', 'lblDashLastLogin', 'script', NULL),
(66, 'lblDateTime', 'backend', 'Date time', 'script', NULL),
(67, 'lblDays', 'backend', 'Days', 'script', NULL),
(68, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(69, 'lblDeleteAvatarConfirmation', 'backend', 'Delete avatar confirmation', 'script', NULL),
(70, 'lblDeleteAvatarTitle', 'backend', 'Delete avatar title', 'script', NULL),
(71, 'lblDeleteFileConfirmation', 'backend', 'Delete file confirmation', 'script', NULL),
(72, 'lblDeleteFileTitle', 'backend', 'Delete file title', 'script', NULL),
(73, 'lblEmail', 'backend', 'Label Email', 'script', NULL),
(74, 'lblError', 'backend', 'Error', 'script', NULL),
(75, 'lblExport', 'backend', 'Export', 'script', NULL),
(76, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(77, 'lblInstall', 'backend', 'Label Install', 'script', NULL),
(78, 'lblInstallPhp1Title', 'backend', 'Install PHP title', 'script', NULL),
(79, 'lblInstallPhp1_0', 'backend', 'Install step 0', 'script', NULL),
(80, 'lblInstallPhp1_1', 'backend', 'Install step 1', 'script', NULL),
(81, 'lblInstallPhp1_2', 'backend', 'Install step 2', 'script', NULL),
(82, 'lblInstallPhp1_3', 'backend', 'Install step 3', 'script', NULL),
(83, 'lblIp', 'backend', 'IP address', 'script', NULL),
(84, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(85, 'lblMember', 'backend', 'Member', 'script', NULL),
(86, 'lblMemberSince', 'backend', 'Label Member since', 'script', NULL),
(87, 'lblName', 'backend', 'Name', 'script', NULL),
(88, 'lblNo', 'backend', 'No', 'script', NULL),
(89, 'lblOption', 'backend', 'Option', 'script', NULL),
(90, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(91, 'lblPass', 'backend', 'Password', 'script', NULL),
(92, 'lblRating', 'backend', 'Rating', 'script', NULL),
(93, 'lblRevertStatus', 'backend', 'Label Revert status', 'script', NULL),
(94, 'lblRole', 'backend', 'Role', 'script', NULL),
(95, 'lblStatus', 'backend', 'Status', 'script', NULL),
(96, 'lblTopic', 'backend', 'Label Topic', 'script', NULL),
(97, 'lblType', 'backend', 'Type', 'script', NULL),
(98, 'lblUpdateComment', 'backend', 'Update comment', 'script', NULL),
(99, 'lblUpdateMember', 'backend', 'Update member', 'script', NULL),
(100, 'lblUpdateTopic', 'backend', 'Update topic', 'script', NULL),
(101, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(102, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(103, 'lblValue', 'backend', 'Value', 'script', NULL),
(104, 'lblWebsite', 'backend', 'Label Website', 'script', NULL),
(105, 'lblYes', 'backend', 'Yes', 'script', NULL),
(106, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(107, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(108, 'locales', 'backend', 'Languages', 'script', NULL),
(109, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(110, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(111, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(112, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(113, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(114, 'menuComments', 'backend', 'Menu Comments', 'script', NULL),
(115, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(116, 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
(117, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(118, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(119, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(120, 'menuMembers', 'backend', 'Menu Members', 'script', NULL),
(121, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(122, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(123, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(124, 'menuTopics', 'backend', 'Menu Topics', 'script', NULL),
(125, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(126, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(127, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(128, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(129, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(130, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(131, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(132, 'pass', 'backend', 'Password', 'script', NULL),
(133, 'pc_active', 'backend', 'Active', 'script', NULL),
(134, 'pc_delete_confirmation', 'backend', 'Delete Confirmation', 'script', NULL),
(135, 'pc_delete_selected', 'backend', 'Delete selected', 'script', NULL),
(136, 'pc_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(137, 'pc_inactive', 'backend', 'Inactive', 'script', NULL),
(142, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(143, 'url', 'backend', 'URL', 'script', NULL),
(144, 'user', 'backend', 'Username', 'script', NULL),
(145, 'front_button_add_comment', 'frontend', 'Button Add comment', 'script', NULL),
(146, 'front_button_cancel', 'frontend', 'Button Cancel', 'script', NULL),
(147, 'front_button_report', 'frontend', 'Button Report', 'script', NULL),
(148, 'front_files', 'frontend', 'Label Files', 'script', NULL),
(149, 'front_label_avatar', 'frontend', 'Label Avatar', 'script', NULL),
(150, 'front_label_cancel', 'frontend', 'Label Cancel', 'script', NULL),
(151, 'front_label_comment', 'frontend', 'Label comment', 'script', NULL),
(152, 'front_label_email', 'frontend', 'Label Email', 'script', NULL),
(153, 'front_label_forgot_password', 'frontend', 'Label Forgot password?', 'script', NULL),
(154, 'front_label_leave_comment', 'frontend', 'Label Leave a comment', 'script', NULL),
(155, 'front_label_name', 'frontend', 'Label Name', 'script', NULL),
(156, 'front_label_password', 'frontend', 'Label Password', 'script', NULL),
(157, 'front_label_profile', 'frontend', 'Label Profile', 'script', NULL),
(158, 'front_label_rate', 'frontend', 'Label Rate', 'script', NULL),
(159, 'front_label_register', 'frontend', 'Label register', 'script', NULL),
(160, 'front_label_report_comment', 'frontend', 'front_label_report_comment', 'script', NULL),
(161, 'front_label_upload_file', 'frontend', 'Label Upload file', 'script', NULL),
(162, 'front_label_verification', 'frontend', 'Label Verification', 'script', NULL),
(163, 'front_label_website', 'frontend', 'Label Website', 'script', NULL),
(164, 'front_menu_login', 'frontend', 'Menu Login', 'script', NULL),
(165, 'front_menu_logout', 'frontend', 'Menu Logout', 'script', NULL),
(166, 'front_menu_my_profile', 'frontend', 'Menu My Profile', 'script', NULL),
(167, 'front_menu_register', 'frontend', 'Menu Register', 'script', NULL),
(168, 'front_not_found', 'frontend', 'Not found comment', 'script', NULL),
(169, 'front_paging_next', 'frontend', 'Paging Next', 'script', NULL),
(170, 'front_paging_previous', 'frontend', 'Paging Previous', 'script', NULL),
(171, 'comment_statarr_ARRAY_F', 'arrays', 'comment_statarr_ARRAY_F', 'script', NULL),
(172, 'comment_statarr_ARRAY_T', 'arrays', 'comment_statarr_ARRAY_T', 'script', NULL),
(173, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(174, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(175, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(176, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(177, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(178, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(179, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(180, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(181, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(182, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(183, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(184, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(185, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(186, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(187, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(188, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(189, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(190, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(191, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(192, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(193, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(194, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(195, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(196, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(197, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(198, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(199, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(200, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(201, 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
(202, 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(203, 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
(204, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(205, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(206, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(207, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(208, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(209, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(210, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(211, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(212, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(213, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(214, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(215, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(216, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(217, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(218, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(219, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(220, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(221, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(222, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(223, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(224, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(225, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(226, 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
(227, 'error_titles_ARRAY_AM04', 'arrays', 'error_titles_ARRAY_AM04', 'script', NULL),
(228, 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
(229, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(230, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(231, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(232, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(233, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(234, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(235, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(236, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(237, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(238, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(239, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(240, 'front_error_ARRAY_comment', 'arrays', 'front_error_ARRAY_comment', 'script', NULL),
(241, 'front_error_ARRAY_email', 'arrays', 'front_error_ARRAY_email', 'script', NULL),
(242, 'front_error_ARRAY_email_inv', 'arrays', 'front_error_ARRAY_email_inv', 'script', NULL),
(243, 'front_error_ARRAY_name', 'arrays', 'front_error_ARRAY_name', 'script', NULL),
(244, 'front_error_ARRAY_verification', 'arrays', 'front_error_ARRAY_verification', 'script', NULL),
(245, 'front_error_ARRAY_verification_inc', 'arrays', 'front_error_ARRAY_verificaiton_inc', 'script', NULL),
(246, 'front_postcomment_ARRAY_FPC01', 'arrays', 'front_postcomment_ARRAY_FPC01', 'script', NULL),
(247, 'front_postcomment_ARRAY_FPC02', 'arrays', 'front_postcomment_ARRAY_FPC02', 'script', NULL),
(248, 'front_report_case_ARRAY_01', 'arrays', 'front_report_case_ARRAY_01', 'script', NULL),
(249, 'front_report_case_ARRAY_02', 'arrays', 'front_report_case_ARRAY_02', 'script', NULL),
(250, 'front_report_case_ARRAY_03', 'arrays', 'front_report_case_ARRAY_03', 'script', NULL),
(251, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(252, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(253, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(254, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(255, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(256, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(257, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(258, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(259, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(260, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(261, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(262, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(263, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(264, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(265, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(266, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(267, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(268, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(269, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(270, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(271, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(272, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(273, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(274, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(275, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(276, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(277, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(278, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(279, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(280, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(281, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(282, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(283, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(284, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(285, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(286, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(287, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(288, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(289, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(290, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(291, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(292, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(293, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(294, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(295, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(296, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(297, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(298, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(299, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(300, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(301, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(302, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(303, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(304, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(305, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(306, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(307, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(308, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(309, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(310, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(311, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(312, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(313, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(314, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(315, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(316, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(317, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(318, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(319, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(320, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(321, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(322, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(323, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(324, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(325, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(326, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(327, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(332, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(333, 'opt_o_allow_comment_rating', 'backend', 'Options / Allow comment rating', 'script', NULL),
(334, 'opt_o_allow_comment_reporting', 'backend', 'Options / Allow comment reporting', 'script', NULL),
(335, 'opt_o_allow_topic_rating', 'backend', 'Options / Allow topic rating', 'script', NULL),
(336, 'opt_o_allow_file_uploading', 'backend', 'Options / Allow file uploading', 'script', NULL),
(337, 'opt_o_allow_topic_subscribing', 'backend', 'Options / Allow topic subscribing', 'script', NULL),
(338, 'lblSubscribe', 'backend', 'Label Subscribe', 'script', NULL),
(339, 'front_label_subscribe', 'frontend', 'front_label_subscribe', 'script', NULL),
(340, 'front_post_comment_ARRAY_FPC01', 'arrays', 'front_post_comment_ARRAY_FPC01', 'script', NULL),
(341, 'front_post_comment_ARRAY_FPC02', 'arrays', 'front_post_comment_ARRAY_FPC02', 'script', NULL),
(342, 'front_login_text', 'frontend', 'front_login_text', 'script', NULL),
(343, 'front_button_login', 'frontend', 'Front button login', 'script', NULL),
(344, 'front_error_ARRAY_password', 'arrays', 'front_error_ARRAY_password', 'script', NULL),
(345, 'front_login_message_ARRAY_FL02', 'arrays', 'front_login_message_ARRAY_FL02', 'script', NULL),
(346, 'front_login_message_ARRAY_FL03', 'arrays', 'front_login_message_ARRAY_FL03', 'script', NULL),
(347, 'front_forgot_text', 'frontend', 'front_forgot_text', 'script', NULL),
(348, 'front_menu_forgot', 'frontend', 'Frong menu forgot', 'script', NULL),
(349, 'front_button_send', 'frontend', 'Frong button send', 'script', NULL),
(350, 'front_forgot_message_ARRAY_FF01', 'arrays', 'front_forgot_message_ARRAY_FF01', 'script', NULL),
(351, 'front_forgot_message_ARRAY_FF02', 'arrays', 'front_forgot_message_ARRAY_FF02', 'script', NULL),
(352, 'front_forgot_message_ARRAY_FF03', 'arrays', 'front_forgot_message_ARRAY_FF03', 'script', NULL),
(353, 'front_register_text', 'frontend', 'front_register_text', 'script', NULL),
(354, 'front_button_register', 'frontend', 'Front button register', 'script', NULL),
(355, 'front_register_message_ARRAY_FR01', 'arrays', 'front_register_message_ARRAY_FR01', 'script', NULL),
(356, 'front_register_message_ARRAY_FR02', 'arrays', 'front_register_message_ARRAY_FR02', 'script', NULL),
(357, 'front_my_profile_text', 'frontend', 'front_my_profile_text', 'script', NULL),
(358, 'front_profile_message_ARRAY_FP01', 'arrays', 'front_profile_message_ARRAY_FP01', 'script', NULL),
(359, 'front_profile_message_ARRAY_FP02', 'arrays', 'front_profile_message_ARRAY_FP02', 'script', NULL),
(360, 'front_label_remove', 'frontend', 'front_label_remove', 'script', NULL),
(361, 'front_button_update', 'frontend', 'Button Update', 'script', NULL),
(362, 'lblViews', 'backend', 'Label Views', 'script', NULL),
(367, 'front_error_ARRAY_email_ext', 'arrays', 'front_error_ARRAY_email_ext', 'script', NULL),
(368, 'lblReported', 'backend', 'Label Reported', 'script', NULL),
(369, 'comment_statarr_ARRAY_R', 'arrays', 'comment_statarr_ARRAY_R', 'script', NULL),
(370, 'menuNotifications', 'backend', 'Menu Notifications', 'script', NULL),
(371, 'infoNotificationsEmailTitle', 'backend', 'Infobox / Email notifications title', 'script', NULL),
(372, 'infoNotificationsEmailBody', 'backend', 'Infobox / Email notifications body', 'script', NULL),
(373, 'opt_o_email_new_member', 'backend', 'Options / New member notification', 'script', NULL),
(374, 'opt_o_email_new_comment', 'backend', 'Options / New comment notification', 'script', NULL),
(375, 'opt_o_email_report', 'backend', 'Options / Comment reported', 'script', NULL),
(376, 'opt_o_email_new_reply', 'backend', 'Options / New reply posted', 'script', NULL),
(377, 'opt_o_email_password_reminder', 'backend', 'Options / Password reminder', 'script', NULL),
(378, 'opt_subject', 'backend', 'Notifications / Subject', 'script', NULL),
(379, 'opt_body_new_member', 'backend', 'Notifications / Body', 'script', NULL),
(380, 'opt_body_new_comment', 'backend', 'Notifications / Body', 'script', NULL),
(381, 'opt_body_report', 'backend', 'Notifications / Body', 'script', NULL),
(382, 'opt_body_new_reply', 'backend', 'Notifications / Body', 'script', NULL),
(383, 'opt_body_password_reminder', 'backend', 'Notifications / Body', 'script', NULL),
(384, 'notify_email_ARRAY_1', 'arrays', 'notify_email_ARRAY_1', 'script', NULL),
(385, 'notify_email_ARRAY_2', 'arrays', 'notify_email_ARRAY_2', 'script', NULL),
(386, 'notify_email_ARRAY_3', 'arrays', 'notify_email_ARRAY_3', 'script', NULL),
(387, 'notify_email_ARRAY_4', 'arrays', 'notify_email_ARRAY_4', 'script', NULL),
(388, 'lblNotifyEmail', 'backend', 'Label Email notifications', 'script', NULL),
(389, 'lblNotifyEmailTip', 'backend', 'Label email notification tip', 'script', NULL),
(391, 'lblTopics', 'backend', 'Label Topics', 'script', NULL),
(392, 'lblMembers', 'backend', 'Label Members', 'script', NULL),
(393, 'lblComments', 'backend', 'Label Comments', 'script', NULL),
(394, 'lblPopularTopics', 'backend', 'Label Most popular topics', 'script', NULL),
(395, 'lblLatestComments', 'backend', 'Label Latest comments', 'script', NULL),
(396, 'lblTopMembers', 'backend', 'Label Top members', 'script', NULL),
(397, 'lblLast', 'backend', 'Label last', 'script', NULL),
(398, 'lblNoTopicFound', 'backend', 'No topic found', 'script', NULL),
(399, 'lblBy', 'backend', 'By', 'script', NULL),
(400, 'lblNoCommentFound', 'backend', 'No comment found', 'script', NULL),
(401, 'lblNoMemberFound', 'backend', 'No member found', 'script', NULL),
(402, 'lblLastComment', 'backend', 'Last comment', 'script', NULL),
(403, 'front_paging_previous_2', 'backend', 'front_paging_previous_2', 'script', NULL),
(404, 'front_register_message_ARRAY_FR03', 'backend', 'front_register_message_ARRAY_FR03', 'script', NULL),
(405, 'front_forgot_message_ARRAY_FF04', 'arrays', 'front_forgot_message_ARRAY_FF04', 'script', NULL),
(406, 'front_login_message_ARRAY_FL04', 'arrays', 'front_login_message_ARRAY_FL04', 'script', NULL),
(407, 'front_postcomment_ARRAY_FPC03', 'arrays', 'front_postcomment_ARRAY_FPC03', 'script', NULL),
(408, 'opt_o_email_member_confirmation', 'backend', 'Notifications / Body', 'script', NULL),
(409, 'opt_o_new_member_activation', 'backend', 'Options / New member activation', 'script', NULL),
(410, 'opt_body_member_confirmation', 'backend', 'Notifications / Body', 'script', NULL),
(412, 'lblPhone', 'backend', 'Label phone', 'script', NULL),
(413, 'lblDeleteCommentTitle', 'backend', 'Comment delete confirmation', 'script', NULL),
(414, 'lblDeleteCommentConfirmation', 'backend', 'Comment delete confirmation', 'script', NULL),
(415, 'front_register_message_ARRAY_FR011', 'arrays', 'front_register_message_ARRAY_FR011', 'script', NULL),
(416, 'front_register_message_ARRAY_FR012', 'arrays', 'front_register_message_ARRAY_FR012', 'script', NULL),
(417, 'front_register_message_ARRAY_FR013', 'arrays', 'front_register_message_ARRAY_FR013', 'script', NULL),
(418, 'front_activation_message_ARRAY_FA01', 'arrays', 'front_activation_message_ARRAY_FA01', 'script', NULL),
(419, 'front_activation_message_ARRAY_FA02', 'arrays', 'front_activation_message_ARRAY_FA02', 'script', NULL),
(420, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(421, 'menuFeatures', 'backend', 'Menu / Features', 'script', NULL),
(422, 'opt_o_send_email', 'backend', 'Options / Send email', 'script', NULL),
(423, 'opt_o_smtp_host', 'backend', 'Options / SMTP Host', 'script', NULL),
(424, 'opt_o_smtp_pass', 'backend', 'Options / SMTP Password', 'script', NULL),
(425, 'opt_o_smtp_port', 'backend', 'Options / SMTP Port', 'script', NULL),
(426, 'opt_o_smtp_user', 'backend', 'Options / SMTP Username', 'script', NULL),
(427, 'opt_o_comment_order', 'backend', 'Options / Comment order', 'script', NULL),
(452, 'lblPageURL', 'backend', 'Label Page URL', 'script', NULL),
(453, 'notify_sms_ARRAY_1', 'arrays', 'notify_sms_ARRAY_1', 'script', NULL),
(454, 'notify_sms_ARRAY_2', 'arrays', 'notify_sms_ARRAY_2', 'script', NULL),
(455, 'notify_sms_ARRAY_3', 'arrays', 'notify_sms_ARRAY_3', 'script', NULL),
(456, 'lblNotifySms', 'backend', 'Label Sms notifications', 'script', NULL),
(492, 'tabEmails', 'backend', 'Tab / Emails', 'script', NULL),
(493, 'tabSms', 'backend', 'Tab / Sms', 'script', NULL),
(494, 'infoNotificationsSmsTitle', 'backend', 'Infobox / Sms notifications title', 'script', NULL),
(495, 'infoNotificationsSmsBody', 'backend', 'Infobox / Sms notifications body', 'script', NULL),
(496, 'opt_o_sms_new_member_registration', 'backend', 'Notifications / New member registration', 'script', NULL),
(497, 'opt_o_sms_new_comment', 'backend', 'Notifications / New comment posted', 'script', NULL),
(498, 'opt_o_sms_comment_reported', 'backend', 'Notifications / Comment reported', 'script', NULL),
(499, 'lblExportComments', 'backend', 'Label / Export comments', 'script', NULL),
(500, 'lblPreview', 'backend', 'Label / Preview', 'script', NULL),
(536, 'add_topic_titles_title', 'backend', 'Infobox / Add topic title', 'script', NULL),
(537, 'add_topic_titles_body', 'backend', 'Infobox / Add topic body', 'script', NULL),
(538, 'member_list_titles_title', 'backend', 'Infobox / Member list title', 'script', NULL),
(539, 'member_list_titles_body', 'backend', 'Infox / Member list titles body', 'script', NULL),
(540, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(541, 'lnkInstall', 'backend', 'Link / Install', 'script', NULL),
(542, 'front_label_unsubscribe', 'frontend', 'Label / Unsubscribe', 'script', NULL),
(543, 'unsubscribe_statarr_ARRAY_0', 'arrays', 'unsubscribe_statarr_ARRAY_0', 'script', NULL),
(544, 'unsubscribe_statarr_ARRAY_1', 'arrays', 'unsubscribe_statarr_ARRAY_1', 'script', NULL),
(545, 'front_postcomment_ARRAY_FPC04', 'arrays', 'front_postcomment_ARRAY_FPC04', 'script', NULL),
(546, 'front_postcomment_ARRAY_FPC05', 'arrays', 'front_postcomment_ARRAY_FPC05', 'script', NULL),
(547, 'front_activation_message_ARRAY_FA03', 'arrays', 'front_activation_message_ARRAY_FA03', 'script', NULL),
(548, 'opt_o_items_per_page', 'backend', 'opt_o_items_per_page', 'script', NULL),
(549, 'front_label_notopic', 'frontend', 'front_label_notopic', 'script', NULL),
(550, 'front_label_inactive_topic', 'frontend', 'front_label_inactive_topic', 'script', NULL),
(551, 'front_postcomment_ARRAY_FPC06', 'arrays', 'front_postcomment_ARRAY_FPC06', 'script', NULL),
(552, 'front_postcomment_ARRAY_FPC07', 'arrays', 'front_postcomment_ARRAY_FPC07', 'script', NULL),
(553, 'opt_o_resend_activation_url', 'backend', 'Label / Resend activation URL', 'script', NULL),
(554, 'front_activation_message_ARRAY_FA04', 'arrays', 'front_activation_message_ARRAY_FA04', 'script', NULL),
(555, 'front_link_resend_activation_url', 'frontend', 'Link / Resend activation URL', 'script', NULL),
(556, 'front_resend_text', 'frontend', 'front_resend_text', 'script', NULL),
(557, 'front_resend_message_ARRAY_FS01', 'arrays', 'front_resend_message_ARRAY_FS01', 'script', NULL),
(558, 'front_resend_message_ARRAY_FS02', 'arrays', 'front_resend_message_ARRAY_FS02', 'script', NULL),
(559, 'front_resend_message_ARRAY_FS03', 'arrays', 'front_resend_message_ARRAY_FS03', 'script', NULL),
(560, 'front_error_ARRAY_file_ext', 'arrays', 'front_error_ARRAY_file_ext', 'script', NULL),
(561, 'front_register_message_ARRAY_FR04', 'backend', 'front_register_message_ARRAY_FR04', 'script', NULL),
(562, 'front_postcomment_ARRAY_FPC08', 'arrays', 'front_postcomment_ARRAY_FPC08', 'script', NULL),
(563, 'front_login_message_ARRAY_FL05', 'arrays', 'front_login_message_ARRAY_FL05', 'script', NULL),
(564, 'front_login_message_ARRAY_FL06', 'arrays', 'front_login_message_ARRAY_FL06', 'script', NULL),
(565, 'front_login_message_ARRAY_FL07', 'arrays', 'front_login_message_ARRAY_FL07', 'script', NULL),
(566, 'front_login_message_ARRAY_FL08', 'arrays', 'front_login_message_ARRAY_FL08', 'script', NULL),
(567, 'front_login_message_ARRAY_FL09', 'arrays', 'front_login_message_ARRAY_FL09', 'script', NULL),
(568, 'front_forgot_message_ARRAY_FF05', 'arrays', 'front_forgot_message_ARRAY_FF05', 'script', NULL),
(569, 'front_forgot_message_ARRAY_FF06', 'arrays', 'front_forgot_message_ARRAY_FF06', 'script', NULL),
(570, 'front_forgot_message_ARRAY_FF07', 'arrays', 'front_forgot_message_ARRAY_FF07', 'script', NULL),
(571, 'front_resend_message_ARRAY_FS04', 'arrays', 'front_resend_message_ARRAY_FS04', 'script', NULL),
(572, 'front_resend_message_ARRAY_FS05', 'arrays', 'front_resend_message_ARRAY_FS05', 'script', NULL),
(573, 'front_resend_message_ARRAY_FS06', 'arrays', 'front_resend_message_ARRAY_FS06', 'script', NULL),
(574, 'front_register_message_ARRAY_FR20', 'arrays', 'front_register_message_ARRAY_FR20', 'script', NULL),
(575, 'front_register_message_ARRAY_FR21', 'arrays', 'front_register_message_ARRAY_FR21', 'script', NULL),
(576, 'front_register_message_ARRAY_FR22', 'arrays', 'front_register_message_ARRAY_FR22', 'script', NULL),
(577, 'front_register_message_ARRAY_FR23', 'arrays', 'front_register_message_ARRAY_FR23', 'script', NULL),
(578, 'front_register_message_ARRAY_FR24', 'arrays', 'front_register_message_ARRAY_FR24', 'script', NULL),
(579, 'front_register_message_ARRAY_FR25', 'arrays', 'front_register_message_ARRAY_FR25', 'script', NULL),
(580, 'front_register_message_ARRAY_FR26', 'arrays', 'front_register_message_ARRAY_FR26', 'script', NULL),
(581, 'front_register_message_ARRAY_FR27', 'arrays', 'front_register_message_ARRAY_FR27', 'script', NULL),
(582, 'front_register_message_ARRAY_FR28', 'arrays', 'front_register_message_ARRAY_FR28', 'script', NULL),
(583, 'front_postcomment_ARRAY_FPC09', 'arrays', 'front_postcomment_ARRAY_FPC09', 'script', NULL),
(584, 'front_postcomment_ARRAY_FPC10', 'arrays', 'front_postcomment_ARRAY_FPC10', 'script', NULL),
(585, 'front_postcomment_ARRAY_FPC11', 'arrays', 'front_postcomment_ARRAY_FPC11', 'script', NULL),
(586, 'front_postcomment_ARRAY_FPC12', 'arrays', 'front_postcomment_ARRAY_FPC12', 'script', NULL),
(587, 'front_postcomment_ARRAY_FPC13', 'arrays', 'front_postcomment_ARRAY_FPC13', 'script', NULL),
(588, 'front_postcomment_ARRAY_FPC14', 'arrays', 'front_postcomment_ARRAY_FPC14', 'script', NULL),
(589, 'front_postcomment_ARRAY_FPC15', 'arrays', 'front_postcomment_ARRAY_FPC15', 'script', NULL),
(590, 'front_postcomment_ARRAY_FPC16', 'arrays', 'front_postcomment_ARRAY_FPC16', 'script', NULL),
(591, 'front_postcomment_ARRAY_FPC17', 'arrays', 'front_postcomment_ARRAY_FPC17', 'script', NULL),
(592, 'front_postcomment_ARRAY_FPC18', 'arrays', 'front_postcomment_ARRAY_FPC18', 'script', NULL),
(593, 'opt_o_file_allowed', 'backend', 'File allowed to upload', 'script', NULL);

INSERT INTO `postcomment_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '&laquo; Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next &raquo;', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next &raquo;', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '&laquo; Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '&laquo; Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'Listing Address Body', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'Listing Address Body', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Listing Address Title', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Listing Address Title', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add comment', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add comment', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add comment', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Add member', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Add member', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Add member', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Add topic', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Add topic', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Add topic', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'Avatar', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'Avatar', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Comment(s)', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Comment(s)', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Comment(s)', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'File(s)', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'File(s)', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'File(s)', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Date time', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Date time', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Date time', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 67, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Are you sure that you want to delete this avatar?', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Are you sure that you want to delete this avatar?', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Are you sure that you want to delete this avatar?', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Delete avatar', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Delete avatar', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Delete avatar', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Are you sure that you want to delete this file?', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Are you sure that you want to delete this file?', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Are you sure that you want to delete this file?', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Delete file', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Delete file', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Delete file', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 76, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Post comment PHP install code', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Post comment PHP install code', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Post comment PHP install code', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Please select the topic that you want to install.', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Please select the topic that you want to install.', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Please select the topic that you want to install.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Step 2. Copy and paste following code inside your html code, where the post comment form will be displayed.', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Step 2. Copy and paste following code inside your html code, where the post comment form will be displayed.', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Step 2. Copy and paste following code inside your html code, where the post comment form will be displayed.', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Member(s)', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Member(s)', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Member(s)', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Member since', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Member since', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Member since', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 88, 'pjField', 2, 'title', '??', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Rating', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Rating', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Rating', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Topic(s)', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Topic(s)', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Topic(s)', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Update comment', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'Update comment', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'Update comment', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Update member', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'Update member', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'Update member', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Update topic', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'Update topic', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'Update topic', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 104, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 104, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 105, 'pjField', 2, 'title', '??', 'script'),
(NULL, 105, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 106, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 106, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 107, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 107, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 108, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 108, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 109, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 109, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 110, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 110, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 111, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 111, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 112, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 112, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 113, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 113, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 114, 'pjField', 2, 'title', 'Comments', 'script'),
(NULL, 114, 'pjField', 3, 'title', 'Comments', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 115, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 115, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 116, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 116, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 117, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 117, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 118, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 118, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 119, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 119, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 120, 'pjField', 2, 'title', 'Members', 'script'),
(NULL, 120, 'pjField', 3, 'title', 'Members', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 121, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 121, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 122, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 122, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 123, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 123, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Topics', 'script'),
(NULL, 124, 'pjField', 2, 'title', 'Topics', 'script'),
(NULL, 124, 'pjField', 3, 'title', 'Topics', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'Email address is already in use', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'Email address is already in use', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Add comment', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'Add comment', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'Add comment', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Report', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Report', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Report', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'File(s)', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'File(s)', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'File(s)', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'Avatar', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'Avatar', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'Comment', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'Comment', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'Forgot password?', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'Forgot password?', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Leave a comment', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'Leave a comment', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'Leave a comment', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 157, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 157, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Rate', 'script'),
(NULL, 158, 'pjField', 2, 'title', 'Rate', 'script'),
(NULL, 158, 'pjField', 3, 'title', 'Rate', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Register', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Register', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Report this comment if it is:', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Report this comment if it is:', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Report this comment if it is:', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Upload file', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Upload file', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Upload file', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Verification', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Verification', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Verification', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'My Profile', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'My Profile', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'My Profile', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Register', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Register', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'No comments found.', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'There is no comment found.', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'There is no comment found.', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'Next', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'Next', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'Prev', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'Prev', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Not approved', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'Not approved', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'Not approved', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Approved', 'script'),
(NULL, 172, 'pjField', 2, 'title', 'Approved', 'script'),
(NULL, 172, 'pjField', 3, 'title', 'Approved', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 173, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 173, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'All the changes made to this comment have been saved.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'All the changes made to this comment have been saved.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'All the changes made to this comment have been saved.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'All the changes made to this comment have been saved.', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'All the changes made to this comment have been saved.', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'All the changes made to this comment have been saved.', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'We are sorry, but the comment has not been added.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'We are sorry, but the comment has not been added.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'We are sorry, but the comment has not been added.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Comment you are looking for is missing.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Comment you are looking for is missing.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Comment you are looking for is missing.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'All the changes made to this member have been saved.', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'All the changes made to this member have been saved.', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'All the changes made to this member have been saved.', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'All the changes made to this member have been saved.', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'All the changes made to this member have been saved.', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'All the changes made to this member have been saved.', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'We are sorry, but the member has not been added.', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'We are sorry, but the member has not been added.', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'We are sorry, but the member has not been added.', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Member you are looking for is missing.', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Member you are looking for is missing.', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Member you are looking for is missing.', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'All the changes made to this topic have been saved.', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'All the changes made to this topic have been saved.', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'All the changes made to this topic have been saved.', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'All the changes made to this topic have been saved.', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'All the changes made to this topic have been saved.', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'All the changes made to this topic have been saved.', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'We are sorry, but the topic has not been added.', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'We are sorry, but the topic has not been added.', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'We are sorry, but the topic has not been added.', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Topic you are looking for is missing.', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Topic you are looking for is missing.', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Topic you are looking for is missing.', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Comment updated!', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Comment updated!', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Comment updated!', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Comment added!', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Comment added!', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Comment added!', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Comment failed to add.', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'Comment failed to add.', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'Comment failed to add.', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Comment not found.', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'Comment not found.', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'Comment not found.', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Member updated!', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'Member updated!', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'Member updated!', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Member added!', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'Member added!', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'Member added!', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Member failed to added.', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'Member failed to added.', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'Member failed to added.', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Member not found.', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'Member not found.', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'Member not found.', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Topic updated!', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'Topic updated!', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'Topic updated!', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Topic added!', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'Topic added!', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'Topic added!', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Topic failed to added.', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'Topic failed to added.', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'Topic failed to added.', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Topic not found.', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'Topic not found.', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'Topic not found.', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Comment is required.', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'Comment is required.', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'Comment is required.', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'Email is required.', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'Email is required.', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Email is invalid', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'Email is invalid', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'Email is invalid', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'Name is required.', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'Name is required.', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Verification is required.', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'Verification is required.', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'Verification is required.', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Verification is incorrect.', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'Verification is incorrect.', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'Verification is incorrect.', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Your comment was saved successfully.', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'Your comment was saved successfully.', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'Your comment was saved successfully.', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Sorry! your comment was not saved.', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'Sorry! your comment was not saved.', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'Sorry! your comment was not saved.', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'spam', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'spam', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'spam', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'offensive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'offensive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'offensive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'out of topic', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'out of topic', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'out of topic', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 257, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 257, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 258, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 258, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'March', 'script');
INSERT INTO `postcomment_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 259, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 259, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 260, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 260, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 261, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 261, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 262, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 262, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 263, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 263, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 264, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 264, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 265, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 265, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 266, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 266, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 267, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 267, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 268, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 268, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 269, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 269, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 270, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 270, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 271, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 271, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 272, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 272, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 273, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 273, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 274, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 274, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 275, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 275, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 276, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 276, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 277, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 277, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 278, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 278, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 279, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 279, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 280, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 280, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 281, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 281, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 291, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 292, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 304, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 304, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 305, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 305, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 306, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 306, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 307, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 307, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 316, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 316, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 317, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 317, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 318, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 318, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 319, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 319, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 320, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 320, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 321, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 321, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 323, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 323, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 324, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 324, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Allow comment rating', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'Allow comment rating', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'Allow comment rating', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Allow comment reporting', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Allow comment reporting', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Allow comment reporting', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Allow topic rating', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'Allow topic rating', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'Allow topic rating', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Allow file uploading', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Allow file uploading', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Allow file uploading', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Allow topic subscribing', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'Allow topic subscribing', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'Allow topic subscribing', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Subscribe', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Subscribe', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Subscribe', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Subscribe', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'Subscribe', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'Subscribe', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Your comment was saved successfully.', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Your comment was saved successfully.', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Your comment was saved successfully.', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Your comment was not saved.', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'Your comment was not saved.', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'Your comment was not saved.', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Password is required.', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Password is required.', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Wrong email or password!', 'script'),
(NULL, 345, 'pjField', 2, 'title', 'Wrong email or password!', 'script'),
(NULL, 345, 'pjField', 3, 'title', 'Wrong email or password!', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Your account is still not activated.', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'Your account is still not activated.', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'Your account is still not activated.', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim.', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim.', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim.', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'The password has just been sent to your email address.', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'The password has just been sent to your email address.', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'The password has just been sent to your email address.', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Your account is still not activated.', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'Your account is still not activated.', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'Your account is still not activated.', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Your email was not found.', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'Your email was not found.', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'Your email was not found.', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 354, 'pjField', 2, 'title', 'Register', 'script'),
(NULL, 354, 'pjField', 3, 'title', 'Register', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Your account has been created successfully.', 'script'),
(NULL, 355, 'pjField', 2, 'title', 'Your account has been created successfully.', 'script'),
(NULL, 355, 'pjField', 3, 'title', 'Your account has been created successfully.', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Your account was not created.', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Your account was not created.', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Your account was not created.', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.', 'script'),
(NULL, 357, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.', 'script'),
(NULL, 357, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Your profile was updated.', 'script'),
(NULL, 358, 'pjField', 2, 'title', 'Your profile was updated.', 'script'),
(NULL, 358, 'pjField', 3, 'title', 'Your profile was updated.', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Your profile was not updated.', 'script'),
(NULL, 359, 'pjField', 2, 'title', 'Your profile was not updated.', 'script'),
(NULL, 359, 'pjField', 3, 'title', 'Your profile was not updated.', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'remove', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'remove', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'remove', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 362, 'pjField', 2, 'title', 'Views', 'script'),
(NULL, 362, 'pjField', 3, 'title', 'Views', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Email was already used.', 'script'),
(NULL, 367, 'pjField', 2, 'title', 'Email was already used.', 'script'),
(NULL, 367, 'pjField', 3, 'title', 'Email was already used.', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Reported', 'script'),
(NULL, 368, 'pjField', 2, 'title', 'Reported', 'script'),
(NULL, 368, 'pjField', 3, 'title', 'Reported', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Reported', 'script'),
(NULL, 369, 'pjField', 2, 'title', 'Reported', 'script'),
(NULL, 369, 'pjField', 3, 'title', 'Reported', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 370, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 370, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 371, 'pjField', 2, 'title', 'Email notifications', 'script'),
(NULL, 371, 'pjField', 3, 'title', 'Email notifications', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Different email notifications will be sent when various events occur. You can edit each of the Users and set which emails to receive.', 'script'),
(NULL, 372, 'pjField', 2, 'title', 'Different email notifications will be sent when various events happen. You can edit each of the Users and set which emails to receive.', 'script'),
(NULL, 372, 'pjField', 3, 'title', 'Different email notifications will be sent when various events happen. You can edit each of the Users and set which emails to receive.', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'New member notification', 'script'),
(NULL, 373, 'pjField', 2, 'title', 'New member notification', 'script'),
(NULL, 373, 'pjField', 3, 'title', 'New member notification', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'New comment notification', 'script'),
(NULL, 374, 'pjField', 2, 'title', 'New comment notification', 'script'),
(NULL, 374, 'pjField', 3, 'title', 'New comment notification', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Comment reported', 'script'),
(NULL, 375, 'pjField', 2, 'title', 'Comment reported', 'script'),
(NULL, 375, 'pjField', 3, 'title', 'Comment reported', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'New reply posted', 'script'),
(NULL, 376, 'pjField', 2, 'title', 'New reply posted', 'script'),
(NULL, 376, 'pjField', 3, 'title', 'New reply posted', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 377, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 377, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 378, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 378, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Body\r\n<br/><br/>\r\nAvailable tokens:<br/>\r\n{Name}<br/>\r\n{Email}', 'script'),
(NULL, 379, 'pjField', 2, 'title', 'Body\r\n<br/><br/>\r\nAvailable tokens:<br/>\r\n{Name}<br/>\r\n{Email}', 'script'),
(NULL, 379, 'pjField', 3, 'title', 'Body\r\n<br/><br/>\r\nAvailable tokens:<br/>\r\n{Name}<br/>\r\n{Email}', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{EditCommentURL}', 'script'),
(NULL, 380, 'pjField', 2, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{EditCommentURL}', 'script'),
(NULL, 380, 'pjField', 3, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{EditCommentURL}', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{EditCommentURL}', 'script'),
(NULL, 381, 'pjField', 2, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{EditCommentURL}', 'script'),
(NULL, 381, 'pjField', 3, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{EditCommentURL}', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{ViewCommentURL}', 'script'),
(NULL, 382, 'pjField', 2, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{ViewCommentURL}', 'script'),
(NULL, 382, 'pjField', 3, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{CommentID}\r\n<br/>\r\n{TopicName}\r\n<br/>\r\n{CommentMessage}\r\n<br/>\r\n{ViewCommentURL}', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{Name}\r\n<br/>\r\n{Email}\r\n<br/>\r\n{Password}', 'script'),
(NULL, 383, 'pjField', 2, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{Name}\r\n<br/>\r\n{Email}\r\n<br/>\r\n{Password}', 'script'),
(NULL, 383, 'pjField', 3, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:\r\n<br/>\r\n{Name}\r\n<br/>\r\n{Email}\r\n<br/>\r\n{Password}', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'New member notification', 'script'),
(NULL, 384, 'pjField', 2, 'title', 'New member notification', 'script'),
(NULL, 384, 'pjField', 3, 'title', 'New member notification', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'New comment notification', 'script'),
(NULL, 385, 'pjField', 2, 'title', 'New comment notification', 'script'),
(NULL, 385, 'pjField', 3, 'title', 'New comment notification', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Comment reported', 'script'),
(NULL, 386, 'pjField', 2, 'title', 'Comment reported', 'script'),
(NULL, 386, 'pjField', 3, 'title', 'Comment reported', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'New reply posted', 'script'),
(NULL, 387, 'pjField', 2, 'title', 'New reply posted', 'script'),
(NULL, 387, 'pjField', 3, 'title', 'New reply posted', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 388, 'pjField', 2, 'title', 'Email notifications', 'script'),
(NULL, 388, 'pjField', 3, 'title', 'Email notifications', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Select the notifications this user should receive', 'script'),
(NULL, 389, 'pjField', 2, 'title', 'Email notification tip - content', 'script'),
(NULL, 389, 'pjField', 3, 'title', 'Email notification tip - content', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Topics', 'script'),
(NULL, 391, 'pjField', 2, 'title', 'Topics', 'script'),
(NULL, 391, 'pjField', 3, 'title', 'Topics', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 392, 'pjField', 2, 'title', 'Members', 'script'),
(NULL, 392, 'pjField', 3, 'title', 'Members', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 393, 'pjField', 2, 'title', 'Comments', 'script'),
(NULL, 393, 'pjField', 3, 'title', 'Comments', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Most popular topics', 'script'),
(NULL, 394, 'pjField', 2, 'title', 'Most popular topics', 'script'),
(NULL, 394, 'pjField', 3, 'title', 'Most popular topics', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Latest comments', 'script'),
(NULL, 395, 'pjField', 2, 'title', 'Latest comments', 'script'),
(NULL, 395, 'pjField', 3, 'title', 'Latest comments', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Top members', 'script'),
(NULL, 396, 'pjField', 2, 'title', 'Top members', 'script'),
(NULL, 396, 'pjField', 3, 'title', 'Top members', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'last', 'script'),
(NULL, 397, 'pjField', 2, 'title', 'last', 'script'),
(NULL, 397, 'pjField', 3, 'title', 'last', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'No topics found.', 'script'),
(NULL, 398, 'pjField', 2, 'title', 'No topics found.', 'script'),
(NULL, 398, 'pjField', 3, 'title', 'No topics found.', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 399, 'pjField', 2, 'title', 'by', 'script'),
(NULL, 399, 'pjField', 3, 'title', 'by', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'No comments found.', 'script'),
(NULL, 400, 'pjField', 2, 'title', 'No comments found.', 'script'),
(NULL, 400, 'pjField', 3, 'title', 'No comments found.', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'No members found.', 'script'),
(NULL, 401, 'pjField', 2, 'title', 'No members found.', 'script'),
(NULL, 401, 'pjField', 3, 'title', 'No members found.', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'last comment', 'script'),
(NULL, 402, 'pjField', 2, 'title', 'last comment', 'script'),
(NULL, 402, 'pjField', 3, 'title', 'last comment', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Previous', 'script'),
(NULL, 403, 'pjField', 2, 'title', 'Previous', 'script'),
(NULL, 403, 'pjField', 3, 'title', 'Previous', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 404, 'pjField', 2, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 404, 'pjField', 3, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 405, 'pjField', 2, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 405, 'pjField', 3, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 406, 'pjField', 2, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 406, 'pjField', 3, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 407, 'pjField', 2, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 407, 'pjField', 3, 'title', 'The data you entered is not valid.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'New member confirmation', 'script'),
(NULL, 408, 'pjField', 2, 'title', 'New member confirmation', 'script'),
(NULL, 408, 'pjField', 3, 'title', 'New member confirmation', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'New member activation', 'script'),
(NULL, 409, 'pjField', 2, 'title', 'New member activation', 'script'),
(NULL, 409, 'pjField', 3, 'title', 'New member activation', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:<br/>\r\n{Name}<br/>\r\n{Email}<br/>\r\n{ActivatedURL}', 'script'),
(NULL, 410, 'pjField', 2, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:<br/>\r\n{Name}<br/>\r\n{Email}<br/>\r\n{ActivatedURL}', 'script'),
(NULL, 410, 'pjField', 3, 'title', 'Body\r\n<br/>\r\n<br/>\r\nAvailable tokens:<br/>\r\n{Name}<br/>\r\n{Email}<br/>\r\n{ActivatedURL}', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 412, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 412, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Comment delete confirmation', 'script'),
(NULL, 413, 'pjField', 2, 'title', 'Comment delete confirmation', 'script'),
(NULL, 413, 'pjField', 3, 'title', 'Comment delete confirmation', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Are you sure that you want to delete this comment?', 'script'),
(NULL, 414, 'pjField', 2, 'title', 'Are you sure that you want to delete this comment?', 'script'),
(NULL, 414, 'pjField', 3, 'title', 'Are you sure that you want to delete this comment?', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Your account has been created successfully. It was also activated.', 'script'),
(NULL, 415, 'pjField', 2, 'title', 'Your account has been created successfully. It was also activated.', 'script'),
(NULL, 415, 'pjField', 3, 'title', 'Your account has been created successfully. It was also activated.', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Your account has been created successfully. Please check your email to activate the account.', 'script'),
(NULL, 416, 'pjField', 2, 'title', 'Your account has been created successfully. Please check your email to activate the account.', 'script'),
(NULL, 416, 'pjField', 3, 'title', 'Your account has been created successfully. Please check your email to activate the account.', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Your account has been created successfully. It will be activated by the administrator.', 'script'),
(NULL, 417, 'pjField', 2, 'title', 'Your account has been created successfully. It will be activated by the administrator.', 'script'),
(NULL, 417, 'pjField', 3, 'title', 'Your account has been created successfully. It will be activated by the administrator.', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Your account has been activated.', 'script'),
(NULL, 418, 'pjField', 2, 'title', 'Your account has been activated.', 'script'),
(NULL, 418, 'pjField', 3, 'title', 'Your account has been activated.', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'The account could not be found in the system.', 'script'),
(NULL, 419, 'pjField', 2, 'title', 'The account could not be found in the system.', 'script'),
(NULL, 419, 'pjField', 3, 'title', 'The account could not be found in the system.', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 420, 'pjField', 2, 'title', 'General', 'script'),
(NULL, 420, 'pjField', 3, 'title', 'General', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 421, 'pjField', 2, 'title', 'Features', 'script'),
(NULL, 421, 'pjField', 3, 'title', 'Features', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 422, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 422, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 423, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 423, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 424, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 424, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 425, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 425, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 426, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 426, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Comment order', 'script'),
(NULL, 427, 'pjField', 2, 'title', 'Comment order', 'script'),
(NULL, 427, 'pjField', 3, 'title', 'Comment order', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Page URL', 'script'),
(NULL, 452, 'pjField', 2, 'title', 'Page URL', 'script'),
(NULL, 452, 'pjField', 3, 'title', 'Page URL', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'New member registration', 'script'),
(NULL, 453, 'pjField', 2, 'title', 'New member registration', 'script'),
(NULL, 453, 'pjField', 3, 'title', 'New member registration', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'New comment posted', 'script'),
(NULL, 454, 'pjField', 2, 'title', 'New comment posted', 'script'),
(NULL, 454, 'pjField', 3, 'title', 'New comment posted', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Comment reported', 'script'),
(NULL, 455, 'pjField', 2, 'title', 'Comment reported', 'script'),
(NULL, 455, 'pjField', 3, 'title', 'Comment reported', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Sms notifications', 'script'),
(NULL, 456, 'pjField', 2, 'title', 'Sms notifications', 'script'),
(NULL, 456, 'pjField', 3, 'title', 'Sms notifications', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 492, 'pjField', 2, 'title', 'Emails', 'script'),
(NULL, 492, 'pjField', 3, 'title', 'Emails', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Sms', 'script'),
(NULL, 493, 'pjField', 2, 'title', 'Sms', 'script'),
(NULL, 493, 'pjField', 3, 'title', 'Sms', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Sms notifications', 'script'),
(NULL, 494, 'pjField', 2, 'title', 'Sms notifications', 'script'),
(NULL, 494, 'pjField', 3, 'title', 'Sms notifications', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Different SMS notifications will be sent when various events occur. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 495, 'pjField', 2, 'title', 'Different SMS notifications will be sent when various events happen. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 495, 'pjField', 3, 'title', 'Different SMS notifications will be sent when various events happen. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'New member registration', 'script'),
(NULL, 496, 'pjField', 2, 'title', 'New member registration', 'script'),
(NULL, 496, 'pjField', 3, 'title', 'New member registration', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'New comment posted', 'script'),
(NULL, 497, 'pjField', 2, 'title', 'New comment posted', 'script'),
(NULL, 497, 'pjField', 3, 'title', 'New comment posted', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Comment reported', 'script'),
(NULL, 498, 'pjField', 2, 'title', 'Comment reported', 'script'),
(NULL, 498, 'pjField', 3, 'title', 'Comment reported', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Export comments', 'script'),
(NULL, 499, 'pjField', 2, 'title', 'Export comments', 'script'),
(NULL, 499, 'pjField', 3, 'title', 'Export comments', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 500, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 500, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Create new topic', 'script'),
(NULL, 536, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet', 'script'),
(NULL, 536, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Enter topic name and URL for the web page where the comment box will be placed.', 'script'),
(NULL, 537, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'script'),
(NULL, 537, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 538, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet', 'script'),
(NULL, 538, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Below you can see member profiles for all people who posted a comment on your topics.', 'script'),
(NULL, 539, 'pjField', 2, 'title', 'Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem', 'script'),
(NULL, 539, 'pjField', 3, 'title', 'Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 540, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 540, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 541, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 541, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Click here to unsubscribe', 'script'),
(NULL, 542, 'pjField', 2, 'title', 'Click here to unsubscribe', 'script'),
(NULL, 542, 'pjField', 3, 'title', 'Click here to unsubscribe', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Sorry! we could not found out your account.', 'script'),
(NULL, 543, 'pjField', 2, 'title', 'Sorry! we could not found out your account.', 'script'),
(NULL, 543, 'pjField', 3, 'title', 'Sorry! we could not found out your account.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'You have just unsubscribed for your account.', 'script'),
(NULL, 544, 'pjField', 2, 'title', 'You have just unsubscribed for your account.', 'script'),
(NULL, 544, 'pjField', 3, 'title', 'You have just unsubscribed for your account.', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Your comment was posted. Please, check your email account to confirm your registration.', 'script'),
(NULL, 545, 'pjField', 2, 'title', 'Your comment was posted. Please, check your email account to confirm your registration.', 'script'),
(NULL, 545, 'pjField', 3, 'title', 'Your comment was posted. Please, check your email account to confirm your registration.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Your comment was posted but needs to be approved by administrator first.', 'script'),
(NULL, 546, 'pjField', 2, 'title', 'Your comment was posted but needs to be approved by administrator first.', 'script'),
(NULL, 546, 'pjField', 3, 'title', 'Your comment was posted but needs to be approved by administrator first.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Your account was already activated.', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'Your account was already activated.', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'Your account was already activated.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 548, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 548, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'The topic no longer exists', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'The topic no longer exists', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'The topic no longer exists', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'The topic is no longer active', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'The topic is no longer active', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'The topic is no longer active', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'We are sorry! Your account has been deleted.', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'We are sorry! Your account has been deleted.', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'We are sorry! Your account has been deleted.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'We are sorry! Your account has been de-activated.', 'script'),
(NULL, 552, 'pjField', 2, 'title', 'We are sorry! Your account has been de-activated.', 'script');
INSERT INTO `postcomment_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 552, 'pjField', 3, 'title', 'We are sorry! Your account has been de-activated.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Resend activation URL', 'script'),
(NULL, 553, 'pjField', 2, 'title', 'Resend activation URL', 'script'),
(NULL, 553, 'pjField', 3, 'title', 'Resend activation URL', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'The link you requested was expired, please go to the registration page and get the activation URL again.', 'script'),
(NULL, 554, 'pjField', 2, 'title', 'The link you requested was expired, please go to the registration page and get the activation URL again.', 'script'),
(NULL, 554, 'pjField', 3, 'title', 'The link you requested was expired, please go to the registration page and get the activation URL again.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Resend activation URL', 'script'),
(NULL, 555, 'pjField', 2, 'title', 'Resend activation URL', 'script'),
(NULL, 555, 'pjField', 3, 'title', 'Resend activation URL', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. ', 'script'),
(NULL, 556, 'pjField', 2, 'title', 'In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. ', 'script'),
(NULL, 556, 'pjField', 3, 'title', 'In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. ', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'The activation URL has just been sent to your email address.', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'The activation URL has just been sent to your email address.', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'The activation URL has just been sent to your email address.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Your account is still not activated.', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'Your account is still not activated.', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'Your account is still not activated.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Your email was not found.', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'Your email was not found.', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'Your email was not found.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'File with extension is not allowed to upload', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'File with extension is not allowed to upload', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Verification is not correct.', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Verification is not correct.', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Verification is not correct.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Verification is not correct.', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'Verification is not correct.', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'Verification is not correct.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Password is missing.', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Password is missing.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'Password cannot be empty.', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'Password cannot be empty.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'Password is missing.', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'Password is missing.', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'Name is missing.', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'Name is missing.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Verification code is missing.', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'Verification code is missing.', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'Verification code is missing.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'Name cannot be empty.', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'Name cannot be empty.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 580, 'pjField', 2, 'title', 'Password cannot be empty.', 'script'),
(NULL, 580, 'pjField', 3, 'title', 'Password cannot be empty.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Verification code cannot be empty.', 'script'),
(NULL, 581, 'pjField', 2, 'title', 'Verification code  cannot be empty.', 'script'),
(NULL, 581, 'pjField', 3, 'title', 'Verification code  be empty.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 582, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 582, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 583, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 583, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Comment text is missing.', 'script'),
(NULL, 584, 'pjField', 2, 'title', 'Comment text is missing.', 'script'),
(NULL, 584, 'pjField', 3, 'title', 'Comment text is missing.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 585, 'pjField', 2, 'title', 'Name is missing.', 'script'),
(NULL, 585, 'pjField', 3, 'title', 'Name is missing.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Verification code is missing.', 'script'),
(NULL, 586, 'pjField', 2, 'title', 'Verification code is missing.', 'script'),
(NULL, 586, 'pjField', 3, 'title', 'Verification code is missing.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 587, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 587, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 588, 'pjField', 2, 'title', 'Name cannot be empty.', 'script'),
(NULL, 588, 'pjField', 3, 'title', 'Name cannot be empty.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Comment text cannot be empty.', 'script'),
(NULL, 589, 'pjField', 2, 'title', 'Comment text cannot be empty.', 'script'),
(NULL, 589, 'pjField', 3, 'title', 'Comment text cannot be empty.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Verification code cannot be empty.', 'script'),
(NULL, 590, 'pjField', 2, 'title', 'Verification code cannot be empty.', 'script'),
(NULL, 590, 'pjField', 3, 'title', 'Verification code cannot be empty.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 591, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 591, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'File is not allowed to upload.', 'script'),
(NULL, 592, 'pjField', 2, 'title', 'File is not allowed to upload.', 'script'),
(NULL, 592, 'pjField', 3, 'title', 'File is not allowed to upload.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 593, 'pjField', 2, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 593, 'pjField', 3, 'title', 'File with extension is not allowed to upload.', 'script');

INSERT INTO `postcomment_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 4, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 5, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 7, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_layout', 1, 'layout_1|layout_2|layout_3|layout_4::layout_1', 'Layout 1|Layout 2|Layout 3|Layout 4', 'enum', 9, 1, NULL),
(1, 'o_comment_order', 1, 'new_on_top|new_at_bottom::new_on_top', 'New on top|New at bottom', 'enum', 10, 1, NULL),
(1, 'o_items_per_page', 1, '5', NULL, 'int', 11, 1, NULL),
(1, 'o_allow_comment_rating', 2, 'Yes|No::Yes', NULL, 'enum', 1, 1, NULL),
(1, 'o_allow_comment_reporting', 2, 'Yes|No::Yes', NULL, 'enum', 2, 1, NULL),
(1, 'o_allow_topic_rating', 2, 'Yes|No::Yes', NULL, 'enum', 3, 1, NULL),
(1, 'o_allow_file_uploading', 2, 'Yes|No::Yes', NULL, 'enum', 4, 1, NULL),
(1, 'o_file_allowed', 2, 'pdf|doc|docx|xls|csv|txt|rtf|zip|mp3|wma|mpg|flv|avi|jpg|jpeg|png|gif', NULL, 'text', 5, 1, NULL),
(1, 'o_allow_topic_subscribing', 2, 'Yes|No::Yes', NULL, 'enum', 6, 1, NULL),
(1, 'o_new_member_activation', 2, 'email|manual|confirmed::email', 'Email confirmation|Manual confirmation|Confirmed', 'enum', 7, 1, NULL),
(1, 'o_email_new_member_subject', 3, 'New member has been registered', NULL, 'string', 1, 1, NULL),
(1, 'o_email_new_member', 3, 'New member has been registered.', NULL, 'text', 2, 1, NULL),
(1, 'o_email_member_confirmation_subject', 3, 'New member confirmation', NULL, 'string', 3, 1, NULL),
(1, 'o_email_member_confirmation', 3, 'The new member has been activated.', NULL, 'text', 4, 1, NULL),
(1, 'o_email_new_comment_subject', 3, 'New comment has been posted', NULL, 'string', 5, 1, NULL),
(1, 'o_email_new_comment', 3, 'New comment has been posted.', NULL, 'text', 6, 1, NULL),
(1, 'o_email_report_subject', 3, 'A comment has been reported', NULL, 'string', 7, 1, NULL),
(1, 'o_email_report', 3, 'A comment has been reported.', NULL, 'text', 8, 1, NULL),
(1, 'o_email_new_reply_subject', 3, 'New reply posted', NULL, 'string', 9, 1, NULL),
(1, 'o_email_new_reply', 3, 'New reply posted.', NULL, 'text', 10, 1, NULL),
(1, 'o_email_password_reminder_subject', 3, 'Password reminder.', NULL, 'string', 11, 1, NULL),
(1, 'o_email_password_reminder', 3, 'Dear {Name},\r\n\r\nYour password: {Password}\r\n\r\nThanks!', NULL, 'text', 12, 1, NULL),
(1, 'o_resend_activation_url_subject', 3, 'Resend activation URL', NULL, 'string', 11, 1, NULL),
(1, 'o_resend_activation_url', 3, 'Resend activation URL', NULL, 'text', 12, 1, NULL),
(1, 'o_sms_new_member_registration', 4, 'New member has been registered.', NULL, 'text', 1, 1, NULL),
(1, 'o_sms_new_comment', 4, 'New comment has been posted.', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_comment_reported', 4, 'A comment has been reported.', NULL, 'text', 3, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 0, NULL);

INSERT INTO `postcomment_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

COMMIT;