(function (window, undefined){
	"use strict";
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined);
	
	function PostComment(opts) {
		if (!(this instanceof PostComment)) {
			return new PostComment(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	PostComment.prototype = {
		reset: function () {
			this.opts = null;
			this.$container = null;
			this.container = null;
			this.flag_vote = 0;
			this.comment_id = null;		
			return this;
		},
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeAttr("disabled");
		},
		init: function (opts) {
			var self = this;
			
			this.opts = opts;
			this.container = document.getElementById("pjWrapperPostComment_" + self.opts.topic_id);
			this.$container = pjQ.$(this.container);
			
			this.$container.on('click.pc', '.pc-star', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var star = parseInt(pjQ.$(this).attr('lang'), 10);
				pjQ.$('#rating_value').val(star);
			}).on('mouseover.pc', '.pc-star', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var star = parseInt(pjQ.$(this).attr('lang'), 10);
				self.bindStartHover.call(self, star);
			}).on('mouseout.pc', '.pc-star', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var rating_value = parseInt(pjQ.$('#rating_value').val(), 10);
				self.bindStartHover.call(self, rating_value);
			}).on('click.pc', '.pc-vote', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(self.flag_vote == 0)
				{
					self.flag_vote = 1;
					var params = {};
					params.id = pjQ.$(this).attr('rev');
					params.value = pjQ.$(this).attr('rel');
					pjQ.$('.pc-vote').attr("disabled", "disabled");
					pjQ.$.get([self.opts.folder, "index.php?controller=pjLoad&action=pjActionVote"].join(""), params).done(function (data) {
						self.flag_vote = 0;
						pjQ.$("#pc_vote_up_" + params.id).html('+' + data.likes);
						pjQ.$("#pc_vote_down_" + params.id).html('-' + data.dislikes);
						pjQ.$('.pc-vote').removeAttr("disabled");
					}).fail(function () {
						pjQ.$('.pc-vote').removeAttr("disabled");
					});
				}
			}).on('click.pc', '.pjPcRemoveAvatar', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var id = pjQ.$(this).attr('data-id');
				var params = {};
				params.id = id;
				pjQ.$.get([self.opts.folder, "index.php?controller=pjLoad&action=pjActionRemoveAvatar"].join(""), params).done(function (data) {
					pjQ.$('#pc_avatar_container').remove();
				}).fail(function () {
					
				});
			}).on('click.pc', '.pc-report', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.comment_id = pjQ.$(this).attr('rev');
				pjQ.$('#pjPcReportModal').modal('show');
			}).on('click.pc', '.pjPcCancelReport', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				pjQ.$('#pjPcReportModal').modal('hide');
			}).on('click.pc', '.pjPcSubmitReport', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(self.comment_id != null)
				{
					pjQ.$.get([self.opts.folder, "index.php?controller=pjLoad&action=pjActionSubmitReport", "&id=", self.comment_id].join("")).done(function (data) {
						pjQ.$('#pjPcReportModal').modal('hide');
					}).fail(function () {
						
					});
				}
			}).on('click.pc', '#pjPcCaptchaImage', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $captcha = pjQ.$(this);
				$captcha.attr("src", $captcha.attr("src").replace(/(&rand=)\d+/g, '\$1' + Math.ceil(Math.random() * 99999)));
				pjQ.$('#pjPcCaptchaField').val("").removeData("previousValue");
			});
			
			if(pjQ.$('#pjCpComment_' + self.opts.topic_id).length > 0)
			{
				pjQ.$('.modal-dialog').css("z-index", "9999");
			}
			
			self.bindCommentForm.call(self);
			self.bindLoginForm.call(self);
			self.bindForgotForm.call(self);
			self.bindRegisterForm.call(self);
			self.bindProfileForm.call(self);
			self.bindResendForm.call(self);
		},
		bindStartHover: function(rating_value){
			var self = this;
			pjQ.$('.pc-star').each(function(e){
				var star = parseInt(pjQ.$(this).attr('lang'), 10);
				if(star <= rating_value)
				{
					pjQ.$(this).find("span").removeClass('glyphicon-star-empty').addClass('glyphicon-star');
				}else{
					pjQ.$(this).find("span").removeClass('glyphicon-star').addClass('glyphicon-star-empty');
				}
			});
		},
		bindCommentForm: function(){
			var self = this;
			var $frmComment = pjQ.$('#frmPostComment_' + self.opts.topic_id);
			if($frmComment.length > 0)
			{
				if(pjQ.$('#rating_value').length > 0)
				{
					var rating_value = parseInt(pjQ.$('#rating_value').val(), 10);
					self.bindStartHover.call(self, rating_value);
				}
				if($frmComment.length > 0 && validate)
				{
					pjQ.$.validator.addMethod('checkwords', function(value, element) {
						var banned_word_str = self.opts.banned_words;
						if(banned_word_str != ""){
					    	banned_word_str = banned_word_str.replace(/\s+/g, '');
					    	banned_word_str = banned_word_str.replace(new RegExp(",","g"),"|");
					    	return !new RegExp(banned_word_str).test(value);
				    	}else{
				    		return true;
				    	}
					});
					pjQ.$.validator.addMethod('checkext', function(value, element) {
						if(value == '')
						{
							return true;
						}
						var allowed_ext = self.opts.allowed_ext.split("|");
						var dot_pos = value.lastIndexOf(".");
						var ext = "";
						if(dot_pos != -1){
							ext = value.substr(dot_pos+1).toLowerCase();
						}
						if(allowed_ext.indexOf(ext) == -1){
							return false;
						}
						return true;
					});
					$frmComment.validate({
						rules: {
							"verification": {
								remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha"
							}
						},
						onkeyup: false,
						errorElement: 'li',
						errorPlacement: function (error, element) {
							error.appendTo(element.next().find('ul'));
						},
						highlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-success').addClass('has-error');
			            },
			            unhighlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-error').addClass('has-success');
			            }
					});
				}
			}
		},
		bindLoginForm: function(){
			var self = this;
			var $frmLogin = pjQ.$('#frmLogin_' + self.opts.topic_id);
			if($frmLogin.length > 0)
			{
				if($frmLogin.length > 0 && validate)
				{
					$frmLogin.validate({
						onkeyup: false,
						errorElement: 'li',
						errorPlacement: function (error, element) {
							error.appendTo(element.next().find('ul'));
						},
						highlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-success').addClass('has-error');
			            },
			            unhighlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-error').addClass('has-success');
			            }
					});
				}
			}
		},
		bindForgotForm: function(){
			var self = this;
			var $frmForgot = pjQ.$('#frmForgot_' + self.opts.topic_id);
			if($frmForgot.length > 0)
			{
				if($frmForgot.length > 0 && validate)
				{
					$frmForgot.validate({
						onkeyup: false,
						errorElement: 'li',
						errorPlacement: function (error, element) {
							error.appendTo(element.next().find('ul'));
						},
						highlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-success').addClass('has-error');
			            },
			            unhighlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-error').addClass('has-success');
			            }
					});
				}
			}
		},
		bindRegisterForm: function(){
			var self = this;
			var $frmRegister = pjQ.$('#frmRegister_' + self.opts.topic_id);
			if($frmRegister.length > 0)
			{
				if($frmRegister.length > 0 && validate)
				{
					$frmRegister.validate({
						rules: {
							"verification": {
								remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha"
							},
							"email": {
								remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckEmail"
							}
						},
						onkeyup: false,
						errorElement: 'li',
						errorPlacement: function (error, element) {
							error.appendTo(element.next().find('ul'));
						},
						highlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-success').addClass('has-error');
			            },
			            unhighlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-error').addClass('has-success');
			            }
					});
				}
			}
		},
		bindProfileForm: function(){
			var self = this;
			var $frmProfile = pjQ.$('#frmMyProfile_' + self.opts.topic_id);
			if($frmProfile.length > 0)
			{
				if($frmProfile.length > 0 && validate)
				{
					pjQ.$.validator.addMethod('checkext', function(value, element) {
						if(value == '')
						{
							return true;
						}
						var image_ext = "jpg|jpeg|png|gif";
						var allowed_ext = image_ext.split("|");
						var dot_pos = value.lastIndexOf(".");
						var ext = "";
						if(dot_pos != -1){
							ext = value.substr(dot_pos+1).toLowerCase();
						}
						if(allowed_ext.indexOf(ext) == -1){
							return false;
						}
						return true;
					});
					$frmProfile.validate({
						rules: {
							"email": {
								remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckEmail&id=" + $frmProfile.find('input[name="id"]').val()
							}
						},
						onkeyup: false,
						errorElement: 'li',
						errorPlacement: function (error, element) {
							error.appendTo(element.next().find('ul'));
						},
						highlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-success').addClass('has-error');
			            },
			            unhighlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-error').addClass('has-success');
			            }
					});
				}
			}
		},
		bindResendForm: function(){
			var self = this;
			var $frmResend = pjQ.$('#frmResend_' + self.opts.topic_id);
			if($frmResend.length > 0)
			{
				if($frmResend.length > 0 && validate)
				{
					$frmResend.validate({
						onkeyup: false,
						errorElement: 'li',
						errorPlacement: function (error, element) {
							error.appendTo(element.next().find('ul'));
						},
						highlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-success').addClass('has-error');
			            },
			            unhighlight: function(ele, errorClass, validClass) {
			            	var $element = pjQ.$(ele);
			            	$element.parent().parent().removeClass('has-error').addClass('has-success');
			            }
					});
				}
			}
		}
	};
	
	window.PostComment = PostComment;
})(window);