DROP TABLE IF EXISTS `stivablog_categories`;
CREATE TABLE IF NOT EXISTS `stivablog_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(250) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_posts`;
CREATE TABLE IF NOT EXISTS `stivablog_posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `author_id` int(11) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `body` text DEFAULT NULL,
  `source_path` varchar(255) DEFAULT NULL,
  `medium_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_name` varchar(255) DEFAULT NULL,
  `meta_title` VARCHAR(255) DEFAULT NULL,
  `meta_keywords` VARCHAR(255) DEFAULT NULL,
  `meta_description` VARCHAR(255) DEFAULT NULL,
  `published_date` date DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_comments`;
CREATE TABLE IF NOT EXISTS `stivablog_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','W','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_votes`;
CREATE TABLE IF NOT EXISTS `stivablog_votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `vote_rate` decimal(5,2) DEFAULT NULL,
  `vote_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_fields`;
CREATE TABLE IF NOT EXISTS `stivablog_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_multi_lang`;
CREATE TABLE IF NOT EXISTS `stivablog_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_options`;
CREATE TABLE IF NOT EXISTS `stivablog_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_roles`;
CREATE TABLE IF NOT EXISTS `stivablog_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivablog_users`;
CREATE TABLE IF NOT EXISTS `stivablog_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `stivablog_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddAuthor', 'backend', 'Add author', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateAuthor', 'backend', 'Update author', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuAuthors', 'backend', 'Menu Authors', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(279, 'opt_o_email_address', 'backend', 'Options / Administrator email', 'script', NULL),
(280, 'opt_o_author_name', 'backend', 'Options / Author name', 'script', NULL),
(281, 'opt_o_posts_per_page', 'backend', 'Options / Number of posts per page', 'script', NULL),
(282, 'opt_o_show_fullly_post', 'backend', 'Options / Show full post', 'script', NULL),
(283, 'opt_o_post_order', 'backend', 'Options / Post order', 'script', NULL),
(284, 'opt_o_allow_posting_comment', 'backend', 'Options / Allow comments posting', 'script', NULL),
(285, 'opt_o_comment_approval', 'backend', 'Options / Comment approval', 'script', NULL),
(286, 'opt_o_comment_order', 'backend', 'Options / Comment order', 'script', NULL),
(287, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(288, 'opt_o_show_category', 'backend', 'Options / Show categories', 'script', NULL),
(289, 'opt_o_show_archive', 'backend', 'Options / Show archive', 'script', NULL),
(290, 'opt_o_show_rating', 'backend', 'Options / Show rating', 'script', NULL),
(291, 'opt_o_limit_vote', 'backend', 'Options / Limit vote', 'script', NULL),
(292, 'opt_o_send_to_friend', 'backend', 'Options / Send to friend', 'script', NULL),
(293, 'opt_o_banned_words', 'backend', 'Options / Banned words', 'script', NULL),
(294, 'menuAddOns', 'backend', 'Menu / Add-ons', 'script', NULL),
(295, 'menuProtection', 'backend', 'Menu / Protection', 'script', NULL),
(296, 'menuCategories', 'backend', 'Label / Categories', 'script', NULL),
(297, 'infoProtectionTitle', 'backend', 'Infobox / Protection title', 'script', NULL),
(298, 'infoProtectionBody', 'backend', 'Infobox / Protection body', 'script', NULL),
(299, 'option_tips_ARRAY_o_email_address', 'arrays', 'option_tips_ARRAY_o_email_address', 'script', NULL),
(300, 'option_tips_ARRAY_o_author_name', 'arrays', 'option_tips_ARRAY_o_author_name', 'script', NULL),
(301, 'option_tips_ARRAY_o_show_fullly_post', 'arrays', 'option_tips_ARRAY_o_show_fullly_post', 'script', NULL),
(302, 'option_tips_ARRAY_o_post_order', 'arrays', 'option_tips_ARRAY_o_post_order', 'script', NULL),
(303, 'option_tips_ARRAY_o_allow_posting_comment', 'arrays', 'option_tips_ARRAY_o_allow_posting_comment', 'script', NULL),
(304, 'option_tips_ARRAY_o_comment_approval', 'arrays', 'option_tips_ARRAY_o_comment_approval', 'script', NULL),
(305, 'option_tips_ARRAY_o_comment_order', 'arrays', 'option_tips_ARRAY_o_comment_order', 'script', NULL),
(306, 'option_tips_ARRAY_o_show_category', 'arrays', 'option_tips_ARRAY_o_show_category', 'script', NULL),
(307, 'option_tips_ARRAY_o_show_archive', 'arrays', 'option_tips_ARRAY_o_show_archive', 'script', NULL),
(308, 'option_tips_ARRAY_o_show_rating', 'arrays', 'option_tips_ARRAY_o_show_rating', 'script', NULL),
(309, 'option_tips_ARRAY_o_limit_vote', 'arrays', 'option_tips_ARRAY_o_limit_vote', 'script', NULL),
(310, 'option_tips_ARRAY_o_send_to_friend', 'arrays', 'option_tips_ARRAY_o_send_to_friend', 'script', NULL),
(311, 'infoAddOnsTitle', 'backend', 'Infobox / Add-ons titles', 'script', NULL),
(312, 'infoAddOnsBody', 'backend', 'Infobox / Add-ons body', 'script', NULL),
(313, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(314, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(315, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(316, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(317, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(318, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(319, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(320, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(321, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(322, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(323, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(324, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(325, 'delete_selected', 'backend', 'label / Delete selected', 'script', NULL),
(326, 'delete_confirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(327, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(328, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(329, 'lblInActive', 'backend', 'Label / Inactive', 'script', NULL),
(330, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(331, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(332, 'lblSameCategory', 'backend', 'Label / same category', 'script', NULL),
(333, 'menuPosts', 'backend', 'Menu / Posts', 'script', NULL),
(334, 'menuComments', 'backend', 'Menu / Comments', 'script', NULL),
(360, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(361, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(362, 'error_titles_ARRAY_AP03', 'arrays', 'error_titles_ARRAY_AP03', 'script', NULL),
(363, 'error_bodies_ARRAY_AP03', 'arrays', 'error_bodies_ARRAY_AP03', 'script', NULL),
(364, 'error_titles_ARRAY_AP04', 'arrays', 'error_titles_ARRAY_AP04', 'script', NULL),
(365, 'error_bodies_ARRAY_AP04', 'arrays', 'error_bodies_ARRAY_AP04', 'script', NULL),
(366, 'error_titles_ARRAY_AP08', 'arrays', 'error_titles_ARRAY_AP08', 'script', NULL),
(367, 'error_bodies_ARRAY_AP08', 'arrays', 'error_bodies_ARRAY_AP08', 'script', NULL),
(368, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(369, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(370, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(371, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(372, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(373, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(374, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(375, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(376, 'lblDatePublished', 'backend', 'Label / Date published', 'script', NULL),
(377, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(378, 'lblComments', 'backend', 'Label / Comments', 'script', NULL),
(379, 'lblAddPost', 'backend', 'Label / Add post', 'script', NULL),
(380, 'lblAuthor', 'backend', 'Label / Author', 'script', NULL),
(381, 'lblBody', 'backend', 'Label / Body', 'script', NULL),
(382, 'lblAddCategory', 'backend', 'Label / Add category', 'script', NULL),
(383, 'lblUpdatePost', 'backend', 'Label / Update post', 'script', NULL),
(384, 'comment_statarr_ARRAY_T', 'arrays', 'comment_statarr_ARRAY_T', 'script', NULL),
(385, 'comment_statarr_ARRAY_F', 'arrays', 'comment_statarr_ARRAY_F', 'script', NULL),
(387, 'lblUnderPost', 'backend', 'Label / Under post', 'script', NULL),
(388, 'lblInvalidEmail', 'backend', 'Label / Email is not valid.', 'script', NULL),
(389, 'lblUpdateComment', 'backend', 'Label / Update comment', 'script', NULL),
(390, 'lblDateTimePosted', 'backend', 'Label / Date time posted', 'script', NULL),
(391, 'lblComment', 'backend', 'Label / Comment', 'script', NULL),
(392, 'lblOf', 'backend', 'Label / of', 'script', NULL),
(393, 'lblVotes', 'backend', 'Label / votes', 'script', NULL),
(394, 'lblReset', 'backend', 'Label / Reset', 'script', NULL),
(395, 'lblResetVotes', 'backend', 'Label / Reset votes', 'script', NULL),
(396, 'lblResetConfirmation', 'backend', 'Label / Reset confirmation', 'script', NULL),
(397, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(423, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(424, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(425, 'lblDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(426, 'lblPosts', 'backend', 'Label / Posts', 'script', NULL),
(427, 'lblPost', 'backend', 'Label / Post', 'script', NULL),
(429, 'lblAuthors', 'backend', 'Lable / Authors', 'script', NULL),
(430, 'lblLatestPosts', 'backend', 'Label / Latest posts', 'script', NULL),
(431, 'lblLatestComments', 'backend', 'Label / Latest comments', 'script', NULL),
(432, 'lblLastLoggedAuthors', 'backend', 'Label / Last login authors', 'script', NULL),
(433, 'lblPostNotFound', 'backend', 'Label / Post not found', 'script', NULL),
(434, 'lblCommentNotFound', 'backend', 'Label / Comment not found', 'script', NULL),
(435, 'lblAuthorNotFound', 'backend', 'Label / Author not found', 'script', NULL),
(461, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(462, 'lblInstallPhp1Title', 'backend', 'Label / Install text', 'script', NULL),
(463, 'lblInstallPhp1_1', 'backend', 'Install / Step 1', 'script', NULL),
(464, 'lblInstallPhp1_2', 'backend', 'Install / Step 2', 'script', NULL),
(465, 'lblInstallPhp1_3', 'backend', 'Label / Step 3', 'script', NULL),
(466, 'post_messages_ARRAY_9999', 'arrays', 'post_messages_ARRAY_9999', 'script', NULL),
(467, 'post_messages_ARRAY_9998', 'arrays', 'post_messages_ARRAY_9998', 'script', NULL),
(468, 'post_messages_ARRAY_9901', 'arrays', 'post_messages_ARRAY_9901', 'script', NULL),
(469, 'post_messages_ARRAY_9902', 'arrays', 'post_messages_ARRAY_9902', 'script', NULL),
(470, 'post_messages_ARRAY_9903', 'arrays', 'post_messages_ARRAY_9903', 'script', NULL),
(471, 'post_messages_ARRAY_9904', 'arrays', 'post_messages_ARRAY_9904', 'script', NULL),
(472, 'post_messages_ARRAY_9905', 'arrays', 'post_messages_ARRAY_9905', 'script', NULL),
(473, 'post_messages_ARRAY_9906', 'arrays', 'post_messages_ARRAY_9906', 'script', NULL),
(474, 'post_messages_ARRAY_9907', 'arrays', 'post_messages_ARRAY_9907', 'script', NULL),
(475, 'post_messages_ARRAY_9908', 'arrays', 'post_messages_ARRAY_9908', 'script', NULL),
(476, 'post_messages_ARRAY_9909', 'arrays', 'post_messages_ARRAY_9909', 'script', NULL),
(477, 'post_messages_ARRAY_9910', 'arrays', 'post_messages_ARRAY_9910', 'script', NULL),
(478, 'post_messages_ARRAY_9911', 'arrays', 'post_messages_ARRAY_9911', 'script', NULL),
(479, 'label_email_subject', 'frontend', 'Label / Email subject', 'script', NULL),
(480, 'label_new_comment', 'frontend', 'Label / There is new comment.', 'script', NULL),
(481, 'label_post', 'frontend', 'Label / Post', 'script', NULL),
(482, 'label_name', 'frontend', 'Label / Name', 'script', NULL),
(483, 'label_email', 'frontend', 'Label / Email', 'script', NULL),
(484, 'label_comment', 'frontend', 'Label / Comment', 'script', NULL),
(510, 'label_related', 'frontend', 'Label / Related', 'script', NULL),
(511, 'label_already_voted', 'frontend', 'Label / Already voted', 'script', NULL),
(512, 'label_thank_vote', 'frontend', 'Label / Thank for voting', 'script', NULL),
(513, 'label_of', 'frontend', 'Label / Of', 'script', NULL),
(514, 'label_votes', 'frontend', 'Label / votes', 'script', NULL),
(515, 'label_continue_reading', 'frontend', 'Label / Continue Reading', 'script', NULL),
(516, 'label_load_more', 'frontend', 'Label / Load More', 'script', NULL),
(517, 'label_send_to_friend', 'frontend', 'Label / Send to Friend', 'script', NULL),
(518, 'button_send', 'frontend', 'Button / Send', 'script', NULL),
(519, 'button_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(520, 'label_comments', 'frontend', 'Label / Comments', 'script', NULL),
(521, 'label_comment_not_found', 'frontend', 'Label / Comment not found', 'script', NULL),
(522, 'button_post_comment', 'frontend', 'Button / Post A Comment', 'script', NULL),
(523, 'label_required_field', 'frontend', 'Label / required field', 'script', NULL),
(524, 'label_invalid_email', 'frontend', 'Label / email invalid', 'script', NULL),
(525, 'label_captcha_incorrect', 'frontend', 'Label / Captcha is incorrect', 'script', NULL),
(526, 'label_banned_msg', 'frontend', 'Label / Banned word message', 'script', NULL),
(527, 'label_send_msg', 'frontend', 'Label / Send message', 'script', NULL),
(528, 'label_send_ok', 'frontend', 'Label / Message sent', 'script', NULL),
(529, 'label_home', 'frontend', 'Label / Home', 'script', NULL),
(530, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(531, 'label_by', 'frontend', 'Label / by', 'script', NULL),
(532, 'label_next', 'frontend', 'Label / next', 'script', NULL),
(533, 'label_prev', 'frontend', 'Label / prev', 'script', NULL),
(534, 'label_back', 'frontend', 'Label / Back', 'script', NULL),
(535, 'label_in', 'frontend', 'Label / in', 'script', NULL),
(537, 'label_subject', 'frontend', 'Label / Subject', 'script', NULL),
(563, 'opt_o_reject_links', 'backend', 'Options / Reject links', 'script', NULL),
(564, 'option_tips_ARRAY_o_reject_links', 'arrays', 'option_tips_ARRAY_o_reject_links', 'script', NULL),
(565, 'opt_o_blog_page', 'backend', 'Options / Blog web page', 'script', NULL),
(566, 'lblInstallOptional', 'backend', 'Label / Optional', 'script', NULL),
(567, 'lblInstallPhp2Title', 'backend', 'Install / Optional step', 'script', NULL),
(568, 'lblInstallPhp1_4', 'backend', 'Label / Options step1', 'script', NULL),
(569, 'lblInstallPhp1_5', 'backend', 'Label / Optional step2', 'script', NULL),
(570, 'opt_o_seo_url', 'backend', 'Options / Seo url', 'script', NULL),
(571, 'infoCategoriesTitle', 'backend', 'Infobox / Categories title', 'script', NULL),
(572, 'infoCategoriesBody', 'backend', 'Infobox / Categories body', 'script', NULL),
(573, 'infoAuthorsTitle', 'backend', 'Infobox / Authors title', 'script', NULL),
(574, 'infoAuthorsBody', 'backend', 'Infobox / Author list body', 'script', NULL),
(575, 'infoAddAuthorTitle', 'backend', 'Infobox / Add author title', 'script', NULL),
(576, 'infoAddAuthorBody', 'backend', 'Infobox / Add author body', 'script', NULL),
(577, 'infoEditAuthorTitle', 'backend', 'Infobox / Edit author title', 'script', NULL),
(578, 'infoEditAuthorBody', 'backend', 'Infobox / Edit author body', 'script', NULL),
(579, 'infoCommentsTitle', 'backend', 'Infobox / Comments title', 'script', NULL),
(580, 'infoCommentsBody', 'backend', 'Infobox / Comments body', 'script', NULL),
(581, 'infoUpdateCommentTitle', 'backend', 'Infobox / Update comment title', 'script', NULL),
(582, 'infoUpdateCommentBody', 'backend', 'Infobox / Update comment body', 'script', NULL),
(583, 'infoPostsTitle', 'backend', 'Infobox / Post title', 'script', NULL),
(584, 'infoPostsBody', 'backend', 'Infobox / Post body', 'script', NULL),
(585, 'infoAddPostTitle', 'backend', 'Infobox / Add post title', 'script', NULL),
(586, 'infoAddPostBody', 'backend', 'Infobox / Add post body', 'script', NULL),
(587, 'infoUpdatePostTitle', 'backend', 'Infobox / Update post title', 'script', NULL),
(588, 'infoUpdatePostBody', 'backend', 'Infobox / Update post body', 'script', NULL),
(589, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(590, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(591, 'label_reject_msg', 'frontend', 'Label / Data blocked', 'script', NULL),
(592, 'post_messages_ARRAY_9912', 'arrays', 'post_messages_ARRAY_9912', 'script', NULL),
(593, 'post_messages_ARRAY_9913', 'arrays', 'post_messages_ARRAY_9913', 'script', NULL),
(594, 'label_back_to_top', 'frontend', 'Label / Back to top', 'script', NULL),
(595, 'label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(596, 'lblHostInvalid', 'backend', 'Label / SMTP Host is not valid.', 'script', NULL),
(597, 'label_post_not_found', 'frontend', 'Label / Post not found', 'script', NULL),
(598, 'label_no_post', 'frontend', 'Label / No posts found', 'script', NULL),
(599, 'error_titles_ARRAY_AP05', 'arrays', 'error_titles_ARRAY_AP05', 'script', NULL),
(600, 'error_bodies_ARRAY_AP05', 'arrays', 'error_bodies_ARRAY_AP05', 'script', NULL),
(601, 'error_titles_ARRAY_AP06', 'arrays', 'error_titles_ARRAY_AP06', 'script', NULL),
(602, 'error_bodies_ARRAY_AP06', 'arrays', 'error_bodies_ARRAY_AP06', 'script', NULL),
(603, 'error_titles_ARRAY_AP09', 'arrays', 'error_titles_ARRAY_AP09', 'script', NULL),
(604, 'error_bodies_ARRAY_AP09', 'arrays', 'error_bodies_ARRAY_AP09', 'script', NULL),
(605, 'error_titles_ARRAY_AP10', 'arrays', 'error_titles_ARRAY_AP10', 'script', NULL),
(606, 'error_bodies_ARRAY_AP10', 'arrays', 'error_bodies_ARRAY_AP10', 'script', NULL),
(607, 'opt_o_related_posts_shown', 'backend', 'Options / Number of related posts shown', 'script', NULL),
(608, 'lblSeo', 'backend', 'Label / SEO', 'script', NULL),
(609, 'infoUpdateSEOTitle', 'backend', 'Infobox / SEO settings', 'script', NULL),
(610, 'infoUpdateSEOBody', 'backend', 'Infobox / SEO settings', 'script', NULL),
(611, 'lblMetaTitle', 'backend', 'Label / Meta title', 'script', NULL),
(612, 'lblMetaKeywords', 'backend', 'Label / Meta keywords', 'script', NULL),
(613, 'lblMetaDescription', 'backend', 'Label / Meta description', 'script', NULL),
(614, 'lblInstallPhp1_2a', 'backend', 'Install / Step 2a (Optional)', 'script', NULL),
(615, 'comment_statarr_ARRAY_W', 'arrays', 'comment_statarr_ARRAY_W', 'script', NULL);

INSERT INTO `stivablog_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add author', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add author', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add author', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update author', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update author', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update author', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Authors', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Authors', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Authors', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this author have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this author have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this author have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this author have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this author have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this author have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the author has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the author has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the author has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Author your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'Author your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'Author your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Author updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'Author updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'Author updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Author added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'Author added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'Author added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Author failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'Author failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'Author failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Author not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'Author not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'Author not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Administrator email', 'script'),
(NULL, 279, 'pjField', 2, 'title', 'Administrator email', 'script'),
(NULL, 279, 'pjField', 3, 'title', 'Administrator email', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Author name', 'script'),
(NULL, 280, 'pjField', 2, 'title', 'Author name', 'script'),
(NULL, 280, 'pjField', 3, 'title', 'Author name', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Number of posts per page', 'script'),
(NULL, 281, 'pjField', 2, 'title', 'Number of posts per page', 'script'),
(NULL, 281, 'pjField', 3, 'title', 'Number of posts per page', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Show full post', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'Show full post', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'Show full post', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Post order', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'Post order', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'Post order', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Allow comments posting', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'Allow comments posting', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'Allow comments posting', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Comment approval', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'Comment approval', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'Comment approval', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Comment order', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'Comment order', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'Comment order', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Show categories', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'Show categories', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'Show categories', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Show archive', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'Show archive', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'Show archive', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Show rating', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'Show rating', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'Show rating', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Limit vote', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'Limit vote', 'script');
INSERT INTO `stivablog_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 291, 'pjField', 3, 'title', 'Limit vote', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Send to friend', 'script'),
(NULL, 292, 'pjField', 2, 'title', 'Send to friend', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'Send to friend', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Banned words', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'Banned words', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'Banned words', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Add-ons', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'Add-ons', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'Add-ons', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Protection', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'Protection', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'Protection', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Banned words', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Banned words', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Banned words', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'You can make a list of words (separated by commas) and comments containing any of these words will not be allowed.', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'You can make a list of words (separated by commas) and comments containing any of these words will not be allowed.', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'You can make a list of words (separated by commas) and comments containing any of these words will not be allowed.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'This is the email address where confirmation email will be sent when a new comment is posted', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'This is the email address where confirmation email will be sent when a new comment is posted', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'This is the email address where confirmation email will be sent when a new comment is posted', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'This is the name of the author of the blog.', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'This is the name of the author of the blog.', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'This is the name of the author of the blog.', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Select ''Yes'', post body will be fully shown at the home page. Otherwise the post body will be trimmed to 1000 characters', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'Select ''Yes'', post body will be fully shown at the home page. Otherwise the post body will be trimmed to 1000 characters', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'Select ''Yes'', post body will be fully shown at the home page. Otherwise the post body will be trimmed to 1000 characters', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Set the way posts should be ordered.', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'Set the way posts should be ordered.', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'Set the way posts should be ordered.', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Select ''Yes'', allow people to post comments. Otherwise select ''No''.', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'Select ''Yes'', allow people to post comments. Otherwise select ''No''.', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'Select ''Yes'', allow people to post comments. Otherwise select ''No''.', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Select ''Yes'' if you want to approve comments before having them posted on the blog. Otherwise select ''No''.', 'script'),
(NULL, 304, 'pjField', 2, 'title', 'Select ''Yes'' if you want to approve comments before having them posted on the blog. Otherwise select ''No''.', 'script'),
(NULL, 304, 'pjField', 3, 'title', 'Select ''Yes'' if you want to approve comments before having them posted on the blog. Otherwise select ''No''.', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Set the way comments should be ordered', 'script'),
(NULL, 305, 'pjField', 2, 'title', 'Set the way comments should be ordered', 'script'),
(NULL, 305, 'pjField', 3, 'title', 'Set the way comments should be ordered', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Select ''Yes'' if you want to display the categories list on the front end. Otherwise select ''No''', 'script'),
(NULL, 306, 'pjField', 2, 'title', 'Select ''Yes'' if you want to display the categories list on the front end. Otherwise select ''No''', 'script'),
(NULL, 306, 'pjField', 3, 'title', 'Select ''Yes'' if you want to display the categories list on the front end. Otherwise select ''No''', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Select ''Yes'' if you want to show the archive list on the front end. Otherwise select ''No''', 'script'),
(NULL, 307, 'pjField', 2, 'title', 'Select ''Yes'' if you want to show the archive list on the front end. Otherwise select ''No''', 'script'),
(NULL, 307, 'pjField', 3, 'title', 'Select ''Yes'' if you want to show the archive list on the front end. Otherwise select ''No''', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Select ''Yes'' if you want to show the rating box on the front end. Otherwise select ''No''', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Select ''Yes'' if you want to show the rating box on the front end. Otherwise select ''No''', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Select ''Yes'' if you want to show the rating box on the front end. Otherwise select ''No''', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Select ''No'' if you want to allow users to vote as many times as they want.<br/>\r\nSelect ''Cookie'', if you want to allow users to make a vote once every 24 hours for the same post and the cookie will be use to track voting.<br/>\r\nSelect ''IP address'', it has the same meaning as the cookie but in this case the IP address will be use to track voting.', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'Select ''No'' if you want to allow users to vote as many times as they want.<br/>\r\nSelect ''Cookie'', if you want to allow users to make a vote once every 24 hours for the same post and the cookie will be use to track voting.<br/>\r\nSelect ''IP address'', it has the same meaning as the cookie but in this case the IP address will be use to track voting.', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'Select ''No'' if you want to allow users to vote as many times as they want.<br/>\r\nSelect ''Cookie'', if you want to allow users to make a vote once every 24 hours for the same post and the cookie will be use to track voting.<br/>\r\nSelect ''IP address'', it has the same meaning as the cookie but in this case the IP address will be use to track voting.', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Select ''Yes'' if you want to enable "send to friend" feature on the front end. Otherwise select ''No''', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'Select ''Yes'' if you want to enable "send to friend" feature on the front end. Otherwise select ''No''', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'Select ''Yes'' if you want to enable "send to friend" feature on the front end. Otherwise select ''No''', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Add-ons', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'Add-ons', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'Add-ons', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Below are some add-on options that you can set to define how your blogs shown on the front-end.', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'Below are some add-on options that you can set to define how your blogs shown on the front-end.', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'Below are some add-on options that you can set to define how your blogs shown on the front-end.', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Add-ons updated', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'Add-ons updated', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'Add-ons updated', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'All changes made to add-ons have been saved successfully.', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'All changes made to add-ons have been saved successfully.', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'All changes made to add-ons have been saved successfully.', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Banned words updated', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'Banned words updated', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'Banned words updated', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'The banned words have been updated successfully.', 'script'),
(NULL, 316, 'pjField', 2, 'title', 'The banned words have been updated successfully.', 'script'),
(NULL, 316, 'pjField', 3, 'title', 'The banned words have been updated successfully.', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Category updated', 'script'),
(NULL, 317, 'pjField', 2, 'title', 'Category updated', 'script'),
(NULL, 317, 'pjField', 3, 'title', 'Category updated', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 318, 'pjField', 2, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 318, 'pjField', 3, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 319, 'pjField', 2, 'title', 'Category added', 'script'),
(NULL, 319, 'pjField', 3, 'title', 'Category added', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 320, 'pjField', 2, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 320, 'pjField', 3, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Category failed to add', 'script'),
(NULL, 321, 'pjField', 2, 'title', 'Category failed to add', 'script'),
(NULL, 321, 'pjField', 3, 'title', 'Category failed to add', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'We are sorry that the category could not be added.', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'We are sorry that the category could not be added.', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'We are sorry that the category could not be added.', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 323, 'pjField', 2, 'title', 'Category not found', 'script'),
(NULL, 323, 'pjField', 3, 'title', 'Category not found', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'We are sorry that the category you are looking for is missing.', 'script'),
(NULL, 324, 'pjField', 2, 'title', 'We are sorry that the category you are looking for is missing.', 'script'),
(NULL, 324, 'pjField', 3, 'title', 'We are sorry that the category you are looking for is missing.', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 329, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'The category was already in use.', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'The category was already in use.', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'The category was already in use.', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Posts', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'Posts', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'Posts', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Comments', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Comments', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Post updated', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Post updated', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Post updated', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'All changes made to the post have been saved.', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'All changes made to the post have been saved.', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'All changes made to the post have been saved.', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Post added', 'script'),
(NULL, 362, 'pjField', 2, 'title', 'Post added', 'script'),
(NULL, 362, 'pjField', 3, 'title', 'Post added', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'A new post has been added to the list.', 'script'),
(NULL, 363, 'pjField', 2, 'title', 'A new post has been added to the list.', 'script'),
(NULL, 363, 'pjField', 3, 'title', 'A new post has been added to the list.', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Post failed to add', 'script'),
(NULL, 364, 'pjField', 2, 'title', 'Post failed to add', 'script'),
(NULL, 364, 'pjField', 3, 'title', 'Post failed to add', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'We are sorry that new post could not bee added.', 'script'),
(NULL, 365, 'pjField', 2, 'title', 'We are sorry that new post could not bee added.', 'script'),
(NULL, 365, 'pjField', 3, 'title', 'We are sorry that new post could not bee added.', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Post not found', 'script'),
(NULL, 366, 'pjField', 2, 'title', 'Post not found', 'script'),
(NULL, 366, 'pjField', 3, 'title', 'Post not found', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'We are sorry that the post you are looking for is missing.', 'script'),
(NULL, 367, 'pjField', 2, 'title', 'We are sorry that the post you are looking for is missing.', 'script'),
(NULL, 367, 'pjField', 3, 'title', 'We are sorry that the post you are looking for is missing.', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Comment updated', 'script'),
(NULL, 368, 'pjField', 2, 'title', 'Comment updated', 'script'),
(NULL, 368, 'pjField', 3, 'title', 'Comment updated', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'All changes made to the comment have been saved.', 'script'),
(NULL, 369, 'pjField', 2, 'title', 'All changes made to the comment have been saved.', 'script'),
(NULL, 369, 'pjField', 3, 'title', 'All changes made to the comment have been saved.', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Comment added', 'script'),
(NULL, 370, 'pjField', 2, 'title', 'Comment added', 'script'),
(NULL, 370, 'pjField', 3, 'title', 'Comment added', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'A new comment has been added to the list.', 'script'),
(NULL, 371, 'pjField', 2, 'title', 'A new comment has been added to the list.', 'script'),
(NULL, 371, 'pjField', 3, 'title', 'A new comment has been added to the list.', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Comment failed to add', 'script'),
(NULL, 372, 'pjField', 2, 'title', 'Comment failed to add', 'script'),
(NULL, 372, 'pjField', 3, 'title', 'Comment failed to add', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'We are sorry that new comment could not be added.', 'script'),
(NULL, 373, 'pjField', 2, 'title', 'We are sorry that new comment could not be added.', 'script'),
(NULL, 373, 'pjField', 3, 'title', 'We are sorry that new comment could not be added.', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Comment not found', 'script'),
(NULL, 374, 'pjField', 2, 'title', 'Comment not found', 'script'),
(NULL, 374, 'pjField', 3, 'title', 'Comment not found', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'We are sorry that the comment you are looking for is missing.', 'script'),
(NULL, 375, 'pjField', 2, 'title', 'We are sorry that the comment you are looking for is missing.', 'script'),
(NULL, 375, 'pjField', 3, 'title', 'We are sorry that the comment you are looking for is missing.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Date published', 'script'),
(NULL, 376, 'pjField', 2, 'title', 'Date published', 'script'),
(NULL, 376, 'pjField', 3, 'title', 'Date published', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 377, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 377, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 378, 'pjField', 2, 'title', 'Comments', 'script'),
(NULL, 378, 'pjField', 3, 'title', 'Comments', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Add post', 'script'),
(NULL, 379, 'pjField', 2, 'title', 'Add post', 'script'),
(NULL, 379, 'pjField', 3, 'title', 'Add post', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Author', 'script'),
(NULL, 380, 'pjField', 2, 'title', 'Author', 'script'),
(NULL, 380, 'pjField', 3, 'title', 'Author', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Body', 'script'),
(NULL, 381, 'pjField', 2, 'title', 'Body', 'script'),
(NULL, 381, 'pjField', 3, 'title', 'Body', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 382, 'pjField', 2, 'title', 'Add category', 'script'),
(NULL, 382, 'pjField', 3, 'title', 'Add category', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Update post', 'script'),
(NULL, 383, 'pjField', 2, 'title', 'Update post', 'script'),
(NULL, 383, 'pjField', 3, 'title', 'Update post', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Approved', 'script'),
(NULL, 384, 'pjField', 2, 'title', 'Approved', 'script'),
(NULL, 384, 'pjField', 3, 'title', 'Approved', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Not approved', 'script'),
(NULL, 385, 'pjField', 2, 'title', 'Not approved', 'script'),
(NULL, 385, 'pjField', 3, 'title', 'Not approved', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Under post', 'script'),
(NULL, 387, 'pjField', 2, 'title', 'Under post', 'script'),
(NULL, 387, 'pjField', 3, 'title', 'Under post', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 388, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 388, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Update comment', 'script'),
(NULL, 389, 'pjField', 2, 'title', 'Update comment', 'script'),
(NULL, 389, 'pjField', 3, 'title', 'Update comment', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Date time posted', 'script'),
(NULL, 390, 'pjField', 2, 'title', 'Date time posted', 'script'),
(NULL, 390, 'pjField', 3, 'title', 'Date time posted', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 391, 'pjField', 2, 'title', 'Comment', 'script'),
(NULL, 391, 'pjField', 3, 'title', 'Comment', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 392, 'pjField', 2, 'title', 'of', 'script'),
(NULL, 392, 'pjField', 3, 'title', 'of', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'votes', 'script'),
(NULL, 393, 'pjField', 2, 'title', 'votes', 'script'),
(NULL, 393, 'pjField', 3, 'title', 'votes', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 394, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 394, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Reset votes', 'script'),
(NULL, 395, 'pjField', 2, 'title', 'Reset votes', 'script'),
(NULL, 395, 'pjField', 3, 'title', 'Reset votes', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Are you sure that you want to reset votes of this post?', 'script'),
(NULL, 396, 'pjField', 2, 'title', 'Are you sure that you want to reset votes of this post?', 'script'),
(NULL, 396, 'pjField', 3, 'title', 'Are you sure that you want to reset votes of this post?', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 397, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 397, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 423, 'pjField', 2, 'title', 'Image', 'script'),
(NULL, 423, 'pjField', 3, 'title', 'Image', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 424, 'pjField', 2, 'title', 'Delete image', 'script'),
(NULL, 424, 'pjField', 3, 'title', 'Delete image', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 425, 'pjField', 2, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 425, 'pjField', 3, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Posts', 'script'),
(NULL, 426, 'pjField', 2, 'title', 'Posts', 'script'),
(NULL, 426, 'pjField', 3, 'title', 'Posts', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Post', 'script'),
(NULL, 427, 'pjField', 2, 'title', 'Post', 'script'),
(NULL, 427, 'pjField', 3, 'title', 'Post', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Authors', 'script'),
(NULL, 429, 'pjField', 2, 'title', 'Authors', 'script'),
(NULL, 429, 'pjField', 3, 'title', 'Authors', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Latest posts', 'script'),
(NULL, 430, 'pjField', 2, 'title', 'Latest posts', 'script'),
(NULL, 430, 'pjField', 3, 'title', 'Latest posts', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Latest comments', 'script'),
(NULL, 431, 'pjField', 2, 'title', 'Latest comments', 'script'),
(NULL, 431, 'pjField', 3, 'title', 'Latest comments', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Last logged in authors', 'script'),
(NULL, 432, 'pjField', 2, 'title', 'Last logged in authors', 'script'),
(NULL, 432, 'pjField', 3, 'title', 'Last logged in authors', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'There is no post found.', 'script'),
(NULL, 433, 'pjField', 2, 'title', 'There is no post found.', 'script'),
(NULL, 433, 'pjField', 3, 'title', 'There is no post found.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'There is no comment found.', 'script'),
(NULL, 434, 'pjField', 2, 'title', 'There is no comment found.', 'script'),
(NULL, 434, 'pjField', 3, 'title', 'There is no comment found.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'There is no author found.', 'script'),
(NULL, 435, 'pjField', 2, 'title', 'There is no author found.', 'script'),
(NULL, 435, 'pjField', 3, 'title', 'There is no author found.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 461, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 461, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Follow these steps to put the blog on your .php web page using PHP include code:', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'Follow these steps to put the blog on your .php web page using PHP include code:', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'Follow these steps to put the blog on your .php web page using PHP include code:', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the blog will be displayed.', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'Step 2. Copy and paste the code below into your html code, where the blog will be displayed.', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'Step 2. Copy and paste the code below into your html code, where the blog will be displayed.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Your comment has been posted and displayed in the list above.', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'Your comment has been posted and displayed in the list above.', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'Your comment has been posted and displayed in the list above.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Your comment has been posted, but it need to be confirmed before displayed', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'Your comment has been posted, but it need to be confirmed before displayed', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'Your comment has been posted, but it need to be confirmed before displayed', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 468, 'pjField', 2, 'title', 'Name is missing.', 'script'),
(NULL, 468, 'pjField', 3, 'title', 'Name is missing.', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 469, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 469, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Comment is missing.', 'script'),
(NULL, 470, 'pjField', 2, 'title', 'Comment is missing.', 'script'),
(NULL, 470, 'pjField', 3, 'title', 'Comment is missing.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'Captcha is missing.', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'Captcha is missing.', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Name cannot be blank.', 'script'),
(NULL, 472, 'pjField', 2, 'title', 'Name cannot be blank.', 'script'),
(NULL, 472, 'pjField', 3, 'title', 'Name cannot be blank.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Email cannot be blank.', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'Email cannot be blank.', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'Email cannot be blank.', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Comment cannot be blank.', 'script'),
(NULL, 474, 'pjField', 2, 'title', 'Comment cannot be blank.', 'script'),
(NULL, 474, 'pjField', 3, 'title', 'Comment cannot be blank.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Captcha cannot be blank.', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'Captcha cannot be blank.', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'Captcha cannot be blank.', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Email address is not valid.', 'script'),
(NULL, 476, 'pjField', 2, 'title', 'Email address is not valid.', 'script'),
(NULL, 476, 'pjField', 3, 'title', 'Email address is not valid.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 477, 'pjField', 2, 'title', 'Captcha is not correct.', 'script'),
(NULL, 477, 'pjField', 3, 'title', 'Captcha is not correct.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Comment contains banned words.', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'Comment contains banned words.', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'Comment contains banned words.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'New comment', 'script'),
(NULL, 479, 'pjField', 2, 'title', 'New comment', 'script'),
(NULL, 479, 'pjField', 3, 'title', 'New comment', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'There is new comment posted as followed:', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'There is new comment.', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'There is new comment.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Post', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'Post', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'Post', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 482, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Comment', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Comment', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Related', 'script'),
(NULL, 510, 'pjField', 2, 'title', 'Related', 'script'),
(NULL, 510, 'pjField', 3, 'title', 'Related', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'You already voted.', 'script'),
(NULL, 511, 'pjField', 2, 'title', 'You already voted.', 'script'),
(NULL, 511, 'pjField', 3, 'title', 'You already voted.', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Thank you for voting.', 'script'),
(NULL, 512, 'pjField', 2, 'title', 'Thank you for voting.', 'script'),
(NULL, 512, 'pjField', 3, 'title', 'Thank you for voting.', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 513, 'pjField', 2, 'title', 'of', 'script'),
(NULL, 513, 'pjField', 3, 'title', 'of', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'votes', 'script'),
(NULL, 514, 'pjField', 2, 'title', 'votes', 'script'),
(NULL, 514, 'pjField', 3, 'title', 'votes', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Continue Reading', 'script'),
(NULL, 515, 'pjField', 2, 'title', 'Continue Reading', 'script'),
(NULL, 515, 'pjField', 3, 'title', 'Continue Reading', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Load More', 'script'),
(NULL, 516, 'pjField', 2, 'title', 'Load More', 'script'),
(NULL, 516, 'pjField', 3, 'title', 'Load More', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Send to Friend', 'script'),
(NULL, 517, 'pjField', 2, 'title', 'Send to Friend', 'script'),
(NULL, 517, 'pjField', 3, 'title', 'Send to Friend', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 518, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 518, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 519, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 519, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 520, 'pjField', 2, 'title', 'Comments', 'script'),
(NULL, 520, 'pjField', 3, 'title', 'Comments', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'There is no comment found.', 'script'),
(NULL, 521, 'pjField', 2, 'title', 'There is no comment found.', 'script'),
(NULL, 521, 'pjField', 3, 'title', 'There is no comment found.', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Post A Comment', 'script'),
(NULL, 522, 'pjField', 2, 'title', 'Post A Comment', 'script'),
(NULL, 522, 'pjField', 3, 'title', 'Post A Comment', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 523, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 523, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Email address is not valid.', 'script'),
(NULL, 524, 'pjField', 2, 'title', 'Email address is not valid.', 'script'),
(NULL, 524, 'pjField', 3, 'title', 'Email address is not valid.', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 525, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 525, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Comment contains banned words.', 'script'),
(NULL, 526, 'pjField', 2, 'title', 'Comment contains banned words.', 'script'),
(NULL, 526, 'pjField', 3, 'title', 'Comment contains banned words.', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Your message is sending...', 'script'),
(NULL, 527, 'pjField', 2, 'title', 'Your message is sending...', 'script'),
(NULL, 527, 'pjField', 3, 'title', 'Your message is sending...', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Your message has been sent to your friend.', 'script'),
(NULL, 528, 'pjField', 2, 'title', 'Your message has been sent to your friend.', 'script'),
(NULL, 528, 'pjField', 3, 'title', 'Your message has been sent to your friend.', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 529, 'pjField', 2, 'title', 'Home', 'script'),
(NULL, 529, 'pjField', 3, 'title', 'Home', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 530, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 530, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 531, 'pjField', 2, 'title', 'by', 'script'),
(NULL, 531, 'pjField', 3, 'title', 'by', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'next', 'script'),
(NULL, 532, 'pjField', 2, 'title', 'next', 'script'),
(NULL, 532, 'pjField', 3, 'title', 'next', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'prev', 'script'),
(NULL, 533, 'pjField', 2, 'title', 'prev', 'script'),
(NULL, 533, 'pjField', 3, 'title', 'prev', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 534, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 534, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'in', 'script'),
(NULL, 535, 'pjField', 2, 'title', 'in', 'script'),
(NULL, 535, 'pjField', 3, 'title', 'in', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 537, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 537, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Reject links', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Reject links', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Reject links', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'If selection is ''Yes'' and any field on the comment form on the front-end ( except email field ) contains any url, that form will be considered as invalid and it will not be submitted.', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'If selection is ''Yes'' and any field on the comment form on the front-end ( except email field ) contains any url, that form will be considered as invalid and it will not be submitted.', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'If selection is ''Yes'' and any field on the comment form on the front-end ( except email field ) contains any url, that form will be considered as invalid and it will not be submitted.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Enter URL for the web page where the blog is installed:', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Enter URL for the web page where the blog is installed:', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Enter URL for the web page where the blog is installed:', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'Optional', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'Optional', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your blogs.', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your blogs.', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your blogs.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with blog is. Then copy and paste the following code into the file.', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with blog is. Then copy and paste the following code into the file.', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with blog is. Then copy and paste the following code into the file.', 'script'),
(NULL, 569, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 569, 'pjField', 2, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 569, 'pjField', 3, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Category list', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'Category list', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'Category list', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Below is the list of categories. Let click on the ''Add'' button to add new category or click on the ''Edit'' icon on the right column to edit the category name.', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Below is the list of categories. Let click on the ''Add'' button to add new category or click on the ''Edit'' icon on the right column to edit the category name.', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Below is the list of categories. Let click on the ''Add'' button to add new category or click on the ''Edit'' icon on the right column to edit the category name.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'List of authors', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'List of authors', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'List of authors', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Below is the list of authors. Let add/edit an author, then when adding a new post, you can set that post belong to which author.', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'Below is the list of authors. Let add/edit an author, then when adding a new post, you can set that post belong to which author.', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'Below is the list of authors. Let add/edit an author, then when adding a new post, you can set that post belong to which author.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Add new author', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'Add new author', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'Add new author', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Please fill out the form and click ''Save'' button to add new author.', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'Please fill out the form and click ''Save'' button to add new author.', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'Please fill out the form and click ''Save'' button to add new author.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Update author', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'Update author', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'Update author', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'You can make any change you want by modifying the content of the form below and click ''Save'' button.', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'You can make any change you want by modifying the content of the form below and click ''Save'' button.', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'You can make any change you want by modifying the content of the form below and click ''Save'' button.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Comment list', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'Comment list', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'Comment list', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Here is the list of comments. You can find out which post that each comment belong to and the created date. In order to edit a certain comment, let click on the corresponding ''Edit'' icon on the right column.', 'script'),
(NULL, 580, 'pjField', 2, 'title', 'Here is the list of comments. You can find out which post that each comment belong to and the created date. In order to edit a certain comment, let click on the corresponding ''Edit'' icon on the right column.', 'script'),
(NULL, 580, 'pjField', 3, 'title', 'Here is the list of comments. You can find out which post that each comment belong to and the created date. In order to edit a certain comment, let click on the corresponding ''Edit'' icon on the right column.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Update comment', 'script'),
(NULL, 581, 'pjField', 2, 'title', 'Update comment', 'script'),
(NULL, 581, 'pjField', 3, 'title', 'Update comment', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Let make any change on the form below and click ''Save'' button to edit the comment.', 'script'),
(NULL, 582, 'pjField', 2, 'title', 'Let make any change on the form below and click ''Save'' button to edit the comment.', 'script'),
(NULL, 582, 'pjField', 3, 'title', 'Let make any change on the form below and click ''Save'' button to edit the comment.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Post list', 'script'),
(NULL, 583, 'pjField', 2, 'title', 'Post list', 'script'),
(NULL, 583, 'pjField', 3, 'title', 'Post list', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'In the list of post, you can see the published date and the number of comments of each post.', 'script'),
(NULL, 584, 'pjField', 2, 'title', 'In the list of post, you can see the published date and the number of comments of each post.', 'script'),
(NULL, 584, 'pjField', 3, 'title', 'In the list of post, you can see the published date and the number of comments of each post.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Add new post', 'script'),
(NULL, 585, 'pjField', 2, 'title', 'Add new post', 'script'),
(NULL, 585, 'pjField', 3, 'title', 'Add new post', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Please fill out the form below and click on ''Save'' button to add new post.', 'script'),
(NULL, 586, 'pjField', 2, 'title', 'Please fill out the form below and click on ''Save'' button to add new post.', 'script'),
(NULL, 586, 'pjField', 3, 'title', 'Please fill out the form below and click on ''Save'' button to add new post.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Update post', 'script'),
(NULL, 587, 'pjField', 2, 'title', 'Update post', 'script'),
(NULL, 587, 'pjField', 3, 'title', 'Update post', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'You can make any change you want on the content of the form below to edit the information of the selected post.', 'script'),
(NULL, 588, 'pjField', 2, 'title', 'You can make any change you want on the content of the form below to edit the information of the selected post.', 'script'),
(NULL, 588, 'pjField', 3, 'title', 'You can make any change you want on the content of the form below to edit the information of the selected post.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Install settings updated', 'script'),
(NULL, 589, 'pjField', 2, 'title', 'Install settings updated', 'script'),
(NULL, 589, 'pjField', 3, 'title', 'Install settings updated', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'All changes made to the install settings have been saved.', 'script'),
(NULL, 590, 'pjField', 2, 'title', 'All changes made to the install settings have been saved.', 'script'),
(NULL, 590, 'pjField', 3, 'title', 'All changes made to the install settings have been saved.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'The field cannot include URL.', 'script'),
(NULL, 591, 'pjField', 2, 'title', 'The field cannot include URL.', 'script'),
(NULL, 591, 'pjField', 3, 'title', 'The field cannot include URL.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Name contains URL.', 'script'),
(NULL, 592, 'pjField', 2, 'title', 'Name contains URL.', 'script'),
(NULL, 592, 'pjField', 3, 'title', 'Name contains URL.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Comment contains URL.', 'script'),
(NULL, 593, 'pjField', 2, 'title', 'Comment contains URL.', 'script'),
(NULL, 593, 'pjField', 3, 'title', 'Comment contains URL.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Back to top', 'script'),
(NULL, 594, 'pjField', 2, 'title', 'Back to top', 'script'),
(NULL, 594, 'pjField', 3, 'title', 'Back to top', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 595, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 595, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'SMTP Host is not valid.', 'script'),
(NULL, 596, 'pjField', 2, 'title', 'SMTP Host is not valid.', 'script'),
(NULL, 596, 'pjField', 3, 'title', 'SMTP Host is not valid.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'We are sorry that there is no post with such ID.', 'script'),
(NULL, 597, 'pjField', 2, 'title', 'We are sorry that there is no post with such ID.', 'script'),
(NULL, 597, 'pjField', 3, 'title', 'We are sorry that there is no post with such ID.', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'No blog posts found.', 'script'),
(NULL, 598, 'pjField', 2, 'title', 'No blog posts found.', 'script'),
(NULL, 598, 'pjField', 3, 'title', 'No blog posts found.', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 599, 'pjField', 2, 'title', 'Image size too large', 'script'),
(NULL, 599, 'pjField', 3, 'title', 'Image size too large', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'New post could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 600, 'pjField', 2, 'title', 'New post could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 600, 'pjField', 3, 'title', 'New post could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 601, 'pjField', 2, 'title', 'Image size too large', 'script'),
(NULL, 601, 'pjField', 3, 'title', 'Image size too large', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'The post could not be updated successfully because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 602, 'pjField', 2, 'title', 'The post could not be updated successfully because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 602, 'pjField', 3, 'title', 'The post could not be updated successfully because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Post added without image uploaded', 'script'),
(NULL, 603, 'pjField', 2, 'title', 'Post added without image uploaded', 'script'),
(NULL, 603, 'pjField', 3, 'title', 'Post added without image uploaded', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'New post has been added, but image could not be uploaded because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 604, 'pjField', 2, 'title', 'New post has been added, but image could not be uploaded because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 604, 'pjField', 3, 'title', 'New post has been added, but image could not be uploaded because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Post updated without image uploaded', 'script'),
(NULL, 605, 'pjField', 2, 'title', 'Post updated without image uploaded', 'script'),
(NULL, 605, 'pjField', 3, 'title', 'Post updated without image uploaded', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'The post has been updated but image could not be uploaded correctly because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 606, 'pjField', 2, 'title', 'The post has been updated but image could not be uploaded correctly because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 606, 'pjField', 3, 'title', 'The post has been updated but image could not be uploaded correctly because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 607, 'pjField', '1', 'title', 'Number of related posts shown', 'script'),  
(NULL, 607, 'pjField', '2', 'title', 'Number of related posts shown', 'script'),  
(NULL, 607, 'pjField', '3', 'title', 'Number of related posts shown', 'script'),  
(NULL, 608, 'pjField', '1', 'title', 'SEO', 'script'),
(NULL, 608, 'pjField', '2', 'title', 'SEO', 'script'),
(NULL, 608, 'pjField', '3', 'title', 'SEO', 'script'),
(NULL, 609, 'pjField', '1', 'title', 'SEO settings', 'script'),
(NULL, 609, 'pjField', '2', 'title', 'SEO settings', 'script'),
(NULL, 609, 'pjField', '3', 'title', 'SEO settings', 'script'),
(NULL, 610, 'pjField', '1', 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your post details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 610, 'pjField', '2', 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your post details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 610, 'pjField', '3', 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your post details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 611, 'pjField', '1', 'title', 'Meta title', 'script'),
(NULL, 611, 'pjField', '2', 'title', 'Meta title', 'script'),
(NULL, 611, 'pjField', '3', 'title', 'Meta title', 'script'),
(NULL, 612, 'pjField', '1', 'title', 'Meta keywords', 'script'),
(NULL, 612, 'pjField', '2', 'title', 'Meta keywords', 'script'),
(NULL, 612, 'pjField', '3', 'title', 'Meta keywords', 'script'),
(NULL, 613, 'pjField', '1', 'title', 'Meta description', 'script'),
(NULL, 613, 'pjField', '2', 'title', 'Meta description', 'script'),
(NULL, 613, 'pjField', '3', 'title', 'Meta description', 'script'),
(NULL, 614, 'pjField', '1', 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 614, 'pjField', '2', 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 614, 'pjField', '3', 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 615, 'pjField', '1', 'title', 'Waiting approval', 'script'),  
(NULL, 615, 'pjField', '2', 'title', 'Waiting approval', 'script'),  
(NULL, 615, 'pjField', '3', 'title', 'Waiting approval', 'script');

INSERT INTO `stivablog_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_posts_per_page', 1, '10', NULL, 'int', 7, 1, NULL),
(1, 'o_post_order', 1, 'top|bottom::top', 'New on the top|New at the bottom', 'enum', 9, 1, NULL),
(1, 'o_allow_posting_comment', 1, 'Yes|No::Yes', NULL, 'enum', 10, 1, NULL),
(1, 'o_comment_approval', 1, 'Yes|No::Yes', NULL, 'enum', 11, 1, NULL),
(1, 'o_comment_order', 1, 'top|bottom::top', 'New on the top|New at the bottom', 'enum', 12, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 20, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 21, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 22, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 23, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 24, 1, NULL),
(1, 'o_layout', 2, 'layout_1|layout_2|layout_3::layout_1', 'Layout 1|Layout 2|Layout 3', 'enum', 1, 1, NULL),
(1, 'o_show_category', 2, 'Yes|No::Yes', NULL, 'enum', 2, 1, NULL),
(1, 'o_show_rating', 2, 'Yes|No::Yes', NULL, 'enum', 4, 1, NULL),
(1, 'o_limit_vote', 2, 'No|Cookie|IP::No', 'No|Cookie|IP address', 'enum', 5, 1, NULL),
(1, 'o_send_to_friend', 2, 'Yes|No::Yes', NULL, 'enum', 6, 1, NULL),
(1, 'o_banned_words', 3, NULL, NULL, 'text', 1, 1, NULL),
(1, 'o_reject_links', 3, 'Yes|No::No', NULL, 'enum', 2, 1, NULL),
(1, 'o_blog_page', 99, '', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_related_posts_shown', 1, '4', NULL, 'int', 13, 1, NULL);

INSERT INTO `stivablog_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'author', 'T');