<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminOptions extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionAddOns()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionProtection()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionNotification()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['notification_update']))
			{
				$pjOptionModel = pjOptionModel::factory();
				
				$pjOptionModel
					->reset()
					->where('foreign_id', $this->getForeignId())
					->where('`key`', 'o_notify_subject')
					->limit(1)
					->modifyAll(array('value' => $_POST['o_notifiy_subject']));
				$pjOptionModel
					->reset()
					->where('foreign_id', $this->getForeignId())
					->where('`key`', 'o_notify_message')
					->limit(1)
					->modifyAll(array('value' => $_POST['o_notify_message']));
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminOptions&action=pjActionNotification&err=AN01");
			}else{
				$arr = pjOptionModel::factory()
					->where('t1.foreign_id', $this->getForeignId())
					->orderBy('t1.order ASC')
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminOptions.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSeo()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			if (isset($_POST['seo_update']))
			{
				$pjOptionModel = pjOptionModel::factory();
	
				$pjOptionModel
					->reset()
					->where('foreign_id', $this->getForeignId())
					->where('`key`', 'o_meta_title')
					->limit(1)
					->modifyAll(array('value' => $_POST['o_meta_title']));
				$pjOptionModel
					->reset()
					->where('foreign_id', $this->getForeignId())
					->where('`key`', 'o_meta_keywords')
					->limit(1)
					->modifyAll(array('value' => $_POST['o_meta_keywords']));
				$pjOptionModel
					->reset()
					->where('foreign_id', $this->getForeignId())
					->where('`key`', 'o_meta_description')
					->limit(1)
					->modifyAll(array('value' => $_POST['o_meta_description']));
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminOptions&action=pjActionSeo&err=AS01");
			}else{
				$arr = pjOptionModel::factory()
					->where('t1.foreign_id', $this->getForeignId())
					->orderBy('t1.order ASC')
					->findAll()
					->getData();
	
				$this->set('arr', $arr);
	
				$this->appendJs('pjAdminOptions.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['options_update']))
			{
				$OptionModel = new pjOptionModel();
			
				foreach ($_POST as $key => $value)
				{
					if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
					{
						list(, $type, $k) = explode("-", $key);
						if (!empty($k))
						{
							$OptionModel
								->reset()
								->where('foreign_id', $this->getForeignId())
								->where('`key`', $k)
								->limit(1)
								->modifyAll(array('value' => $value));
						}
					}
				}
				
				if (isset($_POST['next_action']))
				{
					switch ($_POST['next_action'])
					{
						case 'pjActionIndex':
							$err = 'AO01';
							break;
						case 'pjActionAddOns':
							$err = 'AO02';
							break;
						case 'pjActionProtection':
							$err = 'AO03';
							break;
						case 'pjActionInstall':
							$err = 'AO04';
							break;
					}
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOptions&action=" . @$_POST['next_action'] . "&err=$err");
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionInstall()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->set('o_arr', $this->models['Option']
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.key ASC')
				->findAll()
				->getData()
			);
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPreview()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdateTheme()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjOptionModel::factory()
				->where('foreign_id', $this->getForeignId())
				->where('`key`', 'o_theme')
				->limit(1)
				->modifyAll(array('value' => 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme' . $_GET['theme']));
	
		}
	}
}
?>