<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminPosts extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isAuthor())
		{
			$this->set('author_arr', pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData());
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminPosts.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetPost()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjPostModel = pjPostModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjPostModel->where('t1.title LIKE', "%$q%");
				$pjPostModel->orWhere('t1.body LIKE', "%$q%");
			}
			if (isset($_GET['title']) && !empty($_GET['title']))
			{
				$title = pjObject::escapeString($_GET['title']);
				$pjPostModel->where('t1.title LIKE', "%$title%");
			}
			if (isset($_GET['blog_text']) && !empty($_GET['blog_text']))
			{
				$blog_text = pjObject::escapeString($_GET['blog_text']);
				$pjPostModel->where('t1.body LIKE', "%$blog_text%");
			}
			if ($this->isAuthor()){
				$pjPostModel->where('t1.author_id', $this->getUserId());
			}
			if (isset($_GET['author_id']) && (int) $_GET['author_id'] > 0)
			{
				$pjPostModel->where('t1.author_id', $_GET['author_id']);
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjPostModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['date_from']) && !empty($_GET['date_from']) && isset($_GET['date_to']) && !empty($_GET['date_to']))
			{
				$df = pjUtil::formatDate($_GET['date_from'], $this->option_arr['o_date_format']);
				$dt = pjUtil::formatDate($_GET['date_to'], $this->option_arr['o_date_format']);
				$pjPostModel->where("(t1.published_date BETWEEN '$df' AND '$dt')");
			
			} else {
				if (isset($_GET['date_from']) && !empty($_GET['date_from']))
				{
					$df = pjUtil::formatDate($_GET['date_from'], $this->option_arr['o_date_format']);
					$pjPostModel->where("(t1.published_date >= '$df')");
				} elseif (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
					$dt = pjUtil::formatDate($_GET['date_to'], $this->option_arr['o_date_format']);
					$pjPostModel->where("(t1.published_date <= '$dt')");
				}
			}
				
			$column = 'published_date';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjPostModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			$arr = $pjPostModel->select('t1.*, (SELECT COUNT(TC.post_id) FROM `'.pjCommentModel::factory()->getTable().'` AS TC WHERE t1.id = TC.post_id) AS `cnt_comments`')
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();

			foreach($arr as $k => $v){
				$v['published_date'] = pjUtil::formatDate(date('Y-m-d', strtotime($v['published_date'])), 'Y-m-d', $this->option_arr['o_date_format']);
				$data[$k] = $v;
			}	
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isAuthor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminPosts&action=pjActionIndex&err=AP05");
			}
			if (isset($_POST['post_create']))
			{
				$pjPostModel = pjPostModel::factory();
				$data = array();
				if($this->isAuthor()){
					$data['author_id'] = $this->getUserId();
				}
				$id = $pjPostModel->setAttributes(array_merge($data, $_POST))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					if (isset($_FILES['image']))
					{
						if($_FILES['image']['error'] == 0)
						{
							$data = array();
							
							$Image = new pjImage();
							if ($Image->getErrorCode() !== 200)
							{
								$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
								if ($Image->load($_FILES['image']))
								{
									$resp = $Image->isConvertPossible();
									if ($resp['status'] === true)
									{
										$hash = md5(uniqid(rand(), true));
										$source_path = PJ_UPLOAD_PATH . 'source/' . $id . '_' . $hash . '.' . $Image->getExtension();
										$thumb_path = PJ_UPLOAD_PATH . 'thumb/' . $id . '_' . $hash . '.' . $Image->getExtension();
										$medium_path = PJ_UPLOAD_PATH . 'medium/' . $id . '_' . $hash . '.' . $Image->getExtension();
										if ($Image->save($source_path))
										{
											$small_size = explode(",", preg_replace('/\s+/', '', PJ_IMAGE_SMALL));
											$medium_size = explode(",", preg_replace('/\s+/', '', PJ_IMAGE_MEDIUM));
											
											$Image->loadImage($source_path);
											$Image->resizeSmart($small_size[0], $small_size[1]);
											$Image->saveImage($thumb_path);
											
											$Image->loadImage($source_path);
											$Image->resizeSmart($medium_size[0], $medium_size[1]);
											$Image->saveImage($medium_path);
											
											$data['source_path'] = $source_path;
											$data['medium_path'] = $medium_path;
											$data['thumb_path'] = $thumb_path;
											$data['image_name'] = $_FILES['image']['name'];
											$pjPostModel->reset()->where('id', $id)->limit(1)->modifyAll($data);
										}
									}
								}
							}
						}else if($_FILES['image']['error'] != 4){
							pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminPosts&action=pjActionUpdate&id=$id&err=AP09");
						}
						$err = 'AP03';
					}else{
						$err = 'AP03';
					}
				} else {
					$err = 'AP04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminPosts&action=pjActionIndex&err=$err");
			} else {
							
				$this->set('category_arr', pjCategoryModel::factory()->orderBy('t1.category ASC')->findAll()->getData());
				$this->set('author_arr', pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData());
		
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminPosts.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isAuthor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminPosts&action=pjActionIndex&err=AP06");
			}
			if (isset($_POST['post_update']))
			{
				$err = 'AP01';
				
				$pjPostModel = pjPostModel::factory();
				$data = array();
				$data['modified'] = date('Y-m-d H:i:s');
				$data['published_date'] = pjUtil::formatDate($_POST['published_date'], $this->option_arr['o_date_format']);
				
				if (isset($_FILES['image']))
				{
					if($_FILES['image']['error'] == 0)
					{
						$arr = $pjPostModel->find($_POST['id'])->getData();
						if(!empty($arr['source_path'])){
							$source_path = PJ_INSTALL_PATH . $arr['source_path'];
							$medium_path = PJ_INSTALL_PATH . $arr['medium_path'];
							$thumb_path = PJ_INSTALL_PATH . $arr['thumb_path'];
							@unlink($source_path);
							@unlink($medium_path);
							@unlink($thumb_path);
						}
							
						$Image = new pjImage();
						if ($Image->getErrorCode() !== 200)
						{
							$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
							if ($Image->load($_FILES['image']))
							{
								$resp = $Image->isConvertPossible();
								if ($resp['status'] === true)
								{
									$hash = md5(uniqid(rand(), true));
									$source_path = PJ_UPLOAD_PATH . 'source/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
									$medium_path = PJ_UPLOAD_PATH . 'medium/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
									$thumb_path = PJ_UPLOAD_PATH . 'thumb/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
									if ($Image->save($source_path))
									{
										$small_size = explode(",", preg_replace('/\s+/', '', PJ_IMAGE_SMALL));
										$medium_size = explode(",", preg_replace('/\s+/', '', PJ_IMAGE_MEDIUM));
										
										$Image->loadImage($source_path);
										$Image->resizeSmart($small_size[0], $small_size[1]);
										$Image->saveImage($thumb_path);
										
										$Image->loadImage($source_path);
										$Image->resizeSmart($medium_size[0], $medium_size[1]);
										$Image->saveImage($medium_path);
										
										$data['source_path'] = $source_path;
										$data['medium_path'] = $medium_path;
										$data['thumb_path'] = $thumb_path;
										$data['image_name'] = $_FILES['image']['name'];
									}
								}
							}
						}
					}else if($_FILES['image']['error'] != 4){
						pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminPosts&action=pjActionUpdate&id=".$_POST['id']."&tab_id=" . $_POST['tab_id']."&err=AP10");
					}
				}
				$pjPostModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminPosts&action=pjActionUpdate&id=".$_POST['id']."&tab_id=" . $_POST['tab_id']."&err=$err");
			} else {
				$vote_table = pjVoteModel::factory()->getTable();
				$arr = pjPostModel::factory()
					->select("t1.*, (SELECT COUNT(TV1.id) FROM `$vote_table` AS TV1 WHERE `TV1`.`post_id` = `t1`.`id` LIMIT 1) AS `cnt`,
									(SELECT SUM(TV2.vote_rate)/COUNT(TV2.id) FROM `$vote_table` AS TV2 WHERE `TV2`.`post_id` = `t1`.`id` LIMIT 1) AS `avg_rate`,
									(SELECT COUNT(TC.post_id) FROM `".pjCommentModel::factory()->getTable()."` AS TC WHERE t1.id = TC.post_id) AS `cnt_comments`
							")
					->find($_GET['id'])
					->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminPosts&action=pjActionIndex&err=AP08");
				}
				
				$can_update = true;
				if($this->isAuthor() && $arr['author_id'] != $this->getUserId())
				{
					$can_update = false;
				}
				if($can_update == true)
				{
					$this->set('arr', $arr);
					
					$this->set('category_arr', pjCategoryModel::factory()->orderBy('t1.category ASC')->findAll()->getData());
					$this->set('author_arr', pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData());
					
					$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
					
					$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
					$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
					$this->appendJs('jquery.ui.stars.min.js', PJ_THIRD_PARTY_PATH . 'jstarring/');
					$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
					$this->appendJs('pjAdminPosts.js');
				}else{
					$this->set('status', 2);
				}
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionResetVote()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isAuthor())
		{
			pjVoteModel::factory()->where('post_id', $_GET['id'])->eraseAll();
			pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminPosts&action=pjActionUpdate&id=" . $_GET['id']);
		} else {
			$this->set('status', 2);
		}
		exit;
	}
	
	public function pjActionStatusPost()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjPostModel::factory()->whereIn('id', $_POST['record'])->modifyAll(array(
					'status' => ":IF(`status`='F','T','F')"
				));
			}
		}
		exit;
	}
	
	public function pjActionSavePost()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($_POST['value'] != ''){
				pjPostModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionExportPost()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjPostModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Posts-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionDeletePost()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjPostModel = pjPostModel::factory();
			$arr = $pjPostModel->find($_GET['id'])->getData();
			if ($pjPostModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				if(!empty($arr['source_path'])){
					$source_path = PJ_INSTALL_PATH . $arr['source_path'];
					$medium_path = PJ_INSTALL_PATH . $arr['medium_path'];
					$thumb_path = PJ_INSTALL_PATH . $arr['thumb_path'];
					@unlink($source_path);
					@unlink($medium_path);
					@unlink($thumb_path);
				}
				pjCommentModel::factory()->where('post_id', $_GET['id'])->eraseAll();
				pjVoteModel::factory()->where('post_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeletePostBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjPostModel = pjPostModel::factory();
				$arr = $pjPostModel->whereIn('id', $_POST['record'])->getData();
				foreach($arr as $v){
					if(!empty($v['source_path'])){
						$source_path = PJ_INSTALL_PATH . $v['source_path'];
						$medium_path = PJ_INSTALL_PATH . $v['medium_path'];
						$thumb_path = PJ_INSTALL_PATH . $v['thumb_path'];
						@unlink($source_path);
						@unlink($medium_path);
						@unlink($thumb_path);
					}
				}
				$pjPostModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjCommentModel::factory()->whereIn('post_id', $_POST['record'])->eraseAll();
				pjVoteModel::factory()->whereIn('post_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionDeleteImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$pjPostModel = pjPostModel::factory();
			$arr = $pjPostModel->find($_GET['id'])->getData(); 
			
			if(!empty($arr)){
				if(!empty($arr['source_path'])){
					$source_path = PJ_INSTALL_PATH . $arr['source_path'];
					$medium_path = PJ_INSTALL_PATH . $arr['medium_path'];
					$thumb_path = PJ_INSTALL_PATH . $arr['thumb_path'];
					@unlink($source_path);
					@unlink($medium_path);
					@unlink($thumb_path);
				}
				
				$data = array();
				$data['source_path'] = ':NULL';
				$data['medium_path'] = ':NULL';
				$data['thumb_path'] = ':NULL';
				$data['image_name'] = ':NULL';
				$pjPostModel->reset()->where(array('id' => $_GET['id']))->limit(1)->modifyAll($data);
				
				$response['code'] = 200;
			}else{
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionExport()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			if(isset($_POST['posts_export']))
			{
				$pjPostModel = pjPostModel::factory()
					->select('t1.*, t2.category AS category_title, t3.name AS author_name')
					->join('pjCategory', 't1.category_id=t2.id', 'left outer')
					->join('pjUser', 't1.author_id=t3.id', 'left outer');
	
				$column = 'published_date';
				$direction = 'ASC';
				$where_str = pjUtil::getMadeWhere($_POST['made_period'], $this->option_arr['o_week_start']);
				if($where_str != '')
				{
					$pjPostModel->where($where_str);
				}
	
				$arr= $pjPostModel
					->orderBy("$column $direction")
					->findAll()
					->getData();
				if($_POST['type'] == 'file')
				{
					$this->setLayout('pjActionEmpty');
	
					$xml = new pjXML();
					$xml
						->setEncoding('UTF-8')
						->setName("Export-".time().".xml")
						->process($arr)
						->download();
					exit;
				}else{
					$pjPasswordModel = pjPasswordModel::factory();
					$password = md5($_POST['password'].PJ_SALT);
					$arr = $pjPasswordModel
						->where("t1.password", $password)
						->limit(1)
						->findAll()
						->getData();
					if (count($arr) != 1)
					{
						$pjPasswordModel->setAttributes(array('password' => $password))->insert();
					}
					$this->set('password', $password);
				}
			}
				
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminPosts.js');
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionExportFeed()
	{
		$this->setLayout('pjActionEmpty');
		$access = true;
		if(isset($_GET['p']))
		{
			$pjPasswordModel = pjPasswordModel::factory();
			$arr = $pjPasswordModel
				->where('t1.password', $_GET['p'])
				->limit(1)
				->findAll()
				->getData();
			if (count($arr) != 1)
			{
				$access = false;
			}
		}
		if($access == true)
		{
			$arr = $this->pjGetFeedData($_GET);
				
			if(!empty($arr))
			{
				$xml = new pjXML();
				echo $xml
				->setEncoding('UTF-8')
				->process($arr)
				->getData();
			}
		}else{
			__('lblNoAccessToFeed');
		}
		exit;
	}
	public function pjGetFeedData($get)
	{
		$arr = array();
		$status = true;
		$period = '';
		if(isset($get['period']))
		{
			if(!ctype_digit($get['period']))
			{
				$status = false;
			}else{
				$period = $get['period'];
			}
		}else{
			$status = false;
		}
		if($status == true && $period != '')
		{
			$pjPostModel = pjPostModel::factory()
				->select('t1.*, t2.category AS category_title, t3.name AS author_name')
				->join('pjCategory', 't1.category_id=t2.id', 'left outer')
				->join('pjUser', 't1.author_id=t3.id', 'left outer');
			$column = 'published_date';
			$direction = 'ASC';
			$where_str = pjUtil::getMadeWhere($period, $this->option_arr['o_week_start']);
			if($where_str != '')
			{
				$pjPostModel->where($where_str);
			}
			$arr= $pjPostModel
				->orderBy("$column $direction")
				->findAll()
				->getData();
		}
		return $arr;
	}
}
?>