<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	public $defaultSendCaptcha = 'StivaSoftSendCaptcha';
	public $defaultLocale = 'front_locale_id';
	public $defaultStatus = 'front_view_status';
	public $defaultTheme = 'front_theme_id';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}

	public function afterFilter()
	{		
		$theme = $this->option_arr['o_theme'];
		if(isset($_SESSION[$this->defaultTheme]))
		{
			$theme = $_SESSION[$this->defaultTheme];
		}
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('style.css', PJ_CSS_PATH);
		$this->appendCss($theme . '.css', PJ_CSS_PATH . 'fonts/');
		$this->appendCss($theme . '.css', PJ_CSS_PATH . 'themes/');
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		if(isset($_GET['theme']))
		{
			$theme = pjObject::escapeString($_GET['theme']);
			if(!empty($theme))
			{
				$_SESSION[$this->defaultTheme] = $theme;
			}
		}
		$this->loadSetFields();
		
		$pjPostModel = pjPostModel::factory();
		if(isset($_GET['category_id']) && (int) $_GET['category_id'] > 0)
		{
			$pjPostModel->where('t1.category_id', (int) $_GET['category_id']);
		}
		$current_year_arr = $pjPostModel
			->select("YEAR(published_date) AS pub_year, MONTH(published_date) AS pub_month, COUNT(t1.id) AS cnt_posts")
			->where("YEAR(published_date) = YEAR(CURDATE())")
			->groupBy("YEAR(published_date), MONTH(published_date)")
			->orderBy("pub_year DESC, pub_month DESC")
			->findAll()
			->getData();
		
		$pjPostModel->reset();
		if(isset($_GET['category_id']) && (int) $_GET['category_id'] > 0)
		{
			$pjPostModel->where('t1.category_id', (int) $_GET['category_id']);
		}
		$past_year_arr = $pjPostModel
			->select("YEAR(published_date) AS pub_year, COUNT(t1.id) AS cnt_posts")
			->where("YEAR(published_date) < YEAR(CURDATE())")
			->groupBy("YEAR(published_date)")
			->orderBy("pub_year DESC")
			->findAll()
			->getData();
		
		$category_arr = pjCategoryModel::factory()
			->select("t1.*, (SELECT COUNT(`TP`.id) FROM `".$pjPostModel->getTable()."` AS `TP` WHERE `TP`.category_id=t1.id) AS cnt_posts")
			->where('status', 'T')
			->findAll()
			->getData();
		
		$this->set('current_year_arr', $current_year_arr);
		$this->set('past_year_arr', $past_year_arr);
		$this->set('category_arr', $category_arr);
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		
		header("Cache-Control: max-age=3600, private");
		
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}
	public function pjActionCaptchaSend()
	{
		$this->setAjax(true);
		
		header("Cache-Control: max-age=3600, private");
		
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultSendCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
				
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	public function pjActionCheckSendCaptcha()
	{
		$this->setAjax(true);
				
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultSendCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
}
?>