<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
				
		$bodies_text = str_replace("{SIZE}", ini_get('upload_max_filesize'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
		
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminPosts&amp;action=pjActionUpdate" method="post" id="frmUpdatePost" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="post_update" value="1" />
		<input type="hidden" name="id" value="<?php echo (int) $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('lblPost'); ?></a></li>
				<li><a href="#tabs-2"><?php __('lblSeo'); ?></a></li>
			</ul>
		
			<div id="tabs-1">
				<?php
				pjUtil::printNotice(__('infoUpdatePostTitle', true, false), __('infoUpdatePostBody', true, false)); 
				?>
				<div class="float_left w500">
					<p>
						<label class="title110"><?php __('lblCategory'); ?></label>
						<span class="inline_block">
							<?php
							if(!empty($tpl['category_arr']))
							{ 
								?>
								<select name="category_id" id="category_id" class="pj-form-field w300">
									<option value="0">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['category_arr'] as $v)
									{
										?><option value="<?php echo $v['id']; ?>" <?php echo $v['id'] == $tpl['arr']['category_id'] ? 'selected="selected"' : null; ?>><?php echo stripslashes($v['category']); ?></option><?php
									}
									?>
								</select>
								<?php
							}else{
								?><label class="block t5"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCategories&amp;action=pjActionCreate"><?php __('lblAddCategory', false, true);?></a></label><?php
							} 
							?>
						</span>
					</p>
				</div>
				<div class="float_right">
					<p>
						<?php
						if((int) $tpl['arr']['cnt_comments'] > 0)
						{ 
							?>
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminComments&amp;action=pjActionIndex&amp;post_id=<?php echo (int) $tpl['arr']['id']; ?>"><?php echo $tpl['arr']['cnt_comments'];?> <?php $tpl['arr']['cnt_comments'] != 1 ? __('lblPluralComments') : __('lblSingularComment');?></a>
							<?php
						} 
						?>
					</p>
				</div>
				<div class="clear_both"></div>
				<p>
					<label class="title110"><?php __('lblDatePublished'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="published_date" id="published_date" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($tpl['arr']['published_date'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</p>
				<?php
				if($controller->isAdmin())
				{ 
					?>
					<p>
						<label class="title110"><?php __('lblAuthor'); ?></label>
						<span class="inline_block">
							<select name="author_id" id="author_id" class="pj-form-field w300 required">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['author_arr'] as $v)
								{
									?><option value="<?php echo $v['id']; ?>" <?php echo $v['id'] == $tpl['arr']['author_id'] ? 'selected="selected"' : null; ?>><?php echo stripslashes($v['name']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title110"><?php __('lblTitle', false, true); ?></label>
					<span class="inline_block">
						<input type="text" name="title" id="title" class="pj-form-field required w400 float_left r10" maxlength="200" value="<?php echo stripslashes($tpl['arr']['title']);?>" />
						<span class="post-rating">
							<select name="rate">
								<?php
								$avg = floor($tpl['arr']['avg_rate']);
								for ($j=1; $j<=5; $j++) {
									?>
									<option value="<?php echo $j;?>" <?php echo ($avg == $j) ? 'selected="selected"' : '';?>><?php echo $j;?></option>
									<?php
								}
								?>
							</select>
							<span id="star_message_<?php echo intval($tpl['arr']['id']);?>"><?php echo round($tpl['arr']['avg_rate'], 2);?> <?php __('lblOf', false, true);?> <?php echo intval($tpl['arr']['cnt']);?> <?php __('lblVotes', false, true);?></span>
							<span class="clear"></span>
						</span>
						<a id="rating_reset" class="rating-reset" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminPosts&amp;action=pjActionResetVote&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblReset', false, true);?></a>
					</span>
				</p>
				<p>
					<label class="title110"><?php __('lblBody'); ?></label>
					<span class="inline_block">
						<textarea id="body" name="body" class="mceEditor" style="width: 600px; height: 250px"><?php echo stripslashes($tpl['arr']['body']);?></textarea>
					</span>
				</p>
				<p>
					<label class="title110"><?php __('lblImage', false, true); ?></label>
					<span class="inline_block">
						<input type="file" name="image" id="image" class="pj-form-field w300"/>
					</span>
				</p>
				<?php
				if(!empty($tpl['arr']['source_path'])){
					$thumb_url = PJ_INSTALL_URL . $tpl['arr']['thumb_path'];
					?>
					<p id="image_container">
						<label class="title110">&nbsp;</label>
						<span class="inline_block">
							<img src="<?php echo $thumb_url; ?>" />
							<a class="delete-image" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminPosts&amp;action=pjActionDeleteImage&id=<?php echo $tpl['arr']['id'];?>"><?php __('lblDelete', false, true); ?></a>
						</span>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title110"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $k == $tpl['arr']['status'] ? 'selected="selected"' : null; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title110">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminPosts&action=pjActionIndex';" />
				</p>
			</div>
			<div id="tabs-2">
				<?php
				pjUtil::printNotice(__('infoUpdateSEOTitle', true, false), __('infoUpdateSEOBody', true, false)); 
				?>
				<p>
					<label class="title"><?php __('lblMetaTitle'); ?></label>
					<span class="inline_block">
						<input type="text" id="meta_title" name="meta_title" class="pj-form-field w500" value="<?php echo stripslashes($tpl['arr']['meta_title']); ?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblMetaKeywords'); ?></label>
					<span class="inline_block">
						<input type="text" id="meta_keywords" name="meta_keywords" class="pj-form-field w500" value="<?php echo stripslashes($tpl['arr']['meta_keywords']); ?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblMetaDescription'); ?></label>
					<span class="inline_block">
						<textarea id="meta_description" name="meta_description" class="pj-form-field w500 h150"><?php echo stripslashes($tpl['arr']['meta_description']); ?></textarea>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminPosts&action=pjActionIndex';" />
				</p>
			</div>
		</div>
	</form>
	<div id="dialogReset" style="display: none" title="<?php __('lblResetVotes');?>"><?php __('lblResetConfirmation');?></div>
	<div id="dialogDeleteImage" style="display: none" title="<?php __('lblDeleteImage');?>"><?php __('lblDeleteConfirmation');?></div>
	<div id="delete_url" style="display: none"></div>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('lblFieldRequired', false, true); ?>";
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>